# Contributing to liblrs

All contributions, bug reports, bug fixes, documentation improvements, enhancements, and ideas are welcome.

Check out our community's [Code of Conduct](https://github.com/OpenRailAssociation/liblrs/blob/main/CODE_OF_CONDUCT.md) and feel free to say hi on [matrix](https://matrix.to/#/#liblrs:osrd.fr) if you'd like. It's a nice place to chat about libLRS development, ask questions, and get to know the other contributors and users in a less formal setting.

## Getting oriented

The libLRS project has only one repo, but with subproject for the bindings:

1. [`rust`](https://github.com/OpenRailAssociation/liblrs/tree/main/src): the core of the library.
2. [`python`](https://github.com/OpenRailAssociation/liblrs/tree/main/python): the python bindings (using [`pyO2`](https://pyo3.rs/)).
3. [`wasm`](https://github.com/OpenRailAssociation/liblrs/tree/main/wasm): the javascript bindings (using [`wasm-bindgen`](https://github.com/OpenRailAssociation/liblrs/tree/main/wasm)).

## What we are trying to build

Our goal is to be the reference library for all linear referencing needs.

That is why we highly encourage to test, challenge the implementation and contribute to this project. Any input of your needs is also a contribution.

Don’t hesitate to open an issue or a pull request to improve this library. Sharing your usecases will also be very beneficial. 
