# This file is automatically generated by pyo3_stub_gen
# ruff: noqa: E501, F401

import builtins
import os
import pathlib
import typing

@typing.final
class Anchor:
    r"""
    An `Anchor` is a reference point for a given [`Curve`].
    It can be a milestone, a bridge…
    """
    @property
    def name(self) -> builtins.str:
        r"""
        `name` of the [`Anchor`].
        """
    @name.setter
    def name(self, value: builtins.str) -> None:
        r"""
        `name` of the [`Anchor`].
        """
    @property
    def position(self) -> typing.Optional[Point]:
        r"""
        Projected position on the [`Curve`] (the reference point isn’t always on the curve).
        """
    @position.setter
    def position(self, value: typing.Optional[Point]) -> None:
        r"""
        Projected position on the [`Curve`] (the reference point isn’t always on the curve).
        """
    @property
    def curve_position(self) -> builtins.float:
        r"""
        Position on the [`Curve`].
        """
    @curve_position.setter
    def curve_position(self, value: builtins.float) -> None:
        r"""
        Position on the [`Curve`].
        """
    @property
    def scale_position(self) -> builtins.float:
        r"""
        Position on the scale.
        """
    @scale_position.setter
    def scale_position(self, value: builtins.float) -> None:
        r"""
        Position on the scale.
        """

@typing.final
class AnchorOnLrm:
    r"""
    The linear position of an anchor doesn’t always match the measured distance
    For example if a road was transformed into a bypass, resulting in a longer road,
    but measurements are kept the same
    The start of the curve might also be different from the `0` of the LRM
    """
    @property
    def anchor_index(self) -> builtins.int:
        r"""
        Index of the considered anchor. Use the value returned by [`Builder::add_anchor`]
        """
    @anchor_index.setter
    def anchor_index(self, value: builtins.int) -> None:
        r"""
        Index of the considered anchor. Use the value returned by [`Builder::add_anchor`]
        """
    @property
    def distance_along_lrm(self) -> builtins.float:
        r"""
        The distance from the start of the LRM.
        It can be different from the measured distance
        """
    @distance_along_lrm.setter
    def distance_along_lrm(self, value: builtins.float) -> None:
        r"""
        The distance from the start of the LRM.
        It can be different from the measured distance
        """
    def __new__(cls, anchor_index: builtins.int, distance_along_lrm: builtins.float) -> AnchorOnLrm: ...
    def __repr__(self) -> builtins.str: ...

@typing.final
class Builder:
    def __new__(cls) -> Builder:
        r"""
        Instantiate a new builder
        """
    def add_node(self, id: builtins.str, coord: Point, properties: typing.Mapping[builtins.str, builtins.str]) -> builtins.int:
        r"""
        Add a new topological node (e.g. a railway switch)
        """
    def add_anchor(self, id: builtins.str, coord: Point, properties: typing.Mapping[builtins.str, builtins.str], name: typing.Optional[builtins.str] = None) -> builtins.int:
        r"""
        Add a new anchor by its coordinates
        """
    def add_projected_anchor(self, id: builtins.str, position_on_curve: builtins.float, properties: typing.Mapping[builtins.str, builtins.str], name: typing.Optional[builtins.str] = None) -> builtins.int:
        r"""
        Add a new anchor by its position along the curve
        """
    def add_segment(self, id: builtins.str, geometry: typing.Sequence[Point], start_node_index: builtins.int, end_node_index: builtins.int) -> builtins.int:
        r"""
        Add a new segment
        
        The geometry represents the curve
        start_node_index and end_node_index are the topological extremities returned by `add_node`
        """
    def add_traversal(self, traversal_id: builtins.str, segments: typing.Sequence[SegmentOfTraversal]) -> builtins.int:
        r"""
        Add a traversal
        
        segments represent the curve of the traversal
        """
    def add_lrm(self, id: builtins.str, traversal_index: builtins.int, anchors: typing.Sequence[AnchorOnLrm], properties: typing.Mapping[builtins.str, builtins.str]) -> None:
        r"""
        Add a linear referencing model
        
        It is composed by the traversal identified by traversal_index (that represents the curve)
        and the anchors (that represent the milestones)
        """
    def get_traversal_indexes(self) -> builtins.dict[builtins.str, builtins.int]:
        r"""
        List all the traversals by their id and index
        """
    def read_from_osm(self, input_osm_file: builtins.str | os.PathLike | pathlib.Path, lrm_tag: builtins.str, required: typing.Sequence[tuple[builtins.str, builtins.str]], to_reject: typing.Sequence[tuple[builtins.str, builtins.str]]) -> None:
        r"""
        Read the topology from an OpenStreetMap source
        
        It reads the nodes, segments and traversals.
        """
    def save(self, out_file: builtins.str | os.PathLike | pathlib.Path, properties: typing.Mapping[builtins.str, builtins.str]) -> None:
        r"""
        Save the lrs to a file
        """
    def build_lrs(self, properties: typing.Mapping[builtins.str, builtins.str]) -> Lrs:
        r"""
        Builds the lrs to be used directly
        """
    def euclidean_distance(self, lrm_index_a: builtins.int, lrm_index_b: builtins.int) -> builtins.float:
        r"""
        Compute the euclidean distance between two lrms
        """
    def get_nodes_of_traversal(self, lrm_index: builtins.int) -> builtins.list[builtins.int]:
        r"""
        List all the node indices of a traversal
        """
    def get_node_coord(self, node_index: builtins.int) -> Point:
        r"""
        Get the coordinates of a node identified by its index
        """
    def get_node_id(self, node_index: builtins.int) -> builtins.str:
        r"""
        Get the coordinates of a node identified by its index
        """
    def project(self, lrm_index: builtins.int, point: Point) -> typing.Optional[builtins.float]:
        r"""
        Project a point on a the curve of an lrm
        
        Return a value between 0 and 1, both included
        Return None if the curve of the traversal is not defined
        """
    def reverse(self, lrm_index: builtins.int) -> None:
        r"""
        Reverse the orientation of the lrm
        
        If it is composed by the segments (a, b)-(b, c) it will be (c, b)-(b, a)
        """
    def orient_along_points(self, traversal_index: builtins.int, first_point: Point, last_point: Point) -> None:
        r"""
        Orient the traversal according to two points
        
        In the end, the first coordinate must be closer to the beginning than the second
        If both points are so far from the curve that they are projected to a end, we consider the offset to the curve
        """

@typing.final
class LrmProjection:
    r"""
    The result of a projection onto an [`LrmScale`].
    """
    @property
    def lrm_handle(self) -> builtins.int:
        r"""
        Handle of the [`Lrm`] where this measurement applies to
        """
    @lrm_handle.setter
    def lrm_handle(self, value: builtins.int) -> None:
        r"""
        Handle of the [`Lrm`] where this measurement applies to
        """
    @property
    def measure(self) -> LrmScaleMeasure:
        r"""
        Contains `measure` ([`LrmScaleMeasure`]) and `lrm` ([`LrmHandle`]).
        """
    @measure.setter
    def measure(self, value: LrmScaleMeasure) -> None:
        r"""
        Contains `measure` ([`LrmScaleMeasure`]) and `lrm` ([`LrmHandle`]).
        """
    @property
    def orthogonal_offset(self) -> builtins.float:
        r"""
        How far from the [`Lrm`] is the [`Point`] that has been projected.
        """
    @orthogonal_offset.setter
    def orthogonal_offset(self, value: builtins.float) -> None:
        r"""
        How far from the [`Lrm`] is the [`Point`] that has been projected.
        """

@typing.final
class LrmScaleMeasure:
    r"""
    Represent a position on an [`LrmScale`] relative as an `offset` to an [`Anchor`].
    """
    def __new__(cls, anchor_name: builtins.str, scale_offset: builtins.float) -> LrmScaleMeasure:
        r"""
        Build a new [`LrmMeasure`] from an [`Anchor`] `name` and the `offset` on the [`LrmScale`].
        """
    def __repr__(self) -> builtins.str: ...

@typing.final
class Lrs:
    r"""
    Holds the whole Linear Referencing System.
    """
    def __new__(cls, data: bytes) -> Lrs:
        r"""
        Load the data.
        """
    def lrm_len(self) -> builtins.int:
        r"""
        How many LRMs compose the LRS.
        """
    def get_lrm_geom(self, index: builtins.int) -> builtins.list[Point]:
        r"""
        Return the geometry of the LRM.
        """
    def get_lrm_scale_id(self, index: builtins.int) -> builtins.str:
        r"""
        `id` of the [`LrmScale`].
        """
    def get_anchors(self, lrm_index: builtins.int) -> builtins.list[Anchor]:
        r"""
        All the [`Anchor`]s of a LRM.
        """
    def resolve(self, lrm_index: builtins.int, measure: LrmScaleMeasure) -> Point:
        r"""
        Get the position given a [`LrmScaleMeasure`].
        """
    def locate_point(self, lrm_index: builtins.int, measure: LrmScaleMeasure) -> builtins.float:
        r"""
        Get the positon along the curve given a [`LrmScaleMeasure`]
        The value will be between 0.0 and 1.0, both included
        """
    def resolve_range(self, lrm_index: builtins.int, from_measure: LrmScaleMeasure, to_measure: LrmScaleMeasure) -> builtins.list[Point]:
        r"""
        Given two [`LrmScaleMeasure`]s, return a range of [`Point`] that represent a line string.
        """
    def find_lrm(self, lrm_id: builtins.str) -> typing.Optional[builtins.int]:
        r"""
        Given a ID returns the corresponding lrs index (or None if not found)
        """
    def lookup(self, point: Point, lrm_handle: builtins.int) -> builtins.list[LrmProjection]:
        r"""
        Projects a [`Point`] on all applicable [`Traversal`]s to a given [`Lrm`].
        The [`Point`] must be in the bounding box of the [`Curve`] of the [`Traversal`].
        The result is sorted by `orthogonal_offset`: the nearest [`Lrm`] to the [`Point`] is the first item.
        """
    def lookup_lrms(self, point: Point) -> builtins.list[LrmProjection]:
        r"""
        Projects a [`Point`] on all applicable [`Traversal`]s nearby.
        The [`Point`] must be in the bounding box of the [`Curve`] of the [`Traversal`].
        The result is sorted by `orthogonal_offset`: the nearest [`Lrm`] to the [`Point`] is the first item.
        """
    def lrs_properties(self) -> builtins.dict[builtins.str, builtins.str]:
        r"""
        [`Properties`] of the lrs
        """
    def lrm_properties(self, lrm_index: builtins.int) -> builtins.dict[builtins.str, builtins.str]:
        r"""
        [`Properties`] for a given lrm
        """
    def anchor_properties(self, lrm_index: builtins.int, anchor_index: builtins.int) -> builtins.dict[builtins.str, builtins.str]:
        r"""
        [`Properties`] for a given anchor
        """
    def get_node(self, node_index: builtins.int) -> Node:
        r"""
        Return a single [`Node`]
        """
    def get_nodes(self) -> builtins.list[Node]:
        r"""
        Return all the [`Node`] of the lrs
        """
    def get_segment(self, segment_index: builtins.int) -> Segment:
        r"""
        Return a single [`Segment`]
        """
    def get_segments(self) -> builtins.list[Segment]:
        r"""
        All the [`Segment`] of the lrs
        """

@typing.final
class Node:
    r"""
    A Node is a topological element of the [`Lrs`] that represents a intersection (or an extremity) of an [`Lrm`]
    """
    @property
    def id(self) -> builtins.str:
        r"""
        Identifies this [`Node`].
        """
    @id.setter
    def id(self, value: builtins.str) -> None:
        r"""
        Identifies this [`Node`].
        """
    @property
    def geometry(self) -> typing.Optional[Point]:
        r"""
        Coordinates of the [`Node`]. They are in the same projection system (e.g. spherical or planar) as the [`Lrs`]
        """
    @geometry.setter
    def geometry(self, value: typing.Optional[Point]) -> None:
        r"""
        Coordinates of the [`Node`]. They are in the same projection system (e.g. spherical or planar) as the [`Lrs`]
        """
    @property
    def properties(self) -> builtins.dict[builtins.str, builtins.str]:
        r"""
        Metadata to describe the [`Node`].
        """
    @properties.setter
    def properties(self, value: builtins.dict[builtins.str, builtins.str]) -> None:
        r"""
        Metadata to describe the [`Node`].
        """

@typing.final
class Point:
    r"""
    A geographical [`Point`], it can be either a projected or spherical coordinates.
    """
    @property
    def x(self) -> builtins.float:
        r"""
        Position on x-axis or `longitude`.
        """
    @x.setter
    def x(self, value: builtins.float) -> None:
        r"""
        Position on x-axis or `longitude`.
        """
    @property
    def y(self) -> builtins.float:
        r"""
        Position on y-axis or `latitude`.
        """
    @y.setter
    def y(self, value: builtins.float) -> None:
        r"""
        Position on y-axis or `latitude`.
        """
    def __new__(cls, x: builtins.float, y: builtins.float) -> Point:
        r"""
        Build a new geographical point.
        
        When using spherical coordinates, longitude is x and latitude y
        """
    def __repr__(self) -> builtins.str: ...

@typing.final
class Segment:
    r"""
    A segment is a topological element of the [`Lrs`] that represents a piece of the [`Curve`] of an [`Lrm`]
    
    It has a start and end [`Node`].
    """
    @property
    def id(self) -> builtins.str:
        r"""
        Identifies this [`Segment`]
        """
    @id.setter
    def id(self, value: builtins.str) -> None:
        r"""
        Identifies this [`Segment`]
        """
    @property
    def properties(self) -> builtins.dict[builtins.str, builtins.str]:
        r"""
        Metadata to describe the [`Segment`]
        """
    @properties.setter
    def properties(self, value: builtins.dict[builtins.str, builtins.str]) -> None:
        r"""
        Metadata to describe the [`Segment`]
        """
    @property
    def start_node(self) -> builtins.int:
        r"""
        Start [`Node`]
        """
    @start_node.setter
    def start_node(self, value: builtins.int) -> None:
        r"""
        Start [`Node`]
        """
    @property
    def end_node(self) -> builtins.int:
        r"""
        End [`Node`]
        """
    @end_node.setter
    def end_node(self, value: builtins.int) -> None:
        r"""
        End [`Node`]
        """

@typing.final
class SegmentOfTraversal:
    r"""
    A traversal is composed by segments
    """
    @property
    def segment_index(self) -> builtins.int:
        r"""
        Index of the considered segment. Use the value returned by [`Builder::add_segment`]
        """
    @segment_index.setter
    def segment_index(self, value: builtins.int) -> None:
        r"""
        Index of the considered segment. Use the value returned by [`Builder::add_segment`]
        """
    @property
    def reversed(self) -> builtins.bool:
        r"""
        When integrating the segment in the traversal, should we consider the coordinates in the reverse order
        """
    @reversed.setter
    def reversed(self, value: builtins.bool) -> None:
        r"""
        When integrating the segment in the traversal, should we consider the coordinates in the reverse order
        """
    def __new__(cls, segment_index: builtins.int, reversed: builtins.bool) -> SegmentOfTraversal: ...

