/*
 * Definitions for libmodi
 *
 * Copyright (C) 2012-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBMODI_DEFINITIONS_H )
#define _LIBMODI_DEFINITIONS_H

#include <libmodi/types.h>

#define LIBMODI_VERSION			20240305

/* The version string
 */
#define LIBMODI_VERSION_STRING		"20240305"

/* The access flags definitions
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBMODI_ACCESS_FLAGS
{
	LIBMODI_ACCESS_FLAG_READ	= 0x01,
/* Reserved: not supported yet */
	LIBMODI_ACCESS_FLAG_WRITE	= 0x02
};

/* The file access macros
 */
#define LIBMODI_OPEN_READ		( LIBMODI_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBMODI_OPEN_WRITE		( LIBMODI_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBMODI_OPEN_READ_WRITE		( LIBMODI_ACCESS_FLAG_READ | LIBMODI_ACCESS_FLAG_WRITE )

/* The image type definitions
 */
enum LIBMODI_IMAGE_TYPES
{
	LIBMODI_IMAGE_TYPE_UNKNOWN	= 0,
	LIBMODI_IMAGE_TYPE_RAW,
	LIBMODI_IMAGE_TYPE_SPARSE_BUNDLE,
	LIBMODI_IMAGE_TYPE_SPARSE_IMAGE,
	LIBMODI_IMAGE_TYPE_UDIF_COMPRESSED,
	LIBMODI_IMAGE_TYPE_UDIF_UNCOMPRESSED
};

#endif /* !defined( _LIBMODI_DEFINITIONS_H ) */

