/*
 * Library url type test program
 *
 * Copyright (C) 2009-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "msiecf_test_libcerror.h"
#include "msiecf_test_libmsiecf.h"
#include "msiecf_test_macros.h"
#include "msiecf_test_memory.h"
#include "msiecf_test_unused.h"

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc MSIECF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] MSIECF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc MSIECF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] MSIECF_TEST_ATTRIBUTE_UNUSED )
#endif
{
	MSIECF_TEST_UNREFERENCED_PARAMETER( argc )
	MSIECF_TEST_UNREFERENCED_PARAMETER( argv )

	/* TODO: add tests for libmsiecf_url_get_type */

	/* TODO: add tests for libmsiecf_url_get_primary_time */

	/* TODO: add tests for libmsiecf_url_get_secondary_time */

	/* TODO: add tests for libmsiecf_url_get_expiration_time */

	/* TODO: add tests for libmsiecf_url_get_last_checked_time */

	/* TODO: add tests for libmsiecf_url_get_cached_file_size */

	/* TODO: add tests for libmsiecf_url_get_cache_directory_index */

	/* TODO: add tests for libmsiecf_url_get_number_of_hits */

	/* TODO: add tests for libmsiecf_url_get_location_size */

	/* TODO: add tests for libmsiecf_url_get_location */

	/* TODO: add tests for libmsiecf_url_get_utf8_location_size */

	/* TODO: add tests for libmsiecf_url_get_utf8_location */

	/* TODO: add tests for libmsiecf_url_get_utf16_location_size */

	/* TODO: add tests for libmsiecf_url_get_utf16_location */

	/* TODO: add tests for libmsiecf_url_get_filename_size */

	/* TODO: add tests for libmsiecf_url_get_filename */

	/* TODO: add tests for libmsiecf_url_get_utf8_filename_size */

	/* TODO: add tests for libmsiecf_url_get_utf8_filename */

	/* TODO: add tests for libmsiecf_url_get_utf16_filename_size */

	/* TODO: add tests for libmsiecf_url_get_utf16_filename */

	/* TODO: add tests for libmsiecf_url_get_data_size */

	/* TODO: add tests for libmsiecf_url_get_data */

	return( EXIT_SUCCESS );

on_error:
	return( EXIT_FAILURE );
}

