/*
 * Definitions for libnk2
 *
 * Copyright (C) 2009-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBNK2_DEFINITIONS_H )
#define _LIBNK2_DEFINITIONS_H

#include <libnk2/types.h>

#define LIBNK2_VERSION					20221122

/* The version string
 */
#define LIBNK2_VERSION_STRING				"20221122"

/* The access flags definitions
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBNK2_ACCESS_FLAGS
{
	LIBNK2_ACCESS_FLAG_READ				= 0x01,
/* Reserved: not supported yet */
	LIBNK2_ACCESS_FLAG_WRITE			= 0x02
};

/* The file access macros
 */
#define LIBNK2_OPEN_READ				( LIBNK2_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBNK2_OPEN_WRITE				( LIBNK2_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBNK2_OPEN_READ_WRITE				( LIBNK2_ACCESS_FLAG_READ | LIBNK2_ACCESS_FLAG_WRITE )

/* TODO deprecated remove after a while */
#define LIBNK2_FLAG_READ				LIBNK2_ACCESS_FLAG_READ
#define LIBNK2_FLAG_WRITE				LIBNK2_ACCESS_FLAG_WRITE

/* The entry value flags
 */
enum LIBNK2_ENTRY_VALUE_FLAGS
{
	LIBNK2_ENTRY_VALUE_FLAG_MATCH_ANY_VALUE_TYPE	= 0x01,
};

#endif /* !defined( _LIBNK2_DEFINITIONS_H ) */

