/*
 * The libfole header wrapper
 *
 * Copyright (C) 2008-2015, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _OLECFTOOLS_LIBFOLE_H )
#define _OLECFTOOLS_LIBFOLE_H

#include <common.h>

/* Define HAVE_LOCAL_LIBFOLE for local use of libfole
 */
#if defined( HAVE_LOCAL_LIBFOLE )

#include <libfole_value_type.h>
#include <libfole_types.h>

#else

/* If libtool DLL support is enabled set LIBFOLE_DLL_IMPORT
 * before including libfole.h
 */
#if defined( _WIN32 ) && defined( DLL_IMPORT )
#define LIBFOLE_DLL_IMPORT
#endif

#include <libfole.h>

#endif

#endif

