/*
 * Python object definition of the sequence and iterator object of property values
 *
 * Copyright (C) 2008-2019, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _PYOLECF_PROPERTY_VALUES_H )
#define _PYOLECF_PROPERTY_VALUES_H

#include <common.h>
#include <types.h>

#include "pyolecf_libolecf.h"
#include "pyolecf_python.h"

#if defined( __cplusplus )
extern "C" {
#endif

typedef struct pyolecf_property_values pyolecf_property_values_t;

struct pyolecf_property_values
{
	/* Python object initialization
	 */
	PyObject_HEAD

	/* The parent object
	 */
	PyObject *parent_object;

	/* The get item by index callback function
	 */
	PyObject* (*get_item_by_index)(
	             PyObject *parent_object,
	             int index );

	/* The current index
	 */
	int current_index;

	/* The number of items
	 */
	int number_of_items;
};

extern PyTypeObject pyolecf_property_values_type_object;

PyObject *pyolecf_property_values_new(
           PyObject *parent_object,
           PyObject* (*get_item_by_index)(
                        PyObject *parent_object,
                        int index ),
           int number_of_items );

int pyolecf_property_values_init(
     pyolecf_property_values_t *property_values_object );

void pyolecf_property_values_free(
      pyolecf_property_values_t *property_values_object );

Py_ssize_t pyolecf_property_values_len(
            pyolecf_property_values_t *property_values_object );

PyObject *pyolecf_property_values_getitem(
           pyolecf_property_values_t *property_values_object,
           Py_ssize_t item_index );

PyObject *pyolecf_property_values_iter(
           pyolecf_property_values_t *property_values_object );

PyObject *pyolecf_property_values_iternext(
           pyolecf_property_values_t *property_values_object );

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _PYOLECF_PROPERTY_VALUES_H ) */

