/*
 * Library hive_bin type test program
 *
 * Copyright (C) 2009-2021, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <file_stream.h>
#include <types.h>

#if defined( HAVE_STDLIB_H ) || defined( WINAPI )
#include <stdlib.h>
#endif

#include "regf_test_functions.h"
#include "regf_test_libbfio.h"
#include "regf_test_libcerror.h"
#include "regf_test_libregf.h"
#include "regf_test_macros.h"
#include "regf_test_memory.h"
#include "regf_test_unused.h"

#include "../libregf/libregf_hive_bin.h"

uint8_t regf_test_hive_bin_data1[ 4096 ] = {
	0x68, 0x62, 0x69, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x12, 0xf3, 0xf1, 0xb0, 0x1c, 0xcf, 0xcf, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x70, 0xff, 0xff, 0xff, 0x6e, 0x6b, 0x2c, 0x00, 0x06, 0xb8, 0x19, 0x74, 0x56, 0xe0, 0xcf, 0x01,
	0x03, 0x00, 0x00, 0x00, 0x90, 0x02, 0x00, 0x00, 0x09, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x10, 0x03, 0x00, 0x00, 0x48, 0x01, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xb0, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x39, 0x00, 0x00, 0x00,
	0x43, 0x73, 0x69, 0x54, 0x6f, 0x6f, 0x6c, 0x2d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x48, 0x69,
	0x76, 0x65, 0x2d, 0x7b, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x2d, 0x30, 0x30, 0x30,
	0x30, 0x2d, 0x30, 0x30, 0x30, 0x30, 0x2d, 0x30, 0x30, 0x30, 0x30, 0x2d, 0x30, 0x30, 0x30, 0x30,
	0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x7d, 0x00, 0x00, 0x00, 0x50, 0x56, 0x07, 0x00,
	0x38, 0xff, 0xff, 0xff, 0x73, 0x6b, 0x00, 0x00, 0x28, 0x27, 0x10, 0x00, 0xb0, 0x06, 0x10, 0x00,
	0x01, 0x00, 0x00, 0x00, 0xb0, 0x00, 0x00, 0x00, 0x01, 0x00, 0x14, 0x9c, 0x94, 0x00, 0x00, 0x00,
	0xa4, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x1c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x08, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x78, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x02, 0x18, 0x00,
	0x19, 0x00, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
	0x21, 0x02, 0x00, 0x00, 0x00, 0x02, 0x18, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x02, 0x14, 0x00,
	0x3f, 0x00, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00,
	0x00, 0x02, 0x14, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x18, 0x00, 0x19, 0x00, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00, 0xa0, 0xff, 0xff, 0xff, 0x6e, 0x6b, 0x20, 0x00,
	0x2b, 0x05, 0xee, 0x23, 0x24, 0xcf, 0xcf, 0x01, 0x03, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x08, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xd8, 0x01, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x53,
	0x65, 0x74, 0x30, 0x30, 0x31, 0x00, 0x0f, 0x00, 0xc8, 0xfe, 0xff, 0xff, 0x73, 0x6b, 0x00, 0x00,
	0x28, 0xc9, 0x42, 0x00, 0x78, 0x0a, 0x10, 0x00, 0x02, 0x00, 0x00, 0x00, 0x1c, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x04, 0x9c, 0x00, 0x01, 0x00, 0x00, 0x10, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x14, 0x00, 0x00, 0x00, 0x02, 0x00, 0xec, 0x00, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
	0x19, 0x00, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
	0x21, 0x02, 0x00, 0x00, 0x00, 0x0a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00,
	0x3f, 0x00, 0x0f, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
	0x20, 0x02, 0x00, 0x00, 0x00, 0x0a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00,
	0x3f, 0x00, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00,
	0x00, 0x0a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x0a, 0x14, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x18, 0x00, 0x19, 0x00, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f,
	0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x80,
	0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xb0, 0xff, 0xff, 0xff, 0x6c, 0x68, 0x09, 0x00, 0x78, 0x01, 0x00, 0x00, 0xa2, 0xa9, 0x3b, 0x8f,
	0xc8, 0x26, 0x10, 0x00, 0xe5, 0x6c, 0xdd, 0xe9, 0x18, 0x0a, 0x10, 0x00, 0xf0, 0x56, 0x8b, 0x0a,
	0x50, 0xa8, 0x42, 0x00, 0xf5, 0xea, 0x3c, 0x00, 0x20, 0x0f, 0x10, 0x00, 0x2b, 0x07, 0x7a, 0xfc,
	0x18, 0x13, 0x10, 0x00, 0x0f, 0xc2, 0x01, 0x00, 0xc0, 0x14, 0x10, 0x00, 0xa0, 0x24, 0x00, 0x5f,
	0xb8, 0x15, 0x10, 0x00, 0x81, 0xb8, 0x7c, 0x09, 0xf0, 0x24, 0x10, 0x00, 0x10, 0xdd, 0x01, 0x00,
	0xa8, 0xff, 0xff, 0xff, 0x6e, 0x6b, 0x20, 0x00, 0x54, 0xc3, 0x16, 0x75, 0x56, 0xe0, 0xcf, 0x01,
	0x03, 0x00, 0x00, 0x00, 0x78, 0x01, 0x00, 0x00, 0x6a, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00,
	0x70, 0x09, 0x00, 0x00, 0x28, 0xeb, 0x00, 0x80, 0x0b, 0x00, 0x00, 0x00, 0x48, 0x05, 0x00, 0x00,
	0xb8, 0x03, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x30, 0x00, 0x00, 0x00, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x00, 0xe0, 0xfe, 0xff, 0xff, 0x73, 0x6b, 0x00, 0x00,
	0xd0, 0x33, 0x67, 0x00, 0xf8, 0x32, 0x50, 0x00, 0x60, 0x06, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00,
	0x01, 0x00, 0x14, 0x8c, 0xf0, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00,
	0x1c, 0x00, 0x00, 0x00, 0x02, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0xd4, 0x00,
	0x09, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x00, 0x19, 0x00, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x21, 0x02, 0x00, 0x00, 0x00, 0x1a, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x80, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
	0x21, 0x02, 0x00, 0x00, 0x00, 0x10, 0x18, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x01, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00, 0x20, 0x02, 0x00, 0x00, 0x00, 0x1a, 0x18, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x20, 0x00, 0x00, 0x00,
	0x20, 0x02, 0x00, 0x00, 0x00, 0x10, 0x14, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x14, 0x00, 0x00, 0x00, 0x00, 0x10,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x14, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x18, 0x00, 0x19, 0x00, 0x02, 0x00, 0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f,
	0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x1a, 0x18, 0x00, 0x00, 0x00, 0x00, 0x80,
	0x01, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x05, 0x12, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x10, 0x00,
	0x42, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x50, 0x72, 0x65, 0x73, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0xb8, 0xff, 0xff, 0xff, 0x77, 0x00, 0x75, 0x00, 0x61, 0x00, 0x75, 0x00, 0x73, 0x00, 0x65, 0x00,
	0x72, 0x00, 0x76, 0x00, 0x00, 0x00, 0x67, 0x00, 0x70, 0x00, 0x73, 0x00, 0x76, 0x00, 0x63, 0x00,
	0x00, 0x00, 0x74, 0x00, 0x72, 0x00, 0x75, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x64, 0x00,
	0x69, 0x00, 0x6e, 0x00, 0x73, 0x00, 0x74, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x6c, 0x00, 0x65, 0x00,
	0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xd0, 0xff, 0xff, 0xff, 0xd8, 0x04, 0x00, 0x00,
	0x78, 0x05, 0x00, 0x00, 0x60, 0x06, 0x00, 0x00, 0x88, 0x06, 0x00, 0x00, 0xc8, 0x06, 0x00, 0x00,
	0x08, 0x07, 0x00, 0x00, 0x60, 0x07, 0x00, 0x00, 0xd8, 0x07, 0x00, 0x00, 0x58, 0x08, 0x00, 0x00,
	0x88, 0x08, 0x00, 0x00, 0xb0, 0x08, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x12, 0x00,
	0xb2, 0x00, 0x00, 0x00, 0xa8, 0x05, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x0f,
	0x45, 0x61, 0x72, 0x6c, 0x79, 0x53, 0x74, 0x61, 0x72, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x00, 0x00, 0x01, 0x01, 0x00, 0x00, 0x48, 0xff, 0xff, 0xff, 0x52, 0x00, 0x70, 0x00,
	0x63, 0x00, 0x53, 0x00, 0x73, 0x00, 0x00, 0x00, 0x50, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x65, 0x00,
	0x72, 0x00, 0x00, 0x00, 0x42, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x6b, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x49, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x72, 0x00, 0x61, 0x00, 0x73, 0x00, 0x74, 0x00, 0x72, 0x00,
	0x75, 0x00, 0x63, 0x00, 0x74, 0x00, 0x75, 0x00, 0x72, 0x00, 0x65, 0x00, 0x00, 0x00, 0x53, 0x00,
	0x79, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x45, 0x00, 0x76, 0x00, 0x65, 0x00,
	0x6e, 0x00, 0x74, 0x00, 0x73, 0x00, 0x42, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x6b, 0x00, 0x65, 0x00,
	0x72, 0x00, 0x00, 0x00, 0x44, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x4c, 0x00, 0x61, 0x00,
	0x75, 0x00, 0x6e, 0x00, 0x63, 0x00, 0x68, 0x00, 0x00, 0x00, 0x52, 0x00, 0x70, 0x00, 0x63, 0x00,
	0x45, 0x00, 0x70, 0x00, 0x4d, 0x00, 0x61, 0x00, 0x70, 0x00, 0x70, 0x00, 0x65, 0x00, 0x72, 0x00,
	0x00, 0x00, 0x4c, 0x00, 0x53, 0x00, 0x4d, 0x00, 0x00, 0x00, 0x41, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x49, 0x00, 0x64, 0x00, 0x53, 0x00, 0x76, 0x00, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05,
	0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x0f, 0x00, 0x04, 0x00, 0x00, 0x80, 0x1c, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x72, 0x69, 0x76,
	0x65, 0x72, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x0b, 0x00,
	0x12, 0x00, 0x00, 0x00, 0xb0, 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xe8, 0xff, 0xff, 0xff, 0x55, 0x00, 0x53, 0x00, 0x45, 0x00, 0x52, 0x00, 0x4e, 0x00, 0x41, 0x00,
	0x4d, 0x00, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x18, 0x00,
	0x0a, 0x00, 0x00, 0x00, 0xf8, 0x06, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x57, 0x61, 0x69, 0x74, 0x54, 0x6f, 0x4b, 0x69, 0x6c, 0x6c, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0xf0, 0xff, 0xff, 0xff, 0x35, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x3f, 0x00, 0xd0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x12, 0x00,
	0x22, 0x00, 0x00, 0x00, 0x38, 0x07, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x20, 0x00, 0x4e, 0x00,
	0x4f, 0x00, 0x45, 0x00, 0x58, 0x00, 0x45, 0x00, 0x43, 0x00, 0x55, 0x00, 0x54, 0x00, 0x45, 0x00,
	0x3d, 0x00, 0x4f, 0x00, 0x50, 0x00, 0x54, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x10, 0x00, 0x48, 0x00, 0x00, 0x00, 0x88, 0x07, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x42, 0x6f,
	0x6f, 0x74, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0xb0, 0xff, 0xff, 0xff, 0x6d, 0x00, 0x75, 0x00,
	0x6c, 0x00, 0x74, 0x00, 0x69, 0x00, 0x28, 0x00, 0x30, 0x00, 0x29, 0x00, 0x64, 0x00, 0x69, 0x00,
	0x73, 0x00, 0x6b, 0x00, 0x28, 0x00, 0x30, 0x00, 0x29, 0x00, 0x72, 0x00, 0x64, 0x00, 0x69, 0x00,
	0x73, 0x00, 0x6b, 0x00, 0x28, 0x00, 0x30, 0x00, 0x29, 0x00, 0x70, 0x00, 0x61, 0x00, 0x72, 0x00,
	0x74, 0x00, 0x69, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x28, 0x00, 0x32, 0x00,
	0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x12, 0x00,
	0x48, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xb0, 0xff, 0xff, 0xff, 0x6d, 0x00, 0x75, 0x00,
	0x6c, 0x00, 0x74, 0x00, 0x69, 0x00, 0x28, 0x00, 0x30, 0x00, 0x29, 0x00, 0x64, 0x00, 0x69, 0x00,
	0x73, 0x00, 0x6b, 0x00, 0x28, 0x00, 0x30, 0x00, 0x29, 0x00, 0x72, 0x00, 0x64, 0x00, 0x69, 0x00,
	0x73, 0x00, 0x6b, 0x00, 0x28, 0x00, 0x30, 0x00, 0x29, 0x00, 0x70, 0x00, 0x61, 0x00, 0x72, 0x00,
	0x74, 0x00, 0x69, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x28, 0x00, 0x31, 0x00,
	0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x11, 0x00,
	0x04, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x4c, 0x61, 0x73, 0x74, 0x42, 0x6f, 0x6f, 0x74, 0x53, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x65,
	0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x10, 0x00,
	0x04, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x4c, 0x61, 0x73, 0x74, 0x42, 0x6f, 0x6f, 0x74, 0x53, 0x68, 0x75, 0x74, 0x64, 0x6f, 0x77, 0x6e,
	0xd0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x12, 0x00, 0x04, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x01, 0x00, 0x65, 0x53, 0x44, 0x69, 0x72, 0x74, 0x79, 0x53, 0x68, 0x75,
	0x74, 0x64, 0x6f, 0x77, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0xd0, 0xff, 0xff, 0xff, 0x6c, 0x68, 0x05, 0x00, 0x60, 0x03, 0x00, 0x00, 0x81, 0x64, 0xc1, 0x55,
	0x28, 0xbd, 0x06, 0x00, 0x45, 0x02, 0x37, 0x00, 0x28, 0xe1, 0x06, 0x00, 0xba, 0x7b, 0x02, 0x84,
	0xd0, 0xc8, 0x42, 0x00, 0x90, 0x5f, 0x5c, 0xb2, 0x70, 0xee, 0x06, 0x00, 0x30, 0xf7, 0x7a, 0x22,
	0xa0, 0xff, 0xff, 0xff, 0x6e, 0x6b, 0x20, 0x00, 0x8b, 0x8d, 0x35, 0x24, 0x24, 0xcf, 0xcf, 0x01,
	0x02, 0x00, 0x00, 0x00, 0x60, 0x03, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x38, 0x1d, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0xb8, 0x03, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x0d, 0x00, 0x00, 0x00,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0xb7, 0x01, 0x00,
	0xa8, 0xfc, 0xff, 0xff, 0x6c, 0x68, 0x6a, 0x00, 0x60, 0x19, 0x55, 0x00, 0x41, 0xaf, 0x33, 0x00,
	0xf0, 0x19, 0x55, 0x00, 0x2c, 0x66, 0x01, 0x00, 0xb8, 0x1b, 0x55, 0x00, 0xe2, 0x60, 0x82, 0x07,
	0x10, 0x1e, 0x55, 0x00, 0x6b, 0x03, 0x9b, 0x15, 0xf0, 0x1e, 0x55, 0x00, 0x00, 0xb2, 0x27, 0xc8,
	0x10, 0x09, 0x00, 0x00, 0x0e, 0x8d, 0x0d, 0xd6, 0x58, 0x1d, 0x00, 0x00, 0x7b, 0xd6, 0xf5, 0x9c,
	0x98, 0x2d, 0x55, 0x00, 0xf8, 0x09, 0x00, 0x00, 0xb8, 0x1d, 0x00, 0x00, 0x9a, 0x2c, 0xb8, 0x07,
	0x70, 0xc4, 0x00, 0x00, 0xb2, 0x71, 0x01, 0x00, 0x80, 0x2f, 0x55, 0x00, 0xc7, 0x0a, 0x99, 0x6d,
	0x70, 0xc6, 0x00, 0x00, 0xfd, 0xe8, 0xa1, 0x00, 0x18, 0xc7, 0x00, 0x00, 0x0e, 0x50, 0x3f, 0x18,
	0xe0, 0xc7, 0x00, 0x00, 0x14, 0x80, 0xcf, 0x3f, 0x40, 0x37, 0x55, 0x00, 0x8f, 0xb1, 0xd4, 0x94,
	0xe0, 0x94, 0x55, 0x00, 0x1a, 0x3a, 0x64, 0xd4, 0x40, 0xc9, 0x00, 0x00, 0x04, 0xb6, 0x33, 0x7b,
	0x88, 0xd0, 0x00, 0x00, 0x42, 0x35, 0xd7, 0x11, 0x78, 0x98, 0x55, 0x00, 0x5c, 0xc6, 0xfc, 0x94,
	0xb8, 0xf2, 0x00, 0x00, 0xb2, 0x57, 0xf5, 0x18, 0x40, 0x9c, 0x55, 0x00, 0xe7, 0x33, 0x3b, 0x90,
	0xa8, 0x0a, 0x01, 0x00, 0x01, 0x65, 0xc7, 0xa6, 0x88, 0x1d, 0x01, 0x00, 0xd0, 0xa4, 0x6d, 0x99,
	0x18, 0x9e, 0x55, 0x00, 0xd4, 0xef, 0x63, 0xa3, 0xd0, 0x9e, 0x55, 0x00, 0x4c, 0x7c, 0x01, 0x00,
	0x58, 0xba, 0x55, 0x00, 0x63, 0x01, 0x9b, 0x26, 0x58, 0xbb, 0x55, 0x00, 0x0a, 0x4e, 0x10, 0x91,
	0x90, 0x1e, 0x01, 0x00, 0x89, 0xe9, 0x55, 0x0e, 0xe8, 0xbe, 0x55, 0x00, 0x9d, 0x55, 0xd2, 0x31,
	0x20, 0x26, 0x01, 0x00, 0xc8, 0x24, 0xf8, 0x85, 0x88, 0x2a, 0x01, 0x00, 0xdd, 0x8b, 0x9d, 0x66,
	0xa0, 0xbf, 0x55, 0x00, 0xb9, 0x8a, 0x01, 0x00, 0xe8, 0x3a, 0x01, 0x00, 0xb5, 0x3c, 0xef, 0x2c,
	0x68, 0xc2, 0x55, 0x00, 0x55, 0x51, 0xff, 0x4a, 0xf0, 0xc2, 0x55, 0x00, 0x3f, 0x23, 0x3a, 0x00,
	0x18, 0xc4, 0x55, 0x00, 0x87, 0x6e, 0x02, 0xe5, 0xa8, 0x3b, 0x01, 0x00, 0xd6, 0xf9, 0x59, 0x19,
	0xb0, 0x3e, 0x01, 0x00, 0xac, 0xa2, 0x01, 0x00, 0x90, 0xd6, 0x55, 0x00, 0x8b, 0xb4, 0x69, 0x8a,
	0x40, 0xda, 0x55, 0x00, 0x8e, 0x97, 0xc7, 0x35, 0xd0, 0xda, 0x55, 0x00, 0xf9, 0x39, 0x7d, 0x78,
	0x28, 0xe7, 0x55, 0x00, 0xca, 0x9e, 0xae, 0xef, 0x60, 0xe9, 0x55, 0x00, 0x4b, 0xa5, 0xda, 0x48,
	0xf0, 0xea, 0x55, 0x00, 0x40, 0x76, 0x45, 0x21, 0xa0, 0xee, 0x55, 0x00, 0xc1, 0xb0, 0xf5, 0xc2,
	0x48, 0x03, 0x56, 0x00, 0x85, 0x00, 0x0d, 0x9b, 0xf8, 0x06, 0x56, 0x00, 0x2f, 0x9f, 0xdb, 0x08,
	0xb8, 0x52, 0x01, 0x00, 0x57, 0xa8, 0x01, 0x00, 0x20, 0x09, 0x56, 0x00, 0x92, 0xb7, 0xc6, 0xd2,
	0x90, 0x53, 0x59, 0x00, 0x20, 0x78, 0xa7, 0x2a, 0x68, 0x64, 0x59, 0x00, 0x72, 0x73, 0xa5, 0xa6,
	0x30, 0x55, 0x01, 0x00, 0x72, 0xd8, 0x52, 0xbf, 0xd0, 0x7a, 0x59, 0x00, 0x49, 0xdf, 0x4a, 0x98,
	0xb0, 0x4b, 0x02, 0x00, 0x5b, 0x63, 0x8a, 0x2a, 0xd8, 0x7c, 0x59, 0x00, 0x76, 0x51, 0x73, 0x29,
	0x10, 0x4c, 0x02, 0x00, 0x6d, 0xac, 0x01, 0x00, 0x38, 0x7f, 0x59, 0x00, 0xf6, 0x68, 0x6e, 0x89,
	0x10, 0x86, 0x59, 0x00, 0x36, 0xf2, 0x5a, 0xbf, 0xd8, 0xda, 0x02, 0x00, 0x66, 0xad, 0x01, 0x00,
	0x98, 0x3c, 0x5a, 0x00, 0xe8, 0xe1, 0x60, 0xc7, 0xf8, 0x2b, 0x5a, 0x00, 0xd6, 0xb5, 0x01, 0x00,
	0x58, 0x09, 0x03, 0x00, 0x66, 0xb7, 0x01, 0x00, 0xe0, 0x09, 0x03, 0x00, 0x0d, 0xb6, 0x2e, 0x09,
	0x28, 0x96, 0x05, 0x00, 0x15, 0xbe, 0x30, 0x09, 0x10, 0x2d, 0x5a, 0x00, 0x3f, 0x32, 0x38, 0xf6,
	0x58, 0xad, 0x05, 0x00, 0x89, 0xd7, 0x37, 0x02, 0x70, 0x2d, 0x5a, 0x00, 0x50, 0x35, 0x0d, 0x02,
	0xb0, 0x4d, 0x5a, 0x00, 0x1a, 0x64, 0xdb, 0x72, 0x18, 0x4f, 0x5a, 0x00, 0xf6, 0x09, 0x7e, 0xfa,
	0x20, 0x50, 0x5a, 0x00, 0xa3, 0xe2, 0x3e, 0x8b, 0xc0, 0xd0, 0x5a, 0x00, 0x57, 0xfe, 0xe0, 0xba,
	0xe0, 0xd1, 0x5a, 0x00, 0x4f, 0x37, 0x53, 0xf3, 0x30, 0xe2, 0x5a, 0x00, 0x47, 0x73, 0x59, 0x64,
	0xc0, 0xe2, 0x5a, 0x00, 0xe7, 0x5d, 0x4f, 0x55, 0xa8, 0xae, 0x05, 0x00, 0xb6, 0xf4, 0x74, 0x86,
	0x68, 0xeb, 0x5a, 0x00, 0x2e, 0x3f, 0x98, 0xe2, 0xc8, 0xf8, 0x5a, 0x00, 0x50, 0x11, 0x8a, 0x51,
	0x68, 0x33, 0x06, 0x00, 0x27, 0x4f, 0xdc, 0xd9, 0x10, 0xfa, 0x5a, 0x00, 0x36, 0xd3, 0x41, 0x00,
	0x48, 0xfb, 0x5a, 0x00, 0xc2, 0xaa, 0x6a, 0x5f, 0xc0, 0xfc, 0x5a, 0x00, 0x05, 0xc8, 0x01, 0x00,
	0x80, 0xfd, 0x5a, 0x00, 0x70, 0x9d, 0x20, 0xfc, 0x68, 0xfe, 0x5a, 0x00, 0xe3, 0x8c, 0x4d, 0xbb,
	0xd0, 0x16, 0x5b, 0x00, 0x59, 0xa8, 0x64, 0xf9, 0x28, 0x1b, 0x5b, 0x00, 0x0a, 0x65, 0x18, 0x3c,
	0x00, 0x52, 0x06, 0x00, 0xcd, 0x19, 0x98, 0x0b, 0x98, 0x1d, 0x5b, 0x00, 0x3c, 0xfe, 0xc3, 0xdf,
	0x40, 0x33, 0x5b, 0x00, 0x5b, 0x8f, 0xe2, 0x95, 0x58, 0x52, 0x06, 0x00, 0xeb, 0x3d, 0x74, 0xc0,
	0x50, 0x6e, 0x06, 0x00, 0x65, 0x50, 0x16, 0x3d, 0x80, 0x34, 0x5b, 0x00, 0x30, 0x1f, 0x43, 0x00,
	0xc0, 0x39, 0x5b, 0x00, 0xce, 0xd2, 0x01, 0x00, 0x80, 0x3a, 0x5b, 0x00, 0x17, 0x47, 0x57, 0x70,
	0xa8, 0x3b, 0x5b, 0x00, 0x86, 0xb7, 0xab, 0x25, 0xd0, 0x3e, 0x5b, 0x00, 0x99, 0xd5, 0x01, 0x00,
	0x60, 0xb1, 0x06, 0x00, 0xe7, 0x42, 0xd5, 0x09, 0x50, 0x46, 0x5b, 0x00, 0xdf, 0x94, 0xb0, 0x16,
	0xc0, 0x48, 0x5b, 0x00, 0x59, 0xdb, 0x01, 0x00, 0xe8, 0xb2, 0x06, 0x00, 0x5c, 0xdb, 0x01, 0x00,
	0xc8, 0xb9, 0x06, 0x00, 0x8b, 0xe6, 0x7d, 0x2f, 0xb0, 0xbc, 0x06, 0x00, 0x7e, 0xbc, 0x81, 0x2f,
	0xc0, 0x7d, 0x5b, 0x00, 0xc9, 0xc3, 0x16, 0xde, 0x60, 0x8f, 0x5b, 0x00, 0xa9, 0xdc, 0x01, 0x00,
	0x48, 0xad, 0x60, 0x00, 0x30, 0x40, 0xe3, 0x89, 0xa8, 0xad, 0x60, 0x00, 0x1d, 0xdd, 0x01, 0x00,
	0x90, 0xb2, 0x60, 0x00, 0x9f, 0x78, 0xdf, 0x71, 0xa0, 0xff, 0xff, 0xff, 0x6e, 0x6b, 0x20, 0x00,
	0xce, 0x3e, 0xfd, 0x54, 0x0b, 0xe0, 0xcf, 0x01, 0x02, 0x00, 0x00, 0x00, 0x10, 0x09, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x1b, 0x00, 0x00, 0x00, 0x90, 0x8f, 0x6c, 0x00, 0xb8, 0x03, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x22, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x4e, 0x6f, 0x74,
	0x54, 0x6f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x0f, 0x00,
	0x1a, 0x00, 0x00, 0x00, 0x50, 0x0d, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x0f,
	0x54, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79, 0x20, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x80,
	0xe0, 0xff, 0xff, 0xff, 0x25, 0x00, 0x54, 0x00, 0x45, 0x00, 0x4d, 0x00, 0x50, 0x00, 0x25, 0x00,
	0x5c, 0x00, 0x2a, 0x00, 0x20, 0x00, 0x2f, 0x00, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xe0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x08, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x90, 0x0d, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x42, 0x49, 0x54, 0x53, 0x5f, 0x42, 0x41, 0x4b,
	0xc0, 0xff, 0xff, 0xff, 0x43, 0x00, 0x3a, 0x00, 0x5c, 0x00, 0x57, 0x00, 0x69, 0x00, 0x6e, 0x00,
	0x64, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x73, 0x00, 0x5c, 0x00, 0x53, 0x00, 0x79, 0x00, 0x73, 0x00,
	0x74, 0x00, 0x65, 0x00, 0x6d, 0x00, 0x33, 0x00, 0x32, 0x00, 0x5c, 0x00, 0x42, 0x00, 0x69, 0x00,
	0x74, 0x00, 0x73, 0x00, 0x2e, 0x00, 0x62, 0x00, 0x61, 0x00, 0x6b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xf8, 0xff, 0xff, 0xff, 0x18, 0xae, 0x42, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x10, 0x00,
	0x1e, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0xd4, 0xc4,
	0x4d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x20, 0x50, 0x61, 0x67, 0x65, 0x20, 0x46, 0x69, 0x6c, 0x65,
	0xd8, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x50, 0x00, 0x61, 0x00, 0x67, 0x00, 0x65, 0x00, 0x66, 0x00,
	0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x2e, 0x00, 0x73, 0x00, 0x79, 0x00, 0x73, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x18, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x0d, 0x00,
	0x78, 0x00, 0x00, 0x00, 0x50, 0x0e, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x02, 0x00, 0x00,
	0x80, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00,
	0x6d, 0x00, 0x20, 0x00, 0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x6d, 0x00, 0x65, 0x00,
	0x20, 0x00, 0x49, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x5c, 0x00, 0x4d, 0x00, 0x6f, 0x00, 0x75, 0x00,
	0x6e, 0x00, 0x74, 0x00, 0x50, 0x00, 0x6f, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x4d, 0x00,
	0x61, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x67, 0x00, 0x65, 0x00, 0x72, 0x00, 0x52, 0x00, 0x65, 0x00,
	0x6d, 0x00, 0x6f, 0x00, 0x74, 0x00, 0x65, 0x00, 0x44, 0x00, 0x61, 0x00, 0x74, 0x00, 0x61, 0x00,
	0x62, 0x00, 0x61, 0x00, 0x73, 0x00, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
	0xe0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x03, 0x00, 0x22, 0x01, 0x00, 0x00, 0x20, 0x10, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x05, 0x52, 0x41, 0x43, 0x00, 0x01, 0x01, 0x00, 0x00,
	0xd0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x14, 0x00, 0x8e, 0x00, 0x00, 0x00, 0x20, 0x0f, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x56, 0x53, 0x53, 0x20, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x20, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x00, 0x00, 0x00, 0x00,
	0x68, 0xff, 0xff, 0xff, 0x5c, 0x00, 0x53, 0x00, 0x79, 0x00, 0x73, 0x00, 0x74, 0x00, 0x65, 0x00,
	0x6d, 0x00, 0x20, 0x00, 0x56, 0x00, 0x6f, 0x00, 0x6c, 0x00, 0x75, 0x00, 0x6d, 0x00, 0x65, 0x00,
	0x20, 0x00, 0x49, 0x00, 0x6e, 0x00, 0x66, 0x00, 0x6f, 0x00, 0x72, 0x00, 0x6d, 0x00, 0x61, 0x00,
	0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x5c, 0x00, 0x2a, 0x00, 0x7b, 0x00, 0x33, 0x00,
	0x38, 0x00, 0x30, 0x00, 0x38, 0x00, 0x38, 0x00, 0x37, 0x00, 0x36, 0x00, 0x42, 0x00, 0x2d, 0x00,
	0x43, 0x00, 0x31, 0x00, 0x37, 0x00, 0x36, 0x00, 0x2d, 0x00, 0x34, 0x00, 0x65, 0x00, 0x34, 0x00,
	0x38, 0x00, 0x2d, 0x00, 0x42, 0x00, 0x37, 0x00, 0x41, 0x00, 0x45, 0x00, 0x2d, 0x00, 0x30, 0x00,
	0x34, 0x00, 0x30, 0x00, 0x34, 0x00, 0x36, 0x00, 0x45, 0x00, 0x36, 0x00, 0x43, 0x00, 0x43, 0x00,
	0x37, 0x00, 0x35, 0x00, 0x32, 0x00, 0x7d, 0x00, 0x20, 0x00, 0x2f, 0x00, 0x73, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd8, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x0b, 0x00,
	0x92, 0x00, 0x00, 0x00, 0x48, 0x11, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
	0x46, 0x56, 0x45, 0x5f, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
	0xe0, 0xff, 0xff, 0xff, 0x76, 0x6b, 0x03, 0x00, 0x4c, 0x00, 0x00, 0x00, 0xa0, 0x12, 0x00, 0x00,
	0x07, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x57, 0x55, 0x41, 0x00, 0x00, 0x00, 0x00, 0x00
};

#if defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT )

/* Tests the libregf_hive_bin_initialize function
 * Returns 1 if successful or 0 if not
 */
int regf_test_hive_bin_initialize(
     void )
{
	libcerror_error_t *error        = NULL;
	libregf_hive_bin_t *hive_bin    = NULL;
	int result                      = 0;

#if defined( HAVE_REGF_TEST_MEMORY )
	int number_of_malloc_fail_tests = 2;
	int number_of_memset_fail_tests = 1;
	int test_number                 = 0;
#endif

	/* Test regular cases
	 */
	result = libregf_hive_bin_initialize(
	          &hive_bin,
	          4096,
	          4096,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libregf_hive_bin_free(
	          &hive_bin,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libregf_hive_bin_initialize(
	          NULL,
	          4096,
	          4096,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	hive_bin = (libregf_hive_bin_t *) 0x12345678UL;

	result = libregf_hive_bin_initialize(
	          &hive_bin,
	          4096,
	          4096,
	          &error );

	hive_bin = NULL;

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

#if defined( HAVE_REGF_TEST_MEMORY )

	for( test_number = 0;
	     test_number < number_of_malloc_fail_tests;
	     test_number++ )
	{
		/* Test libregf_hive_bin_initialize with malloc failing
		 */
		regf_test_malloc_attempts_before_fail = test_number;

		result = libregf_hive_bin_initialize(
		          &hive_bin,
		          4096,
		          4096,
		          &error );

		if( regf_test_malloc_attempts_before_fail != -1 )
		{
			regf_test_malloc_attempts_before_fail = -1;

			if( hive_bin != NULL )
			{
				libregf_hive_bin_free(
				 &hive_bin,
				 NULL );
			}
		}
		else
		{
			REGF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			REGF_TEST_ASSERT_IS_NULL(
			 "hive_bin",
			 hive_bin );

			REGF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
	for( test_number = 0;
	     test_number < number_of_memset_fail_tests;
	     test_number++ )
	{
		/* Test libregf_hive_bin_initialize with memset failing
		 */
		regf_test_memset_attempts_before_fail = test_number;

		result = libregf_hive_bin_initialize(
		          &hive_bin,
		          4096,
		          4096,
		          &error );

		if( regf_test_memset_attempts_before_fail != -1 )
		{
			regf_test_memset_attempts_before_fail = -1;

			if( hive_bin != NULL )
			{
				libregf_hive_bin_free(
				 &hive_bin,
				 NULL );
			}
		}
		else
		{
			REGF_TEST_ASSERT_EQUAL_INT(
			 "result",
			 result,
			 -1 );

			REGF_TEST_ASSERT_IS_NULL(
			 "hive_bin",
			 hive_bin );

			REGF_TEST_ASSERT_IS_NOT_NULL(
			 "error",
			 error );

			libcerror_error_free(
			 &error );
		}
	}
#endif /* defined( HAVE_REGF_TEST_MEMORY ) */

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( hive_bin != NULL )
	{
		libregf_hive_bin_free(
		 &hive_bin,
		 NULL );
	}
	return( 0 );
}

/* Tests the libregf_hive_bin_free function
 * Returns 1 if successful or 0 if not
 */
int regf_test_hive_bin_free(
     void )
{
	libcerror_error_t *error = NULL;
	int result               = 0;

	/* Test error cases
	 */
	result = libregf_hive_bin_free(
	          NULL,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libregf_hive_bin_read_cells_data function
 * Returns 1 if successful or 0 if not
 */
int regf_test_hive_bin_read_cells_data(
     void )
{
	libcerror_error_t *error     = NULL;
	libregf_hive_bin_t *hive_bin = NULL;
	int result                   = 0;

	/* Initialize test
	 */
	result = libregf_hive_bin_initialize(
	          &hive_bin,
	          4096,
	          4096,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libregf_hive_bin_read_cells_data(
	          hive_bin,
	          &( regf_test_hive_bin_data1[ 32 ] ),
	          4096 - 32,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libregf_hive_bin_read_cells_data(
	          NULL,
	          &( regf_test_hive_bin_data1[ 32 ] ),
	          4096 - 32,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_read_cells_data(
	          hive_bin,
	          NULL,
	          4096 - 32,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_read_cells_data(
	          hive_bin,
	          &( regf_test_hive_bin_data1[ 32 ] ),
	          0,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_read_cells_data(
	          hive_bin,
	          &( regf_test_hive_bin_data1[ 32 ] ),
	          (size_t) SSIZE_MAX + 1,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up
	 */
	result = libregf_hive_bin_free(
	          &hive_bin,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( hive_bin != NULL )
	{
		libregf_hive_bin_free(
		 &hive_bin,
		 NULL );
	}
	return( 0 );
}

/* Tests the libregf_hive_bin_read_cells_file_io_handle function
 * Returns 1 if successful or 0 if not
 */
int regf_test_hive_bin_read_cells_file_io_handle(
     void )
{
	libbfio_handle_t *file_io_handle = NULL;
	libcerror_error_t *error         = NULL;
	libregf_hive_bin_t *hive_bin     = NULL;
	int result                       = 0;

	/* Initialize test
	 */
	result = libregf_hive_bin_initialize(
	          &hive_bin,
	          4096,
	          4096,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Initialize file IO handle
	 */
	result = regf_test_open_file_io_handle(
	          &file_io_handle,
	          &( regf_test_hive_bin_data1[ 32 ] ),
	          4096 - 32,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "file_io_handle",
	 file_io_handle );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test regular cases
	 */
	result = libregf_hive_bin_read_cells_file_io_handle(
	          hive_bin,
	          file_io_handle,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libregf_hive_bin_read_cells_file_io_handle(
	          NULL,
	          file_io_handle,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_read_cells_file_io_handle(
	          hive_bin,
	          NULL,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	/* Clean up file IO handle
	 */
	result = regf_test_close_file_io_handle(
	          &file_io_handle,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 0 );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test data too small
	 */
	result = regf_test_open_file_io_handle(
	          &file_io_handle,
	          regf_test_hive_bin_data1,
	          3,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "file_io_handle",
	 file_io_handle );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libregf_hive_bin_read_cells_file_io_handle(
	          hive_bin,
	          file_io_handle,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = regf_test_close_file_io_handle(
	          &file_io_handle,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 0 );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Clean up
	 */
	result = libregf_hive_bin_free(
	          &hive_bin,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( file_io_handle != NULL )
	{
		libbfio_handle_free(
		 &file_io_handle,
		 NULL );
	}
	if( hive_bin != NULL )
	{
		libregf_hive_bin_free(
		 &hive_bin,
		 NULL );
	}
	return( 0 );
}

/* Tests the libregf_hive_bin_get_number_of_cells function
 * Returns 1 if successful or 0 if not
 */
int regf_test_hive_bin_get_number_of_cells(
     libregf_hive_bin_t *hive_bin )
{
	libcerror_error_t *error = NULL;
	uint16_t number_of_cells = 0;
	int result               = 0;

	/* Test regular cases
	 */
	result = libregf_hive_bin_get_number_of_cells(
	          hive_bin,
	          &number_of_cells,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_EQUAL_UINT16(
	 "number_of_cells",
	 number_of_cells,
	 44 );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libregf_hive_bin_get_number_of_cells(
	          NULL,
	          &number_of_cells,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_get_number_of_cells(
	          hive_bin,
	          NULL,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libregf_hive_bin_get_cell function
 * Returns 1 if successful or 0 if not
 */
int regf_test_hive_bin_get_cell(
     libregf_hive_bin_t *hive_bin )
{
	libcerror_error_t *error               = NULL;
	libregf_hive_bin_cell_t *hive_bin_cell = NULL;
	int result                             = 0;

	/* Test regular cases
	 */
	result = libregf_hive_bin_get_cell(
	          hive_bin,
	          0,
	          &hive_bin_cell,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "hive_bin_cell",
	 hive_bin_cell );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libregf_hive_bin_get_cell(
	          NULL,
	          0,
	          &hive_bin_cell,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_get_cell(
	          hive_bin,
	          -1,
	          &hive_bin_cell,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_get_cell(
	          hive_bin,
	          0,
	          NULL,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

/* Tests the libregf_hive_bin_get_cell_at_offset function
 * Returns 1 if successful or 0 if not
 */
int regf_test_hive_bin_get_cell_at_offset(
     libregf_hive_bin_t *hive_bin )
{
	libcerror_error_t *error               = NULL;
	libregf_hive_bin_cell_t *hive_bin_cell = NULL;
	int result                             = 0;

	/* Test regular cases
	 */
	hive_bin_cell = NULL;

	result = libregf_hive_bin_get_cell_at_offset(
	          hive_bin,
	          4096 + 32,
	          &hive_bin_cell,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "hive_bin_cell",
	 hive_bin_cell );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	hive_bin_cell = NULL;

	result = libregf_hive_bin_get_cell_at_offset(
	          hive_bin,
	          0,
	          &hive_bin_cell,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 0 );

	REGF_TEST_ASSERT_IS_NULL(
	 "hive_bin_cell",
	 hive_bin_cell );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Test error cases
	 */
	result = libregf_hive_bin_get_cell_at_offset(
	          NULL,
	          0,
	          &hive_bin_cell,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	result = libregf_hive_bin_get_cell_at_offset(
	          hive_bin,
	          0,
	          NULL,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 -1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "error",
	 error );

	libcerror_error_free(
	 &error );

	return( 1 );

on_error:
	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	return( 0 );
}

#endif /* defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT ) */

/* The main program
 */
#if defined( HAVE_WIDE_SYSTEM_CHARACTER )
int wmain(
     int argc REGF_TEST_ATTRIBUTE_UNUSED,
     wchar_t * const argv[] REGF_TEST_ATTRIBUTE_UNUSED )
#else
int main(
     int argc REGF_TEST_ATTRIBUTE_UNUSED,
     char * const argv[] REGF_TEST_ATTRIBUTE_UNUSED )
#endif
{
#if defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT )

	libcerror_error_t *error     = NULL;
	libregf_hive_bin_t *hive_bin = NULL;
	int result                   = 0;

#endif /* defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT ) */

	REGF_TEST_UNREFERENCED_PARAMETER( argc )
	REGF_TEST_UNREFERENCED_PARAMETER( argv )

#if defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT )

	REGF_TEST_RUN(
	 "libregf_hive_bin_initialize",
	 regf_test_hive_bin_initialize );

	REGF_TEST_RUN(
	 "libregf_hive_bin_free",
	 regf_test_hive_bin_free );

	REGF_TEST_RUN(
	 "libregf_hive_bin_read_cells_data",
	 regf_test_hive_bin_read_cells_data );

	REGF_TEST_RUN(
	 "libregf_hive_bin_read_cells_file_io_handle",
	 regf_test_hive_bin_read_cells_file_io_handle );

	/* Initialize test
	 */
	result = libregf_hive_bin_initialize(
	          &hive_bin,
	          4096,
	          4096,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NOT_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	result = libregf_hive_bin_read_cells_data(
	          hive_bin,
	          &( regf_test_hive_bin_data1[ 32 ] ),
	          4096 - 32,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

	/* Run tests
	 */
	REGF_TEST_RUN_WITH_ARGS(
	 "libregf_hive_bin_get_number_of_cells",
	 regf_test_hive_bin_get_number_of_cells,
	 hive_bin );

	REGF_TEST_RUN_WITH_ARGS(
	 "libregf_hive_bin_get_cell",
	 regf_test_hive_bin_get_cell,
	 hive_bin );

	REGF_TEST_RUN_WITH_ARGS(
	 "libregf_hive_bin_get_cell_at_offset",
	 regf_test_hive_bin_get_cell_at_offset,
	 hive_bin );

	/* Clean up
	 */
	result = libregf_hive_bin_free(
	          &hive_bin,
	          &error );

	REGF_TEST_ASSERT_EQUAL_INT(
	 "result",
	 result,
	 1 );

	REGF_TEST_ASSERT_IS_NULL(
	 "hive_bin",
	 hive_bin );

	REGF_TEST_ASSERT_IS_NULL(
	 "error",
	 error );

#endif /* defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT ) */

	return( EXIT_SUCCESS );

on_error:
#if defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT )

	if( error != NULL )
	{
		libcerror_error_free(
		 &error );
	}
	if( hive_bin != NULL )
	{
		libregf_hive_bin_free(
		 &hive_bin,
		 NULL );
	}
#endif /* defined( __GNUC__ ) && !defined( LIBREGF_DLL_IMPORT ) */

	return( EXIT_FAILURE );
}

