/*
 * Windows 949 codepage (Korean) functions
 *
 * Copyright (C) 2008-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <common.h>
#include <types.h>

#include "libuna_codepage_windows_949.h"
#include "libuna_libcerror.h"
#include "libuna_types.h"

/* Extended ASCII to Unicode character lookup tables for the Windows 949 codepage
 * Unknown are filled with the Unicode replacement character 0xfffd
 */
const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8140[ 192 ] = {
	0xfffd, 0xac02, 0xac03, 0xac05, 0xac06, 0xac0b, 0xac0c, 0xac0d,
	0xac0e, 0xac0f, 0xac18, 0xac1e, 0xac1f, 0xac21, 0xac22, 0xac23,
	0xac25, 0xac26, 0xac27, 0xac28, 0xac29, 0xac2a, 0xac2b, 0xac2e,
	0xac32, 0xac33, 0xac34, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xac35, 0xac36, 0xac37, 0xac3a, 0xac3b, 0xac3d, 0xac3e,
	0xac3f, 0xac41, 0xac42, 0xac43, 0xac44, 0xac45, 0xac46, 0xac47,
	0xac48, 0xac49, 0xac4a, 0xac4c, 0xac4e, 0xac4f, 0xac50, 0xac51,
	0xac52, 0xac53, 0xac55, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xac56, 0xac57, 0xac59, 0xac5a, 0xac5b, 0xac5d, 0xac5e,
	0xac5f, 0xac60, 0xac61, 0xac62, 0xac63, 0xac64, 0xac65, 0xac66,
	0xac67, 0xac68, 0xac69, 0xac6a, 0xac6b, 0xac6c, 0xac6d, 0xac6e,
	0xac6f, 0xac72, 0xac73, 0xac75, 0xac76, 0xac79, 0xac7b, 0xac7c,
	0xac7d, 0xac7e, 0xac7f, 0xac82, 0xac87, 0xac88, 0xac8d, 0xac8e,
	0xac8f, 0xac91, 0xac92, 0xac93, 0xac95, 0xac96, 0xac97, 0xac98,
	0xac99, 0xac9a, 0xac9b, 0xac9e, 0xaca2, 0xaca3, 0xaca4, 0xaca5,
	0xaca6, 0xaca7, 0xacab, 0xacad, 0xacae, 0xacb1, 0xacb2, 0xacb3,
	0xacb4, 0xacb5, 0xacb6, 0xacb7, 0xacba, 0xacbe, 0xacbf, 0xacc0,
	0xacc2, 0xacc3, 0xacc5, 0xacc6, 0xacc7, 0xacc9, 0xacca, 0xaccb,
	0xaccd, 0xacce, 0xaccf, 0xacd0, 0xacd1, 0xacd2, 0xacd3, 0xacd4,
	0xacd6, 0xacd8, 0xacd9, 0xacda, 0xacdb, 0xacdc, 0xacdd, 0xacde,
	0xacdf, 0xace2, 0xace3, 0xace5, 0xace6, 0xace9, 0xaceb, 0xaced,
	0xacee, 0xacf2, 0xacf4, 0xacf7, 0xacf8, 0xacf9, 0xacfa, 0xacfb,
	0xacfe, 0xacff, 0xad01, 0xad02, 0xad03, 0xad05, 0xad07, 0xad08,
	0xad09, 0xad0a, 0xad0b, 0xad0e, 0xad10, 0xad12, 0xad13, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8240[ 192 ] = {
	0xfffd, 0xad14, 0xad15, 0xad16, 0xad17, 0xad19, 0xad1a, 0xad1b,
	0xad1d, 0xad1e, 0xad1f, 0xad21, 0xad22, 0xad23, 0xad24, 0xad25,
	0xad26, 0xad27, 0xad28, 0xad2a, 0xad2b, 0xad2e, 0xad2f, 0xad30,
	0xad31, 0xad32, 0xad33, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xad36, 0xad37, 0xad39, 0xad3a, 0xad3b, 0xad3d, 0xad3e,
	0xad3f, 0xad40, 0xad41, 0xad42, 0xad43, 0xad46, 0xad48, 0xad4a,
	0xad4b, 0xad4c, 0xad4d, 0xad4e, 0xad4f, 0xad51, 0xad52, 0xad53,
	0xad55, 0xad56, 0xad57, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xad59, 0xad5a, 0xad5b, 0xad5c, 0xad5d, 0xad5e, 0xad5f,
	0xad60, 0xad62, 0xad64, 0xad65, 0xad66, 0xad67, 0xad68, 0xad69,
	0xad6a, 0xad6b, 0xad6e, 0xad6f, 0xad71, 0xad72, 0xad77, 0xad78,
	0xad79, 0xad7a, 0xad7e, 0xad80, 0xad83, 0xad84, 0xad85, 0xad86,
	0xad87, 0xad8a, 0xad8b, 0xad8d, 0xad8e, 0xad8f, 0xad91, 0xad92,
	0xad93, 0xad94, 0xad95, 0xad96, 0xad97, 0xad98, 0xad99, 0xad9a,
	0xad9b, 0xad9e, 0xad9f, 0xada0, 0xada1, 0xada2, 0xada3, 0xada5,
	0xada6, 0xada7, 0xada8, 0xada9, 0xadaa, 0xadab, 0xadac, 0xadad,
	0xadae, 0xadaf, 0xadb0, 0xadb1, 0xadb2, 0xadb3, 0xadb4, 0xadb5,
	0xadb6, 0xadb8, 0xadb9, 0xadba, 0xadbb, 0xadbc, 0xadbd, 0xadbe,
	0xadbf, 0xadc2, 0xadc3, 0xadc5, 0xadc6, 0xadc7, 0xadc9, 0xadca,
	0xadcb, 0xadcc, 0xadcd, 0xadce, 0xadcf, 0xadd2, 0xadd4, 0xadd5,
	0xadd6, 0xadd7, 0xadd8, 0xadd9, 0xadda, 0xaddb, 0xaddd, 0xadde,
	0xaddf, 0xade1, 0xade2, 0xade3, 0xade5, 0xade6, 0xade7, 0xade8,
	0xade9, 0xadea, 0xadeb, 0xadec, 0xaded, 0xadee, 0xadef, 0xadf0,
	0xadf1, 0xadf2, 0xadf3, 0xadf4, 0xadf5, 0xadf6, 0xadf7, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8340[ 192 ] = {
	0xfffd, 0xadfa, 0xadfb, 0xadfd, 0xadfe, 0xae02, 0xae03, 0xae04,
	0xae05, 0xae06, 0xae07, 0xae0a, 0xae0c, 0xae0e, 0xae0f, 0xae10,
	0xae11, 0xae12, 0xae13, 0xae15, 0xae16, 0xae17, 0xae18, 0xae19,
	0xae1a, 0xae1b, 0xae1c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xae1d, 0xae1e, 0xae1f, 0xae20, 0xae21, 0xae22, 0xae23,
	0xae24, 0xae25, 0xae26, 0xae27, 0xae28, 0xae29, 0xae2a, 0xae2b,
	0xae2c, 0xae2d, 0xae2e, 0xae2f, 0xae32, 0xae33, 0xae35, 0xae36,
	0xae39, 0xae3b, 0xae3c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xae3d, 0xae3e, 0xae3f, 0xae42, 0xae44, 0xae47, 0xae48,
	0xae49, 0xae4b, 0xae4f, 0xae51, 0xae52, 0xae53, 0xae55, 0xae57,
	0xae58, 0xae59, 0xae5a, 0xae5b, 0xae5e, 0xae62, 0xae63, 0xae64,
	0xae66, 0xae67, 0xae6a, 0xae6b, 0xae6d, 0xae6e, 0xae6f, 0xae71,
	0xae72, 0xae73, 0xae74, 0xae75, 0xae76, 0xae77, 0xae7a, 0xae7e,
	0xae7f, 0xae80, 0xae81, 0xae82, 0xae83, 0xae86, 0xae87, 0xae88,
	0xae89, 0xae8a, 0xae8b, 0xae8d, 0xae8e, 0xae8f, 0xae90, 0xae91,
	0xae92, 0xae93, 0xae94, 0xae95, 0xae96, 0xae97, 0xae98, 0xae99,
	0xae9a, 0xae9b, 0xae9c, 0xae9d, 0xae9e, 0xae9f, 0xaea0, 0xaea1,
	0xaea2, 0xaea3, 0xaea4, 0xaea5, 0xaea6, 0xaea7, 0xaea8, 0xaea9,
	0xaeaa, 0xaeab, 0xaeac, 0xaead, 0xaeae, 0xaeaf, 0xaeb0, 0xaeb1,
	0xaeb2, 0xaeb3, 0xaeb4, 0xaeb5, 0xaeb6, 0xaeb7, 0xaeb8, 0xaeb9,
	0xaeba, 0xaebb, 0xaebf, 0xaec1, 0xaec2, 0xaec3, 0xaec5, 0xaec6,
	0xaec7, 0xaec8, 0xaec9, 0xaeca, 0xaecb, 0xaece, 0xaed2, 0xaed3,
	0xaed4, 0xaed5, 0xaed6, 0xaed7, 0xaeda, 0xaedb, 0xaedd, 0xaede,
	0xaedf, 0xaee0, 0xaee1, 0xaee2, 0xaee3, 0xaee4, 0xaee5, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8440[ 192 ] = {
	0xfffd, 0xaee6, 0xaee7, 0xaee9, 0xaeea, 0xaeec, 0xaeee, 0xaeef,
	0xaef0, 0xaef1, 0xaef2, 0xaef3, 0xaef5, 0xaef6, 0xaef7, 0xaef9,
	0xaefa, 0xaefb, 0xaefd, 0xaefe, 0xaeff, 0xaf00, 0xaf01, 0xaf02,
	0xaf03, 0xaf04, 0xaf05, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xaf06, 0xaf09, 0xaf0a, 0xaf0b, 0xaf0c, 0xaf0e, 0xaf0f,
	0xaf11, 0xaf12, 0xaf13, 0xaf14, 0xaf15, 0xaf16, 0xaf17, 0xaf18,
	0xaf19, 0xaf1a, 0xaf1b, 0xaf1c, 0xaf1d, 0xaf1e, 0xaf1f, 0xaf20,
	0xaf21, 0xaf22, 0xaf23, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xaf24, 0xaf25, 0xaf26, 0xaf27, 0xaf28, 0xaf29, 0xaf2a,
	0xaf2b, 0xaf2e, 0xaf2f, 0xaf31, 0xaf33, 0xaf35, 0xaf36, 0xaf37,
	0xaf38, 0xaf39, 0xaf3a, 0xaf3b, 0xaf3e, 0xaf40, 0xaf44, 0xaf45,
	0xaf46, 0xaf47, 0xaf4a, 0xaf4b, 0xaf4c, 0xaf4d, 0xaf4e, 0xaf4f,
	0xaf51, 0xaf52, 0xaf53, 0xaf54, 0xaf55, 0xaf56, 0xaf57, 0xaf58,
	0xaf59, 0xaf5a, 0xaf5b, 0xaf5e, 0xaf5f, 0xaf60, 0xaf61, 0xaf62,
	0xaf63, 0xaf66, 0xaf67, 0xaf68, 0xaf69, 0xaf6a, 0xaf6b, 0xaf6c,
	0xaf6d, 0xaf6e, 0xaf6f, 0xaf70, 0xaf71, 0xaf72, 0xaf73, 0xaf74,
	0xaf75, 0xaf76, 0xaf77, 0xaf78, 0xaf7a, 0xaf7b, 0xaf7c, 0xaf7d,
	0xaf7e, 0xaf7f, 0xaf81, 0xaf82, 0xaf83, 0xaf85, 0xaf86, 0xaf87,
	0xaf89, 0xaf8a, 0xaf8b, 0xaf8c, 0xaf8d, 0xaf8e, 0xaf8f, 0xaf92,
	0xaf93, 0xaf94, 0xaf96, 0xaf97, 0xaf98, 0xaf99, 0xaf9a, 0xaf9b,
	0xaf9d, 0xaf9e, 0xaf9f, 0xafa0, 0xafa1, 0xafa2, 0xafa3, 0xafa4,
	0xafa5, 0xafa6, 0xafa7, 0xafa8, 0xafa9, 0xafaa, 0xafab, 0xafac,
	0xafad, 0xafae, 0xafaf, 0xafb0, 0xafb1, 0xafb2, 0xafb3, 0xafb4,
	0xafb5, 0xafb6, 0xafb7, 0xafba, 0xafbb, 0xafbd, 0xafbe, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8540[ 192 ] = {
	0xfffd, 0xafbf, 0xafc1, 0xafc2, 0xafc3, 0xafc4, 0xafc5, 0xafc6,
	0xafca, 0xafcc, 0xafcf, 0xafd0, 0xafd1, 0xafd2, 0xafd3, 0xafd5,
	0xafd6, 0xafd7, 0xafd8, 0xafd9, 0xafda, 0xafdb, 0xafdd, 0xafde,
	0xafdf, 0xafe0, 0xafe1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xafe2, 0xafe3, 0xafe4, 0xafe5, 0xafe6, 0xafe7, 0xafea,
	0xafeb, 0xafec, 0xafed, 0xafee, 0xafef, 0xaff2, 0xaff3, 0xaff5,
	0xaff6, 0xaff7, 0xaff9, 0xaffa, 0xaffb, 0xaffc, 0xaffd, 0xaffe,
	0xafff, 0xb002, 0xb003, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb005, 0xb006, 0xb007, 0xb008, 0xb009, 0xb00a, 0xb00b,
	0xb00d, 0xb00e, 0xb00f, 0xb011, 0xb012, 0xb013, 0xb015, 0xb016,
	0xb017, 0xb018, 0xb019, 0xb01a, 0xb01b, 0xb01e, 0xb01f, 0xb020,
	0xb021, 0xb022, 0xb023, 0xb024, 0xb025, 0xb026, 0xb027, 0xb029,
	0xb02a, 0xb02b, 0xb02c, 0xb02d, 0xb02e, 0xb02f, 0xb030, 0xb031,
	0xb032, 0xb033, 0xb034, 0xb035, 0xb036, 0xb037, 0xb038, 0xb039,
	0xb03a, 0xb03b, 0xb03c, 0xb03d, 0xb03e, 0xb03f, 0xb040, 0xb041,
	0xb042, 0xb043, 0xb046, 0xb047, 0xb049, 0xb04b, 0xb04d, 0xb04f,
	0xb050, 0xb051, 0xb052, 0xb056, 0xb058, 0xb05a, 0xb05b, 0xb05c,
	0xb05e, 0xb05f, 0xb060, 0xb061, 0xb062, 0xb063, 0xb064, 0xb065,
	0xb066, 0xb067, 0xb068, 0xb069, 0xb06a, 0xb06b, 0xb06c, 0xb06d,
	0xb06e, 0xb06f, 0xb070, 0xb071, 0xb072, 0xb073, 0xb074, 0xb075,
	0xb076, 0xb077, 0xb078, 0xb079, 0xb07a, 0xb07b, 0xb07e, 0xb07f,
	0xb081, 0xb082, 0xb083, 0xb085, 0xb086, 0xb087, 0xb088, 0xb089,
	0xb08a, 0xb08b, 0xb08e, 0xb090, 0xb092, 0xb093, 0xb094, 0xb095,
	0xb096, 0xb097, 0xb09b, 0xb09d, 0xb09e, 0xb0a3, 0xb0a4, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8640[ 192 ] = {
	0xfffd, 0xb0a5, 0xb0a6, 0xb0a7, 0xb0aa, 0xb0b0, 0xb0b2, 0xb0b6,
	0xb0b7, 0xb0b9, 0xb0ba, 0xb0bb, 0xb0bd, 0xb0be, 0xb0bf, 0xb0c0,
	0xb0c1, 0xb0c2, 0xb0c3, 0xb0c6, 0xb0ca, 0xb0cb, 0xb0cc, 0xb0cd,
	0xb0ce, 0xb0cf, 0xb0d2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb0d3, 0xb0d5, 0xb0d6, 0xb0d7, 0xb0d9, 0xb0da, 0xb0db,
	0xb0dc, 0xb0dd, 0xb0de, 0xb0df, 0xb0e1, 0xb0e2, 0xb0e3, 0xb0e4,
	0xb0e6, 0xb0e7, 0xb0e8, 0xb0e9, 0xb0ea, 0xb0eb, 0xb0ec, 0xb0ed,
	0xb0ee, 0xb0ef, 0xb0f0, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb0f1, 0xb0f2, 0xb0f3, 0xb0f4, 0xb0f5, 0xb0f6, 0xb0f7,
	0xb0f8, 0xb0f9, 0xb0fa, 0xb0fb, 0xb0fc, 0xb0fd, 0xb0fe, 0xb0ff,
	0xb100, 0xb101, 0xb102, 0xb103, 0xb104, 0xb105, 0xb106, 0xb107,
	0xb10a, 0xb10d, 0xb10e, 0xb10f, 0xb111, 0xb114, 0xb115, 0xb116,
	0xb117, 0xb11a, 0xb11e, 0xb11f, 0xb120, 0xb121, 0xb122, 0xb126,
	0xb127, 0xb129, 0xb12a, 0xb12b, 0xb12d, 0xb12e, 0xb12f, 0xb130,
	0xb131, 0xb132, 0xb133, 0xb136, 0xb13a, 0xb13b, 0xb13c, 0xb13d,
	0xb13e, 0xb13f, 0xb142, 0xb143, 0xb145, 0xb146, 0xb147, 0xb149,
	0xb14a, 0xb14b, 0xb14c, 0xb14d, 0xb14e, 0xb14f, 0xb152, 0xb153,
	0xb156, 0xb157, 0xb159, 0xb15a, 0xb15b, 0xb15d, 0xb15e, 0xb15f,
	0xb161, 0xb162, 0xb163, 0xb164, 0xb165, 0xb166, 0xb167, 0xb168,
	0xb169, 0xb16a, 0xb16b, 0xb16c, 0xb16d, 0xb16e, 0xb16f, 0xb170,
	0xb171, 0xb172, 0xb173, 0xb174, 0xb175, 0xb176, 0xb177, 0xb17a,
	0xb17b, 0xb17d, 0xb17e, 0xb17f, 0xb181, 0xb183, 0xb184, 0xb185,
	0xb186, 0xb187, 0xb18a, 0xb18c, 0xb18e, 0xb18f, 0xb190, 0xb191,
	0xb195, 0xb196, 0xb197, 0xb199, 0xb19a, 0xb19b, 0xb19d, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8740[ 192 ] = {
	0xfffd, 0xb19e, 0xb19f, 0xb1a0, 0xb1a1, 0xb1a2, 0xb1a3, 0xb1a4,
	0xb1a5, 0xb1a6, 0xb1a7, 0xb1a9, 0xb1aa, 0xb1ab, 0xb1ac, 0xb1ad,
	0xb1ae, 0xb1af, 0xb1b0, 0xb1b1, 0xb1b2, 0xb1b3, 0xb1b4, 0xb1b5,
	0xb1b6, 0xb1b7, 0xb1b8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb1b9, 0xb1ba, 0xb1bb, 0xb1bc, 0xb1bd, 0xb1be, 0xb1bf,
	0xb1c0, 0xb1c1, 0xb1c2, 0xb1c3, 0xb1c4, 0xb1c5, 0xb1c6, 0xb1c7,
	0xb1c8, 0xb1c9, 0xb1ca, 0xb1cb, 0xb1cd, 0xb1ce, 0xb1cf, 0xb1d1,
	0xb1d2, 0xb1d3, 0xb1d5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb1d6, 0xb1d7, 0xb1d8, 0xb1d9, 0xb1da, 0xb1db, 0xb1de,
	0xb1e0, 0xb1e1, 0xb1e2, 0xb1e3, 0xb1e4, 0xb1e5, 0xb1e6, 0xb1e7,
	0xb1ea, 0xb1eb, 0xb1ed, 0xb1ee, 0xb1ef, 0xb1f1, 0xb1f2, 0xb1f3,
	0xb1f4, 0xb1f5, 0xb1f6, 0xb1f7, 0xb1f8, 0xb1fa, 0xb1fc, 0xb1fe,
	0xb1ff, 0xb200, 0xb201, 0xb202, 0xb203, 0xb206, 0xb207, 0xb209,
	0xb20a, 0xb20d, 0xb20e, 0xb20f, 0xb210, 0xb211, 0xb212, 0xb213,
	0xb216, 0xb218, 0xb21a, 0xb21b, 0xb21c, 0xb21d, 0xb21e, 0xb21f,
	0xb221, 0xb222, 0xb223, 0xb224, 0xb225, 0xb226, 0xb227, 0xb228,
	0xb229, 0xb22a, 0xb22b, 0xb22c, 0xb22d, 0xb22e, 0xb22f, 0xb230,
	0xb231, 0xb232, 0xb233, 0xb235, 0xb236, 0xb237, 0xb238, 0xb239,
	0xb23a, 0xb23b, 0xb23d, 0xb23e, 0xb23f, 0xb240, 0xb241, 0xb242,
	0xb243, 0xb244, 0xb245, 0xb246, 0xb247, 0xb248, 0xb249, 0xb24a,
	0xb24b, 0xb24c, 0xb24d, 0xb24e, 0xb24f, 0xb250, 0xb251, 0xb252,
	0xb253, 0xb254, 0xb255, 0xb256, 0xb257, 0xb259, 0xb25a, 0xb25b,
	0xb25d, 0xb25e, 0xb25f, 0xb261, 0xb262, 0xb263, 0xb264, 0xb265,
	0xb266, 0xb267, 0xb26a, 0xb26b, 0xb26c, 0xb26d, 0xb26e, 0xfffd
};
	
const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8840[ 192 ] = {
	0xfffd, 0xb26f, 0xb270, 0xb271, 0xb272, 0xb273, 0xb276, 0xb277,
	0xb278, 0xb279, 0xb27a, 0xb27b, 0xb27d, 0xb27e, 0xb27f, 0xb280,
	0xb281, 0xb282, 0xb283, 0xb286, 0xb287, 0xb288, 0xb28a, 0xb28b,
	0xb28c, 0xb28d, 0xb28e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb28f, 0xb292, 0xb293, 0xb295, 0xb296, 0xb297, 0xb29b,
	0xb29c, 0xb29d, 0xb29e, 0xb29f, 0xb2a2, 0xb2a4, 0xb2a7, 0xb2a8,
	0xb2a9, 0xb2ab, 0xb2ad, 0xb2ae, 0xb2af, 0xb2b1, 0xb2b2, 0xb2b3,
	0xb2b5, 0xb2b6, 0xb2b7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb2b8, 0xb2b9, 0xb2ba, 0xb2bb, 0xb2bc, 0xb2bd, 0xb2be,
	0xb2bf, 0xb2c0, 0xb2c1, 0xb2c2, 0xb2c3, 0xb2c4, 0xb2c5, 0xb2c6,
	0xb2c7, 0xb2ca, 0xb2cb, 0xb2cd, 0xb2ce, 0xb2cf, 0xb2d1, 0xb2d3,
	0xb2d4, 0xb2d5, 0xb2d6, 0xb2d7, 0xb2da, 0xb2dc, 0xb2de, 0xb2df,
	0xb2e0, 0xb2e1, 0xb2e3, 0xb2e7, 0xb2e9, 0xb2ea, 0xb2f0, 0xb2f1,
	0xb2f2, 0xb2f6, 0xb2fc, 0xb2fd, 0xb2fe, 0xb302, 0xb303, 0xb305,
	0xb306, 0xb307, 0xb309, 0xb30a, 0xb30b, 0xb30c, 0xb30d, 0xb30e,
	0xb30f, 0xb312, 0xb316, 0xb317, 0xb318, 0xb319, 0xb31a, 0xb31b,
	0xb31d, 0xb31e, 0xb31f, 0xb320, 0xb321, 0xb322, 0xb323, 0xb324,
	0xb325, 0xb326, 0xb327, 0xb328, 0xb329, 0xb32a, 0xb32b, 0xb32c,
	0xb32d, 0xb32e, 0xb32f, 0xb330, 0xb331, 0xb332, 0xb333, 0xb334,
	0xb335, 0xb336, 0xb337, 0xb338, 0xb339, 0xb33a, 0xb33b, 0xb33c,
	0xb33d, 0xb33e, 0xb33f, 0xb340, 0xb341, 0xb342, 0xb343, 0xb344,
	0xb345, 0xb346, 0xb347, 0xb348, 0xb349, 0xb34a, 0xb34b, 0xb34c,
	0xb34d, 0xb34e, 0xb34f, 0xb350, 0xb351, 0xb352, 0xb353, 0xb357,
	0xb359, 0xb35a, 0xb35d, 0xb360, 0xb361, 0xb362, 0xb363, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8940[ 192 ] = {
	0xfffd, 0xb366, 0xb368, 0xb36a, 0xb36c, 0xb36d, 0xb36f, 0xb372,
	0xb373, 0xb375, 0xb376, 0xb377, 0xb379, 0xb37a, 0xb37b, 0xb37c,
	0xb37d, 0xb37e, 0xb37f, 0xb382, 0xb386, 0xb387, 0xb388, 0xb389,
	0xb38a, 0xb38b, 0xb38d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb38e, 0xb38f, 0xb391, 0xb392, 0xb393, 0xb395, 0xb396,
	0xb397, 0xb398, 0xb399, 0xb39a, 0xb39b, 0xb39c, 0xb39d, 0xb39e,
	0xb39f, 0xb3a2, 0xb3a3, 0xb3a4, 0xb3a5, 0xb3a6, 0xb3a7, 0xb3a9,
	0xb3aa, 0xb3ab, 0xb3ad, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb3ae, 0xb3af, 0xb3b0, 0xb3b1, 0xb3b2, 0xb3b3, 0xb3b4,
	0xb3b5, 0xb3b6, 0xb3b7, 0xb3b8, 0xb3b9, 0xb3ba, 0xb3bb, 0xb3bc,
	0xb3bd, 0xb3be, 0xb3bf, 0xb3c0, 0xb3c1, 0xb3c2, 0xb3c3, 0xb3c6,
	0xb3c7, 0xb3c9, 0xb3ca, 0xb3cd, 0xb3cf, 0xb3d1, 0xb3d2, 0xb3d3,
	0xb3d6, 0xb3d8, 0xb3da, 0xb3dc, 0xb3de, 0xb3df, 0xb3e1, 0xb3e2,
	0xb3e3, 0xb3e5, 0xb3e6, 0xb3e7, 0xb3e9, 0xb3ea, 0xb3eb, 0xb3ec,
	0xb3ed, 0xb3ee, 0xb3ef, 0xb3f0, 0xb3f1, 0xb3f2, 0xb3f3, 0xb3f4,
	0xb3f5, 0xb3f6, 0xb3f7, 0xb3f8, 0xb3f9, 0xb3fa, 0xb3fb, 0xb3fd,
	0xb3fe, 0xb3ff, 0xb400, 0xb401, 0xb402, 0xb403, 0xb404, 0xb405,
	0xb406, 0xb407, 0xb408, 0xb409, 0xb40a, 0xb40b, 0xb40c, 0xb40d,
	0xb40e, 0xb40f, 0xb411, 0xb412, 0xb413, 0xb414, 0xb415, 0xb416,
	0xb417, 0xb419, 0xb41a, 0xb41b, 0xb41d, 0xb41e, 0xb41f, 0xb421,
	0xb422, 0xb423, 0xb424, 0xb425, 0xb426, 0xb427, 0xb42a, 0xb42c,
	0xb42d, 0xb42e, 0xb42f, 0xb430, 0xb431, 0xb432, 0xb433, 0xb435,
	0xb436, 0xb437, 0xb438, 0xb439, 0xb43a, 0xb43b, 0xb43c, 0xb43d,
	0xb43e, 0xb43f, 0xb440, 0xb441, 0xb442, 0xb443, 0xb444, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8a40[ 192 ] = {
	0xfffd, 0xb445, 0xb446, 0xb447, 0xb448, 0xb449, 0xb44a, 0xb44b,
	0xb44c, 0xb44d, 0xb44e, 0xb44f, 0xb452, 0xb453, 0xb455, 0xb456,
	0xb457, 0xb459, 0xb45a, 0xb45b, 0xb45c, 0xb45d, 0xb45e, 0xb45f,
	0xb462, 0xb464, 0xb466, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb467, 0xb468, 0xb469, 0xb46a, 0xb46b, 0xb46d, 0xb46e,
	0xb46f, 0xb470, 0xb471, 0xb472, 0xb473, 0xb474, 0xb475, 0xb476,
	0xb477, 0xb478, 0xb479, 0xb47a, 0xb47b, 0xb47c, 0xb47d, 0xb47e,
	0xb47f, 0xb481, 0xb482, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb483, 0xb484, 0xb485, 0xb486, 0xb487, 0xb489, 0xb48a,
	0xb48b, 0xb48c, 0xb48d, 0xb48e, 0xb48f, 0xb490, 0xb491, 0xb492,
	0xb493, 0xb494, 0xb495, 0xb496, 0xb497, 0xb498, 0xb499, 0xb49a,
	0xb49b, 0xb49c, 0xb49e, 0xb49f, 0xb4a0, 0xb4a1, 0xb4a2, 0xb4a3,
	0xb4a5, 0xb4a6, 0xb4a7, 0xb4a9, 0xb4aa, 0xb4ab, 0xb4ad, 0xb4ae,
	0xb4af, 0xb4b0, 0xb4b1, 0xb4b2, 0xb4b3, 0xb4b4, 0xb4b6, 0xb4b8,
	0xb4ba, 0xb4bb, 0xb4bc, 0xb4bd, 0xb4be, 0xb4bf, 0xb4c1, 0xb4c2,
	0xb4c3, 0xb4c5, 0xb4c6, 0xb4c7, 0xb4c9, 0xb4ca, 0xb4cb, 0xb4cc,
	0xb4cd, 0xb4ce, 0xb4cf, 0xb4d1, 0xb4d2, 0xb4d3, 0xb4d4, 0xb4d6,
	0xb4d7, 0xb4d8, 0xb4d9, 0xb4da, 0xb4db, 0xb4de, 0xb4df, 0xb4e1,
	0xb4e2, 0xb4e5, 0xb4e7, 0xb4e8, 0xb4e9, 0xb4ea, 0xb4eb, 0xb4ee,
	0xb4f0, 0xb4f2, 0xb4f3, 0xb4f4, 0xb4f5, 0xb4f6, 0xb4f7, 0xb4f9,
	0xb4fa, 0xb4fb, 0xb4fc, 0xb4fd, 0xb4fe, 0xb4ff, 0xb500, 0xb501,
	0xb502, 0xb503, 0xb504, 0xb505, 0xb506, 0xb507, 0xb508, 0xb509,
	0xb50a, 0xb50b, 0xb50c, 0xb50d, 0xb50e, 0xb50f, 0xb510, 0xb511,
	0xb512, 0xb513, 0xb516, 0xb517, 0xb519, 0xb51a, 0xb51d, 0xfffd
};
	
const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8b40[ 192 ] = {
	0xfffd, 0xb51e, 0xb51f, 0xb520, 0xb521, 0xb522, 0xb523, 0xb526,
	0xb52b, 0xb52c, 0xb52d, 0xb52e, 0xb52f, 0xb532, 0xb533, 0xb535,
	0xb536, 0xb537, 0xb539, 0xb53a, 0xb53b, 0xb53c, 0xb53d, 0xb53e,
	0xb53f, 0xb542, 0xb546, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb547, 0xb548, 0xb549, 0xb54a, 0xb54e, 0xb54f, 0xb551,
	0xb552, 0xb553, 0xb555, 0xb556, 0xb557, 0xb558, 0xb559, 0xb55a,
	0xb55b, 0xb55e, 0xb562, 0xb563, 0xb564, 0xb565, 0xb566, 0xb567,
	0xb568, 0xb569, 0xb56a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb56b, 0xb56c, 0xb56d, 0xb56e, 0xb56f, 0xb570, 0xb571,
	0xb572, 0xb573, 0xb574, 0xb575, 0xb576, 0xb577, 0xb578, 0xb579,
	0xb57a, 0xb57b, 0xb57c, 0xb57d, 0xb57e, 0xb57f, 0xb580, 0xb581,
	0xb582, 0xb583, 0xb584, 0xb585, 0xb586, 0xb587, 0xb588, 0xb589,
	0xb58a, 0xb58b, 0xb58c, 0xb58d, 0xb58e, 0xb58f, 0xb590, 0xb591,
	0xb592, 0xb593, 0xb594, 0xb595, 0xb596, 0xb597, 0xb598, 0xb599,
	0xb59a, 0xb59b, 0xb59c, 0xb59d, 0xb59e, 0xb59f, 0xb5a2, 0xb5a3,
	0xb5a5, 0xb5a6, 0xb5a7, 0xb5a9, 0xb5ac, 0xb5ad, 0xb5ae, 0xb5af,
	0xb5b2, 0xb5b6, 0xb5b7, 0xb5b8, 0xb5b9, 0xb5ba, 0xb5be, 0xb5bf,
	0xb5c1, 0xb5c2, 0xb5c3, 0xb5c5, 0xb5c6, 0xb5c7, 0xb5c8, 0xb5c9,
	0xb5ca, 0xb5cb, 0xb5ce, 0xb5d2, 0xb5d3, 0xb5d4, 0xb5d5, 0xb5d6,
	0xb5d7, 0xb5d9, 0xb5da, 0xb5db, 0xb5dc, 0xb5dd, 0xb5de, 0xb5df,
	0xb5e0, 0xb5e1, 0xb5e2, 0xb5e3, 0xb5e4, 0xb5e5, 0xb5e6, 0xb5e7,
	0xb5e8, 0xb5e9, 0xb5ea, 0xb5eb, 0xb5ed, 0xb5ee, 0xb5ef, 0xb5f0,
	0xb5f1, 0xb5f2, 0xb5f3, 0xb5f4, 0xb5f5, 0xb5f6, 0xb5f7, 0xb5f8,
	0xb5f9, 0xb5fa, 0xb5fb, 0xb5fc, 0xb5fd, 0xb5fe, 0xb5ff, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8c40[ 192 ] = {
	0xfffd, 0xb600, 0xb601, 0xb602, 0xb603, 0xb604, 0xb605, 0xb606,
	0xb607, 0xb608, 0xb609, 0xb60a, 0xb60b, 0xb60c, 0xb60d, 0xb60e,
	0xb60f, 0xb612, 0xb613, 0xb615, 0xb616, 0xb617, 0xb619, 0xb61a,
	0xb61b, 0xb61c, 0xb61d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb61e, 0xb61f, 0xb620, 0xb621, 0xb622, 0xb623, 0xb624,
	0xb626, 0xb627, 0xb628, 0xb629, 0xb62a, 0xb62b, 0xb62d, 0xb62e,
	0xb62f, 0xb630, 0xb631, 0xb632, 0xb633, 0xb635, 0xb636, 0xb637,
	0xb638, 0xb639, 0xb63a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb63b, 0xb63c, 0xb63d, 0xb63e, 0xb63f, 0xb640, 0xb641,
	0xb642, 0xb643, 0xb644, 0xb645, 0xb646, 0xb647, 0xb649, 0xb64a,
	0xb64b, 0xb64c, 0xb64d, 0xb64e, 0xb64f, 0xb650, 0xb651, 0xb652,
	0xb653, 0xb654, 0xb655, 0xb656, 0xb657, 0xb658, 0xb659, 0xb65a,
	0xb65b, 0xb65c, 0xb65d, 0xb65e, 0xb65f, 0xb660, 0xb661, 0xb662,
	0xb663, 0xb665, 0xb666, 0xb667, 0xb669, 0xb66a, 0xb66b, 0xb66c,
	0xb66d, 0xb66e, 0xb66f, 0xb670, 0xb671, 0xb672, 0xb673, 0xb674,
	0xb675, 0xb676, 0xb677, 0xb678, 0xb679, 0xb67a, 0xb67b, 0xb67c,
	0xb67d, 0xb67e, 0xb67f, 0xb680, 0xb681, 0xb682, 0xb683, 0xb684,
	0xb685, 0xb686, 0xb687, 0xb688, 0xb689, 0xb68a, 0xb68b, 0xb68c,
	0xb68d, 0xb68e, 0xb68f, 0xb690, 0xb691, 0xb692, 0xb693, 0xb694,
	0xb695, 0xb696, 0xb697, 0xb698, 0xb699, 0xb69a, 0xb69b, 0xb69e,
	0xb69f, 0xb6a1, 0xb6a2, 0xb6a3, 0xb6a5, 0xb6a6, 0xb6a7, 0xb6a8,
	0xb6a9, 0xb6aa, 0xb6ad, 0xb6ae, 0xb6af, 0xb6b0, 0xb6b2, 0xb6b3,
	0xb6b4, 0xb6b5, 0xb6b6, 0xb6b7, 0xb6b8, 0xb6b9, 0xb6ba, 0xb6bb,
	0xb6bc, 0xb6bd, 0xb6be, 0xb6bf, 0xb6c0, 0xb6c1, 0xb6c2, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8d40[ 192 ] = {
	0xfffd, 0xb6c3, 0xb6c4, 0xb6c5, 0xb6c6, 0xb6c7, 0xb6c8, 0xb6c9,
	0xb6ca, 0xb6cb, 0xb6cc, 0xb6cd, 0xb6ce, 0xb6cf, 0xb6d0, 0xb6d1,
	0xb6d2, 0xb6d3, 0xb6d5, 0xb6d6, 0xb6d7, 0xb6d8, 0xb6d9, 0xb6da,
	0xb6db, 0xb6dc, 0xb6dd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb6de, 0xb6df, 0xb6e0, 0xb6e1, 0xb6e2, 0xb6e3, 0xb6e4,
	0xb6e5, 0xb6e6, 0xb6e7, 0xb6e8, 0xb6e9, 0xb6ea, 0xb6eb, 0xb6ec,
	0xb6ed, 0xb6ee, 0xb6ef, 0xb6f1, 0xb6f2, 0xb6f3, 0xb6f5, 0xb6f6,
	0xb6f7, 0xb6f9, 0xb6fa, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb6fb, 0xb6fc, 0xb6fd, 0xb6fe, 0xb6ff, 0xb702, 0xb703,
	0xb704, 0xb706, 0xb707, 0xb708, 0xb709, 0xb70a, 0xb70b, 0xb70c,
	0xb70d, 0xb70e, 0xb70f, 0xb710, 0xb711, 0xb712, 0xb713, 0xb714,
	0xb715, 0xb716, 0xb717, 0xb718, 0xb719, 0xb71a, 0xb71b, 0xb71c,
	0xb71d, 0xb71e, 0xb71f, 0xb720, 0xb721, 0xb722, 0xb723, 0xb724,
	0xb725, 0xb726, 0xb727, 0xb72a, 0xb72b, 0xb72d, 0xb72e, 0xb731,
	0xb732, 0xb733, 0xb734, 0xb735, 0xb736, 0xb737, 0xb73a, 0xb73c,
	0xb73d, 0xb73e, 0xb73f, 0xb740, 0xb741, 0xb742, 0xb743, 0xb745,
	0xb746, 0xb747, 0xb749, 0xb74a, 0xb74b, 0xb74d, 0xb74e, 0xb74f,
	0xb750, 0xb751, 0xb752, 0xb753, 0xb756, 0xb757, 0xb758, 0xb759,
	0xb75a, 0xb75b, 0xb75c, 0xb75d, 0xb75e, 0xb75f, 0xb761, 0xb762,
	0xb763, 0xb765, 0xb766, 0xb767, 0xb769, 0xb76a, 0xb76b, 0xb76c,
	0xb76d, 0xb76e, 0xb76f, 0xb772, 0xb774, 0xb776, 0xb777, 0xb778,
	0xb779, 0xb77a, 0xb77b, 0xb77e, 0xb77f, 0xb781, 0xb782, 0xb783,
	0xb785, 0xb786, 0xb787, 0xb788, 0xb789, 0xb78a, 0xb78b, 0xb78e,
	0xb793, 0xb794, 0xb795, 0xb79a, 0xb79b, 0xb79d, 0xb79e, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8e40[ 192 ] = {
	0xfffd, 0xb79f, 0xb7a1, 0xb7a2, 0xb7a3, 0xb7a4, 0xb7a5, 0xb7a6,
	0xb7a7, 0xb7aa, 0xb7ae, 0xb7af, 0xb7b0, 0xb7b1, 0xb7b2, 0xb7b3,
	0xb7b6, 0xb7b7, 0xb7b9, 0xb7ba, 0xb7bb, 0xb7bc, 0xb7bd, 0xb7be,
	0xb7bf, 0xb7c0, 0xb7c1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb7c2, 0xb7c3, 0xb7c4, 0xb7c5, 0xb7c6, 0xb7c8, 0xb7ca,
	0xb7cb, 0xb7cc, 0xb7cd, 0xb7ce, 0xb7cf, 0xb7d0, 0xb7d1, 0xb7d2,
	0xb7d3, 0xb7d4, 0xb7d5, 0xb7d6, 0xb7d7, 0xb7d8, 0xb7d9, 0xb7da,
	0xb7db, 0xb7dc, 0xb7dd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb7de, 0xb7df, 0xb7e0, 0xb7e1, 0xb7e2, 0xb7e3, 0xb7e4,
	0xb7e5, 0xb7e6, 0xb7e7, 0xb7e8, 0xb7e9, 0xb7ea, 0xb7eb, 0xb7ee,
	0xb7ef, 0xb7f1, 0xb7f2, 0xb7f3, 0xb7f5, 0xb7f6, 0xb7f7, 0xb7f8,
	0xb7f9, 0xb7fa, 0xb7fb, 0xb7fe, 0xb802, 0xb803, 0xb804, 0xb805,
	0xb806, 0xb80a, 0xb80b, 0xb80d, 0xb80e, 0xb80f, 0xb811, 0xb812,
	0xb813, 0xb814, 0xb815, 0xb816, 0xb817, 0xb81a, 0xb81c, 0xb81e,
	0xb81f, 0xb820, 0xb821, 0xb822, 0xb823, 0xb826, 0xb827, 0xb829,
	0xb82a, 0xb82b, 0xb82d, 0xb82e, 0xb82f, 0xb830, 0xb831, 0xb832,
	0xb833, 0xb836, 0xb83a, 0xb83b, 0xb83c, 0xb83d, 0xb83e, 0xb83f,
	0xb841, 0xb842, 0xb843, 0xb845, 0xb846, 0xb847, 0xb848, 0xb849,
	0xb84a, 0xb84b, 0xb84c, 0xb84d, 0xb84e, 0xb84f, 0xb850, 0xb852,
	0xb854, 0xb855, 0xb856, 0xb857, 0xb858, 0xb859, 0xb85a, 0xb85b,
	0xb85e, 0xb85f, 0xb861, 0xb862, 0xb863, 0xb865, 0xb866, 0xb867,
	0xb868, 0xb869, 0xb86a, 0xb86b, 0xb86e, 0xb870, 0xb872, 0xb873,
	0xb874, 0xb875, 0xb876, 0xb877, 0xb879, 0xb87a, 0xb87b, 0xb87d,
	0xb87e, 0xb87f, 0xb880, 0xb881, 0xb882, 0xb883, 0xb884, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8f40[ 192 ] = {
	0xfffd, 0xb885, 0xb886, 0xb887, 0xb888, 0xb889, 0xb88a, 0xb88b,
	0xb88c, 0xb88e, 0xb88f, 0xb890, 0xb891, 0xb892, 0xb893, 0xb894,
	0xb895, 0xb896, 0xb897, 0xb898, 0xb899, 0xb89a, 0xb89b, 0xb89c,
	0xb89d, 0xb89e, 0xb89f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb8a0, 0xb8a1, 0xb8a2, 0xb8a3, 0xb8a4, 0xb8a5, 0xb8a6,
	0xb8a7, 0xb8a9, 0xb8aa, 0xb8ab, 0xb8ac, 0xb8ad, 0xb8ae, 0xb8af,
	0xb8b1, 0xb8b2, 0xb8b3, 0xb8b5, 0xb8b6, 0xb8b7, 0xb8b9, 0xb8ba,
	0xb8bb, 0xb8bc, 0xb8bd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb8be, 0xb8bf, 0xb8c2, 0xb8c4, 0xb8c6, 0xb8c7, 0xb8c8,
	0xb8c9, 0xb8ca, 0xb8cb, 0xb8cd, 0xb8ce, 0xb8cf, 0xb8d1, 0xb8d2,
	0xb8d3, 0xb8d5, 0xb8d6, 0xb8d7, 0xb8d8, 0xb8d9, 0xb8da, 0xb8db,
	0xb8dc, 0xb8de, 0xb8e0, 0xb8e2, 0xb8e3, 0xb8e4, 0xb8e5, 0xb8e6,
	0xb8e7, 0xb8ea, 0xb8eb, 0xb8ed, 0xb8ee, 0xb8ef, 0xb8f1, 0xb8f2,
	0xb8f3, 0xb8f4, 0xb8f5, 0xb8f6, 0xb8f7, 0xb8fa, 0xb8fc, 0xb8fe,
	0xb8ff, 0xb900, 0xb901, 0xb902, 0xb903, 0xb905, 0xb906, 0xb907,
	0xb908, 0xb909, 0xb90a, 0xb90b, 0xb90c, 0xb90d, 0xb90e, 0xb90f,
	0xb910, 0xb911, 0xb912, 0xb913, 0xb914, 0xb915, 0xb916, 0xb917,
	0xb919, 0xb91a, 0xb91b, 0xb91c, 0xb91d, 0xb91e, 0xb91f, 0xb921,
	0xb922, 0xb923, 0xb924, 0xb925, 0xb926, 0xb927, 0xb928, 0xb929,
	0xb92a, 0xb92b, 0xb92c, 0xb92d, 0xb92e, 0xb92f, 0xb930, 0xb931,
	0xb932, 0xb933, 0xb934, 0xb935, 0xb936, 0xb937, 0xb938, 0xb939,
	0xb93a, 0xb93b, 0xb93e, 0xb93f, 0xb941, 0xb942, 0xb943, 0xb945,
	0xb946, 0xb947, 0xb948, 0xb949, 0xb94a, 0xb94b, 0xb94d, 0xb94e,
	0xb950, 0xb952, 0xb953, 0xb954, 0xb955, 0xb956, 0xb957, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9040[ 192 ] = {
	0xfffd, 0xb95a, 0xb95b, 0xb95d, 0xb95e, 0xb95f, 0xb961, 0xb962,
	0xb963, 0xb964, 0xb965, 0xb966, 0xb967, 0xb96a, 0xb96c, 0xb96e,
	0xb96f, 0xb970, 0xb971, 0xb972, 0xb973, 0xb976, 0xb977, 0xb979,
	0xb97a, 0xb97b, 0xb97d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb97e, 0xb97f, 0xb980, 0xb981, 0xb982, 0xb983, 0xb986,
	0xb988, 0xb98b, 0xb98c, 0xb98f, 0xb990, 0xb991, 0xb992, 0xb993,
	0xb994, 0xb995, 0xb996, 0xb997, 0xb998, 0xb999, 0xb99a, 0xb99b,
	0xb99c, 0xb99d, 0xb99e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xb99f, 0xb9a0, 0xb9a1, 0xb9a2, 0xb9a3, 0xb9a4, 0xb9a5,
	0xb9a6, 0xb9a7, 0xb9a8, 0xb9a9, 0xb9aa, 0xb9ab, 0xb9ae, 0xb9af,
	0xb9b1, 0xb9b2, 0xb9b3, 0xb9b5, 0xb9b6, 0xb9b7, 0xb9b8, 0xb9b9,
	0xb9ba, 0xb9bb, 0xb9be, 0xb9c0, 0xb9c2, 0xb9c3, 0xb9c4, 0xb9c5,
	0xb9c6, 0xb9c7, 0xb9ca, 0xb9cb, 0xb9cd, 0xb9d3, 0xb9d4, 0xb9d5,
	0xb9d6, 0xb9d7, 0xb9da, 0xb9dc, 0xb9df, 0xb9e0, 0xb9e2, 0xb9e6,
	0xb9e7, 0xb9e9, 0xb9ea, 0xb9eb, 0xb9ed, 0xb9ee, 0xb9ef, 0xb9f0,
	0xb9f1, 0xb9f2, 0xb9f3, 0xb9f6, 0xb9fb, 0xb9fc, 0xb9fd, 0xb9fe,
	0xb9ff, 0xba02, 0xba03, 0xba04, 0xba05, 0xba06, 0xba07, 0xba09,
	0xba0a, 0xba0b, 0xba0c, 0xba0d, 0xba0e, 0xba0f, 0xba10, 0xba11,
	0xba12, 0xba13, 0xba14, 0xba16, 0xba17, 0xba18, 0xba19, 0xba1a,
	0xba1b, 0xba1c, 0xba1d, 0xba1e, 0xba1f, 0xba20, 0xba21, 0xba22,
	0xba23, 0xba24, 0xba25, 0xba26, 0xba27, 0xba28, 0xba29, 0xba2a,
	0xba2b, 0xba2c, 0xba2d, 0xba2e, 0xba2f, 0xba30, 0xba31, 0xba32,
	0xba33, 0xba34, 0xba35, 0xba36, 0xba37, 0xba3a, 0xba3b, 0xba3d,
	0xba3e, 0xba3f, 0xba41, 0xba43, 0xba44, 0xba45, 0xba46, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9140[ 192 ] = {
	0xfffd, 0xba47, 0xba4a, 0xba4c, 0xba4f, 0xba50, 0xba51, 0xba52,
	0xba56, 0xba57, 0xba59, 0xba5a, 0xba5b, 0xba5d, 0xba5e, 0xba5f,
	0xba60, 0xba61, 0xba62, 0xba63, 0xba66, 0xba6a, 0xba6b, 0xba6c,
	0xba6d, 0xba6e, 0xba6f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xba72, 0xba73, 0xba75, 0xba76, 0xba77, 0xba79, 0xba7a,
	0xba7b, 0xba7c, 0xba7d, 0xba7e, 0xba7f, 0xba80, 0xba81, 0xba82,
	0xba86, 0xba88, 0xba89, 0xba8a, 0xba8b, 0xba8d, 0xba8e, 0xba8f,
	0xba90, 0xba91, 0xba92, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xba93, 0xba94, 0xba95, 0xba96, 0xba97, 0xba98, 0xba99,
	0xba9a, 0xba9b, 0xba9c, 0xba9d, 0xba9e, 0xba9f, 0xbaa0, 0xbaa1,
	0xbaa2, 0xbaa3, 0xbaa4, 0xbaa5, 0xbaa6, 0xbaa7, 0xbaaa, 0xbaad,
	0xbaae, 0xbaaf, 0xbab1, 0xbab3, 0xbab4, 0xbab5, 0xbab6, 0xbab7,
	0xbaba, 0xbabc, 0xbabe, 0xbabf, 0xbac0, 0xbac1, 0xbac2, 0xbac3,
	0xbac5, 0xbac6, 0xbac7, 0xbac9, 0xbaca, 0xbacb, 0xbacc, 0xbacd,
	0xbace, 0xbacf, 0xbad0, 0xbad1, 0xbad2, 0xbad3, 0xbad4, 0xbad5,
	0xbad6, 0xbad7, 0xbada, 0xbadb, 0xbadc, 0xbadd, 0xbade, 0xbadf,
	0xbae0, 0xbae1, 0xbae2, 0xbae3, 0xbae4, 0xbae5, 0xbae6, 0xbae7,
	0xbae8, 0xbae9, 0xbaea, 0xbaeb, 0xbaec, 0xbaed, 0xbaee, 0xbaef,
	0xbaf0, 0xbaf1, 0xbaf2, 0xbaf3, 0xbaf4, 0xbaf5, 0xbaf6, 0xbaf7,
	0xbaf8, 0xbaf9, 0xbafa, 0xbafb, 0xbafd, 0xbafe, 0xbaff, 0xbb01,
	0xbb02, 0xbb03, 0xbb05, 0xbb06, 0xbb07, 0xbb08, 0xbb09, 0xbb0a,
	0xbb0b, 0xbb0c, 0xbb0e, 0xbb10, 0xbb12, 0xbb13, 0xbb14, 0xbb15,
	0xbb16, 0xbb17, 0xbb19, 0xbb1a, 0xbb1b, 0xbb1d, 0xbb1e, 0xbb1f,
	0xbb21, 0xbb22, 0xbb23, 0xbb24, 0xbb25, 0xbb26, 0xbb27, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9240[ 192 ] = {
	0xfffd, 0xbb28, 0xbb2a, 0xbb2c, 0xbb2d, 0xbb2e, 0xbb2f, 0xbb30,
	0xbb31, 0xbb32, 0xbb33, 0xbb37, 0xbb39, 0xbb3a, 0xbb3f, 0xbb40,
	0xbb41, 0xbb42, 0xbb43, 0xbb46, 0xbb48, 0xbb4a, 0xbb4b, 0xbb4c,
	0xbb4e, 0xbb51, 0xbb52, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbb53, 0xbb55, 0xbb56, 0xbb57, 0xbb59, 0xbb5a, 0xbb5b,
	0xbb5c, 0xbb5d, 0xbb5e, 0xbb5f, 0xbb60, 0xbb62, 0xbb64, 0xbb65,
	0xbb66, 0xbb67, 0xbb68, 0xbb69, 0xbb6a, 0xbb6b, 0xbb6d, 0xbb6e,
	0xbb6f, 0xbb70, 0xbb71, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbb72, 0xbb73, 0xbb74, 0xbb75, 0xbb76, 0xbb77, 0xbb78,
	0xbb79, 0xbb7a, 0xbb7b, 0xbb7c, 0xbb7d, 0xbb7e, 0xbb7f, 0xbb80,
	0xbb81, 0xbb82, 0xbb83, 0xbb84, 0xbb85, 0xbb86, 0xbb87, 0xbb89,
	0xbb8a, 0xbb8b, 0xbb8d, 0xbb8e, 0xbb8f, 0xbb91, 0xbb92, 0xbb93,
	0xbb94, 0xbb95, 0xbb96, 0xbb97, 0xbb98, 0xbb99, 0xbb9a, 0xbb9b,
	0xbb9c, 0xbb9d, 0xbb9e, 0xbb9f, 0xbba0, 0xbba1, 0xbba2, 0xbba3,
	0xbba5, 0xbba6, 0xbba7, 0xbba9, 0xbbaa, 0xbbab, 0xbbad, 0xbbae,
	0xbbaf, 0xbbb0, 0xbbb1, 0xbbb2, 0xbbb3, 0xbbb5, 0xbbb6, 0xbbb8,
	0xbbb9, 0xbbba, 0xbbbb, 0xbbbc, 0xbbbd, 0xbbbe, 0xbbbf, 0xbbc1,
	0xbbc2, 0xbbc3, 0xbbc5, 0xbbc6, 0xbbc7, 0xbbc9, 0xbbca, 0xbbcb,
	0xbbcc, 0xbbcd, 0xbbce, 0xbbcf, 0xbbd1, 0xbbd2, 0xbbd4, 0xbbd5,
	0xbbd6, 0xbbd7, 0xbbd8, 0xbbd9, 0xbbda, 0xbbdb, 0xbbdc, 0xbbdd,
	0xbbde, 0xbbdf, 0xbbe0, 0xbbe1, 0xbbe2, 0xbbe3, 0xbbe4, 0xbbe5,
	0xbbe6, 0xbbe7, 0xbbe8, 0xbbe9, 0xbbea, 0xbbeb, 0xbbec, 0xbbed,
	0xbbee, 0xbbef, 0xbbf0, 0xbbf1, 0xbbf2, 0xbbf3, 0xbbf4, 0xbbf5,
	0xbbf6, 0xbbf7, 0xbbfa, 0xbbfb, 0xbbfd, 0xbbfe, 0xbc01, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9340[ 192 ] = {
	0xfffd, 0xbc03, 0xbc04, 0xbc05, 0xbc06, 0xbc07, 0xbc0a, 0xbc0e,
	0xbc10, 0xbc12, 0xbc13, 0xbc19, 0xbc1a, 0xbc20, 0xbc21, 0xbc22,
	0xbc23, 0xbc26, 0xbc28, 0xbc2a, 0xbc2b, 0xbc2c, 0xbc2e, 0xbc2f,
	0xbc32, 0xbc33, 0xbc35, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbc36, 0xbc37, 0xbc39, 0xbc3a, 0xbc3b, 0xbc3c, 0xbc3d,
	0xbc3e, 0xbc3f, 0xbc42, 0xbc46, 0xbc47, 0xbc48, 0xbc4a, 0xbc4b,
	0xbc4e, 0xbc4f, 0xbc51, 0xbc52, 0xbc53, 0xbc54, 0xbc55, 0xbc56,
	0xbc57, 0xbc58, 0xbc59, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbc5a, 0xbc5b, 0xbc5c, 0xbc5e, 0xbc5f, 0xbc60, 0xbc61,
	0xbc62, 0xbc63, 0xbc64, 0xbc65, 0xbc66, 0xbc67, 0xbc68, 0xbc69,
	0xbc6a, 0xbc6b, 0xbc6c, 0xbc6d, 0xbc6e, 0xbc6f, 0xbc70, 0xbc71,
	0xbc72, 0xbc73, 0xbc74, 0xbc75, 0xbc76, 0xbc77, 0xbc78, 0xbc79,
	0xbc7a, 0xbc7b, 0xbc7c, 0xbc7d, 0xbc7e, 0xbc7f, 0xbc80, 0xbc81,
	0xbc82, 0xbc83, 0xbc86, 0xbc87, 0xbc89, 0xbc8a, 0xbc8d, 0xbc8f,
	0xbc90, 0xbc91, 0xbc92, 0xbc93, 0xbc96, 0xbc98, 0xbc9b, 0xbc9c,
	0xbc9d, 0xbc9e, 0xbc9f, 0xbca2, 0xbca3, 0xbca5, 0xbca6, 0xbca9,
	0xbcaa, 0xbcab, 0xbcac, 0xbcad, 0xbcae, 0xbcaf, 0xbcb2, 0xbcb6,
	0xbcb7, 0xbcb8, 0xbcb9, 0xbcba, 0xbcbb, 0xbcbe, 0xbcbf, 0xbcc1,
	0xbcc2, 0xbcc3, 0xbcc5, 0xbcc6, 0xbcc7, 0xbcc8, 0xbcc9, 0xbcca,
	0xbccb, 0xbccc, 0xbcce, 0xbcd2, 0xbcd3, 0xbcd4, 0xbcd6, 0xbcd7,
	0xbcd9, 0xbcda, 0xbcdb, 0xbcdd, 0xbcde, 0xbcdf, 0xbce0, 0xbce1,
	0xbce2, 0xbce3, 0xbce4, 0xbce5, 0xbce6, 0xbce7, 0xbce8, 0xbce9,
	0xbcea, 0xbceb, 0xbcec, 0xbced, 0xbcee, 0xbcef, 0xbcf0, 0xbcf1,
	0xbcf2, 0xbcf3, 0xbcf7, 0xbcf9, 0xbcfa, 0xbcfb, 0xbcfd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9440[ 192 ] = {
	0xfffd, 0xbcfe, 0xbcff, 0xbd00, 0xbd01, 0xbd02, 0xbd03, 0xbd06,
	0xbd08, 0xbd0a, 0xbd0b, 0xbd0c, 0xbd0d, 0xbd0e, 0xbd0f, 0xbd11,
	0xbd12, 0xbd13, 0xbd15, 0xbd16, 0xbd17, 0xbd18, 0xbd19, 0xbd1a,
	0xbd1b, 0xbd1c, 0xbd1d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbd1e, 0xbd1f, 0xbd20, 0xbd21, 0xbd22, 0xbd23, 0xbd25,
	0xbd26, 0xbd27, 0xbd28, 0xbd29, 0xbd2a, 0xbd2b, 0xbd2d, 0xbd2e,
	0xbd2f, 0xbd30, 0xbd31, 0xbd32, 0xbd33, 0xbd34, 0xbd35, 0xbd36,
	0xbd37, 0xbd38, 0xbd39, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbd3a, 0xbd3b, 0xbd3c, 0xbd3d, 0xbd3e, 0xbd3f, 0xbd41,
	0xbd42, 0xbd43, 0xbd44, 0xbd45, 0xbd46, 0xbd47, 0xbd4a, 0xbd4b,
	0xbd4d, 0xbd4e, 0xbd4f, 0xbd51, 0xbd52, 0xbd53, 0xbd54, 0xbd55,
	0xbd56, 0xbd57, 0xbd5a, 0xbd5b, 0xbd5c, 0xbd5d, 0xbd5e, 0xbd5f,
	0xbd60, 0xbd61, 0xbd62, 0xbd63, 0xbd65, 0xbd66, 0xbd67, 0xbd69,
	0xbd6a, 0xbd6b, 0xbd6c, 0xbd6d, 0xbd6e, 0xbd6f, 0xbd70, 0xbd71,
	0xbd72, 0xbd73, 0xbd74, 0xbd75, 0xbd76, 0xbd77, 0xbd78, 0xbd79,
	0xbd7a, 0xbd7b, 0xbd7c, 0xbd7d, 0xbd7e, 0xbd7f, 0xbd82, 0xbd83,
	0xbd85, 0xbd86, 0xbd8b, 0xbd8c, 0xbd8d, 0xbd8e, 0xbd8f, 0xbd92,
	0xbd94, 0xbd96, 0xbd97, 0xbd98, 0xbd9b, 0xbd9d, 0xbd9e, 0xbd9f,
	0xbda0, 0xbda1, 0xbda2, 0xbda3, 0xbda5, 0xbda6, 0xbda7, 0xbda8,
	0xbda9, 0xbdaa, 0xbdab, 0xbdac, 0xbdad, 0xbdae, 0xbdaf, 0xbdb1,
	0xbdb2, 0xbdb3, 0xbdb4, 0xbdb5, 0xbdb6, 0xbdb7, 0xbdb9, 0xbdba,
	0xbdbb, 0xbdbc, 0xbdbd, 0xbdbe, 0xbdbf, 0xbdc0, 0xbdc1, 0xbdc2,
	0xbdc3, 0xbdc4, 0xbdc5, 0xbdc6, 0xbdc7, 0xbdc8, 0xbdc9, 0xbdca,
	0xbdcb, 0xbdcc, 0xbdcd, 0xbdce, 0xbdcf, 0xbdd0, 0xbdd1, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9540[ 192 ] = {
	0xfffd, 0xbdd2, 0xbdd3, 0xbdd6, 0xbdd7, 0xbdd9, 0xbdda, 0xbddb,
	0xbddd, 0xbdde, 0xbddf, 0xbde0, 0xbde1, 0xbde2, 0xbde3, 0xbde4,
	0xbde5, 0xbde6, 0xbde7, 0xbde8, 0xbdea, 0xbdeb, 0xbdec, 0xbded,
	0xbdee, 0xbdef, 0xbdf1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbdf2, 0xbdf3, 0xbdf5, 0xbdf6, 0xbdf7, 0xbdf9, 0xbdfa,
	0xbdfb, 0xbdfc, 0xbdfd, 0xbdfe, 0xbdff, 0xbe01, 0xbe02, 0xbe04,
	0xbe06, 0xbe07, 0xbe08, 0xbe09, 0xbe0a, 0xbe0b, 0xbe0e, 0xbe0f,
	0xbe11, 0xbe12, 0xbe13, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbe15, 0xbe16, 0xbe17, 0xbe18, 0xbe19, 0xbe1a, 0xbe1b,
	0xbe1e, 0xbe20, 0xbe21, 0xbe22, 0xbe23, 0xbe24, 0xbe25, 0xbe26,
	0xbe27, 0xbe28, 0xbe29, 0xbe2a, 0xbe2b, 0xbe2c, 0xbe2d, 0xbe2e,
	0xbe2f, 0xbe30, 0xbe31, 0xbe32, 0xbe33, 0xbe34, 0xbe35, 0xbe36,
	0xbe37, 0xbe38, 0xbe39, 0xbe3a, 0xbe3b, 0xbe3c, 0xbe3d, 0xbe3e,
	0xbe3f, 0xbe40, 0xbe41, 0xbe42, 0xbe43, 0xbe46, 0xbe47, 0xbe49,
	0xbe4a, 0xbe4b, 0xbe4d, 0xbe4f, 0xbe50, 0xbe51, 0xbe52, 0xbe53,
	0xbe56, 0xbe58, 0xbe5c, 0xbe5d, 0xbe5e, 0xbe5f, 0xbe62, 0xbe63,
	0xbe65, 0xbe66, 0xbe67, 0xbe69, 0xbe6b, 0xbe6c, 0xbe6d, 0xbe6e,
	0xbe6f, 0xbe72, 0xbe76, 0xbe77, 0xbe78, 0xbe79, 0xbe7a, 0xbe7e,
	0xbe7f, 0xbe81, 0xbe82, 0xbe83, 0xbe85, 0xbe86, 0xbe87, 0xbe88,
	0xbe89, 0xbe8a, 0xbe8b, 0xbe8e, 0xbe92, 0xbe93, 0xbe94, 0xbe95,
	0xbe96, 0xbe97, 0xbe9a, 0xbe9b, 0xbe9c, 0xbe9d, 0xbe9e, 0xbe9f,
	0xbea0, 0xbea1, 0xbea2, 0xbea3, 0xbea4, 0xbea5, 0xbea6, 0xbea7,
	0xbea9, 0xbeaa, 0xbeab, 0xbeac, 0xbead, 0xbeae, 0xbeaf, 0xbeb0,
	0xbeb1, 0xbeb2, 0xbeb3, 0xbeb4, 0xbeb5, 0xbeb6, 0xbeb7, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9640[ 192 ] = {
	0xfffd, 0xbeb8, 0xbeb9, 0xbeba, 0xbebb, 0xbebc, 0xbebd, 0xbebe,
	0xbebf, 0xbec0, 0xbec1, 0xbec2, 0xbec3, 0xbec4, 0xbec5, 0xbec6,
	0xbec7, 0xbec8, 0xbec9, 0xbeca, 0xbecb, 0xbecc, 0xbecd, 0xbece,
	0xbecf, 0xbed2, 0xbed3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbed5, 0xbed6, 0xbed9, 0xbeda, 0xbedb, 0xbedc, 0xbedd,
	0xbede, 0xbedf, 0xbee1, 0xbee2, 0xbee6, 0xbee7, 0xbee8, 0xbee9,
	0xbeea, 0xbeeb, 0xbeed, 0xbeee, 0xbeef, 0xbef0, 0xbef1, 0xbef2,
	0xbef3, 0xbef4, 0xbef5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbef6, 0xbef7, 0xbef8, 0xbef9, 0xbefa, 0xbefb, 0xbefc,
	0xbefd, 0xbefe, 0xbeff, 0xbf00, 0xbf02, 0xbf03, 0xbf04, 0xbf05,
	0xbf06, 0xbf07, 0xbf0a, 0xbf0b, 0xbf0c, 0xbf0d, 0xbf0e, 0xbf0f,
	0xbf10, 0xbf11, 0xbf12, 0xbf13, 0xbf14, 0xbf15, 0xbf16, 0xbf17,
	0xbf1a, 0xbf1e, 0xbf1f, 0xbf20, 0xbf21, 0xbf22, 0xbf23, 0xbf24,
	0xbf25, 0xbf26, 0xbf27, 0xbf28, 0xbf29, 0xbf2a, 0xbf2b, 0xbf2c,
	0xbf2d, 0xbf2e, 0xbf2f, 0xbf30, 0xbf31, 0xbf32, 0xbf33, 0xbf34,
	0xbf35, 0xbf36, 0xbf37, 0xbf38, 0xbf39, 0xbf3a, 0xbf3b, 0xbf3c,
	0xbf3d, 0xbf3e, 0xbf3f, 0xbf42, 0xbf43, 0xbf45, 0xbf46, 0xbf47,
	0xbf49, 0xbf4a, 0xbf4b, 0xbf4c, 0xbf4d, 0xbf4e, 0xbf4f, 0xbf52,
	0xbf53, 0xbf54, 0xbf56, 0xbf57, 0xbf58, 0xbf59, 0xbf5a, 0xbf5b,
	0xbf5c, 0xbf5d, 0xbf5e, 0xbf5f, 0xbf60, 0xbf61, 0xbf62, 0xbf63,
	0xbf64, 0xbf65, 0xbf66, 0xbf67, 0xbf68, 0xbf69, 0xbf6a, 0xbf6b,
	0xbf6c, 0xbf6d, 0xbf6e, 0xbf6f, 0xbf70, 0xbf71, 0xbf72, 0xbf73,
	0xbf74, 0xbf75, 0xbf76, 0xbf77, 0xbf78, 0xbf79, 0xbf7a, 0xbf7b,
	0xbf7c, 0xbf7d, 0xbf7e, 0xbf7f, 0xbf80, 0xbf81, 0xbf82, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9740[ 192 ] = {
	0xfffd, 0xbf83, 0xbf84, 0xbf85, 0xbf86, 0xbf87, 0xbf88, 0xbf89,
	0xbf8a, 0xbf8b, 0xbf8c, 0xbf8d, 0xbf8e, 0xbf8f, 0xbf90, 0xbf91,
	0xbf92, 0xbf93, 0xbf95, 0xbf96, 0xbf97, 0xbf98, 0xbf99, 0xbf9a,
	0xbf9b, 0xbf9c, 0xbf9d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbf9e, 0xbf9f, 0xbfa0, 0xbfa1, 0xbfa2, 0xbfa3, 0xbfa4,
	0xbfa5, 0xbfa6, 0xbfa7, 0xbfa8, 0xbfa9, 0xbfaa, 0xbfab, 0xbfac,
	0xbfad, 0xbfae, 0xbfaf, 0xbfb1, 0xbfb2, 0xbfb3, 0xbfb4, 0xbfb5,
	0xbfb6, 0xbfb7, 0xbfb8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xbfb9, 0xbfba, 0xbfbb, 0xbfbc, 0xbfbd, 0xbfbe, 0xbfbf,
	0xbfc0, 0xbfc1, 0xbfc2, 0xbfc3, 0xbfc4, 0xbfc6, 0xbfc7, 0xbfc8,
	0xbfc9, 0xbfca, 0xbfcb, 0xbfce, 0xbfcf, 0xbfd1, 0xbfd2, 0xbfd3,
	0xbfd5, 0xbfd6, 0xbfd7, 0xbfd8, 0xbfd9, 0xbfda, 0xbfdb, 0xbfdd,
	0xbfde, 0xbfe0, 0xbfe2, 0xbfe3, 0xbfe4, 0xbfe5, 0xbfe6, 0xbfe7,
	0xbfe8, 0xbfe9, 0xbfea, 0xbfeb, 0xbfec, 0xbfed, 0xbfee, 0xbfef,
	0xbff0, 0xbff1, 0xbff2, 0xbff3, 0xbff4, 0xbff5, 0xbff6, 0xbff7,
	0xbff8, 0xbff9, 0xbffa, 0xbffb, 0xbffc, 0xbffd, 0xbffe, 0xbfff,
	0xc000, 0xc001, 0xc002, 0xc003, 0xc004, 0xc005, 0xc006, 0xc007,
	0xc008, 0xc009, 0xc00a, 0xc00b, 0xc00c, 0xc00d, 0xc00e, 0xc00f,
	0xc010, 0xc011, 0xc012, 0xc013, 0xc014, 0xc015, 0xc016, 0xc017,
	0xc018, 0xc019, 0xc01a, 0xc01b, 0xc01c, 0xc01d, 0xc01e, 0xc01f,
	0xc020, 0xc021, 0xc022, 0xc023, 0xc024, 0xc025, 0xc026, 0xc027,
	0xc028, 0xc029, 0xc02a, 0xc02b, 0xc02c, 0xc02d, 0xc02e, 0xc02f,
	0xc030, 0xc031, 0xc032, 0xc033, 0xc034, 0xc035, 0xc036, 0xc037,
	0xc038, 0xc039, 0xc03a, 0xc03b, 0xc03d, 0xc03e, 0xc03f, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9840[ 192 ] = {
	0xfffd, 0xc040, 0xc041, 0xc042, 0xc043, 0xc044, 0xc045, 0xc046,
	0xc047, 0xc048, 0xc049, 0xc04a, 0xc04b, 0xc04c, 0xc04d, 0xc04e,
	0xc04f, 0xc050, 0xc052, 0xc053, 0xc054, 0xc055, 0xc056, 0xc057,
	0xc059, 0xc05a, 0xc05b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc05d, 0xc05e, 0xc05f, 0xc061, 0xc062, 0xc063, 0xc064,
	0xc065, 0xc066, 0xc067, 0xc06a, 0xc06b, 0xc06c, 0xc06d, 0xc06e,
	0xc06f, 0xc070, 0xc071, 0xc072, 0xc073, 0xc074, 0xc075, 0xc076,
	0xc077, 0xc078, 0xc079, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc07a, 0xc07b, 0xc07c, 0xc07d, 0xc07e, 0xc07f, 0xc080,
	0xc081, 0xc082, 0xc083, 0xc084, 0xc085, 0xc086, 0xc087, 0xc088,
	0xc089, 0xc08a, 0xc08b, 0xc08c, 0xc08d, 0xc08e, 0xc08f, 0xc092,
	0xc093, 0xc095, 0xc096, 0xc097, 0xc099, 0xc09a, 0xc09b, 0xc09c,
	0xc09d, 0xc09e, 0xc09f, 0xc0a2, 0xc0a4, 0xc0a6, 0xc0a7, 0xc0a8,
	0xc0a9, 0xc0aa, 0xc0ab, 0xc0ae, 0xc0b1, 0xc0b2, 0xc0b7, 0xc0b8,
	0xc0b9, 0xc0ba, 0xc0bb, 0xc0be, 0xc0c2, 0xc0c3, 0xc0c4, 0xc0c6,
	0xc0c7, 0xc0ca, 0xc0cb, 0xc0cd, 0xc0ce, 0xc0cf, 0xc0d1, 0xc0d2,
	0xc0d3, 0xc0d4, 0xc0d5, 0xc0d6, 0xc0d7, 0xc0da, 0xc0de, 0xc0df,
	0xc0e0, 0xc0e1, 0xc0e2, 0xc0e3, 0xc0e6, 0xc0e7, 0xc0e9, 0xc0ea,
	0xc0eb, 0xc0ed, 0xc0ee, 0xc0ef, 0xc0f0, 0xc0f1, 0xc0f2, 0xc0f3,
	0xc0f6, 0xc0f8, 0xc0fa, 0xc0fb, 0xc0fc, 0xc0fd, 0xc0fe, 0xc0ff,
	0xc101, 0xc102, 0xc103, 0xc105, 0xc106, 0xc107, 0xc109, 0xc10a,
	0xc10b, 0xc10c, 0xc10d, 0xc10e, 0xc10f, 0xc111, 0xc112, 0xc113,
	0xc114, 0xc116, 0xc117, 0xc118, 0xc119, 0xc11a, 0xc11b, 0xc121,
	0xc122, 0xc125, 0xc128, 0xc129, 0xc12a, 0xc12b, 0xc12e, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9940[ 192 ] = {
	0xfffd, 0xc132, 0xc133, 0xc134, 0xc135, 0xc137, 0xc13a, 0xc13b,
	0xc13d, 0xc13e, 0xc13f, 0xc141, 0xc142, 0xc143, 0xc144, 0xc145,
	0xc146, 0xc147, 0xc14a, 0xc14e, 0xc14f, 0xc150, 0xc151, 0xc152,
	0xc153, 0xc156, 0xc157, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc159, 0xc15a, 0xc15b, 0xc15d, 0xc15e, 0xc15f, 0xc160,
	0xc161, 0xc162, 0xc163, 0xc166, 0xc16a, 0xc16b, 0xc16c, 0xc16d,
	0xc16e, 0xc16f, 0xc171, 0xc172, 0xc173, 0xc175, 0xc176, 0xc177,
	0xc179, 0xc17a, 0xc17b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc17c, 0xc17d, 0xc17e, 0xc17f, 0xc180, 0xc181, 0xc182,
	0xc183, 0xc184, 0xc186, 0xc187, 0xc188, 0xc189, 0xc18a, 0xc18b,
	0xc18f, 0xc191, 0xc192, 0xc193, 0xc195, 0xc197, 0xc198, 0xc199,
	0xc19a, 0xc19b, 0xc19e, 0xc1a0, 0xc1a2, 0xc1a3, 0xc1a4, 0xc1a6,
	0xc1a7, 0xc1aa, 0xc1ab, 0xc1ad, 0xc1ae, 0xc1af, 0xc1b1, 0xc1b2,
	0xc1b3, 0xc1b4, 0xc1b5, 0xc1b6, 0xc1b7, 0xc1b8, 0xc1b9, 0xc1ba,
	0xc1bb, 0xc1bc, 0xc1be, 0xc1bf, 0xc1c0, 0xc1c1, 0xc1c2, 0xc1c3,
	0xc1c5, 0xc1c6, 0xc1c7, 0xc1c9, 0xc1ca, 0xc1cb, 0xc1cd, 0xc1ce,
	0xc1cf, 0xc1d0, 0xc1d1, 0xc1d2, 0xc1d3, 0xc1d5, 0xc1d6, 0xc1d9,
	0xc1da, 0xc1db, 0xc1dc, 0xc1dd, 0xc1de, 0xc1df, 0xc1e1, 0xc1e2,
	0xc1e3, 0xc1e5, 0xc1e6, 0xc1e7, 0xc1e9, 0xc1ea, 0xc1eb, 0xc1ec,
	0xc1ed, 0xc1ee, 0xc1ef, 0xc1f2, 0xc1f4, 0xc1f5, 0xc1f6, 0xc1f7,
	0xc1f8, 0xc1f9, 0xc1fa, 0xc1fb, 0xc1fe, 0xc1ff, 0xc201, 0xc202,
	0xc203, 0xc205, 0xc206, 0xc207, 0xc208, 0xc209, 0xc20a, 0xc20b,
	0xc20e, 0xc210, 0xc212, 0xc213, 0xc214, 0xc215, 0xc216, 0xc217,
	0xc21a, 0xc21b, 0xc21d, 0xc21e, 0xc221, 0xc222, 0xc223, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9a40[ 192 ] = {
	0xfffd, 0xc224, 0xc225, 0xc226, 0xc227, 0xc22a, 0xc22c, 0xc22e,
	0xc230, 0xc233, 0xc235, 0xc236, 0xc237, 0xc238, 0xc239, 0xc23a,
	0xc23b, 0xc23c, 0xc23d, 0xc23e, 0xc23f, 0xc240, 0xc241, 0xc242,
	0xc243, 0xc244, 0xc245, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc246, 0xc247, 0xc249, 0xc24a, 0xc24b, 0xc24c, 0xc24d,
	0xc24e, 0xc24f, 0xc252, 0xc253, 0xc255, 0xc256, 0xc257, 0xc259,
	0xc25a, 0xc25b, 0xc25c, 0xc25d, 0xc25e, 0xc25f, 0xc261, 0xc262,
	0xc263, 0xc264, 0xc266, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc267, 0xc268, 0xc269, 0xc26a, 0xc26b, 0xc26e, 0xc26f,
	0xc271, 0xc272, 0xc273, 0xc275, 0xc276, 0xc277, 0xc278, 0xc279,
	0xc27a, 0xc27b, 0xc27e, 0xc280, 0xc282, 0xc283, 0xc284, 0xc285,
	0xc286, 0xc287, 0xc28a, 0xc28b, 0xc28c, 0xc28d, 0xc28e, 0xc28f,
	0xc291, 0xc292, 0xc293, 0xc294, 0xc295, 0xc296, 0xc297, 0xc299,
	0xc29a, 0xc29c, 0xc29e, 0xc29f, 0xc2a0, 0xc2a1, 0xc2a2, 0xc2a3,
	0xc2a6, 0xc2a7, 0xc2a9, 0xc2aa, 0xc2ab, 0xc2ae, 0xc2af, 0xc2b0,
	0xc2b1, 0xc2b2, 0xc2b3, 0xc2b6, 0xc2b8, 0xc2ba, 0xc2bb, 0xc2bc,
	0xc2bd, 0xc2be, 0xc2bf, 0xc2c0, 0xc2c1, 0xc2c2, 0xc2c3, 0xc2c4,
	0xc2c5, 0xc2c6, 0xc2c7, 0xc2c8, 0xc2c9, 0xc2ca, 0xc2cb, 0xc2cc,
	0xc2cd, 0xc2ce, 0xc2cf, 0xc2d0, 0xc2d1, 0xc2d2, 0xc2d3, 0xc2d4,
	0xc2d5, 0xc2d6, 0xc2d7, 0xc2d8, 0xc2d9, 0xc2da, 0xc2db, 0xc2de,
	0xc2df, 0xc2e1, 0xc2e2, 0xc2e5, 0xc2e6, 0xc2e7, 0xc2e8, 0xc2e9,
	0xc2ea, 0xc2ee, 0xc2f0, 0xc2f2, 0xc2f3, 0xc2f4, 0xc2f5, 0xc2f7,
	0xc2fa, 0xc2fd, 0xc2fe, 0xc2ff, 0xc301, 0xc302, 0xc303, 0xc304,
	0xc305, 0xc306, 0xc307, 0xc30a, 0xc30b, 0xc30e, 0xc30f, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9b40[ 192 ] = {
	0xfffd, 0xc310, 0xc311, 0xc312, 0xc316, 0xc317, 0xc319, 0xc31a,
	0xc31b, 0xc31d, 0xc31e, 0xc31f, 0xc320, 0xc321, 0xc322, 0xc323,
	0xc326, 0xc327, 0xc32a, 0xc32b, 0xc32c, 0xc32d, 0xc32e, 0xc32f,
	0xc330, 0xc331, 0xc332, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc333, 0xc334, 0xc335, 0xc336, 0xc337, 0xc338, 0xc339,
	0xc33a, 0xc33b, 0xc33c, 0xc33d, 0xc33e, 0xc33f, 0xc340, 0xc341,
	0xc342, 0xc343, 0xc344, 0xc346, 0xc347, 0xc348, 0xc349, 0xc34a,
	0xc34b, 0xc34c, 0xc34d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc34e, 0xc34f, 0xc350, 0xc351, 0xc352, 0xc353, 0xc354,
	0xc355, 0xc356, 0xc357, 0xc358, 0xc359, 0xc35a, 0xc35b, 0xc35c,
	0xc35d, 0xc35e, 0xc35f, 0xc360, 0xc361, 0xc362, 0xc363, 0xc364,
	0xc365, 0xc366, 0xc367, 0xc36a, 0xc36b, 0xc36d, 0xc36e, 0xc36f,
	0xc371, 0xc373, 0xc374, 0xc375, 0xc376, 0xc377, 0xc37a, 0xc37b,
	0xc37e, 0xc37f, 0xc380, 0xc381, 0xc382, 0xc383, 0xc385, 0xc386,
	0xc387, 0xc389, 0xc38a, 0xc38b, 0xc38d, 0xc38e, 0xc38f, 0xc390,
	0xc391, 0xc392, 0xc393, 0xc394, 0xc395, 0xc396, 0xc397, 0xc398,
	0xc399, 0xc39a, 0xc39b, 0xc39c, 0xc39d, 0xc39e, 0xc39f, 0xc3a0,
	0xc3a1, 0xc3a2, 0xc3a3, 0xc3a4, 0xc3a5, 0xc3a6, 0xc3a7, 0xc3a8,
	0xc3a9, 0xc3aa, 0xc3ab, 0xc3ac, 0xc3ad, 0xc3ae, 0xc3af, 0xc3b0,
	0xc3b1, 0xc3b2, 0xc3b3, 0xc3b4, 0xc3b5, 0xc3b6, 0xc3b7, 0xc3b8,
	0xc3b9, 0xc3ba, 0xc3bb, 0xc3bc, 0xc3bd, 0xc3be, 0xc3bf, 0xc3c1,
	0xc3c2, 0xc3c3, 0xc3c4, 0xc3c5, 0xc3c6, 0xc3c7, 0xc3c8, 0xc3c9,
	0xc3ca, 0xc3cb, 0xc3cc, 0xc3cd, 0xc3ce, 0xc3cf, 0xc3d0, 0xc3d1,
	0xc3d2, 0xc3d3, 0xc3d4, 0xc3d5, 0xc3d6, 0xc3d7, 0xc3da, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9c40[ 192 ] = {
	0xfffd, 0xc3db, 0xc3dd, 0xc3de, 0xc3e1, 0xc3e3, 0xc3e4, 0xc3e5,
	0xc3e6, 0xc3e7, 0xc3ea, 0xc3eb, 0xc3ec, 0xc3ee, 0xc3ef, 0xc3f0,
	0xc3f1, 0xc3f2, 0xc3f3, 0xc3f6, 0xc3f7, 0xc3f9, 0xc3fa, 0xc3fb,
	0xc3fc, 0xc3fd, 0xc3fe, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc3ff, 0xc400, 0xc401, 0xc402, 0xc403, 0xc404, 0xc405,
	0xc406, 0xc407, 0xc409, 0xc40a, 0xc40b, 0xc40c, 0xc40d, 0xc40e,
	0xc40f, 0xc411, 0xc412, 0xc413, 0xc414, 0xc415, 0xc416, 0xc417,
	0xc418, 0xc419, 0xc41a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc41b, 0xc41c, 0xc41d, 0xc41e, 0xc41f, 0xc420, 0xc421,
	0xc422, 0xc423, 0xc425, 0xc426, 0xc427, 0xc428, 0xc429, 0xc42a,
	0xc42b, 0xc42d, 0xc42e, 0xc42f, 0xc431, 0xc432, 0xc433, 0xc435,
	0xc436, 0xc437, 0xc438, 0xc439, 0xc43a, 0xc43b, 0xc43e, 0xc43f,
	0xc440, 0xc441, 0xc442, 0xc443, 0xc444, 0xc445, 0xc446, 0xc447,
	0xc449, 0xc44a, 0xc44b, 0xc44c, 0xc44d, 0xc44e, 0xc44f, 0xc450,
	0xc451, 0xc452, 0xc453, 0xc454, 0xc455, 0xc456, 0xc457, 0xc458,
	0xc459, 0xc45a, 0xc45b, 0xc45c, 0xc45d, 0xc45e, 0xc45f, 0xc460,
	0xc461, 0xc462, 0xc463, 0xc466, 0xc467, 0xc469, 0xc46a, 0xc46b,
	0xc46d, 0xc46e, 0xc46f, 0xc470, 0xc471, 0xc472, 0xc473, 0xc476,
	0xc477, 0xc478, 0xc47a, 0xc47b, 0xc47c, 0xc47d, 0xc47e, 0xc47f,
	0xc481, 0xc482, 0xc483, 0xc484, 0xc485, 0xc486, 0xc487, 0xc488,
	0xc489, 0xc48a, 0xc48b, 0xc48c, 0xc48d, 0xc48e, 0xc48f, 0xc490,
	0xc491, 0xc492, 0xc493, 0xc495, 0xc496, 0xc497, 0xc498, 0xc499,
	0xc49a, 0xc49b, 0xc49d, 0xc49e, 0xc49f, 0xc4a0, 0xc4a1, 0xc4a2,
	0xc4a3, 0xc4a4, 0xc4a5, 0xc4a6, 0xc4a7, 0xc4a8, 0xc4a9, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9d40[ 192 ] = {
	0xfffd, 0xc4aa, 0xc4ab, 0xc4ac, 0xc4ad, 0xc4ae, 0xc4af, 0xc4b0,
	0xc4b1, 0xc4b2, 0xc4b3, 0xc4b4, 0xc4b5, 0xc4b6, 0xc4b7, 0xc4b9,
	0xc4ba, 0xc4bb, 0xc4bd, 0xc4be, 0xc4bf, 0xc4c0, 0xc4c1, 0xc4c2,
	0xc4c3, 0xc4c4, 0xc4c5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc4c6, 0xc4c7, 0xc4c8, 0xc4c9, 0xc4ca, 0xc4cb, 0xc4cc,
	0xc4cd, 0xc4ce, 0xc4cf, 0xc4d0, 0xc4d1, 0xc4d2, 0xc4d3, 0xc4d4,
	0xc4d5, 0xc4d6, 0xc4d7, 0xc4d8, 0xc4d9, 0xc4da, 0xc4db, 0xc4dc,
	0xc4dd, 0xc4de, 0xc4df, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc4e0, 0xc4e1, 0xc4e2, 0xc4e3, 0xc4e4, 0xc4e5, 0xc4e6,
	0xc4e7, 0xc4e8, 0xc4ea, 0xc4eb, 0xc4ec, 0xc4ed, 0xc4ee, 0xc4ef,
	0xc4f2, 0xc4f3, 0xc4f5, 0xc4f6, 0xc4f7, 0xc4f9, 0xc4fb, 0xc4fc,
	0xc4fd, 0xc4fe, 0xc502, 0xc503, 0xc504, 0xc505, 0xc506, 0xc507,
	0xc508, 0xc509, 0xc50a, 0xc50b, 0xc50d, 0xc50e, 0xc50f, 0xc511,
	0xc512, 0xc513, 0xc515, 0xc516, 0xc517, 0xc518, 0xc519, 0xc51a,
	0xc51b, 0xc51d, 0xc51e, 0xc51f, 0xc520, 0xc521, 0xc522, 0xc523,
	0xc524, 0xc525, 0xc526, 0xc527, 0xc52a, 0xc52b, 0xc52d, 0xc52e,
	0xc52f, 0xc531, 0xc532, 0xc533, 0xc534, 0xc535, 0xc536, 0xc537,
	0xc53a, 0xc53c, 0xc53e, 0xc53f, 0xc540, 0xc541, 0xc542, 0xc543,
	0xc546, 0xc547, 0xc54b, 0xc54f, 0xc550, 0xc551, 0xc552, 0xc556,
	0xc55a, 0xc55b, 0xc55c, 0xc55f, 0xc562, 0xc563, 0xc565, 0xc566,
	0xc567, 0xc569, 0xc56a, 0xc56b, 0xc56c, 0xc56d, 0xc56e, 0xc56f,
	0xc572, 0xc576, 0xc577, 0xc578, 0xc579, 0xc57a, 0xc57b, 0xc57e,
	0xc57f, 0xc581, 0xc582, 0xc583, 0xc585, 0xc586, 0xc588, 0xc589,
	0xc58a, 0xc58b, 0xc58e, 0xc590, 0xc592, 0xc593, 0xc594, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9e40[ 192 ] = {
	0xfffd, 0xc596, 0xc599, 0xc59a, 0xc59b, 0xc59d, 0xc59e, 0xc59f,
	0xc5a1, 0xc5a2, 0xc5a3, 0xc5a4, 0xc5a5, 0xc5a6, 0xc5a7, 0xc5a8,
	0xc5aa, 0xc5ab, 0xc5ac, 0xc5ad, 0xc5ae, 0xc5af, 0xc5b0, 0xc5b1,
	0xc5b2, 0xc5b3, 0xc5b6, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc5b7, 0xc5ba, 0xc5bf, 0xc5c0, 0xc5c1, 0xc5c2, 0xc5c3,
	0xc5cb, 0xc5cd, 0xc5cf, 0xc5d2, 0xc5d3, 0xc5d5, 0xc5d6, 0xc5d7,
	0xc5d9, 0xc5da, 0xc5db, 0xc5dc, 0xc5dd, 0xc5de, 0xc5df, 0xc5e2,
	0xc5e4, 0xc5e6, 0xc5e7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc5e8, 0xc5e9, 0xc5ea, 0xc5eb, 0xc5ef, 0xc5f1, 0xc5f2,
	0xc5f3, 0xc5f5, 0xc5f8, 0xc5f9, 0xc5fa, 0xc5fb, 0xc602, 0xc603,
	0xc604, 0xc609, 0xc60a, 0xc60b, 0xc60d, 0xc60e, 0xc60f, 0xc611,
	0xc612, 0xc613, 0xc614, 0xc615, 0xc616, 0xc617, 0xc61a, 0xc61d,
	0xc61e, 0xc61f, 0xc620, 0xc621, 0xc622, 0xc623, 0xc626, 0xc627,
	0xc629, 0xc62a, 0xc62b, 0xc62f, 0xc631, 0xc632, 0xc636, 0xc638,
	0xc63a, 0xc63c, 0xc63d, 0xc63e, 0xc63f, 0xc642, 0xc643, 0xc645,
	0xc646, 0xc647, 0xc649, 0xc64a, 0xc64b, 0xc64c, 0xc64d, 0xc64e,
	0xc64f, 0xc652, 0xc656, 0xc657, 0xc658, 0xc659, 0xc65a, 0xc65b,
	0xc65e, 0xc65f, 0xc661, 0xc662, 0xc663, 0xc664, 0xc665, 0xc666,
	0xc667, 0xc668, 0xc669, 0xc66a, 0xc66b, 0xc66d, 0xc66e, 0xc670,
	0xc672, 0xc673, 0xc674, 0xc675, 0xc676, 0xc677, 0xc67a, 0xc67b,
	0xc67d, 0xc67e, 0xc67f, 0xc681, 0xc682, 0xc683, 0xc684, 0xc685,
	0xc686, 0xc687, 0xc68a, 0xc68c, 0xc68e, 0xc68f, 0xc690, 0xc691,
	0xc692, 0xc693, 0xc696, 0xc697, 0xc699, 0xc69a, 0xc69b, 0xc69d,
	0xc69e, 0xc69f, 0xc6a0, 0xc6a1, 0xc6a2, 0xc6a3, 0xc6a6, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9f40[ 192 ] = {
	0xfffd, 0xc6a8, 0xc6aa, 0xc6ab, 0xc6ac, 0xc6ad, 0xc6ae, 0xc6af,
	0xc6b2, 0xc6b3, 0xc6b5, 0xc6b6, 0xc6b7, 0xc6bb, 0xc6bc, 0xc6bd,
	0xc6be, 0xc6bf, 0xc6c2, 0xc6c4, 0xc6c6, 0xc6c7, 0xc6c8, 0xc6c9,
	0xc6ca, 0xc6cb, 0xc6ce, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc6cf, 0xc6d1, 0xc6d2, 0xc6d3, 0xc6d5, 0xc6d6, 0xc6d7,
	0xc6d8, 0xc6d9, 0xc6da, 0xc6db, 0xc6de, 0xc6df, 0xc6e2, 0xc6e3,
	0xc6e4, 0xc6e5, 0xc6e6, 0xc6e7, 0xc6ea, 0xc6eb, 0xc6ed, 0xc6ee,
	0xc6ef, 0xc6f1, 0xc6f2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc6f3, 0xc6f4, 0xc6f5, 0xc6f6, 0xc6f7, 0xc6fa, 0xc6fb,
	0xc6fc, 0xc6fe, 0xc6ff, 0xc700, 0xc701, 0xc702, 0xc703, 0xc706,
	0xc707, 0xc709, 0xc70a, 0xc70b, 0xc70d, 0xc70e, 0xc70f, 0xc710,
	0xc711, 0xc712, 0xc713, 0xc716, 0xc718, 0xc71a, 0xc71b, 0xc71c,
	0xc71d, 0xc71e, 0xc71f, 0xc722, 0xc723, 0xc725, 0xc726, 0xc727,
	0xc729, 0xc72a, 0xc72b, 0xc72c, 0xc72d, 0xc72e, 0xc72f, 0xc732,
	0xc734, 0xc736, 0xc738, 0xc739, 0xc73a, 0xc73b, 0xc73e, 0xc73f,
	0xc741, 0xc742, 0xc743, 0xc745, 0xc746, 0xc747, 0xc748, 0xc749,
	0xc74b, 0xc74e, 0xc750, 0xc759, 0xc75a, 0xc75b, 0xc75d, 0xc75e,
	0xc75f, 0xc761, 0xc762, 0xc763, 0xc764, 0xc765, 0xc766, 0xc767,
	0xc769, 0xc76a, 0xc76c, 0xc76d, 0xc76e, 0xc76f, 0xc770, 0xc771,
	0xc772, 0xc773, 0xc776, 0xc777, 0xc779, 0xc77a, 0xc77b, 0xc77f,
	0xc780, 0xc781, 0xc782, 0xc786, 0xc78b, 0xc78c, 0xc78d, 0xc78f,
	0xc792, 0xc793, 0xc795, 0xc799, 0xc79b, 0xc79c, 0xc79d, 0xc79e,
	0xc79f, 0xc7a2, 0xc7a7, 0xc7a8, 0xc7a9, 0xc7aa, 0xc7ab, 0xc7ae,
	0xc7af, 0xc7b1, 0xc7b2, 0xc7b3, 0xc7b5, 0xc7b6, 0xc7b7, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa040[ 192 ] = {
	0xfffd, 0xc7b8, 0xc7b9, 0xc7ba, 0xc7bb, 0xc7be, 0xc7c2, 0xc7c3,
	0xc7c4, 0xc7c5, 0xc7c6, 0xc7c7, 0xc7ca, 0xc7cb, 0xc7cd, 0xc7cf,
	0xc7d1, 0xc7d2, 0xc7d3, 0xc7d4, 0xc7d5, 0xc7d6, 0xc7d7, 0xc7d9,
	0xc7da, 0xc7db, 0xc7dc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc7de, 0xc7df, 0xc7e0, 0xc7e1, 0xc7e2, 0xc7e3, 0xc7e5,
	0xc7e6, 0xc7e7, 0xc7e9, 0xc7ea, 0xc7eb, 0xc7ed, 0xc7ee, 0xc7ef,
	0xc7f0, 0xc7f1, 0xc7f2, 0xc7f3, 0xc7f4, 0xc7f5, 0xc7f6, 0xc7f7,
	0xc7f8, 0xc7f9, 0xc7fa, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc7fb, 0xc7fc, 0xc7fd, 0xc7fe, 0xc7ff, 0xc802, 0xc803,
	0xc805, 0xc806, 0xc807, 0xc809, 0xc80b, 0xc80c, 0xc80d, 0xc80e,
	0xc80f, 0xc812, 0xc814, 0xc817, 0xc818, 0xc819, 0xc81a, 0xc81b,
	0xc81e, 0xc81f, 0xc821, 0xc822, 0xc823, 0xc825, 0xc826, 0xc827,
	0xc828, 0xc829, 0xc82a, 0xc82b, 0xc82e, 0xc830, 0xc832, 0xc833,
	0xc834, 0xc835, 0xc836, 0xc837, 0xc839, 0xc83a, 0xc83b, 0xc83d,
	0xc83e, 0xc83f, 0xc841, 0xc842, 0xc843, 0xc844, 0xc845, 0xc846,
	0xc847, 0xc84a, 0xc84b, 0xc84e, 0xc84f, 0xc850, 0xc851, 0xc852,
	0xc853, 0xc855, 0xc856, 0xc857, 0xc858, 0xc859, 0xc85a, 0xc85b,
	0xc85c, 0xc85d, 0xc85e, 0xc85f, 0xc860, 0xc861, 0xc862, 0xc863,
	0xc864, 0xc865, 0xc866, 0xc867, 0xc868, 0xc869, 0xc86a, 0xc86b,
	0xc86c, 0xc86d, 0xc86e, 0xc86f, 0xc872, 0xc873, 0xc875, 0xc876,
	0xc877, 0xc879, 0xc87b, 0xc87c, 0xc87d, 0xc87e, 0xc87f, 0xc882,
	0xc884, 0xc888, 0xc889, 0xc88a, 0xc88e, 0xc88f, 0xc890, 0xc891,
	0xc892, 0xc893, 0xc895, 0xc896, 0xc897, 0xc898, 0xc899, 0xc89a,
	0xc89b, 0xc89c, 0xc89e, 0xc8a0, 0xc8a2, 0xc8a3, 0xc8a4, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa140[ 192 ] = {
	0xfffd, 0xc8a5, 0xc8a6, 0xc8a7, 0xc8a9, 0xc8aa, 0xc8ab, 0xc8ac,
	0xc8ad, 0xc8ae, 0xc8af, 0xc8b0, 0xc8b1, 0xc8b2, 0xc8b3, 0xc8b4,
	0xc8b5, 0xc8b6, 0xc8b7, 0xc8b8, 0xc8b9, 0xc8ba, 0xc8bb, 0xc8be,
	0xc8bf, 0xc8c0, 0xc8c1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc8c2, 0xc8c3, 0xc8c5, 0xc8c6, 0xc8c7, 0xc8c9, 0xc8ca,
	0xc8cb, 0xc8cd, 0xc8ce, 0xc8cf, 0xc8d0, 0xc8d1, 0xc8d2, 0xc8d3,
	0xc8d6, 0xc8d8, 0xc8da, 0xc8db, 0xc8dc, 0xc8dd, 0xc8de, 0xc8df,
	0xc8e2, 0xc8e3, 0xc8e5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc8e6, 0xc8e7, 0xc8e8, 0xc8e9, 0xc8ea, 0xc8eb, 0xc8ec,
	0xc8ed, 0xc8ee, 0xc8ef, 0xc8f0, 0xc8f1, 0xc8f2, 0xc8f3, 0xc8f4,
	0xc8f6, 0xc8f7, 0xc8f8, 0xc8f9, 0xc8fa, 0xc8fb, 0xc8fe, 0xc8ff,
	0xc901, 0xc902, 0xc903, 0xc907, 0xc908, 0xc909, 0xc90a, 0xc90b,
	0xc90e, 0x3000, 0x3001, 0x3002, 0x00b7, 0x2025, 0x2026, 0x00a8,
	0x3003, 0x00ad, 0x2015, 0x2225, 0xff3c, 0x223c, 0x2018, 0x2019,
	0x201c, 0x201d, 0x3014, 0x3015, 0x3008, 0x3009, 0x300a, 0x300b,
	0x300c, 0x300d, 0x300e, 0x300f, 0x3010, 0x3011, 0x00b1, 0x00d7,
	0x00f7, 0x2260, 0x2264, 0x2265, 0x221e, 0x2234, 0x00b0, 0x2032,
	0x2033, 0x2103, 0x212b, 0xffe0, 0xffe1, 0xffe5, 0x2642, 0x2640,
	0x2220, 0x22a5, 0x2312, 0x2202, 0x2207, 0x2261, 0x2252, 0x00a7,
	0x203b, 0x2606, 0x2605, 0x25cb, 0x25cf, 0x25ce, 0x25c7, 0x25c6,
	0x25a1, 0x25a0, 0x25b3, 0x25b2, 0x25bd, 0x25bc, 0x2192, 0x2190,
	0x2191, 0x2193, 0x2194, 0x3013, 0x226a, 0x226b, 0x221a, 0x223d,
	0x221d, 0x2235, 0x222b, 0x222c, 0x2208, 0x220b, 0x2286, 0x2287,
	0x2282, 0x2283, 0x222a, 0x2229, 0x2227, 0x2228, 0xffe2, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa240[ 168 ] = {
	0xfffd, 0xc910, 0xc912, 0xc913, 0xc914, 0xc915, 0xc916, 0xc917,
	0xc919, 0xc91a, 0xc91b, 0xc91c, 0xc91d, 0xc91e, 0xc91f, 0xc920,
	0xc921, 0xc922, 0xc923, 0xc924, 0xc925, 0xc926, 0xc927, 0xc928,
	0xc929, 0xc92a, 0xc92b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc92d, 0xc92e, 0xc92f, 0xc930, 0xc931, 0xc932, 0xc933,
	0xc935, 0xc936, 0xc937, 0xc938, 0xc939, 0xc93a, 0xc93b, 0xc93c,
	0xc93d, 0xc93e, 0xc93f, 0xc940, 0xc941, 0xc942, 0xc943, 0xc944,
	0xc945, 0xc946, 0xc947, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc948, 0xc949, 0xc94a, 0xc94b, 0xc94c, 0xc94d, 0xc94e,
	0xc94f, 0xc952, 0xc953, 0xc955, 0xc956, 0xc957, 0xc959, 0xc95a,
	0xc95b, 0xc95c, 0xc95d, 0xc95e, 0xc95f, 0xc962, 0xc964, 0xc965,
	0xc966, 0xc967, 0xc968, 0xc969, 0xc96a, 0xc96b, 0xc96d, 0xc96e,
	0xc96f, 0x21d2, 0x21d4, 0x2200, 0x2203, 0x00b4, 0xff5e, 0x02c7,
	0x02d8, 0x02dd, 0x02da, 0x02d9, 0x00b8, 0x02db, 0x00a1, 0x00bf,
	0x02d0, 0x222e, 0x2211, 0x220f, 0x00a4, 0x2109, 0x2030, 0x25c1,
	0x25c0, 0x25b7, 0x25b6, 0x2664, 0x2660, 0x2661, 0x2665, 0x2667,
	0x2663, 0x2299, 0x25c8, 0x25a3, 0x25d0, 0x25d1, 0x2592, 0x25a4,
	0x25a5, 0x25a8, 0x25a7, 0x25a6, 0x25a9, 0x2668, 0x260f, 0x260e,
	0x261c, 0x261e, 0x00b6, 0x2020, 0x2021, 0x2195, 0x2197, 0x2199,
	0x2196, 0x2198, 0x266d, 0x2669, 0x266a, 0x266c, 0x327f, 0x321c,
	0x2116, 0x33c7, 0x2122, 0x33c2, 0x33d8, 0x2121, 0x20ac, 0x00ae
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa340[ 192 ] = {
	0xfffd, 0xc971, 0xc972, 0xc973, 0xc975, 0xc976, 0xc977, 0xc978,
	0xc979, 0xc97a, 0xc97b, 0xc97d, 0xc97e, 0xc97f, 0xc980, 0xc981,
	0xc982, 0xc983, 0xc984, 0xc985, 0xc986, 0xc987, 0xc98a, 0xc98b,
	0xc98d, 0xc98e, 0xc98f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc991, 0xc992, 0xc993, 0xc994, 0xc995, 0xc996, 0xc997,
	0xc99a, 0xc99c, 0xc99e, 0xc99f, 0xc9a0, 0xc9a1, 0xc9a2, 0xc9a3,
	0xc9a4, 0xc9a5, 0xc9a6, 0xc9a7, 0xc9a8, 0xc9a9, 0xc9aa, 0xc9ab,
	0xc9ac, 0xc9ad, 0xc9ae, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xc9af, 0xc9b0, 0xc9b1, 0xc9b2, 0xc9b3, 0xc9b4, 0xc9b5,
	0xc9b6, 0xc9b7, 0xc9b8, 0xc9b9, 0xc9ba, 0xc9bb, 0xc9bc, 0xc9bd,
	0xc9be, 0xc9bf, 0xc9c2, 0xc9c3, 0xc9c5, 0xc9c6, 0xc9c9, 0xc9cb,
	0xc9cc, 0xc9cd, 0xc9ce, 0xc9cf, 0xc9d2, 0xc9d4, 0xc9d7, 0xc9d8,
	0xc9db, 0xff01, 0xff02, 0xff03, 0xff04, 0xff05, 0xff06, 0xff07,
	0xff08, 0xff09, 0xff0a, 0xff0b, 0xff0c, 0xff0d, 0xff0e, 0xff0f,
	0xff10, 0xff11, 0xff12, 0xff13, 0xff14, 0xff15, 0xff16, 0xff17,
	0xff18, 0xff19, 0xff1a, 0xff1b, 0xff1c, 0xff1d, 0xff1e, 0xff1f,
	0xff20, 0xff21, 0xff22, 0xff23, 0xff24, 0xff25, 0xff26, 0xff27,
	0xff28, 0xff29, 0xff2a, 0xff2b, 0xff2c, 0xff2d, 0xff2e, 0xff2f,
	0xff30, 0xff31, 0xff32, 0xff33, 0xff34, 0xff35, 0xff36, 0xff37,
	0xff38, 0xff39, 0xff3a, 0xff3b, 0xffe6, 0xff3d, 0xff3e, 0xff3f,
	0xff40, 0xff41, 0xff42, 0xff43, 0xff44, 0xff45, 0xff46, 0xff47,
	0xff48, 0xff49, 0xff4a, 0xff4b, 0xff4c, 0xff4d, 0xff4e, 0xff4f,
	0xff50, 0xff51, 0xff52, 0xff53, 0xff54, 0xff55, 0xff56, 0xff57,
	0xff58, 0xff59, 0xff5a, 0xff5b, 0xff5c, 0xff5d, 0xffe3, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa440[ 192 ] = {
	0xfffd, 0xc9de, 0xc9df, 0xc9e1, 0xc9e3, 0xc9e5, 0xc9e6, 0xc9e8,
	0xc9e9, 0xc9ea, 0xc9eb, 0xc9ee, 0xc9f2, 0xc9f3, 0xc9f4, 0xc9f5,
	0xc9f6, 0xc9f7, 0xc9fa, 0xc9fb, 0xc9fd, 0xc9fe, 0xc9ff, 0xca01,
	0xca02, 0xca03, 0xca04, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xca05, 0xca06, 0xca07, 0xca0a, 0xca0e, 0xca0f, 0xca10,
	0xca11, 0xca12, 0xca13, 0xca15, 0xca16, 0xca17, 0xca19, 0xca1a,
	0xca1b, 0xca1c, 0xca1d, 0xca1e, 0xca1f, 0xca20, 0xca21, 0xca22,
	0xca23, 0xca24, 0xca25, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xca26, 0xca27, 0xca28, 0xca2a, 0xca2b, 0xca2c, 0xca2d,
	0xca2e, 0xca2f, 0xca30, 0xca31, 0xca32, 0xca33, 0xca34, 0xca35,
	0xca36, 0xca37, 0xca38, 0xca39, 0xca3a, 0xca3b, 0xca3c, 0xca3d,
	0xca3e, 0xca3f, 0xca40, 0xca41, 0xca42, 0xca43, 0xca44, 0xca45,
	0xca46, 0x3131, 0x3132, 0x3133, 0x3134, 0x3135, 0x3136, 0x3137,
	0x3138, 0x3139, 0x313a, 0x313b, 0x313c, 0x313d, 0x313e, 0x313f,
	0x3140, 0x3141, 0x3142, 0x3143, 0x3144, 0x3145, 0x3146, 0x3147,
	0x3148, 0x3149, 0x314a, 0x314b, 0x314c, 0x314d, 0x314e, 0x314f,
	0x3150, 0x3151, 0x3152, 0x3153, 0x3154, 0x3155, 0x3156, 0x3157,
	0x3158, 0x3159, 0x315a, 0x315b, 0x315c, 0x315d, 0x315e, 0x315f,
	0x3160, 0x3161, 0x3162, 0x3163, 0x3164, 0x3165, 0x3166, 0x3167,
	0x3168, 0x3169, 0x316a, 0x316b, 0x316c, 0x316d, 0x316e, 0x316f,
	0x3170, 0x3171, 0x3172, 0x3173, 0x3174, 0x3175, 0x3176, 0x3177,
	0x3178, 0x3179, 0x317a, 0x317b, 0x317c, 0x317d, 0x317e, 0x317f,
	0x3180, 0x3181, 0x3182, 0x3183, 0x3184, 0x3185, 0x3186, 0x3187,
	0x3188, 0x3189, 0x318a, 0x318b, 0x318c, 0x318d, 0x318e, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa540[ 192 ] = {
	0xfffd, 0xca47, 0xca48, 0xca49, 0xca4a, 0xca4b, 0xca4e, 0xca4f,
	0xca51, 0xca52, 0xca53, 0xca55, 0xca56, 0xca57, 0xca58, 0xca59,
	0xca5a, 0xca5b, 0xca5e, 0xca62, 0xca63, 0xca64, 0xca65, 0xca66,
	0xca67, 0xca69, 0xca6a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xca6b, 0xca6c, 0xca6d, 0xca6e, 0xca6f, 0xca70, 0xca71,
	0xca72, 0xca73, 0xca74, 0xca75, 0xca76, 0xca77, 0xca78, 0xca79,
	0xca7a, 0xca7b, 0xca7c, 0xca7e, 0xca7f, 0xca80, 0xca81, 0xca82,
	0xca83, 0xca85, 0xca86, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xca87, 0xca88, 0xca89, 0xca8a, 0xca8b, 0xca8c, 0xca8d,
	0xca8e, 0xca8f, 0xca90, 0xca91, 0xca92, 0xca93, 0xca94, 0xca95,
	0xca96, 0xca97, 0xca99, 0xca9a, 0xca9b, 0xca9c, 0xca9d, 0xca9e,
	0xca9f, 0xcaa0, 0xcaa1, 0xcaa2, 0xcaa3, 0xcaa4, 0xcaa5, 0xcaa6,
	0xcaa7, 0x2170, 0x2171, 0x2172, 0x2173, 0x2174, 0x2175, 0x2176,
	0x2177, 0x2178, 0x2179, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165, 0x2166, 0x2167,
	0x2168, 0x2169, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395, 0x0396, 0x0397,
	0x0398, 0x0399, 0x039a, 0x039b, 0x039c, 0x039d, 0x039e, 0x039f,
	0x03a0, 0x03a1, 0x03a3, 0x03a4, 0x03a5, 0x03a6, 0x03a7, 0x03a8,
	0x03a9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0x03b1, 0x03b2, 0x03b3, 0x03b4, 0x03b5, 0x03b6, 0x03b7,
	0x03b8, 0x03b9, 0x03ba, 0x03bb, 0x03bc, 0x03bd, 0x03be, 0x03bf,
	0x03c0, 0x03c1, 0x03c3, 0x03c4, 0x03c5, 0x03c6, 0x03c7, 0x03c8,
	0x03c9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa640[ 168 ] = {
	0xfffd, 0xcaa8, 0xcaa9, 0xcaaa, 0xcaab, 0xcaac, 0xcaad, 0xcaae,
	0xcaaf, 0xcab0, 0xcab1, 0xcab2, 0xcab3, 0xcab4, 0xcab5, 0xcab6,
	0xcab7, 0xcab8, 0xcab9, 0xcaba, 0xcabb, 0xcabe, 0xcabf, 0xcac1,
	0xcac2, 0xcac3, 0xcac5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcac6, 0xcac7, 0xcac8, 0xcac9, 0xcaca, 0xcacb, 0xcace,
	0xcad0, 0xcad2, 0xcad4, 0xcad5, 0xcad6, 0xcad7, 0xcada, 0xcadb,
	0xcadc, 0xcadd, 0xcade, 0xcadf, 0xcae1, 0xcae2, 0xcae3, 0xcae4,
	0xcae5, 0xcae6, 0xcae7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcae8, 0xcae9, 0xcaea, 0xcaeb, 0xcaed, 0xcaee, 0xcaef,
	0xcaf0, 0xcaf1, 0xcaf2, 0xcaf3, 0xcaf5, 0xcaf6, 0xcaf7, 0xcaf8,
	0xcaf9, 0xcafa, 0xcafb, 0xcafc, 0xcafd, 0xcafe, 0xcaff, 0xcb00,
	0xcb01, 0xcb02, 0xcb03, 0xcb04, 0xcb05, 0xcb06, 0xcb07, 0xcb09,
	0xcb0a, 0x2500, 0x2502, 0x250c, 0x2510, 0x2518, 0x2514, 0x251c,
	0x252c, 0x2524, 0x2534, 0x253c, 0x2501, 0x2503, 0x250f, 0x2513,
	0x251b, 0x2517, 0x2523, 0x2533, 0x252b, 0x253b, 0x254b, 0x2520,
	0x252f, 0x2528, 0x2537, 0x253f, 0x251d, 0x2530, 0x2525, 0x2538,
	0x2542, 0x2512, 0x2511, 0x251a, 0x2519, 0x2516, 0x2515, 0x250e,
	0x250d, 0x251e, 0x251f, 0x2521, 0x2522, 0x2526, 0x2527, 0x2529,
	0x252a, 0x252d, 0x252e, 0x2531, 0x2532, 0x2535, 0x2536, 0x2539,
	0x253a, 0x253d, 0x253e, 0x2540, 0x2541, 0x2543, 0x2544, 0x2545,
	0x2546, 0x2547, 0x2548, 0x2549, 0x254a, 0xfffd, 0xfffd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa740[ 176 ] = {
	0xfffd, 0xcb0b, 0xcb0c, 0xcb0d, 0xcb0e, 0xcb0f, 0xcb11, 0xcb12,
	0xcb13, 0xcb15, 0xcb16, 0xcb17, 0xcb19, 0xcb1a, 0xcb1b, 0xcb1c,
	0xcb1d, 0xcb1e, 0xcb1f, 0xcb22, 0xcb23, 0xcb24, 0xcb25, 0xcb26,
	0xcb27, 0xcb28, 0xcb29, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcb2a, 0xcb2b, 0xcb2c, 0xcb2d, 0xcb2e, 0xcb2f, 0xcb30,
	0xcb31, 0xcb32, 0xcb33, 0xcb34, 0xcb35, 0xcb36, 0xcb37, 0xcb38,
	0xcb39, 0xcb3a, 0xcb3b, 0xcb3c, 0xcb3d, 0xcb3e, 0xcb3f, 0xcb40,
	0xcb42, 0xcb43, 0xcb44, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcb45, 0xcb46, 0xcb47, 0xcb4a, 0xcb4b, 0xcb4d, 0xcb4e,
	0xcb4f, 0xcb51, 0xcb52, 0xcb53, 0xcb54, 0xcb55, 0xcb56, 0xcb57,
	0xcb5a, 0xcb5b, 0xcb5c, 0xcb5e, 0xcb5f, 0xcb60, 0xcb61, 0xcb62,
	0xcb63, 0xcb65, 0xcb66, 0xcb67, 0xcb68, 0xcb69, 0xcb6a, 0xcb6b,
	0xcb6c, 0x3395, 0x3396, 0x3397, 0x2113, 0x3398, 0x33c4, 0x33a3,
	0x33a4, 0x33a5, 0x33a6, 0x3399, 0x339a, 0x339b, 0x339c, 0x339d,
	0x339e, 0x339f, 0x33a0, 0x33a1, 0x33a2, 0x33ca, 0x338d, 0x338e,
	0x338f, 0x33cf, 0x3388, 0x3389, 0x33c8, 0x33a7, 0x33a8, 0x33b0,
	0x33b1, 0x33b2, 0x33b3, 0x33b4, 0x33b5, 0x33b6, 0x33b7, 0x33b8,
	0x33b9, 0x3380, 0x3381, 0x3382, 0x3383, 0x3384, 0x33ba, 0x33bb,
	0x33bc, 0x33bd, 0x33be, 0x33bf, 0x3390, 0x3391, 0x3392, 0x3393,
	0x3394, 0x2126, 0x33c0, 0x33c1, 0x338a, 0x338b, 0x338c, 0x33d6,
	0x33c5, 0x33ad, 0x33ae, 0x33af, 0x33db, 0x33a9, 0x33aa, 0x33ab,
	0x33ac, 0x33dd, 0x33d0, 0x33d3, 0x33c3, 0x33c9, 0x33dc, 0x33c6
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa840[ 192 ] = {
	0xfffd, 0xcb6d, 0xcb6e, 0xcb6f, 0xcb70, 0xcb71, 0xcb72, 0xcb73,
	0xcb74, 0xcb75, 0xcb76, 0xcb77, 0xcb7a, 0xcb7b, 0xcb7c, 0xcb7d,
	0xcb7e, 0xcb7f, 0xcb80, 0xcb81, 0xcb82, 0xcb83, 0xcb84, 0xcb85,
	0xcb86, 0xcb87, 0xcb88, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcb89, 0xcb8a, 0xcb8b, 0xcb8c, 0xcb8d, 0xcb8e, 0xcb8f,
	0xcb90, 0xcb91, 0xcb92, 0xcb93, 0xcb94, 0xcb95, 0xcb96, 0xcb97,
	0xcb98, 0xcb99, 0xcb9a, 0xcb9b, 0xcb9d, 0xcb9e, 0xcb9f, 0xcba0,
	0xcba1, 0xcba2, 0xcba3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcba4, 0xcba5, 0xcba6, 0xcba7, 0xcba8, 0xcba9, 0xcbaa,
	0xcbab, 0xcbac, 0xcbad, 0xcbae, 0xcbaf, 0xcbb0, 0xcbb1, 0xcbb2,
	0xcbb3, 0xcbb4, 0xcbb5, 0xcbb6, 0xcbb7, 0xcbb9, 0xcbba, 0xcbbb,
	0xcbbc, 0xcbbd, 0xcbbe, 0xcbbf, 0xcbc0, 0xcbc1, 0xcbc2, 0xcbc3,
	0xcbc4, 0x00c6, 0x00d0, 0x00aa, 0x0126, 0xfffd, 0x0132, 0xfffd,
	0x013f, 0x0141, 0x00d8, 0x0152, 0x00ba, 0x00de, 0x0166, 0x014a,
	0xfffd, 0x3260, 0x3261, 0x3262, 0x3263, 0x3264, 0x3265, 0x3266,
	0x3267, 0x3268, 0x3269, 0x326a, 0x326b, 0x326c, 0x326d, 0x326e,
	0x326f, 0x3270, 0x3271, 0x3272, 0x3273, 0x3274, 0x3275, 0x3276,
	0x3277, 0x3278, 0x3279, 0x327a, 0x327b, 0x24d0, 0x24d1, 0x24d2,
	0x24d3, 0x24d4, 0x24d5, 0x24d6, 0x24d7, 0x24d8, 0x24d9, 0x24da,
	0x24db, 0x24dc, 0x24dd, 0x24de, 0x24df, 0x24e0, 0x24e1, 0x24e2,
	0x24e3, 0x24e4, 0x24e5, 0x24e6, 0x24e7, 0x24e8, 0x24e9, 0x2460,
	0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467, 0x2468,
	0x2469, 0x246a, 0x246b, 0x246c, 0x246d, 0x246e, 0x00bd, 0x2153,
	0x2154, 0x00bc, 0x00be, 0x215b, 0x215c, 0x215d, 0x215e, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa940[ 192 ] = {
	0xfffd, 0xcbc5, 0xcbc6, 0xcbc7, 0xcbc8, 0xcbc9, 0xcbca, 0xcbcb,
	0xcbcc, 0xcbcd, 0xcbce, 0xcbcf, 0xcbd0, 0xcbd1, 0xcbd2, 0xcbd3,
	0xcbd5, 0xcbd6, 0xcbd7, 0xcbd8, 0xcbd9, 0xcbda, 0xcbdb, 0xcbdc,
	0xcbdd, 0xcbde, 0xcbdf, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcbe0, 0xcbe1, 0xcbe2, 0xcbe3, 0xcbe5, 0xcbe6, 0xcbe8,
	0xcbea, 0xcbeb, 0xcbec, 0xcbed, 0xcbee, 0xcbef, 0xcbf0, 0xcbf1,
	0xcbf2, 0xcbf3, 0xcbf4, 0xcbf5, 0xcbf6, 0xcbf7, 0xcbf8, 0xcbf9,
	0xcbfa, 0xcbfb, 0xcbfc, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcbfd, 0xcbfe, 0xcbff, 0xcc00, 0xcc01, 0xcc02, 0xcc03,
	0xcc04, 0xcc05, 0xcc06, 0xcc07, 0xcc08, 0xcc09, 0xcc0a, 0xcc0b,
	0xcc0e, 0xcc0f, 0xcc11, 0xcc12, 0xcc13, 0xcc15, 0xcc16, 0xcc17,
	0xcc18, 0xcc19, 0xcc1a, 0xcc1b, 0xcc1e, 0xcc1f, 0xcc20, 0xcc23,
	0xcc24, 0x00e6, 0x0111, 0x00f0, 0x0127, 0x0131, 0x0133, 0x0138,
	0x0140, 0x0142, 0x00f8, 0x0153, 0x00df, 0x00fe, 0x0167, 0x014b,
	0x0149, 0x3200, 0x3201, 0x3202, 0x3203, 0x3204, 0x3205, 0x3206,
	0x3207, 0x3208, 0x3209, 0x320a, 0x320b, 0x320c, 0x320d, 0x320e,
	0x320f, 0x3210, 0x3211, 0x3212, 0x3213, 0x3214, 0x3215, 0x3216,
	0x3217, 0x3218, 0x3219, 0x321a, 0x321b, 0x249c, 0x249d, 0x249e,
	0x249f, 0x24a0, 0x24a1, 0x24a2, 0x24a3, 0x24a4, 0x24a5, 0x24a6,
	0x24a7, 0x24a8, 0x24a9, 0x24aa, 0x24ab, 0x24ac, 0x24ad, 0x24ae,
	0x24af, 0x24b0, 0x24b1, 0x24b2, 0x24b3, 0x24b4, 0x24b5, 0x2474,
	0x2475, 0x2476, 0x2477, 0x2478, 0x2479, 0x247a, 0x247b, 0x247c,
	0x247d, 0x247e, 0x247f, 0x2480, 0x2481, 0x2482, 0x00b9, 0x00b2,
	0x00b3, 0x2074, 0x207f, 0x2081, 0x2082, 0x2083, 0x2084, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xaa40[ 184 ] = {
	0xfffd, 0xcc25, 0xcc26, 0xcc2a, 0xcc2b, 0xcc2d, 0xcc2f, 0xcc31,
	0xcc32, 0xcc33, 0xcc34, 0xcc35, 0xcc36, 0xcc37, 0xcc3a, 0xcc3f,
	0xcc40, 0xcc41, 0xcc42, 0xcc43, 0xcc46, 0xcc47, 0xcc49, 0xcc4a,
	0xcc4b, 0xcc4d, 0xcc4e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcc4f, 0xcc50, 0xcc51, 0xcc52, 0xcc53, 0xcc56, 0xcc5a,
	0xcc5b, 0xcc5c, 0xcc5d, 0xcc5e, 0xcc5f, 0xcc61, 0xcc62, 0xcc63,
	0xcc65, 0xcc67, 0xcc69, 0xcc6a, 0xcc6b, 0xcc6c, 0xcc6d, 0xcc6e,
	0xcc6f, 0xcc71, 0xcc72, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcc73, 0xcc74, 0xcc76, 0xcc77, 0xcc78, 0xcc79, 0xcc7a,
	0xcc7b, 0xcc7c, 0xcc7d, 0xcc7e, 0xcc7f, 0xcc80, 0xcc81, 0xcc82,
	0xcc83, 0xcc84, 0xcc85, 0xcc86, 0xcc87, 0xcc88, 0xcc89, 0xcc8a,
	0xcc8b, 0xcc8c, 0xcc8d, 0xcc8e, 0xcc8f, 0xcc90, 0xcc91, 0xcc92,
	0xcc93, 0x3041, 0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047,
	0x3048, 0x3049, 0x304a, 0x304b, 0x304c, 0x304d, 0x304e, 0x304f,
	0x3050, 0x3051, 0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057,
	0x3058, 0x3059, 0x305a, 0x305b, 0x305c, 0x305d, 0x305e, 0x305f,
	0x3060, 0x3061, 0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067,
	0x3068, 0x3069, 0x306a, 0x306b, 0x306c, 0x306d, 0x306e, 0x306f,
	0x3070, 0x3071, 0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077,
	0x3078, 0x3079, 0x307a, 0x307b, 0x307c, 0x307d, 0x307e, 0x307f,
	0x3080, 0x3081, 0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087,
	0x3088, 0x3089, 0x308a, 0x308b, 0x308c, 0x308d, 0x308e, 0x308f,
	0x3090, 0x3091, 0x3092, 0x3093, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xab40[ 184 ] = {
	0xfffd, 0xcc94, 0xcc95, 0xcc96, 0xcc97, 0xcc9a, 0xcc9b, 0xcc9d,
	0xcc9e, 0xcc9f, 0xcca1, 0xcca2, 0xcca3, 0xcca4, 0xcca5, 0xcca6,
	0xcca7, 0xccaa, 0xccae, 0xccaf, 0xccb0, 0xccb1, 0xccb2, 0xccb3,
	0xccb6, 0xccb7, 0xccb9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xccba, 0xccbb, 0xccbd, 0xccbe, 0xccbf, 0xccc0, 0xccc1,
	0xccc2, 0xccc3, 0xccc6, 0xccc8, 0xccca, 0xcccb, 0xcccc, 0xcccd,
	0xccce, 0xcccf, 0xccd1, 0xccd2, 0xccd3, 0xccd5, 0xccd6, 0xccd7,
	0xccd8, 0xccd9, 0xccda, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xccdb, 0xccdc, 0xccdd, 0xccde, 0xccdf, 0xcce0, 0xcce1,
	0xcce2, 0xcce3, 0xcce5, 0xcce6, 0xcce7, 0xcce8, 0xcce9, 0xccea,
	0xcceb, 0xcced, 0xccee, 0xccef, 0xccf1, 0xccf2, 0xccf3, 0xccf4,
	0xccf5, 0xccf6, 0xccf7, 0xccf8, 0xccf9, 0xccfa, 0xccfb, 0xccfc,
	0xccfd, 0x30a1, 0x30a2, 0x30a3, 0x30a4, 0x30a5, 0x30a6, 0x30a7,
	0x30a8, 0x30a9, 0x30aa, 0x30ab, 0x30ac, 0x30ad, 0x30ae, 0x30af,
	0x30b0, 0x30b1, 0x30b2, 0x30b3, 0x30b4, 0x30b5, 0x30b6, 0x30b7,
	0x30b8, 0x30b9, 0x30ba, 0x30bb, 0x30bc, 0x30bd, 0x30be, 0x30bf,
	0x30c0, 0x30c1, 0x30c2, 0x30c3, 0x30c4, 0x30c5, 0x30c6, 0x30c7,
	0x30c8, 0x30c9, 0x30ca, 0x30cb, 0x30cc, 0x30cd, 0x30ce, 0x30cf,
	0x30d0, 0x30d1, 0x30d2, 0x30d3, 0x30d4, 0x30d5, 0x30d6, 0x30d7,
	0x30d8, 0x30d9, 0x30da, 0x30db, 0x30dc, 0x30dd, 0x30de, 0x30df,
	0x30e0, 0x30e1, 0x30e2, 0x30e3, 0x30e4, 0x30e5, 0x30e6, 0x30e7,
	0x30e8, 0x30e9, 0x30ea, 0x30eb, 0x30ec, 0x30ed, 0x30ee, 0x30ef,
	0x30f0, 0x30f1, 0x30f2, 0x30f3, 0x30f4, 0x30f5, 0x30f6, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xac40[ 136 ] = {
	0xfffd, 0xccfe, 0xccff, 0xcd00, 0xcd02, 0xcd03, 0xcd04, 0xcd05,
	0xcd06, 0xcd07, 0xcd0a, 0xcd0b, 0xcd0d, 0xcd0e, 0xcd0f, 0xcd11,
	0xcd12, 0xcd13, 0xcd14, 0xcd15, 0xcd16, 0xcd17, 0xcd1a, 0xcd1c,
	0xcd1e, 0xcd1f, 0xcd20, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcd21, 0xcd22, 0xcd23, 0xcd25, 0xcd26, 0xcd27, 0xcd29,
	0xcd2a, 0xcd2b, 0xcd2d, 0xcd2e, 0xcd2f, 0xcd30, 0xcd31, 0xcd32,
	0xcd33, 0xcd34, 0xcd35, 0xcd36, 0xcd37, 0xcd38, 0xcd3a, 0xcd3b,
	0xcd3c, 0xcd3d, 0xcd3e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcd3f, 0xcd40, 0xcd41, 0xcd42, 0xcd43, 0xcd44, 0xcd45,
	0xcd46, 0xcd47, 0xcd48, 0xcd49, 0xcd4a, 0xcd4b, 0xcd4c, 0xcd4d,
	0xcd4e, 0xcd4f, 0xcd50, 0xcd51, 0xcd52, 0xcd53, 0xcd54, 0xcd55,
	0xcd56, 0xcd57, 0xcd58, 0xcd59, 0xcd5a, 0xcd5b, 0xcd5d, 0xcd5e,
	0xcd5f, 0x0410, 0x0411, 0x0412, 0x0413, 0x0414, 0x0415, 0x0401,
	0x0416, 0x0417, 0x0418, 0x0419, 0x041a, 0x041b, 0x041c, 0x041d,
	0x041e, 0x041f, 0x0420, 0x0421, 0x0422, 0x0423, 0x0424, 0x0425,
	0x0426, 0x0427, 0x0428, 0x0429, 0x042a, 0x042b, 0x042c, 0x042d,
	0x042e, 0x042f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xacd0[ 40 ] = {
	0xfffd, 0x0430, 0x0431, 0x0432, 0x0433, 0x0434, 0x0435, 0x0451,
	0x0436, 0x0437, 0x0438, 0x0439, 0x043a, 0x043b, 0x043c, 0x043d,
	0x043e, 0x043f, 0x0440, 0x0441, 0x0442, 0x0443, 0x0444, 0x0445,
	0x0446, 0x0447, 0x0448, 0x0449, 0x044a, 0x044b, 0x044c, 0x044d,
	0x044e, 0x044f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xad40[ 96 ] = {
	0xfffd, 0xcd61, 0xcd62, 0xcd63, 0xcd65, 0xcd66, 0xcd67, 0xcd68,
	0xcd69, 0xcd6a, 0xcd6b, 0xcd6e, 0xcd70, 0xcd72, 0xcd73, 0xcd74,
	0xcd75, 0xcd76, 0xcd77, 0xcd79, 0xcd7a, 0xcd7b, 0xcd7c, 0xcd7d,
	0xcd7e, 0xcd7f, 0xcd80, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcd81, 0xcd82, 0xcd83, 0xcd84, 0xcd85, 0xcd86, 0xcd87,
	0xcd89, 0xcd8a, 0xcd8b, 0xcd8c, 0xcd8d, 0xcd8e, 0xcd8f, 0xcd90,
	0xcd91, 0xcd92, 0xcd93, 0xcd96, 0xcd97, 0xcd99, 0xcd9a, 0xcd9b,
	0xcd9d, 0xcd9e, 0xcd9f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcda0, 0xcda1, 0xcda2, 0xcda3, 0xcda6, 0xcda8, 0xcdaa,
	0xcdab, 0xcdac, 0xcdad, 0xcdae, 0xcdaf, 0xcdb1, 0xcdb2, 0xcdb3,
	0xcdb4, 0xcdb5, 0xcdb6, 0xcdb7, 0xcdb8, 0xcdb9, 0xcdba, 0xcdbb,
	0xcdbc, 0xcdbd, 0xcdbe, 0xcdbf, 0xcdc0, 0xcdc1, 0xcdc2, 0xcdc3
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xae40[ 96 ] = {
	0xfffd, 0xcdc6, 0xcdc7, 0xcdc8, 0xcdc9, 0xcdca, 0xcdcb, 0xcdcd,
	0xcdce, 0xcdcf, 0xcdd1, 0xcdd2, 0xcdd3, 0xcdd4, 0xcdd5, 0xcdd6,
	0xcdd7, 0xcdd8, 0xcdd9, 0xcdda, 0xcddb, 0xcddc, 0xcddd, 0xcdde,
	0xcddf, 0xcde0, 0xcde1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcde2, 0xcde3, 0xcde4, 0xcde5, 0xcde6, 0xcde7, 0xcde9,
	0xcdea, 0xcdeb, 0xcded, 0xcdee, 0xcdef, 0xcdf1, 0xcdf2, 0xcdf3,
	0xcdf4, 0xcdf5, 0xcdf6, 0xcdf7, 0xcdfa, 0xcdfc, 0xcdfe, 0xcdff,
	0xce00, 0xce01, 0xce02, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xce03, 0xce05, 0xce06, 0xce07, 0xce09, 0xce0a, 0xce0b,
	0xce0d, 0xce0e, 0xce0f, 0xce10, 0xce11, 0xce12, 0xce13, 0xce15,
	0xce16, 0xce17, 0xce18, 0xce1a, 0xce1b, 0xce1c, 0xce1d, 0xce1e,
	0xce1f, 0xce22, 0xce23, 0xce25, 0xce26, 0xce27, 0xce29, 0xce2a
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xaf40[ 96 ] = {
	0xfffd, 0xce2c, 0xce2d, 0xce2e, 0xce2f, 0xce32, 0xce34, 0xce36,
	0xce37, 0xce38, 0xce39, 0xce3a, 0xce3b, 0xce3c, 0xce3d, 0xce3e,
	0xce3f, 0xce40, 0xce41, 0xce42, 0xce43, 0xce44, 0xce45, 0xce46,
	0xce47, 0xce48, 0xce49, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xce4a, 0xce4b, 0xce4c, 0xce4d, 0xce4e, 0xce4f, 0xce50,
	0xce51, 0xce52, 0xce53, 0xce54, 0xce55, 0xce56, 0xce57, 0xce5a,
	0xce5b, 0xce5d, 0xce5e, 0xce62, 0xce63, 0xce64, 0xce65, 0xce66,
	0xce67, 0xce6a, 0xce6c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xce6e, 0xce6f, 0xce70, 0xce71, 0xce72, 0xce73, 0xce76,
	0xce77, 0xce79, 0xce7a, 0xce7b, 0xce7d, 0xce7e, 0xce7f, 0xce80,
	0xce81, 0xce82, 0xce83, 0xce86, 0xce88, 0xce8a, 0xce8b, 0xce8c,
	0xce8d, 0xce8e, 0xce8f, 0xce92, 0xce93, 0xce95, 0xce96, 0xce97
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb040[ 192 ] = {
	0xfffd, 0xce9a, 0xce9b, 0xce9c, 0xce9d, 0xce9e, 0xce9f, 0xcea2,
	0xcea6, 0xcea7, 0xcea8, 0xcea9, 0xceaa, 0xceab, 0xceae, 0xceaf,
	0xceb0, 0xceb1, 0xceb2, 0xceb3, 0xceb4, 0xceb5, 0xceb6, 0xceb7,
	0xceb8, 0xceb9, 0xceba, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcebb, 0xcebc, 0xcebd, 0xcebe, 0xcebf, 0xcec0, 0xcec2,
	0xcec3, 0xcec4, 0xcec5, 0xcec6, 0xcec7, 0xcec8, 0xcec9, 0xceca,
	0xcecb, 0xcecc, 0xcecd, 0xcece, 0xcecf, 0xced0, 0xced1, 0xced2,
	0xced3, 0xced4, 0xced5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xced6, 0xced7, 0xced8, 0xced9, 0xceda, 0xcedb, 0xcedc,
	0xcedd, 0xcede, 0xcedf, 0xcee0, 0xcee1, 0xcee2, 0xcee3, 0xcee6,
	0xcee7, 0xcee9, 0xceea, 0xceed, 0xceee, 0xceef, 0xcef0, 0xcef1,
	0xcef2, 0xcef3, 0xcef6, 0xcefa, 0xcefb, 0xcefc, 0xcefd, 0xcefe,
	0xceff, 0xac00, 0xac01, 0xac04, 0xac07, 0xac08, 0xac09, 0xac0a,
	0xac10, 0xac11, 0xac12, 0xac13, 0xac14, 0xac15, 0xac16, 0xac17,
	0xac19, 0xac1a, 0xac1b, 0xac1c, 0xac1d, 0xac20, 0xac24, 0xac2c,
	0xac2d, 0xac2f, 0xac30, 0xac31, 0xac38, 0xac39, 0xac3c, 0xac40,
	0xac4b, 0xac4d, 0xac54, 0xac58, 0xac5c, 0xac70, 0xac71, 0xac74,
	0xac77, 0xac78, 0xac7a, 0xac80, 0xac81, 0xac83, 0xac84, 0xac85,
	0xac86, 0xac89, 0xac8a, 0xac8b, 0xac8c, 0xac90, 0xac94, 0xac9c,
	0xac9d, 0xac9f, 0xaca0, 0xaca1, 0xaca8, 0xaca9, 0xacaa, 0xacac,
	0xacaf, 0xacb0, 0xacb8, 0xacb9, 0xacbb, 0xacbc, 0xacbd, 0xacc1,
	0xacc4, 0xacc8, 0xaccc, 0xacd5, 0xacd7, 0xace0, 0xace1, 0xace4,
	0xace7, 0xace8, 0xacea, 0xacec, 0xacef, 0xacf0, 0xacf1, 0xacf3,
	0xacf5, 0xacf6, 0xacfc, 0xacfd, 0xad00, 0xad04, 0xad06, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb140[ 192 ] = {
	0xfffd, 0xcf02, 0xcf03, 0xcf05, 0xcf06, 0xcf07, 0xcf09, 0xcf0a,
	0xcf0b, 0xcf0c, 0xcf0d, 0xcf0e, 0xcf0f, 0xcf12, 0xcf14, 0xcf16,
	0xcf17, 0xcf18, 0xcf19, 0xcf1a, 0xcf1b, 0xcf1d, 0xcf1e, 0xcf1f,
	0xcf21, 0xcf22, 0xcf23, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcf25, 0xcf26, 0xcf27, 0xcf28, 0xcf29, 0xcf2a, 0xcf2b,
	0xcf2e, 0xcf32, 0xcf33, 0xcf34, 0xcf35, 0xcf36, 0xcf37, 0xcf39,
	0xcf3a, 0xcf3b, 0xcf3c, 0xcf3d, 0xcf3e, 0xcf3f, 0xcf40, 0xcf41,
	0xcf42, 0xcf43, 0xcf44, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcf45, 0xcf46, 0xcf47, 0xcf48, 0xcf49, 0xcf4a, 0xcf4b,
	0xcf4c, 0xcf4d, 0xcf4e, 0xcf4f, 0xcf50, 0xcf51, 0xcf52, 0xcf53,
	0xcf56, 0xcf57, 0xcf59, 0xcf5a, 0xcf5b, 0xcf5d, 0xcf5e, 0xcf5f,
	0xcf60, 0xcf61, 0xcf62, 0xcf63, 0xcf66, 0xcf68, 0xcf6a, 0xcf6b,
	0xcf6c, 0xad0c, 0xad0d, 0xad0f, 0xad11, 0xad18, 0xad1c, 0xad20,
	0xad29, 0xad2c, 0xad2d, 0xad34, 0xad35, 0xad38, 0xad3c, 0xad44,
	0xad45, 0xad47, 0xad49, 0xad50, 0xad54, 0xad58, 0xad61, 0xad63,
	0xad6c, 0xad6d, 0xad70, 0xad73, 0xad74, 0xad75, 0xad76, 0xad7b,
	0xad7c, 0xad7d, 0xad7f, 0xad81, 0xad82, 0xad88, 0xad89, 0xad8c,
	0xad90, 0xad9c, 0xad9d, 0xada4, 0xadb7, 0xadc0, 0xadc1, 0xadc4,
	0xadc8, 0xadd0, 0xadd1, 0xadd3, 0xaddc, 0xade0, 0xade4, 0xadf8,
	0xadf9, 0xadfc, 0xadff, 0xae00, 0xae01, 0xae08, 0xae09, 0xae0b,
	0xae0d, 0xae14, 0xae30, 0xae31, 0xae34, 0xae37, 0xae38, 0xae3a,
	0xae40, 0xae41, 0xae43, 0xae45, 0xae46, 0xae4a, 0xae4c, 0xae4d,
	0xae4e, 0xae50, 0xae54, 0xae56, 0xae5c, 0xae5d, 0xae5f, 0xae60,
	0xae61, 0xae65, 0xae68, 0xae69, 0xae6c, 0xae70, 0xae78, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb240[ 192 ] = {
	0xfffd, 0xcf6d, 0xcf6e, 0xcf6f, 0xcf72, 0xcf73, 0xcf75, 0xcf76,
	0xcf77, 0xcf79, 0xcf7a, 0xcf7b, 0xcf7c, 0xcf7d, 0xcf7e, 0xcf7f,
	0xcf81, 0xcf82, 0xcf83, 0xcf84, 0xcf86, 0xcf87, 0xcf88, 0xcf89,
	0xcf8a, 0xcf8b, 0xcf8d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcf8e, 0xcf8f, 0xcf90, 0xcf91, 0xcf92, 0xcf93, 0xcf94,
	0xcf95, 0xcf96, 0xcf97, 0xcf98, 0xcf99, 0xcf9a, 0xcf9b, 0xcf9c,
	0xcf9d, 0xcf9e, 0xcf9f, 0xcfa0, 0xcfa2, 0xcfa3, 0xcfa4, 0xcfa5,
	0xcfa6, 0xcfa7, 0xcfa9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcfaa, 0xcfab, 0xcfac, 0xcfad, 0xcfae, 0xcfaf, 0xcfb1,
	0xcfb2, 0xcfb3, 0xcfb4, 0xcfb5, 0xcfb6, 0xcfb7, 0xcfb8, 0xcfb9,
	0xcfba, 0xcfbb, 0xcfbc, 0xcfbd, 0xcfbe, 0xcfbf, 0xcfc0, 0xcfc1,
	0xcfc2, 0xcfc3, 0xcfc5, 0xcfc6, 0xcfc7, 0xcfc8, 0xcfc9, 0xcfca,
	0xcfcb, 0xae79, 0xae7b, 0xae7c, 0xae7d, 0xae84, 0xae85, 0xae8c,
	0xaebc, 0xaebd, 0xaebe, 0xaec0, 0xaec4, 0xaecc, 0xaecd, 0xaecf,
	0xaed0, 0xaed1, 0xaed8, 0xaed9, 0xaedc, 0xaee8, 0xaeeb, 0xaeed,
	0xaef4, 0xaef8, 0xaefc, 0xaf07, 0xaf08, 0xaf0d, 0xaf10, 0xaf2c,
	0xaf2d, 0xaf30, 0xaf32, 0xaf34, 0xaf3c, 0xaf3d, 0xaf3f, 0xaf41,
	0xaf42, 0xaf43, 0xaf48, 0xaf49, 0xaf50, 0xaf5c, 0xaf5d, 0xaf64,
	0xaf65, 0xaf79, 0xaf80, 0xaf84, 0xaf88, 0xaf90, 0xaf91, 0xaf95,
	0xaf9c, 0xafb8, 0xafb9, 0xafbc, 0xafc0, 0xafc7, 0xafc8, 0xafc9,
	0xafcb, 0xafcd, 0xafce, 0xafd4, 0xafdc, 0xafe8, 0xafe9, 0xaff0,
	0xaff1, 0xaff4, 0xaff8, 0xb000, 0xb001, 0xb004, 0xb00c, 0xb010,
	0xb014, 0xb01c, 0xb01d, 0xb028, 0xb044, 0xb045, 0xb048, 0xb04a,
	0xb04c, 0xb04e, 0xb053, 0xb054, 0xb055, 0xb057, 0xb059, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb340[ 192 ] = {
	0xfffd, 0xcfcc, 0xcfcd, 0xcfce, 0xcfcf, 0xcfd0, 0xcfd1, 0xcfd2,
	0xcfd3, 0xcfd4, 0xcfd5, 0xcfd6, 0xcfd7, 0xcfd8, 0xcfd9, 0xcfda,
	0xcfdb, 0xcfdc, 0xcfdd, 0xcfde, 0xcfdf, 0xcfe2, 0xcfe3, 0xcfe5,
	0xcfe6, 0xcfe7, 0xcfe9, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xcfea, 0xcfeb, 0xcfec, 0xcfed, 0xcfee, 0xcfef, 0xcff2,
	0xcff4, 0xcff6, 0xcff7, 0xcff8, 0xcff9, 0xcffa, 0xcffb, 0xcffd,
	0xcffe, 0xcfff, 0xd001, 0xd002, 0xd003, 0xd005, 0xd006, 0xd007,
	0xd008, 0xd009, 0xd00a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd00b, 0xd00c, 0xd00d, 0xd00e, 0xd00f, 0xd010, 0xd012,
	0xd013, 0xd014, 0xd015, 0xd016, 0xd017, 0xd019, 0xd01a, 0xd01b,
	0xd01c, 0xd01d, 0xd01e, 0xd01f, 0xd020, 0xd021, 0xd022, 0xd023,
	0xd024, 0xd025, 0xd026, 0xd027, 0xd028, 0xd029, 0xd02a, 0xd02b,
	0xd02c, 0xb05d, 0xb07c, 0xb07d, 0xb080, 0xb084, 0xb08c, 0xb08d,
	0xb08f, 0xb091, 0xb098, 0xb099, 0xb09a, 0xb09c, 0xb09f, 0xb0a0,
	0xb0a1, 0xb0a2, 0xb0a8, 0xb0a9, 0xb0ab, 0xb0ac, 0xb0ad, 0xb0ae,
	0xb0af, 0xb0b1, 0xb0b3, 0xb0b4, 0xb0b5, 0xb0b8, 0xb0bc, 0xb0c4,
	0xb0c5, 0xb0c7, 0xb0c8, 0xb0c9, 0xb0d0, 0xb0d1, 0xb0d4, 0xb0d8,
	0xb0e0, 0xb0e5, 0xb108, 0xb109, 0xb10b, 0xb10c, 0xb110, 0xb112,
	0xb113, 0xb118, 0xb119, 0xb11b, 0xb11c, 0xb11d, 0xb123, 0xb124,
	0xb125, 0xb128, 0xb12c, 0xb134, 0xb135, 0xb137, 0xb138, 0xb139,
	0xb140, 0xb141, 0xb144, 0xb148, 0xb150, 0xb151, 0xb154, 0xb155,
	0xb158, 0xb15c, 0xb160, 0xb178, 0xb179, 0xb17c, 0xb180, 0xb182,
	0xb188, 0xb189, 0xb18b, 0xb18d, 0xb192, 0xb193, 0xb194, 0xb198,
	0xb19c, 0xb1a8, 0xb1cc, 0xb1d0, 0xb1d4, 0xb1dc, 0xb1dd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb440[ 192 ] = {
	0xfffd, 0xd02e, 0xd02f, 0xd030, 0xd031, 0xd032, 0xd033, 0xd036,
	0xd037, 0xd039, 0xd03a, 0xd03b, 0xd03d, 0xd03e, 0xd03f, 0xd040,
	0xd041, 0xd042, 0xd043, 0xd046, 0xd048, 0xd04a, 0xd04b, 0xd04c,
	0xd04d, 0xd04e, 0xd04f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd051, 0xd052, 0xd053, 0xd055, 0xd056, 0xd057, 0xd059,
	0xd05a, 0xd05b, 0xd05c, 0xd05d, 0xd05e, 0xd05f, 0xd061, 0xd062,
	0xd063, 0xd064, 0xd065, 0xd066, 0xd067, 0xd068, 0xd069, 0xd06a,
	0xd06b, 0xd06e, 0xd06f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd071, 0xd072, 0xd073, 0xd075, 0xd076, 0xd077, 0xd078,
	0xd079, 0xd07a, 0xd07b, 0xd07e, 0xd07f, 0xd080, 0xd082, 0xd083,
	0xd084, 0xd085, 0xd086, 0xd087, 0xd088, 0xd089, 0xd08a, 0xd08b,
	0xd08c, 0xd08d, 0xd08e, 0xd08f, 0xd090, 0xd091, 0xd092, 0xd093,
	0xd094, 0xb1df, 0xb1e8, 0xb1e9, 0xb1ec, 0xb1f0, 0xb1f9, 0xb1fb,
	0xb1fd, 0xb204, 0xb205, 0xb208, 0xb20b, 0xb20c, 0xb214, 0xb215,
	0xb217, 0xb219, 0xb220, 0xb234, 0xb23c, 0xb258, 0xb25c, 0xb260,
	0xb268, 0xb269, 0xb274, 0xb275, 0xb27c, 0xb284, 0xb285, 0xb289,
	0xb290, 0xb291, 0xb294, 0xb298, 0xb299, 0xb29a, 0xb2a0, 0xb2a1,
	0xb2a3, 0xb2a5, 0xb2a6, 0xb2aa, 0xb2ac, 0xb2b0, 0xb2b4, 0xb2c8,
	0xb2c9, 0xb2cc, 0xb2d0, 0xb2d2, 0xb2d8, 0xb2d9, 0xb2db, 0xb2dd,
	0xb2e2, 0xb2e4, 0xb2e5, 0xb2e6, 0xb2e8, 0xb2eb, 0xb2ec, 0xb2ed,
	0xb2ee, 0xb2ef, 0xb2f3, 0xb2f4, 0xb2f5, 0xb2f7, 0xb2f8, 0xb2f9,
	0xb2fa, 0xb2fb, 0xb2ff, 0xb300, 0xb301, 0xb304, 0xb308, 0xb310,
	0xb311, 0xb313, 0xb314, 0xb315, 0xb31c, 0xb354, 0xb355, 0xb356,
	0xb358, 0xb35b, 0xb35c, 0xb35e, 0xb35f, 0xb364, 0xb365, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb540[ 192 ] = {
	0xfffd, 0xd095, 0xd096, 0xd097, 0xd098, 0xd099, 0xd09a, 0xd09b,
	0xd09c, 0xd09d, 0xd09e, 0xd09f, 0xd0a0, 0xd0a1, 0xd0a2, 0xd0a3,
	0xd0a6, 0xd0a7, 0xd0a9, 0xd0aa, 0xd0ab, 0xd0ad, 0xd0ae, 0xd0af,
	0xd0b0, 0xd0b1, 0xd0b2, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd0b3, 0xd0b6, 0xd0b8, 0xd0ba, 0xd0bb, 0xd0bc, 0xd0bd,
	0xd0be, 0xd0bf, 0xd0c2, 0xd0c3, 0xd0c5, 0xd0c6, 0xd0c7, 0xd0ca,
	0xd0cb, 0xd0cc, 0xd0cd, 0xd0ce, 0xd0cf, 0xd0d2, 0xd0d6, 0xd0d7,
	0xd0d8, 0xd0d9, 0xd0da, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd0db, 0xd0de, 0xd0df, 0xd0e1, 0xd0e2, 0xd0e3, 0xd0e5,
	0xd0e6, 0xd0e7, 0xd0e8, 0xd0e9, 0xd0ea, 0xd0eb, 0xd0ee, 0xd0f2,
	0xd0f3, 0xd0f4, 0xd0f5, 0xd0f6, 0xd0f7, 0xd0f9, 0xd0fa, 0xd0fb,
	0xd0fc, 0xd0fd, 0xd0fe, 0xd0ff, 0xd100, 0xd101, 0xd102, 0xd103,
	0xd104, 0xb367, 0xb369, 0xb36b, 0xb36e, 0xb370, 0xb371, 0xb374,
	0xb378, 0xb380, 0xb381, 0xb383, 0xb384, 0xb385, 0xb38c, 0xb390,
	0xb394, 0xb3a0, 0xb3a1, 0xb3a8, 0xb3ac, 0xb3c4, 0xb3c5, 0xb3c8,
	0xb3cb, 0xb3cc, 0xb3ce, 0xb3d0, 0xb3d4, 0xb3d5, 0xb3d7, 0xb3d9,
	0xb3db, 0xb3dd, 0xb3e0, 0xb3e4, 0xb3e8, 0xb3fc, 0xb410, 0xb418,
	0xb41c, 0xb420, 0xb428, 0xb429, 0xb42b, 0xb434, 0xb450, 0xb451,
	0xb454, 0xb458, 0xb460, 0xb461, 0xb463, 0xb465, 0xb46c, 0xb480,
	0xb488, 0xb49d, 0xb4a4, 0xb4a8, 0xb4ac, 0xb4b5, 0xb4b7, 0xb4b9,
	0xb4c0, 0xb4c4, 0xb4c8, 0xb4d0, 0xb4d5, 0xb4dc, 0xb4dd, 0xb4e0,
	0xb4e3, 0xb4e4, 0xb4e6, 0xb4ec, 0xb4ed, 0xb4ef, 0xb4f1, 0xb4f8,
	0xb514, 0xb515, 0xb518, 0xb51b, 0xb51c, 0xb524, 0xb525, 0xb527,
	0xb528, 0xb529, 0xb52a, 0xb530, 0xb531, 0xb534, 0xb538, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb640[ 192 ] = {
	0xfffd, 0xd105, 0xd106, 0xd107, 0xd108, 0xd109, 0xd10a, 0xd10b,
	0xd10c, 0xd10e, 0xd10f, 0xd110, 0xd111, 0xd112, 0xd113, 0xd114,
	0xd115, 0xd116, 0xd117, 0xd118, 0xd119, 0xd11a, 0xd11b, 0xd11c,
	0xd11d, 0xd11e, 0xd11f, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd120, 0xd121, 0xd122, 0xd123, 0xd124, 0xd125, 0xd126,
	0xd127, 0xd128, 0xd129, 0xd12a, 0xd12b, 0xd12c, 0xd12d, 0xd12e,
	0xd12f, 0xd132, 0xd133, 0xd135, 0xd136, 0xd137, 0xd139, 0xd13b,
	0xd13c, 0xd13d, 0xd13e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd13f, 0xd142, 0xd146, 0xd147, 0xd148, 0xd149, 0xd14a,
	0xd14b, 0xd14e, 0xd14f, 0xd151, 0xd152, 0xd153, 0xd155, 0xd156,
	0xd157, 0xd158, 0xd159, 0xd15a, 0xd15b, 0xd15e, 0xd160, 0xd162,
	0xd163, 0xd164, 0xd165, 0xd166, 0xd167, 0xd169, 0xd16a, 0xd16b,
	0xd16d, 0xb540, 0xb541, 0xb543, 0xb544, 0xb545, 0xb54b, 0xb54c,
	0xb54d, 0xb550, 0xb554, 0xb55c, 0xb55d, 0xb55f, 0xb560, 0xb561,
	0xb5a0, 0xb5a1, 0xb5a4, 0xb5a8, 0xb5aa, 0xb5ab, 0xb5b0, 0xb5b1,
	0xb5b3, 0xb5b4, 0xb5b5, 0xb5bb, 0xb5bc, 0xb5bd, 0xb5c0, 0xb5c4,
	0xb5cc, 0xb5cd, 0xb5cf, 0xb5d0, 0xb5d1, 0xb5d8, 0xb5ec, 0xb610,
	0xb611, 0xb614, 0xb618, 0xb625, 0xb62c, 0xb634, 0xb648, 0xb664,
	0xb668, 0xb69c, 0xb69d, 0xb6a0, 0xb6a4, 0xb6ab, 0xb6ac, 0xb6b1,
	0xb6d4, 0xb6f0, 0xb6f4, 0xb6f8, 0xb700, 0xb701, 0xb705, 0xb728,
	0xb729, 0xb72c, 0xb72f, 0xb730, 0xb738, 0xb739, 0xb73b, 0xb744,
	0xb748, 0xb74c, 0xb754, 0xb755, 0xb760, 0xb764, 0xb768, 0xb770,
	0xb771, 0xb773, 0xb775, 0xb77c, 0xb77d, 0xb780, 0xb784, 0xb78c,
	0xb78d, 0xb78f, 0xb790, 0xb791, 0xb792, 0xb796, 0xb797, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb740[ 192 ] = {
	0xfffd, 0xd16e, 0xd16f, 0xd170, 0xd171, 0xd172, 0xd173, 0xd174,
	0xd175, 0xd176, 0xd177, 0xd178, 0xd179, 0xd17a, 0xd17b, 0xd17d,
	0xd17e, 0xd17f, 0xd180, 0xd181, 0xd182, 0xd183, 0xd185, 0xd186,
	0xd187, 0xd189, 0xd18a, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd18b, 0xd18c, 0xd18d, 0xd18e, 0xd18f, 0xd190, 0xd191,
	0xd192, 0xd193, 0xd194, 0xd195, 0xd196, 0xd197, 0xd198, 0xd199,
	0xd19a, 0xd19b, 0xd19c, 0xd19d, 0xd19e, 0xd19f, 0xd1a2, 0xd1a3,
	0xd1a5, 0xd1a6, 0xd1a7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd1a9, 0xd1aa, 0xd1ab, 0xd1ac, 0xd1ad, 0xd1ae, 0xd1af,
	0xd1b2, 0xd1b4, 0xd1b6, 0xd1b7, 0xd1b8, 0xd1b9, 0xd1bb, 0xd1bd,
	0xd1be, 0xd1bf, 0xd1c1, 0xd1c2, 0xd1c3, 0xd1c4, 0xd1c5, 0xd1c6,
	0xd1c7, 0xd1c8, 0xd1c9, 0xd1ca, 0xd1cb, 0xd1cc, 0xd1cd, 0xd1ce,
	0xd1cf, 0xb798, 0xb799, 0xb79c, 0xb7a0, 0xb7a8, 0xb7a9, 0xb7ab,
	0xb7ac, 0xb7ad, 0xb7b4, 0xb7b5, 0xb7b8, 0xb7c7, 0xb7c9, 0xb7ec,
	0xb7ed, 0xb7f0, 0xb7f4, 0xb7fc, 0xb7fd, 0xb7ff, 0xb800, 0xb801,
	0xb807, 0xb808, 0xb809, 0xb80c, 0xb810, 0xb818, 0xb819, 0xb81b,
	0xb81d, 0xb824, 0xb825, 0xb828, 0xb82c, 0xb834, 0xb835, 0xb837,
	0xb838, 0xb839, 0xb840, 0xb844, 0xb851, 0xb853, 0xb85c, 0xb85d,
	0xb860, 0xb864, 0xb86c, 0xb86d, 0xb86f, 0xb871, 0xb878, 0xb87c,
	0xb88d, 0xb8a8, 0xb8b0, 0xb8b4, 0xb8b8, 0xb8c0, 0xb8c1, 0xb8c3,
	0xb8c5, 0xb8cc, 0xb8d0, 0xb8d4, 0xb8dd, 0xb8df, 0xb8e1, 0xb8e8,
	0xb8e9, 0xb8ec, 0xb8f0, 0xb8f8, 0xb8f9, 0xb8fb, 0xb8fd, 0xb904,
	0xb918, 0xb920, 0xb93c, 0xb93d, 0xb940, 0xb944, 0xb94c, 0xb94f,
	0xb951, 0xb958, 0xb959, 0xb95c, 0xb960, 0xb968, 0xb969, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb840[ 192 ] = {
	0xfffd, 0xd1d0, 0xd1d1, 0xd1d2, 0xd1d3, 0xd1d4, 0xd1d5, 0xd1d6,
	0xd1d7, 0xd1d9, 0xd1da, 0xd1db, 0xd1dc, 0xd1dd, 0xd1de, 0xd1df,
	0xd1e0, 0xd1e1, 0xd1e2, 0xd1e3, 0xd1e4, 0xd1e5, 0xd1e6, 0xd1e7,
	0xd1e8, 0xd1e9, 0xd1ea, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd1eb, 0xd1ec, 0xd1ed, 0xd1ee, 0xd1ef, 0xd1f0, 0xd1f1,
	0xd1f2, 0xd1f3, 0xd1f5, 0xd1f6, 0xd1f7, 0xd1f9, 0xd1fa, 0xd1fb,
	0xd1fc, 0xd1fd, 0xd1fe, 0xd1ff, 0xd200, 0xd201, 0xd202, 0xd203,
	0xd204, 0xd205, 0xd206, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd208, 0xd20a, 0xd20b, 0xd20c, 0xd20d, 0xd20e, 0xd20f,
	0xd211, 0xd212, 0xd213, 0xd214, 0xd215, 0xd216, 0xd217, 0xd218,
	0xd219, 0xd21a, 0xd21b, 0xd21c, 0xd21d, 0xd21e, 0xd21f, 0xd220,
	0xd221, 0xd222, 0xd223, 0xd224, 0xd225, 0xd226, 0xd227, 0xd228,
	0xd229, 0xb96b, 0xb96d, 0xb974, 0xb975, 0xb978, 0xb97c, 0xb984,
	0xb985, 0xb987, 0xb989, 0xb98a, 0xb98d, 0xb98e, 0xb9ac, 0xb9ad,
	0xb9b0, 0xb9b4, 0xb9bc, 0xb9bd, 0xb9bf, 0xb9c1, 0xb9c8, 0xb9c9,
	0xb9cc, 0xb9ce, 0xb9cf, 0xb9d0, 0xb9d1, 0xb9d2, 0xb9d8, 0xb9d9,
	0xb9db, 0xb9dd, 0xb9de, 0xb9e1, 0xb9e3, 0xb9e4, 0xb9e5, 0xb9e8,
	0xb9ec, 0xb9f4, 0xb9f5, 0xb9f7, 0xb9f8, 0xb9f9, 0xb9fa, 0xba00,
	0xba01, 0xba08, 0xba15, 0xba38, 0xba39, 0xba3c, 0xba40, 0xba42,
	0xba48, 0xba49, 0xba4b, 0xba4d, 0xba4e, 0xba53, 0xba54, 0xba55,
	0xba58, 0xba5c, 0xba64, 0xba65, 0xba67, 0xba68, 0xba69, 0xba70,
	0xba71, 0xba74, 0xba78, 0xba83, 0xba84, 0xba85, 0xba87, 0xba8c,
	0xbaa8, 0xbaa9, 0xbaab, 0xbaac, 0xbab0, 0xbab2, 0xbab8, 0xbab9,
	0xbabb, 0xbabd, 0xbac4, 0xbac8, 0xbad8, 0xbad9, 0xbafc, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb940[ 192 ] = {
	0xfffd, 0xd22a, 0xd22b, 0xd22e, 0xd22f, 0xd231, 0xd232, 0xd233,
	0xd235, 0xd236, 0xd237, 0xd238, 0xd239, 0xd23a, 0xd23b, 0xd23e,
	0xd240, 0xd242, 0xd243, 0xd244, 0xd245, 0xd246, 0xd247, 0xd249,
	0xd24a, 0xd24b, 0xd24c, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd24d, 0xd24e, 0xd24f, 0xd250, 0xd251, 0xd252, 0xd253,
	0xd254, 0xd255, 0xd256, 0xd257, 0xd258, 0xd259, 0xd25a, 0xd25b,
	0xd25d, 0xd25e, 0xd25f, 0xd260, 0xd261, 0xd262, 0xd263, 0xd265,
	0xd266, 0xd267, 0xd268, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd269, 0xd26a, 0xd26b, 0xd26c, 0xd26d, 0xd26e, 0xd26f,
	0xd270, 0xd271, 0xd272, 0xd273, 0xd274, 0xd275, 0xd276, 0xd277,
	0xd278, 0xd279, 0xd27a, 0xd27b, 0xd27c, 0xd27d, 0xd27e, 0xd27f,
	0xd282, 0xd283, 0xd285, 0xd286, 0xd287, 0xd289, 0xd28a, 0xd28b,
	0xd28c, 0xbb00, 0xbb04, 0xbb0d, 0xbb0f, 0xbb11, 0xbb18, 0xbb1c,
	0xbb20, 0xbb29, 0xbb2b, 0xbb34, 0xbb35, 0xbb36, 0xbb38, 0xbb3b,
	0xbb3c, 0xbb3d, 0xbb3e, 0xbb44, 0xbb45, 0xbb47, 0xbb49, 0xbb4d,
	0xbb4f, 0xbb50, 0xbb54, 0xbb58, 0xbb61, 0xbb63, 0xbb6c, 0xbb88,
	0xbb8c, 0xbb90, 0xbba4, 0xbba8, 0xbbac, 0xbbb4, 0xbbb7, 0xbbc0,
	0xbbc4, 0xbbc8, 0xbbd0, 0xbbd3, 0xbbf8, 0xbbf9, 0xbbfc, 0xbbff,
	0xbc00, 0xbc02, 0xbc08, 0xbc09, 0xbc0b, 0xbc0c, 0xbc0d, 0xbc0f,
	0xbc11, 0xbc14, 0xbc15, 0xbc16, 0xbc17, 0xbc18, 0xbc1b, 0xbc1c,
	0xbc1d, 0xbc1e, 0xbc1f, 0xbc24, 0xbc25, 0xbc27, 0xbc29, 0xbc2d,
	0xbc30, 0xbc31, 0xbc34, 0xbc38, 0xbc40, 0xbc41, 0xbc43, 0xbc44,
	0xbc45, 0xbc49, 0xbc4c, 0xbc4d, 0xbc50, 0xbc5d, 0xbc84, 0xbc85,
	0xbc88, 0xbc8b, 0xbc8c, 0xbc8e, 0xbc94, 0xbc95, 0xbc97, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xba40[ 192 ] = {
	0xfffd, 0xd28d, 0xd28e, 0xd28f, 0xd292, 0xd293, 0xd294, 0xd296,
	0xd297, 0xd298, 0xd299, 0xd29a, 0xd29b, 0xd29d, 0xd29e, 0xd29f,
	0xd2a1, 0xd2a2, 0xd2a3, 0xd2a5, 0xd2a6, 0xd2a7, 0xd2a8, 0xd2a9,
	0xd2aa, 0xd2ab, 0xd2ad, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd2ae, 0xd2af, 0xd2b0, 0xd2b2, 0xd2b3, 0xd2b4, 0xd2b5,
	0xd2b6, 0xd2b7, 0xd2ba, 0xd2bb, 0xd2bd, 0xd2be, 0xd2c1, 0xd2c3,
	0xd2c4, 0xd2c5, 0xd2c6, 0xd2c7, 0xd2ca, 0xd2cc, 0xd2cd, 0xd2ce,
	0xd2cf, 0xd2d0, 0xd2d1, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd2d2, 0xd2d3, 0xd2d5, 0xd2d6, 0xd2d7, 0xd2d9, 0xd2da,
	0xd2db, 0xd2dd, 0xd2de, 0xd2df, 0xd2e0, 0xd2e1, 0xd2e2, 0xd2e3,
	0xd2e6, 0xd2e7, 0xd2e8, 0xd2e9, 0xd2ea, 0xd2eb, 0xd2ec, 0xd2ed,
	0xd2ee, 0xd2ef, 0xd2f2, 0xd2f3, 0xd2f5, 0xd2f6, 0xd2f7, 0xd2f9,
	0xd2fa, 0xbc99, 0xbc9a, 0xbca0, 0xbca1, 0xbca4, 0xbca7, 0xbca8,
	0xbcb0, 0xbcb1, 0xbcb3, 0xbcb4, 0xbcb5, 0xbcbc, 0xbcbd, 0xbcc0,
	0xbcc4, 0xbccd, 0xbccf, 0xbcd0, 0xbcd1, 0xbcd5, 0xbcd8, 0xbcdc,
	0xbcf4, 0xbcf5, 0xbcf6, 0xbcf8, 0xbcfc, 0xbd04, 0xbd05, 0xbd07,
	0xbd09, 0xbd10, 0xbd14, 0xbd24, 0xbd2c, 0xbd40, 0xbd48, 0xbd49,
	0xbd4c, 0xbd50, 0xbd58, 0xbd59, 0xbd64, 0xbd68, 0xbd80, 0xbd81,
	0xbd84, 0xbd87, 0xbd88, 0xbd89, 0xbd8a, 0xbd90, 0xbd91, 0xbd93,
	0xbd95, 0xbd99, 0xbd9a, 0xbd9c, 0xbda4, 0xbdb0, 0xbdb8, 0xbdd4,
	0xbdd5, 0xbdd8, 0xbddc, 0xbde9, 0xbdf0, 0xbdf4, 0xbdf8, 0xbe00,
	0xbe03, 0xbe05, 0xbe0c, 0xbe0d, 0xbe10, 0xbe14, 0xbe1c, 0xbe1d,
	0xbe1f, 0xbe44, 0xbe45, 0xbe48, 0xbe4c, 0xbe4e, 0xbe54, 0xbe55,
	0xbe57, 0xbe59, 0xbe5a, 0xbe5b, 0xbe60, 0xbe61, 0xbe64, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbb40[ 192 ] = {
	0xfffd, 0xd2fb, 0xd2fc, 0xd2fd, 0xd2fe, 0xd2ff, 0xd302, 0xd304,
	0xd306, 0xd307, 0xd308, 0xd309, 0xd30a, 0xd30b, 0xd30f, 0xd311,
	0xd312, 0xd313, 0xd315, 0xd317, 0xd318, 0xd319, 0xd31a, 0xd31b,
	0xd31e, 0xd322, 0xd323, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd324, 0xd326, 0xd327, 0xd32a, 0xd32b, 0xd32d, 0xd32e,
	0xd32f, 0xd331, 0xd332, 0xd333, 0xd334, 0xd335, 0xd336, 0xd337,
	0xd33a, 0xd33e, 0xd33f, 0xd340, 0xd341, 0xd342, 0xd343, 0xd346,
	0xd347, 0xd348, 0xd349, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd34a, 0xd34b, 0xd34c, 0xd34d, 0xd34e, 0xd34f, 0xd350,
	0xd351, 0xd352, 0xd353, 0xd354, 0xd355, 0xd356, 0xd357, 0xd358,
	0xd359, 0xd35a, 0xd35b, 0xd35c, 0xd35d, 0xd35e, 0xd35f, 0xd360,
	0xd361, 0xd362, 0xd363, 0xd364, 0xd365, 0xd366, 0xd367, 0xd368,
	0xd369, 0xbe68, 0xbe6a, 0xbe70, 0xbe71, 0xbe73, 0xbe74, 0xbe75,
	0xbe7b, 0xbe7c, 0xbe7d, 0xbe80, 0xbe84, 0xbe8c, 0xbe8d, 0xbe8f,
	0xbe90, 0xbe91, 0xbe98, 0xbe99, 0xbea8, 0xbed0, 0xbed1, 0xbed4,
	0xbed7, 0xbed8, 0xbee0, 0xbee3, 0xbee4, 0xbee5, 0xbeec, 0xbf01,
	0xbf08, 0xbf09, 0xbf18, 0xbf19, 0xbf1b, 0xbf1c, 0xbf1d, 0xbf40,
	0xbf41, 0xbf44, 0xbf48, 0xbf50, 0xbf51, 0xbf55, 0xbf94, 0xbfb0,
	0xbfc5, 0xbfcc, 0xbfcd, 0xbfd0, 0xbfd4, 0xbfdc, 0xbfdf, 0xbfe1,
	0xc03c, 0xc051, 0xc058, 0xc05c, 0xc060, 0xc068, 0xc069, 0xc090,
	0xc091, 0xc094, 0xc098, 0xc0a0, 0xc0a1, 0xc0a3, 0xc0a5, 0xc0ac,
	0xc0ad, 0xc0af, 0xc0b0, 0xc0b3, 0xc0b4, 0xc0b5, 0xc0b6, 0xc0bc,
	0xc0bd, 0xc0bf, 0xc0c0, 0xc0c1, 0xc0c5, 0xc0c8, 0xc0c9, 0xc0cc,
	0xc0d0, 0xc0d8, 0xc0d9, 0xc0db, 0xc0dc, 0xc0dd, 0xc0e4, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbc40[ 192 ] = {
	0xfffd, 0xd36a, 0xd36b, 0xd36c, 0xd36d, 0xd36e, 0xd36f, 0xd370,
	0xd371, 0xd372, 0xd373, 0xd374, 0xd375, 0xd376, 0xd377, 0xd378,
	0xd379, 0xd37a, 0xd37b, 0xd37e, 0xd37f, 0xd381, 0xd382, 0xd383,
	0xd385, 0xd386, 0xd387, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd388, 0xd389, 0xd38a, 0xd38b, 0xd38e, 0xd392, 0xd393,
	0xd394, 0xd395, 0xd396, 0xd397, 0xd39a, 0xd39b, 0xd39d, 0xd39e,
	0xd39f, 0xd3a1, 0xd3a2, 0xd3a3, 0xd3a4, 0xd3a5, 0xd3a6, 0xd3a7,
	0xd3aa, 0xd3ac, 0xd3ae, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd3af, 0xd3b0, 0xd3b1, 0xd3b2, 0xd3b3, 0xd3b5, 0xd3b6,
	0xd3b7, 0xd3b9, 0xd3ba, 0xd3bb, 0xd3bd, 0xd3be, 0xd3bf, 0xd3c0,
	0xd3c1, 0xd3c2, 0xd3c3, 0xd3c6, 0xd3c7, 0xd3ca, 0xd3cb, 0xd3cc,
	0xd3cd, 0xd3ce, 0xd3cf, 0xd3d1, 0xd3d2, 0xd3d3, 0xd3d4, 0xd3d5,
	0xd3d6, 0xc0e5, 0xc0e8, 0xc0ec, 0xc0f4, 0xc0f5, 0xc0f7, 0xc0f9,
	0xc100, 0xc104, 0xc108, 0xc110, 0xc115, 0xc11c, 0xc11d, 0xc11e,
	0xc11f, 0xc120, 0xc123, 0xc124, 0xc126, 0xc127, 0xc12c, 0xc12d,
	0xc12f, 0xc130, 0xc131, 0xc136, 0xc138, 0xc139, 0xc13c, 0xc140,
	0xc148, 0xc149, 0xc14b, 0xc14c, 0xc14d, 0xc154, 0xc155, 0xc158,
	0xc15c, 0xc164, 0xc165, 0xc167, 0xc168, 0xc169, 0xc170, 0xc174,
	0xc178, 0xc185, 0xc18c, 0xc18d, 0xc18e, 0xc190, 0xc194, 0xc196,
	0xc19c, 0xc19d, 0xc19f, 0xc1a1, 0xc1a5, 0xc1a8, 0xc1a9, 0xc1ac,
	0xc1b0, 0xc1bd, 0xc1c4, 0xc1c8, 0xc1cc, 0xc1d4, 0xc1d7, 0xc1d8,
	0xc1e0, 0xc1e4, 0xc1e8, 0xc1f0, 0xc1f1, 0xc1f3, 0xc1fc, 0xc1fd,
	0xc200, 0xc204, 0xc20c, 0xc20d, 0xc20f, 0xc211, 0xc218, 0xc219,
	0xc21c, 0xc21f, 0xc220, 0xc228, 0xc229, 0xc22b, 0xc22d, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbd40[ 192 ] = {
	0xfffd, 0xd3d7, 0xd3d9, 0xd3da, 0xd3db, 0xd3dc, 0xd3dd, 0xd3de,
	0xd3df, 0xd3e0, 0xd3e2, 0xd3e4, 0xd3e5, 0xd3e6, 0xd3e7, 0xd3e8,
	0xd3e9, 0xd3ea, 0xd3eb, 0xd3ee, 0xd3ef, 0xd3f1, 0xd3f2, 0xd3f3,
	0xd3f5, 0xd3f6, 0xd3f7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd3f8, 0xd3f9, 0xd3fa, 0xd3fb, 0xd3fe, 0xd400, 0xd402,
	0xd403, 0xd404, 0xd405, 0xd406, 0xd407, 0xd409, 0xd40a, 0xd40b,
	0xd40c, 0xd40d, 0xd40e, 0xd40f, 0xd410, 0xd411, 0xd412, 0xd413,
	0xd414, 0xd415, 0xd416, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd417, 0xd418, 0xd419, 0xd41a, 0xd41b, 0xd41c, 0xd41e,
	0xd41f, 0xd420, 0xd421, 0xd422, 0xd423, 0xd424, 0xd425, 0xd426,
	0xd427, 0xd428, 0xd429, 0xd42a, 0xd42b, 0xd42c, 0xd42d, 0xd42e,
	0xd42f, 0xd430, 0xd431, 0xd432, 0xd433, 0xd434, 0xd435, 0xd436,
	0xd437, 0xc22f, 0xc231, 0xc232, 0xc234, 0xc248, 0xc250, 0xc251,
	0xc254, 0xc258, 0xc260, 0xc265, 0xc26c, 0xc26d, 0xc270, 0xc274,
	0xc27c, 0xc27d, 0xc27f, 0xc281, 0xc288, 0xc289, 0xc290, 0xc298,
	0xc29b, 0xc29d, 0xc2a4, 0xc2a5, 0xc2a8, 0xc2ac, 0xc2ad, 0xc2b4,
	0xc2b5, 0xc2b7, 0xc2b9, 0xc2dc, 0xc2dd, 0xc2e0, 0xc2e3, 0xc2e4,
	0xc2eb, 0xc2ec, 0xc2ed, 0xc2ef, 0xc2f1, 0xc2f6, 0xc2f8, 0xc2f9,
	0xc2fb, 0xc2fc, 0xc300, 0xc308, 0xc309, 0xc30c, 0xc30d, 0xc313,
	0xc314, 0xc315, 0xc318, 0xc31c, 0xc324, 0xc325, 0xc328, 0xc329,
	0xc345, 0xc368, 0xc369, 0xc36c, 0xc370, 0xc372, 0xc378, 0xc379,
	0xc37c, 0xc37d, 0xc384, 0xc388, 0xc38c, 0xc3c0, 0xc3d8, 0xc3d9,
	0xc3dc, 0xc3df, 0xc3e0, 0xc3e2, 0xc3e8, 0xc3e9, 0xc3ed, 0xc3f4,
	0xc3f5, 0xc3f8, 0xc408, 0xc410, 0xc424, 0xc42c, 0xc430, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbe40[ 192 ] = {
	0xfffd, 0xd438, 0xd439, 0xd43a, 0xd43b, 0xd43c, 0xd43d, 0xd43e,
	0xd43f, 0xd441, 0xd442, 0xd443, 0xd445, 0xd446, 0xd447, 0xd448,
	0xd449, 0xd44a, 0xd44b, 0xd44c, 0xd44d, 0xd44e, 0xd44f, 0xd450,
	0xd451, 0xd452, 0xd453, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd454, 0xd455, 0xd456, 0xd457, 0xd458, 0xd459, 0xd45a,
	0xd45b, 0xd45d, 0xd45e, 0xd45f, 0xd461, 0xd462, 0xd463, 0xd465,
	0xd466, 0xd467, 0xd468, 0xd469, 0xd46a, 0xd46b, 0xd46c, 0xd46e,
	0xd470, 0xd471, 0xd472, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd473, 0xd474, 0xd475, 0xd476, 0xd477, 0xd47a, 0xd47b,
	0xd47d, 0xd47e, 0xd481, 0xd483, 0xd484, 0xd485, 0xd486, 0xd487,
	0xd48a, 0xd48c, 0xd48e, 0xd48f, 0xd490, 0xd491, 0xd492, 0xd493,
	0xd495, 0xd496, 0xd497, 0xd498, 0xd499, 0xd49a, 0xd49b, 0xd49c,
	0xd49d, 0xc434, 0xc43c, 0xc43d, 0xc448, 0xc464, 0xc465, 0xc468,
	0xc46c, 0xc474, 0xc475, 0xc479, 0xc480, 0xc494, 0xc49c, 0xc4b8,
	0xc4bc, 0xc4e9, 0xc4f0, 0xc4f1, 0xc4f4, 0xc4f8, 0xc4fa, 0xc4ff,
	0xc500, 0xc501, 0xc50c, 0xc510, 0xc514, 0xc51c, 0xc528, 0xc529,
	0xc52c, 0xc530, 0xc538, 0xc539, 0xc53b, 0xc53d, 0xc544, 0xc545,
	0xc548, 0xc549, 0xc54a, 0xc54c, 0xc54d, 0xc54e, 0xc553, 0xc554,
	0xc555, 0xc557, 0xc558, 0xc559, 0xc55d, 0xc55e, 0xc560, 0xc561,
	0xc564, 0xc568, 0xc570, 0xc571, 0xc573, 0xc574, 0xc575, 0xc57c,
	0xc57d, 0xc580, 0xc584, 0xc587, 0xc58c, 0xc58d, 0xc58f, 0xc591,
	0xc595, 0xc597, 0xc598, 0xc59c, 0xc5a0, 0xc5a9, 0xc5b4, 0xc5b5,
	0xc5b8, 0xc5b9, 0xc5bb, 0xc5bc, 0xc5bd, 0xc5be, 0xc5c4, 0xc5c5,
	0xc5c6, 0xc5c7, 0xc5c8, 0xc5c9, 0xc5ca, 0xc5cc, 0xc5ce, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbf40[ 192 ] = {
	0xfffd, 0xd49e, 0xd49f, 0xd4a0, 0xd4a1, 0xd4a2, 0xd4a3, 0xd4a4,
	0xd4a5, 0xd4a6, 0xd4a7, 0xd4a8, 0xd4aa, 0xd4ab, 0xd4ac, 0xd4ad,
	0xd4ae, 0xd4af, 0xd4b0, 0xd4b1, 0xd4b2, 0xd4b3, 0xd4b4, 0xd4b5,
	0xd4b6, 0xd4b7, 0xd4b8, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd4b9, 0xd4ba, 0xd4bb, 0xd4bc, 0xd4bd, 0xd4be, 0xd4bf,
	0xd4c0, 0xd4c1, 0xd4c2, 0xd4c3, 0xd4c4, 0xd4c5, 0xd4c6, 0xd4c7,
	0xd4c8, 0xd4c9, 0xd4ca, 0xd4cb, 0xd4cd, 0xd4ce, 0xd4cf, 0xd4d1,
	0xd4d2, 0xd4d3, 0xd4d5, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd4d6, 0xd4d7, 0xd4d8, 0xd4d9, 0xd4da, 0xd4db, 0xd4dd,
	0xd4de, 0xd4e0, 0xd4e1, 0xd4e2, 0xd4e3, 0xd4e4, 0xd4e5, 0xd4e6,
	0xd4e7, 0xd4e9, 0xd4ea, 0xd4eb, 0xd4ed, 0xd4ee, 0xd4ef, 0xd4f1,
	0xd4f2, 0xd4f3, 0xd4f4, 0xd4f5, 0xd4f6, 0xd4f7, 0xd4f9, 0xd4fa,
	0xd4fc, 0xc5d0, 0xc5d1, 0xc5d4, 0xc5d8, 0xc5e0, 0xc5e1, 0xc5e3,
	0xc5e5, 0xc5ec, 0xc5ed, 0xc5ee, 0xc5f0, 0xc5f4, 0xc5f6, 0xc5f7,
	0xc5fc, 0xc5fd, 0xc5fe, 0xc5ff, 0xc600, 0xc601, 0xc605, 0xc606,
	0xc607, 0xc608, 0xc60c, 0xc610, 0xc618, 0xc619, 0xc61b, 0xc61c,
	0xc624, 0xc625, 0xc628, 0xc62c, 0xc62d, 0xc62e, 0xc630, 0xc633,
	0xc634, 0xc635, 0xc637, 0xc639, 0xc63b, 0xc640, 0xc641, 0xc644,
	0xc648, 0xc650, 0xc651, 0xc653, 0xc654, 0xc655, 0xc65c, 0xc65d,
	0xc660, 0xc66c, 0xc66f, 0xc671, 0xc678, 0xc679, 0xc67c, 0xc680,
	0xc688, 0xc689, 0xc68b, 0xc68d, 0xc694, 0xc695, 0xc698, 0xc69c,
	0xc6a4, 0xc6a5, 0xc6a7, 0xc6a9, 0xc6b0, 0xc6b1, 0xc6b4, 0xc6b8,
	0xc6b9, 0xc6ba, 0xc6c0, 0xc6c1, 0xc6c3, 0xc6c5, 0xc6cc, 0xc6cd,
	0xc6d0, 0xc6d4, 0xc6dc, 0xc6dd, 0xc6e0, 0xc6e1, 0xc6e8, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc040[ 192 ] = {
	0xfffd, 0xd4fe, 0xd4ff, 0xd500, 0xd501, 0xd502, 0xd503, 0xd505,
	0xd506, 0xd507, 0xd509, 0xd50a, 0xd50b, 0xd50d, 0xd50e, 0xd50f,
	0xd510, 0xd511, 0xd512, 0xd513, 0xd516, 0xd518, 0xd519, 0xd51a,
	0xd51b, 0xd51c, 0xd51d, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd51e, 0xd51f, 0xd520, 0xd521, 0xd522, 0xd523, 0xd524,
	0xd525, 0xd526, 0xd527, 0xd528, 0xd529, 0xd52a, 0xd52b, 0xd52c,
	0xd52d, 0xd52e, 0xd52f, 0xd530, 0xd531, 0xd532, 0xd533, 0xd534,
	0xd535, 0xd536, 0xd537, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd538, 0xd539, 0xd53a, 0xd53b, 0xd53e, 0xd53f, 0xd541,
	0xd542, 0xd543, 0xd545, 0xd546, 0xd547, 0xd548, 0xd549, 0xd54a,
	0xd54b, 0xd54e, 0xd550, 0xd552, 0xd553, 0xd554, 0xd555, 0xd556,
	0xd557, 0xd55a, 0xd55b, 0xd55d, 0xd55e, 0xd55f, 0xd561, 0xd562,
	0xd563, 0xc6e9, 0xc6ec, 0xc6f0, 0xc6f8, 0xc6f9, 0xc6fd, 0xc704,
	0xc705, 0xc708, 0xc70c, 0xc714, 0xc715, 0xc717, 0xc719, 0xc720,
	0xc721, 0xc724, 0xc728, 0xc730, 0xc731, 0xc733, 0xc735, 0xc737,
	0xc73c, 0xc73d, 0xc740, 0xc744, 0xc74a, 0xc74c, 0xc74d, 0xc74f,
	0xc751, 0xc752, 0xc753, 0xc754, 0xc755, 0xc756, 0xc757, 0xc758,
	0xc75c, 0xc760, 0xc768, 0xc76b, 0xc774, 0xc775, 0xc778, 0xc77c,
	0xc77d, 0xc77e, 0xc783, 0xc784, 0xc785, 0xc787, 0xc788, 0xc789,
	0xc78a, 0xc78e, 0xc790, 0xc791, 0xc794, 0xc796, 0xc797, 0xc798,
	0xc79a, 0xc7a0, 0xc7a1, 0xc7a3, 0xc7a4, 0xc7a5, 0xc7a6, 0xc7ac,
	0xc7ad, 0xc7b0, 0xc7b4, 0xc7bc, 0xc7bd, 0xc7bf, 0xc7c0, 0xc7c1,
	0xc7c8, 0xc7c9, 0xc7cc, 0xc7ce, 0xc7d0, 0xc7d8, 0xc7dd, 0xc7e4,
	0xc7e8, 0xc7ec, 0xc800, 0xc801, 0xc804, 0xc808, 0xc80a, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc140[ 192 ] = {
	0xfffd, 0xd564, 0xd566, 0xd567, 0xd56a, 0xd56c, 0xd56e, 0xd56f,
	0xd570, 0xd571, 0xd572, 0xd573, 0xd576, 0xd577, 0xd579, 0xd57a,
	0xd57b, 0xd57d, 0xd57e, 0xd57f, 0xd580, 0xd581, 0xd582, 0xd583,
	0xd586, 0xd58a, 0xd58b, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd58c, 0xd58d, 0xd58e, 0xd58f, 0xd591, 0xd592, 0xd593,
	0xd594, 0xd595, 0xd596, 0xd597, 0xd598, 0xd599, 0xd59a, 0xd59b,
	0xd59c, 0xd59d, 0xd59e, 0xd59f, 0xd5a0, 0xd5a1, 0xd5a2, 0xd5a3,
	0xd5a4, 0xd5a6, 0xd5a7, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd5a8, 0xd5a9, 0xd5aa, 0xd5ab, 0xd5ac, 0xd5ad, 0xd5ae,
	0xd5af, 0xd5b0, 0xd5b1, 0xd5b2, 0xd5b3, 0xd5b4, 0xd5b5, 0xd5b6,
	0xd5b7, 0xd5b8, 0xd5b9, 0xd5ba, 0xd5bb, 0xd5bc, 0xd5bd, 0xd5be,
	0xd5bf, 0xd5c0, 0xd5c1, 0xd5c2, 0xd5c3, 0xd5c4, 0xd5c5, 0xd5c6,
	0xd5c7, 0xc810, 0xc811, 0xc813, 0xc815, 0xc816, 0xc81c, 0xc81d,
	0xc820, 0xc824, 0xc82c, 0xc82d, 0xc82f, 0xc831, 0xc838, 0xc83c,
	0xc840, 0xc848, 0xc849, 0xc84c, 0xc84d, 0xc854, 0xc870, 0xc871,
	0xc874, 0xc878, 0xc87a, 0xc880, 0xc881, 0xc883, 0xc885, 0xc886,
	0xc887, 0xc88b, 0xc88c, 0xc88d, 0xc894, 0xc89d, 0xc89f, 0xc8a1,
	0xc8a8, 0xc8bc, 0xc8bd, 0xc8c4, 0xc8c8, 0xc8cc, 0xc8d4, 0xc8d5,
	0xc8d7, 0xc8d9, 0xc8e0, 0xc8e1, 0xc8e4, 0xc8f5, 0xc8fc, 0xc8fd,
	0xc900, 0xc904, 0xc905, 0xc906, 0xc90c, 0xc90d, 0xc90f, 0xc911,
	0xc918, 0xc92c, 0xc934, 0xc950, 0xc951, 0xc954, 0xc958, 0xc960,
	0xc961, 0xc963, 0xc96c, 0xc970, 0xc974, 0xc97c, 0xc988, 0xc989,
	0xc98c, 0xc990, 0xc998, 0xc999, 0xc99b, 0xc99d, 0xc9c0, 0xc9c1,
	0xc9c4, 0xc9c7, 0xc9c8, 0xc9ca, 0xc9d0, 0xc9d1, 0xc9d3, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc240[ 192 ] = {
	0xfffd, 0xd5ca, 0xd5cb, 0xd5cd, 0xd5ce, 0xd5cf, 0xd5d1, 0xd5d3,
	0xd5d4, 0xd5d5, 0xd5d6, 0xd5d7, 0xd5da, 0xd5dc, 0xd5de, 0xd5df,
	0xd5e0, 0xd5e1, 0xd5e2, 0xd5e3, 0xd5e6, 0xd5e7, 0xd5e9, 0xd5ea,
	0xd5eb, 0xd5ed, 0xd5ee, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd5ef, 0xd5f0, 0xd5f1, 0xd5f2, 0xd5f3, 0xd5f6, 0xd5f8,
	0xd5fa, 0xd5fb, 0xd5fc, 0xd5fd, 0xd5fe, 0xd5ff, 0xd602, 0xd603,
	0xd605, 0xd606, 0xd607, 0xd609, 0xd60a, 0xd60b, 0xd60c, 0xd60d,
	0xd60e, 0xd60f, 0xd612, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd616, 0xd617, 0xd618, 0xd619, 0xd61a, 0xd61b, 0xd61d,
	0xd61e, 0xd61f, 0xd621, 0xd622, 0xd623, 0xd625, 0xd626, 0xd627,
	0xd628, 0xd629, 0xd62a, 0xd62b, 0xd62c, 0xd62e, 0xd62f, 0xd630,
	0xd631, 0xd632, 0xd633, 0xd634, 0xd635, 0xd636, 0xd637, 0xd63a,
	0xd63b, 0xc9d5, 0xc9d6, 0xc9d9, 0xc9da, 0xc9dc, 0xc9dd, 0xc9e0,
	0xc9e2, 0xc9e4, 0xc9e7, 0xc9ec, 0xc9ed, 0xc9ef, 0xc9f0, 0xc9f1,
	0xc9f8, 0xc9f9, 0xc9fc, 0xca00, 0xca08, 0xca09, 0xca0b, 0xca0c,
	0xca0d, 0xca14, 0xca18, 0xca29, 0xca4c, 0xca4d, 0xca50, 0xca54,
	0xca5c, 0xca5d, 0xca5f, 0xca60, 0xca61, 0xca68, 0xca7d, 0xca84,
	0xca98, 0xcabc, 0xcabd, 0xcac0, 0xcac4, 0xcacc, 0xcacd, 0xcacf,
	0xcad1, 0xcad3, 0xcad8, 0xcad9, 0xcae0, 0xcaec, 0xcaf4, 0xcb08,
	0xcb10, 0xcb14, 0xcb18, 0xcb20, 0xcb21, 0xcb41, 0xcb48, 0xcb49,
	0xcb4c, 0xcb50, 0xcb58, 0xcb59, 0xcb5d, 0xcb64, 0xcb78, 0xcb79,
	0xcb9c, 0xcbb8, 0xcbd4, 0xcbe4, 0xcbe7, 0xcbe9, 0xcc0c, 0xcc0d,
	0xcc10, 0xcc14, 0xcc1c, 0xcc1d, 0xcc21, 0xcc22, 0xcc27, 0xcc28,
	0xcc29, 0xcc2c, 0xcc2e, 0xcc30, 0xcc38, 0xcc39, 0xcc3b, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc340[ 192 ] = {
	0xfffd, 0xd63d, 0xd63e, 0xd63f, 0xd641, 0xd642, 0xd643, 0xd644,
	0xd646, 0xd647, 0xd64a, 0xd64c, 0xd64e, 0xd64f, 0xd650, 0xd652,
	0xd653, 0xd656, 0xd657, 0xd659, 0xd65a, 0xd65b, 0xd65d, 0xd65e,
	0xd65f, 0xd660, 0xd661, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd662, 0xd663, 0xd664, 0xd665, 0xd666, 0xd668, 0xd66a,
	0xd66b, 0xd66c, 0xd66d, 0xd66e, 0xd66f, 0xd672, 0xd673, 0xd675,
	0xd676, 0xd677, 0xd678, 0xd679, 0xd67a, 0xd67b, 0xd67c, 0xd67d,
	0xd67e, 0xd67f, 0xd680, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd681, 0xd682, 0xd684, 0xd686, 0xd687, 0xd688, 0xd689,
	0xd68a, 0xd68b, 0xd68e, 0xd68f, 0xd691, 0xd692, 0xd693, 0xd695,
	0xd696, 0xd697, 0xd698, 0xd699, 0xd69a, 0xd69b, 0xd69c, 0xd69e,
	0xd6a0, 0xd6a2, 0xd6a3, 0xd6a4, 0xd6a5, 0xd6a6, 0xd6a7, 0xd6a9,
	0xd6aa, 0xcc3c, 0xcc3d, 0xcc3e, 0xcc44, 0xcc45, 0xcc48, 0xcc4c,
	0xcc54, 0xcc55, 0xcc57, 0xcc58, 0xcc59, 0xcc60, 0xcc64, 0xcc66,
	0xcc68, 0xcc70, 0xcc75, 0xcc98, 0xcc99, 0xcc9c, 0xcca0, 0xcca8,
	0xcca9, 0xccab, 0xccac, 0xccad, 0xccb4, 0xccb5, 0xccb8, 0xccbc,
	0xccc4, 0xccc5, 0xccc7, 0xccc9, 0xccd0, 0xccd4, 0xcce4, 0xccec,
	0xccf0, 0xcd01, 0xcd08, 0xcd09, 0xcd0c, 0xcd10, 0xcd18, 0xcd19,
	0xcd1b, 0xcd1d, 0xcd24, 0xcd28, 0xcd2c, 0xcd39, 0xcd5c, 0xcd60,
	0xcd64, 0xcd6c, 0xcd6d, 0xcd6f, 0xcd71, 0xcd78, 0xcd88, 0xcd94,
	0xcd95, 0xcd98, 0xcd9c, 0xcda4, 0xcda5, 0xcda7, 0xcda9, 0xcdb0,
	0xcdc4, 0xcdcc, 0xcdd0, 0xcde8, 0xcdec, 0xcdf0, 0xcdf8, 0xcdf9,
	0xcdfb, 0xcdfd, 0xce04, 0xce08, 0xce0c, 0xce14, 0xce19, 0xce20,
	0xce21, 0xce24, 0xce28, 0xce30, 0xce31, 0xce33, 0xce35, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc440[ 192 ] = {
	0xfffd, 0xd6ab, 0xd6ad, 0xd6ae, 0xd6af, 0xd6b1, 0xd6b2, 0xd6b3,
	0xd6b4, 0xd6b5, 0xd6b6, 0xd6b7, 0xd6b8, 0xd6ba, 0xd6bc, 0xd6bd,
	0xd6be, 0xd6bf, 0xd6c0, 0xd6c1, 0xd6c2, 0xd6c3, 0xd6c6, 0xd6c7,
	0xd6c9, 0xd6ca, 0xd6cb, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd6cd, 0xd6ce, 0xd6cf, 0xd6d0, 0xd6d2, 0xd6d3, 0xd6d5,
	0xd6d6, 0xd6d8, 0xd6da, 0xd6db, 0xd6dc, 0xd6dd, 0xd6de, 0xd6df,
	0xd6e1, 0xd6e2, 0xd6e3, 0xd6e5, 0xd6e6, 0xd6e7, 0xd6e9, 0xd6ea,
	0xd6eb, 0xd6ec, 0xd6ed, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd6ee, 0xd6ef, 0xd6f1, 0xd6f2, 0xd6f3, 0xd6f4, 0xd6f6,
	0xd6f7, 0xd6f8, 0xd6f9, 0xd6fa, 0xd6fb, 0xd6fe, 0xd6ff, 0xd701,
	0xd702, 0xd703, 0xd705, 0xd706, 0xd707, 0xd708, 0xd709, 0xd70a,
	0xd70b, 0xd70c, 0xd70d, 0xd70e, 0xd70f, 0xd710, 0xd712, 0xd713,
	0xd714, 0xce58, 0xce59, 0xce5c, 0xce5f, 0xce60, 0xce61, 0xce68,
	0xce69, 0xce6b, 0xce6d, 0xce74, 0xce75, 0xce78, 0xce7c, 0xce84,
	0xce85, 0xce87, 0xce89, 0xce90, 0xce91, 0xce94, 0xce98, 0xcea0,
	0xcea1, 0xcea3, 0xcea4, 0xcea5, 0xceac, 0xcead, 0xcec1, 0xcee4,
	0xcee5, 0xcee8, 0xceeb, 0xceec, 0xcef4, 0xcef5, 0xcef7, 0xcef8,
	0xcef9, 0xcf00, 0xcf01, 0xcf04, 0xcf08, 0xcf10, 0xcf11, 0xcf13,
	0xcf15, 0xcf1c, 0xcf20, 0xcf24, 0xcf2c, 0xcf2d, 0xcf2f, 0xcf30,
	0xcf31, 0xcf38, 0xcf54, 0xcf55, 0xcf58, 0xcf5c, 0xcf64, 0xcf65,
	0xcf67, 0xcf69, 0xcf70, 0xcf71, 0xcf74, 0xcf78, 0xcf80, 0xcf85,
	0xcf8c, 0xcfa1, 0xcfa8, 0xcfb0, 0xcfc4, 0xcfe0, 0xcfe1, 0xcfe4,
	0xcfe8, 0xcff0, 0xcff1, 0xcff3, 0xcff5, 0xcffc, 0xd000, 0xd004,
	0xd011, 0xd018, 0xd02d, 0xd034, 0xd035, 0xd038, 0xd03c, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc540[ 192 ] = {
	0xfffd, 0xd715, 0xd716, 0xd717, 0xd71a, 0xd71b, 0xd71d, 0xd71e,
	0xd71f, 0xd721, 0xd722, 0xd723, 0xd724, 0xd725, 0xd726, 0xd727,
	0xd72a, 0xd72c, 0xd72e, 0xd72f, 0xd730, 0xd731, 0xd732, 0xd733,
	0xd736, 0xd737, 0xd739, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd73a, 0xd73b, 0xd73d, 0xd73e, 0xd73f, 0xd740, 0xd741,
	0xd742, 0xd743, 0xd745, 0xd746, 0xd748, 0xd74a, 0xd74b, 0xd74c,
	0xd74d, 0xd74e, 0xd74f, 0xd752, 0xd753, 0xd755, 0xd75a, 0xd75b,
	0xd75c, 0xd75d, 0xd75e, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd,
	0xfffd, 0xd75f, 0xd762, 0xd764, 0xd766, 0xd767, 0xd768, 0xd76a,
	0xd76b, 0xd76d, 0xd76e, 0xd76f, 0xd771, 0xd772, 0xd773, 0xd775,
	0xd776, 0xd777, 0xd778, 0xd779, 0xd77a, 0xd77b, 0xd77e, 0xd77f,
	0xd780, 0xd782, 0xd783, 0xd784, 0xd785, 0xd786, 0xd787, 0xd78a,
	0xd78b, 0xd044, 0xd045, 0xd047, 0xd049, 0xd050, 0xd054, 0xd058,
	0xd060, 0xd06c, 0xd06d, 0xd070, 0xd074, 0xd07c, 0xd07d, 0xd081,
	0xd0a4, 0xd0a5, 0xd0a8, 0xd0ac, 0xd0b4, 0xd0b5, 0xd0b7, 0xd0b9,
	0xd0c0, 0xd0c1, 0xd0c4, 0xd0c8, 0xd0c9, 0xd0d0, 0xd0d1, 0xd0d3,
	0xd0d4, 0xd0d5, 0xd0dc, 0xd0dd, 0xd0e0, 0xd0e4, 0xd0ec, 0xd0ed,
	0xd0ef, 0xd0f0, 0xd0f1, 0xd0f8, 0xd10d, 0xd130, 0xd131, 0xd134,
	0xd138, 0xd13a, 0xd140, 0xd141, 0xd143, 0xd144, 0xd145, 0xd14c,
	0xd14d, 0xd150, 0xd154, 0xd15c, 0xd15d, 0xd15f, 0xd161, 0xd168,
	0xd16c, 0xd17c, 0xd184, 0xd188, 0xd1a0, 0xd1a1, 0xd1a4, 0xd1a8,
	0xd1b0, 0xd1b1, 0xd1b3, 0xd1b5, 0xd1ba, 0xd1bc, 0xd1c0, 0xd1d8,
	0xd1f4, 0xd1f8, 0xd207, 0xd209, 0xd210, 0xd22c, 0xd22d, 0xd230,
	0xd234, 0xd23c, 0xd23d, 0xd23f, 0xd241, 0xd248, 0xd25c, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc640[ 24 ] = {
	0xfffd, 0xd78d, 0xd78e, 0xd78f, 0xd791, 0xd792, 0xd793, 0xd794,
	0xd795, 0xd796, 0xd797, 0xd79a, 0xd79c, 0xd79e, 0xd79f, 0xd7a0,
	0xd7a1, 0xd7a2, 0xd7a3, 0xfffd, 0xfffd, 0xfffd, 0xfffd, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc6a0[ 96 ] = {
	0xfffd, 0xd264, 0xd280, 0xd281, 0xd284, 0xd288, 0xd290, 0xd291,
	0xd295, 0xd29c, 0xd2a0, 0xd2a4, 0xd2ac, 0xd2b1, 0xd2b8, 0xd2b9,
	0xd2bc, 0xd2bf, 0xd2c0, 0xd2c2, 0xd2c8, 0xd2c9, 0xd2cb, 0xd2d4,
	0xd2d8, 0xd2dc, 0xd2e4, 0xd2e5, 0xd2f0, 0xd2f1, 0xd2f4, 0xd2f8,
	0xd300, 0xd301, 0xd303, 0xd305, 0xd30c, 0xd30d, 0xd30e, 0xd310,
	0xd314, 0xd316, 0xd31c, 0xd31d, 0xd31f, 0xd320, 0xd321, 0xd325,
	0xd328, 0xd329, 0xd32c, 0xd330, 0xd338, 0xd339, 0xd33b, 0xd33c,
	0xd33d, 0xd344, 0xd345, 0xd37c, 0xd37d, 0xd380, 0xd384, 0xd38c,
	0xd38d, 0xd38f, 0xd390, 0xd391, 0xd398, 0xd399, 0xd39c, 0xd3a0,
	0xd3a8, 0xd3a9, 0xd3ab, 0xd3ad, 0xd3b4, 0xd3b8, 0xd3bc, 0xd3c4,
	0xd3c5, 0xd3c8, 0xd3c9, 0xd3d0, 0xd3d8, 0xd3e1, 0xd3e3, 0xd3ec,
	0xd3ed, 0xd3f0, 0xd3f4, 0xd3fc, 0xd3fd, 0xd3ff, 0xd401, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc7a0[ 96 ] = {
	0xfffd, 0xd408, 0xd41d, 0xd440, 0xd444, 0xd45c, 0xd460, 0xd464,
	0xd46d, 0xd46f, 0xd478, 0xd479, 0xd47c, 0xd47f, 0xd480, 0xd482,
	0xd488, 0xd489, 0xd48b, 0xd48d, 0xd494, 0xd4a9, 0xd4cc, 0xd4d0,
	0xd4d4, 0xd4dc, 0xd4df, 0xd4e8, 0xd4ec, 0xd4f0, 0xd4f8, 0xd4fb,
	0xd4fd, 0xd504, 0xd508, 0xd50c, 0xd514, 0xd515, 0xd517, 0xd53c,
	0xd53d, 0xd540, 0xd544, 0xd54c, 0xd54d, 0xd54f, 0xd551, 0xd558,
	0xd559, 0xd55c, 0xd560, 0xd565, 0xd568, 0xd569, 0xd56b, 0xd56d,
	0xd574, 0xd575, 0xd578, 0xd57c, 0xd584, 0xd585, 0xd587, 0xd588,
	0xd589, 0xd590, 0xd5a5, 0xd5c8, 0xd5c9, 0xd5cc, 0xd5d0, 0xd5d2,
	0xd5d8, 0xd5d9, 0xd5db, 0xd5dd, 0xd5e4, 0xd5e5, 0xd5e8, 0xd5ec,
	0xd5f4, 0xd5f5, 0xd5f7, 0xd5f9, 0xd600, 0xd601, 0xd604, 0xd608,
	0xd610, 0xd611, 0xd613, 0xd614, 0xd615, 0xd61c, 0xd620, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc8a0[ 96 ] = {
	0xfffd, 0xd624, 0xd62d, 0xd638, 0xd639, 0xd63c, 0xd640, 0xd645,
	0xd648, 0xd649, 0xd64b, 0xd64d, 0xd651, 0xd654, 0xd655, 0xd658,
	0xd65c, 0xd667, 0xd669, 0xd670, 0xd671, 0xd674, 0xd683, 0xd685,
	0xd68c, 0xd68d, 0xd690, 0xd694, 0xd69d, 0xd69f, 0xd6a1, 0xd6a8,
	0xd6ac, 0xd6b0, 0xd6b9, 0xd6bb, 0xd6c4, 0xd6c5, 0xd6c8, 0xd6cc,
	0xd6d1, 0xd6d4, 0xd6d7, 0xd6d9, 0xd6e0, 0xd6e4, 0xd6e8, 0xd6f0,
	0xd6f5, 0xd6fc, 0xd6fd, 0xd700, 0xd704, 0xd711, 0xd718, 0xd719,
	0xd71c, 0xd720, 0xd728, 0xd729, 0xd72b, 0xd72d, 0xd734, 0xd735,
	0xd738, 0xd73c, 0xd744, 0xd747, 0xd749, 0xd750, 0xd751, 0xd754,
	0xd756, 0xd757, 0xd758, 0xd759, 0xd760, 0xd761, 0xd763, 0xd765,
	0xd769, 0xd76c, 0xd770, 0xd774, 0xd77c, 0xd77d, 0xd781, 0xd788,
	0xd789, 0xd78c, 0xd790, 0xd798, 0xd799, 0xd79b, 0xd79d, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcaa0[ 96 ] = {
	0xfffd, 0x4f3d, 0x4f73, 0x5047, 0x50f9, 0x52a0, 0x53ef, 0x5475,
	0x54e5, 0x5609, 0x5ac1, 0x5bb6, 0x6687, 0x67b6, 0x67b7, 0x67ef,
	0x6b4c, 0x73c2, 0x75c2, 0x7a3c, 0x82db, 0x8304, 0x8857, 0x8888,
	0x8a36, 0x8cc8, 0x8dcf, 0x8efb, 0x8fe6, 0x99d5, 0x523b, 0x5374,
	0x5404, 0x606a, 0x6164, 0x6bbc, 0x73cf, 0x811a, 0x89ba, 0x89d2,
	0x95a3, 0x4f83, 0x520a, 0x58be, 0x5978, 0x59e6, 0x5e72, 0x5e79,
	0x61c7, 0x63c0, 0x6746, 0x67ec, 0x687f, 0x6f97, 0x764e, 0x770b,
	0x78f5, 0x7a08, 0x7aff, 0x7c21, 0x809d, 0x826e, 0x8271, 0x8aeb,
	0x9593, 0x4e6b, 0x559d, 0x66f7, 0x6e34, 0x78a3, 0x7aed, 0x845b,
	0x8910, 0x874e, 0x97a8, 0x52d8, 0x574e, 0x582a, 0x5d4c, 0x611f,
	0x61be, 0x6221, 0x6562, 0x67d1, 0x6a44, 0x6e1b, 0x7518, 0x75b3,
	0x76e3, 0x77b0, 0x7d3a, 0x90af, 0x9451, 0x9452, 0x9f95, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcba0[ 96 ] = {
	0xfffd, 0x5323, 0x5cac, 0x7532, 0x80db, 0x9240, 0x9598, 0x525b,
	0x5808, 0x59dc, 0x5ca1, 0x5d17, 0x5eb7, 0x5f3a, 0x5f4a, 0x6177,
	0x6c5f, 0x757a, 0x7586, 0x7ce0, 0x7d73, 0x7db1, 0x7f8c, 0x8154,
	0x8221, 0x8591, 0x8941, 0x8b1b, 0x92fc, 0x964d, 0x9c47, 0x4ecb,
	0x4ef7, 0x500b, 0x51f1, 0x584f, 0x6137, 0x613e, 0x6168, 0x6539,
	0x69ea, 0x6f11, 0x75a5, 0x7686, 0x76d6, 0x7b87, 0x82a5, 0x84cb,
	0xf900, 0x93a7, 0x958b, 0x5580, 0x5ba2, 0x5751, 0xf901, 0x7cb3,
	0x7fb9, 0x91b5, 0x5028, 0x53bb, 0x5c45, 0x5de8, 0x62d2, 0x636e,
	0x64da, 0x64e7, 0x6e20, 0x70ac, 0x795b, 0x8ddd, 0x8e1e, 0xf902,
	0x907d, 0x9245, 0x92f8, 0x4e7e, 0x4ef6, 0x5065, 0x5dfe, 0x5efa,
	0x6106, 0x6957, 0x8171, 0x8654, 0x8e47, 0x9375, 0x9a2b, 0x4e5e,
	0x5091, 0x6770, 0x6840, 0x5109, 0x528d, 0x5292, 0x6aa2, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcca0[ 96 ] = {
	0xfffd, 0x77bc, 0x9210, 0x9ed4, 0x52ab, 0x602f, 0x8ff2, 0x5048,
	0x61a9, 0x63ed, 0x64ca, 0x683c, 0x6a84, 0x6fc0, 0x8188, 0x89a1,
	0x9694, 0x5805, 0x727d, 0x72ac, 0x7504, 0x7d79, 0x7e6d, 0x80a9,
	0x898b, 0x8b74, 0x9063, 0x9d51, 0x6289, 0x6c7a, 0x6f54, 0x7d50,
	0x7f3a, 0x8a23, 0x517c, 0x614a, 0x7b9d, 0x8b19, 0x9257, 0x938c,
	0x4eac, 0x4fd3, 0x501e, 0x50be, 0x5106, 0x52c1, 0x52cd, 0x537f,
	0x5770, 0x5883, 0x5e9a, 0x5f91, 0x6176, 0x61ac, 0x64ce, 0x656c,
	0x666f, 0x66bb, 0x66f4, 0x6897, 0x6d87, 0x7085, 0x70f1, 0x749f,
	0x74a5, 0x74ca, 0x75d9, 0x786c, 0x78ec, 0x7adf, 0x7af6, 0x7d45,
	0x7d93, 0x8015, 0x803f, 0x811b, 0x8396, 0x8b66, 0x8f15, 0x9015,
	0x93e1, 0x9803, 0x9838, 0x9a5a, 0x9be8, 0x4fc2, 0x5553, 0x583a,
	0x5951, 0x5b63, 0x5c46, 0x60b8, 0x6212, 0x6842, 0x68b0, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcda0[ 96 ] = {
	0xfffd, 0x68e8, 0x6eaa, 0x754c, 0x7678, 0x78ce, 0x7a3d, 0x7cfb,
	0x7e6b, 0x7e7c, 0x8a08, 0x8aa1, 0x8c3f, 0x968e, 0x9dc4, 0x53e4,
	0x53e9, 0x544a, 0x5471, 0x56fa, 0x59d1, 0x5b64, 0x5c3b, 0x5eab,
	0x62f7, 0x6537, 0x6545, 0x6572, 0x66a0, 0x67af, 0x69c1, 0x6cbd,
	0x75fc, 0x7690, 0x777e, 0x7a3f, 0x7f94, 0x8003, 0x80a1, 0x818f,
	0x82e6, 0x82fd, 0x83f0, 0x85c1, 0x8831, 0x88b4, 0x8aa5, 0xf903,
	0x8f9c, 0x932e, 0x96c7, 0x9867, 0x9ad8, 0x9f13, 0x54ed, 0x659b,
	0x66f2, 0x688f, 0x7a40, 0x8c37, 0x9d60, 0x56f0, 0x5764, 0x5d11,
	0x6606, 0x68b1, 0x68cd, 0x6efe, 0x7428, 0x889e, 0x9be4, 0x6c68,
	0xf904, 0x9aa8, 0x4f9b, 0x516c, 0x5171, 0x529f, 0x5b54, 0x5de5,
	0x6050, 0x606d, 0x62f1, 0x63a7, 0x653b, 0x73d9, 0x7a7a, 0x86a3,
	0x8ca2, 0x978f, 0x4e32, 0x5be1, 0x6208, 0x679c, 0x74dc, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcea0[ 96 ] = {
	0xfffd, 0x79d1, 0x83d3, 0x8a87, 0x8ab2, 0x8de8, 0x904e, 0x934b,
	0x9846, 0x5ed3, 0x69e8, 0x85ff, 0x90ed, 0xf905, 0x51a0, 0x5b98,
	0x5bec, 0x6163, 0x68fa, 0x6b3e, 0x704c, 0x742f, 0x74d8, 0x7ba1,
	0x7f50, 0x83c5, 0x89c0, 0x8cab, 0x95dc, 0x9928, 0x522e, 0x605d,
	0x62ec, 0x9002, 0x4f8a, 0x5149, 0x5321, 0x58d9, 0x5ee3, 0x66e0,
	0x6d38, 0x709a, 0x72c2, 0x73d6, 0x7b50, 0x80f1, 0x945b, 0x5366,
	0x639b, 0x7f6b, 0x4e56, 0x5080, 0x584a, 0x58de, 0x602a, 0x6127,
	0x62d0, 0x69d0, 0x9b41, 0x5b8f, 0x7d18, 0x80b1, 0x8f5f, 0x4ea4,
	0x50d1, 0x54ac, 0x55ac, 0x5b0c, 0x5da0, 0x5de7, 0x652a, 0x654e,
	0x6821, 0x6a4b, 0x72e1, 0x768e, 0x77ef, 0x7d5e, 0x7ff9, 0x81a0,
	0x854e, 0x86df, 0x8f03, 0x8f4e, 0x90ca, 0x9903, 0x9a55, 0x9bab,
	0x4e18, 0x4e45, 0x4e5d, 0x4ec7, 0x4ff1, 0x5177, 0x52fe, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcfa0[ 96 ] = {
	0xfffd, 0x5340, 0x53e3, 0x53e5, 0x548e, 0x5614, 0x5775, 0x57a2,
	0x5bc7, 0x5d87, 0x5ed0, 0x61fc, 0x62d8, 0x6551, 0x67b8, 0x67e9,
	0x69cb, 0x6b50, 0x6bc6, 0x6bec, 0x6c42, 0x6e9d, 0x7078, 0x72d7,
	0x7396, 0x7403, 0x77bf, 0x77e9, 0x7a76, 0x7d7f, 0x8009, 0x81fc,
	0x8205, 0x820a, 0x82df, 0x8862, 0x8b33, 0x8cfc, 0x8ec0, 0x9011,
	0x90b1, 0x9264, 0x92b6, 0x99d2, 0x9a45, 0x9ce9, 0x9dd7, 0x9f9c,
	0x570b, 0x5c40, 0x83ca, 0x97a0, 0x97ab, 0x9eb4, 0x541b, 0x7a98,
	0x7fa4, 0x88d9, 0x8ecd, 0x90e1, 0x5800, 0x5c48, 0x6398, 0x7a9f,
	0x5bae, 0x5f13, 0x7a79, 0x7aae, 0x828e, 0x8eac, 0x5026, 0x5238,
	0x52f8, 0x5377, 0x5708, 0x62f3, 0x6372, 0x6b0a, 0x6dc3, 0x7737,
	0x53a5, 0x7357, 0x8568, 0x8e76, 0x95d5, 0x673a, 0x6ac3, 0x6f70,
	0x8a6d, 0x8ecc, 0x994b, 0xf906, 0x6677, 0x6b78, 0x8cb4, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd0a0[ 96 ] = {
	0xfffd, 0x9b3c, 0xf907, 0x53eb, 0x572d, 0x594e, 0x63c6, 0x69fb,
	0x73ea, 0x7845, 0x7aba, 0x7ac5, 0x7cfe, 0x8475, 0x898f, 0x8d73,
	0x9035, 0x95a8, 0x52fb, 0x5747, 0x7547, 0x7b60, 0x83cc, 0x921e,
	0xf908, 0x6a58, 0x514b, 0x524b, 0x5287, 0x621f, 0x68d8, 0x6975,
	0x9699, 0x50c5, 0x52a4, 0x52e4, 0x61c3, 0x65a4, 0x6839, 0x69ff,
	0x747e, 0x7b4b, 0x82b9, 0x83eb, 0x89b2, 0x8b39, 0x8fd1, 0x9949,
	0xf909, 0x4eca, 0x5997, 0x64d2, 0x6611, 0x6a8e, 0x7434, 0x7981,
	0x79bd, 0x82a9, 0x887e, 0x887f, 0x895f, 0xf90a, 0x9326, 0x4f0b,
	0x53ca, 0x6025, 0x6271, 0x6c72, 0x7d1a, 0x7d66, 0x4e98, 0x5162,
	0x77dc, 0x80af, 0x4f01, 0x4f0e, 0x5176, 0x5180, 0x55dc, 0x5668,
	0x573b, 0x57fa, 0x57fc, 0x5914, 0x5947, 0x5993, 0x5bc4, 0x5c90,
	0x5d0e, 0x5df1, 0x5e7e, 0x5fcc, 0x6280, 0x65d7, 0x65e3, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd1a0[ 96 ] = {
	0xfffd, 0x671e, 0x671f, 0x675e, 0x68cb, 0x68c4, 0x6a5f, 0x6b3a,
	0x6c23, 0x6c7d, 0x6c82, 0x6dc7, 0x7398, 0x7426, 0x742a, 0x7482,
	0x74a3, 0x7578, 0x757f, 0x7881, 0x78ef, 0x7941, 0x7947, 0x7948,
	0x797a, 0x7b95, 0x7d00, 0x7dba, 0x7f88, 0x8006, 0x802d, 0x808c,
	0x8a18, 0x8b4f, 0x8c48, 0x8d77, 0x9321, 0x9324, 0x98e2, 0x9951,
	0x9a0e, 0x9a0f, 0x9a65, 0x9e92, 0x7dca, 0x4f76, 0x5409, 0x62ee,
	0x6854, 0x91d1, 0x55ab, 0x513a, 0xf90b, 0xf90c, 0x5a1c, 0x61e6,
	0xf90d, 0x62cf, 0x62ff, 0xf90e, 0xf90f, 0xf910, 0xf911, 0xf912,
	0xf913, 0x90a3, 0xf914, 0xf915, 0xf916, 0xf917, 0xf918, 0x8afe,
	0xf919, 0xf91a, 0xf91b, 0xf91c, 0x6696, 0xf91d, 0x7156, 0xf91e,
	0xf91f, 0x96e3, 0xf920, 0x634f, 0x637a, 0x5357, 0xf921, 0x678f,
	0x6960, 0x6e73, 0xf922, 0x7537, 0xf923, 0xf924, 0xf925, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd2a0[ 96 ] = {
	0xfffd, 0x7d0d, 0xf926, 0xf927, 0x8872, 0x56ca, 0x5a18, 0xf928,
	0xf929, 0xf92a, 0xf92b, 0xf92c, 0x4e43, 0xf92d, 0x5167, 0x5948,
	0x67f0, 0x8010, 0xf92e, 0x5973, 0x5e74, 0x649a, 0x79ca, 0x5ff5,
	0x606c, 0x62c8, 0x637b, 0x5be7, 0x5bd7, 0x52aa, 0xf92f, 0x5974,
	0x5f29, 0x6012, 0xf930, 0xf931, 0xf932, 0x7459, 0xf933, 0xf934,
	0xf935, 0xf936, 0xf937, 0xf938, 0x99d1, 0xf939, 0xf93a, 0xf93b,
	0xf93c, 0xf93d, 0xf93e, 0xf93f, 0xf940, 0xf941, 0xf942, 0xf943,
	0x6fc3, 0xf944, 0xf945, 0x81bf, 0x8fb2, 0x60f1, 0xf946, 0xf947,
	0x8166, 0xf948, 0xf949, 0x5c3f, 0xf94a, 0xf94b, 0xf94c, 0xf94d,
	0xf94e, 0xf94f, 0xf950, 0xf951, 0x5ae9, 0x8a25, 0x677b, 0x7d10,
	0xf952, 0xf953, 0xf954, 0xf955, 0xf956, 0xf957, 0x80fd, 0xf958,
	0xf959, 0x5c3c, 0x6ce5, 0x533f, 0x6eba, 0x591a, 0x8336, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd3a0[ 96 ] = {
	0xfffd, 0x4e39, 0x4eb6, 0x4f46, 0x55ae, 0x5718, 0x58c7, 0x5f56,
	0x65b7, 0x65e6, 0x6a80, 0x6bb5, 0x6e4d, 0x77ed, 0x7aef, 0x7c1e,
	0x7dde, 0x86cb, 0x8892, 0x9132, 0x935b, 0x64bb, 0x6fbe, 0x737a,
	0x75b8, 0x9054, 0x5556, 0x574d, 0x61ba, 0x64d4, 0x66c7, 0x6de1,
	0x6e5b, 0x6f6d, 0x6fb9, 0x75f0, 0x8043, 0x81bd, 0x8541, 0x8983,
	0x8ac7, 0x8b5a, 0x931f, 0x6c93, 0x7553, 0x7b54, 0x8e0f, 0x905d,
	0x5510, 0x5802, 0x5858, 0x5e62, 0x6207, 0x649e, 0x68e0, 0x7576,
	0x7cd6, 0x87b3, 0x9ee8, 0x4ee3, 0x5788, 0x576e, 0x5927, 0x5c0d,
	0x5cb1, 0x5e36, 0x5f85, 0x6234, 0x64e1, 0x73b3, 0x81fa, 0x888b,
	0x8cb8, 0x968a, 0x9edb, 0x5b85, 0x5fb7, 0x60b3, 0x5012, 0x5200,
	0x5230, 0x5716, 0x5835, 0x5857, 0x5c0e, 0x5c60, 0x5cf6, 0x5d8b,
	0x5ea6, 0x5f92, 0x60bc, 0x6311, 0x6389, 0x6417, 0x6843, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd4a0[ 96 ] = {
	0xfffd, 0x68f9, 0x6ac2, 0x6dd8, 0x6e21, 0x6ed4, 0x6fe4, 0x71fe,
	0x76dc, 0x7779, 0x79b1, 0x7a3b, 0x8404, 0x89a9, 0x8ced, 0x8df3,
	0x8e48, 0x9003, 0x9014, 0x9053, 0x90fd, 0x934d, 0x9676, 0x97dc,
	0x6bd2, 0x7006, 0x7258, 0x72a2, 0x7368, 0x7763, 0x79bf, 0x7be4,
	0x7e9b, 0x8b80, 0x58a9, 0x60c7, 0x6566, 0x65fd, 0x66be, 0x6c8c,
	0x711e, 0x71c9, 0x8c5a, 0x9813, 0x4e6d, 0x7a81, 0x4edd, 0x51ac,
	0x51cd, 0x52d5, 0x540c, 0x61a7, 0x6771, 0x6850, 0x68df, 0x6d1e,
	0x6f7c, 0x75bc, 0x77b3, 0x7ae5, 0x80f4, 0x8463, 0x9285, 0x515c,
	0x6597, 0x675c, 0x6793, 0x75d8, 0x7ac7, 0x8373, 0xf95a, 0x8c46,
	0x9017, 0x982d, 0x5c6f, 0x81c0, 0x829a, 0x9041, 0x906f, 0x920d,
	0x5f97, 0x5d9d, 0x6a59, 0x71c8, 0x767b, 0x7b49, 0x85e4, 0x8b04,
	0x9127, 0x9a30, 0x5587, 0x61f6, 0xf95b, 0x7669, 0x7f85, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd5a0[ 96 ] = {
	0xfffd, 0x863f, 0x87ba, 0x88f8, 0x908f, 0xf95c, 0x6d1b, 0x70d9,
	0x73de, 0x7d61, 0x843d, 0xf95d, 0x916a, 0x99f1, 0xf95e, 0x4e82,
	0x5375, 0x6b04, 0x6b12, 0x703e, 0x721b, 0x862d, 0x9e1e, 0x524c,
	0x8fa3, 0x5d50, 0x64e5, 0x652c, 0x6b16, 0x6feb, 0x7c43, 0x7e9c,
	0x85cd, 0x8964, 0x89bd, 0x62c9, 0x81d8, 0x881f, 0x5eca, 0x6717,
	0x6d6a, 0x72fc, 0x7405, 0x746f, 0x8782, 0x90de, 0x4f86, 0x5d0d,
	0x5fa0, 0x840a, 0x51b7, 0x63a0, 0x7565, 0x4eae, 0x5006, 0x5169,
	0x51c9, 0x6881, 0x6a11, 0x7cae, 0x7cb1, 0x7ce7, 0x826f, 0x8ad2,
	0x8f1b, 0x91cf, 0x4fb6, 0x5137, 0x52f5, 0x5442, 0x5eec, 0x616e,
	0x623e, 0x65c5, 0x6ada, 0x6ffe, 0x792a, 0x85dc, 0x8823, 0x95ad,
	0x9a62, 0x9a6a, 0x9e97, 0x9ece, 0x529b, 0x66c6, 0x6b77, 0x701d,
	0x792b, 0x8f62, 0x9742, 0x6190, 0x6200, 0x6523, 0x6f23, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd6a0[ 96 ] = {
	0xfffd, 0x7149, 0x7489, 0x7df4, 0x806f, 0x84ee, 0x8f26, 0x9023,
	0x934a, 0x51bd, 0x5217, 0x52a3, 0x6d0c, 0x70c8, 0x88c2, 0x5ec9,
	0x6582, 0x6bae, 0x6fc2, 0x7c3e, 0x7375, 0x4ee4, 0x4f36, 0x56f9,
	0xf95f, 0x5cba, 0x5dba, 0x601c, 0x73b2, 0x7b2d, 0x7f9a, 0x7fce,
	0x8046, 0x901e, 0x9234, 0x96f6, 0x9748, 0x9818, 0x9f61, 0x4f8b,
	0x6fa7, 0x79ae, 0x91b4, 0x96b7, 0x52de, 0xf960, 0x6488, 0x64c4,
	0x6ad3, 0x6f5e, 0x7018, 0x7210, 0x76e7, 0x8001, 0x8606, 0x865c,
	0x8def, 0x8f05, 0x9732, 0x9b6f, 0x9dfa, 0x9e75, 0x788c, 0x797f,
	0x7da0, 0x83c9, 0x9304, 0x9e7f, 0x9e93, 0x8ad6, 0x58df, 0x5f04,
	0x6727, 0x7027, 0x74cf, 0x7c60, 0x807e, 0x5121, 0x7028, 0x7262,
	0x78ca, 0x8cc2, 0x8cda, 0x8cf4, 0x96f7, 0x4e86, 0x50da, 0x5bee,
	0x5ed6, 0x6599, 0x71ce, 0x7642, 0x77ad, 0x804a, 0x84fc, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd7a0[ 96 ] = {
	0xfffd, 0x907c, 0x9b27, 0x9f8d, 0x58d8, 0x5a41, 0x5c62, 0x6a13,
	0x6dda, 0x6f0f, 0x763b, 0x7d2f, 0x7e37, 0x851e, 0x8938, 0x93e4,
	0x964b, 0x5289, 0x65d2, 0x67f3, 0x69b4, 0x6d41, 0x6e9c, 0x700f,
	0x7409, 0x7460, 0x7559, 0x7624, 0x786b, 0x8b2c, 0x985e, 0x516d,
	0x622e, 0x9678, 0x4f96, 0x502b, 0x5d19, 0x6dea, 0x7db8, 0x8f2a,
	0x5f8b, 0x6144, 0x6817, 0xf961, 0x9686, 0x52d2, 0x808b, 0x51dc,
	0x51cc, 0x695e, 0x7a1c, 0x7dbe, 0x83f1, 0x9675, 0x4fda, 0x5229,
	0x5398, 0x540f, 0x550e, 0x5c65, 0x60a7, 0x674e, 0x68a8, 0x6d6c,
	0x7281, 0x72f8, 0x7406, 0x7483, 0xf962, 0x75e2, 0x7c6c, 0x7f79,
	0x7fb8, 0x8389, 0x88cf, 0x88e1, 0x91cc, 0x91d0, 0x96e2, 0x9bc9,
	0x541d, 0x6f7e, 0x71d0, 0x7498, 0x85fa, 0x8eaa, 0x96a3, 0x9c57,
	0x9e9f, 0x6797, 0x6dcb, 0x7433, 0x81e8, 0x9716, 0x782c, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd8a0[ 96 ] = {
	0xfffd, 0x7acb, 0x7b20, 0x7c92, 0x6469, 0x746a, 0x75f2, 0x78bc,
	0x78e8, 0x99ac, 0x9b54, 0x9ebb, 0x5bde, 0x5e55, 0x6f20, 0x819c,
	0x83ab, 0x9088, 0x4e07, 0x534d, 0x5a29, 0x5dd2, 0x5f4e, 0x6162,
	0x633d, 0x6669, 0x66fc, 0x6eff, 0x6f2b, 0x7063, 0x779e, 0x842c,
	0x8513, 0x883b, 0x8f13, 0x9945, 0x9c3b, 0x551c, 0x62b9, 0x672b,
	0x6cab, 0x8309, 0x896a, 0x977a, 0x4ea1, 0x5984, 0x5fd8, 0x5fd9,
	0x671b, 0x7db2, 0x7f54, 0x8292, 0x832b, 0x83bd, 0x8f1e, 0x9099,
	0x57cb, 0x59b9, 0x5a92, 0x5bd0, 0x6627, 0x679a, 0x6885, 0x6bcf,
	0x7164, 0x7f75, 0x8cb7, 0x8ce3, 0x9081, 0x9b45, 0x8108, 0x8c8a,
	0x964c, 0x9a40, 0x9ea5, 0x5b5f, 0x6c13, 0x731b, 0x76f2, 0x76df,
	0x840c, 0x51aa, 0x8993, 0x514d, 0x5195, 0x52c9, 0x68c9, 0x6c94,
	0x7704, 0x7720, 0x7dbf, 0x7dec, 0x9762, 0x9eb5, 0x6ec5, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd9a0[ 96 ] = {
	0xfffd, 0x8511, 0x51a5, 0x540d, 0x547d, 0x660e, 0x669d, 0x6927,
	0x6e9f, 0x76bf, 0x7791, 0x8317, 0x84c2, 0x879f, 0x9169, 0x9298,
	0x9cf4, 0x8882, 0x4fae, 0x5192, 0x52df, 0x59c6, 0x5e3d, 0x6155,
	0x6478, 0x6479, 0x66ae, 0x67d0, 0x6a21, 0x6bcd, 0x6bdb, 0x725f,
	0x7261, 0x7441, 0x7738, 0x77db, 0x8017, 0x82bc, 0x8305, 0x8b00,
	0x8b28, 0x8c8c, 0x6728, 0x6c90, 0x7267, 0x76ee, 0x7766, 0x7a46,
	0x9da9, 0x6b7f, 0x6c92, 0x5922, 0x6726, 0x8499, 0x536f, 0x5893,
	0x5999, 0x5edf, 0x63cf, 0x6634, 0x6773, 0x6e3a, 0x732b, 0x7ad7,
	0x82d7, 0x9328, 0x52d9, 0x5deb, 0x61ae, 0x61cb, 0x620a, 0x62c7,
	0x64ab, 0x65e0, 0x6959, 0x6b66, 0x6bcb, 0x7121, 0x73f7, 0x755d,
	0x7e46, 0x821e, 0x8302, 0x856a, 0x8aa3, 0x8cbf, 0x9727, 0x9d61,
	0x58a8, 0x9ed8, 0x5011, 0x520e, 0x543b, 0x554f, 0x6587, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdaa0[ 96 ] = {
	0xfffd, 0x6c76, 0x7d0a, 0x7d0b, 0x805e, 0x868a, 0x9580, 0x96ef,
	0x52ff, 0x6c95, 0x7269, 0x5473, 0x5a9a, 0x5c3e, 0x5d4b, 0x5f4c,
	0x5fae, 0x672a, 0x68b6, 0x6963, 0x6e3c, 0x6e44, 0x7709, 0x7c73,
	0x7f8e, 0x8587, 0x8b0e, 0x8ff7, 0x9761, 0x9ef4, 0x5cb7, 0x60b6,
	0x610d, 0x61ab, 0x654f, 0x65fb, 0x65fc, 0x6c11, 0x6cef, 0x739f,
	0x73c9, 0x7de1, 0x9594, 0x5bc6, 0x871c, 0x8b10, 0x525d, 0x535a,
	0x62cd, 0x640f, 0x64b2, 0x6734, 0x6a38, 0x6cca, 0x73c0, 0x749e,
	0x7b94, 0x7c95, 0x7e1b, 0x818a, 0x8236, 0x8584, 0x8feb, 0x96f9,
	0x99c1, 0x4f34, 0x534a, 0x53cd, 0x53db, 0x62cc, 0x642c, 0x6500,
	0x6591, 0x69c3, 0x6cee, 0x6f58, 0x73ed, 0x7554, 0x7622, 0x76e4,
	0x76fc, 0x78d0, 0x78fb, 0x792c, 0x7d46, 0x822c, 0x87e0, 0x8fd4,
	0x9812, 0x98ef, 0x52c3, 0x62d4, 0x64a5, 0x6e24, 0x6f51, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdba0[ 96 ] = {
	0xfffd, 0x767c, 0x8dcb, 0x91b1, 0x9262, 0x9aee, 0x9b43, 0x5023,
	0x508d, 0x574a, 0x59a8, 0x5c28, 0x5e47, 0x5f77, 0x623f, 0x653e,
	0x65b9, 0x65c1, 0x6609, 0x678b, 0x699c, 0x6ec2, 0x78c5, 0x7d21,
	0x80aa, 0x8180, 0x822b, 0x82b3, 0x84a1, 0x868c, 0x8a2a, 0x8b17,
	0x90a6, 0x9632, 0x9f90, 0x500d, 0x4ff3, 0xf963, 0x57f9, 0x5f98,
	0x62dc, 0x6392, 0x676f, 0x6e43, 0x7119, 0x76c3, 0x80cc, 0x80da,
	0x88f4, 0x88f5, 0x8919, 0x8ce0, 0x8f29, 0x914d, 0x966a, 0x4f2f,
	0x4f70, 0x5e1b, 0x67cf, 0x6822, 0x767d, 0x767e, 0x9b44, 0x5e61,
	0x6a0a, 0x7169, 0x71d4, 0x756a, 0xf964, 0x7e41, 0x8543, 0x85e9,
	0x98dc, 0x4f10, 0x7b4f, 0x7f70, 0x95a5, 0x51e1, 0x5e06, 0x68b5,
	0x6c3e, 0x6c4e, 0x6cdb, 0x72af, 0x7bc4, 0x8303, 0x6cd5, 0x743a,
	0x50fb, 0x5288, 0x58c1, 0x64d8, 0x6a97, 0x74a7, 0x7656, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdca0[ 96 ] = {
	0xfffd, 0x78a7, 0x8617, 0x95e2, 0x9739, 0xf965, 0x535e, 0x5f01,
	0x8b8a, 0x8fa8, 0x8faf, 0x908a, 0x5225, 0x77a5, 0x9c49, 0x9f08,
	0x4e19, 0x5002, 0x5175, 0x5c5b, 0x5e77, 0x661e, 0x663a, 0x67c4,
	0x68c5, 0x70b3, 0x7501, 0x75c5, 0x79c9, 0x7add, 0x8f27, 0x9920,
	0x9a08, 0x4fdd, 0x5821, 0x5831, 0x5bf6, 0x666e, 0x6b65, 0x6d11,
	0x6e7a, 0x6f7d, 0x73e4, 0x752b, 0x83e9, 0x88dc, 0x8913, 0x8b5c,
	0x8f14, 0x4f0f, 0x50d5, 0x5310, 0x535c, 0x5b93, 0x5fa9, 0x670d,
	0x798f, 0x8179, 0x832f, 0x8514, 0x8907, 0x8986, 0x8f39, 0x8f3b,
	0x99a5, 0x9c12, 0x672c, 0x4e76, 0x4ff8, 0x5949, 0x5c01, 0x5cef,
	0x5cf0, 0x6367, 0x68d2, 0x70fd, 0x71a2, 0x742b, 0x7e2b, 0x84ec,
	0x8702, 0x9022, 0x92d2, 0x9cf3, 0x4e0d, 0x4ed8, 0x4fef, 0x5085,
	0x5256, 0x526f, 0x5426, 0x5490, 0x57e0, 0x592b, 0x5a66, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdda0[ 96 ] = {
	0xfffd, 0x5b5a, 0x5b75, 0x5bcc, 0x5e9c, 0xf966, 0x6276, 0x6577,
	0x65a7, 0x6d6e, 0x6ea5, 0x7236, 0x7b26, 0x7c3f, 0x7f36, 0x8150,
	0x8151, 0x819a, 0x8240, 0x8299, 0x83a9, 0x8a03, 0x8ca0, 0x8ce6,
	0x8cfb, 0x8d74, 0x8dba, 0x90e8, 0x91dc, 0x961c, 0x9644, 0x99d9,
	0x9ce7, 0x5317, 0x5206, 0x5429, 0x5674, 0x58b3, 0x5954, 0x596e,
	0x5fff, 0x61a4, 0x626e, 0x6610, 0x6c7e, 0x711a, 0x76c6, 0x7c89,
	0x7cde, 0x7d1b, 0x82ac, 0x8cc1, 0x96f0, 0xf967, 0x4f5b, 0x5f17,
	0x5f7f, 0x62c2, 0x5d29, 0x670b, 0x68da, 0x787c, 0x7e43, 0x9d6c,
	0x4e15, 0x5099, 0x5315, 0x532a, 0x5351, 0x5983, 0x5a62, 0x5e87,
	0x60b2, 0x618a, 0x6249, 0x6279, 0x6590, 0x6787, 0x69a7, 0x6bd4,
	0x6bd6, 0x6bd7, 0x6bd8, 0x6cb8, 0xf968, 0x7435, 0x75fa, 0x7812,
	0x7891, 0x79d5, 0x79d8, 0x7c83, 0x7dcb, 0x7fe1, 0x80a5, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdea0[ 96 ] = {
	0xfffd, 0x813e, 0x81c2, 0x83f2, 0x871a, 0x88e8, 0x8ab9, 0x8b6c,
	0x8cbb, 0x9119, 0x975e, 0x98db, 0x9f3b, 0x56ac, 0x5b2a, 0x5f6c,
	0x658c, 0x6ab3, 0x6baf, 0x6d5c, 0x6ff1, 0x7015, 0x725d, 0x73ad,
	0x8ca7, 0x8cd3, 0x983b, 0x6191, 0x6c37, 0x8058, 0x9a01, 0x4e4d,
	0x4e8b, 0x4e9b, 0x4ed5, 0x4f3a, 0x4f3c, 0x4f7f, 0x4fdf, 0x50ff,
	0x53f2, 0x53f8, 0x5506, 0x55e3, 0x56db, 0x58eb, 0x5962, 0x5a11,
	0x5beb, 0x5bfa, 0x5c04, 0x5df3, 0x5e2b, 0x5f99, 0x601d, 0x6368,
	0x659c, 0x65af, 0x67f6, 0x67fb, 0x68ad, 0x6b7b, 0x6c99, 0x6cd7,
	0x6e23, 0x7009, 0x7345, 0x7802, 0x793e, 0x7940, 0x7960, 0x79c1,
	0x7be9, 0x7d17, 0x7d72, 0x8086, 0x820d, 0x838e, 0x84d1, 0x86c7,
	0x88df, 0x8a50, 0x8a5e, 0x8b1d, 0x8cdc, 0x8d66, 0x8fad, 0x90aa,
	0x98fc, 0x99df, 0x9e9d, 0x524a, 0xf969, 0x6714, 0xf96a, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdfa0[ 96 ] = {
	0xfffd, 0x5098, 0x522a, 0x5c71, 0x6563, 0x6c55, 0x73ca, 0x7523,
	0x759d, 0x7b97, 0x849c, 0x9178, 0x9730, 0x4e77, 0x6492, 0x6bba,
	0x715e, 0x85a9, 0x4e09, 0xf96b, 0x6749, 0x68ee, 0x6e17, 0x829f,
	0x8518, 0x886b, 0x63f7, 0x6f81, 0x9212, 0x98af, 0x4e0a, 0x50b7,
	0x50cf, 0x511f, 0x5546, 0x55aa, 0x5617, 0x5b40, 0x5c19, 0x5ce0,
	0x5e38, 0x5e8a, 0x5ea0, 0x5ec2, 0x60f3, 0x6851, 0x6a61, 0x6e58,
	0x723d, 0x7240, 0x72c0, 0x76f8, 0x7965, 0x7bb1, 0x7fd4, 0x88f3,
	0x89f4, 0x8a73, 0x8c61, 0x8cde, 0x971c, 0x585e, 0x74bd, 0x8cfd,
	0x55c7, 0xf96c, 0x7a61, 0x7d22, 0x8272, 0x7272, 0x751f, 0x7525,
	0xf96d, 0x7b19, 0x5885, 0x58fb, 0x5dbc, 0x5e8f, 0x5eb6, 0x5f90,
	0x6055, 0x6292, 0x637f, 0x654d, 0x6691, 0x66d9, 0x66f8, 0x6816,
	0x68f2, 0x7280, 0x745e, 0x7b6e, 0x7d6e, 0x7dd6, 0x7f72, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe0a0[ 96 ] = {
	0xfffd, 0x80e5, 0x8212, 0x85af, 0x897f, 0x8a93, 0x901d, 0x92e4,
	0x9ecd, 0x9f20, 0x5915, 0x596d, 0x5e2d, 0x60dc, 0x6614, 0x6673,
	0x6790, 0x6c50, 0x6dc5, 0x6f5f, 0x77f3, 0x78a9, 0x84c6, 0x91cb,
	0x932b, 0x4ed9, 0x50ca, 0x5148, 0x5584, 0x5b0b, 0x5ba3, 0x6247,
	0x657e, 0x65cb, 0x6e32, 0x717d, 0x7401, 0x7444, 0x7487, 0x74bf,
	0x766c, 0x79aa, 0x7dda, 0x7e55, 0x7fa8, 0x817a, 0x81b3, 0x8239,
	0x861a, 0x87ec, 0x8a75, 0x8de3, 0x9078, 0x9291, 0x9425, 0x994d,
	0x9bae, 0x5368, 0x5c51, 0x6954, 0x6cc4, 0x6d29, 0x6e2b, 0x820c,
	0x859b, 0x893b, 0x8a2d, 0x8aaa, 0x96ea, 0x9f67, 0x5261, 0x66b9,
	0x6bb2, 0x7e96, 0x87fe, 0x8d0d, 0x9583, 0x965d, 0x651d, 0x6d89,
	0x71ee, 0xf96e, 0x57ce, 0x59d3, 0x5bac, 0x6027, 0x60fa, 0x6210,
	0x661f, 0x665f, 0x7329, 0x73f9, 0x76db, 0x7701, 0x7b6c, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe1a0[ 96 ] = {
	0xfffd, 0x8056, 0x8072, 0x8165, 0x8aa0, 0x9192, 0x4e16, 0x52e2,
	0x6b72, 0x6d17, 0x7a05, 0x7b39, 0x7d30, 0xf96f, 0x8cb0, 0x53ec,
	0x562f, 0x5851, 0x5bb5, 0x5c0f, 0x5c11, 0x5de2, 0x6240, 0x6383,
	0x6414, 0x662d, 0x68b3, 0x6cbc, 0x6d88, 0x6eaf, 0x701f, 0x70a4,
	0x71d2, 0x7526, 0x758f, 0x758e, 0x7619, 0x7b11, 0x7be0, 0x7c2b,
	0x7d20, 0x7d39, 0x852c, 0x856d, 0x8607, 0x8a34, 0x900d, 0x9061,
	0x90b5, 0x92b7, 0x97f6, 0x9a37, 0x4fd7, 0x5c6c, 0x675f, 0x6d91,
	0x7c9f, 0x7e8c, 0x8b16, 0x8d16, 0x901f, 0x5b6b, 0x5dfd, 0x640d,
	0x84c0, 0x905c, 0x98e1, 0x7387, 0x5b8b, 0x609a, 0x677e, 0x6dde,
	0x8a1f, 0x8aa6, 0x9001, 0x980c, 0x5237, 0xf970, 0x7051, 0x788e,
	0x9396, 0x8870, 0x91d7, 0x4fee, 0x53d7, 0x55fd, 0x56da, 0x5782,
	0x58fd, 0x5ac2, 0x5b88, 0x5cab, 0x5cc0, 0x5e25, 0x6101, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe2a0[ 96 ] = {
	0xfffd, 0x620d, 0x624b, 0x6388, 0x641c, 0x6536, 0x6578, 0x6a39,
	0x6b8a, 0x6c34, 0x6d19, 0x6f31, 0x71e7, 0x72e9, 0x7378, 0x7407,
	0x74b2, 0x7626, 0x7761, 0x79c0, 0x7a57, 0x7aea, 0x7cb9, 0x7d8f,
	0x7dac, 0x7e61, 0x7f9e, 0x8129, 0x8331, 0x8490, 0x84da, 0x85ea,
	0x8896, 0x8ab0, 0x8b90, 0x8f38, 0x9042, 0x9083, 0x916c, 0x9296,
	0x92b9, 0x968b, 0x96a7, 0x96a8, 0x96d6, 0x9700, 0x9808, 0x9996,
	0x9ad3, 0x9b1a, 0x53d4, 0x587e, 0x5919, 0x5b70, 0x5bbf, 0x6dd1,
	0x6f5a, 0x719f, 0x7421, 0x74b9, 0x8085, 0x83fd, 0x5de1, 0x5f87,
	0x5faa, 0x6042, 0x65ec, 0x6812, 0x696f, 0x6a53, 0x6b89, 0x6d35,
	0x6df3, 0x73e3, 0x76fe, 0x77ac, 0x7b4d, 0x7d14, 0x8123, 0x821c,
	0x8340, 0x84f4, 0x8563, 0x8a62, 0x8ac4, 0x9187, 0x931e, 0x9806,
	0x99b4, 0x620c, 0x8853, 0x8ff0, 0x9265, 0x5d07, 0x5d27, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe3a0[ 96 ] = {
	0xfffd, 0x5d69, 0x745f, 0x819d, 0x8768, 0x6fd5, 0x62fe, 0x7fd2,
	0x8936, 0x8972, 0x4e1e, 0x4e58, 0x50e7, 0x52dd, 0x5347, 0x627f,
	0x6607, 0x7e69, 0x8805, 0x965e, 0x4f8d, 0x5319, 0x5636, 0x59cb,
	0x5aa4, 0x5c38, 0x5c4e, 0x5c4d, 0x5e02, 0x5f11, 0x6043, 0x65bd,
	0x662f, 0x6642, 0x67be, 0x67f4, 0x731c, 0x77e2, 0x793a, 0x7fc5,
	0x8494, 0x84cd, 0x8996, 0x8a66, 0x8a69, 0x8ae1, 0x8c55, 0x8c7a,
	0x57f4, 0x5bd4, 0x5f0f, 0x606f, 0x62ed, 0x690d, 0x6b96, 0x6e5c,
	0x7184, 0x7bd2, 0x8755, 0x8b58, 0x8efe, 0x98df, 0x98fe, 0x4f38,
	0x4f81, 0x4fe1, 0x547b, 0x5a20, 0x5bb8, 0x613c, 0x65b0, 0x6668,
	0x71fc, 0x7533, 0x795e, 0x7d33, 0x814e, 0x81e3, 0x8398, 0x85aa,
	0x85ce, 0x8703, 0x8a0a, 0x8eab, 0x8f9b, 0xf971, 0x8fc5, 0x5931,
	0x5ba4, 0x5be6, 0x6089, 0x5be9, 0x5c0b, 0x5fc3, 0x6c81, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe4a0[ 96 ] = {
	0xfffd, 0xf972, 0x6df1, 0x700b, 0x751a, 0x82af, 0x8af6, 0x4ec0,
	0x5341, 0xf973, 0x96d9, 0x6c0f, 0x4e9e, 0x4fc4, 0x5152, 0x555e,
	0x5a25, 0x5ce8, 0x6211, 0x7259, 0x82bd, 0x83aa, 0x86fe, 0x8859,
	0x8a1d, 0x963f, 0x96c5, 0x9913, 0x9d09, 0x9d5d, 0x580a, 0x5cb3,
	0x5dbd, 0x5e44, 0x60e1, 0x6115, 0x63e1, 0x6a02, 0x6e25, 0x9102,
	0x9354, 0x984e, 0x9c10, 0x9f77, 0x5b89, 0x5cb8, 0x6309, 0x664f,
	0x6848, 0x773c, 0x96c1, 0x978d, 0x9854, 0x9b9f, 0x65a1, 0x8b01,
	0x8ecb, 0x95bc, 0x5535, 0x5ca9, 0x5dd6, 0x5eb5, 0x6697, 0x764c,
	0x83f4, 0x95c7, 0x58d3, 0x62bc, 0x72ce, 0x9d28, 0x4ef0, 0x592e,
	0x600f, 0x663b, 0x6b83, 0x79e7, 0x9d26, 0x5393, 0x54c0, 0x57c3,
	0x5d16, 0x611b, 0x66d6, 0x6daf, 0x788d, 0x827e, 0x9698, 0x9744,
	0x5384, 0x627c, 0x6396, 0x6db2, 0x7e0a, 0x814b, 0x984d, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe5a0[ 96 ] = {
	0xfffd, 0x6afb, 0x7f4c, 0x9daf, 0x9e1a, 0x4e5f, 0x503b, 0x51b6,
	0x591c, 0x60f9, 0x63f6, 0x6930, 0x723a, 0x8036, 0xf974, 0x91ce,
	0x5f31, 0xf975, 0xf976, 0x7d04, 0x82e5, 0x846f, 0x84bb, 0x85e5,
	0x8e8d, 0xf977, 0x4f6f, 0xf978, 0xf979, 0x58e4, 0x5b43, 0x6059,
	0x63da, 0x6518, 0x656d, 0x6698, 0xf97a, 0x694a, 0x6a23, 0x6d0b,
	0x7001, 0x716c, 0x75d2, 0x760d, 0x79b3, 0x7a70, 0xf97b, 0x7f8a,
	0xf97c, 0x8944, 0xf97d, 0x8b93, 0x91c0, 0x967d, 0xf97e, 0x990a,
	0x5704, 0x5fa1, 0x65bc, 0x6f01, 0x7600, 0x79a6, 0x8a9e, 0x99ad,
	0x9b5a, 0x9f6c, 0x5104, 0x61b6, 0x6291, 0x6a8d, 0x81c6, 0x5043,
	0x5830, 0x5f66, 0x7109, 0x8a00, 0x8afa, 0x5b7c, 0x8616, 0x4ffa,
	0x513c, 0x56b4, 0x5944, 0x63a9, 0x6df9, 0x5daa, 0x696d, 0x5186,
	0x4e88, 0x4f59, 0xf97f, 0xf980, 0xf981, 0x5982, 0xf982, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe6a0[ 96 ] = {
	0xfffd, 0xf983, 0x6b5f, 0x6c5d, 0xf984, 0x74b5, 0x7916, 0xf985,
	0x8207, 0x8245, 0x8339, 0x8f3f, 0x8f5d, 0xf986, 0x9918, 0xf987,
	0xf988, 0xf989, 0x4ea6, 0xf98a, 0x57df, 0x5f79, 0x6613, 0xf98b,
	0xf98c, 0x75ab, 0x7e79, 0x8b6f, 0xf98d, 0x9006, 0x9a5b, 0x56a5,
	0x5827, 0x59f8, 0x5a1f, 0x5bb4, 0xf98e, 0x5ef6, 0xf98f, 0xf990,
	0x6350, 0x633b, 0xf991, 0x693d, 0x6c87, 0x6cbf, 0x6d8e, 0x6d93,
	0x6df5, 0x6f14, 0xf992, 0x70df, 0x7136, 0x7159, 0xf993, 0x71c3,
	0x71d5, 0xf994, 0x784f, 0x786f, 0xf995, 0x7b75, 0x7de3, 0xf996,
	0x7e2f, 0xf997, 0x884d, 0x8edf, 0xf998, 0xf999, 0xf99a, 0x925b,
	0xf99b, 0x9cf6, 0xf99c, 0xf99d, 0xf99e, 0x6085, 0x6d85, 0xf99f,
	0x71b1, 0xf9a0, 0xf9a1, 0x95b1, 0x53ad, 0xf9a2, 0xf9a3, 0xf9a4,
	0x67d3, 0xf9a5, 0x708e, 0x7130, 0x7430, 0x8276, 0x82d2, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe7a0[ 96 ] = {
	0xfffd, 0xf9a6, 0x95bb, 0x9ae5, 0x9e7d, 0x66c4, 0xf9a7, 0x71c1,
	0x8449, 0xf9a8, 0xf9a9, 0x584b, 0xf9aa, 0xf9ab, 0x5db8, 0x5f71,
	0xf9ac, 0x6620, 0x668e, 0x6979, 0x69ae, 0x6c38, 0x6cf3, 0x6e36,
	0x6f41, 0x6fda, 0x701b, 0x702f, 0x7150, 0x71df, 0x7370, 0xf9ad,
	0x745b, 0xf9ae, 0x74d4, 0x76c8, 0x7a4e, 0x7e93, 0xf9af, 0xf9b0,
	0x82f1, 0x8a60, 0x8fce, 0xf9b1, 0x9348, 0xf9b2, 0x9719, 0xf9b3,
	0xf9b4, 0x4e42, 0x502a, 0xf9b5, 0x5208, 0x53e1, 0x66f3, 0x6c6d,
	0x6fca, 0x730a, 0x777f, 0x7a62, 0x82ae, 0x85dd, 0x8602, 0xf9b6,
	0x88d4, 0x8a63, 0x8b7d, 0x8c6b, 0xf9b7, 0x92b3, 0xf9b8, 0x9713,
	0x9810, 0x4e94, 0x4f0d, 0x4fc9, 0x50b2, 0x5348, 0x543e, 0x5433,
	0x55da, 0x5862, 0x58ba, 0x5967, 0x5a1b, 0x5be4, 0x609f, 0xf9b9,
	0x61ca, 0x6556, 0x65ff, 0x6664, 0x68a7, 0x6c5a, 0x6fb3, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe8a0[ 96 ] = {
	0xfffd, 0x70cf, 0x71ac, 0x7352, 0x7b7d, 0x8708, 0x8aa4, 0x9c32,
	0x9f07, 0x5c4b, 0x6c83, 0x7344, 0x7389, 0x923a, 0x6eab, 0x7465,
	0x761f, 0x7a69, 0x7e15, 0x860a, 0x5140, 0x58c5, 0x64c1, 0x74ee,
	0x7515, 0x7670, 0x7fc1, 0x9095, 0x96cd, 0x9954, 0x6e26, 0x74e6,
	0x7aa9, 0x7aaa, 0x81e5, 0x86d9, 0x8778, 0x8a1b, 0x5a49, 0x5b8c,
	0x5b9b, 0x68a1, 0x6900, 0x6d63, 0x73a9, 0x7413, 0x742c, 0x7897,
	0x7de9, 0x7feb, 0x8118, 0x8155, 0x839e, 0x8c4c, 0x962e, 0x9811,
	0x66f0, 0x5f80, 0x65fa, 0x6789, 0x6c6a, 0x738b, 0x502d, 0x5a03,
	0x6b6a, 0x77ee, 0x5916, 0x5d6c, 0x5dcd, 0x7325, 0x754f, 0xf9ba,
	0xf9bb, 0x50e5, 0x51f9, 0x582f, 0x592d, 0x5996, 0x59da, 0x5be5,
	0xf9bc, 0xf9bd, 0x5da2, 0x62d7, 0x6416, 0x6493, 0x64fe, 0xf9be,
	0x66dc, 0xf9bf, 0x6a48, 0xf9c0, 0x71ff, 0x7464, 0xf9c1, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe9a0[ 96 ] = {
	0xfffd, 0x7a88, 0x7aaf, 0x7e47, 0x7e5e, 0x8000, 0x8170, 0xf9c2,
	0x87ef, 0x8981, 0x8b20, 0x9059, 0xf9c3, 0x9080, 0x9952, 0x617e,
	0x6b32, 0x6d74, 0x7e1f, 0x8925, 0x8fb1, 0x4fd1, 0x50ad, 0x5197,
	0x52c7, 0x57c7, 0x5889, 0x5bb9, 0x5eb8, 0x6142, 0x6995, 0x6d8c,
	0x6e67, 0x6eb6, 0x7194, 0x7462, 0x7528, 0x752c, 0x8073, 0x8338,
	0x84c9, 0x8e0a, 0x9394, 0x93de, 0xf9c4, 0x4e8e, 0x4f51, 0x5076,
	0x512a, 0x53c8, 0x53cb, 0x53f3, 0x5b87, 0x5bd3, 0x5c24, 0x611a,
	0x6182, 0x65f4, 0x725b, 0x7397, 0x7440, 0x76c2, 0x7950, 0x7991,
	0x79b9, 0x7d06, 0x7fbd, 0x828b, 0x85d5, 0x865e, 0x8fc2, 0x9047,
	0x90f5, 0x91ea, 0x9685, 0x96e8, 0x96e9, 0x52d6, 0x5f67, 0x65ed,
	0x6631, 0x682f, 0x715c, 0x7a36, 0x90c1, 0x980a, 0x4e91, 0xf9c5,
	0x6a52, 0x6b9e, 0x6f90, 0x7189, 0x8018, 0x82b8, 0x8553, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeaa0[ 96 ] = {
	0xfffd, 0x904b, 0x9695, 0x96f2, 0x97fb, 0x851a, 0x9b31, 0x4e90,
	0x718a, 0x96c4, 0x5143, 0x539f, 0x54e1, 0x5713, 0x5712, 0x57a3,
	0x5a9b, 0x5ac4, 0x5bc3, 0x6028, 0x613f, 0x63f4, 0x6c85, 0x6d39,
	0x6e72, 0x6e90, 0x7230, 0x733f, 0x7457, 0x82d1, 0x8881, 0x8f45,
	0x9060, 0xf9c6, 0x9662, 0x9858, 0x9d1b, 0x6708, 0x8d8a, 0x925e,
	0x4f4d, 0x5049, 0x50de, 0x5371, 0x570d, 0x59d4, 0x5a01, 0x5c09,
	0x6170, 0x6690, 0x6e2d, 0x7232, 0x744b, 0x7def, 0x80c3, 0x840e,
	0x8466, 0x853f, 0x875f, 0x885b, 0x8918, 0x8b02, 0x9055, 0x97cb,
	0x9b4f, 0x4e73, 0x4f91, 0x5112, 0x516a, 0xf9c7, 0x552f, 0x55a9,
	0x5b7a, 0x5ba5, 0x5e7c, 0x5e7d, 0x5ebe, 0x60a0, 0x60df, 0x6108,
	0x6109, 0x63c4, 0x6538, 0x6709, 0xf9c8, 0x67d4, 0x67da, 0xf9c9,
	0x6961, 0x6962, 0x6cb9, 0x6d27, 0xf9ca, 0x6e38, 0xf9cb, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeba0[ 96 ] = {
	0xfffd, 0x6fe1, 0x7336, 0x7337, 0xf9cc, 0x745c, 0x7531, 0xf9cd,
	0x7652, 0xf9ce, 0xf9cf, 0x7dad, 0x81fe, 0x8438, 0x88d5, 0x8a98,
	0x8adb, 0x8aed, 0x8e30, 0x8e42, 0x904a, 0x903e, 0x907a, 0x9149,
	0x91c9, 0x936e, 0xf9d0, 0xf9d1, 0x5809, 0xf9d2, 0x6bd3, 0x8089,
	0x80b2, 0xf9d3, 0xf9d4, 0x5141, 0x596b, 0x5c39, 0xf9d5, 0xf9d6,
	0x6f64, 0x73a7, 0x80e4, 0x8d07, 0xf9d7, 0x9217, 0x958f, 0xf9d8,
	0xf9d9, 0xf9da, 0xf9db, 0x807f, 0x620e, 0x701c, 0x7d68, 0x878d,
	0xf9dc, 0x57a0, 0x6069, 0x6147, 0x6bb7, 0x8abe, 0x9280, 0x96b1,
	0x4e59, 0x541f, 0x6deb, 0x852d, 0x9670, 0x97f3, 0x98ee, 0x63d6,
	0x6ce3, 0x9091, 0x51dd, 0x61c9, 0x81ba, 0x9df9, 0x4f9d, 0x501a,
	0x5100, 0x5b9c, 0x610f, 0x61ff, 0x64ec, 0x6905, 0x6bc5, 0x7591,
	0x77e3, 0x7fa9, 0x8264, 0x858f, 0x87fb, 0x8863, 0x8abc, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeca0[ 96 ] = {
	0xfffd, 0x8b70, 0x91ab, 0x4e8c, 0x4ee5, 0x4f0a, 0xf9dd, 0xf9de,
	0x5937, 0x59e8, 0xf9df, 0x5df2, 0x5f1b, 0x5f5b, 0x6021, 0xf9e0,
	0xf9e1, 0xf9e2, 0xf9e3, 0x723e, 0x73e5, 0xf9e4, 0x7570, 0x75cd,
	0xf9e5, 0x79fb, 0xf9e6, 0x800c, 0x8033, 0x8084, 0x82e1, 0x8351,
	0xf9e7, 0xf9e8, 0x8cbd, 0x8cb3, 0x9087, 0xf9e9, 0xf9ea, 0x98f4,
	0x990c, 0xf9eb, 0xf9ec, 0x7037, 0x76ca, 0x7fca, 0x7fcc, 0x7ffc,
	0x8b1a, 0x4eba, 0x4ec1, 0x5203, 0x5370, 0xf9ed, 0x54bd, 0x56e0,
	0x59fb, 0x5bc5, 0x5f15, 0x5fcd, 0x6e6e, 0xf9ee, 0xf9ef, 0x7d6a,
	0x8335, 0xf9f0, 0x8693, 0x8a8d, 0xf9f1, 0x976d, 0x9777, 0xf9f2,
	0xf9f3, 0x4e00, 0x4f5a, 0x4f7e, 0x58f9, 0x65e5, 0x6ea2, 0x9038,
	0x93b0, 0x99b9, 0x4efb, 0x58ec, 0x598a, 0x59d9, 0x6041, 0xf9f4,
	0xf9f5, 0x7a14, 0xf9f6, 0x834f, 0x8cc3, 0x5165, 0x5344, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeda0[ 96 ] = {
	0xfffd, 0xf9f7, 0xf9f8, 0xf9f9, 0x4ecd, 0x5269, 0x5b55, 0x82bf,
	0x4ed4, 0x523a, 0x54a8, 0x59c9, 0x59ff, 0x5b50, 0x5b57, 0x5b5c,
	0x6063, 0x6148, 0x6ecb, 0x7099, 0x716e, 0x7386, 0x74f7, 0x75b5,
	0x78c1, 0x7d2b, 0x8005, 0x81ea, 0x8328, 0x8517, 0x85c9, 0x8aee,
	0x8cc7, 0x96cc, 0x4f5c, 0x52fa, 0x56bc, 0x65ab, 0x6628, 0x707c,
	0x70b8, 0x7235, 0x7dbd, 0x828d, 0x914c, 0x96c0, 0x9d72, 0x5b71,
	0x68e7, 0x6b98, 0x6f7a, 0x76de, 0x5c91, 0x66ab, 0x6f5b, 0x7bb4,
	0x7c2a, 0x8836, 0x96dc, 0x4e08, 0x4ed7, 0x5320, 0x5834, 0x58bb,
	0x58ef, 0x596c, 0x5c07, 0x5e33, 0x5e84, 0x5f35, 0x638c, 0x66b2,
	0x6756, 0x6a1f, 0x6aa3, 0x6b0c, 0x6f3f, 0x7246, 0xf9fa, 0x7350,
	0x748b, 0x7ae0, 0x7ca7, 0x8178, 0x81df, 0x81e7, 0x838a, 0x846c,
	0x8523, 0x8594, 0x85cf, 0x88dd, 0x8d13, 0x91ac, 0x9577, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeea0[ 96 ] = {
	0xfffd, 0x969c, 0x518d, 0x54c9, 0x5728, 0x5bb0, 0x624d, 0x6750,
	0x683d, 0x6893, 0x6e3d, 0x6ed3, 0x707d, 0x7e21, 0x88c1, 0x8ca1,
	0x8f09, 0x9f4b, 0x9f4e, 0x722d, 0x7b8f, 0x8acd, 0x931a, 0x4f47,
	0x4f4e, 0x5132, 0x5480, 0x59d0, 0x5e95, 0x62b5, 0x6775, 0x696e,
	0x6a17, 0x6cae, 0x6e1a, 0x72d9, 0x732a, 0x75bd, 0x7bb8, 0x7d35,
	0x82e7, 0x83f9, 0x8457, 0x85f7, 0x8a5b, 0x8caf, 0x8e87, 0x9019,
	0x90b8, 0x96ce, 0x9f5f, 0x52e3, 0x540a, 0x5ae1, 0x5bc2, 0x6458,
	0x6575, 0x6ef4, 0x72c4, 0xf9fb, 0x7684, 0x7a4d, 0x7b1b, 0x7c4d,
	0x7e3e, 0x7fdf, 0x837b, 0x8b2b, 0x8cca, 0x8d64, 0x8de1, 0x8e5f,
	0x8fea, 0x8ff9, 0x9069, 0x93d1, 0x4f43, 0x4f7a, 0x50b3, 0x5168,
	0x5178, 0x524d, 0x526a, 0x5861, 0x587c, 0x5960, 0x5c08, 0x5c55,
	0x5edb, 0x609b, 0x6230, 0x6813, 0x6bbf, 0x6c08, 0x6fb1, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xefa0[ 96 ] = {
	0xfffd, 0x714e, 0x7420, 0x7530, 0x7538, 0x7551, 0x7672, 0x7b4c,
	0x7b8b, 0x7bad, 0x7bc6, 0x7e8f, 0x8a6e, 0x8f3e, 0x8f49, 0x923f,
	0x9293, 0x9322, 0x942b, 0x96fb, 0x985a, 0x986b, 0x991e, 0x5207,
	0x622a, 0x6298, 0x6d59, 0x7664, 0x7aca, 0x7bc0, 0x7d76, 0x5360,
	0x5cbe, 0x5e97, 0x6f38, 0x70b9, 0x7c98, 0x9711, 0x9b8e, 0x9ede,
	0x63a5, 0x647a, 0x8776, 0x4e01, 0x4e95, 0x4ead, 0x505c, 0x5075,
	0x5448, 0x59c3, 0x5b9a, 0x5e40, 0x5ead, 0x5ef7, 0x5f81, 0x60c5,
	0x633a, 0x653f, 0x6574, 0x65cc, 0x6676, 0x6678, 0x67fe, 0x6968,
	0x6a89, 0x6b63, 0x6c40, 0x6dc0, 0x6de8, 0x6e1f, 0x6e5e, 0x701e,
	0x70a1, 0x738e, 0x73fd, 0x753a, 0x775b, 0x7887, 0x798e, 0x7a0b,
	0x7a7d, 0x7cbe, 0x7d8e, 0x8247, 0x8a02, 0x8aea, 0x8c9e, 0x912d,
	0x914a, 0x91d8, 0x9266, 0x92cc, 0x9320, 0x9706, 0x9756, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf0a0[ 96 ] = {
	0xfffd, 0x975c, 0x9802, 0x9f0e, 0x5236, 0x5291, 0x557c, 0x5824,
	0x5e1d, 0x5f1f, 0x608c, 0x63d0, 0x68af, 0x6fdf, 0x796d, 0x7b2c,
	0x81cd, 0x85ba, 0x88fd, 0x8af8, 0x8e44, 0x918d, 0x9664, 0x969b,
	0x973d, 0x984c, 0x9f4a, 0x4fce, 0x5146, 0x51cb, 0x52a9, 0x5632,
	0x5f14, 0x5f6b, 0x63aa, 0x64cd, 0x65e9, 0x6641, 0x66fa, 0x66f9,
	0x671d, 0x689d, 0x68d7, 0x69fd, 0x6f15, 0x6f6e, 0x7167, 0x71e5,
	0x722a, 0x74aa, 0x773a, 0x7956, 0x795a, 0x79df, 0x7a20, 0x7a95,
	0x7c97, 0x7cdf, 0x7d44, 0x7e70, 0x8087, 0x85fb, 0x86a4, 0x8a54,
	0x8abf, 0x8d99, 0x8e81, 0x9020, 0x906d, 0x91e3, 0x963b, 0x96d5,
	0x9ce5, 0x65cf, 0x7c07, 0x8db3, 0x93c3, 0x5b58, 0x5c0a, 0x5352,
	0x62d9, 0x731d, 0x5027, 0x5b97, 0x5f9e, 0x60b0, 0x616b, 0x68d5,
	0x6dd9, 0x742e, 0x7a2e, 0x7d42, 0x7d9c, 0x7e31, 0x816b, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf1a0[ 96 ] = {
	0xfffd, 0x8e2a, 0x8e35, 0x937e, 0x9418, 0x4f50, 0x5750, 0x5de6,
	0x5ea7, 0x632b, 0x7f6a, 0x4e3b, 0x4f4f, 0x4f8f, 0x505a, 0x59dd,
	0x80c4, 0x546a, 0x5468, 0x55fe, 0x594f, 0x5b99, 0x5dde, 0x5eda,
	0x665d, 0x6731, 0x67f1, 0x682a, 0x6ce8, 0x6d32, 0x6e4a, 0x6f8d,
	0x70b7, 0x73e0, 0x7587, 0x7c4c, 0x7d02, 0x7d2c, 0x7da2, 0x821f,
	0x86db, 0x8a3b, 0x8a85, 0x8d70, 0x8e8a, 0x8f33, 0x9031, 0x914e,
	0x9152, 0x9444, 0x99d0, 0x7af9, 0x7ca5, 0x4fca, 0x5101, 0x51c6,
	0x57c8, 0x5bef, 0x5cfb, 0x6659, 0x6a3d, 0x6d5a, 0x6e96, 0x6fec,
	0x710c, 0x756f, 0x7ae3, 0x8822, 0x9021, 0x9075, 0x96cb, 0x99ff,
	0x8301, 0x4e2d, 0x4ef2, 0x8846, 0x91cd, 0x537d, 0x6adb, 0x696b,
	0x6c41, 0x847a, 0x589e, 0x618e, 0x66fe, 0x62ef, 0x70dd, 0x7511,
	0x75c7, 0x7e52, 0x84b8, 0x8b49, 0x8d08, 0x4e4b, 0x53ea, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf2a0[ 96 ] = {
	0xfffd, 0x54ab, 0x5730, 0x5740, 0x5fd7, 0x6301, 0x6307, 0x646f,
	0x652f, 0x65e8, 0x667a, 0x679d, 0x67b3, 0x6b62, 0x6c60, 0x6c9a,
	0x6f2c, 0x77e5, 0x7825, 0x7949, 0x7957, 0x7d19, 0x80a2, 0x8102,
	0x81f3, 0x829d, 0x82b7, 0x8718, 0x8a8c, 0xf9fc, 0x8d04, 0x8dbe,
	0x9072, 0x76f4, 0x7a19, 0x7a37, 0x7e54, 0x8077, 0x5507, 0x55d4,
	0x5875, 0x632f, 0x6422, 0x6649, 0x664b, 0x686d, 0x699b, 0x6b84,
	0x6d25, 0x6eb1, 0x73cd, 0x7468, 0x74a1, 0x755b, 0x75b9, 0x76e1,
	0x771e, 0x778b, 0x79e6, 0x7e09, 0x7e1d, 0x81fb, 0x852f, 0x8897,
	0x8a3a, 0x8cd1, 0x8eeb, 0x8fb0, 0x9032, 0x93ad, 0x9663, 0x9673,
	0x9707, 0x4f84, 0x53f1, 0x59ea, 0x5ac9, 0x5e19, 0x684e, 0x74c6,
	0x75be, 0x79e9, 0x7a92, 0x81a3, 0x86ed, 0x8cea, 0x8dcc, 0x8fed,
	0x659f, 0x6715, 0xf9fd, 0x57f7, 0x6f57, 0x7ddd, 0x8f2f, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf3a0[ 96 ] = {
	0xfffd, 0x93f6, 0x96c6, 0x5fb5, 0x61f2, 0x6f84, 0x4e14, 0x4f98,
	0x501f, 0x53c9, 0x55df, 0x5d6f, 0x5dee, 0x6b21, 0x6b64, 0x78cb,
	0x7b9a, 0xf9fe, 0x8e49, 0x8eca, 0x906e, 0x6349, 0x643e, 0x7740,
	0x7a84, 0x932f, 0x947f, 0x9f6a, 0x64b0, 0x6faf, 0x71e6, 0x74a8,
	0x74da, 0x7ac4, 0x7c12, 0x7e82, 0x7cb2, 0x7e98, 0x8b9a, 0x8d0a,
	0x947d, 0x9910, 0x994c, 0x5239, 0x5bdf, 0x64e6, 0x672d, 0x7d2e,
	0x50ed, 0x53c3, 0x5879, 0x6158, 0x6159, 0x61fa, 0x65ac, 0x7ad9,
	0x8b92, 0x8b96, 0x5009, 0x5021, 0x5275, 0x5531, 0x5a3c, 0x5ee0,
	0x5f70, 0x6134, 0x655e, 0x660c, 0x6636, 0x66a2, 0x69cd, 0x6ec4,
	0x6f32, 0x7316, 0x7621, 0x7a93, 0x8139, 0x8259, 0x83d6, 0x84bc,
	0x50b5, 0x57f0, 0x5bc0, 0x5be8, 0x5f69, 0x63a1, 0x7826, 0x7db5,
	0x83dc, 0x8521, 0x91c7, 0x91f5, 0x518a, 0x67f5, 0x7b56, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf4a0[ 96 ] = {
	0xfffd, 0x8cac, 0x51c4, 0x59bb, 0x60bd, 0x8655, 0x501c, 0xf9ff,
	0x5254, 0x5c3a, 0x617d, 0x621a, 0x62d3, 0x64f2, 0x65a5, 0x6ecc,
	0x7620, 0x810a, 0x8e60, 0x965f, 0x96bb, 0x4edf, 0x5343, 0x5598,
	0x5929, 0x5ddd, 0x64c5, 0x6cc9, 0x6dfa, 0x7394, 0x7a7f, 0x821b,
	0x85a6, 0x8ce4, 0x8e10, 0x9077, 0x91e7, 0x95e1, 0x9621, 0x97c6,
	0x51f8, 0x54f2, 0x5586, 0x5fb9, 0x64a4, 0x6f88, 0x7db4, 0x8f1f,
	0x8f4d, 0x9435, 0x50c9, 0x5c16, 0x6cbe, 0x6dfb, 0x751b, 0x77bb,
	0x7c3d, 0x7c64, 0x8a79, 0x8ac2, 0x581e, 0x59be, 0x5e16, 0x6377,
	0x7252, 0x758a, 0x776b, 0x8adc, 0x8cbc, 0x8f12, 0x5ef3, 0x6674,
	0x6df8, 0x807d, 0x83c1, 0x8acb, 0x9751, 0x9bd6, 0xfa00, 0x5243,
	0x66ff, 0x6d95, 0x6eef, 0x7de0, 0x8ae6, 0x902e, 0x905e, 0x9ad4,
	0x521d, 0x527f, 0x54e8, 0x6194, 0x6284, 0x62db, 0x68a2, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf5a0[ 96 ] = {
	0xfffd, 0x6912, 0x695a, 0x6a35, 0x7092, 0x7126, 0x785d, 0x7901,
	0x790e, 0x79d2, 0x7a0d, 0x8096, 0x8278, 0x82d5, 0x8349, 0x8549,
	0x8c82, 0x8d85, 0x9162, 0x918b, 0x91ae, 0x4fc3, 0x56d1, 0x71ed,
	0x77d7, 0x8700, 0x89f8, 0x5bf8, 0x5fd6, 0x6751, 0x90a8, 0x53e2,
	0x585a, 0x5bf5, 0x60a4, 0x6181, 0x6460, 0x7e3d, 0x8070, 0x8525,
	0x9283, 0x64ae, 0x50ac, 0x5d14, 0x6700, 0x589c, 0x62bd, 0x63a8,
	0x690e, 0x6978, 0x6a1e, 0x6e6b, 0x76ba, 0x79cb, 0x82bb, 0x8429,
	0x8acf, 0x8da8, 0x8ffd, 0x9112, 0x914b, 0x919c, 0x9310, 0x9318,
	0x939a, 0x96db, 0x9a36, 0x9c0d, 0x4e11, 0x755c, 0x795d, 0x7afa,
	0x7b51, 0x7bc9, 0x7e2e, 0x84c4, 0x8e59, 0x8e74, 0x8ef8, 0x9010,
	0x6625, 0x693f, 0x7443, 0x51fa, 0x672e, 0x9edc, 0x5145, 0x5fe0,
	0x6c96, 0x87f2, 0x885d, 0x8877, 0x60b4, 0x81b5, 0x8403, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf6a0[ 96 ] = {
	0xfffd, 0x8d05, 0x53d6, 0x5439, 0x5634, 0x5a36, 0x5c31, 0x708a,
	0x7fe0, 0x805a, 0x8106, 0x81ed, 0x8da3, 0x9189, 0x9a5f, 0x9df2,
	0x5074, 0x4ec4, 0x53a0, 0x60fb, 0x6e2c, 0x5c64, 0x4f88, 0x5024,
	0x55e4, 0x5cd9, 0x5e5f, 0x6065, 0x6894, 0x6cbb, 0x6dc4, 0x71be,
	0x75d4, 0x75f4, 0x7661, 0x7a1a, 0x7a49, 0x7dc7, 0x7dfb, 0x7f6e,
	0x81f4, 0x86a9, 0x8f1c, 0x96c9, 0x99b3, 0x9f52, 0x5247, 0x52c5,
	0x98ed, 0x89aa, 0x4e03, 0x67d2, 0x6f06, 0x4fb5, 0x5be2, 0x6795,
	0x6c88, 0x6d78, 0x741b, 0x7827, 0x91dd, 0x937c, 0x87c4, 0x79e4,
	0x7a31, 0x5feb, 0x4ed6, 0x54a4, 0x553e, 0x58ae, 0x59a5, 0x60f0,
	0x6253, 0x62d6, 0x6736, 0x6955, 0x8235, 0x9640, 0x99b1, 0x99dd,
	0x502c, 0x5353, 0x5544, 0x577c, 0xfa01, 0x6258, 0xfa02, 0x64e2,
	0x666b, 0x67dd, 0x6fc1, 0x6fef, 0x7422, 0x7438, 0x8a17, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf7a0[ 96 ] = {
	0xfffd, 0x9438, 0x5451, 0x5606, 0x5766, 0x5f48, 0x619a, 0x6b4e,
	0x7058, 0x70ad, 0x7dbb, 0x8a95, 0x596a, 0x812b, 0x63a2, 0x7708,
	0x803d, 0x8caa, 0x5854, 0x642d, 0x69bb, 0x5b95, 0x5e11, 0x6e6f,
	0xfa03, 0x8569, 0x514c, 0x53f0, 0x592a, 0x6020, 0x614b, 0x6b86,
	0x6c70, 0x6cf0, 0x7b1e, 0x80ce, 0x82d4, 0x8dc6, 0x90b0, 0x98b1,
	0xfa04, 0x64c7, 0x6fa4, 0x6491, 0x6504, 0x514e, 0x5410, 0x571f,
	0x8a0e, 0x615f, 0x6876, 0xfa05, 0x75db, 0x7b52, 0x7d71, 0x901a,
	0x5806, 0x69cc, 0x817f, 0x892a, 0x9000, 0x9839, 0x5078, 0x5957,
	0x59ac, 0x6295, 0x900f, 0x9b2a, 0x615d, 0x7279, 0x95d6, 0x5761,
	0x5a46, 0x5df4, 0x628a, 0x64ad, 0x64fa, 0x6777, 0x6ce2, 0x6d3e,
	0x722c, 0x7436, 0x7834, 0x7f77, 0x82ad, 0x8ddb, 0x9817, 0x5224,
	0x5742, 0x677f, 0x7248, 0x74e3, 0x8ca9, 0x8fa6, 0x9211, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf8a0[ 96 ] = {
	0xfffd, 0x962a, 0x516b, 0x53ed, 0x634c, 0x4f69, 0x5504, 0x6096,
	0x6557, 0x6c9b, 0x6d7f, 0x724c, 0x72fd, 0x7a17, 0x8987, 0x8c9d,
	0x5f6d, 0x6f8e, 0x70f9, 0x81a8, 0x610e, 0x4fbf, 0x504f, 0x6241,
	0x7247, 0x7bc7, 0x7de8, 0x7fe9, 0x904d, 0x97ad, 0x9a19, 0x8cb6,
	0x576a, 0x5e73, 0x67b0, 0x840d, 0x8a55, 0x5420, 0x5b16, 0x5e63,
	0x5ee2, 0x5f0a, 0x6583, 0x80ba, 0x853d, 0x9589, 0x965b, 0x4f48,
	0x5305, 0x530d, 0x530f, 0x5486, 0x54fa, 0x5703, 0x5e03, 0x6016,
	0x629b, 0x62b1, 0x6355, 0xfa06, 0x6ce1, 0x6d66, 0x75b1, 0x7832,
	0x80de, 0x812f, 0x82de, 0x8461, 0x84b2, 0x888d, 0x8912, 0x900b,
	0x92ea, 0x98fd, 0x9b91, 0x5e45, 0x66b4, 0x66dd, 0x7011, 0x7206,
	0xfa07, 0x4ff5, 0x527d, 0x5f6a, 0x6153, 0x6753, 0x6a19, 0x6f02,
	0x74e2, 0x7968, 0x8868, 0x8c79, 0x98c7, 0x98c4, 0x9a43, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf9a0[ 96 ] = {
	0xfffd, 0x54c1, 0x7a1f, 0x6953, 0x8af7, 0x8c4a, 0x98a8, 0x99ae,
	0x5f7c, 0x62ab, 0x75b2, 0x76ae, 0x88ab, 0x907f, 0x9642, 0x5339,
	0x5f3c, 0x5fc5, 0x6ccc, 0x73cc, 0x7562, 0x758b, 0x7b46, 0x82fe,
	0x999d, 0x4e4f, 0x903c, 0x4e0b, 0x4f55, 0x53a6, 0x590f, 0x5ec8,
	0x6630, 0x6cb3, 0x7455, 0x8377, 0x8766, 0x8cc0, 0x9050, 0x971e,
	0x9c15, 0x58d1, 0x5b78, 0x8650, 0x8b14, 0x9db4, 0x5bd2, 0x6068,
	0x608d, 0x65f1, 0x6c57, 0x6f22, 0x6fa3, 0x701a, 0x7f55, 0x7ff0,
	0x9591, 0x9592, 0x9650, 0x97d3, 0x5272, 0x8f44, 0x51fd, 0x542b,
	0x54b8, 0x5563, 0x558a, 0x6abb, 0x6db5, 0x7dd8, 0x8266, 0x929c,
	0x9677, 0x9e79, 0x5408, 0x54c8, 0x76d2, 0x86e4, 0x95a4, 0x95d4,
	0x965c, 0x4ea2, 0x4f09, 0x59ee, 0x5ae6, 0x5df7, 0x6052, 0x6297,
	0x676d, 0x6841, 0x6c86, 0x6e2f, 0x7f38, 0x809b, 0x822a, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfaa0[ 96 ] = {
	0xfffd, 0xfa08, 0xfa09, 0x9805, 0x4ea5, 0x5055, 0x54b3, 0x5793,
	0x595a, 0x5b69, 0x5bb3, 0x61c8, 0x6977, 0x6d77, 0x7023, 0x87f9,
	0x89e3, 0x8a72, 0x8ae7, 0x9082, 0x99ed, 0x9ab8, 0x52be, 0x6838,
	0x5016, 0x5e78, 0x674f, 0x8347, 0x884c, 0x4eab, 0x5411, 0x56ae,
	0x73e6, 0x9115, 0x97ff, 0x9909, 0x9957, 0x9999, 0x5653, 0x589f,
	0x865b, 0x8a31, 0x61b2, 0x6af6, 0x737b, 0x8ed2, 0x6b47, 0x96aa,
	0x9a57, 0x5955, 0x7200, 0x8d6b, 0x9769, 0x4fd4, 0x5cf4, 0x5f26,
	0x61f8, 0x665b, 0x6ceb, 0x70ab, 0x7384, 0x73b9, 0x73fe, 0x7729,
	0x774d, 0x7d43, 0x7d62, 0x7e23, 0x8237, 0x8852, 0xfa0a, 0x8ce2,
	0x9249, 0x986f, 0x5b51, 0x7a74, 0x8840, 0x9801, 0x5acc, 0x4fe0,
	0x5354, 0x593e, 0x5cfd, 0x633e, 0x6d79, 0x72f9, 0x8105, 0x8107,
	0x83a2, 0x92cf, 0x9830, 0x4ea8, 0x5144, 0x5211, 0x578b, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfba0[ 96 ] = {
	0xfffd, 0x5f62, 0x6cc2, 0x6ece, 0x7005, 0x7050, 0x70af, 0x7192,
	0x73e9, 0x7469, 0x834a, 0x87a2, 0x8861, 0x9008, 0x90a2, 0x93a3,
	0x99a8, 0x516e, 0x5f57, 0x60e0, 0x6167, 0x66b3, 0x8559, 0x8e4a,
	0x91af, 0x978b, 0x4e4e, 0x4e92, 0x547c, 0x58d5, 0x58fa, 0x597d,
	0x5cb5, 0x5f27, 0x6236, 0x6248, 0x660a, 0x6667, 0x6beb, 0x6d69,
	0x6dcf, 0x6e56, 0x6ef8, 0x6f94, 0x6fe0, 0x6fe9, 0x705d, 0x72d0,
	0x7425, 0x745a, 0x74e0, 0x7693, 0x795c, 0x7cca, 0x7e1e, 0x80e1,
	0x82a6, 0x846b, 0x84bf, 0x864e, 0x865f, 0x8774, 0x8b77, 0x8c6a,
	0x93ac, 0x9800, 0x9865, 0x60d1, 0x6216, 0x9177, 0x5a5a, 0x660f,
	0x6df7, 0x6e3e, 0x743f, 0x9b42, 0x5ffd, 0x60da, 0x7b0f, 0x54c4,
	0x5f18, 0x6c5e, 0x6cd3, 0x6d2a, 0x70d8, 0x7d05, 0x8679, 0x8a0c,
	0x9d3b, 0x5316, 0x548c, 0x5b05, 0x6a3a, 0x706b, 0x7575, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfca0[ 96 ] = {
	0xfffd, 0x798d, 0x79be, 0x82b1, 0x83ef, 0x8a71, 0x8b41, 0x8ca8,
	0x9774, 0xfa0b, 0x64f4, 0x652b, 0x78ba, 0x78bb, 0x7a6b, 0x4e38,
	0x559a, 0x5950, 0x5ba6, 0x5e7b, 0x60a3, 0x63db, 0x6b61, 0x6665,
	0x6853, 0x6e19, 0x7165, 0x74b0, 0x7d08, 0x9084, 0x9a69, 0x9c25,
	0x6d3b, 0x6ed1, 0x733e, 0x8c41, 0x95ca, 0x51f0, 0x5e4c, 0x5fa8,
	0x604d, 0x60f6, 0x6130, 0x614c, 0x6643, 0x6644, 0x69a5, 0x6cc1,
	0x6e5f, 0x6ec9, 0x6f62, 0x714c, 0x749c, 0x7687, 0x7bc1, 0x7c27,
	0x8352, 0x8757, 0x9051, 0x968d, 0x9ec3, 0x532f, 0x56de, 0x5efb,
	0x5f8a, 0x6062, 0x6094, 0x61f7, 0x6666, 0x6703, 0x6a9c, 0x6dee,
	0x6fae, 0x7070, 0x736a, 0x7e6a, 0x81be, 0x8334, 0x86d4, 0x8aa8,
	0x8cc4, 0x5283, 0x7372, 0x5b96, 0x6a6b, 0x9404, 0x54ee, 0x5686,
	0x5b5d, 0x6548, 0x6585, 0x66c9, 0x689f, 0x6d8d, 0x6dc6, 0xfffd
};

const uint16_t libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfda0[ 96 ] = {
	0xfffd, 0x723b, 0x80b4, 0x9175, 0x9a4d, 0x4faf, 0x5019, 0x539a,
	0x540e, 0x543c, 0x5589, 0x55c5, 0x5e3f, 0x5f8c, 0x673d, 0x7166,
	0x73dd, 0x9005, 0x52db, 0x52f3, 0x5864, 0x58ce, 0x7104, 0x718f,
	0x71fb, 0x85b0, 0x8a13, 0x6688, 0x85a8, 0x55a7, 0x6684, 0x714a,
	0x8431, 0x5349, 0x5599, 0x6bc1, 0x5f59, 0x5fbd, 0x63ee, 0x6689,
	0x7147, 0x8af1, 0x8f1d, 0x9ebe, 0x4f11, 0x643a, 0x70cb, 0x7566,
	0x8667, 0x6064, 0x8b4e, 0x9df8, 0x5147, 0x51f6, 0x5308, 0x6d36,
	0x80f8, 0x9ed1, 0x6615, 0x6b23, 0x7098, 0x75d5, 0x5403, 0x5c79,
	0x7d07, 0x8a16, 0x6b20, 0x6b3d, 0x6b46, 0x5438, 0x6070, 0x6d3d,
	0x7fd5, 0x8208, 0x50d6, 0x51de, 0x559c, 0x566b, 0x56cd, 0x59ec,
	0x5b09, 0x5e0c, 0x6199, 0x6198, 0x6231, 0x665e, 0x66e6, 0x7199,
	0x71b9, 0x71ba, 0x72a7, 0x79a7, 0x7a00, 0x7fb2, 0x8a70, 0xfffd
};

/* Unicode to ASCII character lookup tables for the Windows 949 codepage
 * Unknown are filled with the ASCII replacement character 0x1a
 */
const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0x0080[ 256 ] = {
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaea2, 0x001a, 0x001a, 0xb4a2, 0x001a, 0x001a, 0xd7a1,
	0xa7a1, 0x001a, 0xa3a8, 0x001a, 0x001a, 0xa9a1, 0xe7a2, 0x001a,
	0xc6a1, 0xbea1, 0xf7a9, 0xf8a9, 0xa5a2, 0x001a, 0xd2a2, 0xa4a1,
	0xaca2, 0xf6a9, 0xaca8, 0x001a, 0xf9a8, 0xf6a8, 0xfaa8, 0xafa2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa1a8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa2a8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbfa1,
	0xaaa8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xada8, 0xaca9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa1a9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa3a9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc0a1,
	0xaaa9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xada9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa2a9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4a8, 0xa4a9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa5a9, 0xa6a8, 0xa6a9, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa7a9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8a8,
	0xa8a9, 0xa9a8, 0xa9a9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb0a9, 0xafa8, 0xafa9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaba8, 0xaba9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaea8, 0xaea9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a
};

const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0x02c0[ 448 ] = {
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa7a2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb0a2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa8a2, 0xaba2, 0xaaa2, 0xada2, 0x001a, 0xa9a2, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc1a5, 0xc2a5, 0xc3a5, 0xc4a5, 0xc5a5, 0xc6a5, 0xc7a5,
	0xc8a5, 0xc9a5, 0xcaa5, 0xcba5, 0xcca5, 0xcda5, 0xcea5, 0xcfa5,
	0xd0a5, 0xd1a5, 0x001a, 0xd2a5, 0xd3a5, 0xd4a5, 0xd5a5, 0xd6a5,
	0xd7a5, 0xd8a5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe1a5, 0xe2a5, 0xe3a5, 0xe4a5, 0xe5a5, 0xe6a5, 0xe7a5,
	0xe8a5, 0xe9a5, 0xeaa5, 0xeba5, 0xeca5, 0xeda5, 0xeea5, 0xefa5,
	0xf0a5, 0xf1a5, 0x001a, 0xf2a5, 0xf3a5, 0xf4a5, 0xf5a5, 0xf6a5,
	0xf7a5, 0xf8a5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa7ac, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa1ac, 0xa2ac, 0xa3ac, 0xa4ac, 0xa5ac, 0xa6ac, 0xa8ac, 0xa9ac,
	0xaaac, 0xabac, 0xacac, 0xadac, 0xaeac, 0xafac, 0xb0ac, 0xb1ac,
	0xb2ac, 0xb3ac, 0xb4ac, 0xb5ac, 0xb6ac, 0xb7ac, 0xb8ac, 0xb9ac,
	0xbaac, 0xbbac, 0xbcac, 0xbdac, 0xbeac, 0xbfac, 0xc0ac, 0xc1ac,
	0xd1ac, 0xd2ac, 0xd3ac, 0xd4ac, 0xd5ac, 0xd6ac, 0xd8ac, 0xd9ac,
	0xdaac, 0xdbac, 0xdcac, 0xddac, 0xdeac, 0xdfac, 0xe0ac, 0xe1ac,
	0xe2ac, 0xe3ac, 0xe4ac, 0xe5ac, 0xe6ac, 0xe7ac, 0xe8ac, 0xe9ac,
	0xeaac, 0xebac, 0xecac, 0xedac, 0xeeac, 0xefac, 0xf0ac, 0xf1ac,
	0x001a, 0xd7ac, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a
};

const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0x2000[ 1664 ] = {
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaaa1, 0x001a, 0x001a,
	0xaea1, 0xafa1, 0x001a, 0x001a, 0xb0a1, 0xb1a1, 0x001a, 0x001a,
	0xd3a2, 0xd4a2, 0x001a, 0x001a, 0x001a, 0xa5a1, 0xa6a1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb6a2, 0x001a, 0xc7a1, 0xc8a1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd8a1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf9a9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfaa9,
	0x001a, 0xfba9, 0xfca9, 0xfda9, 0xfea9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe6a2, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc9a1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb5a2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa4a7, 0x001a, 0x001a, 0xe0a2, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe5a2, 0xe2a2, 0x001a, 0x001a, 0x001a, 0xd9a7, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcaa1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf7a8, 0xf8a8, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfba8, 0xfca8, 0xfda8, 0xfea8, 0x001a,
	0xb0a5, 0xb1a5, 0xb2a5, 0xb3a5, 0xb4a5, 0xb5a5, 0xb6a5, 0xb7a5,
	0xb8a5, 0xb9a5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa1a5, 0xa2a5, 0xa3a5, 0xa4a5, 0xa5a5, 0xa6a5, 0xa7a5, 0xa8a5,
	0xa9a5, 0xaaa5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe7a1, 0xe8a1, 0xe6a1, 0xe9a1, 0xeaa1, 0xd5a2, 0xd8a2, 0xd6a2,
	0xd9a2, 0xd7a2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa1a2, 0x001a, 0xa2a2, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa3a2, 0x001a, 0xd3a1, 0xa4a2, 0x001a, 0x001a, 0x001a, 0xd4a1,
	0xf4a1, 0x001a, 0x001a, 0xf5a1, 0x001a, 0x001a, 0x001a, 0xb3a2,
	0x001a, 0xb2a2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xeea1, 0x001a, 0x001a, 0xf0a1, 0xc4a1, 0x001a,
	0xd0a1, 0x001a, 0x001a, 0x001a, 0x001a, 0xaba1, 0x001a, 0xfca1,
	0xfda1, 0xfba1, 0xfaa1, 0xf2a1, 0xf3a1, 0x001a, 0xb1a2, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc5a1, 0xf1a1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xada1, 0xefa1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd6a1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc1a1, 0xd5a1, 0x001a, 0x001a, 0xc2a1, 0xc3a1, 0x001a, 0x001a,
	0x001a, 0x001a, 0xeca1, 0xeda1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf8a1, 0xf9a1, 0x001a, 0x001a, 0xf6a1, 0xf7a1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc1a2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd1a1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd2a1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe7a8, 0xe8a8, 0xe9a8, 0xeaa8, 0xeba8, 0xeca8, 0xeda8, 0xeea8,
	0xefa8, 0xf0a8, 0xf1a8, 0xf2a8, 0xf3a8, 0xf4a8, 0xf5a8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe7a9, 0xe8a9, 0xe9a9, 0xeaa9,
	0xeba9, 0xeca9, 0xeda9, 0xeea9, 0xefa9, 0xf0a9, 0xf1a9, 0xf2a9,
	0xf3a9, 0xf4a9, 0xf5a9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcda9, 0xcea9, 0xcfa9, 0xd0a9,
	0xd1a9, 0xd2a9, 0xd3a9, 0xd4a9, 0xd5a9, 0xd6a9, 0xd7a9, 0xd8a9,
	0xd9a9, 0xdaa9, 0xdba9, 0xdca9, 0xdda9, 0xdea9, 0xdfa9, 0xe0a9,
	0xe1a9, 0xe2a9, 0xe3a9, 0xe4a9, 0xe5a9, 0xe6a9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcda8, 0xcea8, 0xcfa8, 0xd0a8, 0xd1a8, 0xd2a8, 0xd3a8, 0xd4a8,
	0xd5a8, 0xd6a8, 0xd7a8, 0xd8a8, 0xd9a8, 0xdaa8, 0xdba8, 0xdca8,
	0xdda8, 0xdea8, 0xdfa8, 0xe0a8, 0xe1a8, 0xe2a8, 0xe3a8, 0xe4a8,
	0xe5a8, 0xe6a8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa1a6, 0xaca6, 0xa2a6, 0xada6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa3a6, 0xc8a6, 0xc7a6, 0xaea6,
	0xa4a6, 0xc2a6, 0xc1a6, 0xafa6, 0xa6a6, 0xc6a6, 0xc5a6, 0xb1a6,
	0xa5a6, 0xc4a6, 0xc3a6, 0xb0a6, 0xa7a6, 0xbca6, 0xc9a6, 0xcaa6,
	0xb7a6, 0xcba6, 0xcca6, 0xb2a6, 0xa9a6, 0xbea6, 0xcda6, 0xcea6,
	0xb9a6, 0xcfa6, 0xd0a6, 0xb4a6, 0xa8a6, 0xd1a6, 0xd2a6, 0xb8a6,
	0xbda6, 0xd3a6, 0xd4a6, 0xb3a6, 0xaaa6, 0xd5a6, 0xd6a6, 0xbaa6,
	0xbfa6, 0xd7a6, 0xd8a6, 0xb5a6, 0xaba6, 0xd9a6, 0xdaa6, 0xbba6,
	0xdba6, 0xdca6, 0xc0a6, 0xdda6, 0xdea6, 0xdfa6, 0xe0a6, 0xe1a6,
	0xe2a6, 0xe3a6, 0xe4a6, 0xb6a6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc6a2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe1a1, 0xe0a1, 0x001a, 0xc3a2, 0xc7a2, 0xc8a2, 0xcba2, 0xcaa2,
	0xc9a2, 0xcca2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe3a1, 0xe2a1, 0x001a, 0x001a, 0xbaa2, 0xb9a2,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe5a1, 0xe4a1, 0x001a, 0x001a,
	0xb8a2, 0xb7a2, 0x001a, 0x001a, 0x001a, 0x001a, 0xdfa1, 0xdea1,
	0xc2a2, 0x001a, 0x001a, 0xdba1, 0x001a, 0x001a, 0xdda1, 0xdca1,
	0xc4a2, 0xc5a2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdaa1, 0xd9a1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcfa2, 0xcea2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd0a2, 0x001a, 0xd1a2, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcfa1, 0x001a, 0xcea1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbca2, 0xbda2, 0x001a, 0xc0a2, 0xbba2, 0xbea2, 0x001a, 0xbfa2,
	0xcda2, 0xdba2, 0xdca2, 0x001a, 0xdda2, 0xdaa2, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a
};

const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0x3000[ 1024 ] = {
	0xa1a1, 0xa2a1, 0xa3a1, 0xa8a1, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb4a1, 0xb5a1, 0xb6a1, 0xb7a1, 0xb8a1, 0xb9a1, 0xbaa1, 0xbba1,
	0xbca1, 0xbda1, 0x001a, 0xeba1, 0xb2a1, 0xb3a1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa1aa, 0xa2aa, 0xa3aa, 0xa4aa, 0xa5aa, 0xa6aa, 0xa7aa,
	0xa8aa, 0xa9aa, 0xaaaa, 0xabaa, 0xacaa, 0xadaa, 0xaeaa, 0xafaa,
	0xb0aa, 0xb1aa, 0xb2aa, 0xb3aa, 0xb4aa, 0xb5aa, 0xb6aa, 0xb7aa,
	0xb8aa, 0xb9aa, 0xbaaa, 0xbbaa, 0xbcaa, 0xbdaa, 0xbeaa, 0xbfaa,
	0xc0aa, 0xc1aa, 0xc2aa, 0xc3aa, 0xc4aa, 0xc5aa, 0xc6aa, 0xc7aa,
	0xc8aa, 0xc9aa, 0xcaaa, 0xcbaa, 0xccaa, 0xcdaa, 0xceaa, 0xcfaa,
	0xd0aa, 0xd1aa, 0xd2aa, 0xd3aa, 0xd4aa, 0xd5aa, 0xd6aa, 0xd7aa,
	0xd8aa, 0xd9aa, 0xdaaa, 0xdbaa, 0xdcaa, 0xddaa, 0xdeaa, 0xdfaa,
	0xe0aa, 0xe1aa, 0xe2aa, 0xe3aa, 0xe4aa, 0xe5aa, 0xe6aa, 0xe7aa,
	0xe8aa, 0xe9aa, 0xeaaa, 0xebaa, 0xecaa, 0xedaa, 0xeeaa, 0xefaa,
	0xf0aa, 0xf1aa, 0xf2aa, 0xf3aa, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa1ab, 0xa2ab, 0xa3ab, 0xa4ab, 0xa5ab, 0xa6ab, 0xa7ab,
	0xa8ab, 0xa9ab, 0xaaab, 0xabab, 0xacab, 0xadab, 0xaeab, 0xafab,
	0xb0ab, 0xb1ab, 0xb2ab, 0xb3ab, 0xb4ab, 0xb5ab, 0xb6ab, 0xb7ab,
	0xb8ab, 0xb9ab, 0xbaab, 0xbbab, 0xbcab, 0xbdab, 0xbeab, 0xbfab,
	0xc0ab, 0xc1ab, 0xc2ab, 0xc3ab, 0xc4ab, 0xc5ab, 0xc6ab, 0xc7ab,
	0xc8ab, 0xc9ab, 0xcaab, 0xcbab, 0xccab, 0xcdab, 0xceab, 0xcfab,
	0xd0ab, 0xd1ab, 0xd2ab, 0xd3ab, 0xd4ab, 0xd5ab, 0xd6ab, 0xd7ab,
	0xd8ab, 0xd9ab, 0xdaab, 0xdbab, 0xdcab, 0xddab, 0xdeab, 0xdfab,
	0xe0ab, 0xe1ab, 0xe2ab, 0xe3ab, 0xe4ab, 0xe5ab, 0xe6ab, 0xe7ab,
	0xe8ab, 0xe9ab, 0xeaab, 0xebab, 0xecab, 0xedab, 0xeeab, 0xefab,
	0xf0ab, 0xf1ab, 0xf2ab, 0xf3ab, 0xf4ab, 0xf5ab, 0xf6ab, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa1a4, 0xa2a4, 0xa3a4, 0xa4a4, 0xa5a4, 0xa6a4, 0xa7a4,
	0xa8a4, 0xa9a4, 0xaaa4, 0xaba4, 0xaca4, 0xada4, 0xaea4, 0xafa4,
	0xb0a4, 0xb1a4, 0xb2a4, 0xb3a4, 0xb4a4, 0xb5a4, 0xb6a4, 0xb7a4,
	0xb8a4, 0xb9a4, 0xbaa4, 0xbba4, 0xbca4, 0xbda4, 0xbea4, 0xbfa4,
	0xc0a4, 0xc1a4, 0xc2a4, 0xc3a4, 0xc4a4, 0xc5a4, 0xc6a4, 0xc7a4,
	0xc8a4, 0xc9a4, 0xcaa4, 0xcba4, 0xcca4, 0xcda4, 0xcea4, 0xcfa4,
	0xd0a4, 0xd1a4, 0xd2a4, 0xd3a4, 0xd4a4, 0xd5a4, 0xd6a4, 0xd7a4,
	0xd8a4, 0xd9a4, 0xdaa4, 0xdba4, 0xdca4, 0xdda4, 0xdea4, 0xdfa4,
	0xe0a4, 0xe1a4, 0xe2a4, 0xe3a4, 0xe4a4, 0xe5a4, 0xe6a4, 0xe7a4,
	0xe8a4, 0xe9a4, 0xeaa4, 0xeba4, 0xeca4, 0xeda4, 0xeea4, 0xefa4,
	0xf0a4, 0xf1a4, 0xf2a4, 0xf3a4, 0xf4a4, 0xf5a4, 0xf6a4, 0xf7a4,
	0xf8a4, 0xf9a4, 0xfaa4, 0xfba4, 0xfca4, 0xfda4, 0xfea4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb1a9, 0xb2a9, 0xb3a9, 0xb4a9, 0xb5a9, 0xb6a9, 0xb7a9, 0xb8a9,
	0xb9a9, 0xbaa9, 0xbba9, 0xbca9, 0xbda9, 0xbea9, 0xbfa9, 0xc0a9,
	0xc1a9, 0xc2a9, 0xc3a9, 0xc4a9, 0xc5a9, 0xc6a9, 0xc7a9, 0xc8a9,
	0xc9a9, 0xcaa9, 0xcba9, 0xcca9, 0xdfa2, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb1a8, 0xb2a8, 0xb3a8, 0xb4a8, 0xb5a8, 0xb6a8, 0xb7a8, 0xb8a8,
	0xb9a8, 0xbaa8, 0xbba8, 0xbca8, 0xbda8, 0xbea8, 0xbfa8, 0xc0a8,
	0xc1a8, 0xc2a8, 0xc3a8, 0xc4a8, 0xc5a8, 0xc6a8, 0xc7a8, 0xc8a8,
	0xc9a8, 0xcaa8, 0xcba8, 0xcca8, 0x001a, 0x001a, 0x001a, 0xdea2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc9a7, 0xcaa7, 0xcba7, 0xcca7, 0xcda7, 0x001a, 0x001a, 0x001a,
	0xbaa7, 0xbba7, 0xdca7, 0xdda7, 0xdea7, 0xb6a7, 0xb7a7, 0xb8a7,
	0xd4a7, 0xd5a7, 0xd6a7, 0xd7a7, 0xd8a7, 0xa1a7, 0xa2a7, 0xa3a7,
	0xa5a7, 0xaba7, 0xaca7, 0xada7, 0xaea7, 0xafa7, 0xb0a7, 0xb1a7,
	0xb2a7, 0xb3a7, 0xb4a7, 0xa7a7, 0xa8a7, 0xa9a7, 0xaaa7, 0xbda7,
	0xbea7, 0xe5a7, 0xe6a7, 0xe7a7, 0xe8a7, 0xe1a7, 0xe2a7, 0xe3a7,
	0xbfa7, 0xc0a7, 0xc1a7, 0xc2a7, 0xc3a7, 0xc4a7, 0xc5a7, 0xc6a7,
	0xc7a7, 0xc8a7, 0xcea7, 0xcfa7, 0xd0a7, 0xd1a7, 0xd2a7, 0xd3a7,
	0xdaa7, 0xdba7, 0xe3a2, 0xeca7, 0xa6a7, 0xe0a7, 0xefa7, 0xe1a2,
	0xbca7, 0xeda7, 0xb5a7, 0x001a, 0x001a, 0x001a, 0x001a, 0xb9a7,
	0xeaa7, 0x001a, 0x001a, 0xeba7, 0x001a, 0x001a, 0xdfa7, 0x001a,
	0xe4a2, 0x001a, 0x001a, 0xe4a7, 0xeea7, 0xe9a7, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a
};

const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0x4e00[ 20928 ] = {
	0xe9ec, 0xcbef, 0x001a, 0xd2f6, 0x001a, 0x001a, 0x001a, 0xb2d8,
	0xdbed, 0xb2df, 0xbedf, 0xbbf9, 0x001a, 0xf4dc, 0x001a, 0x001a,
	0x001a, 0xe4f5, 0x001a, 0x001a, 0xa6f3, 0xe0dd, 0xa6e1, 0x001a,
	0xf8ce, 0xb0dc, 0x001a, 0x001a, 0x001a, 0x001a, 0xaae3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9f1, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfacd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaffc, 0xa1d3, 0x001a, 0xabf1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd1e7, 0xacd2, 0x001a, 0xf9ce, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfdf1, 0x001a, 0xbfde, 0xbafb, 0xb9f9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd2ce, 0x001a,
	0xabe3, 0xe0eb, 0x001a, 0x001a, 0x001a, 0xface, 0xf7cb, 0xa5e5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe1ca, 0x001a, 0xccd4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe1ea, 0x001a, 0x001a, 0xe3dc, 0xaddf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xebcb, 0x001a,
	0x001a, 0x001a, 0xafd5, 0x001a, 0x001a, 0x001a, 0xf5d6, 0x001a,
	0xf8e5, 0x001a, 0x001a, 0xc0de, 0xa3ec, 0x001a, 0xcde9, 0x001a,
	0xa7ea, 0xf6e9, 0xbbfb, 0x001a, 0xe9e7, 0xccef, 0x001a, 0x001a,
	0xe6d0, 0x001a, 0x001a, 0xc1de, 0x001a, 0x001a, 0xace4, 0x001a,
	0x001a, 0xccd8, 0xf1f9, 0x001a, 0xdfce, 0xa4fa, 0xb2e6, 0x001a,
	0xfbfa, 0x001a, 0x001a, 0xbdfa, 0xc8cc, 0xcdef, 0xd5d5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa2d3, 0x001a,
	0x001a, 0x001a, 0xd1ec, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa7e4, 0xd2ec, 0x001a, 0x001a, 0xb1f6, 0x001a, 0x001a, 0xfbce,
	0x001a, 0x001a, 0xd1d0, 0xbfcb, 0x001a, 0xa4ed, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa8ed, 0xc2de, 0xe2f6, 0xdced,
	0xf5dc, 0xb9e0, 0x001a, 0x001a, 0x001a, 0xced4, 0x001a, 0xb5f4,
	0x001a, 0x001a, 0x001a, 0xdbd3, 0xb5d6, 0xa4ec, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe6e4, 0x001a, 0xeaf1, 0x001a, 0x001a, 0x001a, 0xeccb, 0xc0cb,
	0x001a, 0x001a, 0x001a, 0xf2ec, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xead0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf2f9, 0xa5ec, 0xdfd0, 0x001a, 0xeae7, 0xebd0, 0xd1dc,
	0xe9db, 0xccfd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd7db,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe1da, 0x001a, 0xb6d6, 0x001a,
	0xdfe3, 0x001a, 0xc3de, 0x001a, 0xc4de, 0xa1ca, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xecee, 0x001a, 0x001a, 0xa3d3, 0xb7ee,
	0xcff8, 0x001a, 0x001a, 0x001a, 0x001a, 0xc8ea, 0xb8ee, 0xacf1,
	0xa5f1, 0xcee9, 0x001a, 0x001a, 0x001a, 0xbcf9, 0x001a, 0x001a,
	0x001a, 0xf9e5, 0xeaec, 0xd6dd, 0xc2ed, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa5f8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbae5,
	0xd8db, 0x001a, 0x001a, 0xa2ca, 0x001a, 0x001a, 0xcdd1, 0x001a,
	0x001a, 0x001a, 0xedee, 0x001a, 0x001a, 0x001a, 0xebec, 0xc5de,
	0x001a, 0xe0e3, 0x001a, 0xc9ca, 0xe9f2, 0x001a, 0xced5, 0x001a,
	0xb6f6, 0x001a, 0xc2ce, 0xc7d6, 0x001a, 0xb4e3, 0x001a, 0xadf1,
	0x001a, 0xe2ea, 0x001a, 0x001a, 0x001a, 0x001a, 0xc2d7, 0x001a,
	0xa7f3, 0x001a, 0x001a, 0xeacd, 0x001a, 0xeeeb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2d9, 0xa5fd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5f6, 0xe2d5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb5f8,
	0x001a, 0x001a, 0xf5cc, 0xb5f5, 0xade4, 0x001a, 0x001a, 0x001a,
	0x001a, 0xebe7, 0xd5f1, 0x001a, 0x001a, 0x001a, 0xbbf0, 0x001a,
	0x001a, 0xb5e9, 0x001a, 0xc9cc, 0xd5fa, 0x001a, 0x001a, 0xd4e1,
	0x001a, 0x001a, 0xd6d7, 0x001a, 0x001a, 0xc1dc, 0x001a, 0xc6de,
	0xeffa, 0xe1e3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf3e1, 0xf6dc,
	0x001a, 0xfcce, 0x001a, 0xc4db, 0x001a, 0xf1f8, 0x001a, 0x001a,
	0xe4dc, 0x001a, 0xefe5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb1dc, 0x001a, 0x001a, 0x001a, 0xd6d5, 0x001a,
	0x001a, 0xdaf3, 0x001a, 0xc1cb, 0x001a, 0xc3db, 0x001a, 0x001a,
	0x001a, 0xfad9, 0xeed3, 0x001a, 0x001a, 0x001a, 0xb8fa, 0x001a,
	0x001a, 0xa6fd, 0xefeb, 0x001a, 0xa6f4, 0x001a, 0xcacc, 0xa8f3,
	0x001a, 0xdbf3, 0x001a, 0xa7db, 0xb7f6, 0x001a, 0xe6cf, 0xf2f0,
	0xdacb, 0x001a, 0xd2e7, 0xc3d7, 0xf0f6, 0xdee8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa6e5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe7e5, 0x001a, 0x001a, 0x001a, 0xa3ca,
	0xa7cc, 0xc9ea, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6f8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5fa, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaef1, 0x001a, 0xceef, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xedcb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb0f6, 0xcfef, 0xcfe9, 0x001a,
	0xdef7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd3ce, 0x001a, 0x001a, 0x001a, 0x001a, 0xf7dc, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8db, 0x001a, 0x001a,
	0x001a, 0xf8cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa1df, 0xe1dd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcaf5, 0xb6e9, 0x001a, 0x001a,
	0x001a, 0x001a, 0xece7, 0xeeee, 0x001a, 0xf0f3, 0x001a, 0xbfdf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbcc, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc1d0, 0x001a, 0x001a,
	0x001a, 0xd2f4, 0xbae0, 0x001a, 0x001a, 0x001a, 0x001a, 0xc0df,
	0x001a, 0xe0ce, 0x001a, 0x001a, 0x001a, 0xd2dc, 0xeafd, 0x001a,
	0x001a, 0x001a, 0xf6d6, 0x001a, 0x001a, 0x001a, 0xcaea, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9e8, 0x001a, 0xace3,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd0f3, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa4ca, 0x001a, 0xf8db, 0x001a, 0x001a, 0x001a, 0xc7de,
	0xf0eb, 0xd6f1, 0x001a, 0x001a, 0xe2e5, 0x001a, 0xcccc, 0x001a,
	0x001a, 0xfbcb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe3ea, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc1df,
	0x001a, 0xedd6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd0e9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb9ee, 0x001a, 0x001a, 0x001a, 0x001a, 0xe3d5,
	0x001a, 0x001a, 0xd3d1, 0x001a, 0xf0e5, 0x001a, 0x001a, 0x001a,
	0xb4e8, 0xc3eb, 0x001a, 0xaaea, 0xfcfa, 0xf6f5, 0xbcf0, 0xd4fd,
	0xbbe0, 0xc3ce, 0x001a, 0xbad0, 0xbaf7, 0xf3d8, 0xcdf7, 0x001a,
	0x001a, 0x001a, 0xaee4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdfd4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe7d0, 0x001a, 0x001a, 0xfdec, 0x001a, 0xaed2,
	0xefee, 0xd7d5, 0xe4ea, 0xa2f8, 0xebcd, 0xbfd7, 0xb1fb, 0x001a,
	0x001a, 0xeccd, 0x001a, 0x001a, 0x001a, 0xb2dc, 0xecd0, 0xfdce,
	0xf0ee, 0x001a, 0x001a, 0x001a, 0xc2cc, 0x001a, 0x001a, 0x001a,
	0xedd0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf7e5, 0x001a,
	0x001a, 0x001a, 0xfcf3, 0x001a, 0x001a, 0xa2ee, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb3d9, 0x001a, 0x001a, 0xf4d8, 0x001a, 0xb7e9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaece, 0x001a, 0x001a, 0x001a, 0x001a, 0xa2d9, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf1d8, 0x001a, 0xcfd4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa7e5, 0xd2d5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9d6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa2f4, 0x001a, 0xd7f1, 0x001a,
	0x001a, 0xd8d5, 0x001a, 0xbdf0, 0xd0d7, 0xd0d4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcfd7, 0xeaeb, 0xebfd, 0x001a,
	0x001a, 0xeddb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc5fc, 0xc2cb, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5fd, 0x001a,
	0xc8f4, 0xeae8, 0xf3f5, 0x001a, 0x001a, 0xdef9, 0x001a, 0x001a,
	0xefd3, 0x001a, 0x001a, 0xd3ec, 0x001a, 0x001a, 0xc2dd, 0xb7ef,
	0xd4e7, 0x001a, 0xcaca, 0x001a, 0x001a, 0x001a, 0xfbd9, 0x001a,
	0x001a, 0xfdfa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaad6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf8f4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf7f7, 0xacdc, 0x001a, 0x001a,
	0x001a, 0xd7d7, 0xa2df, 0x001a, 0x001a, 0x001a, 0xbece, 0x001a,
	0xf0d3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4f0, 0xece1,
	0xe7cf, 0xcbf3, 0xa9ed, 0xbeca, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xeff4, 0x001a, 0x001a, 0x001a, 0xcef6,
	0x001a, 0x001a, 0xfbde, 0xbbd0, 0xb7d5, 0xf1ee, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa8f4, 0x001a, 0xf8dc, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa7cb, 0x001a, 0xceda, 0x001a, 0x001a,
	0x001a, 0xe6e0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa5ed, 0xf2ee, 0x001a, 0x001a, 0x001a, 0x001a, 0xf9dc,
	0x001a, 0x001a, 0xdcf9, 0x001a, 0x001a, 0xdcf3, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf2f8, 0x001a, 0xf9f4,
	0x001a, 0x001a, 0x001a, 0xf1fc, 0x001a, 0x001a, 0x001a, 0xbcd0,
	0xf9db, 0xb1d7, 0x001a, 0x001a, 0x001a, 0xfccb, 0x001a, 0x001a,
	0x001a, 0xa5f0, 0xfdcb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf4d5, 0x001a, 0x001a, 0x001a, 0xedcd,
	0xa5ca, 0x001a, 0x001a, 0xabd6, 0xc2d0, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbef0, 0xbdd2, 0xa4cc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6fa, 0x001a,
	0x001a, 0xcdcc, 0x001a, 0xfada, 0x001a, 0xcff6, 0x001a, 0xb8e9,
	0x001a, 0xf5d8, 0x001a, 0x001a, 0x001a, 0xcecc, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcdd7, 0x001a, 0x001a, 0xd1d4, 0xede9, 0x001a,
	0xebca, 0xe2d9, 0x001a, 0xb2fd, 0x001a, 0xade3, 0xccd6, 0xb4d9,
	0x001a, 0x001a, 0xa7e1, 0xd3ee, 0xc3d0, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb3fd, 0x001a, 0xe4d5, 0x001a, 0x001a,
	0xe8cf, 0x001a, 0xc3ed, 0xb2d0, 0x001a, 0x001a, 0xfece, 0xa8da,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd0f8, 0x001a, 0x001a,
	0xd6fd, 0x001a, 0x001a, 0x001a, 0x001a, 0xd1f8, 0x001a, 0xd2f8,
	0xd3dc, 0x001a, 0x001a, 0x001a, 0x001a, 0xe2dd, 0xf9fb, 0xc1dd,
	0x001a, 0xb5e3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdded, 0xc4ce, 0x001a, 0xa1cb, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe3dd, 0x001a, 0x001a, 0x001a, 0x001a, 0xddfc,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaff9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfbd2,
	0xa1cf, 0xa8e4, 0x001a, 0xb6f4, 0xfeec, 0x001a, 0x001a, 0xaee3,
	0xede7, 0xc1fd, 0xe2da, 0x001a, 0x001a, 0xb3d8, 0x001a, 0x001a,
	0x001a, 0xe4dd, 0xeff0, 0xf1f6, 0xf0fa, 0x001a, 0x001a, 0xf5d1,
	0x001a, 0x001a, 0xcfda, 0x001a, 0xd4dc, 0x001a, 0xa6dc, 0x001a,
	0xbfef, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcfce, 0x001a,
	0xd9e0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd6d9,
	0xd4ec, 0xcbea, 0x001a, 0x001a, 0xbfca, 0xb0d5, 0x001a, 0xe9cf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xedf1, 0x001a, 0xcfcc,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf8e4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xede4, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd8d7, 0x001a, 0xa7fd, 0x001a, 0x001a, 0x001a, 0x001a, 0xabea,
	0xb2f6, 0x001a, 0x001a, 0x001a, 0x001a, 0xf0cf, 0xbdf9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf4e6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdbcb, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd1f3, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd1e9, 0xa9f3, 0xe0d0, 0xd2e9, 0x001a, 0xe3da, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd2e2, 0x001a, 0xa2f6, 0xf4e1,
	0x001a, 0x001a, 0x001a, 0xe4da, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd5e7, 0xbff5, 0xa2cf, 0xafcd, 0xa3cf, 0x001a, 0x001a,
	0x001a, 0xb0cd, 0xfef1, 0xa3d0, 0xafe1, 0xa3f8, 0x001a, 0xa6ca,
	0xbbf7, 0xeaf2, 0xc8de, 0xd3e9, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc9de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdefd, 0xc0ca, 0x001a, 0x001a, 0x001a,
	0xeaf9, 0xced1, 0xd4ee, 0x001a, 0xd2d4, 0xa3d9, 0xa8fd, 0xd9d7,
	0xcef7, 0xbefa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd6cf, 0x001a, 0xf0d7, 0x001a, 0xe1eb,
	0xc5f8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfadc, 0x001a,
	0x001a, 0xc3dd, 0x001a, 0xdff9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xefe7, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe5fd, 0xa3f6, 0x001a, 0xfcd9, 0xa9fd, 0x001a, 0xeee7, 0x001a,
	0x001a, 0x001a, 0xe5d5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd0ef, 0x001a, 0xb1cd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa2f7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb2f1, 0x001a, 0xb1f1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb2cd, 0x001a, 0xabda, 0x001a, 0xa7ca, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe2e3, 0xbcfb, 0xa4d9, 0x001a, 0x001a,
	0xbaee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd3f8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfafb, 0x001a, 0xa4cf, 0x001a,
	0xfbdc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe3f6, 0x001a, 0x001a, 0x001a,
	0xaaed, 0x001a, 0x001a, 0xa1f2, 0xe1ce, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa6fa, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe0f9, 0x001a, 0x001a, 0x001a, 0x001a, 0xd6ec, 0x001a, 0x001a,
	0xeee4, 0xa1f9, 0x001a, 0x001a, 0xeffb, 0x001a, 0x001a, 0x001a,
	0xebf9, 0xa3ee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xacea, 0x001a, 0x001a, 0x001a, 0xa8ca, 0x001a, 0x001a,
	0xfaf4, 0x001a, 0x001a, 0x001a, 0x001a, 0xd6cd, 0xf6fc, 0x001a,
	0x001a, 0x001a, 0xc9f4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd4f8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa6f8, 0x001a, 0xcade, 0xc6f2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdad7, 0x001a,
	0xd0d3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc5d8, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe6ea,
	0x001a, 0xddf3, 0x001a, 0x001a, 0x001a, 0xdae4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe4f6, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf2f6, 0x001a, 0xc2df, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfdd9,
	0x001a, 0x001a, 0x001a, 0xf6cc, 0x001a, 0x001a, 0xbad3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xafe4, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe1f9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa6f0, 0x001a, 0x001a, 0x001a,
	0xd3cb, 0x001a, 0x001a, 0x001a, 0xbce0, 0x001a, 0xcaf4, 0xfad4,
	0x001a, 0xaafd, 0xe2f9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb7f4, 0xc2fd, 0xb0fc, 0x001a, 0xecfd, 0xe2ca, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbdfd,
	0x001a, 0xe7ea, 0xc3df, 0xd2d1, 0xe2ce, 0x001a, 0xa4d3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xabfd, 0x001a, 0xe0df,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc7f2, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf0e7, 0x001a, 0xeed0, 0x001a, 0x001a, 0xaaf3,
	0x001a, 0x001a, 0x001a, 0xcbde, 0xb8f6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf5e1, 0xb3f1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3f7, 0x001a,
	0x001a, 0xa9ca, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa5cf, 0x001a, 0x001a, 0xc4df,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb0e1,
	0x001a, 0x001a, 0xbff0, 0x001a, 0xa4f6, 0x001a, 0xb6e3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc6fa, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xefd0, 0x001a, 0x001a, 0xedfd, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc4dd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf7fc, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbfe6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xadde, 0x001a, 0xbffa, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf1e5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc4ed, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa5d2, 0x001a, 0x001a, 0xeefd, 0x001a, 0x001a,
	0x001a, 0xb6f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf6e1, 0xccde, 0x001a, 0x001a, 0xdefc, 0x001a,
	0xd7ec, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xddcd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb7d6, 0xb3cd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd5f8, 0xd8e5, 0x001a, 0x001a, 0x001a,
	0xeacf, 0x001a, 0x001a, 0xd0cf, 0x001a, 0xccea, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaeea, 0xadea, 0x001a, 0x001a, 0xf1d3, 0x001a,
	0xa5d3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcff7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa4ee, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4d0, 0x001a, 0x001a,
	0xa2f2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf0d0, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa3f2, 0x001a, 0xf8f7, 0x001a, 0x001a, 0x001a, 0x001a, 0xb3d0,
	0x001a, 0x001a, 0xa9db, 0x001a, 0x001a, 0xbbd3, 0xecca, 0x001a,
	0xa6f1, 0xd5cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe7f7, 0x001a, 0x001a, 0xdecd, 0x001a, 0xa4f7, 0x001a,
	0x001a, 0x001a, 0xc0f8, 0x001a, 0x001a, 0x001a, 0xddd3, 0x001a,
	0xd0cc, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6cf, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf3f6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf7e1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdcd3, 0x001a, 0x001a, 0xfefa, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa7fa, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd9eb, 0x001a, 0xa7cf, 0xafea, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xefe4, 0x001a, 0x001a, 0x001a, 0xb9e9,
	0xd8f1, 0x001a, 0x001a, 0xd8d8, 0x001a, 0x001a, 0xf2e0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb4e6,
	0xfcdc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf1f3, 0x001a, 0x001a, 0x001a, 0xd0e3, 0x001a, 0x001a, 0xfbf2,
	0x001a, 0xc6db, 0xf1d0, 0x001a, 0xf2d0, 0x001a, 0x001a, 0x001a,
	0xdccf, 0x001a, 0xd1d3, 0x001a, 0x001a, 0xb1cc, 0xd8f7, 0x001a,
	0xa8cb, 0xbceb, 0xbee4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdcf4, 0x001a,
	0x001a, 0xc2dc, 0x001a, 0x001a, 0xa7f0, 0x001a, 0x001a, 0xc0e6,
	0x001a, 0x001a, 0xedca, 0x001a, 0x001a, 0x001a, 0x001a, 0xebe8,
	0xe8e5, 0xc3dc, 0x001a, 0x001a, 0xdeed, 0xf2d3, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf7cc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd4ce, 0xabe7, 0x001a, 0x001a, 0x001a, 0xc3cb,
	0x001a, 0xb1e1, 0x001a, 0x001a, 0xb2f7, 0x001a, 0x001a, 0xf3d3,
	0xd2d3, 0x001a, 0xc0f5, 0x001a, 0x001a, 0x001a, 0xdddf, 0x001a,
	0x001a, 0xf3ee, 0xf1e7, 0x001a, 0xb4fd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc8f2, 0x001a, 0x001a,
	0x001a, 0xd2f3, 0x001a, 0x001a, 0xf4ee, 0x001a, 0xd3e2, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd1cc, 0x001a, 0xeadf, 0x001a, 0x001a,
	0x001a, 0xbae9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd7d9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcdf5, 0x001a, 0xf2f1, 0xc7fa,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf8d9, 0xc2d4, 0x001a, 0x001a, 0x001a, 0x001a, 0xe5f6, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc5dd, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf2e7, 0xdfed, 0x001a, 0x001a, 0xcbca, 0x001a,
	0x001a, 0xfadb, 0x001a, 0x001a, 0x001a, 0xb5e8, 0x001a, 0xa6d3,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb5fd, 0x001a,
	0x001a, 0xc9f9, 0x001a, 0xe2e4, 0x001a, 0xbdfb, 0x001a, 0x001a,
	0xa4d7, 0xc5ce, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5ce, 0xe6d6,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbde5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcdde, 0xf3ec, 0x001a, 0x001a, 0xe0ed,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xecec, 0xbefb, 0xebdf, 0x001a, 0xf8e1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbef9,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf3d0, 0xaae0, 0xe2e8, 0x001a,
	0x001a, 0xd4e2, 0xfdd2, 0x001a, 0xa8e5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd3d9, 0x001a, 0x001a, 0x001a, 0x001a, 0xded3,
	0x001a, 0xb8f4, 0xbcf7, 0xfddc, 0x001a, 0xece8, 0xe7e4, 0x001a,
	0x001a, 0xf7e3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8ec,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf1fa, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf2e5, 0x001a, 0x001a, 0xf4d0,
	0xafd2, 0xe5dc, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5d0, 0xb4f1,
	0xb1fc, 0xf8cc, 0x001a, 0x001a, 0xc6dd, 0xd1fa, 0x001a, 0xdff7,
	0x001a, 0x001a, 0xa8fa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf5ee, 0x001a, 0xcede, 0x001a, 0x001a, 0x001a, 0x001a, 0xf3e7,
	0x001a, 0x001a, 0xacf7, 0xc4eb, 0xe1ed, 0xabe0, 0xc7dd, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb3d2, 0xbfd2, 0x001a, 0x001a, 0x001a,
	0xccca, 0x001a, 0x001a, 0x001a, 0x001a, 0xbffb, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfde5, 0xe5dd, 0xcdd8, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf4ec, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf5d0, 0x001a, 0x001a, 0xede8, 0xd2d0,
	0x001a, 0xd8d9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe6f6, 0x001a, 0x001a,
	0xaadb, 0x001a, 0x001a, 0x001a, 0xe0f7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd9d8, 0x001a, 0xa3f4, 0x001a, 0x001a, 0xddf4, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd1ef, 0x001a, 0x001a, 0xb5d9, 0x001a,
	0x001a, 0xabed, 0x001a, 0xb7e3, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbbee, 0xb4cd, 0x001a, 0xf3e0, 0xcdea, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf5ec, 0xeee8, 0x001a, 0xa9cb, 0xaff1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcdca, 0x001a,
	0xa9ec, 0x001a, 0xebf2, 0x001a, 0xeffd, 0x001a, 0xf3f9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc1e6, 0x001a, 0x001a, 0xd8ec, 0x001a, 0x001a, 0x001a, 0xaced,
	0x001a, 0xceea, 0x001a, 0xdfe8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcfde, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa6d2, 0x001a, 0x001a, 0xf4e7, 0xd6d1, 0x001a, 0x001a, 0xc2e6,
	0xe3e3, 0x001a, 0x001a, 0x001a, 0x001a, 0xb0e4, 0x001a, 0x001a,
	0x001a, 0xb4d8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5f6, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdef3, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa5d7, 0x001a, 0x001a, 0x001a, 0x001a, 0xe8f7, 0x001a,
	0x001a, 0xc6e8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe6fb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe6dd, 0x001a, 0x001a, 0x001a, 0xfedc, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xdad8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xacda, 0xb0ea, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb8e3, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaaca, 0xf9e1, 0x001a, 0xb1ea, 0x001a, 0x001a, 0x001a,
	0x001a, 0xecf2, 0x001a, 0x001a, 0xeefa, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd5ee, 0x001a, 0x001a, 0x001a, 0x001a, 0xf4f9, 0x001a,
	0x001a, 0xecd2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfbfb, 0x001a, 0x001a,
	0x001a, 0xf0fd, 0x001a, 0xbde0, 0xe3ce, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc6f8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaede, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc5df, 0x001a, 0x001a, 0xbee5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaded, 0xeafa, 0x001a, 0x001a, 0xeecd, 0xa6ed, 0x001a, 0xaeed,
	0xedf0, 0x001a, 0xa1dd, 0x001a, 0xafed, 0xf8fc, 0x001a, 0xebd8,
	0x001a, 0x001a, 0x001a, 0xf9cc, 0xb5cd, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa9fa, 0x001a, 0xdde1, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd5e2, 0xcfed, 0x001a, 0x001a, 0x001a, 0xa2dd, 0x001a, 0x001a,
	0xcaf9, 0x001a, 0xe8ea, 0x001a, 0xede5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xebd3, 0x001a, 0xd4e9,
	0xfae1, 0xcce4, 0x001a, 0xe4e1, 0xc7e8, 0x001a, 0x001a, 0xdbce,
	0x001a, 0x001a, 0x001a, 0xd5dc, 0x001a, 0xb5f7, 0xf3fc, 0xf3f0,
	0xafce, 0xb5f1, 0xd2ef, 0xc8e8, 0xf1eb, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd4cb, 0xbee0, 0xf8e3, 0xe9ea, 0xb2fc, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf4e0, 0x001a, 0xe0cf, 0x001a,
	0xa5ee, 0x001a, 0x001a, 0xaafa, 0xc3e6, 0xb2e1, 0xabca, 0x001a,
	0xe4e3, 0xbbe9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd6e2,
	0xf2f3, 0x001a, 0xd6ee, 0xb2ea, 0xf6d0, 0xd9ec, 0xcbda, 0xa8cf,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa3dd, 0x001a, 0x001a, 0x001a,
	0xdbd8, 0x001a, 0xcef9, 0xd5e9, 0xd1e3, 0x001a, 0x001a, 0xbcd2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xacd8, 0xccf3,
	0x001a, 0xfbcd, 0xd6f6, 0x001a, 0xf5e7, 0xefe8, 0xf9e3, 0xbbd2,
	0xf3f3, 0xfbe3, 0x001a, 0xd0de, 0xb0ce, 0x001a, 0xf7d6, 0xd9f1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc1f5, 0xc4dc, 0x001a,
	0xbbf5, 0x001a, 0xd1de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe6dc, 0x001a, 0x001a, 0xd2de, 0x001a, 0x001a, 0xe2ed,
	0xf6ee, 0xcfea, 0xeef0, 0xfce3, 0x001a, 0xdfd3, 0xf4d3, 0xb3e1,
	0x001a, 0xb4e1, 0x001a, 0x001a, 0x001a, 0x001a, 0xd3f4, 0x001a,
	0x001a, 0xc6df, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd6e9, 0x001a, 0x001a, 0x001a,
	0xabdb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa6f6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb9e3, 0xc5eb, 0xa9f4, 0xb6cd, 0xf9d2, 0x001a, 0xadda, 0xe3d2,
	0xd1cf, 0x001a, 0x001a, 0x001a, 0x001a, 0xdccb, 0xfacc, 0x001a,
	0xddcf, 0x001a, 0x001a, 0xa9e8, 0x001a, 0xbbe3, 0xbae3, 0x001a,
	0x001a, 0xdae0, 0x001a, 0x001a, 0x001a, 0xf7ee, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb3dc, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf5d3, 0x001a, 0xa6d7, 0x001a, 0xb5f6, 0xdbd7, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd5e1, 0x001a, 0x001a, 0xead4,
	0x001a, 0xa3df, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdffd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf7d0, 0xd4ed, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaacb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdbe4, 0x001a, 0xfbe1, 0xa2cb, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe0d3, 0x001a, 0xbfe4, 0x001a, 0xc0fb, 0x001a, 0xbeda,
	0xcde4, 0x001a, 0xb9d6, 0x001a, 0x001a, 0x001a, 0xc0ef, 0x001a,
	0xfce1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb9f6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc7df, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb1e4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7dc,
	0xe8dc, 0x001a, 0x001a, 0x001a, 0xd6fa, 0x001a, 0xf6d3, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdaf1, 0x001a, 0xf2fa, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfde2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcfd5, 0xf8d0, 0x001a,
	0x001a, 0xdfcd, 0x001a, 0x001a, 0xcbf5, 0x001a, 0xf0e4, 0xabcb,
	0x001a, 0xc4d7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfee2,
	0x001a, 0xdadd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xaeda, 0xeeca, 0x001a, 0x001a, 0x001a,
	0xb9d5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa1e3, 0x001a, 0x001a, 0xe3e8, 0x001a, 0x001a, 0xabf3,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9cf,
	0x001a, 0x001a, 0x001a, 0xf7d3, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf1d4, 0x001a, 0x001a,
	0xe4ce, 0x001a, 0xf2e8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf5e5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaee7, 0x001a, 0xbad6, 0x001a, 0xecdf, 0xc0e4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe4e8, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb5d8, 0x001a, 0x001a, 0x001a, 0xdce4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb9f4, 0xb6f1, 0x001a,
	0x001a, 0xdee2, 0xb5e1, 0x001a, 0x001a, 0xefcd, 0xa7f1, 0xe5ce,
	0xddcb, 0x001a, 0x001a, 0xe3d9, 0x001a, 0x001a, 0xacf3, 0x001a,
	0x001a, 0xf9d0, 0xabec, 0xd3de, 0xe9f7, 0x001a, 0x001a, 0xf5f9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdee1, 0xeecb, 0x001a,
	0x001a, 0x001a, 0xbce3, 0xd6f8, 0x001a, 0x001a, 0xeedb, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf1fd, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb6f7, 0x001a, 0x001a, 0x001a, 0x001a, 0xdef4, 0x001a,
	0x001a, 0xedf2, 0x001a, 0xd9db, 0x001a, 0xa8f0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfde1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd4de, 0x001a, 0xace0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe3ed, 0x001a, 0x001a, 0xe1d3, 0x001a,
	0xc8df, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6d9, 0x001a, 0xacfd,
	0xd3ef, 0x001a, 0x001a, 0x001a, 0xc1e4, 0xebf8, 0x001a, 0xacdb,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc6fc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xadd8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbaf6,
	0x001a, 0xdfdb, 0xd3d3, 0xc7f8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xceca, 0xc1f8, 0xb4d2, 0x001a, 0x001a, 0xb4dc,
	0xb9fa, 0xcfca, 0x001a, 0xb3fc, 0xeaea, 0xebea, 0xfad0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe4ed, 0x001a, 0x001a, 0xe7dd,
	0x001a, 0x001a, 0xc9df, 0x001a, 0x001a, 0x001a, 0x001a, 0xeddf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbcee, 0x001a, 0xc1ef,
	0x001a, 0x001a, 0xd2cc, 0x001a, 0xa4dd, 0x001a, 0x001a, 0x001a,
	0xcadf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf8d3, 0xa8f1,
	0x001a, 0x001a, 0x001a, 0xb7cd, 0x001a, 0xd4ef, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdde4, 0xeedf, 0xaccb,
	0xbce9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xecea, 0x001a,
	0x001a, 0x001a, 0xcbdf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbff9, 0xafd6, 0xc6d5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaacf, 0x001a, 0x001a, 0xa9ce, 0x001a, 0x001a, 0xf8d6, 0x001a,
	0x001a, 0x001a, 0xb7f1, 0xf8ee, 0x001a, 0x001a, 0x001a, 0xd9d9,
	0xdff3, 0x001a, 0xc8f8, 0xc6ce, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe6d5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe6f4, 0x001a, 0x001a, 0xc5e6, 0xd5ef,
	0x001a, 0x001a, 0xefcb, 0xdffc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa7dc, 0x001a, 0x001a, 0xe7d6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc9f8, 0x001a, 0x001a, 0x001a, 0x001a, 0xd2e3,
	0x001a, 0xbde3, 0x001a, 0xe1cf, 0xc0f0, 0xdaec, 0x001a, 0xd7dd,
	0xf0fb, 0x001a, 0x001a, 0xacec, 0x001a, 0x001a, 0x001a, 0xa9f0,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd7fa, 0xc1fb,
	0x001a, 0xc0d2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb0e5, 0x001a, 0x001a, 0x001a, 0xe5ed, 0x001a, 0x001a,
	0x001a, 0x001a, 0xadcb, 0x001a, 0xb0f9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa5f7, 0x001a, 0xaecb, 0x001a, 0xafda, 0x001a, 0xb6d8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa7d3, 0xb2fb,
	0x001a, 0xc4fd, 0x001a, 0xadec, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa1fb, 0x001a, 0x001a, 0x001a, 0xe9e5, 0xeee9,
	0x001a, 0xf4f3, 0xf3f8, 0xc1f0, 0xafde, 0xb0f8, 0x001a, 0x001a,
	0xe0f3, 0xafe7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaddb,
	0x001a, 0xb5e6, 0x001a, 0x001a, 0xa8f9, 0x001a, 0x001a, 0xd8dd,
	0xd9e8, 0xd6ef, 0x001a, 0x001a, 0x001a, 0xe2d3, 0x001a, 0xdfe2,
	0x001a, 0x001a, 0xe0fc, 0xc8d7, 0xadfd, 0x001a, 0x001a, 0x001a,
	0xefdf, 0xd3cc, 0xf9d3, 0x001a, 0x001a, 0x001a, 0x001a, 0xf0d4,
	0xc7db, 0xd5de, 0x001a, 0x001a, 0x001a, 0x001a, 0xf4f0, 0x001a,
	0xd0d5, 0xd9e5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc7fc, 0xd6dc, 0xe0e2, 0x001a, 0x001a, 0x001a, 0xb0da, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3f3, 0x001a, 0xecd3,
	0x001a, 0xcbf4, 0x001a, 0x001a, 0x001a, 0xc5fd, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfde3, 0x001a, 0xb1f9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfbd0, 0xdbec, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbcf5, 0xa4f2,
	0xced8, 0xcfd8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf7f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe1f6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb7d2, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xecfb, 0x001a, 0xc8dd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe8e4,
	0x001a, 0x001a, 0xc1d2, 0x001a, 0x001a, 0x001a, 0xd7f8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbbd6, 0xd6de, 0x001a, 0x001a,
	0xbdf7, 0xaeec, 0x001a, 0x001a, 0x001a, 0xe1d0, 0x001a, 0xf5e0,
	0xb3ea, 0x001a, 0xd6ce, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5cc,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf6ec, 0xe1e2, 0xbee3, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc8fc, 0x001a, 0x001a,
	0xf0cd, 0x001a, 0xf6f9, 0x001a, 0x001a, 0xf0df, 0x001a, 0x001a,
	0x001a, 0xbfe5, 0x001a, 0x001a, 0x001a, 0xbfce, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe1fc, 0xb0ed, 0xd1fd, 0xbbf6, 0x001a, 0x001a,
	0xcff9, 0xdaeb, 0xc1ca, 0x001a, 0xb8d2, 0xf1cd, 0x001a, 0xd3e3,
	0xe6fd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xede6, 0x001a, 0x001a,
	0x001a, 0xfae3, 0x001a, 0x001a, 0xaaf0, 0xd0f9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe2fc, 0x001a, 0xa7f8, 0x001a,
	0x001a, 0x001a, 0xe5e1, 0xf9ee, 0x001a, 0x001a, 0x001a, 0xf6e7,
	0xedea, 0x001a, 0x001a, 0xb4fc, 0xc2f5, 0x001a, 0x001a, 0xdcd7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf5f0, 0x001a, 0xe8dd, 0xedd3, 0xfcf5, 0x001a, 0xbfda, 0x001a,
	0xfbcc, 0x001a, 0x001a, 0x001a, 0xfad3, 0xa4f4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd7ef, 0x001a, 0xc3d4,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe3fb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xedfb, 0x001a, 0xade0, 0x001a, 0x001a, 0xeeea,
	0xb3fb, 0xc2e4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe7f6, 0xddd2, 0x001a, 0xccdf, 0x001a, 0x001a, 0xc9fc, 0x001a,
	0x001a, 0xa9e5, 0xf6e0, 0xb3f6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfee1, 0x001a, 0x001a, 0x001a, 0x001a, 0xf0cb, 0x001a,
	0xefea, 0xf0ea, 0x001a, 0x001a, 0x001a, 0xc0da, 0xb4f8, 0xf2eb,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc3e4, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd7e9, 0xf1e4, 0x001a, 0x001a, 0x001a, 0xefca,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd7ce,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcafc, 0x001a, 0x001a, 0x001a, 0xe1f3, 0x001a, 0x001a, 0xc4cb,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe5e3, 0x001a, 0xc5cb, 0xb4ea,
	0x001a, 0x001a, 0xbde9, 0x001a, 0xc9d7, 0x001a, 0x001a, 0xdbeb,
	0xb1ed, 0x001a, 0xc3cc, 0xbef7, 0xcbfc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf4f8, 0x001a, 0xb7d9, 0x001a, 0x001a,
	0xd3f3, 0xd4f3, 0x001a, 0x001a, 0x001a, 0xe4f7, 0x001a, 0xd1f7,
	0x001a, 0x001a, 0xb7d8, 0xb1ce, 0xc2ca, 0x001a, 0x001a, 0xb4fb,
	0xc6cb, 0x001a, 0x001a, 0xf6f0, 0x001a, 0x001a, 0xe7d5, 0x001a,
	0xd0ea, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4cc, 0xafcb,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaaf4, 0xafe9, 0x001a,
	0x001a, 0xc3f5, 0xd8e9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe9dd, 0x001a, 0x001a, 0x001a, 0xf3f1, 0x001a,
	0xfbd5, 0xbbde, 0x001a, 0x001a, 0xfbf4, 0x001a, 0x001a, 0x001a,
	0xf3fd, 0xf2fd, 0xa6f7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc9dd, 0x001a, 0x001a, 0xd3d4,
	0x001a, 0xa8cc, 0x001a, 0xc1da, 0xd5cc, 0x001a, 0xe4d9, 0x001a,
	0x001a, 0x001a, 0xcafa, 0x001a, 0x001a, 0x001a, 0xe3e5, 0x001a,
	0x001a, 0x001a, 0xbcd3, 0x001a, 0x001a, 0x001a, 0xf0ca, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc4d0, 0x001a, 0x001a, 0x001a, 0xd0ca,
	0xabfa, 0xebeb, 0xf8e7, 0xe5d9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd7d1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa4f3, 0x001a, 0x001a, 0x001a, 0xfbd4, 0xe3fc,
	0xd8fa, 0x001a, 0xd5f3, 0x001a, 0xabcf, 0x001a, 0x001a, 0xf3eb,
	0xfcd5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4d3,
	0xfccd, 0x001a, 0xe6d9, 0x001a, 0xf9e2, 0xa1e2, 0xd4eb, 0x001a,
	0xf7e0, 0xb2e4, 0xfccc, 0x001a, 0x001a, 0x001a, 0xe4fb, 0x001a,
	0x001a, 0x001a, 0xabf4, 0x001a, 0x001a, 0x001a, 0x001a, 0xbdd0,
	0x001a, 0xf1ca, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb8ef, 0x001a, 0x001a, 0x001a, 0xc0d7, 0x001a,
	0xfaee, 0xf4fd, 0x001a, 0x001a, 0xe3d3, 0x001a, 0xc2fb, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe8d5, 0xaedb,
	0xb6e1, 0xb7f8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbfe0,
	0xc3fb, 0xeadd, 0x001a, 0xa2e2, 0x001a, 0xa6ee, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe8f6, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf5f6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcadd, 0x001a,
	0x001a, 0xe2d0, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6dd, 0x001a,
	0x001a, 0xebdd, 0x001a, 0x001a, 0xf9e4, 0x001a, 0x001a, 0xafe3,
	0xfcd0, 0x001a, 0x001a, 0x001a, 0xfcf4, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbccc, 0xeaf7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe4e5, 0xf1df, 0x001a, 0x001a, 0xe1f7, 0x001a, 0xf7f9,
	0xb9ef, 0x001a, 0x001a, 0xd8f8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa9f9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd9f8, 0x001a, 0x001a, 0x001a, 0xbdee, 0x001a, 0x001a,
	0x001a, 0xc6d8, 0x001a, 0x001a, 0xe3e4, 0xcef5, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd9dd, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7d9,
	0xb9d2, 0xc3d5, 0x001a, 0x001a, 0xe5da, 0xd0da, 0x001a, 0xd9d1,
	0xd8ce, 0x001a, 0xdecb, 0xacf4, 0xfbda, 0x001a, 0xe9f6, 0xf3e8,
	0xaccf, 0xf0f0, 0x001a, 0xfdf4, 0xc8db, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc0ce, 0xd4e3, 0xcfd1, 0xf5f1,
	0x001a, 0xf2cd, 0x001a, 0xebcf, 0x001a, 0x001a, 0x001a, 0xb8cd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6e3, 0xdad1,
	0x001a, 0xa5f2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6f2,
	0x001a, 0xcee4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfbd3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa9f1, 0x001a, 0x001a, 0x001a, 0xc9f2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd8ef, 0xc9e6, 0x001a, 0xb8d8, 0xf3fa, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb5f3, 0x001a, 0x001a, 0xa4f8, 0x001a, 0x001a, 0xf3d1,
	0xc8e6, 0x001a, 0x001a, 0x001a, 0x001a, 0xdaf8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9dc,
	0xd7de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdfcb, 0x001a,
	0x001a, 0x001a, 0xeccf, 0x001a, 0x001a, 0x001a, 0x001a, 0xdff4,
	0x001a, 0x001a, 0xf4d1, 0xbad2, 0x001a, 0x001a, 0x001a, 0xf2df,
	0x001a, 0x001a, 0x001a, 0xb7e1, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa3e2, 0xfcd3, 0x001a, 0x001a, 0xe6ed, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc9db, 0x001a, 0x001a, 0x001a, 0xfae4, 0x001a,
	0xdecf, 0x001a, 0x001a, 0xd0ce, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd3d5, 0xf5f3, 0xaef7, 0x001a, 0x001a, 0xc8ef, 0x001a, 0xf3cd,
	0xcff5, 0xf3e5, 0xc2f0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd1ca, 0x001a, 0x001a, 0x001a, 0xf1ea, 0x001a, 0xa6d0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdad9,
	0xabf0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7eb, 0x001a,
	0x001a, 0x001a, 0xc0e5, 0xb5fc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc4e4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9cc, 0xc6fd, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb5ea, 0x001a, 0xaae5, 0xbadf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdfe1, 0x001a, 0xd1da,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb8e1, 0x001a, 0xf4e8, 0xfdd3,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa4e2, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcaf2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe6da, 0xb3f7, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcdfd, 0x001a, 0x001a, 0x001a, 0xb6f3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd7ee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc4f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa4d8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa7f2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb8d9, 0xb9d9, 0xc9ef, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xced6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcbf7, 0xaedf, 0xf5e8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb5d2, 0x001a, 0x001a, 0x001a, 0xd5d3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xccf4, 0xfcda, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe8d9, 0x001a, 0xebf7, 0xc9f5, 0x001a,
	0xbcf3, 0x001a, 0xd2da, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb5d3, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb6e8, 0x001a, 0x001a, 0xcfd6, 0xbaf4, 0x001a, 0xc9f7,
	0x001a, 0x001a, 0xaacc, 0x001a, 0x001a, 0xc3f0, 0xd6cc, 0x001a,
	0x001a, 0x001a, 0xd3d0, 0x001a, 0xbdd3, 0x001a, 0x001a, 0x001a,
	0xfbdb, 0x001a, 0xe0cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe4d3, 0xf7f6, 0x001a, 0x001a, 0xbad5, 0xcdf3, 0xe1cb,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf4eb, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xadf4, 0x001a, 0xaafc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xecf7, 0x001a, 0x001a, 0x001a, 0xf6e8, 0x001a,
	0xe7da, 0x001a, 0x001a, 0x001a, 0xccf7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc1e5, 0x001a, 0x001a, 0x001a, 0x001a, 0xeee0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfdd5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe6ce, 0xabfc, 0xbbd5, 0x001a, 0x001a, 0xa8f2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5e2, 0xb9cd,
	0xf2ea, 0xc7cb, 0x001a, 0xf4cd, 0x001a, 0x001a, 0xafdb, 0xd9ef,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbacd, 0x001a, 0x001a,
	0xf9fc, 0x001a, 0x001a, 0x001a, 0x001a, 0xf3df, 0xe7ce, 0xc2da,
	0x001a, 0xadcf, 0x001a, 0x001a, 0x001a, 0x001a, 0xf9e7, 0xa8f8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe2f3, 0x001a,
	0x001a, 0x001a, 0xf2ca, 0xa4df, 0x001a, 0x001a, 0xc4d4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd7cc, 0xc2e5, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbbcd, 0x001a, 0xdaef, 0xd8ee, 0x001a, 0xa7dd,
	0xa6e2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc0e0, 0x001a,
	0x001a, 0x001a, 0xb0d6, 0xcaf8, 0x001a, 0xfafc, 0x001a, 0xfed9,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb0de, 0x001a, 0x001a, 0x001a,
	0xecdd, 0xe8da, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe0d4,
	0x001a, 0xf9d6, 0x001a, 0xd7cd, 0xd8de, 0x001a, 0x001a, 0xf8f2,
	0x001a, 0xd6e4, 0x001a, 0x001a, 0xc5d0, 0xaef4, 0x001a, 0xa8dd,
	0x001a, 0x001a, 0x001a, 0xc5ed, 0xd6f3, 0x001a, 0x001a, 0xd9de,
	0xe6e3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8d3,
	0x001a, 0xb0db, 0x001a, 0x001a, 0xdae5, 0xbfe3, 0x001a, 0x001a,
	0x001a, 0xb1db, 0x001a, 0x001a, 0x001a, 0xe9d5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc1e0, 0xdbef, 0x001a, 0x001a, 0xe9f0,
	0x001a, 0x001a, 0xb2d7, 0x001a, 0x001a, 0x001a, 0x001a, 0xfdd0,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe9d9, 0x001a, 0x001a, 0xfed0, 0x001a, 0xedec, 0xa9d3, 0x001a,
	0xa9f2, 0xc4f0, 0x001a, 0x001a, 0xe2e2, 0xefe9, 0x001a, 0x001a,
	0x001a, 0xd1f9, 0x001a, 0x001a, 0xd9e9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xdae8, 0xc3da, 0xc4da, 0xc5d4, 0x001a, 0xfae7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe0cd, 0xb0e3,
	0x001a, 0xb2db, 0xc4fb, 0x001a, 0xe3f3, 0x001a, 0xa5d9, 0xe7fb,
	0xcbdd, 0xd4d0, 0x001a, 0xb6e6, 0xaee0, 0xdafd, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb5dc, 0xf8e0,
	0xb1e7, 0x001a, 0x001a, 0x001a, 0x001a, 0xf0f5, 0x001a, 0xdcd8,
	0xc6ed, 0x001a, 0x001a, 0x001a, 0x001a, 0xb9e1, 0x001a, 0xc0e3,
	0xc0f9, 0xf0e9, 0x001a, 0x001a, 0xdbd9, 0x001a, 0xe4f3, 0x001a,
	0x001a, 0x001a, 0xb6dc, 0xe9e4, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc5f0, 0xc1e3, 0xccfc, 0xcdfc, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcbf2, 0x001a, 0xccf2, 0x001a, 0x001a, 0x001a, 0xcfe4,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdbf1, 0x001a, 0xd9fa, 0x001a, 0xb8f1, 0xf5fd, 0xf9e0,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfbe7, 0xb7fc, 0xe4fc, 0xc5fb,
	0xe7e3, 0xb9d8, 0x001a, 0xf8f6, 0x001a, 0x001a, 0xc5dc, 0xd8cc,
	0x001a, 0x001a, 0x001a, 0xafe0, 0xe7f4, 0x001a, 0xdcef, 0xfccf,
	0xddef, 0x001a, 0xaaf2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbefd, 0x001a, 0x001a, 0xacca,
	0xbbfd, 0xc7fd, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2e7, 0x001a,
	0xd1ea, 0xf4df, 0x001a, 0x001a, 0x001a, 0x001a, 0xecd1, 0xdee4,
	0xc3e5, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6d9, 0x001a, 0x001a,
	0xbccd, 0x001a, 0xe5f3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd5ed, 0x001a, 0x001a, 0xbad9, 0x001a,
	0x001a, 0x001a, 0xe7ed, 0xb5fb, 0xecf8, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe7e0, 0x001a, 0xd9cc, 0x001a, 0x001a, 0xc6d4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa5e7, 0x001a, 0xf5d5, 0xbed3,
	0x001a, 0xfbfc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf2e4, 0x001a,
	0x001a, 0xf5df, 0x001a, 0x001a, 0xf8e8, 0xedf8, 0x001a, 0x001a,
	0xc7ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf6fd, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd8e8, 0x001a, 0xd8cd, 0xd6e7, 0xdacc, 0x001a, 0x001a, 0xe3ca,
	0xf6df, 0xc7f0, 0xc6f0, 0x001a, 0xbad8, 0x001a, 0xf4f1, 0xf0f4,
	0xccf5, 0x001a, 0x001a, 0xe5fc, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc5ea, 0xf3ea, 0x001a, 0xdbdd, 0x001a, 0xd7dc, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfdde, 0xf9f2, 0x001a, 0xc7d5,
	0x001a, 0x001a, 0x001a, 0xd0d8, 0x001a, 0xc8f0, 0xa1d1, 0xa2d1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4d9, 0xe8d6,
	0xcad9, 0x001a, 0xb1da, 0xc7d8, 0xe2dc, 0xcef3, 0xf4f5, 0x001a,
	0x001a, 0xb9f1, 0x001a, 0x001a, 0xd3da, 0x001a, 0xeaf6, 0x001a,
	0x001a, 0x001a, 0xf5cf, 0x001a, 0x001a, 0xaefd, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd2ca, 0x001a,
	0x001a, 0xb4df, 0x001a, 0x001a, 0x001a, 0x001a, 0xddd7, 0xbafa,
	0xa7ee, 0xbdf5, 0x001a, 0xf5f8, 0x001a, 0x001a, 0xe8ed, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe1d4, 0x001a, 0xa3d1, 0xd6e1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf8f9, 0x001a, 0xcadb,
	0xf9cb, 0xd4d4, 0x001a, 0xdcd9, 0x001a, 0xbeee, 0x001a, 0xedf7,
	0x001a, 0x001a, 0x001a, 0xeed2, 0x001a, 0x001a, 0xe6e1, 0xf9f7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeddd,
	0x001a, 0xdbe8, 0x001a, 0xb3db, 0x001a, 0x001a, 0x001a, 0xf7d1,
	0xb0e0, 0x001a, 0x001a, 0xe2d4, 0x001a, 0xd7f6, 0x001a, 0xf9d7,
	0x001a, 0x001a, 0xddd8, 0x001a, 0xfdcd, 0xabf2, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbdcd,
	0xc2f8, 0x001a, 0x001a, 0xacf2, 0x001a, 0x001a, 0xadca, 0xaeca,
	0xaecf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc2e3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb7dc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdadb,
	0xbbd9, 0xf3ca, 0xd3f6, 0xf8e6, 0xf5ea, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf6ea, 0x001a, 0x001a, 0xf9f6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xafcf, 0x001a, 0x001a, 0xd3ca, 0x001a, 0x001a, 0xafca,
	0xb0d2, 0xbaf1, 0x001a, 0xb3d7, 0xc3e3, 0xfdf3, 0xdade, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdbde, 0x001a, 0x001a, 0xdeef, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe3e2, 0xfbee, 0x001a, 0x001a, 0xf7df, 0xcad7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe8ce, 0xdbdb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbbf1, 0x001a, 0x001a, 0x001a, 0x001a, 0xf1e9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb7fa, 0xc6d0, 0x001a, 0x001a, 0xabcc, 0xa8ee, 0x001a, 0x001a,
	0xfacb, 0xf9f9, 0xfdcc, 0xfed3, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd0e4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeef2, 0x001a,
	0xd5d4, 0xcddf, 0x001a, 0xb8fc, 0xd0d1, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcdf2, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd2f7, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4ca,
	0x001a, 0xd9d5, 0x001a, 0x001a, 0x001a, 0xded8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd9cd,
	0x001a, 0x001a, 0x001a, 0xa9ee, 0xbcf6, 0x001a, 0x001a, 0xdbcc,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc9f0, 0x001a, 0xfcfc,
	0x001a, 0xc9e8, 0xfef4, 0x001a, 0x001a, 0x001a, 0x001a, 0xfce7,
	0xded7, 0x001a, 0x001a, 0x001a, 0x001a, 0xdcde, 0x001a, 0xacf0,
	0xfecc, 0xe1cd, 0x001a, 0xbae1, 0x001a, 0xefdb, 0xb2da, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa5d1, 0xb8dc, 0x001a, 0x001a,
	0x001a, 0xf6d8, 0x001a, 0xa4d1, 0x001a, 0xe2cd, 0x001a, 0x001a,
	0x001a, 0x001a, 0xeadc, 0x001a, 0x001a, 0xf7f0, 0x001a, 0xcaf0,
	0xbed0, 0x001a, 0xdcdd, 0x001a, 0x001a, 0x001a, 0x001a, 0xd6d4,
	0xd6d3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd0ed,
	0xa1cd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb5df, 0x001a,
	0x001a, 0x001a, 0xf8df, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa1d4, 0xb2ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcae8, 0x001a, 0x001a, 0x001a, 0x001a, 0xf5eb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5e3, 0xd0f5, 0x001a,
	0x001a, 0x001a, 0xa1f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa7d9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xabe5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbe6, 0x001a, 0xf1f5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc5e5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa3f9, 0xdbe0, 0xebf6, 0x001a, 0xf1cb,
	0x001a, 0xead9, 0xa2f5, 0x001a, 0x001a, 0x001a, 0xd1d7, 0x001a,
	0xf8d1, 0xf8ea, 0xf9ea, 0xb3da, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdfef, 0x001a, 0x001a, 0xeff1, 0x001a, 0xf6e5, 0xbfee, 0xe4e2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbfd0, 0x001a, 0xacfa,
	0xd1f5, 0xb3e7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbee9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcef2, 0xb4db, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcefc, 0x001a, 0xeedd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb4e7, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb4d7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb4f7, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbecd, 0x001a, 0xe9da, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb0cf, 0xd9f7, 0xe6f3, 0x001a, 0x001a,
	0xd9ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaace, 0x001a, 0xc8cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa7d0, 0x001a, 0xcbf0, 0x001a, 0xc7d0,
	0x001a, 0x001a, 0xc5e4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe0db, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdad5, 0x001a, 0xa7d7, 0x001a, 0x001a, 0x001a, 0xc0ee,
	0x001a, 0xf6f8, 0x001a, 0x001a, 0x001a, 0x001a, 0xd2f5, 0xe9ed,
	0x001a, 0xbcd9, 0x001a, 0xc6e5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3f5, 0x001a, 0x001a,
	0xd4da, 0xa7e2, 0xfcfb, 0x001a, 0x001a, 0xdcf1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf4ca, 0x001a, 0x001a, 0x001a,
	0xfae8, 0x001a, 0x001a, 0xe9ce, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf8e9, 0xe5e2, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb9d0, 0xf2d4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6d1,
	0x001a, 0xcedf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf4fc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaad3, 0x001a, 0x001a, 0x001a, 0xaccc, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe0ef, 0x001a, 0x001a, 0x001a, 0xe5e5, 0xd5d0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfcdb,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe6fc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfecb, 0xeaed, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb1de, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe3f9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa2d4, 0xf6cf, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd0d6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xead5, 0xeef1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbfa, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa1e5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb1d5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xedcf, 0x001a, 0xebed, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb2d5, 0x001a, 0x001a, 0x001a, 0xbcd5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe2fd, 0xadf3, 0x001a, 0xdbfd, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb0e9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa7d1, 0x001a, 0x001a, 0xe3fd, 0xb3ce, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe4fd, 0xcefa,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb0ca, 0x001a, 0xa7f7, 0x001a,
	0xb1cf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa2e6,
	0x001a, 0xb6fc, 0xadf2, 0xe1ef, 0xaef3, 0xc6dc, 0xebd9, 0x001a,
	0x001a, 0x001a, 0xe0e8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa8e1, 0x001a, 0x001a, 0x001a, 0x001a, 0xf6d5,
	0xfdcf, 0x001a, 0x001a, 0xddde, 0x001a, 0x001a, 0x001a, 0xd1d9,
	0x001a, 0x001a, 0x001a, 0xeae4, 0xcff2, 0x001a, 0xbff7, 0x001a,
	0x001a, 0xe6e2, 0xa8e2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd6e3, 0x001a,
	0xd1ed, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf9e9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb1d6, 0xb2de,
	0x001a, 0x001a, 0xe8e0, 0x001a, 0x001a, 0xabd3, 0x001a, 0xdceb,
	0x001a, 0x001a, 0xafdf, 0x001a, 0xc3ca, 0x001a, 0x001a, 0xfcee,
	0x001a, 0xc3fd, 0x001a, 0x001a, 0x001a, 0xf6eb, 0xb2cf, 0x001a,
	0x001a, 0x001a, 0x001a, 0xecd9, 0x001a, 0xbdd9, 0x001a, 0xdfd8,
	0x001a, 0x001a, 0xb8d4, 0xbeeb, 0xefdd, 0x001a, 0xf0dd, 0xf1dd,
	0xf2dd, 0x001a, 0x001a, 0xbed9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc6fb, 0xb3cf, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xfdee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xabe4,
	0x001a, 0xc5da, 0x001a, 0xecd8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa8d1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa9e2, 0x001a, 0x001a, 0xbcde,
	0xb5e7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf0db, 0x001a,
	0xe2ef, 0xf0f1, 0xb4cf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf1db, 0x001a,
	0xb1e0, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5df, 0x001a, 0xd2f9,
	0x001a, 0x001a, 0xfde7, 0x001a, 0x001a, 0xa3e6, 0xf1fb, 0xb0cb,
	0xaef2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe7cd, 0x001a, 0xdce8, 0x001a, 0x001a, 0xd7e7, 0x001a, 0x001a,
	0xc0f7, 0x001a, 0xe3d0, 0x001a, 0x001a, 0x001a, 0xa1da, 0x001a,
	0x001a, 0x001a, 0xbdcc, 0x001a, 0x001a, 0xa9d1, 0xccdd, 0x001a,
	0x001a, 0xfee3, 0xaad1, 0xaae8, 0x001a, 0xb6ea, 0xfaf9, 0xcce6,
	0xd8f6, 0x001a, 0x001a, 0x001a, 0xc7d4, 0x001a, 0x001a, 0x001a,
	0xcbd9, 0x001a, 0xd2d9, 0xcbd3, 0xf7d8, 0xa9da, 0xf8f5, 0x001a,
	0x001a, 0xdede, 0xaff2, 0xa9f8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc8d8, 0x001a, 0x001a, 0xc1ee, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc1f9, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf3dd, 0xfaea, 0x001a, 0xbdf6, 0xbbe1, 0xbfcd, 0xd4f4, 0xcde6,
	0x001a, 0xcffc, 0xa2fb, 0x001a, 0xdce0, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbbf4, 0xd5da, 0x001a, 0xb2f9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf2fb, 0x001a, 0xf6db, 0x001a, 0xdfde,
	0x001a, 0x001a, 0x001a, 0xf2db, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdcf8, 0xeef7, 0xe8eb, 0x001a, 0xfad2, 0x001a, 0x001a,
	0xbcf1, 0x001a, 0x001a, 0xdafa, 0x001a, 0x001a, 0xeada, 0xc6da,
	0xc1f7, 0x001a, 0x001a, 0xb6e7, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc7e5, 0xacd6, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc7dc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9e1,
	0x001a, 0xaae2, 0x001a, 0xa6d5, 0x001a, 0x001a, 0xd7d4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd0f2, 0x001a, 0xfbea,
	0x001a, 0xdde0, 0xf3fb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbdf1, 0x001a, 0x001a, 0xe7e2, 0xd7fd, 0x001a,
	0xc8ce, 0xb7ea, 0x001a, 0xc0fc, 0x001a, 0xe7fd, 0xeff7, 0x001a,
	0x001a, 0xb5d7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbaef, 0xddf1, 0x001a, 0xb3de, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcbe8, 0x001a, 0x001a, 0xddf8, 0x001a,
	0x001a, 0xc7fb, 0xc8d5, 0x001a, 0xdfd7, 0x001a, 0xa9dd, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb1e9, 0x001a, 0x001a, 0xadfa,
	0xd9f6, 0xf4fa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaaf8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeee6, 0x001a, 0xdccc,
	0xbce1, 0xefe0, 0x001a, 0x001a, 0xbfe9, 0xfdfc, 0xcee6, 0x001a,
	0x001a, 0xd7e1, 0x001a, 0xcfe6, 0x001a, 0xf1f4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf3e4,
	0x001a, 0x001a, 0xfbe4, 0x001a, 0x001a, 0xe4f9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe3ef, 0x001a, 0x001a, 0xeecf, 0xbef6, 0xb2e0, 0xfefc, 0xabd1,
	0x001a, 0x001a, 0x001a, 0xfad7, 0x001a, 0x001a, 0x001a, 0xc8fb,
	0x001a, 0xd7e2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa3d4, 0xf8f0, 0xa8d7, 0x001a, 0x001a, 0x001a, 0xe7e1, 0x001a,
	0x001a, 0xbfd3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe4ef, 0x001a, 0xc5d7, 0xe2eb, 0x001a, 0x001a, 0xe7fc, 0x001a,
	0x001a, 0xa2e4, 0x001a, 0xe8e2, 0x001a, 0xd0e6, 0x001a, 0xe8fb,
	0xe8f4, 0xf4e5, 0xbcf4, 0xd5f4, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6df,
	0x001a, 0xb9fc, 0xc2ee, 0xf5ca, 0x001a, 0x001a, 0x001a, 0xe5ef,
	0xe2cb, 0xa4d4, 0x001a, 0xe0de, 0xfdda, 0xc6e4, 0xbee8, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdee0, 0xb4f6, 0xd2ea, 0x001a, 0xfbf9,
	0x001a, 0x001a, 0xc2e0, 0x001a, 0xe4ca, 0x001a, 0xb7e7, 0x001a,
	0xfdea, 0x001a, 0xddd9, 0x001a, 0xb4da, 0xaaee, 0xe9fb, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcbdb, 0xb5da, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbef1, 0x001a, 0x001a, 0xacd3, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc9fb, 0x001a,
	0xcfdf, 0x001a, 0x001a, 0xc0d3, 0xd7e3, 0x001a, 0xe6ef, 0xd0fc,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc0e9,
	0x001a, 0x001a, 0x001a, 0xd3f5, 0x001a, 0x001a, 0xdcec, 0xb7f7,
	0x001a, 0x001a, 0xb8ea, 0xf9d1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc8dc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb9ea, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdef1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb6d7, 0xb5cf, 0x001a, 0xa8d9,
	0x001a, 0x001a, 0xeeec, 0x001a, 0x001a, 0xaadd, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa2cd, 0xaee8, 0x001a, 0x001a, 0x001a, 0xbde1,
	0x001a, 0xd1f2, 0x001a, 0x001a, 0x001a, 0x001a, 0xc1e9, 0x001a,
	0x001a, 0x001a, 0xfcd2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb5db, 0x001a, 0xe7f3, 0xfed8, 0x001a, 0x001a,
	0x001a, 0xd1fc, 0x001a, 0xb2ed, 0xaff4, 0x001a, 0xa3fb, 0x001a,
	0x001a, 0xc1fc, 0x001a, 0xabee, 0xa5d4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf2f4,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd9ee, 0x001a, 0x001a, 0x001a,
	0xcafb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe3cd, 0xbbd8,
	0x001a, 0xdbe5, 0xf7f8, 0x001a, 0x001a, 0x001a, 0xd4f6, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9d7,
	0x001a, 0xc9cb, 0x001a, 0x001a, 0xd1e6, 0xccf0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaed8, 0x001a, 0xd3f9, 0xfed5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xbcd8, 0xb0f2, 0x001a, 0x001a, 0x001a,
	0x001a, 0xabe2, 0xe8f3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc2ef, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeced,
	0x001a, 0xb8e7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfeda, 0x001a, 0x001a, 0xbecc, 0x001a, 0x001a, 0xfcf2,
	0xebda, 0x001a, 0xd8e2, 0xd6ed, 0x001a, 0x001a, 0xd1d6, 0xb3e0,
	0x001a, 0x001a, 0xd2fc, 0x001a, 0xc8eb, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc1d3, 0xcdf0, 0x001a,
	0xf7cf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd2ed, 0x001a, 0xd8d4, 0xc9dc, 0xf1d7, 0x001a,
	0x001a, 0xbbdf, 0x001a, 0x001a, 0xa5f3, 0x001a, 0x001a, 0x001a,
	0xcdf4, 0x001a, 0x001a, 0x001a, 0x001a, 0xbff1, 0xb1f8, 0x001a,
	0xfae9, 0x001a, 0x001a, 0x001a, 0xcbfb, 0x001a, 0x001a, 0xd5ca,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd4f9, 0xcaf7, 0x001a, 0x001a, 0xc8d6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe8fc, 0xbdf3,
	0x001a, 0xfeee, 0x001a, 0xfee7, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc2d3, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6d3, 0x001a,
	0xadcc, 0xfaf6, 0xb2d6, 0xd8d2, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd8e7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5e3, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb9e7, 0x001a, 0x001a, 0x001a, 0x001a, 0xadf0,
	0xccfb, 0xa1eb, 0x001a, 0x001a, 0xa6d4, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcdfb, 0x001a, 0xbdd5, 0xdff1, 0x001a, 0x001a, 0xfbf6,
	0x001a, 0xb4de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xebd5, 0x001a,
	0x001a, 0xc8e5, 0x001a, 0x001a, 0x001a, 0xa4fb, 0xb9d4, 0x001a,
	0x001a, 0xe1de, 0x001a, 0xa3e4, 0x001a, 0x001a, 0x001a, 0xb7d7,
	0x001a, 0xeef8, 0x001a, 0x001a, 0x001a, 0xb5de, 0x001a, 0x001a,
	0xd2d6, 0x001a, 0xd5f9, 0xbae7, 0xd5eb, 0xf7d5, 0xe7ef, 0xbee1,
	0x001a, 0x001a, 0x001a, 0xaefa, 0x001a, 0x001a, 0x001a, 0xe9d6,
	0xeed6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbbe7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbec,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb3d5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb4ce, 0x001a, 0x001a, 0x001a,
	0xa5fb, 0xeee1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa8f7, 0x001a, 0x001a, 0x001a, 0x001a, 0xcefb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xbdd8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfdfb, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe9fc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb6cf, 0x001a, 0x001a, 0x001a, 0xc7ed, 0xacee, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xddcc, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa7f6, 0x001a, 0x001a, 0x001a, 0xfae6, 0x001a,
	0x001a, 0x001a, 0xa4f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdcfd, 0xb3ed, 0xc9ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe8ef, 0x001a, 0x001a, 0xbfe1, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdbfa, 0xe3cb, 0xa9f7, 0x001a, 0xa6fb,
	0x001a, 0x001a, 0x001a, 0xb9dc, 0x001a, 0x001a, 0x001a, 0xc0f1,
	0xc8ed, 0xc3ef, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xadd6, 0x001a, 0x001a, 0xcefd, 0x001a, 0x001a, 0x001a, 0xa1e8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf4fb, 0xa7d5, 0x001a, 0x001a, 0x001a, 0xf6f1, 0x001a, 0xd3e6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdecc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb2f8, 0x001a, 0x001a, 0x001a, 0xebdc, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb6fd, 0x001a, 0x001a, 0x001a,
	0x001a, 0xeae5, 0x001a, 0x001a, 0xe0f1, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xccdb, 0xcddd, 0x001a, 0x001a, 0x001a, 0xc8d4, 0x001a,
	0x001a, 0xedd9, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5f5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xfbe6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4e6, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc8fd,
	0x001a, 0xa1d6, 0xbffd, 0x001a, 0xd3fc, 0x001a, 0xa1ef, 0x001a,
	0xbce7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeed1, 0x001a,
	0x001a, 0xd5e6, 0x001a, 0x001a, 0xf2e9, 0x001a, 0xb0df, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe0d8, 0xbafc, 0xaffd, 0xcef0,
	0x001a, 0xe1db, 0x001a, 0x001a, 0xc9e5, 0x001a, 0xb4ed, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc3e0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd8e3, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfbe9, 0xa8ea, 0x001a, 0x001a, 0x001a, 0x001a, 0xb7fd,
	0x001a, 0x001a, 0xa7fb, 0x001a, 0xc2e9, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf7fd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd9e2,
	0x001a, 0x001a, 0xecdc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa2e8, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf0e6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf8fd, 0xf9fd, 0x001a, 0x001a, 0x001a, 0xbff6, 0x001a,
	0x001a, 0xa7e7, 0x001a, 0xd7e6, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf3d4, 0xc9d4, 0x001a, 0x001a, 0x001a, 0x001a, 0xfad6, 0x001a,
	0xf2d7, 0x001a, 0xc0e1, 0x001a, 0xe2db, 0xd8e6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbde7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcff0, 0xbef3, 0xace2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb7f5, 0xf0e0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb8fd, 0xe8e3, 0x001a, 0xa7d4, 0xfce8,
	0xd2fa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeff8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd3d6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb4d5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd0f0, 0x001a, 0xf0f7, 0xb3ee, 0x001a, 0x001a,
	0xbaea, 0x001a, 0xd3ea, 0x001a, 0x001a, 0xc9ed, 0xabdd, 0x001a,
	0x001a, 0x001a, 0xace5, 0xa1fd, 0x001a, 0xd0df, 0xb3ec, 0x001a,
	0xd1df, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeded, 0xb8f8,
	0xfaf7, 0x001a, 0x001a, 0x001a, 0xabf8, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe0f4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbad4, 0xb3e4, 0x001a, 0xdae9, 0x001a, 0xb6de, 0x001a, 0xbfd9,
	0x001a, 0xc0d9, 0xefd6, 0x001a, 0x001a, 0x001a, 0x001a, 0xccd9,
	0x001a, 0xaada, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe5df, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe5f7, 0x001a, 0x001a, 0x001a, 0xb2cc, 0x001a, 0x001a,
	0xf9df, 0xe0d7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbbd4, 0x001a, 0x001a, 0x001a, 0x001a, 0xfafd,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb3cc, 0x001a, 0x001a, 0xf3db,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd2df, 0x001a, 0xcace, 0x001a, 0xdaee, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe4e4, 0x001a,
	0xcffb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb7cf,
	0x001a, 0xc3ee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xeace, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xade2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe1d7, 0xf5fa, 0x001a, 0x001a, 0xc9d5, 0xacf8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd9e7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9f3, 0x001a,
	0x001a, 0x001a, 0x001a, 0xedd8, 0xc4e3, 0xf1f0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe5e8, 0x001a, 0x001a,
	0x001a, 0xfae0, 0xc4ee, 0xded9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa2eb, 0xa3eb,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc2fc, 0xbbea,
	0x001a, 0x001a, 0x001a, 0x001a, 0xabe8, 0xe2de, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xefed, 0x001a, 0xa3e8, 0x001a, 0x001a, 0x001a, 0x001a, 0xf1cf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbcd4, 0x001a, 0xeafc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbee7, 0x001a, 0xf2fc, 0x001a, 0x001a, 0xb4d6, 0x001a, 0x001a,
	0xaee2, 0x001a, 0xb7d3, 0xccfa, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdcfa, 0x001a, 0xb5ed, 0xe3e1,
	0x001a, 0xace8, 0x001a, 0xdde8, 0x001a, 0x001a, 0xe9ef, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbdf4, 0x001a, 0xb8cf, 0xdbe9,
	0xacd1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc7da,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc9eb,
	0x001a, 0xcce8, 0x001a, 0x001a, 0x001a, 0xb7de, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbcd6, 0xe5d3, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xddfa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd6da, 0x001a, 0xb1ca, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc8da, 0xa6df, 0x001a, 0xb3f9, 0xd2f2, 0x001a, 0xc4ca,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbce, 0x001a,
	0x001a, 0xf5cd, 0x001a, 0x001a, 0x001a, 0xb0fd, 0xa8d5, 0x001a,
	0xc1f1, 0x001a, 0x001a, 0xe9e2, 0xcadc, 0xb4ec, 0xc0fa, 0x001a,
	0x001a, 0xa8fb, 0xa8d0, 0x001a, 0x001a, 0xecda, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeed9,
	0x001a, 0xfbe0, 0x001a, 0x001a, 0x001a, 0xeaef, 0xdefa, 0x001a,
	0x001a, 0xc4e0, 0x001a, 0xb9cf, 0x001a, 0xcad5, 0xe2d7, 0xafe2,
	0x001a, 0xb8d7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcde8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdaf6, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa2ef, 0xdae2, 0xfcf6, 0x001a, 0x001a, 0xd0fb, 0xadd1, 0x001a,
	0xe4cd, 0x001a, 0xaed1, 0xeddc, 0xcee8, 0x001a, 0xf9f0, 0xb5ce,
	0xfce6, 0x001a, 0x001a, 0xfbd7, 0xd6d0, 0xf5dd, 0xf1f7, 0x001a,
	0xfdf6, 0x001a, 0xf7db, 0x001a, 0x001a, 0x001a, 0x001a, 0xeafb,
	0xdce9, 0xc1d9, 0x001a, 0xf2f5, 0xc5e0, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd4ea, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc2f9, 0x001a, 0xbcea,
	0x001a, 0xc5d2, 0xd1fb, 0xc0e7, 0xa5eb, 0x001a, 0xfadf, 0xa2e3,
	0xb9d7, 0x001a, 0xc3e9, 0x001a, 0xfde8, 0xafe8, 0x001a, 0x001a,
	0xd3f2, 0xa9fb, 0xa5d8, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbd5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc8d0, 0x001a,
	0x001a, 0x001a, 0xafd1, 0xe3d7, 0x001a, 0x001a, 0x001a, 0xc6e0,
	0x001a, 0xa2d6, 0x001a, 0xf0ed, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf3d7, 0x001a, 0x001a, 0x001a, 0xd4fc, 0x001a, 0xd7da, 0xdfcc,
	0x001a, 0xd4f2, 0x001a, 0xb0d1, 0x001a, 0xe0cc, 0x001a, 0xfddb,
	0xbff3, 0x001a, 0xd1f0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbbfc, 0x001a, 0xb0e2, 0x001a, 0x001a, 0xa5e6, 0x001a, 0x001a,
	0x001a, 0xdbe2, 0x001a, 0x001a, 0x001a, 0xdedf, 0x001a, 0xc7e0,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeff2, 0x001a,
	0x001a, 0x001a, 0xe1cc, 0x001a, 0x001a, 0x001a, 0x001a, 0xead6,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc2e7, 0x001a, 0x001a, 0x001a,
	0xb6ce, 0x001a, 0xc0f3, 0x001a, 0xfecd, 0x001a, 0x001a, 0x001a,
	0xd2fb, 0x001a, 0xf8f8, 0xfbf7, 0x001a, 0x001a, 0xbfe8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb7e8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6ed,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbadc, 0x001a, 0x001a, 0xb4cc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf7f1, 0x001a, 0x001a, 0x001a, 0xb8e8, 0x001a, 0x001a,
	0xf6ca, 0x001a, 0xa4e4, 0xd6f4, 0x001a, 0x001a, 0x001a, 0xe6df,
	0x001a, 0x001a, 0x001a, 0xa7df, 0x001a, 0xe7df, 0xc1e1, 0x001a,
	0xc4e9, 0x001a, 0x001a, 0xcbdc, 0xc5e9, 0x001a, 0x001a, 0x001a,
	0xa3ef, 0xa6eb, 0xa3cb, 0xe9e3, 0x001a, 0x001a, 0x001a, 0xfbd1,
	0xa4ef, 0x001a, 0xebef, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb4d0,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa3cd, 0x001a, 0x001a, 0xe6e8,
	0x001a, 0xa5ef, 0x001a, 0xccd3, 0xedda, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbad7, 0x001a, 0xd5f2, 0xe5f5, 0xefd9, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb4f9, 0x001a, 0x001a, 0xd4d5, 0xcffd, 0x001a,
	0x001a, 0x001a, 0xe3db, 0x001a, 0x001a, 0x001a, 0x001a, 0xe1f1,
	0xb6ec, 0x001a, 0x001a, 0x001a, 0x001a, 0xfefb, 0xd7d3, 0x001a,
	0xb1d1, 0x001a, 0xb1cb, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2d1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2cb, 0xc2f1,
	0x001a, 0x001a, 0xe1f4, 0xb5f9, 0x001a, 0x001a, 0xc3e1, 0xc2e1,
	0x001a, 0xf7eb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8df, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcacb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb9e6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdef8, 0xaaf9, 0xf7ca, 0x001a, 0xb7ed, 0x001a, 0x001a,
	0xb8d3, 0xd6f2, 0x001a, 0x001a, 0xd9d4, 0xc5ee, 0xf0f2, 0x001a,
	0x001a, 0x001a, 0xb2ca, 0x001a, 0x001a, 0xbbdc, 0x001a, 0xf8f1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb7ec, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcae5, 0x001a, 0xc0f6, 0xddfd, 0x001a, 0x001a,
	0xe3d4, 0xe2cc, 0x001a, 0xd4f7, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe5d7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc3d3, 0x001a, 0xa6d8, 0x001a, 0xc1f6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf6dd, 0x001a, 0xc0cd, 0x001a, 0x001a, 0x001a,
	0xdce5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbe5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc4e1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb0e8,
	0xb0f4, 0xeaf3, 0xeeda, 0x001a, 0xbbd7, 0x001a, 0xb1e2, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xaad7, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfbd6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdfe4, 0x001a, 0xd6ca, 0x001a,
	0x001a, 0x001a, 0xa8eb, 0x001a, 0x001a, 0x001a, 0xfedb, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc2f6, 0x001a, 0x001a, 0xbbef, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfdd4, 0x001a, 0x001a, 0xc8e0, 0x001a, 0x001a, 0x001a,
	0xb9e8, 0x001a, 0xa6ef, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa4cd, 0x001a, 0x001a, 0xf4d4, 0xa1db, 0xdcdb, 0xdddb, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdcee, 0x001a, 0xcbcb, 0xd5fc,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xebce, 0x001a,
	0xc1cd, 0x001a, 0x001a, 0xd3fb, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xabf9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd4f5, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9d9,
	0x001a, 0x001a, 0xdde9, 0xcddb, 0x001a, 0x001a, 0xcedd, 0x001a,
	0xc3e7, 0x001a, 0xccec, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xecf9, 0x001a, 0x001a, 0x001a, 0xcccb, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfce0, 0xa8d4, 0x001a, 0xd3ed, 0xefd8,
	0x001a, 0xd7f2, 0x001a, 0xf8ca, 0xefda, 0x001a, 0x001a, 0xd4d6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcdd9, 0x001a,
	0x001a, 0x001a, 0xeed8, 0x001a, 0xc1f2, 0x001a, 0x001a, 0x001a,
	0xd3df, 0x001a, 0x001a, 0x001a, 0xf0da, 0x001a, 0xeae2, 0x001a,
	0x001a, 0xfde0, 0x001a, 0x001a, 0xf8d8, 0x001a, 0x001a, 0x001a,
	0xaff7, 0xb6da, 0x001a, 0xd7ca, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd8f2, 0x001a,
	0xf9d8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdffa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xefcf,
	0xc2d9, 0x001a, 0xd2f0, 0x001a, 0xd1e4, 0x001a, 0x001a, 0x001a,
	0xb7f3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe0fa, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xecef, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb2e2, 0x001a, 0xbdd4, 0x001a, 0x001a, 0xced9, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe2f4, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa9d4, 0x001a, 0x001a, 0x001a, 0x001a, 0xc2cd, 0xdae7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd9f2, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaad9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbed8, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaddc, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xebe2, 0xfcd6, 0x001a, 0x001a,
	0xf9ca, 0x001a, 0x001a, 0xdad4, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd7f4, 0xa1cc, 0x001a, 0x001a, 0xbacf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb8f5,
	0x001a, 0x001a, 0x001a, 0xc3d9, 0xe8d0, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc5e3, 0xf8eb, 0x001a, 0xb1f2, 0x001a, 0x001a,
	0x001a, 0xbbcf, 0x001a, 0x001a, 0x001a, 0xadd3, 0xe1e8, 0xecce,
	0x001a, 0x001a, 0x001a, 0xb4e0, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe3de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf7dd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2f2, 0xf6f3, 0xdbf6,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfed7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xdff8, 0x001a, 0xf2f7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9d0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdae6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6f5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xbcd7, 0xe3cc, 0x001a, 0x001a, 0xdbe6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdddd, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb3d1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xedef,
	0x001a, 0x001a, 0x001a, 0x001a, 0xded6, 0xf4e4, 0xefe1, 0x001a,
	0x001a, 0xf8dd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcfe8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe5ca, 0x001a, 0x001a, 0x001a, 0xa1dc,
	0x001a, 0xb5e0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xacfc, 0xadfc, 0xa7d8, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb8ed, 0x001a, 0x001a, 0x001a, 0xb6db, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf0d6, 0xaff3, 0x001a, 0x001a, 0xa5cd, 0x001a,
	0xf1da, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa8d8, 0x001a, 0x001a, 0x001a, 0xe4cc, 0x001a, 0x001a, 0xb4d1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd8ca, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf2da, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa7f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8f5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6e6, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xecd5, 0xf8d5, 0xf3da, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc6e3, 0x001a, 0x001a, 0x001a, 0xe4de, 0x001a,
	0xe5de, 0xb5d1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6d1,
	0xb7d1, 0xb3f2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdee9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd3f0, 0xb4f2,
	0x001a, 0x001a, 0xd4f0, 0xe4cb, 0xd4fb, 0xe6f5, 0xeae3, 0x001a,
	0xe6de, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4df, 0x001a, 0x001a,
	0xf9f8, 0x001a, 0x001a, 0x001a, 0x001a, 0xaef0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb8d1, 0x001a, 0x001a, 0x001a, 0x001a, 0xdfd6,
	0x001a, 0xd7d0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa1fc, 0xeeef, 0xd8dc,
	0x001a, 0xdfe9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdde5, 0xfbfd,
	0x001a, 0x001a, 0xc9e0, 0x001a, 0x001a, 0x001a, 0xc9d6, 0x001a,
	0x001a, 0xaad4, 0x001a, 0xcce5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe0e9, 0x001a, 0x001a, 0x001a, 0xd8d0, 0xa2fc, 0xbed4,
	0xb3e2, 0xe7de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbcdc, 0xb6d2, 0xd5f5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa1ce, 0xa9f5, 0x001a, 0x001a, 0xf9dd, 0x001a, 0x001a,
	0xfadd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5f0,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdff6, 0x001a, 0xdaf2, 0xebe4,
	0x001a, 0xf1f2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb9ec, 0x001a, 0x001a, 0x001a, 0x001a,
	0xfcfd, 0x001a, 0x001a, 0x001a, 0x001a, 0xaae1, 0x001a, 0x001a,
	0xd9ca, 0x001a, 0x001a, 0xefef, 0x001a, 0xaaf5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf9ec, 0x001a, 0x001a, 0xadf8,
	0x001a, 0xc2f2, 0xc3f6, 0x001a, 0xd2d7, 0x001a, 0x001a, 0xa2f9,
	0xd6f0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfaf0, 0x001a,
	0x001a, 0xe0f6, 0x001a, 0x001a, 0x001a, 0x001a, 0xf3e9, 0xc3f2,
	0x001a, 0x001a, 0x001a, 0xabd4, 0xb3ca, 0xa6cd, 0x001a, 0xc3cd,
	0xdacd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcfd9, 0x001a,
	0x001a, 0xc4f6, 0x001a, 0x001a, 0x001a, 0xddee, 0xc4e7, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb4e2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe2df, 0xdbe7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb1e8, 0x001a, 0xaefc, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcde5, 0x001a, 0x001a, 0x001a, 0xebfa, 0x001a, 0xbccf, 0x001a,
	0x001a, 0xe2cf, 0xf6cd, 0x001a, 0x001a, 0xf0ef, 0x001a, 0xbef4,
	0x001a, 0xcdd4, 0x001a, 0x001a, 0xb8f3, 0x001a, 0x001a, 0x001a,
	0xa1e9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf2f2, 0xebf3, 0x001a, 0xd7f0, 0x001a, 0x001a,
	0xd7cf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdfcf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc0e8, 0xc1e8, 0x001a, 0x001a, 0x001a, 0xe3cf, 0xa2e9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaad0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc1f3, 0xabd0, 0x001a, 0xe4d4,
	0x001a, 0x001a, 0xbcef, 0xa1d8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdfd9,
	0x001a, 0xd7f3, 0x001a, 0x001a, 0x001a, 0xbddc, 0x001a, 0xe5cc,
	0xf1ed, 0x001a, 0x001a, 0xe2f1, 0x001a, 0xdbd4, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb5e2, 0x001a, 0x001a, 0xe6ca, 0x001a, 0xaed3,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe6cc, 0x001a,
	0x001a, 0xd3f1, 0xe7f5, 0x001a, 0x001a, 0x001a, 0x001a, 0xdaca,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeefb,
	0x001a, 0xc5e1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe9df, 0x001a, 0xdeee, 0x001a, 0x001a, 0xc2f7, 0x001a,
	0xa2d8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xacdd, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xaff0, 0xbdd6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xabe1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6f9, 0x001a,
	0x001a, 0xf5d4, 0x001a, 0xc9d0, 0xa7ef, 0xece2, 0x001a, 0xeadb,
	0xccce, 0xe8f5, 0xd5f7, 0x001a, 0xcdd3, 0x001a, 0xfef3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb5d0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfee0, 0x001a, 0xfbdf, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdde6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4e8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcdcb,
	0x001a, 0x001a, 0x001a, 0xa8ef, 0x001a, 0x001a, 0x001a, 0xb4ee,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd8da, 0xb9d1, 0x001a, 0xa9df,
	0x001a, 0x001a, 0xb0f3, 0x001a, 0x001a, 0xc4cc, 0x001a, 0x001a,
	0x001a, 0xb7ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9ef, 0x001a, 0x001a,
	0x001a, 0xd5df, 0x001a, 0x001a, 0xd7ed, 0x001a, 0x001a, 0x001a,
	0xc6ee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbdef, 0xd6fc, 0x001a, 0x001a, 0xf4db, 0x001a, 0xaaef, 0xb9f8,
	0x001a, 0xe9f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd9e3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc6e1, 0x001a, 0x001a, 0x001a, 0xbfd4, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe8de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeaf0,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc2f3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xafd3, 0x001a,
	0x001a, 0xdbca, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd7fc,
	0x001a, 0x001a, 0xd8ed, 0xc7e1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd8f4, 0xb3d6, 0xaddd,
	0x001a, 0x001a, 0x001a, 0xbed5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc3f1, 0xdfee, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xebd6, 0x001a, 0x001a, 0x001a, 0xd9f4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe6d7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb7da, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfbdd, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcfdd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa3d8, 0x001a, 0x001a, 0xd9da, 0x001a, 0xd8f0,
	0xc4ef, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd8e1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4f1, 0x001a, 0xf2ed,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdbd5, 0x001a,
	0x001a, 0xdcd5, 0xc4f3, 0xd7cb, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb6e2, 0x001a, 0x001a, 0x001a, 0x001a, 0xf1ef, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd5fb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd8d3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd0dd, 0xd9f0,
	0xb3cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xddd5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa7cd, 0x001a, 0x001a, 0xacd0, 0x001a,
	0xbad1, 0x001a, 0xc4f1, 0x001a, 0xb3e5, 0xf5fb, 0xe1e9, 0xe0fd,
	0xbcfc, 0x001a, 0xa2da, 0xa3da, 0x001a, 0xa1d2, 0x001a, 0x001a,
	0xefd2, 0x001a, 0x001a, 0x001a, 0xede2, 0x001a, 0x001a, 0xe9de,
	0xdcce, 0xb5f2, 0xe4d0, 0xd1dd, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc8e1, 0xb7db, 0xe3df, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb9ed, 0xc5f1, 0x001a, 0xcff3, 0xabd7,
	0xace1, 0x001a, 0x001a, 0xebe3, 0x001a, 0xc7ee, 0x001a, 0x001a,
	0x001a, 0xc9e1, 0xfaca, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfbf0, 0xe1fa, 0xdaf0, 0xe7cc, 0xf4da, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbfcc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xedce, 0x001a,
	0x001a, 0xa9d5, 0xe2fa, 0x001a, 0x001a, 0x001a, 0xe5d0, 0x001a,
	0xd6eb, 0x001a, 0xdfec, 0x001a, 0x001a, 0x001a, 0xfcdf, 0x001a,
	0x001a, 0xd6f7, 0xeade, 0xb4cb, 0x001a, 0x001a, 0xbeef, 0x001a,
	0x001a, 0xb5cc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbdcf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf2ef, 0xb7e2,
	0x001a, 0x001a, 0x001a, 0xe8cc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfcf0, 0x001a, 0x001a, 0x001a,
	0xe0d6, 0x001a, 0xc6f1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb8e2, 0xabeb, 0x001a, 0x001a,
	0x001a, 0xb5cb, 0xd1d8, 0x001a, 0xcef4, 0xf7f3, 0x001a, 0x001a,
	0xc6d7, 0x001a, 0xbbd1, 0xaaf7, 0x001a, 0xcaed, 0xd3d7, 0xfad8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc5f6,
	0x001a, 0x001a, 0xccd1, 0xfcdd, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfddf, 0x001a,
	0xe5f9, 0x001a, 0xcae0, 0x001a, 0x001a, 0xfdf2, 0xb0d3, 0x001a,
	0xf3f4, 0xc9da, 0x001a, 0xdee6, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbaf8, 0xd0e8, 0x001a, 0x001a, 0xfbd8, 0x001a, 0x001a, 0xd5ea,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa3d6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc6f6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdbf2, 0xfce4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2e8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdada, 0x001a, 0xdcf2, 0xd6fb, 0xb2e9,
	0x001a, 0xadee, 0x001a, 0xe3fa, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xeedc, 0x001a, 0x001a, 0xeaf5, 0xe0e6,
	0x001a, 0xfdf0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xacd7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc5f5, 0xe0ee, 0x001a,
	0x001a, 0xe5db, 0x001a, 0xdedd, 0x001a, 0x001a, 0xf0d9, 0xa3e9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf9f1, 0x001a, 0xc4f2, 0xcbe0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4e9, 0x001a,
	0x001a, 0xb9e2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb1e3, 0xebfc, 0xa8cd, 0x001a, 0xb6cc, 0x001a, 0x001a,
	0xdbf0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbae6, 0x001a, 0x001a, 0xa9cd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc3f3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd9e1, 0x001a, 0x001a, 0xabef,
	0x001a, 0x001a, 0x001a, 0xc5e7, 0x001a, 0x001a, 0xe9e0, 0x001a,
	0xc5f3, 0x001a, 0x001a, 0xc0d4, 0xbfd5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaedd, 0x001a,
	0xfcf9, 0x001a, 0xc0cc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa2e5, 0x001a, 0x001a, 0x001a,
	0xb8ce, 0x001a, 0x001a, 0x001a, 0xd2d8, 0xd6f9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaaf1, 0xd1ce, 0x001a, 0x001a, 0xc7f6, 0x001a,
	0xebdb, 0x001a, 0xfedf, 0x001a, 0x001a, 0xe1d8, 0x001a, 0xf3f7,
	0x001a, 0xe7d7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfed4, 0x001a, 0x001a,
	0xbcd1, 0x001a, 0xcfe5, 0x001a, 0xb6cb, 0x001a, 0xb8da, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc4cd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbed6, 0x001a, 0x001a, 0x001a, 0xbae2, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd8cf, 0x001a, 0x001a, 0x001a,
	0xcce0, 0xf9eb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfdfd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe8d7, 0xd8cb, 0x001a, 0x001a, 0x001a, 0xe2e9, 0x001a, 0x001a,
	0x001a, 0xbae8, 0x001a, 0x001a, 0x001a, 0xc7e3, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcdec, 0x001a, 0xceec, 0x001a, 0xbfd6, 0x001a,
	0x001a, 0x001a, 0xa7e3, 0x001a, 0xd6df, 0xe8fd, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe1ee,
	0xa8f6, 0xfddd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbbf8, 0x001a, 0xd1e8, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd7f9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xeece, 0x001a, 0x001a, 0xcfec, 0x001a, 0x001a, 0x001a,
	0xa5e9, 0xd5d6, 0x001a, 0xc5cd, 0x001a, 0xbaed, 0xbdd1, 0x001a,
	0x001a, 0xbecf, 0x001a, 0x001a, 0xbbec, 0x001a, 0x001a, 0x001a,
	0xb1d2, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9cc, 0x001a, 0xc4d9,
	0xfce9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbed1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xbcec, 0x001a, 0x001a, 0xade5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb0f7, 0x001a, 0xeacc,
	0x001a, 0x001a, 0x001a, 0xc4d3, 0x001a, 0x001a, 0xc0d6, 0x001a,
	0x001a, 0x001a, 0xfdd6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa1e1, 0x001a,
	0xbdde, 0x001a, 0xa9f6, 0x001a, 0x001a, 0x001a, 0xa4da, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4d6,
	0xc6f5, 0x001a, 0xa2e1, 0xc6e9, 0x001a, 0x001a, 0x001a, 0xc5f2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9f4, 0xecd6, 0xd3eb,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbdec, 0xdce2, 0xebde, 0xdcf0,
	0x001a, 0xbfeb, 0x001a, 0xced7, 0xbfd1, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xabf5, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfdf9, 0x001a, 0xdcca, 0x001a, 0x001a,
	0x001a, 0xc6cd, 0xb6f2, 0x001a, 0x001a, 0xfedd, 0x001a, 0x001a,
	0x001a, 0xb7cc, 0xb8db, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9d0,
	0x001a, 0xddce, 0xc0eb, 0x001a, 0xa2fd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcbf8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd6ea, 0xb0f1, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcedb, 0x001a, 0xc3f7, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcfdb, 0xa4cb, 0x001a, 0x001a, 0xe0f8, 0x001a,
	0x001a, 0xd7fb, 0x001a, 0x001a, 0xcaeb, 0xa1e0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcdce, 0x001a, 0x001a, 0xdcd4, 0x001a, 0x001a, 0x001a,
	0xd8fd, 0x001a, 0x001a, 0x001a, 0x001a, 0xf6d2, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb7f2, 0x001a, 0x001a, 0xf6fa, 0xaaf6, 0xf7fa,
	0xe6d8, 0x001a, 0xb1f4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd2e8, 0x001a, 0xc5ca, 0xebcc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xeee2, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbbe2, 0x001a, 0xadf7, 0x001a, 0x001a, 0x001a, 0xe1f8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xecf3, 0x001a, 0x001a, 0x001a, 0x001a, 0xa1de, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfde4, 0x001a, 0x001a, 0xece3, 0x001a,
	0xafdd, 0xb0dd, 0x001a, 0x001a, 0xb7cb, 0xd3e8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3e1, 0xe0d2, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfef0, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa6e9, 0xf2cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf3ed, 0xd9dc, 0xcde0, 0x001a, 0x001a, 0x001a, 0x001a, 0xdaf7,
	0xb9db, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaecc, 0x001a, 0xdbda, 0x001a, 0x001a, 0x001a, 0x001a, 0xc7cd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb1dd, 0x001a, 0xafd8, 0xa3e3, 0x001a, 0x001a,
	0xefce, 0x001a, 0x001a, 0xf3f2, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb3f8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcee0, 0x001a, 0xfdf5, 0x001a, 0x001a,
	0x001a, 0x001a, 0xeceb, 0x001a, 0x001a, 0xc5d3, 0xecfc, 0xdbd2,
	0xebd4, 0x001a, 0xa2de, 0x001a, 0x001a, 0x001a, 0xe6e5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb0f0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc4d5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf4ed,
	0x001a, 0x001a, 0x001a, 0xede3, 0x001a, 0xc2e8, 0x001a, 0xf5ed,
	0xfcd7, 0x001a, 0xbbed, 0x001a, 0x001a, 0xabf6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb8f2, 0xc8f6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe6d3, 0xddf2, 0xbfcf, 0x001a, 0xaceb, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc0cf, 0x001a, 0xa8e6,
	0xe9fd, 0x001a, 0xc1cf, 0x001a, 0xdfe0, 0xecde, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa2e0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xbff4, 0xefe2, 0x001a, 0xf1d9, 0xc7f1,
	0x001a, 0xb8cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfef9, 0xbadb, 0xf5da, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xecf6, 0xdcda, 0xe4fa,
	0x001a, 0xcfe0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb2dd, 0x001a, 0x001a, 0x001a, 0x001a, 0xa9e6, 0x001a, 0xf3ef,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xedf3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfaeb, 0x001a, 0xe6f9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xddca, 0xded5,
	0x001a, 0xdeca, 0xe4df, 0x001a, 0x001a, 0x001a, 0xfde6, 0x001a,
	0xacf5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf5e4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe3e9, 0x001a, 0xcbed, 0xe4cf, 0x001a,
	0x001a, 0x001a, 0xd3d8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb3dd, 0xecd4, 0x001a, 0x001a, 0xb9f2, 0x001a, 0xb7df,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcecb, 0xd8fb, 0x001a,
	0x001a, 0xd9d0, 0x001a, 0x001a, 0xd2dd, 0xf4f7, 0xdce7, 0xa5e4,
	0x001a, 0xa3fc, 0x001a, 0xbbdb, 0x001a, 0x001a, 0x001a, 0xbaf2,
	0xfde9, 0xcad0, 0x001a, 0xd6f5, 0xc5d9, 0xb4e4, 0x001a, 0xa7ed,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbdea, 0xfee6, 0x001a, 0xc4f7, 0xadf5, 0x001a, 0xe0d9,
	0x001a, 0x001a, 0x001a, 0xb4ca, 0x001a, 0x001a, 0xe2f8, 0xc2cf,
	0x001a, 0xbeec, 0x001a, 0x001a, 0x001a, 0xb4e5, 0xc8cd, 0xc8ee,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc8e7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc9cd, 0xb7f9, 0x001a,
	0x001a, 0xe8f1, 0xf2d9, 0xf5db, 0xb5ca, 0xc6d9, 0x001a, 0x001a,
	0x001a, 0xc9d8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xabd9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbced, 0x001a, 0x001a, 0xd4d8, 0x001a, 0x001a, 0x001a, 0xdadc,
	0x001a, 0xbce2, 0x001a, 0x001a, 0xedfc, 0xe0ec, 0xfed2, 0x001a,
	0xc7e9, 0xaae6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf0e2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbbfa,
	0x001a, 0xaef5, 0xaafb, 0x001a, 0x001a, 0x001a, 0x001a, 0xfbec,
	0x001a, 0xbfec, 0xd8fc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe5d4, 0x001a, 0x001a, 0x001a, 0xc3f9,
	0x001a, 0x001a, 0x001a, 0xe2ee, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe9d7, 0xf6ed, 0x001a, 0x001a, 0x001a, 0xedde, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeccc, 0x001a,
	0xeee3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd4e8, 0x001a,
	0x001a, 0x001a, 0xf8fa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb4dd, 0xb5e4, 0xb0d8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5d8, 0x001a, 0x001a,
	0x001a, 0xeaf4, 0x001a, 0x001a, 0x001a, 0xb9ce, 0x001a, 0x001a,
	0x001a, 0xe1d6, 0xd2cf, 0x001a, 0xb6d0, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa2ce, 0x001a, 0x001a, 0xeef3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf8f3, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xccdc, 0x001a, 0xcbd0, 0x001a, 0x001a, 0x001a, 0xa4fc,
	0xcacd, 0xd4d7, 0xa3de, 0x001a, 0xe0e4, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc9ee, 0x001a, 0x001a, 0x001a, 0xdde2, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfef5, 0xacd4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd1d5, 0x001a, 0xf0d8, 0xc3f8, 0xd7ea, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd7f5, 0x001a, 0x001a, 0xbfd8, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc0fd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xadeb, 0x001a, 0x001a, 0x001a, 0x001a, 0xaad5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa8e7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcaee,
	0x001a, 0x001a, 0x001a, 0xe7ca, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe3f8, 0x001a, 0xddd4, 0x001a, 0x001a, 0xd8ea, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd9fb, 0xf7ed, 0x001a, 0x001a, 0xb5e5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xadd0, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf1f1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbde2, 0x001a, 0x001a, 0x001a, 0xc8e3, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd5d9, 0x001a, 0x001a, 0xaadf, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbcdb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe4f8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xfaf1, 0x001a, 0x001a, 0xb6e5, 0xeff3, 0x001a, 0x001a, 0xdafb,
	0xe0e1, 0x001a, 0xacd9, 0x001a, 0xebf5, 0x001a, 0xb6e0, 0x001a,
	0x001a, 0xc8e9, 0x001a, 0xcfcb, 0x001a, 0xc9e3, 0x001a, 0x001a,
	0x001a, 0xeede, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbee2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xefdc, 0x001a, 0xa5d6, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf1e2, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfed6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa1d9, 0x001a, 0xc0d8, 0xdbdc, 0x001a, 0x001a, 0xbded,
	0xb8df, 0x001a, 0xa5ea, 0x001a, 0x001a, 0x001a, 0xadd7, 0x001a,
	0x001a, 0xf9f3, 0x001a, 0xf8ed, 0x001a, 0xc7f5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcae1, 0xe3eb, 0x001a, 0xdef2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xccf8, 0x001a, 0xd9ea,
	0x001a, 0xc6d3, 0x001a, 0xe6db, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaff5, 0x001a, 0x001a, 0x001a, 0x001a, 0xf0ce, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfee9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb6fb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf2e2, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf2cf, 0xb9f7, 0xf3d9, 0x001a, 0x001a, 0xcbe1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xddda, 0x001a, 0x001a, 0xb9da,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfbeb,
	0x001a, 0xb9cb, 0x001a, 0x001a, 0xf9ed, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe0e0, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc0f4, 0x001a,
	0xbcfd, 0xb1df, 0xefe3, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3e0,
	0xb9fd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb1f0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcbcd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbeed, 0x001a, 0x001a, 0x001a, 0xc0d5, 0xf0e3, 0xfaed,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe4e9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xedd5, 0xdde7, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf6d4, 0xb7e5, 0x001a, 0x001a,
	0x001a, 0xe7db, 0xbfe2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbee,
	0x001a, 0x001a, 0xf4d7, 0xddf0, 0x001a, 0x001a, 0x001a, 0xabce,
	0x001a, 0x001a, 0xdee7, 0x001a, 0x001a, 0x001a, 0xd6d6, 0xcce1,
	0x001a, 0x001a, 0xb3e8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeee5, 0xa2dc,
	0x001a, 0x001a, 0xd0e0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb5d5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa1d5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdbfb, 0x001a,
	0xcbf9, 0x001a, 0x001a, 0x001a, 0xf3cb, 0xa5f4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc8fa, 0xd7d6, 0x001a, 0xe5e9, 0xdcfb,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd0fd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf6fb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa5da, 0x001a, 0xbddb, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe2ec, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf7cd, 0xdef0, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc9f6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xefde,
	0x001a, 0x001a, 0x001a, 0xb1d3, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xeefc, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc3e8, 0x001a, 0xc8f1, 0x001a, 0x001a, 0x001a, 0xf1ce,
	0x001a, 0x001a, 0x001a, 0x001a, 0xedf9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf4f2, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6e4, 0x001a,
	0xb9f5, 0x001a, 0xf0dc, 0xf1e3, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa5e8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbbf2, 0x001a, 0xa4de, 0x001a, 0xccda, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9ca, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdae3, 0x001a, 0xd9fc,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdaea,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc4f9, 0x001a,
	0xa4e3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xddfb, 0x001a, 0xcaef, 0x001a,
	0xc4e8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xccd5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd7eb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xadd9,
	0x001a, 0x001a, 0xabfb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd9d3, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa2d5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdef6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf6da, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd1e0, 0x001a, 0x001a, 0xa8e9,
	0x001a, 0x001a, 0xf9f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaffa, 0x001a, 0xfceb, 0x001a, 0x001a, 0xeae0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2e3, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc5d5,
	0x001a, 0x001a, 0xe3f1, 0xeed5, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcccd, 0x001a, 0x001a, 0x001a, 0x001a, 0xd9ed, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc1d8, 0x001a, 0x001a, 0x001a, 0x001a,
	0xecfa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xebf1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbcfa, 0xe2e6, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe5fa, 0xfae2, 0x001a, 0x001a, 0x001a, 0xb6ca,
	0x001a, 0xb7e4, 0x001a, 0xdbea, 0x001a, 0xfaf5, 0x001a, 0x001a,
	0x001a, 0xacfb, 0xc3cf, 0xfdeb, 0x001a, 0x001a, 0x001a, 0x001a,
	0xfaf8, 0x001a, 0x001a, 0xb9df, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf1e1, 0x001a, 0xa4d2, 0x001a, 0x001a, 0x001a, 0x001a, 0xfbf5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdad0, 0xdbd0,
	0x001a, 0xbeea, 0xb1d9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb7ca, 0x001a, 0x001a, 0xe7d3, 0x001a, 0xe5f8, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb2d3, 0x001a, 0x001a, 0x001a, 0xc0e2, 0xdff2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe5cd, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xacf9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcdcd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaeee, 0xaed6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xead7,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe0e7, 0xaeeb, 0x001a, 0x001a,
	0x001a, 0xd9cf, 0x001a, 0x001a, 0xcddc, 0xfbed, 0x001a, 0xf0de,
	0x001a, 0xebd7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa5de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd7df, 0xd0db, 0xd1db, 0x001a, 0x001a,
	0xa3d5, 0x001a, 0x001a, 0x001a, 0x001a, 0xb2f0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdcdc,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe8ca, 0x001a, 0xe6f8, 0xcedc, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdcea, 0xd2db, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb3e9, 0x001a, 0x001a,
	0x001a, 0x001a, 0xdbf7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8e3, 0x001a,
	0xaed7, 0x001a, 0x001a, 0xe1e0, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbacb, 0x001a, 0x001a, 0xd1e5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdcd0,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc1d5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcad8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa9e3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4e0,
	0x001a, 0xa9e9, 0x001a, 0xc7d3, 0x001a, 0x001a, 0xdddc, 0xaef8,
	0x001a, 0x001a, 0x001a, 0xb8cc, 0x001a, 0x001a, 0x001a, 0xaed0,
	0x001a, 0x001a, 0x001a, 0xf2d8, 0x001a, 0x001a, 0xcae3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xafcc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xadd4, 0xd1f6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xccd0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc6ca, 0x001a, 0x001a, 0xc2d5, 0x001a, 0x001a,
	0xbace, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc7ca, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb0fa, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd8df, 0x001a, 0x001a, 0x001a,
	0xbaf5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xebe5, 0x001a, 0xf4ef, 0xb5dd, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaacd, 0x001a, 0xf2e3, 0x001a, 0xf7fb, 0x001a, 0xd0f7, 0x001a,
	0x001a, 0x001a, 0x001a, 0xbafd, 0x001a, 0x001a, 0xe1fd, 0xfef6,
	0xc0d1, 0x001a, 0x001a, 0xc5e8, 0x001a, 0xb8e4, 0x001a, 0xe8e1,
	0x001a, 0x001a, 0x001a, 0xc1cc, 0x001a, 0xedd2, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbedb, 0x001a, 0x001a, 0xe2e0, 0x001a, 0x001a,
	0x001a, 0xc9fa, 0x001a, 0x001a, 0xcde1, 0x001a, 0xb8ca, 0x001a,
	0x001a, 0x001a, 0xe0f2, 0xc9f1, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf1de, 0x001a, 0x001a, 0x001a, 0xdff0, 0xc4f8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xccee, 0x001a, 0x001a, 0xf2de, 0x001a,
	0xc9e7, 0x001a, 0xf3e2, 0xe1e7, 0x001a, 0x001a, 0xcbe3, 0x001a,
	0x001a, 0xcce3, 0x001a, 0x001a, 0x001a, 0xf8cf, 0xacef, 0x001a,
	0xfefd, 0xa5fc, 0xb1fa, 0xd9df, 0x001a, 0xd2e0, 0x001a, 0x001a,
	0x001a, 0xdaf4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcaf1, 0x001a, 0xa3ce,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbcf2, 0xe3ec, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa5e0, 0x001a, 0xabf7, 0x001a, 0x001a,
	0xafeb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdee5, 0x001a,
	0xa4e1, 0xabcd, 0x001a, 0xf4d9, 0xa6e8, 0xcecd, 0xe9e1, 0x001a,
	0xeffc, 0x001a, 0xe3e0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc1e2, 0x001a, 0xa4ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa6de, 0x001a, 0x001a, 0xfeeb, 0x001a, 0xddeb, 0xe0f0,
	0x001a, 0x001a, 0xdbf4, 0x001a, 0xf4e2, 0x001a, 0x001a, 0xc8d3,
	0x001a, 0x001a, 0x001a, 0xebf4, 0x001a, 0xb5ee, 0x001a, 0xd8f5,
	0x001a, 0x001a, 0xdfd5, 0x001a, 0x001a, 0x001a, 0xe5d6, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb0eb, 0xe3f4, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcde3, 0x001a, 0x001a, 0x001a, 0x001a, 0xf4f4, 0xb2fa,
	0x001a, 0x001a, 0xf5ef, 0xdfca, 0x001a, 0xb1eb, 0xbfed, 0x001a,
	0x001a, 0xc9fd, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6e4, 0xa4f9,
	0xb3f0, 0x001a, 0xece5, 0x001a, 0x001a, 0x001a, 0xe7d1, 0x001a,
	0xc7d9, 0xd7e4, 0xddea, 0x001a, 0xf7d4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbada, 0x001a,
	0xcdda, 0x001a, 0x001a, 0x001a, 0xccf9, 0x001a, 0xdae1, 0xbfdb,
	0x001a, 0xc5cc, 0xd0ec, 0xbbcb, 0x001a, 0xf3de, 0x001a, 0x001a,
	0xaae9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc8d9, 0x001a, 0x001a, 0xe3ee, 0xbdd7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc4cf, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcdd0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa6fc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfbf1, 0x001a, 0x001a, 0x001a, 0x001a, 0xd2fd, 0xc1d1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdbe3, 0x001a, 0xc9d3, 0x001a, 0xcfdc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xedcc, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa7de, 0x001a, 0x001a, 0xbbe6,
	0xa1ec, 0x001a, 0x001a, 0x001a, 0xb9cc, 0x001a, 0x001a, 0xdefb,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe2e7, 0x001a, 0x001a,
	0xc1d4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa8dc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc2e2, 0x001a, 0xd8f3, 0xd3e5, 0x001a, 0x001a, 0xd9f3, 0x001a,
	0x001a, 0x001a, 0xc6f3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdbcd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaccd,
	0x001a, 0xc3fc, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7d4, 0x001a,
	0xc2d1, 0x001a, 0xa5f9, 0x001a, 0xd5e8, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcee3, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcad4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdadf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xdffb, 0xe3e7, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfbf8, 0xcfe3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb0f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe7d8, 0x001a, 0xc9d9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xaff8, 0xf6ef, 0x001a,
	0xb6dd, 0xafee, 0xf8cd, 0x001a, 0x001a, 0x001a, 0x001a, 0xb8de,
	0xa7fc, 0xfcf7, 0xb1f7, 0xbbce, 0xa1f4, 0x001a, 0x001a, 0xcdee,
	0xaee1, 0x001a, 0x001a, 0xc3ec, 0xfecf, 0x001a, 0xbff8, 0xe2d8,
	0xe8d3, 0x001a, 0x001a, 0xa8de, 0xe4f4, 0xc2ec, 0x001a, 0xf5d9,
	0xc5f9, 0xd3dd, 0xf1d6, 0xfcec, 0xf0fc, 0x001a, 0x001a, 0xc0ed,
	0xb9ca, 0x001a, 0xe4ee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe1f2, 0x001a, 0xb9de, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf2d6, 0x001a, 0xf4de, 0x001a, 0xdbdf, 0x001a,
	0xd3db, 0x001a, 0xe7fa, 0xe3d8, 0xc1f4, 0x001a, 0xb7dd, 0x001a,
	0x001a, 0x001a, 0xf5f2, 0x001a, 0x001a, 0xaed4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf3d6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb8dd, 0xc5cf, 0xdfdf, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbef2, 0xa1f6, 0x001a, 0xcbeb,
	0xfcf1, 0x001a, 0xc7f3, 0x001a, 0x001a, 0xebe0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xfced, 0x001a, 0x001a, 0xdbe1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe5ee, 0x001a, 0xf5de, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd3fa, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcbf1, 0x001a, 0x001a, 0xafd0, 0xb9dd, 0x001a, 0x001a, 0xc3d1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb1f5, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc6ea, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe1f0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xacf6, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd9f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xebf0, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbadd, 0x001a, 0x001a, 0x001a, 0xbff2, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc5f7, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa2db, 0xf6f2, 0x001a, 0x001a, 0xbaca,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf5f7, 0x001a, 0xe5cb, 0x001a, 0x001a,
	0x001a, 0xe6ee, 0x001a, 0xd3e0, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa5ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd8d6,
	0x001a, 0x001a, 0x001a, 0xafd4, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc9e9, 0x001a, 0x001a, 0x001a, 0x001a, 0xced3,
	0xc2f4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe6cb, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa1f1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb2eb, 0x001a, 0x001a, 0x001a, 0x001a, 0xa2f1, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb3eb, 0x001a, 0xb4f0, 0x001a, 0x001a, 0xf4cb,
	0xb0d4, 0xb2f3, 0xb7fb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xecf5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7ee,
	0xb2f4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xedf5, 0x001a, 0xf3cf, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe2f0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xceee,
	0x001a, 0x001a, 0xccf1, 0x001a, 0x001a, 0xb8e5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf5d7, 0xf3e3, 0xe5cf, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc6cf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb3f3, 0xd8e4, 0xf9cf, 0xdacf, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcdfa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe3e6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe2f2, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xeef5, 0x001a, 0x001a, 0xbbca, 0x001a, 0x001a, 0xdce3, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf2ce, 0x001a, 0xd9d6, 0x001a, 0x001a,
	0x001a, 0xb0ee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe5f4, 0xc2d8, 0xd0dc, 0xeecc, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe0d5, 0xcaf6, 0xcafd, 0xd6d8, 0xcff4,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa6d6, 0xbedc,
	0x001a, 0xd4db, 0xc7d7, 0x001a, 0x001a, 0x001a, 0x001a, 0xfef2,
	0x001a, 0x001a, 0x001a, 0xcdf1, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc3e2, 0xdedc, 0x001a, 0xdfdc, 0x001a, 0x001a, 0xadef, 0xabe6,
	0x001a, 0x001a, 0x001a, 0x001a, 0xddf9, 0xbfea, 0x001a, 0x001a,
	0x001a, 0xaeef, 0x001a, 0x001a, 0x001a, 0xd0f4, 0xf3ce, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xace6, 0x001a, 0xdece,
	0x001a, 0x001a, 0xf9d5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf4e3, 0xd0cd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb8d5, 0x001a, 0x001a, 0xfdf7, 0x001a,
	0xa9dc, 0x001a, 0x001a, 0x001a, 0x001a, 0xf6de, 0x001a, 0xaadc,
	0xe3f2, 0xb4e9, 0xdcd2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe6e9, 0x001a, 0x001a, 0xf6e3, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcae7, 0x001a,
	0x001a, 0xced0, 0x001a, 0x001a, 0xf7da, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbcca, 0x001a,
	0x001a, 0x001a, 0xe8ee, 0xdeda, 0x001a, 0xf7f2, 0x001a, 0x001a,
	0xfbe2, 0x001a, 0xa6cc, 0x001a, 0x001a, 0x001a, 0x001a, 0xbbda,
	0x001a, 0xe9ee, 0x001a, 0x001a, 0x001a, 0xdaf5, 0x001a, 0x001a,
	0xdcf7, 0xeae1, 0xc1ce, 0xb1d4, 0x001a, 0xb1fd, 0xbde6, 0x001a,
	0xadfb, 0x001a, 0x001a, 0xe7f8, 0x001a, 0xcee1, 0x001a, 0xe2f7,
	0xeff5, 0xc7cf, 0x001a, 0x001a, 0xb2d4, 0xefcc, 0x001a, 0xe8d4,
	0x001a, 0xcfee, 0xd7f7, 0x001a, 0x001a, 0xa6e0, 0xc1d6, 0xdce1,
	0xe3f0, 0xe4f1, 0xf1dc, 0xa7d6, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf5f4, 0x001a,
	0x001a, 0xcef1, 0xe4f2, 0x001a, 0x001a, 0xb0d0, 0x001a, 0x001a,
	0xefec, 0x001a, 0x001a, 0x001a, 0xbaf9, 0x001a, 0xb5eb, 0x001a,
	0x001a, 0xedd4, 0xc4e2, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7e9,
	0x001a, 0x001a, 0xb4eb, 0xa1ea, 0x001a, 0xbcf8, 0xa6ce, 0x001a,
	0xc6f9, 0xdafc, 0x001a, 0xb3d4, 0xb9d3, 0xdeea, 0x001a, 0x001a,
	0x001a, 0xabe9, 0x001a, 0x001a, 0xe1e1, 0xcfd3, 0xf6f4, 0x001a,
	0xc0ea, 0xcfe1, 0x001a, 0xbacc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xeaee, 0x001a, 0x001a, 0x001a, 0xe4f0, 0xb4f3, 0xeed4,
	0x001a, 0x001a, 0xc0f2, 0x001a, 0x001a, 0xe5f1, 0x001a, 0xc3f4,
	0xd4e0, 0x001a, 0xb6eb, 0x001a, 0xa1d7, 0xe8cb, 0x001a, 0xadf9,
	0xade9, 0xe4d8, 0xb3fa, 0xc5e2, 0xbdfc, 0x001a, 0x001a, 0xc4ec,
	0xb1d8, 0x001a, 0xabdc, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4d5,
	0x001a, 0xe9eb, 0x001a, 0x001a, 0x001a, 0xbbe8, 0x001a, 0x001a,
	0x001a, 0xd7d8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaefb, 0xe1d1, 0x001a, 0x001a, 0xc0db, 0x001a,
	0xbef5, 0x001a, 0xf7de, 0x001a, 0x001a, 0x001a, 0x001a, 0xfbca,
	0xc6f7, 0xc8cf, 0x001a, 0x001a, 0x001a, 0xd0e1, 0x001a, 0x001a,
	0xd0ee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf4e9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xf4ce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcdd5, 0x001a,
	0x001a, 0xdbcf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbbdd, 0x001a, 0x001a, 0x001a, 0x001a, 0xacce, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe8e9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb4d4, 0x001a, 0x001a,
	0x001a, 0x001a, 0xc7e4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xdbf5, 0x001a, 0x001a, 0xc1fa, 0x001a, 0x001a,
	0x001a, 0xa9de, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf8d4,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf7ef, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb3d3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xb7eb, 0xf8ef, 0xdcf5, 0xcced, 0xd5db, 0xcff1, 0x001a,
	0x001a, 0x001a, 0xd0f1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xb2f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xaed9, 0xacd5, 0x001a, 0xc6e2, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3fd, 0x001a, 0xe5fb,
	0xabdf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf5e2,
	0x001a, 0xadf6, 0x001a, 0xb3f5, 0x001a, 0xb5f0, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa5e1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xddf5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa2ec, 0xfded, 0x001a, 0xb4f5, 0xb8fb,
	0x001a, 0xa3db, 0x001a, 0x001a, 0xcad6, 0xd9cb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd4e5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfaf3,
	0x001a, 0xb8eb, 0x001a, 0xb7e0, 0xecd7, 0xecf1, 0xafe5, 0xe1d5,
	0xedd7, 0xd1d1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf2e1,
	0xf9ef, 0x001a, 0x001a, 0x001a, 0xbcdd, 0xdcf6, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe5f0, 0x001a, 0x001a, 0x001a, 0xc4f4,
	0x001a, 0x001a, 0xe9e9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfbf3, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xefd4, 0x001a, 0x001a,
	0xa2cc, 0xfef7, 0xbcdf, 0x001a, 0x001a, 0x001a, 0x001a, 0xcdeb,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb7d0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc2d6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xade8, 0x001a, 0x001a, 0x001a, 0x001a, 0xafef,
	0xa5cb, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9cb, 0x001a, 0x001a,
	0x001a, 0xe8fa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc6cc,
	0x001a, 0x001a, 0x001a, 0xe7e6, 0x001a, 0x001a, 0xc7ea, 0x001a,
	0x001a, 0x001a, 0xa4db, 0x001a, 0xc9cf, 0xfce2, 0xfaef, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdeeb, 0x001a, 0x001a, 0xc8f5, 0x001a, 0xded4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd5e0, 0x001a, 0xb0ef, 0x001a, 0x001a, 0xc7e2, 0x001a,
	0xafd9, 0x001a, 0x001a, 0x001a, 0xe7f9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe5e7, 0x001a, 0x001a, 0xcacf, 0xd1e1,
	0x001a, 0xc8e2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfbef, 0x001a, 0x001a, 0xf9fa,
	0x001a, 0x001a, 0xf2dc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa7e0, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe8f8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xeacb, 0x001a, 0x001a, 0x001a, 0xbccb, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe2d6, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdef5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdff5, 0x001a, 0xb6ee, 0x001a, 0x001a, 0x001a, 0xf6e2, 0xcad3,
	0xfcef, 0xc4d1, 0xb1ef, 0x001a, 0xc5d1, 0x001a, 0xded0, 0x001a,
	0xe1d9, 0x001a, 0x001a, 0xb8e0, 0x001a, 0x001a, 0xd1cd, 0xb9f3,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcce7, 0x001a, 0xa8d6, 0xa7ce, 0x001a, 0xb5d4, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc8e4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb4d3, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb9eb, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf5cb, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xddf6, 0x001a, 0xa3f1, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc7cc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcae9, 0x001a, 0xf0e1, 0x001a,
	0x001a, 0x001a, 0xe0f5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xaffb, 0x001a, 0x001a, 0x001a, 0xd1cb,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe0fb, 0xe5f2, 0x001a, 0x001a,
	0xf0ec, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xecf0, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xebee, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbe9, 0x001a,
	0x001a, 0xf0cc, 0x001a, 0x001a, 0xafd7, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa1f3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf5fc, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa4f1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd6e0, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb2ef, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd1f4, 0x001a, 0x001a,
	0xa1f7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd1f1, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xfcca, 0xfdca, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcece, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc8f3, 0x001a, 0xbaf3,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfeed,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa6da, 0x001a, 0x001a, 0xece0, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xcdf8, 0x001a, 0xd2cb, 0x001a, 0x001a, 0x001a, 0xceeb,
	0x001a, 0xd8f9, 0xd9f9, 0xe0ca, 0xcada, 0x001a, 0x001a, 0x001a,
	0xa6cb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc8ca, 0xeef9, 0xecdb, 0x001a, 0x001a,
	0xb1d0, 0x001a, 0x001a, 0x001a, 0x001a, 0xefd5, 0x001a, 0x001a,
	0x001a, 0xf3e6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa2e7, 0xd9e4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe1e4,
	0x001a, 0x001a, 0xc4fc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xeff9, 0xf4cf, 0xe6f7, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbcce, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc5f4, 0xa3dc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbddd, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc6f4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa1f8, 0x001a, 0x001a, 0x001a, 0xd6e8, 0x001a,
	0x001a, 0x001a, 0xc1db, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe6f0, 0x001a, 0x001a, 0x001a, 0xb9e4,
	0xedf6, 0x001a, 0xaef9, 0x001a, 0xbedd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb0d7, 0xe8d8, 0xbdcb, 0x001a, 0x001a,
	0xdaf9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xcef8, 0xf0f9, 0xede0, 0xb3e3, 0xb3f4,
	0x001a, 0x001a, 0xc2ea, 0xe6f2, 0xb6f0, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd6db, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe4eb, 0x001a, 0x001a, 0xe7f2, 0x001a, 0xd5d7, 0xb6d4, 0xe8f9,
	0xc1d7, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5e5, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xeae9, 0xccd7, 0x001a,
	0x001a, 0x001a, 0xe9d3, 0xc9e2, 0x001a, 0xdbfc, 0xadcd, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb0cc, 0xa2ea, 0x001a, 0x001a,
	0xf6e4, 0xc0d0, 0x001a, 0xb7f0, 0xa1ee, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf6d7, 0x001a, 0x001a, 0x001a, 0xcae2,
	0xcbe2, 0x001a, 0xcffa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdfeb, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbd6,
	0x001a, 0x001a, 0x001a, 0xb4f4, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcded, 0xd2e4, 0x001a, 0x001a, 0xa9ea, 0xbae4, 0xa2f3, 0xd2cd,
	0x001a, 0xcbf6, 0x001a, 0xe6f1, 0xc1ed, 0xbce8, 0xd1ee, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7f0, 0xcce2, 0x001a,
	0x001a, 0xaae4, 0x001a, 0xe1f5, 0xdaed, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xeed7, 0xf1d1, 0x001a, 0x001a, 0x001a, 0x001a,
	0xebe9, 0xece9, 0xe4e0, 0x001a, 0x001a, 0x001a, 0x001a, 0xa7da,
	0xd4dd, 0x001a, 0xa3ea, 0x001a, 0x001a, 0x001a, 0xc3d6, 0xf4d6,
	0x001a, 0xdfda, 0x001a, 0xb3ef, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcde2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfdef, 0xe8f2,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc5ef, 0x001a, 0xe7e7, 0x001a, 0x001a, 0xfdd7, 0x001a,
	0x001a, 0xcee7, 0x001a, 0x001a, 0xdcdf, 0x001a, 0xc7f9, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf6d9,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xacdf, 0x001a, 0xdad6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa4dc, 0x001a, 0x001a, 0x001a, 0xb8f0, 0x001a, 0x001a,
	0x001a, 0x001a, 0xfad5, 0x001a, 0xf7e4, 0x001a, 0x001a, 0x001a,
	0xc4d6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xecf4, 0x001a, 0x001a, 0x001a, 0x001a, 0xfeef, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa1f0, 0x001a, 0xaade, 0x001a,
	0x001a, 0xbcda, 0xfcd8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd4fa, 0x001a, 0x001a, 0x001a, 0xe5ec, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa8fc, 0x001a, 0x001a, 0xe6ec,
	0x001a, 0x001a, 0xcbd8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xb9fb, 0x001a, 0xd3e4, 0x001a, 0xf9cd,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd3cf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xeaca, 0x001a, 0x001a, 0xd4cf, 0x001a, 0xbdf8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc7f4, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdfea, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdbf9, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb7d4, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xe5eb, 0x001a, 0x001a, 0xd2e1, 0x001a,
	0x001a, 0x001a, 0x001a, 0xa4ea, 0x001a, 0x001a, 0x001a, 0xc2fa,
	0xe1fb, 0xedfa, 0xa2f0, 0xf1cc, 0x001a, 0xa3fa, 0xf7e2, 0x001a,
	0xcee2, 0x001a, 0xf5e9, 0x001a, 0xebe1, 0x001a, 0x001a, 0x001a,
	0xe8e7, 0xd7e8, 0xf8da, 0xcbd4, 0x001a, 0x001a, 0x001a, 0xf6f7,
	0xc5d6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe9d4, 0x001a, 0x001a,
	0xfafa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf2cc, 0xddf7, 0x001a, 0xbade, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8ce, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xb9f0, 0xfee4, 0xc9e4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd4e4, 0x001a, 0x001a, 0x001a,
	0xc3ea, 0x001a, 0xb4ef, 0x001a, 0x001a, 0x001a, 0xbed7, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe2fb, 0x001a, 0xd3cd,
	0x001a, 0x001a, 0x001a, 0xb5ef, 0x001a, 0x001a, 0x001a, 0xe9fa,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa6f9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbddf,
	0x001a, 0xc7f7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xfdf8, 0x001a, 0x001a, 0xfcf8,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xabde, 0xe8db, 0x001a, 0x001a, 0xdde3,
	0x001a, 0xe2e1, 0xc6d1, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd0f6, 0xe6eb, 0xf9da,
	0x001a, 0x001a, 0x001a, 0x001a, 0xc7ec, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xf8de, 0xe9f8, 0xdee3, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf5ce, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xc3fa, 0xd7e5, 0x001a, 0xc8ec, 0x001a, 0x001a, 0x001a,
	0xc9f3, 0x001a, 0x001a, 0xbbe4, 0x001a, 0x001a, 0x001a, 0x001a,
	0xaee6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb6ef, 0x001a,
	0xbfdc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xbdce, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc3d8, 0x001a, 0x001a,
	0x001a, 0xcfd0, 0x001a, 0xfacf, 0xcaf3, 0xd7e0, 0x001a, 0x001a,
	0x001a, 0xc7d1, 0xaee9, 0x001a, 0xbde8, 0x001a, 0x001a, 0xc4fa,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcfe2, 0x001a,
	0x001a, 0xc5fa, 0x001a, 0x001a, 0x001a, 0xb8f9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe0dc, 0x001a, 0x001a,
	0xb0fb, 0x001a, 0x001a, 0x001a, 0xa9d8, 0xdfe5, 0xa7f9, 0x001a,
	0x001a, 0xeef6, 0x001a, 0xccf6, 0xf8e2, 0x001a, 0x001a, 0x001a,
	0x001a, 0xf1ec, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xe0da, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd2f1, 0xccd2, 0xcbcf, 0x001a, 0x001a, 0xbdca, 0x001a, 0x001a,
	0x001a, 0xbfdd, 0x001a, 0x001a, 0x001a, 0xeff6, 0x001a, 0xf9de,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xb4fa, 0x001a, 0x001a,
	0x001a, 0xadd5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe7f1,
	0x001a, 0xbede, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xc0dc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc8d1, 0xc9d1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbef8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf6cb, 0x001a, 0x001a, 0x001a, 0x001a,
	0xf9d4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe2f5, 0xd3e1,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe9d8, 0x001a, 0x001a, 0xfef8, 0x001a, 0xcccf, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa4fd, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf6ce, 0x001a, 0xd0fa,
	0x001a, 0x001a, 0xf3cc, 0xbee6, 0x001a, 0x001a, 0x001a, 0xaef6,
	0x001a, 0x001a, 0xf0d5, 0x001a, 0x001a, 0xcad1, 0x001a, 0x001a,
	0x001a, 0xbefc, 0xf1d5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xe9cd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xb5fa, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd0e2, 0xf7f4, 0x001a, 0x001a, 0x001a,
	0xd4cd, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3e7, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa5db, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xd1e2, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa2d7,
	0x001a, 0x001a, 0xe3f7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xa6ea, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xa1d0, 0x001a, 0x001a, 0x001a,
	0x001a, 0xdace, 0xebfb, 0xa6db, 0xdedb, 0xe5d8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe0ea,
	0x001a, 0x001a, 0x001a, 0x001a, 0xaad8, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xe0e5, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xdbd6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xc6ef, 0x001a,
	0x001a, 0xeaf8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd5e4,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf7ce, 0x001a, 0x001a, 0xd8e0, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xefd7, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xedf4, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xe6cd, 0x001a, 0x001a, 0x001a,
	0xf4cc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe3f5, 0x001a, 0x001a,
	0xcae4, 0x001a, 0xe1dc, 0x001a, 0x001a, 0xc8f9, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbffc, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa7e8, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc4d8, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbecb,
	0x001a, 0xaedc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xf7d7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe8f0, 0x001a, 0xc0dd,
	0x001a, 0xcdcf, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf3dc, 0xb0d9, 0x001a, 0xe9e6, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbce4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xc4ea, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xece4, 0x001a,
	0xe5e4, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xf8fb, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xbbcc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xbde4, 0x001a, 0x001a,
	0xdccd, 0xf7d9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xdfdd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xceed, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0xd0d9, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3e5,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcdf9, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xaecd, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcecf,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xaff6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xd3fd, 0xedeb, 0xdcd6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xa4e5, 0x001a, 0x001a, 0x001a, 0xb6d5, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xddd6, 0x001a, 0x001a,
	0x001a, 0xe9f9, 0x001a, 0x001a, 0x001a, 0xa4e7, 0x001a, 0xe3d6,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xcbd1, 0xe4d6, 0x001a, 0x001a, 0x001a, 0xf2d5,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xfade, 0x001a, 0xf8d7,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xead8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xd5cf, 0xfdd8, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xabd8, 0x001a, 0x001a, 0xcbfd, 0x001a,
	0x001a, 0x001a, 0x001a, 0xdcfc, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8e0, 0xf3d5, 0x001a,
	0x001a, 0xd9fd, 0x001a, 0x001a, 0xa3cc, 0x001a, 0x001a, 0x001a,
	0xf9d9, 0x001a, 0x001a, 0xead3, 0xf5f5, 0x001a, 0xc7ef, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xdad3, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xbdda, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa8e8,
	0xafdc, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3f0, 0x001a,
	0x001a, 0x001a, 0x001a, 0xd5cd, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xa9e0, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0xacde, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0xbaf0, 0xb1ee, 0x001a, 0x001a, 0xb2ee, 0x001a,
	0x001a, 0x001a, 0xcdf6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xd2ee,
	0x001a, 0xc6d6, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xe5e0,
	0x001a, 0x001a, 0xbbf3, 0x001a, 0xe1e5, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xcbe4,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0xa3d7, 0x001a, 0x001a,
	0xc2db, 0x001a, 0x001a, 0x001a, 0x001a, 0xfeca, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0xcfcf, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a
};

const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0xac00[ 11172 ] = {
	0xa1b0, 0xa2b0, 0x4181, 0x4281, 0xa3b0, 0x4381, 0x4481, 0xa4b0,
	0xa5b0, 0xa6b0, 0xa7b0, 0x4581, 0x4681, 0x4781, 0x4881, 0x4981,
	0xa8b0, 0xa9b0, 0xaab0, 0xabb0, 0xacb0, 0xadb0, 0xaeb0, 0xafb0,
	0x4a81, 0xb0b0, 0xb1b0, 0xb2b0, 0xb3b0, 0xb4b0, 0x4b81, 0x4c81,
	0xb5b0, 0x4d81, 0x4e81, 0x4f81, 0xb6b0, 0x5081, 0x5181, 0x5281,
	0x5381, 0x5481, 0x5581, 0x5681, 0xb7b0, 0xb8b0, 0x5781, 0xb9b0,
	0xbab0, 0xbbb0, 0x5881, 0x5981, 0x5a81, 0x6181, 0x6281, 0x6381,
	0xbcb0, 0xbdb0, 0x6481, 0x6581, 0xbeb0, 0x6681, 0x6781, 0x6881,
	0xbfb0, 0x6981, 0x6a81, 0x6b81, 0x6c81, 0x6d81, 0x6e81, 0x6f81,
	0x7081, 0x7181, 0x7281, 0xc0b0, 0x7381, 0xc1b0, 0x7481, 0x7581,
	0x7681, 0x7781, 0x7881, 0x7981, 0xc2b0, 0x7a81, 0x8181, 0x8281,
	0xc3b0, 0x8381, 0x8481, 0x8581, 0xc4b0, 0x8681, 0x8781, 0x8881,
	0x8981, 0x8a81, 0x8b81, 0x8c81, 0x8d81, 0x8e81, 0x8f81, 0x9081,
	0x9181, 0x9281, 0x9381, 0x9481, 0x9581, 0x9681, 0x9781, 0x9881,
	0xc5b0, 0xc6b0, 0x9981, 0x9a81, 0xc7b0, 0x9b81, 0x9c81, 0xc8b0,
	0xc9b0, 0x9d81, 0xcab0, 0x9e81, 0x9f81, 0xa081, 0xa181, 0xa281,
	0xcbb0, 0xccb0, 0xa381, 0xcdb0, 0xceb0, 0xcfb0, 0xd0b0, 0xa481,
	0xa581, 0xd1b0, 0xd2b0, 0xd3b0, 0xd4b0, 0xa681, 0xa781, 0xa881,
	0xd5b0, 0xa981, 0xaa81, 0xab81, 0xd6b0, 0xac81, 0xad81, 0xae81,
	0xaf81, 0xb081, 0xb181, 0xb281, 0xd7b0, 0xd8b0, 0xb381, 0xd9b0,
	0xdab0, 0xdbb0, 0xb481, 0xb581, 0xb681, 0xb781, 0xb881, 0xb981,
	0xdcb0, 0xddb0, 0xdeb0, 0xba81, 0xdfb0, 0xbb81, 0xbc81, 0xe0b0,
	0xe1b0, 0xbd81, 0xbe81, 0xbf81, 0xc081, 0xc181, 0xc281, 0xc381,
	0xe2b0, 0xe3b0, 0xc481, 0xe4b0, 0xe5b0, 0xe6b0, 0xc581, 0xc681,
	0xc781, 0xe7b0, 0xc881, 0xc981, 0xe8b0, 0xca81, 0xcb81, 0xcc81,
	0xe9b0, 0xcd81, 0xce81, 0xcf81, 0xeab0, 0xd081, 0xd181, 0xd281,
	0xd381, 0xd481, 0xd581, 0xd681, 0xd781, 0xebb0, 0xd881, 0xecb0,
	0xd981, 0xda81, 0xdb81, 0xdc81, 0xdd81, 0xde81, 0xdf81, 0xe081,
	0xedb0, 0xeeb0, 0xe181, 0xe281, 0xefb0, 0xe381, 0xe481, 0xf0b0,
	0xf1b0, 0xe581, 0xf2b0, 0xe681, 0xf3b0, 0xe781, 0xe881, 0xf4b0,
	0xf5b0, 0xf6b0, 0xe981, 0xf7b0, 0xea81, 0xf8b0, 0xf9b0, 0xeb81,
	0xec81, 0xed81, 0xee81, 0xef81, 0xfab0, 0xfbb0, 0xf081, 0xf181,
	0xfcb0, 0xf281, 0xf381, 0xf481, 0xfdb0, 0xf581, 0xfeb0, 0xf681,
	0xf781, 0xf881, 0xf981, 0xfa81, 0xa1b1, 0xa2b1, 0xfb81, 0xa3b1,
	0xfc81, 0xa4b1, 0xfd81, 0xfe81, 0x4182, 0x4282, 0x4382, 0x4482,
	0xa5b1, 0x4582, 0x4682, 0x4782, 0xa6b1, 0x4882, 0x4982, 0x4a82,
	0xa7b1, 0x4b82, 0x4c82, 0x4d82, 0x4e82, 0x4f82, 0x5082, 0x5182,
	0x5282, 0xa8b1, 0x5382, 0x5482, 0xa9b1, 0xaab1, 0x5582, 0x5682,
	0x5782, 0x5882, 0x5982, 0x5a82, 0xabb1, 0xacb1, 0x6182, 0x6282,
	0xadb1, 0x6382, 0x6482, 0x6582, 0xaeb1, 0x6682, 0x6782, 0x6882,
	0x6982, 0x6a82, 0x6b82, 0x6c82, 0xafb1, 0xb0b1, 0x6d82, 0xb1b1,
	0x6e82, 0xb2b1, 0x6f82, 0x7082, 0x7182, 0x7282, 0x7382, 0x7482,
	0xb3b1, 0x7582, 0x7682, 0x7782, 0xb4b1, 0x7882, 0x7982, 0x7a82,
	0xb5b1, 0x8182, 0x8282, 0x8382, 0x8482, 0x8582, 0x8682, 0x8782,
	0x8882, 0xb6b1, 0x8982, 0xb7b1, 0x8a82, 0x8b82, 0x8c82, 0x8d82,
	0x8e82, 0x8f82, 0x9082, 0x9182, 0xb8b1, 0xb9b1, 0x9282, 0x9382,
	0xbab1, 0x9482, 0x9582, 0xbbb1, 0xbcb1, 0xbdb1, 0xbeb1, 0x9682,
	0x9782, 0x9882, 0x9982, 0xbfb1, 0xc0b1, 0xc1b1, 0x9a82, 0xc2b1,
	0x9b82, 0xc3b1, 0xc4b1, 0x9c82, 0x9d82, 0x9e82, 0x9f82, 0xa082,
	0xc5b1, 0xc6b1, 0xa182, 0xa282, 0xc7b1, 0xa382, 0xa482, 0xa582,
	0xc8b1, 0xa682, 0xa782, 0xa882, 0xa982, 0xaa82, 0xab82, 0xac82,
	0xad82, 0xae82, 0xaf82, 0xb082, 0xc9b1, 0xcab1, 0xb182, 0xb282,
	0xb382, 0xb482, 0xb582, 0xb682, 0xcbb1, 0xb782, 0xb882, 0xb982,
	0xba82, 0xbb82, 0xbc82, 0xbd82, 0xbe82, 0xbf82, 0xc082, 0xc182,
	0xc282, 0xc382, 0xc482, 0xc582, 0xc682, 0xc782, 0xc882, 0xccb1,
	0xc982, 0xca82, 0xcb82, 0xcc82, 0xcd82, 0xce82, 0xcf82, 0xd082,
	0xcdb1, 0xceb1, 0xd182, 0xd282, 0xcfb1, 0xd382, 0xd482, 0xd582,
	0xd0b1, 0xd682, 0xd782, 0xd882, 0xd982, 0xda82, 0xdb82, 0xdc82,
	0xd1b1, 0xd2b1, 0xdd82, 0xd3b1, 0xde82, 0xdf82, 0xe082, 0xe182,
	0xe282, 0xe382, 0xe482, 0xe582, 0xd4b1, 0xe682, 0xe782, 0xe882,
	0xd5b1, 0xe982, 0xea82, 0xeb82, 0xd6b1, 0xec82, 0xed82, 0xee82,
	0xef82, 0xf082, 0xf182, 0xf282, 0xf382, 0xf482, 0xf582, 0xf682,
	0xf782, 0xf882, 0xf982, 0xfa82, 0xfb82, 0xfc82, 0xfd82, 0xfe82,
	0xd7b1, 0xd8b1, 0x4183, 0x4283, 0xd9b1, 0x4383, 0x4483, 0xdab1,
	0xdbb1, 0xdcb1, 0x4583, 0x4683, 0x4783, 0x4883, 0x4983, 0x4a83,
	0xddb1, 0xdeb1, 0x4b83, 0xdfb1, 0x4c83, 0xe0b1, 0x4d83, 0x4e83,
	0x4f83, 0x5083, 0x5183, 0x5283, 0xe1b1, 0x5383, 0x5483, 0x5583,
	0x5683, 0x5783, 0x5883, 0x5983, 0x5a83, 0x6183, 0x6283, 0x6383,
	0x6483, 0x6583, 0x6683, 0x6783, 0x6883, 0x6983, 0x6a83, 0x6b83,
	0x6c83, 0x6d83, 0x6e83, 0x6f83, 0x7083, 0x7183, 0x7283, 0x7383,
	0xe2b1, 0xe3b1, 0x7483, 0x7583, 0xe4b1, 0x7683, 0x7783, 0xe5b1,
	0xe6b1, 0x7883, 0xe7b1, 0x7983, 0x7a83, 0x8183, 0x8283, 0x8383,
	0xe8b1, 0xe9b1, 0x8483, 0xeab1, 0x8583, 0xebb1, 0xecb1, 0x8683,
	0x8783, 0x8883, 0xedb1, 0x8983, 0xeeb1, 0xefb1, 0xf0b1, 0x8a83,
	0xf1b1, 0x8b83, 0x8c83, 0x8d83, 0xf2b1, 0x8e83, 0xf3b1, 0x8f83,
	0x9083, 0x9183, 0x9283, 0x9383, 0xf4b1, 0xf5b1, 0x9483, 0xf6b1,
	0xf7b1, 0xf8b1, 0x9583, 0x9683, 0x9783, 0xf9b1, 0x9883, 0x9983,
	0xfab1, 0xfbb1, 0x9a83, 0x9b83, 0xfcb1, 0x9c83, 0x9d83, 0x9e83,
	0xfdb1, 0x9f83, 0xa083, 0xa183, 0xa283, 0xa383, 0xa483, 0xa583,
	0xfeb1, 0xa1b2, 0xa683, 0xa2b2, 0xa3b2, 0xa4b2, 0xa783, 0xa883,
	0xa983, 0xaa83, 0xab83, 0xac83, 0xa5b2, 0xa6b2, 0xad83, 0xae83,
	0xaf83, 0xb083, 0xb183, 0xb283, 0xa7b2, 0xb383, 0xb483, 0xb583,
	0xb683, 0xb783, 0xb883, 0xb983, 0xba83, 0xbb83, 0xbc83, 0xbd83,
	0xbe83, 0xbf83, 0xc083, 0xc183, 0xc283, 0xc383, 0xc483, 0xc583,
	0xc683, 0xc783, 0xc883, 0xc983, 0xca83, 0xcb83, 0xcc83, 0xcd83,
	0xce83, 0xcf83, 0xd083, 0xd183, 0xd283, 0xd383, 0xd483, 0xd583,
	0xd683, 0xd783, 0xd883, 0xd983, 0xda83, 0xdb83, 0xdc83, 0xdd83,
	0xde83, 0xdf83, 0xe083, 0xe183, 0xa8b2, 0xa9b2, 0xaab2, 0xe283,
	0xabb2, 0xe383, 0xe483, 0xe583, 0xacb2, 0xe683, 0xe783, 0xe883,
	0xe983, 0xea83, 0xeb83, 0xec83, 0xadb2, 0xaeb2, 0xed83, 0xafb2,
	0xb0b2, 0xb1b2, 0xee83, 0xef83, 0xf083, 0xf183, 0xf283, 0xf383,
	0xb2b2, 0xb3b2, 0xf483, 0xf583, 0xb4b2, 0xf683, 0xf783, 0xf883,
	0xf983, 0xfa83, 0xfb83, 0xfc83, 0xfd83, 0xfe83, 0x4184, 0x4284,
	0xb5b2, 0x4384, 0x4484, 0xb6b2, 0x4584, 0xb7b2, 0x4684, 0x4784,
	0x4884, 0x4984, 0x4a84, 0x4b84, 0xb8b2, 0x4c84, 0x4d84, 0x4e84,
	0xb9b2, 0x4f84, 0x5084, 0x5184, 0xbab2, 0x5284, 0x5384, 0x5484,
	0x5584, 0x5684, 0x5784, 0x5884, 0x5984, 0x5a84, 0x6184, 0xbbb2,
	0xbcb2, 0x6284, 0x6384, 0x6484, 0x6584, 0xbdb2, 0x6684, 0x6784,
	0xbeb2, 0x6884, 0x6984, 0x6a84, 0x6b84, 0x6c84, 0x6d84, 0x6e84,
	0x6f84, 0x7084, 0x7184, 0x7284, 0x7384, 0x7484, 0x7584, 0x7684,
	0x7784, 0x7884, 0x7984, 0x7a84, 0x8184, 0x8284, 0x8384, 0x8484,
	0x8584, 0x8684, 0x8784, 0x8884, 0xbfb2, 0xc0b2, 0x8984, 0x8a84,
	0xc1b2, 0x8b84, 0xc2b2, 0x8c84, 0xc3b2, 0x8d84, 0x8e84, 0x8f84,
	0x9084, 0x9184, 0x9284, 0x9384, 0xc4b2, 0xc5b2, 0x9484, 0xc6b2,
	0x9584, 0xc7b2, 0xc8b2, 0xc9b2, 0x9684, 0x9784, 0x9884, 0x9984,
	0xcab2, 0xcbb2, 0x9a84, 0x9b84, 0x9c84, 0x9d84, 0x9e84, 0x9f84,
	0xccb2, 0xa084, 0xa184, 0xa284, 0xa384, 0xa484, 0xa584, 0xa684,
	0xa784, 0xa884, 0xa984, 0xaa84, 0xcdb2, 0xceb2, 0xab84, 0xac84,
	0xad84, 0xae84, 0xaf84, 0xb084, 0xcfb2, 0xd0b2, 0xb184, 0xb284,
	0xb384, 0xb484, 0xb584, 0xb684, 0xb784, 0xb884, 0xb984, 0xba84,
	0xbb84, 0xbc84, 0xbd84, 0xbe84, 0xbf84, 0xc084, 0xc184, 0xc284,
	0xc384, 0xd1b2, 0xc484, 0xc584, 0xc684, 0xc784, 0xc884, 0xc984,
	0xd2b2, 0xca84, 0xcb84, 0xcc84, 0xd3b2, 0xcd84, 0xce84, 0xcf84,
	0xd4b2, 0xd084, 0xd184, 0xd284, 0xd384, 0xd484, 0xd584, 0xd684,
	0xd5b2, 0xd6b2, 0xd784, 0xd884, 0xd984, 0xd7b2, 0xda84, 0xdb84,
	0xdc84, 0xdd84, 0xde84, 0xdf84, 0xd8b2, 0xe084, 0xe184, 0xe284,
	0xe384, 0xe484, 0xe584, 0xe684, 0xe784, 0xe884, 0xe984, 0xea84,
	0xeb84, 0xec84, 0xed84, 0xee84, 0xef84, 0xf084, 0xf184, 0xf284,
	0xf384, 0xf484, 0xf584, 0xf684, 0xf784, 0xf884, 0xf984, 0xfa84,
	0xd9b2, 0xdab2, 0xfb84, 0xfc84, 0xdbb2, 0xfd84, 0xfe84, 0x4185,
	0xdcb2, 0x4285, 0x4385, 0x4485, 0x4585, 0x4685, 0x4785, 0xddb2,
	0xdeb2, 0xdfb2, 0x4885, 0xe0b2, 0x4985, 0xe1b2, 0xe2b2, 0x4a85,
	0x4b85, 0x4c85, 0x4d85, 0x4e85, 0xe3b2, 0x4f85, 0x5085, 0x5185,
	0x5285, 0x5385, 0x5485, 0x5585, 0xe4b2, 0x5685, 0x5785, 0x5885,
	0x5985, 0x5a85, 0x6185, 0x6285, 0x6385, 0x6485, 0x6585, 0x6685,
	0xe5b2, 0xe6b2, 0x6785, 0x6885, 0x6985, 0x6a85, 0x6b85, 0x6c85,
	0xe7b2, 0xe8b2, 0x6d85, 0x6e85, 0xe9b2, 0x6f85, 0x7085, 0x7185,
	0xeab2, 0x7285, 0x7385, 0x7485, 0x7585, 0x7685, 0x7785, 0x7885,
	0xebb2, 0xecb2, 0x7985, 0x7a85, 0xedb2, 0x8185, 0x8285, 0x8385,
	0x8485, 0x8585, 0x8685, 0x8785, 0xeeb2, 0x8885, 0x8985, 0x8a85,
	0xefb2, 0x8b85, 0x8c85, 0x8d85, 0xf0b2, 0x8e85, 0x8f85, 0x9085,
	0x9185, 0x9285, 0x9385, 0x9485, 0xf1b2, 0xf2b2, 0x9585, 0x9685,
	0x9785, 0x9885, 0x9985, 0x9a85, 0x9b85, 0x9c85, 0x9d85, 0x9e85,
	0xf3b2, 0x9f85, 0xa085, 0xa185, 0xa285, 0xa385, 0xa485, 0xa585,
	0xa685, 0xa785, 0xa885, 0xa985, 0xaa85, 0xab85, 0xac85, 0xad85,
	0xae85, 0xaf85, 0xb085, 0xb185, 0xb285, 0xb385, 0xb485, 0xb585,
	0xb685, 0xb785, 0xb885, 0xb985, 0xf4b2, 0xf5b2, 0xba85, 0xbb85,
	0xf6b2, 0xbc85, 0xf7b2, 0xbd85, 0xf8b2, 0xbe85, 0xf9b2, 0xbf85,
	0xc085, 0xc185, 0xc285, 0xfab2, 0xfbb2, 0xfcb2, 0xc385, 0xfdb2,
	0xc485, 0xfeb2, 0xc585, 0xc685, 0xc785, 0xa1b3, 0xc885, 0xc985,
	0xca85, 0xcb85, 0xcc85, 0xcd85, 0xce85, 0xcf85, 0xd085, 0xd185,
	0xd285, 0xd385, 0xd485, 0xd585, 0xd685, 0xd785, 0xd885, 0xd985,
	0xda85, 0xdb85, 0xdc85, 0xdd85, 0xde85, 0xdf85, 0xe085, 0xe185,
	0xe285, 0xe385, 0xe485, 0xe585, 0xa2b3, 0xa3b3, 0xe685, 0xe785,
	0xa4b3, 0xe885, 0xe985, 0xea85, 0xa5b3, 0xeb85, 0xec85, 0xed85,
	0xee85, 0xef85, 0xf085, 0xf185, 0xa6b3, 0xa7b3, 0xf285, 0xa8b3,
	0xf385, 0xa9b3, 0xf485, 0xf585, 0xf685, 0xf785, 0xf885, 0xf985,
	0xaab3, 0xabb3, 0xacb3, 0xfa85, 0xadb3, 0xfb85, 0xfc85, 0xaeb3,
	0xafb3, 0xb0b3, 0xb1b3, 0xfd85, 0xfe85, 0x4186, 0x4286, 0x4386,
	0xb2b3, 0xb3b3, 0x4486, 0xb4b3, 0xb5b3, 0xb6b3, 0xb7b3, 0xb8b3,
	0x4586, 0xb9b3, 0x4686, 0xbab3, 0xbbb3, 0xbcb3, 0x4786, 0x4886,
	0xbdb3, 0x4986, 0x4a86, 0x4b86, 0xbeb3, 0x4c86, 0x4d86, 0x4e86,
	0x4f86, 0x5086, 0x5186, 0x5286, 0xbfb3, 0xc0b3, 0x5386, 0xc1b3,
	0xc2b3, 0xc3b3, 0x5486, 0x5586, 0x5686, 0x5786, 0x5886, 0x5986,
	0xc4b3, 0xc5b3, 0x5a86, 0x6186, 0xc6b3, 0x6286, 0x6386, 0x6486,
	0xc7b3, 0x6586, 0x6686, 0x6786, 0x6886, 0x6986, 0x6a86, 0x6b86,
	0xc8b3, 0x6c86, 0x6d86, 0x6e86, 0x6f86, 0xc9b3, 0x7086, 0x7186,
	0x7286, 0x7386, 0x7486, 0x7586, 0x7686, 0x7786, 0x7886, 0x7986,
	0x7a86, 0x8186, 0x8286, 0x8386, 0x8486, 0x8586, 0x8686, 0x8786,
	0x8886, 0x8986, 0x8a86, 0x8b86, 0x8c86, 0x8d86, 0x8e86, 0x8f86,
	0x9086, 0x9186, 0x9286, 0x9386, 0x9486, 0x9586, 0x9686, 0x9786,
	0xcab3, 0xcbb3, 0x9886, 0xccb3, 0xcdb3, 0x9986, 0x9a86, 0x9b86,
	0xceb3, 0x9c86, 0xcfb3, 0xd0b3, 0x9d86, 0x9e86, 0x9f86, 0xa086,
	0xd1b3, 0xd2b3, 0xa186, 0xd3b3, 0xd4b3, 0xd5b3, 0xa286, 0xa386,
	0xa486, 0xa586, 0xa686, 0xd6b3, 0xd7b3, 0xd8b3, 0xa786, 0xa886,
	0xd9b3, 0xa986, 0xaa86, 0xab86, 0xdab3, 0xac86, 0xad86, 0xae86,
	0xaf86, 0xb086, 0xb186, 0xb286, 0xdbb3, 0xdcb3, 0xb386, 0xddb3,
	0xdeb3, 0xdfb3, 0xb486, 0xb586, 0xb686, 0xb786, 0xb886, 0xb986,
	0xe0b3, 0xe1b3, 0xba86, 0xbb86, 0xe2b3, 0xbc86, 0xbd86, 0xbe86,
	0xe3b3, 0xbf86, 0xc086, 0xc186, 0xc286, 0xc386, 0xc486, 0xc586,
	0xe4b3, 0xe5b3, 0xc686, 0xc786, 0xe6b3, 0xe7b3, 0xc886, 0xc986,
	0xe8b3, 0xca86, 0xcb86, 0xcc86, 0xe9b3, 0xcd86, 0xce86, 0xcf86,
	0xeab3, 0xd086, 0xd186, 0xd286, 0xd386, 0xd486, 0xd586, 0xd686,
	0xd786, 0xd886, 0xd986, 0xda86, 0xdb86, 0xdc86, 0xdd86, 0xde86,
	0xdf86, 0xe086, 0xe186, 0xe286, 0xe386, 0xe486, 0xe586, 0xe686,
	0xebb3, 0xecb3, 0xe786, 0xe886, 0xedb3, 0xe986, 0xea86, 0xeb86,
	0xeeb3, 0xec86, 0xefb3, 0xed86, 0xee86, 0xef86, 0xf086, 0xf186,
	0xf0b3, 0xf1b3, 0xf286, 0xf2b3, 0xf386, 0xf3b3, 0xf486, 0xf586,
	0xf686, 0xf786, 0xf4b3, 0xf5b3, 0xf6b3, 0xf886, 0xf986, 0xfa86,
	0xf7b3, 0xfb86, 0xfc86, 0xfd86, 0xf8b3, 0xfe86, 0x4187, 0x4287,
	0x4387, 0x4487, 0x4587, 0x4687, 0x4787, 0x4887, 0x4987, 0x4a87,
	0xf9b3, 0x4b87, 0x4c87, 0x4d87, 0x4e87, 0x4f87, 0x5087, 0x5187,
	0x5287, 0x5387, 0x5487, 0x5587, 0x5687, 0x5787, 0x5887, 0x5987,
	0x5a87, 0x6187, 0x6287, 0x6387, 0x6487, 0x6587, 0x6687, 0x6787,
	0x6887, 0x6987, 0x6a87, 0x6b87, 0x6c87, 0x6d87, 0x6e87, 0x6f87,
	0x7087, 0x7187, 0x7287, 0x7387, 0xfab3, 0x7487, 0x7587, 0x7687,
	0xfbb3, 0x7787, 0x7887, 0x7987, 0xfcb3, 0x7a87, 0x8187, 0x8287,
	0x8387, 0x8487, 0x8587, 0x8687, 0xfdb3, 0xfeb3, 0x8787, 0xa1b4,
	0x8887, 0x8987, 0x8a87, 0x8b87, 0x8c87, 0x8d87, 0x8e87, 0x8f87,
	0xa2b4, 0xa3b4, 0x9087, 0x9187, 0xa4b4, 0x9287, 0x9387, 0x9487,
	0xa5b4, 0x9587, 0x9687, 0x9787, 0x9887, 0x9987, 0x9a87, 0x9b87,
	0x9c87, 0xa6b4, 0x9d87, 0xa7b4, 0x9e87, 0xa8b4, 0x9f87, 0xa087,
	0xa187, 0xa287, 0xa387, 0xa487, 0xa9b4, 0xaab4, 0xa587, 0xa687,
	0xabb4, 0xa787, 0xa887, 0xacb4, 0xadb4, 0xa987, 0xaa87, 0xab87,
	0xac87, 0xad87, 0xae87, 0xaf87, 0xaeb4, 0xafb4, 0xb087, 0xb0b4,
	0xb187, 0xb1b4, 0xb287, 0xb387, 0xb487, 0xb587, 0xb687, 0xb787,
	0xb2b4, 0xb887, 0xb987, 0xba87, 0xbb87, 0xbc87, 0xbd87, 0xbe87,
	0xbf87, 0xc087, 0xc187, 0xc287, 0xc387, 0xc487, 0xc587, 0xc687,
	0xc787, 0xc887, 0xc987, 0xca87, 0xb3b4, 0xcb87, 0xcc87, 0xcd87,
	0xce87, 0xcf87, 0xd087, 0xd187, 0xb4b4, 0xd287, 0xd387, 0xd487,
	0xd587, 0xd687, 0xd787, 0xd887, 0xd987, 0xda87, 0xdb87, 0xdc87,
	0xdd87, 0xde87, 0xdf87, 0xe087, 0xe187, 0xe287, 0xe387, 0xe487,
	0xe587, 0xe687, 0xe787, 0xe887, 0xe987, 0xea87, 0xeb87, 0xec87,
	0xb5b4, 0xed87, 0xee87, 0xef87, 0xb6b4, 0xf087, 0xf187, 0xf287,
	0xb7b4, 0xf387, 0xf487, 0xf587, 0xf687, 0xf787, 0xf887, 0xf987,
	0xb8b4, 0xb9b4, 0xfa87, 0xfb87, 0xfc87, 0xfd87, 0xfe87, 0x4188,
	0x4288, 0x4388, 0x4488, 0x4588, 0xbab4, 0xbbb4, 0x4688, 0x4788,
	0x4888, 0x4988, 0x4a88, 0x4b88, 0xbcb4, 0x4c88, 0x4d88, 0x4e88,
	0x4f88, 0x5088, 0x5188, 0x5288, 0xbdb4, 0xbeb4, 0x5388, 0x5488,
	0x5588, 0xbfb4, 0x5688, 0x5788, 0x5888, 0x5988, 0x5a88, 0x6188,
	0xc0b4, 0xc1b4, 0x6288, 0x6388, 0xc2b4, 0x6488, 0x6588, 0x6688,
	0xc3b4, 0xc4b4, 0xc5b4, 0x6788, 0x6888, 0x6988, 0x6a88, 0x6b88,
	0xc6b4, 0xc7b4, 0x6c88, 0xc8b4, 0x6d88, 0xc9b4, 0xcab4, 0x6e88,
	0x6f88, 0x7088, 0xcbb4, 0x7188, 0xccb4, 0x7288, 0x7388, 0x7488,
	0xcdb4, 0x7588, 0x7688, 0x7788, 0xceb4, 0x7888, 0x7988, 0x7a88,
	0x8188, 0x8288, 0x8388, 0x8488, 0x8588, 0x8688, 0x8788, 0x8888,
	0x8988, 0x8a88, 0x8b88, 0x8c88, 0x8d88, 0x8e88, 0x8f88, 0x9088,
	0xcfb4, 0xd0b4, 0x9188, 0x9288, 0xd1b4, 0x9388, 0x9488, 0x9588,
	0xd2b4, 0x9688, 0xd3b4, 0x9788, 0x9888, 0x9988, 0x9a88, 0x9b88,
	0xd4b4, 0xd5b4, 0x9c88, 0xd6b4, 0x9d88, 0xd7b4, 0x9e88, 0x9f88,
	0xa088, 0xa188, 0xd8b4, 0xa288, 0xd9b4, 0xdab4, 0xdbb4, 0xa388,
	0xdcb4, 0xa488, 0xa588, 0xddb4, 0xdeb4, 0xdfb4, 0xe0b4, 0xe1b4,
	0xa688, 0xa788, 0xa888, 0xe2b4, 0xe3b4, 0xe4b4, 0xa988, 0xe5b4,
	0xe6b4, 0xe7b4, 0xe8b4, 0xe9b4, 0xaa88, 0xab88, 0xac88, 0xeab4,
	0xebb4, 0xecb4, 0xad88, 0xae88, 0xedb4, 0xaf88, 0xb088, 0xb188,
	0xeeb4, 0xb288, 0xb388, 0xb488, 0xb588, 0xb688, 0xb788, 0xb888,
	0xefb4, 0xf0b4, 0xb988, 0xf1b4, 0xf2b4, 0xf3b4, 0xba88, 0xbb88,
	0xbc88, 0xbd88, 0xbe88, 0xbf88, 0xf4b4, 0xc088, 0xc188, 0xc288,
	0xc388, 0xc488, 0xc588, 0xc688, 0xc788, 0xc888, 0xc988, 0xca88,
	0xcb88, 0xcc88, 0xcd88, 0xce88, 0xcf88, 0xd088, 0xd188, 0xd288,
	0xd388, 0xd488, 0xd588, 0xd688, 0xd788, 0xd888, 0xd988, 0xda88,
	0xdb88, 0xdc88, 0xdd88, 0xde88, 0xdf88, 0xe088, 0xe188, 0xe288,
	0xe388, 0xe488, 0xe588, 0xe688, 0xe788, 0xe888, 0xe988, 0xea88,
	0xeb88, 0xec88, 0xed88, 0xee88, 0xef88, 0xf088, 0xf188, 0xf288,
	0xf388, 0xf488, 0xf588, 0xf688, 0xf5b4, 0xf6b4, 0xf7b4, 0xf788,
	0xf8b4, 0xf888, 0xf988, 0xf9b4, 0xfab4, 0xfa88, 0xfbb4, 0xfcb4,
	0xfb88, 0xfc88, 0xfd88, 0xfe88, 0xfdb4, 0xfeb4, 0x4189, 0xa1b5,
	0x4289, 0xa2b5, 0x4389, 0xa3b5, 0x4489, 0x4589, 0xa4b5, 0x4689,
	0xa5b5, 0xa6b5, 0x4789, 0x4889, 0xa7b5, 0x4989, 0x4a89, 0x4b89,
	0xa8b5, 0x4c89, 0x4d89, 0x4e89, 0x4f89, 0x5089, 0x5189, 0x5289,
	0xa9b5, 0xaab5, 0x5389, 0xabb5, 0xacb5, 0xadb5, 0x5489, 0x5589,
	0x5689, 0x5789, 0x5889, 0x5989, 0xaeb5, 0x5a89, 0x6189, 0x6289,
	0xafb5, 0x6389, 0x6489, 0x6589, 0xb0b5, 0x6689, 0x6789, 0x6889,
	0x6989, 0x6a89, 0x6b89, 0x6c89, 0x6d89, 0x6e89, 0x6f89, 0x7089,
	0xb1b5, 0xb2b5, 0x7189, 0x7289, 0x7389, 0x7489, 0x7589, 0x7689,
	0xb3b5, 0x7789, 0x7889, 0x7989, 0xb4b5, 0x7a89, 0x8189, 0x8289,
	0x8389, 0x8489, 0x8589, 0x8689, 0x8789, 0x8889, 0x8989, 0x8a89,
	0x8b89, 0x8c89, 0x8d89, 0x8e89, 0x8f89, 0x9089, 0x9189, 0x9289,
	0x9389, 0x9489, 0x9589, 0x9689, 0xb5b5, 0xb6b5, 0x9789, 0x9889,
	0xb7b5, 0x9989, 0x9a89, 0xb8b5, 0xb9b5, 0x9b89, 0xbab5, 0x9c89,
	0xbbb5, 0x9d89, 0x9e89, 0x9f89, 0xbcb5, 0xbdb5, 0xa089, 0xbeb5,
	0xa189, 0xbfb5, 0xa289, 0xc0b5, 0xa389, 0xc1b5, 0xa489, 0xa589,
	0xc2b5, 0xa689, 0xa789, 0xa889, 0xc3b5, 0xa989, 0xaa89, 0xab89,
	0xc4b5, 0xac89, 0xad89, 0xae89, 0xaf89, 0xb089, 0xb189, 0xb289,
	0xb389, 0xb489, 0xb589, 0xb689, 0xb789, 0xb889, 0xb989, 0xba89,
	0xbb89, 0xbc89, 0xbd89, 0xbe89, 0xc5b5, 0xbf89, 0xc089, 0xc189,
	0xc289, 0xc389, 0xc489, 0xc589, 0xc689, 0xc789, 0xc889, 0xc989,
	0xca89, 0xcb89, 0xcc89, 0xcd89, 0xce89, 0xcf89, 0xd089, 0xd189,
	0xc6b5, 0xd289, 0xd389, 0xd489, 0xd589, 0xd689, 0xd789, 0xd889,
	0xc7b5, 0xd989, 0xda89, 0xdb89, 0xc8b5, 0xdc89, 0xdd89, 0xde89,
	0xc9b5, 0xdf89, 0xe089, 0xe189, 0xe289, 0xe389, 0xe489, 0xe589,
	0xcab5, 0xcbb5, 0xe689, 0xccb5, 0xe789, 0xe889, 0xe989, 0xea89,
	0xeb89, 0xec89, 0xed89, 0xee89, 0xcdb5, 0xef89, 0xf089, 0xf189,
	0xf289, 0xf389, 0xf489, 0xf589, 0xf689, 0xf789, 0xf889, 0xf989,
	0xfa89, 0xfb89, 0xfc89, 0xfd89, 0xfe89, 0x418a, 0x428a, 0x438a,
	0x448a, 0x458a, 0x468a, 0x478a, 0x488a, 0x498a, 0x4a8a, 0x4b8a,
	0xceb5, 0xcfb5, 0x4c8a, 0x4d8a, 0xd0b5, 0x4e8a, 0x4f8a, 0x508a,
	0xd1b5, 0x518a, 0x528a, 0x538a, 0x548a, 0x558a, 0x568a, 0x578a,
	0xd2b5, 0xd3b5, 0x588a, 0xd4b5, 0x598a, 0xd5b5, 0x5a8a, 0x618a,
	0x628a, 0x638a, 0x648a, 0x658a, 0xd6b5, 0x668a, 0x678a, 0x688a,
	0x698a, 0x6a8a, 0x6b8a, 0x6c8a, 0x6d8a, 0x6e8a, 0x6f8a, 0x708a,
	0x718a, 0x728a, 0x738a, 0x748a, 0x758a, 0x768a, 0x778a, 0x788a,
	0xd7b5, 0x798a, 0x7a8a, 0x818a, 0x828a, 0x838a, 0x848a, 0x858a,
	0xd8b5, 0x868a, 0x878a, 0x888a, 0x898a, 0x8a8a, 0x8b8a, 0x8c8a,
	0x8d8a, 0x8e8a, 0x8f8a, 0x908a, 0x918a, 0x928a, 0x938a, 0x948a,
	0x958a, 0x968a, 0x978a, 0x988a, 0x998a, 0xd9b5, 0x9a8a, 0x9b8a,
	0x9c8a, 0x9d8a, 0x9e8a, 0x9f8a, 0xdab5, 0xa08a, 0xa18a, 0xa28a,
	0xdbb5, 0xa38a, 0xa48a, 0xa58a, 0xdcb5, 0xa68a, 0xa78a, 0xa88a,
	0xa98a, 0xaa8a, 0xab8a, 0xac8a, 0xad8a, 0xddb5, 0xae8a, 0xdeb5,
	0xaf8a, 0xdfb5, 0xb08a, 0xb18a, 0xb28a, 0xb38a, 0xb48a, 0xb58a,
	0xe0b5, 0xb68a, 0xb78a, 0xb88a, 0xe1b5, 0xb98a, 0xba8a, 0xbb8a,
	0xe2b5, 0xbc8a, 0xbd8a, 0xbe8a, 0xbf8a, 0xc08a, 0xc18a, 0xc28a,
	0xe3b5, 0xc38a, 0xc48a, 0xc58a, 0xc68a, 0xe4b5, 0xc78a, 0xc88a,
	0xc98a, 0xca8a, 0xcb8a, 0xcc8a, 0xe5b5, 0xe6b5, 0xcd8a, 0xce8a,
	0xe7b5, 0xcf8a, 0xd08a, 0xe8b5, 0xe9b5, 0xd18a, 0xeab5, 0xd28a,
	0xd38a, 0xd48a, 0xd58a, 0xd68a, 0xebb5, 0xecb5, 0xd78a, 0xedb5,
	0xd88a, 0xeeb5, 0xd98a, 0xda8a, 0xdb8a, 0xdc8a, 0xdd8a, 0xde8a,
	0xefb5, 0xdf8a, 0xe08a, 0xe18a, 0xe28a, 0xe38a, 0xe48a, 0xe58a,
	0xe68a, 0xe78a, 0xe88a, 0xe98a, 0xea8a, 0xeb8a, 0xec8a, 0xed8a,
	0xee8a, 0xef8a, 0xf08a, 0xf18a, 0xf28a, 0xf38a, 0xf48a, 0xf58a,
	0xf68a, 0xf78a, 0xf88a, 0xf98a, 0xf0b5, 0xf1b5, 0xfa8a, 0xfb8a,
	0xf2b5, 0xfc8a, 0xfd8a, 0xf3b5, 0xf4b5, 0xfe8a, 0x418b, 0x428b,
	0x438b, 0x448b, 0x458b, 0x468b, 0xf5b5, 0xf6b5, 0x478b, 0xf7b5,
	0xf8b5, 0xf9b5, 0xfab5, 0x488b, 0x498b, 0x4a8b, 0x4b8b, 0x4c8b,
	0xfbb5, 0xfcb5, 0x4d8b, 0x4e8b, 0xfdb5, 0x4f8b, 0x508b, 0x518b,
	0xfeb5, 0x528b, 0x538b, 0x548b, 0x558b, 0x568b, 0x578b, 0x588b,
	0xa1b6, 0xa2b6, 0x598b, 0xa3b6, 0xa4b6, 0xa5b6, 0x5a8b, 0x618b,
	0x628b, 0x638b, 0x648b, 0xa6b6, 0xa7b6, 0xa8b6, 0x658b, 0x668b,
	0xa9b6, 0x678b, 0x688b, 0x698b, 0xaab6, 0x6a8b, 0x6b8b, 0x6c8b,
	0x6d8b, 0x6e8b, 0x6f8b, 0x708b, 0xabb6, 0xacb6, 0x718b, 0xadb6,
	0xaeb6, 0xafb6, 0x728b, 0x738b, 0x748b, 0x758b, 0x768b, 0x778b,
	0x788b, 0x798b, 0x7a8b, 0x818b, 0x828b, 0x838b, 0x848b, 0x858b,
	0x868b, 0x878b, 0x888b, 0x898b, 0x8a8b, 0x8b8b, 0x8c8b, 0x8d8b,
	0x8e8b, 0x8f8b, 0x908b, 0x918b, 0x928b, 0x938b, 0x948b, 0x958b,
	0x968b, 0x978b, 0x988b, 0x998b, 0x9a8b, 0x9b8b, 0x9c8b, 0x9d8b,
	0x9e8b, 0x9f8b, 0xa08b, 0xa18b, 0xa28b, 0xa38b, 0xa48b, 0xa58b,
	0xa68b, 0xa78b, 0xa88b, 0xa98b, 0xaa8b, 0xab8b, 0xac8b, 0xad8b,
	0xae8b, 0xaf8b, 0xb08b, 0xb18b, 0xb28b, 0xb38b, 0xb48b, 0xb58b,
	0xb0b6, 0xb1b6, 0xb68b, 0xb78b, 0xb2b6, 0xb88b, 0xb98b, 0xba8b,
	0xb3b6, 0xbb8b, 0xb4b6, 0xb5b6, 0xbc8b, 0xbd8b, 0xbe8b, 0xbf8b,
	0xb6b6, 0xb7b6, 0xc08b, 0xb8b6, 0xb9b6, 0xbab6, 0xc18b, 0xc28b,
	0xc38b, 0xc48b, 0xc58b, 0xbbb6, 0xbcb6, 0xbdb6, 0xc68b, 0xc78b,
	0xbeb6, 0xc88b, 0xc98b, 0xca8b, 0xbfb6, 0xcb8b, 0xcc8b, 0xcd8b,
	0xce8b, 0xcf8b, 0xd08b, 0xd18b, 0xc0b6, 0xc1b6, 0xd28b, 0xc2b6,
	0xc3b6, 0xc4b6, 0xd38b, 0xd48b, 0xd58b, 0xd68b, 0xd78b, 0xd88b,
	0xc5b6, 0xd98b, 0xda8b, 0xdb8b, 0xdc8b, 0xdd8b, 0xde8b, 0xdf8b,
	0xe08b, 0xe18b, 0xe28b, 0xe38b, 0xe48b, 0xe58b, 0xe68b, 0xe78b,
	0xe88b, 0xe98b, 0xea8b, 0xeb8b, 0xc6b6, 0xec8b, 0xed8b, 0xee8b,
	0xef8b, 0xf08b, 0xf18b, 0xf28b, 0xf38b, 0xf48b, 0xf58b, 0xf68b,
	0xf78b, 0xf88b, 0xf98b, 0xfa8b, 0xfb8b, 0xfc8b, 0xfd8b, 0xfe8b,
	0x418c, 0x428c, 0x438c, 0x448c, 0x458c, 0x468c, 0x478c, 0x488c,
	0x498c, 0x4a8c, 0x4b8c, 0x4c8c, 0x4d8c, 0x4e8c, 0x4f8c, 0x508c,
	0xc7b6, 0xc8b6, 0x518c, 0x528c, 0xc9b6, 0x538c, 0x548c, 0x558c,
	0xcab6, 0x568c, 0x578c, 0x588c, 0x598c, 0x5a8c, 0x618c, 0x628c,
	0x638c, 0x648c, 0x658c, 0x668c, 0x678c, 0xcbb6, 0x688c, 0x698c,
	0x6a8c, 0x6b8c, 0x6c8c, 0x6d8c, 0xccb6, 0x6e8c, 0x6f8c, 0x708c,
	0x718c, 0x728c, 0x738c, 0x748c, 0xcdb6, 0x758c, 0x768c, 0x778c,
	0x788c, 0x798c, 0x7a8c, 0x818c, 0x828c, 0x838c, 0x848c, 0x858c,
	0x868c, 0x878c, 0x888c, 0x898c, 0x8a8c, 0x8b8c, 0x8c8c, 0x8d8c,
	0xceb6, 0x8e8c, 0x8f8c, 0x908c, 0x918c, 0x928c, 0x938c, 0x948c,
	0x958c, 0x968c, 0x978c, 0x988c, 0x998c, 0x9a8c, 0x9b8c, 0x9c8c,
	0x9d8c, 0x9e8c, 0x9f8c, 0xa08c, 0xa18c, 0xa28c, 0xa38c, 0xa48c,
	0xa58c, 0xa68c, 0xa78c, 0xa88c, 0xcfb6, 0xa98c, 0xaa8c, 0xab8c,
	0xd0b6, 0xac8c, 0xad8c, 0xae8c, 0xaf8c, 0xb08c, 0xb18c, 0xb28c,
	0xb38c, 0xb48c, 0xb58c, 0xb68c, 0xb78c, 0xb88c, 0xb98c, 0xba8c,
	0xbb8c, 0xbc8c, 0xbd8c, 0xbe8c, 0xbf8c, 0xc08c, 0xc18c, 0xc28c,
	0xc38c, 0xc48c, 0xc58c, 0xc68c, 0xc78c, 0xc88c, 0xc98c, 0xca8c,
	0xcb8c, 0xcc8c, 0xcd8c, 0xce8c, 0xcf8c, 0xd08c, 0xd18c, 0xd28c,
	0xd38c, 0xd48c, 0xd58c, 0xd68c, 0xd78c, 0xd88c, 0xd98c, 0xda8c,
	0xdb8c, 0xdc8c, 0xdd8c, 0xde8c, 0xd1b6, 0xd2b6, 0xdf8c, 0xe08c,
	0xd3b6, 0xe18c, 0xe28c, 0xe38c, 0xd4b6, 0xe48c, 0xe58c, 0xe68c,
	0xe78c, 0xe88c, 0xe98c, 0xd5b6, 0xd6b6, 0xea8c, 0xeb8c, 0xec8c,
	0xed8c, 0xd7b6, 0xee8c, 0xef8c, 0xf08c, 0xf18c, 0xf28c, 0xf38c,
	0xf48c, 0xf58c, 0xf68c, 0xf78c, 0xf88c, 0xf98c, 0xfa8c, 0xfb8c,
	0xfc8c, 0xfd8c, 0xfe8c, 0x418d, 0x428d, 0x438d, 0x448d, 0x458d,
	0x468d, 0x478d, 0x488d, 0x498d, 0x4a8d, 0x4b8d, 0x4c8d, 0x4d8d,
	0x4e8d, 0x4f8d, 0x508d, 0x518d, 0xd8b6, 0x528d, 0x538d, 0x548d,
	0x558d, 0x568d, 0x578d, 0x588d, 0x598d, 0x5a8d, 0x618d, 0x628d,
	0x638d, 0x648d, 0x658d, 0x668d, 0x678d, 0x688d, 0x698d, 0x6a8d,
	0x6b8d, 0x6c8d, 0x6d8d, 0x6e8d, 0x6f8d, 0x708d, 0x718d, 0x728d,
	0xd9b6, 0x738d, 0x748d, 0x758d, 0xdab6, 0x768d, 0x778d, 0x788d,
	0xdbb6, 0x798d, 0x7a8d, 0x818d, 0x828d, 0x838d, 0x848d, 0x858d,
	0xdcb6, 0xddb6, 0x868d, 0x878d, 0x888d, 0xdeb6, 0x898d, 0x8a8d,
	0x8b8d, 0x8c8d, 0x8d8d, 0x8e8d, 0x8f8d, 0x908d, 0x918d, 0x928d,
	0x938d, 0x948d, 0x958d, 0x968d, 0x978d, 0x988d, 0x998d, 0x9a8d,
	0x9b8d, 0x9c8d, 0x9d8d, 0x9e8d, 0x9f8d, 0xa08d, 0xa18d, 0xa28d,
	0xa38d, 0xa48d, 0xa58d, 0xa68d, 0xa78d, 0xa88d, 0xa98d, 0xaa8d,
	0xdfb6, 0xe0b6, 0xab8d, 0xac8d, 0xe1b6, 0xad8d, 0xae8d, 0xe2b6,
	0xe3b6, 0xaf8d, 0xb08d, 0xb18d, 0xb28d, 0xb38d, 0xb48d, 0xb58d,
	0xe4b6, 0xe5b6, 0xb68d, 0xe6b6, 0xb78d, 0xb88d, 0xb98d, 0xba8d,
	0xbb8d, 0xbc8d, 0xbd8d, 0xbe8d, 0xe7b6, 0xbf8d, 0xc08d, 0xc18d,
	0xe8b6, 0xc28d, 0xc38d, 0xc48d, 0xe9b6, 0xc58d, 0xc68d, 0xc78d,
	0xc88d, 0xc98d, 0xca8d, 0xcb8d, 0xeab6, 0xebb6, 0xcc8d, 0xcd8d,
	0xce8d, 0xcf8d, 0xd08d, 0xd18d, 0xd28d, 0xd38d, 0xd48d, 0xd58d,
	0xecb6, 0xd68d, 0xd78d, 0xd88d, 0xedb6, 0xd98d, 0xda8d, 0xdb8d,
	0xeeb6, 0xdc8d, 0xdd8d, 0xde8d, 0xdf8d, 0xe08d, 0xe18d, 0xe28d,
	0xefb6, 0xf0b6, 0xe38d, 0xf1b6, 0xe48d, 0xf2b6, 0xe58d, 0xe68d,
	0xe78d, 0xe88d, 0xe98d, 0xea8d, 0xf3b6, 0xf4b6, 0xeb8d, 0xec8d,
	0xf5b6, 0xed8d, 0xee8d, 0xef8d, 0xf6b6, 0xf08d, 0xf18d, 0xf28d,
	0xf38d, 0xf48d, 0xf58d, 0xf68d, 0xf7b6, 0xf8b6, 0xf78d, 0xf9b6,
	0xfab6, 0xfbb6, 0xfcb6, 0xf88d, 0xf98d, 0xfa8d, 0xfdb6, 0xfeb6,
	0xa1b7, 0xa2b7, 0xfb8d, 0xfc8d, 0xa3b7, 0xfd8d, 0xfe8d, 0x418e,
	0xa4b7, 0x428e, 0x438e, 0x448e, 0x458e, 0x468e, 0x478e, 0x488e,
	0xa5b7, 0xa6b7, 0x498e, 0xa7b7, 0xa8b7, 0xa9b7, 0x4a8e, 0x4b8e,
	0x4c8e, 0x4d8e, 0x4e8e, 0x4f8e, 0xaab7, 0xabb7, 0x508e, 0x518e,
	0xacb7, 0x528e, 0x538e, 0x548e, 0x558e, 0x568e, 0x578e, 0x588e,
	0x598e, 0x5a8e, 0x618e, 0x628e, 0x638e, 0x648e, 0x658e, 0xadb7,
	0x668e, 0xaeb7, 0x678e, 0x688e, 0x698e, 0x6a8e, 0x6b8e, 0x6c8e,
	0x6d8e, 0x6e8e, 0x6f8e, 0x708e, 0x718e, 0x728e, 0x738e, 0x748e,
	0x758e, 0x768e, 0x778e, 0x788e, 0x798e, 0x7a8e, 0x818e, 0x828e,
	0x838e, 0x848e, 0x858e, 0x868e, 0x878e, 0x888e, 0x898e, 0x8a8e,
	0x8b8e, 0x8c8e, 0x8d8e, 0x8e8e, 0xafb7, 0xb0b7, 0x8f8e, 0x908e,
	0xb1b7, 0x918e, 0x928e, 0x938e, 0xb2b7, 0x948e, 0x958e, 0x968e,
	0x978e, 0x988e, 0x998e, 0x9a8e, 0xb3b7, 0xb4b7, 0x9b8e, 0xb5b7,
	0xb6b7, 0xb7b7, 0x9c8e, 0x9d8e, 0x9e8e, 0x9f8e, 0xa08e, 0xb8b7,
	0xb9b7, 0xbab7, 0xa18e, 0xa28e, 0xbbb7, 0xa38e, 0xa48e, 0xa58e,
	0xbcb7, 0xa68e, 0xa78e, 0xa88e, 0xa98e, 0xaa8e, 0xab8e, 0xac8e,
	0xbdb7, 0xbeb7, 0xad8e, 0xbfb7, 0xae8e, 0xc0b7, 0xaf8e, 0xb08e,
	0xb18e, 0xb28e, 0xb38e, 0xb48e, 0xc1b7, 0xc2b7, 0xb58e, 0xb68e,
	0xc3b7, 0xb78e, 0xb88e, 0xb98e, 0xc4b7, 0xba8e, 0xbb8e, 0xbc8e,
	0xbd8e, 0xbe8e, 0xbf8e, 0xc08e, 0xc5b7, 0xc6b7, 0xc18e, 0xc7b7,
	0xc8b7, 0xc9b7, 0xc28e, 0xc38e, 0xc48e, 0xc58e, 0xc68e, 0xc78e,
	0xcab7, 0xc88e, 0xc98e, 0xca8e, 0xcbb7, 0xcb8e, 0xcc8e, 0xcd8e,
	0xce8e, 0xcf8e, 0xd08e, 0xd18e, 0xd28e, 0xd38e, 0xd48e, 0xd58e,
	0xd68e, 0xccb7, 0xd78e, 0xcdb7, 0xd88e, 0xd98e, 0xda8e, 0xdb8e,
	0xdc8e, 0xdd8e, 0xde8e, 0xdf8e, 0xceb7, 0xcfb7, 0xe08e, 0xe18e,
	0xd0b7, 0xe28e, 0xe38e, 0xe48e, 0xd1b7, 0xe58e, 0xe68e, 0xe78e,
	0xe88e, 0xe98e, 0xea8e, 0xeb8e, 0xd2b7, 0xd3b7, 0xec8e, 0xd4b7,
	0xed8e, 0xd5b7, 0xee8e, 0xef8e, 0xf08e, 0xf18e, 0xf28e, 0xf38e,
	0xd6b7, 0xf48e, 0xf58e, 0xf68e, 0xd7b7, 0xf78e, 0xf88e, 0xf98e,
	0xfa8e, 0xfb8e, 0xfc8e, 0xfd8e, 0xfe8e, 0x418f, 0x428f, 0x438f,
	0x448f, 0x458f, 0x468f, 0x478f, 0x488f, 0xd8b7, 0x498f, 0x4a8f,
	0x4b8f, 0x4c8f, 0x4d8f, 0x4e8f, 0x4f8f, 0x508f, 0x518f, 0x528f,
	0x538f, 0x548f, 0x558f, 0x568f, 0x578f, 0x588f, 0x598f, 0x5a8f,
	0x618f, 0x628f, 0x638f, 0x648f, 0x658f, 0x668f, 0x678f, 0x688f,
	0xd9b7, 0x698f, 0x6a8f, 0x6b8f, 0x6c8f, 0x6d8f, 0x6e8f, 0x6f8f,
	0xdab7, 0x708f, 0x718f, 0x728f, 0xdbb7, 0x738f, 0x748f, 0x758f,
	0xdcb7, 0x768f, 0x778f, 0x788f, 0x798f, 0x7a8f, 0x818f, 0x828f,
	0xddb7, 0xdeb7, 0x838f, 0xdfb7, 0x848f, 0xe0b7, 0x858f, 0x868f,
	0x878f, 0x888f, 0x898f, 0x8a8f, 0xe1b7, 0x8b8f, 0x8c8f, 0x8d8f,
	0xe2b7, 0x8e8f, 0x8f8f, 0x908f, 0xe3b7, 0x918f, 0x928f, 0x938f,
	0x948f, 0x958f, 0x968f, 0x978f, 0x988f, 0xe4b7, 0x998f, 0xe5b7,
	0x9a8f, 0xe6b7, 0x9b8f, 0x9c8f, 0x9d8f, 0x9e8f, 0x9f8f, 0xa08f,
	0xe7b7, 0xe8b7, 0xa18f, 0xa28f, 0xe9b7, 0xa38f, 0xa48f, 0xa58f,
	0xeab7, 0xa68f, 0xa78f, 0xa88f, 0xa98f, 0xaa8f, 0xab8f, 0xac8f,
	0xebb7, 0xecb7, 0xad8f, 0xedb7, 0xae8f, 0xeeb7, 0xaf8f, 0xb08f,
	0xb18f, 0xb28f, 0xb38f, 0xb48f, 0xefb7, 0xb58f, 0xb68f, 0xb78f,
	0xb88f, 0xb98f, 0xba8f, 0xbb8f, 0xbc8f, 0xbd8f, 0xbe8f, 0xbf8f,
	0xc08f, 0xc18f, 0xc28f, 0xc38f, 0xc48f, 0xc58f, 0xc68f, 0xc78f,
	0xf0b7, 0xc88f, 0xc98f, 0xca8f, 0xcb8f, 0xcc8f, 0xcd8f, 0xce8f,
	0xf1b7, 0xcf8f, 0xd08f, 0xd18f, 0xd28f, 0xd38f, 0xd48f, 0xd58f,
	0xd68f, 0xd78f, 0xd88f, 0xd98f, 0xda8f, 0xdb8f, 0xdc8f, 0xdd8f,
	0xde8f, 0xdf8f, 0xe08f, 0xe18f, 0xe28f, 0xe38f, 0xe48f, 0xe58f,
	0xe68f, 0xe78f, 0xe88f, 0xe98f, 0xf2b7, 0xf3b7, 0xea8f, 0xeb8f,
	0xf4b7, 0xec8f, 0xed8f, 0xee8f, 0xf5b7, 0xef8f, 0xf08f, 0xf18f,
	0xf28f, 0xf38f, 0xf48f, 0xf58f, 0xf6b7, 0xf68f, 0xf78f, 0xf7b7,
	0xf88f, 0xf8b7, 0xf98f, 0xfa8f, 0xfb8f, 0xfc8f, 0xfd8f, 0xfe8f,
	0xf9b7, 0xfab7, 0x4190, 0x4290, 0xfbb7, 0x4390, 0x4490, 0x4590,
	0xfcb7, 0x4690, 0x4790, 0x4890, 0x4990, 0x4a90, 0x4b90, 0x4c90,
	0xfdb7, 0xfeb7, 0x4d90, 0xa1b8, 0x4e90, 0xa2b8, 0x4f90, 0x5090,
	0x5190, 0x5290, 0x5390, 0x5490, 0xa3b8, 0xa4b8, 0x5590, 0x5690,
	0xa5b8, 0x5790, 0x5890, 0x5990, 0xa6b8, 0x5a90, 0x6190, 0x6290,
	0x6390, 0x6490, 0x6590, 0x6690, 0xa7b8, 0xa8b8, 0x6790, 0xa9b8,
	0x6890, 0xaab8, 0xabb8, 0x6990, 0x6a90, 0xacb8, 0xadb8, 0x6b90,
	0x6c90, 0x6d90, 0x6e90, 0x6f90, 0x7090, 0x7190, 0x7290, 0x7390,
	0x7490, 0x7590, 0x7690, 0x7790, 0x7890, 0x7990, 0x7a90, 0x8190,
	0x8290, 0x8390, 0x8490, 0x8590, 0x8690, 0x8790, 0x8890, 0x8990,
	0x8a90, 0x8b90, 0x8c90, 0x8d90, 0xaeb8, 0xafb8, 0x8e90, 0x8f90,
	0xb0b8, 0x9090, 0x9190, 0x9290, 0xb1b8, 0x9390, 0x9490, 0x9590,
	0x9690, 0x9790, 0x9890, 0x9990, 0xb2b8, 0xb3b8, 0x9a90, 0xb4b8,
	0x9b90, 0xb5b8, 0x9c90, 0x9d90, 0x9e90, 0x9f90, 0xa090, 0xa190,
	0xb6b8, 0xb7b8, 0xa290, 0xa390, 0xb8b8, 0xa490, 0xb9b8, 0xbab8,
	0xbbb8, 0xbcb8, 0xbdb8, 0xa590, 0xa690, 0xa790, 0xa890, 0xa990,
	0xbeb8, 0xbfb8, 0xaa90, 0xc0b8, 0xab90, 0xc1b8, 0xc2b8, 0xac90,
	0xad90, 0xc3b8, 0xae90, 0xc4b8, 0xc5b8, 0xc6b8, 0xaf90, 0xb090,
	0xc7b8, 0xb190, 0xb290, 0xb390, 0xc8b8, 0xb490, 0xb590, 0xb690,
	0xb790, 0xb890, 0xb990, 0xba90, 0xc9b8, 0xcab8, 0xbb90, 0xcbb8,
	0xccb8, 0xcdb8, 0xceb8, 0xbc90, 0xbd90, 0xbe90, 0xbf90, 0xc090,
	0xcfb8, 0xd0b8, 0xc190, 0xc290, 0xc390, 0xc490, 0xc590, 0xc690,
	0xd1b8, 0xc790, 0xc890, 0xc990, 0xca90, 0xcb90, 0xcc90, 0xcd90,
	0xce90, 0xcf90, 0xd090, 0xd190, 0xd290, 0xd2b8, 0xd390, 0xd490,
	0xd590, 0xd690, 0xd790, 0xd890, 0xd990, 0xda90, 0xdb90, 0xdc90,
	0xdd90, 0xde90, 0xdf90, 0xe090, 0xe190, 0xe290, 0xe390, 0xe490,
	0xe590, 0xe690, 0xe790, 0xe890, 0xe990, 0xea90, 0xeb90, 0xec90,
	0xed90, 0xee90, 0xef90, 0xf090, 0xf190, 0xf290, 0xf390, 0xf490,
	0xd3b8, 0xd4b8, 0xf590, 0xf690, 0xd5b8, 0xf790, 0xf890, 0xf990,
	0xd6b8, 0xfa90, 0xd7b8, 0xfb90, 0xfc90, 0xfd90, 0xfe90, 0x4191,
	0xd8b8, 0xd9b8, 0x4291, 0xdab8, 0x4391, 0xdbb8, 0xdcb8, 0x4491,
	0x4591, 0x4691, 0x4791, 0xddb8, 0xdeb8, 0xdfb8, 0x4891, 0x4991,
	0xe0b8, 0x4a91, 0x4b91, 0x4c91, 0xe1b8, 0x4d91, 0x4e91, 0x4f91,
	0x5091, 0x5191, 0x5291, 0x5391, 0xe2b8, 0xe3b8, 0x5491, 0xe4b8,
	0xe5b8, 0xe6b8, 0x5591, 0x5691, 0x5791, 0x5891, 0x5991, 0x5a91,
	0xe7b8, 0xe8b8, 0x6191, 0x6291, 0xe9b8, 0x6391, 0x6491, 0x6591,
	0xeab8, 0x6691, 0x6791, 0x6891, 0x6991, 0x6a91, 0x6b91, 0x6c91,
	0x6d91, 0x6e91, 0x6f91, 0xebb8, 0xecb8, 0xedb8, 0x7091, 0xeeb8,
	0x7191, 0x7291, 0x7391, 0x7491, 0xefb8, 0x7591, 0x7691, 0x7791,
	0x7891, 0x7991, 0x7a91, 0x8191, 0x8291, 0x8391, 0x8491, 0x8591,
	0x8691, 0x8791, 0x8891, 0x8991, 0x8a91, 0x8b91, 0x8c91, 0x8d91,
	0x8e91, 0x8f91, 0x9091, 0x9191, 0x9291, 0x9391, 0x9491, 0x9591,
	0xf0b8, 0xf1b8, 0x9691, 0xf2b8, 0xf3b8, 0x9791, 0x9891, 0x9991,
	0xf4b8, 0x9a91, 0xf5b8, 0x9b91, 0x9c91, 0x9d91, 0x9e91, 0x9f91,
	0xf6b8, 0xf7b8, 0xa091, 0xf8b8, 0xa191, 0xf9b8, 0xa291, 0xa391,
	0xa491, 0xa591, 0xa691, 0xa791, 0xfab8, 0xa891, 0xa991, 0xaa91,
	0xfbb8, 0xab91, 0xac91, 0xad91, 0xae91, 0xaf91, 0xb091, 0xb191,
	0xb291, 0xb391, 0xb491, 0xb591, 0xb691, 0xb791, 0xb891, 0xb991,
	0xfcb8, 0xfdb8, 0xba91, 0xbb91, 0xbc91, 0xbd91, 0xbe91, 0xbf91,
	0xc091, 0xc191, 0xc291, 0xc391, 0xc491, 0xc591, 0xc691, 0xc791,
	0xc891, 0xc991, 0xca91, 0xcb91, 0xcc91, 0xcd91, 0xce91, 0xcf91,
	0xd091, 0xd191, 0xd291, 0xd391, 0xd491, 0xd591, 0xd691, 0xd791,
	0xd891, 0xd991, 0xda91, 0xdb91, 0xfeb8, 0xdc91, 0xdd91, 0xde91,
	0xa1b9, 0xdf91, 0xe091, 0xe191, 0xa2b9, 0xe291, 0xe391, 0xe491,
	0xe591, 0xe691, 0xe791, 0xe891, 0xe991, 0xa3b9, 0xea91, 0xa4b9,
	0xeb91, 0xa5b9, 0xec91, 0xed91, 0xee91, 0xef91, 0xf091, 0xf191,
	0xa6b9, 0xf291, 0xf391, 0xf491, 0xa7b9, 0xf591, 0xf691, 0xf791,
	0xa8b9, 0xf891, 0xf991, 0xfa91, 0xfb91, 0xfc91, 0xfd91, 0xfe91,
	0x4192, 0xa9b9, 0x4292, 0xaab9, 0x4392, 0x4492, 0x4592, 0x4692,
	0x4792, 0x4892, 0x4992, 0x4a92, 0xabb9, 0xacb9, 0xadb9, 0x4b92,
	0xaeb9, 0x4c92, 0x4d92, 0xafb9, 0xb0b9, 0xb1b9, 0xb2b9, 0x4e92,
	0x4f92, 0x5092, 0x5192, 0x5292, 0xb3b9, 0xb4b9, 0x5392, 0xb5b9,
	0x5492, 0xb6b9, 0x5592, 0x5692, 0x5792, 0xb7b9, 0x5892, 0xb8b9,
	0xb9b9, 0x5992, 0x5a92, 0x6192, 0xbab9, 0x6292, 0x6392, 0x6492,
	0xbbb9, 0x6592, 0x6692, 0x6792, 0x6892, 0x6992, 0x6a92, 0x6b92,
	0x6c92, 0xbcb9, 0x6d92, 0xbdb9, 0x6e92, 0x6f92, 0x7092, 0x7192,
	0x7292, 0x7392, 0x7492, 0x7592, 0xbeb9, 0x7692, 0x7792, 0x7892,
	0x7992, 0x7a92, 0x8192, 0x8292, 0x8392, 0x8492, 0x8592, 0x8692,
	0x8792, 0x8892, 0x8992, 0x8a92, 0x8b92, 0x8c92, 0x8d92, 0x8e92,
	0x8f92, 0x9092, 0x9192, 0x9292, 0x9392, 0x9492, 0x9592, 0x9692,
	0xbfb9, 0x9792, 0x9892, 0x9992, 0xc0b9, 0x9a92, 0x9b92, 0x9c92,
	0xc1b9, 0x9d92, 0x9e92, 0x9f92, 0xa092, 0xa192, 0xa292, 0xa392,
	0xa492, 0xa592, 0xa692, 0xa792, 0xa892, 0xa992, 0xaa92, 0xab92,
	0xac92, 0xad92, 0xae92, 0xaf92, 0xc2b9, 0xb092, 0xb192, 0xb292,
	0xc3b9, 0xb392, 0xb492, 0xb592, 0xc4b9, 0xb692, 0xb792, 0xb892,
	0xb992, 0xba92, 0xbb92, 0xbc92, 0xc5b9, 0xbd92, 0xbe92, 0xc6b9,
	0xbf92, 0xc092, 0xc192, 0xc292, 0xc392, 0xc492, 0xc592, 0xc692,
	0xc7b9, 0xc792, 0xc892, 0xc992, 0xc8b9, 0xca92, 0xcb92, 0xcc92,
	0xc9b9, 0xcd92, 0xce92, 0xcf92, 0xd092, 0xd192, 0xd292, 0xd392,
	0xcab9, 0xd492, 0xd592, 0xcbb9, 0xd692, 0xd792, 0xd892, 0xd992,
	0xda92, 0xdb92, 0xdc92, 0xdd92, 0xde92, 0xdf92, 0xe092, 0xe192,
	0xe292, 0xe392, 0xe492, 0xe592, 0xe692, 0xe792, 0xe892, 0xe992,
	0xea92, 0xeb92, 0xec92, 0xed92, 0xee92, 0xef92, 0xf092, 0xf192,
	0xf292, 0xf392, 0xf492, 0xf592, 0xf692, 0xf792, 0xf892, 0xf992,
	0xccb9, 0xcdb9, 0xfa92, 0xfb92, 0xceb9, 0xfc92, 0xfd92, 0xcfb9,
	0xd0b9, 0xfe92, 0xd1b9, 0x4193, 0x4293, 0x4393, 0x4493, 0x4593,
	0xd2b9, 0xd3b9, 0x4693, 0xd4b9, 0xd5b9, 0xd6b9, 0x4793, 0xd7b9,
	0x4893, 0xd8b9, 0x4993, 0x4a93, 0xd9b9, 0xdab9, 0xdbb9, 0xdcb9,
	0xddb9, 0x4b93, 0x4c93, 0xdeb9, 0xdfb9, 0xe0b9, 0xe1b9, 0xe2b9,
	0x4d93, 0x4e93, 0x4f93, 0x5093, 0xe3b9, 0xe4b9, 0x5193, 0xe5b9,
	0x5293, 0xe6b9, 0x5393, 0x5493, 0x5593, 0xe7b9, 0x5693, 0x5793,
	0xe8b9, 0xe9b9, 0x5893, 0x5993, 0xeab9, 0x5a93, 0x6193, 0x6293,
	0xebb9, 0x6393, 0x6493, 0x6593, 0x6693, 0x6793, 0x6893, 0x6993,
	0xecb9, 0xedb9, 0x6a93, 0xeeb9, 0xefb9, 0xf0b9, 0x6b93, 0x6c93,
	0x6d93, 0xf1b9, 0x6e93, 0x6f93, 0xf2b9, 0xf3b9, 0x7093, 0x7193,
	0xf4b9, 0x7293, 0x7393, 0x7493, 0x7593, 0x7693, 0x7793, 0x7893,
	0x7993, 0x7a93, 0x8193, 0x8293, 0x8393, 0xf5b9, 0x8493, 0x8593,
	0x8693, 0x8793, 0x8893, 0x8993, 0x8a93, 0x8b93, 0x8c93, 0x8d93,
	0x8e93, 0x8f93, 0x9093, 0x9193, 0x9293, 0x9393, 0x9493, 0x9593,
	0x9693, 0x9793, 0x9893, 0x9993, 0x9a93, 0x9b93, 0x9c93, 0x9d93,
	0x9e93, 0x9f93, 0xa093, 0xa193, 0xa293, 0xa393, 0xa493, 0xa593,
	0xa693, 0xa793, 0xa893, 0xa993, 0xf6b9, 0xf7b9, 0xaa93, 0xab93,
	0xf8b9, 0xac93, 0xad93, 0xf9b9, 0xfab9, 0xae93, 0xfbb9, 0xaf93,
	0xb093, 0xb193, 0xb293, 0xb393, 0xfcb9, 0xfdb9, 0xb493, 0xfeb9,
	0xb593, 0xa1ba, 0xa2ba, 0xb693, 0xb793, 0xb893, 0xb993, 0xba93,
	0xa3ba, 0xa4ba, 0xbb93, 0xbc93, 0xa5ba, 0xbd93, 0xbe93, 0xa6ba,
	0xa7ba, 0xbf93, 0xc093, 0xc193, 0xc293, 0xc393, 0xc493, 0xc593,
	0xa8ba, 0xa9ba, 0xc693, 0xaaba, 0xabba, 0xacba, 0xc793, 0xc893,
	0xc993, 0xca93, 0xcb93, 0xcc93, 0xadba, 0xaeba, 0xcd93, 0xce93,
	0xafba, 0xcf93, 0xd093, 0xd193, 0xb0ba, 0xd293, 0xd393, 0xd493,
	0xd593, 0xd693, 0xd793, 0xd893, 0xd993, 0xb1ba, 0xda93, 0xb2ba,
	0xb3ba, 0xb4ba, 0xdb93, 0xdc93, 0xdd93, 0xb5ba, 0xde93, 0xdf93,
	0xb6ba, 0xe093, 0xe193, 0xe293, 0xb7ba, 0xe393, 0xe493, 0xe593,
	0xe693, 0xe793, 0xe893, 0xe993, 0xea93, 0xeb93, 0xec93, 0xed93,
	0xee93, 0xef93, 0xf093, 0xf193, 0xf293, 0xf393, 0xf493, 0xf593,
	0xf693, 0xf793, 0xf893, 0xf993, 0xb8ba, 0xb9ba, 0xbaba, 0xfa93,
	0xbbba, 0xfb93, 0xfc93, 0xfd93, 0xbcba, 0xfe93, 0x4194, 0x4294,
	0x4394, 0x4494, 0x4594, 0x4694, 0xbdba, 0xbeba, 0x4794, 0xbfba,
	0x4894, 0xc0ba, 0x4994, 0x4a94, 0x4b94, 0x4c94, 0x4d94, 0x4e94,
	0xc1ba, 0x4f94, 0x5094, 0x5194, 0xc2ba, 0x5294, 0x5394, 0x5494,
	0x5594, 0x5694, 0x5794, 0x5894, 0x5994, 0x5a94, 0x6194, 0x6294,
	0x6394, 0x6494, 0x6594, 0x6694, 0xc3ba, 0x6794, 0x6894, 0x6994,
	0x6a94, 0x6b94, 0x6c94, 0x6d94, 0xc4ba, 0x6e94, 0x6f94, 0x7094,
	0x7194, 0x7294, 0x7394, 0x7494, 0x7594, 0x7694, 0x7794, 0x7894,
	0x7994, 0x7a94, 0x8194, 0x8294, 0x8394, 0x8494, 0x8594, 0x8694,
	0xc5ba, 0x8794, 0x8894, 0x8994, 0x8a94, 0x8b94, 0x8c94, 0x8d94,
	0xc6ba, 0xc7ba, 0x8e94, 0x8f94, 0xc8ba, 0x9094, 0x9194, 0x9294,
	0xc9ba, 0x9394, 0x9494, 0x9594, 0x9694, 0x9794, 0x9894, 0x9994,
	0xcaba, 0xcbba, 0x9a94, 0x9b94, 0x9c94, 0x9d94, 0x9e94, 0x9f94,
	0xa094, 0xa194, 0xa294, 0xa394, 0xccba, 0xa494, 0xa594, 0xa694,
	0xcdba, 0xa794, 0xa894, 0xa994, 0xaa94, 0xab94, 0xac94, 0xad94,
	0xae94, 0xaf94, 0xb094, 0xb194, 0xb294, 0xb394, 0xb494, 0xb594,
	0xb694, 0xb794, 0xb894, 0xb994, 0xba94, 0xbb94, 0xbc94, 0xbd94,
	0xceba, 0xcfba, 0xbe94, 0xbf94, 0xd0ba, 0xc094, 0xc194, 0xd1ba,
	0xd2ba, 0xd3ba, 0xd4ba, 0xc294, 0xc394, 0xc494, 0xc594, 0xc694,
	0xd5ba, 0xd6ba, 0xc794, 0xd7ba, 0xc894, 0xd8ba, 0xc994, 0xca94,
	0xcb94, 0xd9ba, 0xdaba, 0xcc94, 0xdbba, 0xcd94, 0xce94, 0xcf94,
	0xd094, 0xd194, 0xd294, 0xd394, 0xdcba, 0xd494, 0xd594, 0xd694,
	0xd794, 0xd894, 0xd994, 0xda94, 0xdb94, 0xdc94, 0xdd94, 0xde94,
	0xddba, 0xdf94, 0xe094, 0xe194, 0xe294, 0xe394, 0xe494, 0xe594,
	0xdeba, 0xe694, 0xe794, 0xe894, 0xe994, 0xea94, 0xeb94, 0xec94,
	0xed94, 0xee94, 0xef94, 0xf094, 0xf194, 0xf294, 0xf394, 0xf494,
	0xf594, 0xf694, 0xf794, 0xf894, 0xf994, 0xfa94, 0xfb94, 0xfc94,
	0xfd94, 0xfe94, 0x4195, 0x4295, 0xdfba, 0xe0ba, 0x4395, 0x4495,
	0xe1ba, 0x4595, 0x4695, 0x4795, 0xe2ba, 0x4895, 0x4995, 0x4a95,
	0x4b95, 0x4c95, 0x4d95, 0x4e95, 0x4f95, 0x5095, 0x5195, 0x5295,
	0x5395, 0xe3ba, 0x5495, 0x5595, 0x5695, 0x5795, 0x5895, 0x5995,
	0xe4ba, 0x5a95, 0x6195, 0x6295, 0xe5ba, 0x6395, 0x6495, 0x6595,
	0xe6ba, 0x6695, 0x6795, 0x6895, 0x6995, 0x6a95, 0x6b95, 0x6c95,
	0xe7ba, 0x6d95, 0x6e95, 0xe8ba, 0x6f95, 0xe9ba, 0x7095, 0x7195,
	0x7295, 0x7395, 0x7495, 0x7595, 0xeaba, 0xebba, 0x7695, 0x7795,
	0xecba, 0x7895, 0x7995, 0x7a95, 0xedba, 0x8195, 0x8295, 0x8395,
	0x8495, 0x8595, 0x8695, 0x8795, 0xeeba, 0xefba, 0x8895, 0xf0ba,
	0x8995, 0x8a95, 0x8b95, 0x8c95, 0x8d95, 0x8e95, 0x8f95, 0x9095,
	0x9195, 0x9295, 0x9395, 0x9495, 0x9595, 0x9695, 0x9795, 0x9895,
	0x9995, 0x9a95, 0x9b95, 0x9c95, 0x9d95, 0x9e95, 0x9f95, 0xa095,
	0xa195, 0xa295, 0xa395, 0xa495, 0xa595, 0xa695, 0xa795, 0xa895,
	0xa995, 0xaa95, 0xab95, 0xac95, 0xf1ba, 0xf2ba, 0xad95, 0xae95,
	0xf3ba, 0xaf95, 0xb095, 0xb195, 0xf4ba, 0xb295, 0xf5ba, 0xb395,
	0xb495, 0xb595, 0xb695, 0xb795, 0xf6ba, 0xf7ba, 0xb895, 0xf8ba,
	0xb995, 0xf9ba, 0xfaba, 0xfbba, 0xba95, 0xbb95, 0xbc95, 0xbd95,
	0xfcba, 0xfdba, 0xbe95, 0xbf95, 0xfeba, 0xc095, 0xc195, 0xc295,
	0xa1bb, 0xc395, 0xa2bb, 0xc495, 0xc595, 0xc695, 0xc795, 0xc895,
	0xa3bb, 0xa4bb, 0xc995, 0xa5bb, 0xa6bb, 0xa7bb, 0xca95, 0xcb95,
	0xcc95, 0xcd95, 0xce95, 0xa8bb, 0xa9bb, 0xaabb, 0xcf95, 0xd095,
	0xabbb, 0xd195, 0xd295, 0xd395, 0xacbb, 0xd495, 0xd595, 0xd695,
	0xd795, 0xd895, 0xd995, 0xda95, 0xadbb, 0xaebb, 0xdb95, 0xafbb,
	0xb0bb, 0xb1bb, 0xdc95, 0xdd95, 0xde95, 0xdf95, 0xe095, 0xe195,
	0xb2bb, 0xb3bb, 0xe295, 0xe395, 0xe495, 0xe595, 0xe695, 0xe795,
	0xe895, 0xe995, 0xea95, 0xeb95, 0xec95, 0xed95, 0xee95, 0xef95,
	0xb4bb, 0xf095, 0xf195, 0xf295, 0xf395, 0xf495, 0xf595, 0xf695,
	0xf795, 0xf895, 0xf995, 0xfa95, 0xfb95, 0xfc95, 0xfd95, 0xfe95,
	0x4196, 0x4296, 0x4396, 0x4496, 0x4596, 0x4696, 0x4796, 0x4896,
	0x4996, 0x4a96, 0x4b96, 0x4c96, 0x4d96, 0x4e96, 0x4f96, 0x5096,
	0x5196, 0x5296, 0x5396, 0x5496, 0x5596, 0x5696, 0x5796, 0x5896,
	0xb5bb, 0xb6bb, 0x5996, 0x5a96, 0xb7bb, 0x6196, 0x6296, 0xb8bb,
	0xb9bb, 0x6396, 0x6496, 0x6596, 0x6696, 0x6796, 0x6896, 0x6996,
	0xbabb, 0x6a96, 0x6b96, 0xbbbb, 0xbcbb, 0xbdbb, 0x6c96, 0x6d96,
	0x6e96, 0x6f96, 0x7096, 0x7196, 0xbebb, 0x7296, 0x7396, 0x7496,
	0x7596, 0x7696, 0x7796, 0x7896, 0x7996, 0x7a96, 0x8196, 0x8296,
	0x8396, 0x8496, 0x8596, 0x8696, 0x8796, 0x8896, 0x8996, 0x8a96,
	0x8b96, 0xbfbb, 0x8c96, 0x8d96, 0x8e96, 0x8f96, 0x9096, 0x9196,
	0xc0bb, 0xc1bb, 0x9296, 0x9396, 0x9496, 0x9596, 0x9696, 0x9796,
	0x9896, 0x9996, 0x9a96, 0x9b96, 0x9c96, 0x9d96, 0x9e96, 0x9f96,
	0xc2bb, 0xc3bb, 0xa096, 0xc4bb, 0xc5bb, 0xc6bb, 0xa196, 0xa296,
	0xa396, 0xa496, 0xa596, 0xa696, 0xa796, 0xa896, 0xa996, 0xaa96,
	0xab96, 0xac96, 0xad96, 0xae96, 0xaf96, 0xb096, 0xb196, 0xb296,
	0xb396, 0xb496, 0xb596, 0xb696, 0xb796, 0xb896, 0xb996, 0xba96,
	0xbb96, 0xbc96, 0xbd96, 0xbe96, 0xbf96, 0xc096, 0xc196, 0xc296,
	0xc7bb, 0xc8bb, 0xc396, 0xc496, 0xc9bb, 0xc596, 0xc696, 0xc796,
	0xcabb, 0xc896, 0xc996, 0xca96, 0xcb96, 0xcc96, 0xcd96, 0xce96,
	0xcbbb, 0xccbb, 0xcf96, 0xd096, 0xd196, 0xcdbb, 0xd296, 0xd396,
	0xd496, 0xd596, 0xd696, 0xd796, 0xd896, 0xd996, 0xda96, 0xdb96,
	0xdc96, 0xdd96, 0xde96, 0xdf96, 0xe096, 0xe196, 0xe296, 0xe396,
	0xe496, 0xe596, 0xe696, 0xe796, 0xe896, 0xe996, 0xea96, 0xeb96,
	0xec96, 0xed96, 0xee96, 0xef96, 0xf096, 0xf196, 0xf296, 0xf396,
	0xf496, 0xf596, 0xf696, 0xf796, 0xf896, 0xf996, 0xfa96, 0xfb96,
	0xfc96, 0xfd96, 0xfe96, 0x4197, 0x4297, 0x4397, 0x4497, 0x4597,
	0x4697, 0x4797, 0x4897, 0x4997, 0x4a97, 0x4b97, 0x4c97, 0x4d97,
	0x4e97, 0x4f97, 0x5097, 0x5197, 0xcebb, 0x5297, 0x5397, 0x5497,
	0x5597, 0x5697, 0x5797, 0x5897, 0x5997, 0x5a97, 0x6197, 0x6297,
	0x6397, 0x6497, 0x6597, 0x6697, 0x6797, 0x6897, 0x6997, 0x6a97,
	0x6b97, 0x6c97, 0x6d97, 0x6e97, 0x6f97, 0x7097, 0x7197, 0x7297,
	0xcfbb, 0x7397, 0x7497, 0x7597, 0x7697, 0x7797, 0x7897, 0x7997,
	0x7a97, 0x8197, 0x8297, 0x8397, 0x8497, 0x8597, 0x8697, 0x8797,
	0x8897, 0x8997, 0x8a97, 0x8b97, 0x8c97, 0xd0bb, 0x8d97, 0x8e97,
	0x8f97, 0x9097, 0x9197, 0x9297, 0xd1bb, 0xd2bb, 0x9397, 0x9497,
	0xd3bb, 0x9597, 0x9697, 0x9797, 0xd4bb, 0x9897, 0x9997, 0x9a97,
	0x9b97, 0x9c97, 0x9d97, 0x9e97, 0xd5bb, 0x9f97, 0xa097, 0xd6bb,
	0xa197, 0xd7bb, 0xa297, 0xa397, 0xa497, 0xa597, 0xa697, 0xa797,
	0xa897, 0xa997, 0xaa97, 0xab97, 0xac97, 0xad97, 0xae97, 0xaf97,
	0xb097, 0xb197, 0xb297, 0xb397, 0xb497, 0xb597, 0xb697, 0xb797,
	0xb897, 0xb997, 0xba97, 0xbb97, 0xbc97, 0xbd97, 0xbe97, 0xbf97,
	0xc097, 0xc197, 0xc297, 0xc397, 0xc497, 0xc597, 0xc697, 0xc797,
	0xc897, 0xc997, 0xca97, 0xcb97, 0xcc97, 0xcd97, 0xce97, 0xcf97,
	0xd097, 0xd197, 0xd297, 0xd397, 0xd497, 0xd597, 0xd697, 0xd797,
	0xd897, 0xd997, 0xda97, 0xdb97, 0xdc97, 0xdd97, 0xde97, 0xdf97,
	0xe097, 0xe197, 0xe297, 0xe397, 0xe497, 0xe597, 0xe697, 0xe797,
	0xe897, 0xe997, 0xea97, 0xeb97, 0xec97, 0xed97, 0xee97, 0xef97,
	0xf097, 0xf197, 0xf297, 0xf397, 0xf497, 0xf597, 0xf697, 0xf797,
	0xf897, 0xf997, 0xfa97, 0xfb97, 0xd8bb, 0xfc97, 0xfd97, 0xfe97,
	0x4198, 0x4298, 0x4398, 0x4498, 0x4598, 0x4698, 0x4798, 0x4898,
	0x4998, 0x4a98, 0x4b98, 0x4c98, 0x4d98, 0x4e98, 0x4f98, 0x5098,
	0x5198, 0xd9bb, 0x5298, 0x5398, 0x5498, 0x5598, 0x5698, 0x5798,
	0xdabb, 0x5898, 0x5998, 0x5a98, 0xdbbb, 0x6198, 0x6298, 0x6398,
	0xdcbb, 0x6498, 0x6598, 0x6698, 0x6798, 0x6898, 0x6998, 0x6a98,
	0xddbb, 0xdebb, 0x6b98, 0x6c98, 0x6d98, 0x6e98, 0x6f98, 0x7098,
	0x7198, 0x7298, 0x7398, 0x7498, 0x7598, 0x7698, 0x7798, 0x7898,
	0x7998, 0x7a98, 0x8198, 0x8298, 0x8398, 0x8498, 0x8598, 0x8698,
	0x8798, 0x8898, 0x8998, 0x8a98, 0x8b98, 0x8c98, 0x8d98, 0x8e98,
	0x8f98, 0x9098, 0x9198, 0x9298, 0x9398, 0x9498, 0x9598, 0x9698,
	0xdfbb, 0xe0bb, 0x9798, 0x9898, 0xe1bb, 0x9998, 0x9a98, 0x9b98,
	0xe2bb, 0x9c98, 0x9d98, 0x9e98, 0x9f98, 0xa098, 0xa198, 0xa298,
	0xe3bb, 0xe4bb, 0xa398, 0xe5bb, 0xa498, 0xe6bb, 0xa598, 0xa698,
	0xa798, 0xa898, 0xa998, 0xaa98, 0xe7bb, 0xe8bb, 0xab98, 0xe9bb,
	0xeabb, 0xac98, 0xad98, 0xebbb, 0xecbb, 0xedbb, 0xeebb, 0xae98,
	0xaf98, 0xb098, 0xb198, 0xb298, 0xefbb, 0xf0bb, 0xb398, 0xf1bb,
	0xf2bb, 0xf3bb, 0xb498, 0xb598, 0xb698, 0xf4bb, 0xb798, 0xb898,
	0xf5bb, 0xf6bb, 0xb998, 0xba98, 0xf7bb, 0xbb98, 0xbc98, 0xbd98,
	0xf8bb, 0xbe98, 0xbf98, 0xc098, 0xc198, 0xc298, 0xc398, 0xc498,
	0xf9bb, 0xfabb, 0xc598, 0xfbbb, 0xfcbb, 0xfdbb, 0xc698, 0xc798,
	0xc898, 0xc998, 0xca98, 0xcb98, 0xfebb, 0xa1bc, 0xcc98, 0xcd98,
	0xa2bc, 0xce98, 0xcf98, 0xd098, 0xa3bc, 0xd198, 0xd298, 0xd398,
	0xd498, 0xd598, 0xd698, 0xd798, 0xa4bc, 0xa5bc, 0xd898, 0xa6bc,
	0xd998, 0xa7bc, 0xda98, 0xdb98, 0xdc98, 0xdd98, 0xde98, 0xdf98,
	0xa8bc, 0xe098, 0xe198, 0xe298, 0xa9bc, 0xe398, 0xe498, 0xe598,
	0xaabc, 0xe698, 0xe798, 0xe898, 0xe998, 0xea98, 0xeb98, 0xec98,
	0xabbc, 0xed98, 0xee98, 0xef98, 0xf098, 0xacbc, 0xf198, 0xf298,
	0xf398, 0xf498, 0xf598, 0xf698, 0xadbc, 0xaebc, 0xafbc, 0xb0bc,
	0xb1bc, 0xf798, 0xf898, 0xb2bc, 0xb3bc, 0xf998, 0xb4bc, 0xb5bc,
	0xfa98, 0xfb98, 0xfc98, 0xfd98, 0xb6bc, 0xb7bc, 0xfe98, 0xb8bc,
	0xb9bc, 0xbabc, 0x4199, 0x4299, 0x4399, 0x4499, 0xbbbc, 0x4599,
	0xbcbc, 0xbdbc, 0x4699, 0x4799, 0xbebc, 0x4899, 0x4999, 0x4a99,
	0xbfbc, 0x4b99, 0x4c99, 0x4d99, 0x4e99, 0x4f99, 0x5099, 0x5199,
	0xc0bc, 0xc1bc, 0x5299, 0xc2bc, 0xc3bc, 0xc4bc, 0x5399, 0x5499,
	0x5599, 0x5699, 0x5799, 0x5899, 0xc5bc, 0xc6bc, 0x5999, 0x5a99,
	0xc7bc, 0x6199, 0x6299, 0x6399, 0xc8bc, 0x6499, 0x6599, 0x6699,
	0x6799, 0x6899, 0x6999, 0x6a99, 0xc9bc, 0xcabc, 0x6b99, 0xcbbc,
	0xccbc, 0xcdbc, 0x6c99, 0x6d99, 0x6e99, 0x6f99, 0x7099, 0x7199,
	0xcebc, 0x7299, 0x7399, 0x7499, 0xcfbc, 0x7599, 0x7699, 0x7799,
	0xd0bc, 0x7899, 0x7999, 0x7a99, 0x8199, 0x8299, 0x8399, 0x8499,
	0x8599, 0x8699, 0x8799, 0x8899, 0x8999, 0xd1bc, 0x8a99, 0x8b99,
	0x8c99, 0x8d99, 0x8e99, 0x8f99, 0xd2bc, 0xd3bc, 0xd4bc, 0x9099,
	0xd5bc, 0x9199, 0x9299, 0x9399, 0xd6bc, 0x9499, 0xd7bc, 0x9599,
	0x9699, 0x9799, 0x9899, 0x9999, 0xd8bc, 0xd9bc, 0x9a99, 0xdabc,
	0x9b99, 0xdbbc, 0x9c99, 0x9d99, 0x9e99, 0xdcbc, 0x9f99, 0xa099,
	0xddbc, 0xdebc, 0xa199, 0xa299, 0xdfbc, 0xa399, 0xa499, 0xa599,
	0xe0bc, 0xa699, 0xa799, 0xa899, 0xa999, 0xaa99, 0xab99, 0xac99,
	0xad99, 0xae99, 0xaf99, 0xb099, 0xb199, 0xe1bc, 0xb299, 0xb399,
	0xb499, 0xb599, 0xb699, 0xb799, 0xe2bc, 0xb899, 0xb999, 0xba99,
	0xe3bc, 0xbb99, 0xbc99, 0xbd99, 0xe4bc, 0xbe99, 0xbf99, 0xc099,
	0xc199, 0xc299, 0xc399, 0xc499, 0xe5bc, 0xc599, 0xc699, 0xe6bc,
	0xe7bc, 0xc799, 0xc899, 0xc999, 0xca99, 0xcb99, 0xcc99, 0xcd99,
	0xe8bc, 0xce99, 0xcf99, 0xd099, 0xe9bc, 0xd199, 0xd299, 0xd399,
	0xeabc, 0xd499, 0xd599, 0xd699, 0xd799, 0xd899, 0xd999, 0xda99,
	0xebbc, 0xecbc, 0xdb99, 0xedbc, 0xdc99, 0xdd99, 0xde99, 0xdf99,
	0xe099, 0xe199, 0xe299, 0xe399, 0xeebc, 0xefbc, 0xe499, 0xe599,
	0xf0bc, 0xe699, 0xe799, 0xe899, 0xf1bc, 0xe999, 0xea99, 0xeb99,
	0xec99, 0xed99, 0xee99, 0xef99, 0xf2bc, 0xf3bc, 0xf099, 0xf4bc,
	0xf199, 0xf5bc, 0xf299, 0xf399, 0xf499, 0xf599, 0xf699, 0xf799,
	0xf6bc, 0xf7bc, 0xf899, 0xf999, 0xf8bc, 0xfa99, 0xfb99, 0xf9bc,
	0xfabc, 0xfc99, 0xfd99, 0xfe99, 0x419a, 0x429a, 0x439a, 0x449a,
	0xfbbc, 0xfcbc, 0x459a, 0xfdbc, 0x469a, 0xfebc, 0x479a, 0xa1bd,
	0x489a, 0xa2bd, 0xa3bd, 0x499a, 0xa4bd, 0x4a9a, 0x4b9a, 0x4c9a,
	0x4d9a, 0x4e9a, 0x4f9a, 0x509a, 0x519a, 0x529a, 0x539a, 0x549a,
	0x559a, 0x569a, 0x579a, 0x589a, 0x599a, 0x5a9a, 0x619a, 0x629a,
	0xa5bd, 0x639a, 0x649a, 0x659a, 0x669a, 0x679a, 0x689a, 0x699a,
	0xa6bd, 0xa7bd, 0x6a9a, 0x6b9a, 0xa8bd, 0x6c9a, 0x6d9a, 0x6e9a,
	0xa9bd, 0x6f9a, 0x709a, 0x719a, 0x729a, 0x739a, 0x749a, 0x759a,
	0xaabd, 0x769a, 0x779a, 0x789a, 0x799a, 0xabbd, 0x7a9a, 0x819a,
	0x829a, 0x839a, 0x849a, 0x859a, 0xacbd, 0xadbd, 0x869a, 0x879a,
	0xaebd, 0x889a, 0x899a, 0x8a9a, 0xafbd, 0x8b9a, 0x8c9a, 0x8d9a,
	0x8e9a, 0x8f9a, 0x909a, 0x919a, 0xb0bd, 0xb1bd, 0x929a, 0xb2bd,
	0x939a, 0xb3bd, 0x949a, 0x959a, 0x969a, 0x979a, 0x989a, 0x999a,
	0xb4bd, 0xb5bd, 0x9a9a, 0x9b9a, 0x9c9a, 0x9d9a, 0x9e9a, 0x9f9a,
	0xb6bd, 0xa09a, 0xa19a, 0xa29a, 0xa39a, 0xa49a, 0xa59a, 0xa69a,
	0xb7bd, 0xa79a, 0xa89a, 0xb8bd, 0xa99a, 0xb9bd, 0xaa9a, 0xab9a,
	0xac9a, 0xad9a, 0xae9a, 0xaf9a, 0xbabd, 0xbbbd, 0xb09a, 0xb19a,
	0xbcbd, 0xb29a, 0xb39a, 0xb49a, 0xbdbd, 0xbebd, 0xb59a, 0xb69a,
	0xb79a, 0xb89a, 0xb99a, 0xba9a, 0xbfbd, 0xc0bd, 0xbb9a, 0xc1bd,
	0xbc9a, 0xc2bd, 0xbd9a, 0xbe9a, 0xbf9a, 0xc09a, 0xc19a, 0xc29a,
	0xc39a, 0xc49a, 0xc59a, 0xc69a, 0xc79a, 0xc89a, 0xc99a, 0xca9a,
	0xcb9a, 0xcc9a, 0xcd9a, 0xce9a, 0xcf9a, 0xd09a, 0xd19a, 0xd29a,
	0xd39a, 0xd49a, 0xd59a, 0xd69a, 0xd79a, 0xd89a, 0xd99a, 0xda9a,
	0xdb9a, 0xdc9a, 0xdd9a, 0xde9a, 0xc3bd, 0xc4bd, 0xdf9a, 0xe09a,
	0xc5bd, 0xe19a, 0xe29a, 0xc6bd, 0xc7bd, 0xe39a, 0xe49a, 0xe59a,
	0xe69a, 0xe79a, 0xe89a, 0xc8bd, 0xc9bd, 0xcabd, 0xe99a, 0xcbbd,
	0xea9a, 0xccbd, 0xeb9a, 0xec9a, 0xed9a, 0xee9a, 0xcdbd, 0xef9a,
	0xcebd, 0xcfbd, 0xf09a, 0xd0bd, 0xd1bd, 0xf19a, 0xf29a, 0xf39a,
	0xd2bd, 0xf49a, 0xf59a, 0xf69a, 0xf79a, 0xf89a, 0xf99a, 0xfa9a,
	0xd3bd, 0xd4bd, 0xfb9a, 0xfc9a, 0xd5bd, 0xd6bd, 0xfd9a, 0xfe9a,
	0x419b, 0x429b, 0x439b, 0xd7bd, 0xd8bd, 0xd9bd, 0x449b, 0x459b,
	0xdabd, 0x469b, 0x479b, 0x489b, 0xdbbd, 0x499b, 0x4a9b, 0x4b9b,
	0x4c9b, 0x4d9b, 0x4e9b, 0x4f9b, 0xdcbd, 0xddbd, 0x509b, 0x519b,
	0xdebd, 0xdfbd, 0x529b, 0x539b, 0x549b, 0x559b, 0x569b, 0x579b,
	0x589b, 0x599b, 0x5a9b, 0x619b, 0x629b, 0x639b, 0x649b, 0x659b,
	0x669b, 0x679b, 0x689b, 0x699b, 0x6a9b, 0x6b9b, 0x6c9b, 0x6d9b,
	0x6e9b, 0x6f9b, 0x709b, 0x719b, 0x729b, 0xe0bd, 0x739b, 0x749b,
	0x759b, 0x769b, 0x779b, 0x789b, 0x799b, 0x7a9b, 0x819b, 0x829b,
	0x839b, 0x849b, 0x859b, 0x869b, 0x879b, 0x889b, 0x899b, 0x8a9b,
	0x8b9b, 0x8c9b, 0x8d9b, 0x8e9b, 0x8f9b, 0x909b, 0x919b, 0x929b,
	0x939b, 0x949b, 0x959b, 0x969b, 0x979b, 0x989b, 0x999b, 0x9a9b,
	0xe1bd, 0xe2bd, 0x9b9b, 0x9c9b, 0xe3bd, 0x9d9b, 0x9e9b, 0x9f9b,
	0xe4bd, 0xa09b, 0xe5bd, 0xa19b, 0xa29b, 0xa39b, 0xa49b, 0xa59b,
	0xe6bd, 0xe7bd, 0xa69b, 0xa79b, 0xe8bd, 0xe9bd, 0xa89b, 0xa99b,
	0xaa9b, 0xab9b, 0xac9b, 0xad9b, 0xeabd, 0xae9b, 0xaf9b, 0xb09b,
	0xebbd, 0xb19b, 0xb29b, 0xb39b, 0xecbd, 0xb49b, 0xb59b, 0xb69b,
	0xb79b, 0xb89b, 0xb99b, 0xba9b, 0xbb9b, 0xbc9b, 0xbd9b, 0xbe9b,
	0xbf9b, 0xc09b, 0xc19b, 0xc29b, 0xc39b, 0xc49b, 0xc59b, 0xc69b,
	0xc79b, 0xc89b, 0xc99b, 0xca9b, 0xcb9b, 0xcc9b, 0xcd9b, 0xce9b,
	0xcf9b, 0xd09b, 0xd19b, 0xd29b, 0xd39b, 0xd49b, 0xd59b, 0xd69b,
	0xd79b, 0xd89b, 0xd99b, 0xda9b, 0xdb9b, 0xdc9b, 0xdd9b, 0xde9b,
	0xdf9b, 0xe09b, 0xe19b, 0xe29b, 0xe39b, 0xe49b, 0xe59b, 0xe69b,
	0xedbd, 0xe79b, 0xe89b, 0xe99b, 0xea9b, 0xeb9b, 0xec9b, 0xed9b,
	0xee9b, 0xef9b, 0xf09b, 0xf19b, 0xf29b, 0xf39b, 0xf49b, 0xf59b,
	0xf69b, 0xf79b, 0xf89b, 0xf99b, 0xfa9b, 0xfb9b, 0xfc9b, 0xfd9b,
	0xeebd, 0xefbd, 0xfe9b, 0x419c, 0xf0bd, 0x429c, 0x439c, 0xf1bd,
	0xf2bd, 0x449c, 0xf3bd, 0x459c, 0x469c, 0x479c, 0x489c, 0x499c,
	0xf4bd, 0xf5bd, 0x4a9c, 0x4b9c, 0x4c9c, 0xf6bd, 0x4d9c, 0x4e9c,
	0x4f9c, 0x509c, 0x519c, 0x529c, 0xf7bd, 0xf8bd, 0x539c, 0x549c,
	0xf9bd, 0x559c, 0x569c, 0x579c, 0x589c, 0x599c, 0x5a9c, 0x619c,
	0x629c, 0x639c, 0x649c, 0x659c, 0x669c, 0x679c, 0x689c, 0x699c,
	0xfabd, 0x6a9c, 0x6b9c, 0x6c9c, 0x6d9c, 0x6e9c, 0x6f9c, 0x709c,
	0xfbbd, 0x719c, 0x729c, 0x739c, 0x749c, 0x759c, 0x769c, 0x779c,
	0x789c, 0x799c, 0x7a9c, 0x819c, 0x829c, 0x839c, 0x849c, 0x859c,
	0x869c, 0x879c, 0x889c, 0x899c, 0xfcbd, 0x8a9c, 0x8b9c, 0x8c9c,
	0x8d9c, 0x8e9c, 0x8f9c, 0x909c, 0xfdbd, 0x919c, 0x929c, 0x939c,
	0xfebd, 0x949c, 0x959c, 0x969c, 0xa1be, 0x979c, 0x989c, 0x999c,
	0x9a9c, 0x9b9c, 0x9c9c, 0x9d9c, 0xa2be, 0xa3be, 0x9e9c, 0x9f9c,
	0xa09c, 0xa19c, 0xa29c, 0xa39c, 0xa49c, 0xa59c, 0xa69c, 0xa79c,
	0xa4be, 0xa89c, 0xa99c, 0xaa9c, 0xab9c, 0xac9c, 0xad9c, 0xae9c,
	0xaf9c, 0xb09c, 0xb19c, 0xb29c, 0xb39c, 0xb49c, 0xb59c, 0xb69c,
	0xb79c, 0xb89c, 0xb99c, 0xba9c, 0xbb9c, 0xbc9c, 0xbd9c, 0xbe9c,
	0xbf9c, 0xc09c, 0xc19c, 0xc29c, 0xa5be, 0xa6be, 0xc39c, 0xc49c,
	0xa7be, 0xc59c, 0xc69c, 0xc79c, 0xa8be, 0xc89c, 0xc99c, 0xca9c,
	0xcb9c, 0xcc9c, 0xcd9c, 0xce9c, 0xa9be, 0xaabe, 0xcf9c, 0xd09c,
	0xd19c, 0xabbe, 0xd29c, 0xd39c, 0xd49c, 0xd59c, 0xd69c, 0xd79c,
	0xacbe, 0xd89c, 0xd99c, 0xda9c, 0xdb9c, 0xdc9c, 0xdd9c, 0xde9c,
	0xdf9c, 0xe09c, 0xe19c, 0xe29c, 0xe39c, 0xe49c, 0xe59c, 0xe69c,
	0xe79c, 0xe89c, 0xe99c, 0xea9c, 0xadbe, 0xeb9c, 0xec9c, 0xed9c,
	0xee9c, 0xef9c, 0xf09c, 0xf19c, 0xaebe, 0xf29c, 0xf39c, 0xf49c,
	0xf59c, 0xf69c, 0xf79c, 0xf89c, 0xf99c, 0xfa9c, 0xfb9c, 0xfc9c,
	0xfd9c, 0xfe9c, 0x419d, 0x429d, 0x439d, 0x449d, 0x459d, 0x469d,
	0x479d, 0x489d, 0x499d, 0x4a9d, 0x4b9d, 0x4c9d, 0x4d9d, 0x4e9d,
	0xafbe, 0x4f9d, 0x509d, 0x519d, 0xb0be, 0x529d, 0x539d, 0x549d,
	0x559d, 0x569d, 0x579d, 0x589d, 0x599d, 0x5a9d, 0x619d, 0x629d,
	0x639d, 0x649d, 0x659d, 0x669d, 0x679d, 0x689d, 0x699d, 0x6a9d,
	0x6b9d, 0x6c9d, 0x6d9d, 0x6e9d, 0x6f9d, 0x709d, 0x719d, 0x729d,
	0x739d, 0x749d, 0x759d, 0x769d, 0x779d, 0x789d, 0x799d, 0x7a9d,
	0x819d, 0x829d, 0x839d, 0x849d, 0x859d, 0x869d, 0x879d, 0x889d,
	0x899d, 0xb1be, 0x8a9d, 0x8b9d, 0x8c9d, 0x8d9d, 0x8e9d, 0x8f9d,
	0xb2be, 0xb3be, 0x909d, 0x919d, 0xb4be, 0x929d, 0x939d, 0x949d,
	0xb5be, 0x959d, 0xb6be, 0x969d, 0x979d, 0x989d, 0x999d, 0xb7be,
	0xb8be, 0xb9be, 0x9a9d, 0x9b9d, 0x9c9d, 0x9d9d, 0x9e9d, 0x9f9d,
	0xa09d, 0xa19d, 0xa29d, 0xa39d, 0xbabe, 0xa49d, 0xa59d, 0xa69d,
	0xbbbe, 0xa79d, 0xa89d, 0xa99d, 0xbcbe, 0xaa9d, 0xab9d, 0xac9d,
	0xad9d, 0xae9d, 0xaf9d, 0xb09d, 0xbdbe, 0xb19d, 0xb29d, 0xb39d,
	0xb49d, 0xb59d, 0xb69d, 0xb79d, 0xb89d, 0xb99d, 0xba9d, 0xbb9d,
	0xbebe, 0xbfbe, 0xbc9d, 0xbd9d, 0xc0be, 0xbe9d, 0xbf9d, 0xc09d,
	0xc1be, 0xc19d, 0xc29d, 0xc39d, 0xc49d, 0xc59d, 0xc69d, 0xc79d,
	0xc2be, 0xc3be, 0xc89d, 0xc4be, 0xc99d, 0xc5be, 0xca9d, 0xcb9d,
	0xcc9d, 0xcd9d, 0xce9d, 0xcf9d, 0xc6be, 0xc7be, 0xd09d, 0xd19d,
	0xc8be, 0xc9be, 0xcabe, 0xd29d, 0xcbbe, 0xccbe, 0xcdbe, 0xd39d,
	0xd49d, 0xd59d, 0xd69d, 0xcebe, 0xcfbe, 0xd0be, 0xd79d, 0xd1be,
	0xd2be, 0xd3be, 0xd89d, 0xd99d, 0xda9d, 0xd4be, 0xd5be, 0xdb9d,
	0xd6be, 0xd7be, 0xdc9d, 0xdd9d, 0xd8be, 0xde9d, 0xdf9d, 0xe09d,
	0xd9be, 0xe19d, 0xe29d, 0xe39d, 0xe49d, 0xe59d, 0xe69d, 0xe79d,
	0xdabe, 0xdbbe, 0xe89d, 0xdcbe, 0xddbe, 0xdebe, 0xe99d, 0xea9d,
	0xeb9d, 0xec9d, 0xed9d, 0xee9d, 0xdfbe, 0xe0be, 0xef9d, 0xf09d,
	0xe1be, 0xf19d, 0xf29d, 0xf39d, 0xe2be, 0xf49d, 0xf59d, 0xe3be,
	0xf69d, 0xf79d, 0xf89d, 0xf99d, 0xe4be, 0xe5be, 0xfa9d, 0xe6be,
	0xfb9d, 0xe7be, 0xfc9d, 0xfd9d, 0xfe9d, 0xe8be, 0x419e, 0xe9be,
	0xeabe, 0x429e, 0x439e, 0x449e, 0xebbe, 0x459e, 0x469e, 0x479e,
	0xecbe, 0x489e, 0x499e, 0x4a9e, 0x4b9e, 0x4c9e, 0x4d9e, 0x4e9e,
	0x4f9e, 0xedbe, 0x509e, 0x519e, 0x529e, 0x539e, 0x549e, 0x559e,
	0x569e, 0x579e, 0x589e, 0x599e, 0xeebe, 0xefbe, 0x5a9e, 0x619e,
	0xf0be, 0xf1be, 0x629e, 0xf2be, 0xf3be, 0xf4be, 0xf5be, 0x639e,
	0x649e, 0x659e, 0x669e, 0x679e, 0xf6be, 0xf7be, 0xf8be, 0xf9be,
	0xfabe, 0xfbbe, 0xfcbe, 0x689e, 0xfdbe, 0x699e, 0xfebe, 0x6a9e,
	0xa1bf, 0xa2bf, 0x6b9e, 0x6c9e, 0xa3bf, 0x6d9e, 0x6e9e, 0x6f9e,
	0xa4bf, 0x709e, 0x719e, 0x729e, 0x739e, 0x749e, 0x759e, 0x769e,
	0xa5bf, 0xa6bf, 0x779e, 0xa7bf, 0x789e, 0xa8bf, 0x799e, 0x7a9e,
	0x819e, 0x829e, 0x839e, 0x849e, 0xa9bf, 0xaabf, 0xabbf, 0x859e,
	0xacbf, 0x869e, 0x879e, 0x889e, 0xadbf, 0x899e, 0xaebf, 0xafbf,
	0x8a9e, 0x8b9e, 0x8c9e, 0x8d9e, 0xb0bf, 0xb1bf, 0xb2bf, 0xb3bf,
	0xb4bf, 0xb5bf, 0x8e9e, 0x8f9e, 0x909e, 0xb6bf, 0xb7bf, 0xb8bf,
	0xb9bf, 0x919e, 0x929e, 0x939e, 0xbabf, 0x949e, 0x959e, 0x969e,
	0xbbbf, 0x979e, 0x989e, 0x999e, 0x9a9e, 0x9b9e, 0x9c9e, 0x9d9e,
	0xbcbf, 0xbdbf, 0x9e9e, 0xbebf, 0xbfbf, 0x9f9e, 0xa09e, 0xa19e,
	0xa29e, 0xa39e, 0xa49e, 0xa59e, 0xc0bf, 0xc1bf, 0xa69e, 0xa79e,
	0xc2bf, 0xa89e, 0xa99e, 0xaa9e, 0xc3bf, 0xc4bf, 0xc5bf, 0xab9e,
	0xc6bf, 0xac9e, 0xad9e, 0xc7bf, 0xc8bf, 0xc9bf, 0xae9e, 0xcabf,
	0xaf9e, 0xcbbf, 0xb09e, 0xccbf, 0xb19e, 0xb29e, 0xb39e, 0xb49e,
	0xcdbf, 0xcebf, 0xb59e, 0xb69e, 0xcfbf, 0xb79e, 0xb89e, 0xb99e,
	0xd0bf, 0xba9e, 0xbb9e, 0xbc9e, 0xbd9e, 0xbe9e, 0xbf9e, 0xc09e,
	0xd1bf, 0xd2bf, 0xc19e, 0xd3bf, 0xd4bf, 0xd5bf, 0xc29e, 0xc39e,
	0xc49e, 0xc59e, 0xc69e, 0xc79e, 0xd6bf, 0xd7bf, 0xc89e, 0xc99e,
	0xd8bf, 0xca9e, 0xcb9e, 0xcc9e, 0xcd9e, 0xce9e, 0xcf9e, 0xd09e,
	0xd19e, 0xd29e, 0xd39e, 0xd49e, 0xd9bf, 0xd59e, 0xd69e, 0xdabf,
	0xd79e, 0xdbbf, 0xd89e, 0xd99e, 0xda9e, 0xdb9e, 0xdc9e, 0xdd9e,
	0xdcbf, 0xddbf, 0xde9e, 0xdf9e, 0xdebf, 0xe09e, 0xe19e, 0xe29e,
	0xdfbf, 0xe39e, 0xe49e, 0xe59e, 0xe69e, 0xe79e, 0xe89e, 0xe99e,
	0xe0bf, 0xe1bf, 0xea9e, 0xe2bf, 0xeb9e, 0xe3bf, 0xec9e, 0xed9e,
	0xee9e, 0xef9e, 0xf09e, 0xf19e, 0xe4bf, 0xe5bf, 0xf29e, 0xf39e,
	0xe6bf, 0xf49e, 0xf59e, 0xf69e, 0xe7bf, 0xf79e, 0xf89e, 0xf99e,
	0xfa9e, 0xfb9e, 0xfc9e, 0xfd9e, 0xe8bf, 0xe9bf, 0xfe9e, 0xeabf,
	0x419f, 0xebbf, 0x429f, 0x439f, 0x449f, 0x459f, 0x469f, 0x479f,
	0xecbf, 0xedbf, 0x489f, 0x499f, 0xeebf, 0x4a9f, 0x4b9f, 0x4c9f,
	0xefbf, 0xf0bf, 0xf1bf, 0x4d9f, 0x4e9f, 0x4f9f, 0x509f, 0x519f,
	0xf2bf, 0xf3bf, 0x529f, 0xf4bf, 0x539f, 0xf5bf, 0x549f, 0x559f,
	0x569f, 0x579f, 0x589f, 0x599f, 0xf6bf, 0xf7bf, 0x5a9f, 0x619f,
	0xf8bf, 0x629f, 0x639f, 0x649f, 0xf9bf, 0x659f, 0x669f, 0x679f,
	0x689f, 0x699f, 0x6a9f, 0x6b9f, 0xfabf, 0xfbbf, 0x6c9f, 0x6d9f,
	0xfcbf, 0xfdbf, 0x6e9f, 0x6f9f, 0x709f, 0x719f, 0x729f, 0x739f,
	0xfebf, 0xa1c0, 0x749f, 0x759f, 0xa2c0, 0x769f, 0x779f, 0x789f,
	0xa3c0, 0x799f, 0x7a9f, 0x819f, 0x829f, 0x839f, 0x849f, 0x859f,
	0xa4c0, 0xa5c0, 0x869f, 0x879f, 0x889f, 0xa6c0, 0x899f, 0x8a9f,
	0x8b9f, 0x8c9f, 0x8d9f, 0x8e9f, 0xa7c0, 0xa8c0, 0x8f9f, 0x909f,
	0xa9c0, 0x919f, 0x929f, 0x939f, 0xaac0, 0x949f, 0x959f, 0x969f,
	0x979f, 0x989f, 0x999f, 0x9a9f, 0xabc0, 0xacc0, 0x9b9f, 0xadc0,
	0x9c9f, 0xaec0, 0x9d9f, 0x9e9f, 0x9f9f, 0xa09f, 0xa19f, 0xa29f,
	0xafc0, 0xb0c0, 0xa39f, 0xa49f, 0xb1c0, 0xa59f, 0xa69f, 0xa79f,
	0xb2c0, 0xa89f, 0xa99f, 0xaa9f, 0xab9f, 0xac9f, 0xad9f, 0xae9f,
	0xb3c0, 0xb4c0, 0xaf9f, 0xb5c0, 0xb09f, 0xb6c0, 0xb19f, 0xb7c0,
	0xb29f, 0xb39f, 0xb49f, 0xb59f, 0xb8c0, 0xb9c0, 0xb69f, 0xb79f,
	0xbac0, 0xb89f, 0xb99f, 0xba9f, 0xbbc0, 0xbb9f, 0xbc9f, 0xbd9f,
	0xbe9f, 0xbf9f, 0xbcc0, 0xc09f, 0xbdc0, 0xbec0, 0xc19f, 0xbfc0,
	0xc29f, 0xc0c0, 0xc1c0, 0xc2c0, 0xc3c0, 0xc4c0, 0xc5c0, 0xc6c0,
	0xc7c0, 0xc39f, 0xc49f, 0xc59f, 0xc8c0, 0xc69f, 0xc79f, 0xc89f,
	0xc9c0, 0xc99f, 0xca9f, 0xcb9f, 0xcc9f, 0xcd9f, 0xce9f, 0xcf9f,
	0xcac0, 0xd09f, 0xd19f, 0xcbc0, 0xd29f, 0xd39f, 0xd49f, 0xd59f,
	0xd69f, 0xd79f, 0xd89f, 0xd99f, 0xccc0, 0xcdc0, 0xda9f, 0xdb9f,
	0xcec0, 0xdc9f, 0xdd9f, 0xde9f, 0xcfc0, 0xd0c0, 0xd1c0, 0xdf9f,
	0xe09f, 0xe19f, 0xe29f, 0xd2c0, 0xd3c0, 0xd4c0, 0xe39f, 0xd5c0,
	0xd6c0, 0xd7c0, 0xd8c0, 0xe49f, 0xe59f, 0xe69f, 0xd9c0, 0xe79f,
	0xdac0, 0xdbc0, 0xe89f, 0xe99f, 0xdcc0, 0xea9f, 0xddc0, 0xdec0,
	0xdfc0, 0xeb9f, 0xe0c0, 0xec9f, 0xed9f, 0xee9f, 0xef9f, 0xf09f,
	0xe1c0, 0xe2c0, 0xf19f, 0xe3c0, 0xe4c0, 0xe5c0, 0xe6c0, 0xf29f,
	0xf39f, 0xf49f, 0xf59f, 0xf69f, 0xe7c0, 0xe8c0, 0xf79f, 0xf89f,
	0xe9c0, 0xf99f, 0xfa9f, 0xfb9f, 0xeac0, 0xfc9f, 0xfd9f, 0xfe9f,
	0x41a0, 0x42a0, 0x43a0, 0x44a0, 0xebc0, 0xecc0, 0x45a0, 0xedc0,
	0xeec0, 0xefc0, 0x46a0, 0x47a0, 0x48a0, 0x49a0, 0x4aa0, 0x4ba0,
	0xf0c0, 0xf1c0, 0x4ca0, 0x4da0, 0xf2c0, 0x4ea0, 0xf3c0, 0x4fa0,
	0xf4c0, 0x50a0, 0x51a0, 0x52a0, 0x53a0, 0x54a0, 0x55a0, 0x56a0,
	0xf5c0, 0x57a0, 0x58a0, 0x59a0, 0x5aa0, 0xf6c0, 0x61a0, 0x62a0,
	0x63a0, 0x64a0, 0x65a0, 0x66a0, 0xf7c0, 0x67a0, 0x68a0, 0x69a0,
	0xf8c0, 0x6aa0, 0x6ba0, 0x6ca0, 0xf9c0, 0x6da0, 0x6ea0, 0x6fa0,
	0x70a0, 0x71a0, 0x72a0, 0x73a0, 0x74a0, 0x75a0, 0x76a0, 0x77a0,
	0x78a0, 0x79a0, 0x7aa0, 0x81a0, 0x82a0, 0x83a0, 0x84a0, 0x85a0,
	0xfac0, 0xfbc0, 0x86a0, 0x87a0, 0xfcc0, 0x88a0, 0x89a0, 0x8aa0,
	0xfdc0, 0x8ba0, 0xfec0, 0x8ca0, 0x8da0, 0x8ea0, 0x8fa0, 0x90a0,
	0xa1c1, 0xa2c1, 0x91a0, 0xa3c1, 0x92a0, 0xa4c1, 0xa5c1, 0x93a0,
	0x94a0, 0x95a0, 0x96a0, 0x97a0, 0xa6c1, 0xa7c1, 0x98a0, 0x99a0,
	0xa8c1, 0x9aa0, 0x9ba0, 0x9ca0, 0xa9c1, 0x9da0, 0x9ea0, 0x9fa0,
	0xa0a0, 0xa1a0, 0xa2a0, 0xa3a0, 0xaac1, 0xabc1, 0xa4a0, 0xacc1,
	0xa5a0, 0xadc1, 0xa6a0, 0xa7a0, 0xa8a0, 0xa9a0, 0xaaa0, 0xaba0,
	0xaec1, 0xaca0, 0xada0, 0xaea0, 0xafc1, 0xafa0, 0xb0a0, 0xb1a0,
	0xb0c1, 0xb2a0, 0xb3a0, 0xb4a0, 0xb5a0, 0xb6a0, 0xb7a0, 0xb8a0,
	0xb1c1, 0xb2c1, 0xb9a0, 0xbaa0, 0xb3c1, 0xb4c1, 0xbba0, 0xbca0,
	0xbda0, 0xbea0, 0xbfa0, 0xc0a0, 0xb5c1, 0xc1a0, 0xc2a0, 0xc3a0,
	0xc4a0, 0xc5a0, 0xc6a0, 0xc7a0, 0xc8a0, 0xc9a0, 0xcaa0, 0xcba0,
	0xcca0, 0xcda0, 0xcea0, 0xcfa0, 0xd0a0, 0xd1a0, 0xd2a0, 0xd3a0,
	0xd4a0, 0xd5a0, 0xd6a0, 0xd7a0, 0xd8a0, 0xd9a0, 0xdaa0, 0xdba0,
	0xb6c1, 0xb7c1, 0xdca0, 0xdda0, 0xb8c1, 0xdea0, 0xdfa0, 0xe0a0,
	0xb9c1, 0xe1a0, 0xbac1, 0xe2a0, 0xe3a0, 0xe4a0, 0xe5a0, 0xe6a0,
	0xbbc1, 0xbcc1, 0xe7a0, 0xbdc1, 0xe8a0, 0xbec1, 0xbfc1, 0xc0c1,
	0xe9a0, 0xeaa0, 0xeba0, 0xc1c1, 0xc2c1, 0xc3c1, 0xeca0, 0xeda0,
	0xeea0, 0xefa0, 0xf0a0, 0xf1a0, 0xc4c1, 0xf2a0, 0xf3a0, 0xf4a0,
	0xf5a0, 0xf6a0, 0xf7a0, 0xf8a0, 0xf9a0, 0xc5c1, 0xfaa0, 0xc6c1,
	0xfba0, 0xc7c1, 0xfca0, 0xfda0, 0xfea0, 0x41a1, 0x42a1, 0x43a1,
	0xc8c1, 0x44a1, 0x45a1, 0x46a1, 0x47a1, 0x48a1, 0x49a1, 0x4aa1,
	0x4ba1, 0x4ca1, 0x4da1, 0x4ea1, 0x4fa1, 0x50a1, 0x51a1, 0x52a1,
	0x53a1, 0x54a1, 0x55a1, 0x56a1, 0xc9c1, 0xcac1, 0x57a1, 0x58a1,
	0x59a1, 0x5aa1, 0x61a1, 0x62a1, 0xcbc1, 0x63a1, 0x64a1, 0x65a1,
	0xccc1, 0x66a1, 0x67a1, 0x68a1, 0xcdc1, 0x69a1, 0x6aa1, 0x6ba1,
	0x6ca1, 0x6da1, 0x6ea1, 0x6fa1, 0xcec1, 0xcfc1, 0x70a1, 0xd0c1,
	0x71a1, 0xd1c1, 0x72a1, 0x73a1, 0x74a1, 0x75a1, 0x76a1, 0x77a1,
	0xd2c1, 0xd3c1, 0x78a1, 0x79a1, 0xd4c1, 0x7aa1, 0x81a1, 0x82a1,
	0x83a1, 0x84a1, 0x85a1, 0x86a1, 0x87a1, 0x88a1, 0x89a1, 0x8aa1,
	0x8ba1, 0x8ca1, 0x8da1, 0x8ea1, 0x8fa1, 0xd5c1, 0x90a1, 0x91a1,
	0x92a1, 0x93a1, 0x94a1, 0x95a1, 0xd6c1, 0xd7c1, 0x96a1, 0x97a1,
	0xd8c1, 0x98a1, 0x99a1, 0x9aa1, 0xd9c1, 0xdac1, 0xdbc1, 0x9ba1,
	0x9ca1, 0x9da1, 0x9ea1, 0x9fa1, 0xdcc1, 0xddc1, 0xa0a1, 0xdec1,
	0x41a2, 0xdfc1, 0x42a2, 0x43a2, 0x44a2, 0x45a2, 0x46a2, 0x47a2,
	0xe0c1, 0x48a2, 0x49a2, 0x4aa2, 0x4ba2, 0x4ca2, 0x4da2, 0x4ea2,
	0x4fa2, 0x50a2, 0x51a2, 0x52a2, 0x53a2, 0x54a2, 0x55a2, 0x56a2,
	0x57a2, 0x58a2, 0x59a2, 0x5aa2, 0xe1c1, 0x61a2, 0x62a2, 0x63a2,
	0x64a2, 0x65a2, 0x66a2, 0x67a2, 0xe2c1, 0x68a2, 0x69a2, 0x6aa2,
	0x6ba2, 0x6ca2, 0x6da2, 0x6ea2, 0x6fa2, 0x70a2, 0x71a2, 0x72a2,
	0x73a2, 0x74a2, 0x75a2, 0x76a2, 0x77a2, 0x78a2, 0x79a2, 0x7aa2,
	0x81a2, 0x82a2, 0x83a2, 0x84a2, 0x85a2, 0x86a2, 0x87a2, 0x88a2,
	0xe3c1, 0xe4c1, 0x89a2, 0x8aa2, 0xe5c1, 0x8ba2, 0x8ca2, 0x8da2,
	0xe6c1, 0x8ea2, 0x8fa2, 0x90a2, 0x91a2, 0x92a2, 0x93a2, 0x94a2,
	0xe7c1, 0xe8c1, 0x95a2, 0xe9c1, 0x96a2, 0x97a2, 0x98a2, 0x99a2,
	0x9aa2, 0x9ba2, 0x9ca2, 0x9da2, 0xeac1, 0x9ea2, 0x9fa2, 0xa0a2,
	0xebc1, 0x41a3, 0x42a3, 0x43a3, 0xecc1, 0x44a3, 0x45a3, 0x46a3,
	0x47a3, 0x48a3, 0x49a3, 0x4aa3, 0xedc1, 0x4ba3, 0x4ca3, 0x4da3,
	0x4ea3, 0x4fa3, 0x50a3, 0x51a3, 0x52a3, 0x53a3, 0x54a3, 0x55a3,
	0xeec1, 0xefc1, 0x56a3, 0x57a3, 0xf0c1, 0x58a3, 0x59a3, 0x5aa3,
	0xf1c1, 0x61a3, 0x62a3, 0x63a3, 0x64a3, 0x65a3, 0x66a3, 0x67a3,
	0xf2c1, 0xf3c1, 0x68a3, 0xf4c1, 0x69a3, 0xf5c1, 0x6aa3, 0x6ba3,
	0x6ca3, 0x6da3, 0x6ea3, 0x6fa3, 0x70a3, 0x71a3, 0x72a3, 0x73a3,
	0x74a3, 0x75a3, 0x76a3, 0x77a3, 0x78a3, 0x79a3, 0x7aa3, 0x81a3,
	0x82a3, 0x83a3, 0x84a3, 0x85a3, 0x86a3, 0x87a3, 0x88a3, 0x89a3,
	0x8aa3, 0x8ba3, 0x8ca3, 0x8da3, 0x8ea3, 0x8fa3, 0x90a3, 0x91a3,
	0xf6c1, 0xf7c1, 0x92a3, 0x93a3, 0xf8c1, 0x94a3, 0x95a3, 0xf9c1,
	0xfac1, 0x96a3, 0xfbc1, 0x97a3, 0x98a3, 0x99a3, 0x9aa3, 0x9ba3,
	0xfcc1, 0xfdc1, 0x9ca3, 0xfec1, 0x9da3, 0xa1c2, 0xa2c2, 0x9ea3,
	0x9fa3, 0xa3c2, 0xa4c2, 0xa0a3, 0xa5c2, 0xa6c2, 0x41a4, 0x42a4,
	0xa7c2, 0x43a4, 0xa8c2, 0x44a4, 0xa9c2, 0x45a4, 0x46a4, 0xaac2,
	0x47a4, 0x48a4, 0x49a4, 0x4aa4, 0xabc2, 0xacc2, 0x4ba4, 0xadc2,
	0xaec2, 0xafc2, 0x4ca4, 0x4da4, 0x4ea4, 0x4fa4, 0x50a4, 0x51a4,
	0xb0c2, 0xb1c2, 0x52a4, 0x53a4, 0xb2c2, 0x54a4, 0x55a4, 0x56a4,
	0xb3c2, 0x57a4, 0x58a4, 0x59a4, 0x5aa4, 0x61a4, 0x62a4, 0x63a4,
	0xb4c2, 0xb5c2, 0x64a4, 0xb6c2, 0xb7c2, 0xb8c2, 0x65a4, 0x66a4,
	0x67a4, 0x68a4, 0x69a4, 0x6aa4, 0xb9c2, 0x6ba4, 0x6ca4, 0x6da4,
	0xbac2, 0x6ea4, 0x6fa4, 0x70a4, 0x71a4, 0x72a4, 0x73a4, 0x74a4,
	0x75a4, 0x76a4, 0x77a4, 0x78a4, 0x79a4, 0x7aa4, 0x81a4, 0x82a4,
	0x83a4, 0xbbc2, 0x84a4, 0x85a4, 0x86a4, 0x87a4, 0x88a4, 0x89a4,
	0x8aa4, 0x8ba4, 0x8ca4, 0x8da4, 0x8ea4, 0x8fa4, 0x90a4, 0x91a4,
	0x92a4, 0x93a4, 0x94a4, 0x95a4, 0x96a4, 0x97a4, 0x98a4, 0x99a4,
	0x9aa4, 0x9ba4, 0x9ca4, 0x9da4, 0x9ea4, 0x9fa4, 0xa0a4, 0x41a5,
	0x42a5, 0x43a5, 0x44a5, 0x45a5, 0xbcc2, 0xbdc2, 0x46a5, 0x47a5,
	0xbec2, 0x48a5, 0x49a5, 0x4aa5, 0xbfc2, 0x4ba5, 0x4ca5, 0x4da5,
	0x4ea5, 0x4fa5, 0x50a5, 0x51a5, 0xc0c2, 0xc1c2, 0x52a5, 0xc2c2,
	0xc3c2, 0xc4c2, 0x53a5, 0x54a5, 0x55a5, 0x56a5, 0x57a5, 0x58a5,
	0xc5c2, 0x59a5, 0x5aa5, 0x61a5, 0x62a5, 0x63a5, 0x64a5, 0x65a5,
	0x66a5, 0x67a5, 0x68a5, 0x69a5, 0x6aa5, 0x6ba5, 0x6ca5, 0x6da5,
	0x6ea5, 0x6fa5, 0x70a5, 0x71a5, 0x72a5, 0xc6c2, 0x73a5, 0x74a5,
	0x75a5, 0x76a5, 0x77a5, 0x78a5, 0xc7c2, 0x79a5, 0x7aa5, 0x81a5,
	0x82a5, 0x83a5, 0x84a5, 0x85a5, 0x86a5, 0x87a5, 0x88a5, 0x89a5,
	0x8aa5, 0x8ba5, 0x8ca5, 0x8da5, 0x8ea5, 0x8fa5, 0x90a5, 0x91a5,
	0xc8c2, 0x92a5, 0x93a5, 0x94a5, 0x95a5, 0x96a5, 0x97a5, 0x98a5,
	0x99a5, 0x9aa5, 0x9ba5, 0x9ca5, 0x9da5, 0x9ea5, 0x9fa5, 0xa0a5,
	0x41a6, 0x42a6, 0x43a6, 0x44a6, 0x45a6, 0x46a6, 0x47a6, 0x48a6,
	0x49a6, 0x4aa6, 0x4ba6, 0x4ca6, 0x4da6, 0x4ea6, 0x4fa6, 0x50a6,
	0x51a6, 0x52a6, 0x53a6, 0x54a6, 0xc9c2, 0xcac2, 0x55a6, 0x56a6,
	0xcbc2, 0x57a6, 0x58a6, 0x59a6, 0xccc2, 0x5aa6, 0x61a6, 0x62a6,
	0x63a6, 0x64a6, 0x65a6, 0x66a6, 0xcdc2, 0xcec2, 0x67a6, 0xcfc2,
	0x68a6, 0xd0c2, 0x69a6, 0xd1c2, 0x6aa6, 0x6ba6, 0x6ca6, 0x6da6,
	0xd2c2, 0xd3c2, 0x6ea6, 0x6fa6, 0x70a6, 0x71a6, 0x72a6, 0x73a6,
	0xd4c2, 0x74a6, 0x75a6, 0x76a6, 0x77a6, 0x78a6, 0x79a6, 0x7aa6,
	0x81a6, 0x82a6, 0x83a6, 0x84a6, 0xd5c2, 0x85a6, 0x86a6, 0x87a6,
	0x88a6, 0x89a6, 0x8aa6, 0x8ba6, 0xd6c2, 0x8ca6, 0x8da6, 0x8ea6,
	0x8fa6, 0x90a6, 0x91a6, 0x92a6, 0x93a6, 0x94a6, 0x95a6, 0x96a6,
	0x97a6, 0x98a6, 0x99a6, 0x9aa6, 0x9ba6, 0x9ca6, 0x9da6, 0x9ea6,
	0xd7c2, 0x9fa6, 0xa0a6, 0x41a7, 0x42a7, 0x43a7, 0x44a7, 0x45a7,
	0xd8c2, 0x46a7, 0x47a7, 0x48a7, 0xd9c2, 0x49a7, 0x4aa7, 0x4ba7,
	0xdac2, 0x4ca7, 0x4da7, 0x4ea7, 0x4fa7, 0x50a7, 0x51a7, 0x52a7,
	0xdbc2, 0xdcc2, 0x53a7, 0x54a7, 0x55a7, 0x56a7, 0x57a7, 0x58a7,
	0x59a7, 0x5aa7, 0x61a7, 0x62a7, 0x63a7, 0x64a7, 0x65a7, 0x66a7,
	0x67a7, 0x68a7, 0x69a7, 0x6aa7, 0x6ba7, 0x6ca7, 0x6da7, 0x6ea7,
	0x6fa7, 0x70a7, 0x71a7, 0x72a7, 0x73a7, 0x74a7, 0x75a7, 0x76a7,
	0x77a7, 0xddc2, 0x78a7, 0x79a7, 0x7aa7, 0x81a7, 0x82a7, 0x83a7,
	0xdec2, 0xdfc2, 0x84a7, 0x85a7, 0xe0c2, 0x86a7, 0x87a7, 0x88a7,
	0xe1c2, 0x89a7, 0x8aa7, 0x8ba7, 0x8ca7, 0x8da7, 0x8ea7, 0x8fa7,
	0xe2c2, 0xe3c2, 0x90a7, 0x91a7, 0x92a7, 0xe4c2, 0x93a7, 0x94a7,
	0x95a7, 0x96a7, 0x97a7, 0x98a7, 0xe5c2, 0x99a7, 0x9aa7, 0x9ba7,
	0x9ca7, 0x9da7, 0x9ea7, 0x9fa7, 0xa0a7, 0x41a8, 0x42a8, 0x43a8,
	0x44a8, 0x45a8, 0x46a8, 0x47a8, 0x48a8, 0x49a8, 0x4aa8, 0x4ba8,
	0xe6c2, 0xe7c2, 0x4ca8, 0x4da8, 0x4ea8, 0x4fa8, 0x50a8, 0x51a8,
	0x52a8, 0x53a8, 0x54a8, 0x55a8, 0x56a8, 0x57a8, 0x58a8, 0x59a8,
	0x5aa8, 0x61a8, 0x62a8, 0x63a8, 0x64a8, 0x65a8, 0x66a8, 0x67a8,
	0x68a8, 0x69a8, 0x6aa8, 0x6ba8, 0x6ca8, 0x6da8, 0x6ea8, 0x6fa8,
	0x70a8, 0x71a8, 0x72a8, 0x73a8, 0xe8c2, 0x74a8, 0x75a8, 0x76a8,
	0x77a8, 0x78a8, 0x79a8, 0x7aa8, 0x81a8, 0x82a8, 0x83a8, 0x84a8,
	0x85a8, 0x86a8, 0x87a8, 0x88a8, 0x89a8, 0x8aa8, 0x8ba8, 0x8ca8,
	0x8da8, 0x8ea8, 0x8fa8, 0x90a8, 0x91a8, 0x92a8, 0x93a8, 0x94a8,
	0xe9c2, 0x95a8, 0x96a8, 0x97a8, 0x98a8, 0x99a8, 0x9aa8, 0x9ba8,
	0x9ca8, 0x9da8, 0x9ea8, 0x9fa8, 0xa0a8, 0x41a9, 0x42a9, 0x43a9,
	0x44a9, 0x45a9, 0x46a9, 0x47a9, 0x48a9, 0x49a9, 0x4aa9, 0x4ba9,
	0x4ca9, 0x4da9, 0x4ea9, 0x4fa9, 0xeac2, 0x50a9, 0x51a9, 0x52a9,
	0x53a9, 0x54a9, 0x55a9, 0x56a9, 0x57a9, 0x58a9, 0x59a9, 0x5aa9,
	0x61a9, 0x62a9, 0x63a9, 0x64a9, 0xebc2, 0x65a9, 0x66a9, 0xecc2,
	0x67a9, 0xedc2, 0x68a9, 0x69a9, 0x6aa9, 0x6ba9, 0x6ca9, 0x6da9,
	0x6ea9, 0x6fa9, 0x70a9, 0x71a9, 0x72a9, 0x73a9, 0x74a9, 0x75a9,
	0x76a9, 0x77a9, 0x78a9, 0x79a9, 0x7aa9, 0x81a9, 0x82a9, 0x83a9,
	0x84a9, 0x85a9, 0x86a9, 0x87a9, 0x88a9, 0x89a9, 0x8aa9, 0x8ba9,
	0x8ca9, 0x8da9, 0x8ea9, 0x8fa9, 0xeec2, 0xefc2, 0x90a9, 0x91a9,
	0xf0c2, 0x92a9, 0x93a9, 0x94a9, 0xf1c2, 0x95a9, 0x96a9, 0x97a9,
	0x98a9, 0x99a9, 0x9aa9, 0x9ba9, 0xf2c2, 0xf3c2, 0x9ca9, 0x9da9,
	0x9ea9, 0xf4c2, 0xf5c2, 0x9fa9, 0xa0a9, 0x41aa, 0x42aa, 0xf6c2,
	0xf7c2, 0xf8c2, 0x43aa, 0x44aa, 0xf9c2, 0x45aa, 0xfac2, 0x46aa,
	0xfbc2, 0x47aa, 0x48aa, 0x49aa, 0x4aaa, 0x4baa, 0x4caa, 0x4daa,
	0xfcc2, 0xfdc2, 0x4eaa, 0xfec2, 0xa1c3, 0xa2c3, 0xa3c3, 0x4faa,
	0x50aa, 0x51aa, 0x52aa, 0x53aa, 0xa4c3, 0xa5c3, 0x54aa, 0x55aa,
	0xa6c3, 0x56aa, 0x57aa, 0x58aa, 0xa7c3, 0x59aa, 0x5aaa, 0x61aa,
	0x62aa, 0x63aa, 0x64aa, 0x65aa, 0xa8c3, 0xa9c3, 0x66aa, 0xaac3,
	0xabc3, 0xacc3, 0x67aa, 0x68aa, 0x69aa, 0x6aaa, 0x6baa, 0x6caa,
	0xadc3, 0x6daa, 0x6eaa, 0x6faa, 0xaec3, 0x70aa, 0xafc3, 0x71aa,
	0xb0c3, 0x72aa, 0x73aa, 0x74aa, 0x75aa, 0x76aa, 0x77aa, 0x78aa,
	0xb1c3, 0x79aa, 0x7aaa, 0x81aa, 0x82aa, 0xb2c3, 0x83aa, 0x84aa,
	0x85aa, 0x86aa, 0x87aa, 0x88aa, 0x89aa, 0x8aaa, 0x8baa, 0x8caa,
	0x8daa, 0x8eaa, 0x8faa, 0x90aa, 0x91aa, 0x92aa, 0x93aa, 0x94aa,
	0x95aa, 0x96aa, 0x97aa, 0x98aa, 0x99aa, 0x9aaa, 0x9baa, 0x9caa,
	0x9daa, 0x9eaa, 0x9faa, 0xa0aa, 0x41ab, 0x42ab, 0x43ab, 0x44ab,
	0xb3c3, 0xb4c3, 0x45ab, 0x46ab, 0xb5c3, 0x47ab, 0x48ab, 0x49ab,
	0xb6c3, 0x4aab, 0x4bab, 0x4cab, 0x4dab, 0x4eab, 0x4fab, 0x50ab,
	0xb7c3, 0xb8c3, 0x51ab, 0xb9c3, 0xbac3, 0xbbc3, 0x52ab, 0x53ab,
	0x54ab, 0x55ab, 0x56ab, 0x57ab, 0xbcc3, 0xbdc3, 0x58ab, 0x59ab,
	0xbec3, 0x5aab, 0x61ab, 0x62ab, 0xbfc3, 0x63ab, 0x64ab, 0x65ab,
	0x66ab, 0x67ab, 0x68ab, 0x69ab, 0xc0c3, 0xc1c3, 0x6aab, 0xc2c3,
	0x6bab, 0xc3c3, 0x6cab, 0x6dab, 0x6eab, 0x6fab, 0x70ab, 0x71ab,
	0xc4c3, 0x72ab, 0x73ab, 0x74ab, 0xc5c3, 0x75ab, 0x76ab, 0x77ab,
	0x78ab, 0x79ab, 0x7aab, 0x81ab, 0x82ab, 0x83ab, 0x84ab, 0x85ab,
	0x86ab, 0x87ab, 0x88ab, 0x89ab, 0xc6c3, 0x8aab, 0x8bab, 0x8cab,
	0x8dab, 0x8eab, 0x8fab, 0x90ab, 0xc7c3, 0x91ab, 0x92ab, 0x93ab,
	0xc8c3, 0x94ab, 0x95ab, 0x96ab, 0x97ab, 0x98ab, 0x99ab, 0x9aab,
	0x9bab, 0x9cab, 0x9dab, 0x9eab, 0x9fab, 0xa0ab, 0x41ac, 0x42ac,
	0x43ac, 0xc9c3, 0x44ac, 0x45ac, 0x46ac, 0x47ac, 0x48ac, 0x49ac,
	0xcac3, 0xcbc3, 0x4aac, 0x4bac, 0xccc3, 0x4cac, 0x4dac, 0x4eac,
	0xcdc3, 0x4fac, 0x50ac, 0x51ac, 0x52ac, 0x53ac, 0x54ac, 0x55ac,
	0xcec3, 0xcfc3, 0x56ac, 0xd0c3, 0x57ac, 0xd1c3, 0x58ac, 0x59ac,
	0x5aac, 0x61ac, 0x62ac, 0x63ac, 0xd2c3, 0x64ac, 0x65ac, 0x66ac,
	0xd3c3, 0x67ac, 0x68ac, 0x69ac, 0xd4c3, 0x6aac, 0x6bac, 0x6cac,
	0x6dac, 0x6eac, 0x6fac, 0x70ac, 0x71ac, 0x72ac, 0x73ac, 0x74ac,
	0x75ac, 0xd5c3, 0x76ac, 0x77ac, 0x78ac, 0x79ac, 0x7aac, 0x81ac,
	0x82ac, 0x83ac, 0x84ac, 0x85ac, 0x86ac, 0x87ac, 0x88ac, 0x89ac,
	0x8aac, 0x8bac, 0x8cac, 0x8dac, 0x8eac, 0x8fac, 0x90ac, 0x91ac,
	0x92ac, 0x93ac, 0x94ac, 0x95ac, 0x96ac, 0x97ac, 0x98ac, 0x99ac,
	0x9aac, 0x9bac, 0x9cac, 0x9dac, 0xd6c3, 0x9eac, 0x9fac, 0xa0ac,
	0xd7c3, 0x41ad, 0x42ad, 0x43ad, 0xd8c3, 0x44ad, 0x45ad, 0x46ad,
	0x47ad, 0x48ad, 0x49ad, 0x4aad, 0xd9c3, 0xdac3, 0x4bad, 0xdbc3,
	0x4cad, 0xdcc3, 0x4dad, 0x4ead, 0x4fad, 0x50ad, 0x51ad, 0x52ad,
	0xddc3, 0x53ad, 0x54ad, 0x55ad, 0x56ad, 0x57ad, 0x58ad, 0x59ad,
	0x5aad, 0x61ad, 0x62ad, 0x63ad, 0x64ad, 0x65ad, 0x66ad, 0x67ad,
	0xdec3, 0x68ad, 0x69ad, 0x6aad, 0x6bad, 0x6cad, 0x6dad, 0x6ead,
	0x6fad, 0x70ad, 0x71ad, 0x72ad, 0xdfc3, 0xe0c3, 0x73ad, 0x74ad,
	0xe1c3, 0x75ad, 0x76ad, 0x77ad, 0xe2c3, 0x78ad, 0x79ad, 0x7aad,
	0x81ad, 0x82ad, 0x83ad, 0x84ad, 0xe3c3, 0xe4c3, 0x85ad, 0xe5c3,
	0x86ad, 0xe6c3, 0x87ad, 0x88ad, 0x89ad, 0x8aad, 0x8bad, 0x8cad,
	0xe7c3, 0x8dad, 0x8ead, 0x8fad, 0x90ad, 0x91ad, 0x92ad, 0x93ad,
	0x94ad, 0x95ad, 0x96ad, 0x97ad, 0x98ad, 0x99ad, 0x9aad, 0x9bad,
	0x9cad, 0x9dad, 0x9ead, 0x9fad, 0xe8c3, 0xa0ad, 0x41ae, 0x42ae,
	0x43ae, 0x44ae, 0x45ae, 0x46ae, 0xe9c3, 0x47ae, 0x48ae, 0x49ae,
	0xeac3, 0x4aae, 0x4bae, 0x4cae, 0x4dae, 0x4eae, 0x4fae, 0x50ae,
	0x51ae, 0x52ae, 0x53ae, 0x54ae, 0x55ae, 0x56ae, 0x57ae, 0x58ae,
	0x59ae, 0x5aae, 0x61ae, 0x62ae, 0x63ae, 0x64ae, 0x65ae, 0x66ae,
	0xebc3, 0x67ae, 0x68ae, 0x69ae, 0xecc3, 0x6aae, 0x6bae, 0x6cae,
	0xedc3, 0x6dae, 0x6eae, 0x6fae, 0x70ae, 0x71ae, 0x72ae, 0x73ae,
	0xeec3, 0xefc3, 0x74ae, 0xf0c3, 0x75ae, 0xf1c3, 0x76ae, 0x77ae,
	0x78ae, 0x79ae, 0x7aae, 0x81ae, 0xf2c3, 0x82ae, 0x83ae, 0x84ae,
	0xf3c3, 0x85ae, 0x86ae, 0x87ae, 0xf4c3, 0x88ae, 0x89ae, 0x8aae,
	0x8bae, 0x8cae, 0x8dae, 0x8eae, 0xf5c3, 0x8fae, 0x90ae, 0x91ae,
	0x92ae, 0xf6c3, 0x93ae, 0x94ae, 0x95ae, 0x96ae, 0x97ae, 0x98ae,
	0xf7c3, 0xf8c3, 0x99ae, 0x9aae, 0xf9c3, 0x9bae, 0x9cae, 0x9dae,
	0xfac3, 0x9eae, 0x9fae, 0xa0ae, 0x41af, 0x42af, 0x43af, 0x44af,
	0xfbc3, 0xfcc3, 0x45af, 0xfdc3, 0x46af, 0xfec3, 0x47af, 0x48af,
	0x49af, 0x4aaf, 0x4baf, 0x4caf, 0x4daf, 0x4eaf, 0x4faf, 0x50af,
	0x51af, 0x52af, 0x53af, 0x54af, 0x55af, 0x56af, 0x57af, 0x58af,
	0x59af, 0x5aaf, 0x61af, 0x62af, 0x63af, 0x64af, 0x65af, 0x66af,
	0x67af, 0x68af, 0x69af, 0x6aaf, 0x6baf, 0x6caf, 0x6daf, 0x6eaf,
	0xa1c4, 0xa2c4, 0x6faf, 0x70af, 0xa3c4, 0x71af, 0x72af, 0xa4c4,
	0xa5c4, 0xa6c4, 0x73af, 0x74af, 0x75af, 0x76af, 0x77af, 0x78af,
	0xa7c4, 0xa8c4, 0x79af, 0xa9c4, 0x7aaf, 0xaac4, 0x81af, 0x82af,
	0x83af, 0x84af, 0x85af, 0x86af, 0xabc4, 0xacc4, 0x87af, 0x88af,
	0xadc4, 0x89af, 0x8aaf, 0x8baf, 0xaec4, 0x8caf, 0x8daf, 0x8eaf,
	0x8faf, 0x90af, 0x91af, 0x92af, 0xafc4, 0xb0c4, 0x93af, 0xb1c4,
	0x94af, 0xb2c4, 0x95af, 0x96af, 0x97af, 0x98af, 0x99af, 0x9aaf,
	0xb3c4, 0xb4c4, 0x9baf, 0x9caf, 0xb5c4, 0x9daf, 0x9eaf, 0x9faf,
	0xb6c4, 0xa0af, 0x41b0, 0x42b0, 0x43b0, 0x44b0, 0x45b0, 0x46b0,
	0xb7c4, 0xb8c4, 0x47b0, 0xb9c4, 0xbac4, 0xbbc4, 0x48b0, 0x49b0,
	0x4ab0, 0x4bb0, 0x4cb0, 0x4db0, 0xbcc4, 0xbdc4, 0x4eb0, 0x4fb0,
	0x50b0, 0x51b0, 0x52b0, 0x53b0, 0x54b0, 0x55b0, 0x56b0, 0x57b0,
	0x58b0, 0x59b0, 0x5ab0, 0x61b0, 0x62b0, 0x63b0, 0x64b0, 0x65b0,
	0x66b0, 0xbec4, 0x67b0, 0x68b0, 0x69b0, 0x6ab0, 0x6bb0, 0x6cb0,
	0x6db0, 0x6eb0, 0x6fb0, 0x70b0, 0x71b0, 0x72b0, 0x73b0, 0x74b0,
	0x75b0, 0x76b0, 0x77b0, 0x78b0, 0x79b0, 0x7ab0, 0x81b0, 0x82b0,
	0x83b0, 0x84b0, 0x85b0, 0x86b0, 0x87b0, 0x88b0, 0x89b0, 0x8ab0,
	0x8bb0, 0x8cb0, 0x8db0, 0x8eb0, 0xbfc4, 0xc0c4, 0x8fb0, 0x90b0,
	0xc1c4, 0x91b0, 0x92b0, 0xc2c4, 0xc3c4, 0x93b0, 0x94b0, 0x95b0,
	0x96b0, 0x97b0, 0x98b0, 0x99b0, 0xc4c4, 0xc5c4, 0x9ab0, 0xc6c4,
	0xc7c4, 0xc8c4, 0x9bb0, 0x9cb0, 0x9db0, 0x9eb0, 0x9fb0, 0xa0b0,
	0xc9c4, 0xcac4, 0x41b1, 0x42b1, 0xcbc4, 0x43b1, 0x44b1, 0x45b1,
	0xccc4, 0x46b1, 0x47b1, 0x48b1, 0x49b1, 0x4ab1, 0x4bb1, 0x4cb1,
	0xcdc4, 0xcec4, 0x4db1, 0xcfc4, 0x4eb1, 0xd0c4, 0x4fb1, 0x50b1,
	0x51b1, 0x52b1, 0x53b1, 0x54b1, 0xd1c4, 0x55b1, 0x56b1, 0x57b1,
	0xd2c4, 0x58b1, 0x59b1, 0x5ab1, 0xd3c4, 0x61b1, 0x62b1, 0x63b1,
	0x64b1, 0x65b1, 0x66b1, 0x67b1, 0xd4c4, 0xd5c4, 0x68b1, 0xd6c4,
	0xd7c4, 0xd8c4, 0x69b1, 0x6ab1, 0x6bb1, 0x6cb1, 0x6db1, 0x6eb1,
	0xd9c4, 0x6fb1, 0x70b1, 0x71b1, 0x72b1, 0x73b1, 0x74b1, 0x75b1,
	0x76b1, 0x77b1, 0x78b1, 0x79b1, 0x7ab1, 0x81b1, 0x82b1, 0x83b1,
	0x84b1, 0x85b1, 0x86b1, 0x87b1, 0x88b1, 0x89b1, 0x8ab1, 0x8bb1,
	0x8cb1, 0x8db1, 0x8eb1, 0x8fb1, 0xdac4, 0xdbc4, 0x90b1, 0x91b1,
	0xdcc4, 0x92b1, 0x93b1, 0x94b1, 0xddc4, 0x95b1, 0x96b1, 0x97b1,
	0x98b1, 0x99b1, 0x9ab1, 0x9bb1, 0xdec4, 0xdfc4, 0x9cb1, 0xe0c4,
	0x9db1, 0xe1c4, 0x9eb1, 0x9fb1, 0xa0b1, 0x41b2, 0x42b2, 0x43b2,
	0xe2c4, 0xe3c4, 0x44b2, 0x45b2, 0xe4c4, 0x46b2, 0x47b2, 0x48b2,
	0xe5c4, 0x49b2, 0x4ab2, 0x4bb2, 0x4cb2, 0x4db2, 0x4eb2, 0x4fb2,
	0xe6c4, 0x50b2, 0x51b2, 0x52b2, 0x53b2, 0xe7c4, 0x54b2, 0x55b2,
	0x56b2, 0x57b2, 0x58b2, 0x59b2, 0xe8c4, 0x5ab2, 0x61b2, 0x62b2,
	0x63b2, 0x64b2, 0x65b2, 0x66b2, 0x67b2, 0x68b2, 0x69b2, 0x6ab2,
	0x6bb2, 0x6cb2, 0x6db2, 0x6eb2, 0x6fb2, 0x70b2, 0x71b2, 0x72b2,
	0x73b2, 0xe9c4, 0x74b2, 0x75b2, 0x76b2, 0x77b2, 0x78b2, 0x79b2,
	0xeac4, 0x7ab2, 0x81b2, 0x82b2, 0x83b2, 0x84b2, 0x85b2, 0x86b2,
	0xebc4, 0x87b2, 0x88b2, 0x89b2, 0x8ab2, 0x8bb2, 0x8cb2, 0x8db2,
	0x8eb2, 0x8fb2, 0x90b2, 0x91b2, 0x92b2, 0x93b2, 0x94b2, 0x95b2,
	0x96b2, 0x97b2, 0x98b2, 0x99b2, 0xecc4, 0x9ab2, 0x9bb2, 0x9cb2,
	0x9db2, 0x9eb2, 0x9fb2, 0xa0b2, 0x41b3, 0x42b3, 0x43b3, 0x44b3,
	0x45b3, 0x46b3, 0x47b3, 0x48b3, 0x49b3, 0x4ab3, 0x4bb3, 0x4cb3,
	0x4db3, 0x4eb3, 0x4fb3, 0x50b3, 0x51b3, 0x52b3, 0x53b3, 0x54b3,
	0xedc4, 0xeec4, 0x55b3, 0x56b3, 0xefc4, 0x57b3, 0x58b3, 0x59b3,
	0xf0c4, 0x5ab3, 0x61b3, 0x62b3, 0x63b3, 0x64b3, 0x65b3, 0x66b3,
	0xf1c4, 0xf2c4, 0x67b3, 0xf3c4, 0x68b3, 0xf4c4, 0x69b3, 0x6ab3,
	0x6bb3, 0x6cb3, 0x6db3, 0x6eb3, 0xf5c4, 0x6fb3, 0x70b3, 0x71b3,
	0xf6c4, 0x72b3, 0x73b3, 0x74b3, 0xf7c4, 0x75b3, 0x76b3, 0x77b3,
	0x78b3, 0x79b3, 0x7ab3, 0x81b3, 0x82b3, 0x83b3, 0x84b3, 0x85b3,
	0x86b3, 0xf8c4, 0x87b3, 0x88b3, 0x89b3, 0x8ab3, 0x8bb3, 0x8cb3,
	0xf9c4, 0x8db3, 0x8eb3, 0x8fb3, 0x90b3, 0x91b3, 0x92b3, 0x93b3,
	0x94b3, 0x95b3, 0x96b3, 0x97b3, 0x98b3, 0x99b3, 0x9ab3, 0x9bb3,
	0x9cb3, 0x9db3, 0x9eb3, 0x9fb3, 0xa0b3, 0xfac4, 0x41b4, 0x42b4,
	0x43b4, 0x44b4, 0x45b4, 0x46b4, 0xfbc4, 0xfcc4, 0x47b4, 0x48b4,
	0xfdc4, 0x49b4, 0x4ab4, 0x4bb4, 0xfec4, 0x4cb4, 0x4db4, 0x4eb4,
	0x4fb4, 0x50b4, 0x51b4, 0x52b4, 0xa1c5, 0xa2c5, 0x53b4, 0xa3c5,
	0x54b4, 0xa4c5, 0x55b4, 0x56b4, 0x57b4, 0x58b4, 0x59b4, 0x5ab4,
	0xa5c5, 0x61b4, 0x62b4, 0x63b4, 0xa6c5, 0x64b4, 0x65b4, 0x66b4,
	0xa7c5, 0x67b4, 0x68b4, 0x69b4, 0x6ab4, 0x6bb4, 0x6cb4, 0x6db4,
	0xa8c5, 0x6eb4, 0x6fb4, 0x70b4, 0x71b4, 0x72b4, 0x73b4, 0x74b4,
	0x75b4, 0x76b4, 0x77b4, 0x78b4, 0xa9c5, 0xaac5, 0x79b4, 0x7ab4,
	0xabc5, 0x81b4, 0x82b4, 0x83b4, 0xacc5, 0x84b4, 0x85b4, 0x86b4,
	0x87b4, 0x88b4, 0x89b4, 0x8ab4, 0xadc5, 0xaec5, 0x8bb4, 0x8cb4,
	0x8db4, 0xafc5, 0x8eb4, 0x8fb4, 0x90b4, 0x91b4, 0x92b4, 0x93b4,
	0x94b4, 0x95b4, 0x96b4, 0x97b4, 0x98b4, 0x99b4, 0x9ab4, 0x9bb4,
	0x9cb4, 0x9db4, 0x9eb4, 0x9fb4, 0xa0b4, 0x41b5, 0x42b5, 0x43b5,
	0x44b5, 0x45b5, 0x46b5, 0x47b5, 0x48b5, 0x49b5, 0x4ab5, 0x4bb5,
	0x4cb5, 0x4db5, 0x4eb5, 0x4fb5, 0xb0c5, 0xb1c5, 0x50b5, 0x51b5,
	0xb2c5, 0x52b5, 0x53b5, 0x54b5, 0xb3c5, 0x55b5, 0x56b5, 0x57b5,
	0x58b5, 0x59b5, 0x5ab5, 0x61b5, 0xb4c5, 0xb5c5, 0x62b5, 0xb6c5,
	0x63b5, 0xb7c5, 0x64b5, 0x65b5, 0x66b5, 0x67b5, 0x68b5, 0x69b5,
	0xb8c5, 0xb9c5, 0x6ab5, 0x6bb5, 0xbac5, 0x6cb5, 0x6db5, 0x6eb5,
	0xbbc5, 0xbcc5, 0x6fb5, 0x70b5, 0x71b5, 0x72b5, 0x73b5, 0x74b5,
	0xbdc5, 0xbec5, 0x75b5, 0xbfc5, 0xc0c5, 0xc1c5, 0x76b5, 0x77b5,
	0x78b5, 0x79b5, 0x7ab5, 0x81b5, 0xc2c5, 0xc3c5, 0x82b5, 0x83b5,
	0xc4c5, 0x84b5, 0x85b5, 0x86b5, 0xc5c5, 0x87b5, 0x88b5, 0x89b5,
	0x8ab5, 0x8bb5, 0x8cb5, 0x8db5, 0xc6c5, 0xc7c5, 0x8eb5, 0xc8c5,
	0xc9c5, 0xcac5, 0x8fb5, 0x90b5, 0x91b5, 0x92b5, 0x93b5, 0x94b5,
	0xcbc5, 0x95b5, 0x96b5, 0x97b5, 0x98b5, 0x99b5, 0x9ab5, 0x9bb5,
	0x9cb5, 0x9db5, 0x9eb5, 0x9fb5, 0xa0b5, 0x41b6, 0x42b6, 0x43b6,
	0x44b6, 0x45b6, 0x46b6, 0x47b6, 0x48b6, 0xccc5, 0x49b6, 0x4ab6,
	0x4bb6, 0x4cb6, 0x4db6, 0x4eb6, 0x4fb6, 0x50b6, 0x51b6, 0x52b6,
	0x53b6, 0x54b6, 0x55b6, 0x56b6, 0x57b6, 0x58b6, 0x59b6, 0x5ab6,
	0x61b6, 0x62b6, 0x63b6, 0x64b6, 0x65b6, 0x66b6, 0x67b6, 0x68b6,
	0x69b6, 0x6ab6, 0x6bb6, 0x6cb6, 0x6db6, 0x6eb6, 0x6fb6, 0x70b6,
	0xcdc5, 0xcec5, 0x71b6, 0x72b6, 0xcfc5, 0x73b6, 0x74b6, 0x75b6,
	0xd0c5, 0x76b6, 0xd1c5, 0x77b6, 0x78b6, 0x79b6, 0x7ab6, 0x81b6,
	0xd2c5, 0xd3c5, 0x82b6, 0xd4c5, 0xd5c5, 0xd6c5, 0x83b6, 0x84b6,
	0x85b6, 0x86b6, 0x87b6, 0x88b6, 0xd7c5, 0xd8c5, 0x89b6, 0x8ab6,
	0xd9c5, 0x8bb6, 0x8cb6, 0x8db6, 0xdac5, 0x8eb6, 0x8fb6, 0x90b6,
	0x91b6, 0x92b6, 0x93b6, 0x94b6, 0xdbc5, 0xdcc5, 0x95b6, 0xddc5,
	0x96b6, 0xdec5, 0x97b6, 0x98b6, 0x99b6, 0x9ab6, 0x9bb6, 0x9cb6,
	0xdfc5, 0x9db6, 0x9eb6, 0x9fb6, 0xe0c5, 0xa0b6, 0x41b7, 0x42b7,
	0x43b7, 0x44b7, 0x45b7, 0x46b7, 0x47b7, 0x48b7, 0x49b7, 0x4ab7,
	0x4bb7, 0x4cb7, 0x4db7, 0x4eb7, 0xe1c5, 0x4fb7, 0x50b7, 0x51b7,
	0x52b7, 0x53b7, 0x54b7, 0x55b7, 0xe2c5, 0x56b7, 0x57b7, 0x58b7,
	0xe3c5, 0x59b7, 0x5ab7, 0x61b7, 0x62b7, 0x63b7, 0x64b7, 0x65b7,
	0x66b7, 0x67b7, 0x68b7, 0x69b7, 0x6ab7, 0x6bb7, 0x6cb7, 0x6db7,
	0x6eb7, 0x6fb7, 0x70b7, 0x71b7, 0x72b7, 0x73b7, 0x74b7, 0x75b7,
	0xe4c5, 0xe5c5, 0x76b7, 0x77b7, 0xe6c5, 0x78b7, 0x79b7, 0x7ab7,
	0xe7c5, 0x81b7, 0x82b7, 0x83b7, 0x84b7, 0x85b7, 0x86b7, 0x87b7,
	0xe8c5, 0xe9c5, 0x88b7, 0xeac5, 0x89b7, 0xebc5, 0x8ab7, 0x8bb7,
	0x8cb7, 0x8db7, 0xecc5, 0x8eb7, 0xedc5, 0x8fb7, 0x90b7, 0x91b7,
	0xeec5, 0x92b7, 0x93b7, 0x94b7, 0x95b7, 0x96b7, 0x97b7, 0x98b7,
	0x99b7, 0x9ab7, 0x9bb7, 0x9cb7, 0x9db7, 0x9eb7, 0x9fb7, 0xa0b7,
	0x41b8, 0x42b8, 0x43b8, 0x44b8, 0x45b8, 0x46b8, 0x47b8, 0x48b8,
	0xefc5, 0x49b8, 0x4ab8, 0x4bb8, 0x4cb8, 0x4db8, 0x4eb8, 0x4fb8,
	0x50b8, 0x51b8, 0x52b8, 0x53b8, 0x54b8, 0x55b8, 0x56b8, 0x57b8,
	0x58b8, 0x59b8, 0x5ab8, 0x61b8, 0x62b8, 0x63b8, 0x64b8, 0x65b8,
	0x66b8, 0x67b8, 0x68b8, 0x69b8, 0xf0c5, 0x6ab8, 0x6bb8, 0x6cb8,
	0xf1c5, 0x6db8, 0x6eb8, 0x6fb8, 0x70b8, 0x71b8, 0x72b8, 0x73b8,
	0x74b8, 0x75b8, 0x76b8, 0x77b8, 0x78b8, 0x79b8, 0x7ab8, 0xf2c5,
	0x81b8, 0xf3c5, 0x82b8, 0x83b8, 0x84b8, 0x85b8, 0x86b8, 0x87b8,
	0xf4c5, 0x88b8, 0x89b8, 0x8ab8, 0x8bb8, 0x8cb8, 0x8db8, 0x8eb8,
	0x8fb8, 0x90b8, 0x91b8, 0x92b8, 0x93b8, 0x94b8, 0x95b8, 0x96b8,
	0x97b8, 0x98b8, 0x99b8, 0x9ab8, 0x9bb8, 0x9cb8, 0x9db8, 0x9eb8,
	0x9fb8, 0xa0b8, 0x41b9, 0x42b9, 0xf5c5, 0xf6c5, 0x43b9, 0x44b9,
	0xf7c5, 0x45b9, 0x46b9, 0x47b9, 0xf8c5, 0x48b9, 0x49b9, 0x4ab9,
	0x4bb9, 0x4cb9, 0x4db9, 0x4eb9, 0xf9c5, 0xfac5, 0x4fb9, 0xfbc5,
	0x50b9, 0xfcc5, 0x51b9, 0x52b9, 0x53b9, 0x54b9, 0x55b9, 0x56b9,
	0xfdc5, 0x57b9, 0x58b9, 0x59b9, 0x5ab9, 0x61b9, 0x62b9, 0x63b9,
	0x64b9, 0x65b9, 0x66b9, 0x67b9, 0x68b9, 0x69b9, 0x6ab9, 0x6bb9,
	0x6cb9, 0x6db9, 0x6eb9, 0x6fb9, 0xfec5, 0x70b9, 0x71b9, 0x72b9,
	0x73b9, 0x74b9, 0x75b9, 0x76b9, 0xa1c6, 0x77b9, 0x78b9, 0x79b9,
	0x7ab9, 0x81b9, 0x82b9, 0x83b9, 0x84b9, 0x85b9, 0x86b9, 0x87b9,
	0x88b9, 0x89b9, 0x8ab9, 0x8bb9, 0x8cb9, 0x8db9, 0x8eb9, 0x8fb9,
	0x90b9, 0x91b9, 0x92b9, 0x93b9, 0x94b9, 0x95b9, 0x96b9, 0x97b9,
	0xa2c6, 0xa3c6, 0x98b9, 0x99b9, 0xa4c6, 0x9ab9, 0x9bb9, 0x9cb9,
	0xa5c6, 0x9db9, 0x9eb9, 0x9fb9, 0xa0b9, 0x41ba, 0x42ba, 0x43ba,
	0xa6c6, 0xa7c6, 0x44ba, 0x45ba, 0x46ba, 0xa8c6, 0x47ba, 0x48ba,
	0x49ba, 0x4aba, 0x4bba, 0x4cba, 0xa9c6, 0x4dba, 0x4eba, 0x4fba,
	0xaac6, 0x50ba, 0x51ba, 0x52ba, 0xabc6, 0x53ba, 0x54ba, 0x55ba,
	0x56ba, 0x57ba, 0x58ba, 0x59ba, 0xacc6, 0x5aba, 0x61ba, 0x62ba,
	0x63ba, 0xadc6, 0x64ba, 0x65ba, 0x66ba, 0x67ba, 0x68ba, 0x69ba,
	0xaec6, 0xafc6, 0x6aba, 0x6bba, 0xb0c6, 0x6cba, 0x6dba, 0xb1c6,
	0xb2c6, 0x6eba, 0xb3c6, 0x6fba, 0x70ba, 0x71ba, 0x72ba, 0x73ba,
	0xb4c6, 0xb5c6, 0x74ba, 0xb6c6, 0x75ba, 0x76ba, 0x77ba, 0x78ba,
	0x79ba, 0x7aba, 0x81ba, 0x82ba, 0xb7c6, 0x83ba, 0x84ba, 0x85ba,
	0xb8c6, 0x86ba, 0x87ba, 0x88ba, 0xb9c6, 0x89ba, 0x8aba, 0x8bba,
	0x8cba, 0x8dba, 0x8eba, 0x8fba, 0xbac6, 0xbbc6, 0x90ba, 0x91ba,
	0x92ba, 0x93ba, 0x94ba, 0x95ba, 0x96ba, 0x97ba, 0x98ba, 0x99ba,
	0xbcc6, 0xbdc6, 0x9aba, 0x9bba, 0xbec6, 0x9cba, 0x9dba, 0x9eba,
	0xbfc6, 0x9fba, 0xa0ba, 0x41bb, 0x42bb, 0x43bb, 0x44bb, 0x45bb,
	0xc0c6, 0xc1c6, 0x46bb, 0xc2c6, 0x47bb, 0xc3c6, 0x48bb, 0x49bb,
	0x4abb, 0x4bbb, 0x4cbb, 0x4dbb, 0xc4c6, 0xc5c6, 0xc6c6, 0x4ebb,
	0xc7c6, 0x4fbb, 0x50bb, 0x51bb, 0xc8c6, 0x52bb, 0xc9c6, 0x53bb,
	0x54bb, 0x55bb, 0x56bb, 0x57bb, 0xcac6, 0xcbc6, 0x58bb, 0xccc6,
	0xcdc6, 0xcec6, 0x59bb, 0x5abb, 0x61bb, 0xcfc6, 0x62bb, 0x63bb,
	0xd0c6, 0xd1c6, 0x64bb, 0x65bb, 0xd2c6, 0x66bb, 0x67bb, 0x68bb,
	0xd3c6, 0x69bb, 0x6abb, 0x6bbb, 0x6cbb, 0x6dbb, 0x6ebb, 0x6fbb,
	0xd4c6, 0xd5c6, 0x70bb, 0xd6c6, 0xd7c6, 0xd8c6, 0x71bb, 0x72bb,
	0x73bb, 0x74bb, 0x75bb, 0x76bb, 0xd9c6, 0xdac6, 0x77bb, 0x78bb,
	0x79bb, 0x7abb, 0x81bb, 0x82bb, 0x83bb, 0x84bb, 0x85bb, 0x86bb,
	0x87bb, 0x88bb, 0x89bb, 0x8abb, 0x8bbb, 0x8cbb, 0x8dbb, 0x8ebb,
	0x8fbb, 0x90bb, 0x91bb, 0x92bb, 0x93bb, 0x94bb, 0x95bb, 0x96bb,
	0x97bb, 0x98bb, 0x99bb, 0x9abb, 0x9bbb, 0x9cbb, 0x9dbb, 0x9ebb,
	0x9fbb, 0xa0bb, 0x41bc, 0x42bc, 0x43bc, 0x44bc, 0x45bc, 0x46bc,
	0x47bc, 0x48bc, 0x49bc, 0x4abc, 0x4bbc, 0x4cbc, 0x4dbc, 0x4ebc,
	0x4fbc, 0x50bc, 0x51bc, 0x52bc, 0xdbc6, 0xdcc6, 0x53bc, 0x54bc,
	0xddc6, 0x55bc, 0x56bc, 0x57bc, 0xdec6, 0x58bc, 0x59bc, 0x5abc,
	0x61bc, 0x62bc, 0x63bc, 0x64bc, 0xdfc6, 0xe0c6, 0x65bc, 0xe1c6,
	0xe2c6, 0xe3c6, 0x66bc, 0x67bc, 0x68bc, 0x69bc, 0x6abc, 0x6bbc,
	0xe4c6, 0xe5c6, 0x6cbc, 0x6dbc, 0xe6c6, 0x6ebc, 0x6fbc, 0x70bc,
	0xe7c6, 0x71bc, 0x72bc, 0x73bc, 0x74bc, 0x75bc, 0x76bc, 0x77bc,
	0xe8c6, 0xe9c6, 0x78bc, 0xeac6, 0x79bc, 0xebc6, 0x7abc, 0x81bc,
	0x82bc, 0x83bc, 0x84bc, 0x85bc, 0xecc6, 0x86bc, 0x87bc, 0x88bc,
	0xedc6, 0x89bc, 0x8abc, 0x8bbc, 0xeec6, 0x8cbc, 0x8dbc, 0x8ebc,
	0x8fbc, 0x90bc, 0x91bc, 0x92bc, 0xefc6, 0xf0c6, 0x93bc, 0x94bc,
	0xf1c6, 0xf2c6, 0x95bc, 0x96bc, 0x97bc, 0x98bc, 0x99bc, 0x9abc,
	0xf3c6, 0x9bbc, 0x9cbc, 0x9dbc, 0x9ebc, 0x9fbc, 0xa0bc, 0x41bd,
	0xf4c6, 0x42bd, 0x43bd, 0x44bd, 0x45bd, 0x46bd, 0x47bd, 0x48bd,
	0x49bd, 0xf5c6, 0x4abd, 0xf6c6, 0x4bbd, 0x4cbd, 0x4dbd, 0x4ebd,
	0x4fbd, 0x50bd, 0x51bd, 0x52bd, 0xf7c6, 0xf8c6, 0x53bd, 0x54bd,
	0xf9c6, 0x55bd, 0x56bd, 0x57bd, 0xfac6, 0x58bd, 0x59bd, 0x5abd,
	0x61bd, 0x62bd, 0x63bd, 0x64bd, 0xfbc6, 0xfcc6, 0x65bd, 0xfdc6,
	0x66bd, 0xfec6, 0x67bd, 0x68bd, 0x69bd, 0x6abd, 0x6bbd, 0x6cbd,
	0xa1c7, 0x6dbd, 0x6ebd, 0x6fbd, 0x70bd, 0x71bd, 0x72bd, 0x73bd,
	0x74bd, 0x75bd, 0x76bd, 0x77bd, 0x78bd, 0x79bd, 0x7abd, 0x81bd,
	0x82bd, 0x83bd, 0x84bd, 0x85bd, 0x86bd, 0xa2c7, 0x87bd, 0x88bd,
	0x89bd, 0x8abd, 0x8bbd, 0x8cbd, 0x8dbd, 0x8ebd, 0x8fbd, 0x90bd,
	0x91bd, 0x92bd, 0x93bd, 0x94bd, 0x95bd, 0x96bd, 0x97bd, 0x98bd,
	0x99bd, 0x9abd, 0x9bbd, 0x9cbd, 0x9dbd, 0x9ebd, 0x9fbd, 0xa0bd,
	0x41be, 0x42be, 0x43be, 0x44be, 0x45be, 0x46be, 0x47be, 0x48be,
	0xa3c7, 0x49be, 0x4abe, 0x4bbe, 0xa4c7, 0x4cbe, 0x4dbe, 0x4ebe,
	0x4fbe, 0x50be, 0x51be, 0x52be, 0x53be, 0x54be, 0x55be, 0x56be,
	0x57be, 0x58be, 0x59be, 0x5abe, 0x61be, 0x62be, 0x63be, 0x64be,
	0x65be, 0x66be, 0x67be, 0x68be, 0xa5c7, 0x69be, 0x6abe, 0x6bbe,
	0xa6c7, 0x6cbe, 0x6dbe, 0x6ebe, 0xa7c7, 0x6fbe, 0x70be, 0x71be,
	0x72be, 0x73be, 0x74be, 0x75be, 0x76be, 0xa8c7, 0x77be, 0xa9c7,
	0x78be, 0x79be, 0x7abe, 0x81be, 0x82be, 0x83be, 0x84be, 0x85be,
	0xaac7, 0xabc7, 0x86be, 0x87be, 0xacc7, 0x88be, 0x89be, 0xadc7,
	0xaec7, 0x8abe, 0xafc7, 0x8bbe, 0x8cbe, 0x8dbe, 0x8ebe, 0x8fbe,
	0xb0c7, 0xb1c7, 0x90be, 0xb2c7, 0x91be, 0xb3c7, 0x92be, 0x93be,
	0x94be, 0x95be, 0x96be, 0x97be, 0xb4c7, 0x98be, 0x99be, 0x9abe,
	0x9bbe, 0x9cbe, 0x9dbe, 0x9ebe, 0x9fbe, 0xa0be, 0x41bf, 0x42bf,
	0x43bf, 0x44bf, 0x45bf, 0x46bf, 0x47bf, 0x48bf, 0x49bf, 0x4abf,
	0x4bbf, 0xb5c7, 0x4cbf, 0x4dbf, 0x4ebf, 0x4fbf, 0x50bf, 0x51bf,
	0x52bf, 0x53bf, 0x54bf, 0x55bf, 0x56bf, 0x57bf, 0x58bf, 0x59bf,
	0x5abf, 0x61bf, 0x62bf, 0x63bf, 0x64bf, 0x65bf, 0x66bf, 0x67bf,
	0x68bf, 0x69bf, 0x6abf, 0x6bbf, 0x6cbf, 0x6dbf, 0x6ebf, 0x6fbf,
	0x70bf, 0x71bf, 0x72bf, 0x73bf, 0xb6c7, 0x74bf, 0x75bf, 0x76bf,
	0xb7c7, 0x77bf, 0x78bf, 0x79bf, 0xb8c7, 0x7abf, 0x81bf, 0x82bf,
	0x83bf, 0x84bf, 0x85bf, 0x86bf, 0xb9c7, 0x87bf, 0x88bf, 0xbac7,
	0x89bf, 0x8abf, 0x8bbf, 0x8cbf, 0x8dbf, 0x8ebf, 0x8fbf, 0x90bf,
	0xbbc7, 0x91bf, 0x92bf, 0x93bf, 0xbcc7, 0x94bf, 0x95bf, 0x96bf,
	0xbdc7, 0x97bf, 0x98bf, 0x99bf, 0x9abf, 0x9bbf, 0x9cbf, 0x9dbf,
	0xbec7, 0x9ebf, 0x9fbf, 0xbfc7, 0xa0bf, 0xc0c7, 0x41c0, 0x42c0,
	0x43c0, 0x44c0, 0x45c0, 0x46c0, 0xc1c7, 0x47c0, 0x48c0, 0x49c0,
	0xc2c7, 0x4ac0, 0x4bc0, 0x4cc0, 0xc3c7, 0x4dc0, 0x4ec0, 0x4fc0,
	0x50c0, 0x51c0, 0x52c0, 0x53c0, 0xc4c7, 0xc5c7, 0x54c0, 0xc6c7,
	0x55c0, 0x56c0, 0x57c0, 0x58c0, 0x59c0, 0x5ac0, 0x61c0, 0x62c0,
	0x63c0, 0x64c0, 0x65c0, 0x66c0, 0x67c0, 0x68c0, 0x69c0, 0x6ac0,
	0x6bc0, 0x6cc0, 0x6dc0, 0x6ec0, 0x6fc0, 0x70c0, 0x71c0, 0x72c0,
	0x73c0, 0x74c0, 0x75c0, 0x76c0, 0x77c0, 0x78c0, 0x79c0, 0x7ac0,
	0x81c0, 0x82c0, 0x83c0, 0x84c0, 0xc7c7, 0xc8c7, 0x85c0, 0x86c0,
	0xc9c7, 0x87c0, 0x88c0, 0x89c0, 0xcac7, 0x8ac0, 0x8bc0, 0x8cc0,
	0x8dc0, 0x8ec0, 0x8fc0, 0x90c0, 0xcbc7, 0xccc7, 0x91c0, 0xcdc7,
	0x92c0, 0xcec7, 0x93c0, 0x94c0, 0x95c0, 0x96c0, 0x97c0, 0x98c0,
	0xcfc7, 0xd0c7, 0x99c0, 0x9ac0, 0xd1c7, 0x9bc0, 0x9cc0, 0x9dc0,
	0xd2c7, 0x9ec0, 0x9fc0, 0xa0c0, 0x41c1, 0xd3c7, 0x42c1, 0x43c1,
	0xd4c7, 0xd5c7, 0x44c1, 0xd6c7, 0x45c1, 0xd7c7, 0x46c1, 0x47c1,
	0x48c1, 0x49c1, 0x4ac1, 0x4bc1, 0xd8c7, 0xd9c7, 0x4cc1, 0x4dc1,
	0xdac7, 0x4ec1, 0x4fc1, 0x50c1, 0xdbc7, 0x51c1, 0x52c1, 0x53c1,
	0x54c1, 0x55c1, 0x56c1, 0x57c1, 0xdcc7, 0xddc7, 0x58c1, 0xdec7,
	0xdfc7, 0xe0c7, 0x59c1, 0x5ac1, 0x61c1, 0x62c1, 0x63c1, 0x64c1,
	0xe1c7, 0x65c1, 0x66c1, 0x67c1, 0x68c1, 0x69c1, 0x6ac1, 0x6bc1,
	0x6cc1, 0x6dc1, 0x6ec1, 0x6fc1, 0x70c1, 0x71c1, 0x72c1, 0x73c1,
	0x74c1, 0x75c1, 0x76c1, 0x77c1, 0x78c1, 0xe2c7, 0x79c1, 0x7ac1,
	0x81c1, 0x82c1, 0x83c1, 0x84c1, 0x85c1, 0x86c1, 0x87c1, 0x88c1,
	0x89c1, 0x8ac1, 0x8bc1, 0x8cc1, 0x8dc1, 0x8ec1, 0x8fc1, 0x90c1,
	0x91c1, 0x92c1, 0x93c1, 0x94c1, 0x95c1, 0x96c1, 0x97c1, 0x98c1,
	0x99c1, 0x9ac1, 0x9bc1, 0x9cc1, 0x9dc1, 0x9ec1, 0x9fc1, 0xa0c1,
	0xe3c7, 0xe4c7, 0x41c2, 0x42c2, 0xe5c7, 0x43c2, 0x44c2, 0x45c2,
	0xe6c7, 0x46c2, 0xe7c7, 0x47c2, 0x48c2, 0x49c2, 0x4ac2, 0x4bc2,
	0xe8c7, 0xe9c7, 0x4cc2, 0xeac7, 0x4dc2, 0xebc7, 0x4ec2, 0x4fc2,
	0x50c2, 0x51c2, 0x52c2, 0x53c2, 0xecc7, 0xedc7, 0x54c2, 0x55c2,
	0xeec7, 0x56c2, 0x57c2, 0x58c2, 0xefc7, 0x59c2, 0x5ac2, 0x61c2,
	0x62c2, 0x63c2, 0x64c2, 0x65c2, 0xf0c7, 0xf1c7, 0x66c2, 0xf2c7,
	0x67c2, 0xf3c7, 0x68c2, 0x69c2, 0x6ac2, 0x6bc2, 0x6cc2, 0x6dc2,
	0xf4c7, 0xf5c7, 0x6ec2, 0x6fc2, 0xf6c7, 0x70c2, 0x71c2, 0x72c2,
	0xf7c7, 0x73c2, 0x74c2, 0x75c2, 0x76c2, 0x77c2, 0x78c2, 0x79c2,
	0xf8c7, 0xf9c7, 0x7ac2, 0xfac7, 0xfbc7, 0xfcc7, 0x81c2, 0x82c2,
	0x83c2, 0x84c2, 0x85c2, 0x86c2, 0xfdc7, 0x87c2, 0x88c2, 0x89c2,
	0xfec7, 0x8ac2, 0x8bc2, 0x8cc2, 0xa1c8, 0x8dc2, 0x8ec2, 0x8fc2,
	0x90c2, 0x91c2, 0x92c2, 0x93c2, 0x94c2, 0xa2c8, 0x95c2, 0x96c2,
	0x97c2, 0x98c2, 0x99c2, 0x9ac2, 0x9bc2, 0x9cc2, 0x9dc2, 0x9ec2,
	0xa3c8, 0xa4c8, 0x9fc2, 0xa0c2, 0xa5c8, 0x41c3, 0x42c3, 0x43c3,
	0xa6c8, 0x44c3, 0x45c3, 0x46c3, 0x47c3, 0xa7c8, 0x48c3, 0x49c3,
	0xa8c8, 0xa9c8, 0x4ac3, 0xaac8, 0x4bc3, 0xabc8, 0x4cc3, 0x4dc3,
	0x4ec3, 0xacc8, 0x4fc3, 0x50c3, 0xadc8, 0xaec8, 0x51c3, 0x52c3,
	0xafc8, 0x53c3, 0x54c3, 0x55c3, 0xb0c8, 0x56c3, 0x57c3, 0x58c3,
	0x59c3, 0x5ac3, 0x61c3, 0x62c3, 0x63c3, 0x64c3, 0x65c3, 0xb1c8,
	0x66c3, 0xb2c8, 0x67c3, 0x68c3, 0x69c3, 0x6ac3, 0x6bc3, 0x6cc3,
	0xb3c8, 0xb4c8, 0x6dc3, 0x6ec3, 0xb5c8, 0x6fc3, 0x70c3, 0x71c3,
	0x72c3, 0x73c3, 0x74c3, 0x75c3, 0x76c3, 0x77c3, 0x78c3, 0x79c3,
	0x7ac3, 0x81c3, 0x82c3, 0xb6c8, 0x83c3, 0xb7c8, 0x84c3, 0x85c3,
	0x86c3, 0x87c3, 0x88c3, 0x89c3, 0xb8c8, 0xb9c8, 0x8ac3, 0x8bc3,
	0xbac8, 0x8cc3, 0x8dc3, 0x8ec3, 0xbbc8, 0x8fc3, 0x90c3, 0x91c3,
	0x92c3, 0x93c3, 0x94c3, 0x95c3, 0x96c3, 0xbcc8, 0x97c3, 0xbdc8,
	0x98c3, 0xbec8, 0x99c3, 0x9ac3, 0x9bc3, 0x9cc3, 0x9dc3, 0x9ec3,
	0xbfc8, 0x9fc3, 0xa0c3, 0x41c4, 0xc0c8, 0x42c4, 0x43c4, 0x44c4,
	0xc1c8, 0x45c4, 0x46c4, 0x47c4, 0x48c4, 0x49c4, 0x4ac4, 0x4bc4,
	0x4cc4, 0xc2c8, 0x4dc4, 0xc3c8, 0x4ec4, 0x4fc4, 0x50c4, 0x51c4,
	0x52c4, 0x53c4, 0x54c4, 0x55c4, 0xc4c8, 0xc5c8, 0x56c4, 0x57c4,
	0xc6c8, 0x58c4, 0x59c4, 0x5ac4, 0xc7c8, 0x61c4, 0x62c4, 0x63c4,
	0x64c4, 0xc8c8, 0x65c4, 0x66c4, 0xc9c8, 0x67c4, 0x68c4, 0xcac8,
	0x69c4, 0xcbc8, 0x6ac4, 0x6bc4, 0x6cc4, 0x6dc4, 0x6ec4, 0x6fc4,
	0xccc8, 0x70c4, 0x71c4, 0x72c4, 0xcdc8, 0x73c4, 0x74c4, 0x75c4,
	0xcec8, 0x76c4, 0x77c4, 0x78c4, 0x79c4, 0x7ac4, 0x81c4, 0x82c4,
	0xcfc8, 0x83c4, 0x84c4, 0x85c4, 0x86c4, 0xd0c8, 0x87c4, 0x88c4,
	0x89c4, 0x8ac4, 0x8bc4, 0x8cc4, 0xd1c8, 0xd2c8, 0x8dc4, 0x8ec4,
	0xd3c8, 0x8fc4, 0x90c4, 0x91c4, 0xd4c8, 0x92c4, 0x93c4, 0x94c4,
	0x95c4, 0x96c4, 0x97c4, 0x98c4, 0x99c4, 0x9ac4, 0x9bc4, 0x9cc4,
	0x9dc4, 0xd5c8, 0x9ec4, 0x9fc4, 0xa0c4, 0x41c5, 0x42c5, 0x43c5,
	0xd6c8, 0xd7c8, 0x44c5, 0x45c5, 0xd8c8, 0x46c5, 0x47c5, 0x48c5,
	0xd9c8, 0x49c5, 0x4ac5, 0x4bc5, 0x4cc5, 0x4dc5, 0x4ec5, 0x4fc5,
	0xdac8, 0xdbc8, 0x50c5, 0xdcc8, 0x51c5, 0xddc8, 0x52c5, 0x53c5,
	0x54c5, 0x55c5, 0x56c5, 0x57c5, 0xdec8, 0xdfc8, 0x58c5, 0x59c5,
	0xe0c8, 0x5ac5, 0x61c5, 0x62c5, 0xe1c8, 0x63c5, 0x64c5, 0x65c5,
	0x66c5, 0x67c5, 0x68c5, 0x69c5, 0xe2c8, 0x6ac5, 0x6bc5, 0xe3c8,
	0x6cc5, 0xe4c8, 0x6dc5, 0x6ec5, 0x6fc5, 0x70c5, 0x71c5, 0x72c5,
	0xe5c8, 0xe6c8, 0x73c5, 0x74c5, 0xe7c8, 0x75c5, 0xe8c8, 0xe9c8,
	0xeac8, 0xebc8, 0x76c5, 0x77c5, 0x78c5, 0x79c5, 0x7ac5, 0x81c5,
	0xecc8, 0xedc8, 0x82c5, 0xeec8, 0x83c5, 0xefc8, 0x84c5, 0x85c5,
	0x86c5, 0xf0c8, 0x87c5, 0x88c5, 0xf1c8, 0x89c5, 0x8ac5, 0x8bc5,
	0xf2c8, 0x8cc5, 0x8dc5, 0x8ec5, 0xf3c8, 0x8fc5, 0x90c5, 0x91c5,
	0x92c5, 0x93c5, 0x94c5, 0x95c5, 0xf4c8, 0xf5c8, 0x96c5, 0x97c5,
	0x98c5, 0xf6c8, 0x99c5, 0x9ac5, 0x9bc5, 0x9cc5, 0x9dc5, 0x9ec5,
	0xf7c8, 0xf8c8, 0x9fc5, 0xa0c5, 0xf9c8, 0x41c6, 0x42c6, 0x43c6,
	0xfac8, 0x44c6, 0x45c6, 0x46c6, 0x47c6, 0x48c6, 0x49c6, 0x4ac6,
	0xfbc8, 0xfcc8, 0x4bc6, 0xfdc8, 0x4cc6, 0xfec8, 0x4dc6, 0x4ec6,
	0x4fc6, 0x50c6, 0x51c6, 0x52c6
};

const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0xf900[ 268 ] = {
	0xd0cb, 0xd6cb, 0xe7cb, 0xcfcd, 0xe8cd, 0xadce, 0xfbcf, 0xa2d0,
	0xb8d0, 0xd0d0, 0xddd0, 0xd4d1, 0xd5d1, 0xd8d1, 0xdbd1, 0xdcd1,
	0xddd1, 0xded1, 0xdfd1, 0xe0d1, 0xe2d1, 0xe3d1, 0xe4d1, 0xe5d1,
	0xe6d1, 0xe8d1, 0xe9d1, 0xead1, 0xebd1, 0xedd1, 0xefd1, 0xf0d1,
	0xf2d1, 0xf6d1, 0xfad1, 0xfcd1, 0xfdd1, 0xfed1, 0xa2d2, 0xa3d2,
	0xa7d2, 0xa8d2, 0xa9d2, 0xaad2, 0xabd2, 0xadd2, 0xb2d2, 0xbed2,
	0xc2d2, 0xc3d2, 0xc4d2, 0xc6d2, 0xc7d2, 0xc8d2, 0xc9d2, 0xcad2,
	0xcbd2, 0xcdd2, 0xced2, 0xcfd2, 0xd0d2, 0xd1d2, 0xd2d2, 0xd3d2,
	0xd4d2, 0xd5d2, 0xd6d2, 0xd7d2, 0xd9d2, 0xdad2, 0xded2, 0xdfd2,
	0xe1d2, 0xe2d2, 0xe4d2, 0xe5d2, 0xe6d2, 0xe7d2, 0xe8d2, 0xe9d2,
	0xead2, 0xebd2, 0xf0d2, 0xf1d2, 0xf2d2, 0xf3d2, 0xf4d2, 0xf5d2,
	0xf7d2, 0xf8d2, 0xe6d4, 0xfcd4, 0xa5d5, 0xabd5, 0xaed5, 0xb8d6,
	0xcdd6, 0xcbd7, 0xe4d7, 0xc5db, 0xe4db, 0xa5dc, 0xa5dd, 0xd5dd,
	0xf4dd, 0xfcde, 0xfede, 0xb3df, 0xe1df, 0xe8df, 0xf1e0, 0xade1,
	0xede1, 0xf5e3, 0xa1e4, 0xa9e4, 0xaee5, 0xb1e5, 0xb2e5, 0xb9e5,
	0xbbe5, 0xbce5, 0xc4e5, 0xcee5, 0xd0e5, 0xd2e5, 0xd6e5, 0xfae5,
	0xfbe5, 0xfce5, 0xfee5, 0xa1e6, 0xa4e6, 0xa7e6, 0xade6, 0xafe6,
	0xb0e6, 0xb1e6, 0xb3e6, 0xb7e6, 0xb8e6, 0xbce6, 0xc4e6, 0xc6e6,
	0xc7e6, 0xcae6, 0xd2e6, 0xd6e6, 0xd9e6, 0xdce6, 0xdfe6, 0xe1e6,
	0xe4e6, 0xe5e6, 0xe6e6, 0xe8e6, 0xeae6, 0xebe6, 0xece6, 0xefe6,
	0xf1e6, 0xf2e6, 0xf5e6, 0xf6e6, 0xf7e6, 0xf9e6, 0xa1e7, 0xa6e7,
	0xa9e7, 0xaae7, 0xace7, 0xade7, 0xb0e7, 0xbfe7, 0xc1e7, 0xc6e7,
	0xc7e7, 0xcbe7, 0xcde7, 0xcfe7, 0xd0e7, 0xd3e7, 0xdfe7, 0xe4e7,
	0xe6e7, 0xf7e7, 0xe7e8, 0xe8e8, 0xf0e8, 0xf1e8, 0xf7e8, 0xf9e8,
	0xfbe8, 0xfee8, 0xa7e9, 0xace9, 0xcce9, 0xf7e9, 0xc1ea, 0xe5ea,
	0xf4ea, 0xf7ea, 0xfcea, 0xfeea, 0xa4eb, 0xa7eb, 0xa9eb, 0xaaeb,
	0xbaeb, 0xbbeb, 0xbdeb, 0xc1eb, 0xc2eb, 0xc6eb, 0xc7eb, 0xcceb,
	0xcfeb, 0xd0eb, 0xd1eb, 0xd2eb, 0xd8eb, 0xa6ec, 0xa7ec, 0xaaec,
	0xafec, 0xb0ec, 0xb1ec, 0xb2ec, 0xb5ec, 0xb8ec, 0xbaec, 0xc0ec,
	0xc1ec, 0xc5ec, 0xc6ec, 0xc9ec, 0xcaec, 0xd5ec, 0xddec, 0xdeec,
	0xe1ec, 0xe4ec, 0xe7ec, 0xe8ec, 0xf7ec, 0xf8ec, 0xfaec, 0xa1ed,
	0xa2ed, 0xa3ed, 0xeeed, 0xdbee, 0xbdf2, 0xfaf2, 0xb1f3, 0xa7f4,
	0xeef4, 0xf4f6, 0xf6f6, 0xb8f7, 0xc8f7, 0xd3f7, 0xdbf8, 0xf0f8,
	0xa1fa, 0xa2fa, 0xe6fa, 0xa9fc
};

const uint16_t libuna_codepage_windows_949_unicode_to_byte_stream_base_0xff00[ 256 ] = {
	0x001a, 0xa1a3, 0xa2a3, 0xa3a3, 0xa4a3, 0xa5a3, 0xa6a3, 0xa7a3,
	0xa8a3, 0xa9a3, 0xaaa3, 0xaba3, 0xaca3, 0xada3, 0xaea3, 0xafa3,
	0xb0a3, 0xb1a3, 0xb2a3, 0xb3a3, 0xb4a3, 0xb5a3, 0xb6a3, 0xb7a3,
	0xb8a3, 0xb9a3, 0xbaa3, 0xbba3, 0xbca3, 0xbda3, 0xbea3, 0xbfa3,
	0xc0a3, 0xc1a3, 0xc2a3, 0xc3a3, 0xc4a3, 0xc5a3, 0xc6a3, 0xc7a3,
	0xc8a3, 0xc9a3, 0xcaa3, 0xcba3, 0xcca3, 0xcda3, 0xcea3, 0xcfa3,
	0xd0a3, 0xd1a3, 0xd2a3, 0xd3a3, 0xd4a3, 0xd5a3, 0xd6a3, 0xd7a3,
	0xd8a3, 0xd9a3, 0xdaa3, 0xdba3, 0xaca1, 0xdda3, 0xdea3, 0xdfa3,
	0xe0a3, 0xe1a3, 0xe2a3, 0xe3a3, 0xe4a3, 0xe5a3, 0xe6a3, 0xe7a3,
	0xe8a3, 0xe9a3, 0xeaa3, 0xeba3, 0xeca3, 0xeda3, 0xeea3, 0xefa3,
	0xf0a3, 0xf1a3, 0xf2a3, 0xf3a3, 0xf4a3, 0xf5a3, 0xf6a3, 0xf7a3,
	0xf8a3, 0xf9a3, 0xfaa3, 0xfba3, 0xfca3, 0xfda3, 0xa6a2, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0xcba1, 0xcca1, 0xfea1, 0xfea3, 0x001a, 0xcda1, 0xdca3, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a,
	0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a, 0x001a
};


/* Determines the size of a Windows 949 encoded byte stream from an Unicode character
 * Adds the size to the byte stream character size value
 * Returns 1 if successful, 0 if the byte stream character is valid but not supported since it requires special handling or -1 on error
 */
int libuna_codepage_windows_949_unicode_character_size_to_byte_stream(
     libuna_unicode_character_t unicode_character,
     size_t *byte_stream_character_size,
     libcerror_error_t **error )
{
	static char *function      = "libuna_codepage_windows_949_unicode_character_size_to_byte_stream";
	uint16_t byte_stream_value = 0x001a;

	if( byte_stream_character_size == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid byte stream character size.",
		 function );

		return( -1 );
	}
	if( unicode_character < 0x80 )
	{
		byte_stream_value = (uint16_t) unicode_character;
	}
	else if( ( unicode_character >= 0x0080 )
	      && ( unicode_character < 0x0180 ) )
	{
		unicode_character -= 0x0080;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x0080[ unicode_character ];
	}
	else if( ( unicode_character >= 0x02c0 )
	      && ( unicode_character < 0x0480 ) )
	{
		unicode_character -= 0x02c0;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x02c0[ unicode_character ];
	}
	else if( ( unicode_character >= 0x2000 )
	      && ( unicode_character < 0x2680 ) )
	{
		unicode_character -= 0x2000;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x2000[ unicode_character ];
	}
	else if( ( unicode_character >= 0x3000 )
	      && ( unicode_character < 0x3400 ) )
	{
		unicode_character -= 0x3000;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x3000[ unicode_character ];
	}
	else if( ( unicode_character >= 0x4e00 )
	      && ( unicode_character < 0x9fc0 ) )
	{
		unicode_character -= 0x4e00;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x4e00[ unicode_character ];
	}
	else if( ( unicode_character >= 0xac00 )
	      && ( unicode_character < 0xd7a4 ) )
	{
		unicode_character -= 0xac00;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0xac00[ unicode_character ];
	}
	else if( ( unicode_character >= 0xf900 )
	      && ( unicode_character < 0xfa0c ) )
	{
		unicode_character -= 0xf900;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0xf900[ unicode_character ];
	}
	else if( ( unicode_character >= 0xff00 )
	      && ( unicode_character < 0x10000 ) )
	{
		unicode_character -= 0xff00;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0xff00[ unicode_character ];
	}
	byte_stream_value >>= 8;

	if( byte_stream_value != 0 )
	{
		*byte_stream_character_size += 2;
	}
	else
	{
		*byte_stream_character_size += 1;
	}
	return( 1 );
}

/* Copies an Unicode character from a byte stream
 * Returns 1 if successful or -1 on error
 */
int libuna_codepage_windows_949_copy_from_byte_stream(
     libuna_unicode_character_t *unicode_character,
     const uint8_t *byte_stream,
     size_t byte_stream_size,
     size_t *byte_stream_index,
     libcerror_error_t **error )
{
	static char *function                             = "libuna_codepage_windows_949_copy_from_byte_stream";
	libuna_unicode_character_t safe_unicode_character = 0xfffd;
	size_t safe_byte_stream_index                     = 0;
	uint8_t additional_character                      = 0;
	uint8_t byte_stream_character                     = 0;

	if( unicode_character == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid Unicode character.",
		 function );

		return( -1 );
	}
	if( byte_stream == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid byte stream.",
		 function );

		return( -1 );
	}
	if( byte_stream_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid byte stream size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( byte_stream_index == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid byte stream index.",
		 function );

		return( -1 );
	}
	safe_byte_stream_index = *byte_stream_index;

	if( safe_byte_stream_index >= byte_stream_size )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: byte stream too small.",
		 function );

		return( -1 );
	}
	byte_stream_character = byte_stream[ safe_byte_stream_index ];

	if( byte_stream_character < 0x80 )
	{
		safe_unicode_character = byte_stream_character;
	}
	else if( ( safe_byte_stream_index + 1 ) <= byte_stream_size )
	{
		safe_byte_stream_index += 1;

		additional_character = byte_stream[ safe_byte_stream_index ];

		if( ( byte_stream_character >= 0x81 )
		 && ( byte_stream_character <= 0xa1 ) )
		{
			if( additional_character >= 0x40 )
			{
				additional_character -= 0x40;

				switch( byte_stream_character )
				{
					case 0x81:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8140[ additional_character ];
						break;

					case 0x82:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8240[ additional_character ];
						break;

					case 0x83:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8340[ additional_character ];
						break;

					case 0x84:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8440[ additional_character ];
						break;

					case 0x85:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8540[ additional_character ];
						break;

					case 0x86:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8640[ additional_character ];
						break;

					case 0x87:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8740[ additional_character ];
						break;

					case 0x88:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8840[ additional_character ];
						break;

					case 0x89:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8940[ additional_character ];
						break;

					case 0x8a:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8a40[ additional_character ];
						break;

					case 0x8b:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8b40[ additional_character ];
						break;

					case 0x8c:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8c40[ additional_character ];
						break;

					case 0x8d:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8d40[ additional_character ];
						break;

					case 0x8e:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8e40[ additional_character ];
						break;

					case 0x8f:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x8f40[ additional_character ];
						break;

					case 0x90:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9040[ additional_character ];
						break;

					case 0x91:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9140[ additional_character ];
						break;

					case 0x92:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9240[ additional_character ];
						break;

					case 0x93:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9340[ additional_character ];
						break;

					case 0x94:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9440[ additional_character ];
						break;

					case 0x95:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9540[ additional_character ];
						break;

					case 0x96:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9640[ additional_character ];
						break;

					case 0x97:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9740[ additional_character ];
						break;

					case 0x98:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9840[ additional_character ];
						break;

					case 0x99:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9940[ additional_character ];
						break;

					case 0x9a:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9a40[ additional_character ];
						break;

					case 0x9b:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9b40[ additional_character ];
						break;

					case 0x9c:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9c40[ additional_character ];
						break;

					case 0x9d:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9d40[ additional_character ];
						break;

					case 0x9e:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9e40[ additional_character ];
						break;

					case 0x9f:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0x9f40[ additional_character ];
						break;

					case 0xa0:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa040[ additional_character ];
						break;

					case 0xa1:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa140[ additional_character ];
						break;
				}
			}
		}
		else if( byte_stream_character == 0xa2 )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xe8 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa240[ additional_character ];
			}
		}
		else if( ( byte_stream_character >= 0xa3 )
		      && ( byte_stream_character <= 0xa4 ) )
		{
			if( additional_character >= 0x40 )
			{
				additional_character -= 0x40;

				switch( byte_stream_character )
				{
					case 0xa3:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa340[ additional_character ];
						break;

					case 0xa4:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa440[ additional_character ];
						break;
				}
			}
		}
		else if( byte_stream_character == 0xa5 )
		{
			if( additional_character >= 0x40 )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa540[ additional_character ];
			}
		}
		else if( byte_stream_character == 0xa6 )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xe8 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa640[ additional_character ];
			}
		}
		else if( byte_stream_character == 0xa7 )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xf0 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa740[ additional_character ];
			}
		}
		else if( ( byte_stream_character >= 0xa8 )
		      && ( byte_stream_character <= 0xa9 ) )
		{
			if( additional_character >= 0x40 )
			{
				additional_character -= 0x40;

				switch( byte_stream_character )
				{
					case 0xa8:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa840[ additional_character ];
						break;

					case 0xa9:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xa940[ additional_character ];
						break;
				}
			}
		}
		else if( ( byte_stream_character >= 0xaa )
		      && ( byte_stream_character <= 0xab ) )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xf8 ) )
			{
				additional_character -= 0x40;

				switch( byte_stream_character )
				{
					case 0xaa:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xaa40[ additional_character ];
						break;

					case 0xab:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xab40[ additional_character ];
						break;
				}
			}
		}
		else if( byte_stream_character == 0xac )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xc8 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xac40[ additional_character ];
			}
			else if( ( additional_character >= 0xd0 )
			      && ( additional_character < 0xf8 ) )
			{
				additional_character -= 0xd0;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xacd0[ additional_character ];
			}
		}
		else if( byte_stream_character == 0xad )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xa0 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xad40[ additional_character ];
			}
			else if( additional_character == 0xa0 )
			{
				safe_unicode_character = 0xcdc5;
			}
		}
		else if( byte_stream_character == 0xae )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xa0 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xae40[ additional_character ];
			}
			else if( additional_character == 0xa0 )
			{
				safe_unicode_character = 0xce2b;
			}
		}
		else if( byte_stream_character == 0xaf )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0xa0 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xaf40[ additional_character ];
			}
			else if( additional_character == 0xa0 )
			{
				safe_unicode_character = 0xce99;
			}
		}
		else if( ( byte_stream_character >= 0xb0 )
		      && ( byte_stream_character <= 0xc5 ) )
		{
			if( additional_character >= 0x40 )
			{
				additional_character -= 0x40;

				switch( byte_stream_character )
				{
					case 0xb0:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb040[ additional_character ];
						break;

					case 0xb1:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb140[ additional_character ];
						break;

					case 0xb2:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb240[ additional_character ];
						break;

					case 0xb3:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb340[ additional_character ];
						break;

					case 0xb4:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb440[ additional_character ];
						break;

					case 0xb5:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb540[ additional_character ];
						break;

					case 0xb6:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb640[ additional_character ];
						break;

					case 0xb7:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb740[ additional_character ];
						break;

					case 0xb8:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb840[ additional_character ];
						break;

					case 0xb9:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xb940[ additional_character ];
						break;

					case 0xba:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xba40[ additional_character ];
						break;

					case 0xbb:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbb40[ additional_character ];
						break;

					case 0xbc:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbc40[ additional_character ];
						break;

					case 0xbd:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbd40[ additional_character ];
						break;

					case 0xbe:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbe40[ additional_character ];
						break;

					case 0xbf:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xbf40[ additional_character ];
						break;

					case 0xc0:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc040[ additional_character ];
						break;

					case 0xc1:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc140[ additional_character ];
						break;

					case 0xc2:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc240[ additional_character ];
						break;

					case 0xc3:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc340[ additional_character ];
						break;

					case 0xc4:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc440[ additional_character ];
						break;

					case 0xc5:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc540[ additional_character ];
						break;
				}
			}
		}
		else if( byte_stream_character == 0xc6 )
		{
			if( ( additional_character >= 0x40 )
			 && ( additional_character < 0x58 ) )
			{
				additional_character -= 0x40;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc640[ additional_character ];
			}
			else if( additional_character >= 0xa0 )
			{
				additional_character -= 0xa0;

				safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc6a0[ additional_character ];
			}
		}
		else if( ( byte_stream_character >= 0xc7 )
		      && ( byte_stream_character <= 0xc8 ) )
		{
			if( additional_character >= 0xa0 )
			{
				additional_character -= 0xa0;

				switch( byte_stream_character )
				{
					case 0xc7:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc7a0[ additional_character ];
						break;

					case 0xc8:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xc8a0[ additional_character ];
						break;
				}
			}
		}
		else if( ( byte_stream_character >= 0xca )
		      && ( byte_stream_character <= 0xfd ) )
		{
			if( additional_character >= 0xa0 )
			{
				additional_character -= 0xa0;

				switch( byte_stream_character )
				{
					case 0xca:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcaa0[ additional_character ];
						break;

					case 0xcb:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcba0[ additional_character ];
						break;

					case 0xcc:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcca0[ additional_character ];
						break;

					case 0xcd:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcda0[ additional_character ];
						break;

					case 0xce:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcea0[ additional_character ];
						break;

					case 0xcf:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xcfa0[ additional_character ];
						break;

					case 0xd0:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd0a0[ additional_character ];
						break;

					case 0xd1:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd1a0[ additional_character ];
						break;

					case 0xd2:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd2a0[ additional_character ];
						break;

					case 0xd3:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd3a0[ additional_character ];
						break;

					case 0xd4:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd4a0[ additional_character ];
						break;

					case 0xd5:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd5a0[ additional_character ];
						break;

					case 0xd6:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd6a0[ additional_character ];
						break;

					case 0xd7:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd7a0[ additional_character ];
						break;

					case 0xd8:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd8a0[ additional_character ];
						break;

					case 0xd9:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xd9a0[ additional_character ];
						break;

					case 0xda:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdaa0[ additional_character ];
						break;

					case 0xdb:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdba0[ additional_character ];
						break;

					case 0xdc:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdca0[ additional_character ];
						break;

					case 0xdd:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdda0[ additional_character ];
						break;

					case 0xde:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdea0[ additional_character ];
						break;

					case 0xdf:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xdfa0[ additional_character ];
						break;

					case 0xe0:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe0a0[ additional_character ];
						break;

					case 0xe1:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe1a0[ additional_character ];
						break;

					case 0xe2:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe2a0[ additional_character ];
						break;

					case 0xe3:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe3a0[ additional_character ];
						break;

					case 0xe4:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe4a0[ additional_character ];
						break;

					case 0xe5:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe5a0[ additional_character ];
						break;

					case 0xe6:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe6a0[ additional_character ];
						break;

					case 0xe7:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe7a0[ additional_character ];
						break;

					case 0xe8:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe8a0[ additional_character ];
						break;

					case 0xe9:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xe9a0[ additional_character ];
						break;

					case 0xea:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeaa0[ additional_character ];
						break;

					case 0xeb:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeba0[ additional_character ];
						break;

					case 0xec:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeca0[ additional_character ];
						break;

					case 0xed:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeda0[ additional_character ];
						break;

					case 0xee:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xeea0[ additional_character ];
						break;

					case 0xef:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xefa0[ additional_character ];
						break;

					case 0xf0:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf0a0[ additional_character ];
						break;

					case 0xf1:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf1a0[ additional_character ];
						break;

					case 0xf2:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf2a0[ additional_character ];
						break;

					case 0xf3:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf3a0[ additional_character ];
						break;

					case 0xf4:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf4a0[ additional_character ];
						break;

					case 0xf5:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf5a0[ additional_character ];
						break;

					case 0xf6:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf6a0[ additional_character ];
						break;

					case 0xf7:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf7a0[ additional_character ];
						break;

					case 0xf8:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf8a0[ additional_character ];
						break;

					case 0xf9:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xf9a0[ additional_character ];
						break;

					case 0xfa:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfaa0[ additional_character ];
						break;

					case 0xfb:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfba0[ additional_character ];
						break;

					case 0xfc:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfca0[ additional_character ];
						break;

					case 0xfd:
						safe_unicode_character = libuna_codepage_windows_949_byte_stream_to_unicode_base_0xfda0[ additional_character ];
						break;
				}
			}
		}
	}
	*unicode_character = safe_unicode_character;
	*byte_stream_index = safe_byte_stream_index + 1;

	return( 1 );
}

/* Copies an Unicode character to a byte stream
 * Returns 1 if successful or -1 on error
 */
int libuna_codepage_windows_949_copy_to_byte_stream(
     libuna_unicode_character_t unicode_character,
     uint8_t *byte_stream,
     size_t byte_stream_size,
     size_t *byte_stream_index,
     libcerror_error_t **error )
{
	static char *function         = "libuna_codepage_windows_949_copy_to_byte_stream";
	size_t safe_byte_stream_index = 0;
	uint16_t byte_stream_value    = 0x001a;

	if( byte_stream == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid byte stream.",
		 function );

		return( -1 );
	}
	if( byte_stream_size > (size_t) SSIZE_MAX )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_EXCEEDS_MAXIMUM,
		 "%s: invalid byte stream size value exceeds maximum.",
		 function );

		return( -1 );
	}
	if( byte_stream_index == NULL )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_INVALID_VALUE,
		 "%s: invalid byte stream index.",
		 function );

		return( -1 );
	}
	safe_byte_stream_index = *byte_stream_index;

	if( safe_byte_stream_index >= byte_stream_size )
	{
		libcerror_error_set(
		 error,
		 LIBCERROR_ERROR_DOMAIN_ARGUMENTS,
		 LIBCERROR_ARGUMENT_ERROR_VALUE_TOO_SMALL,
		 "%s: byte stream too small.",
		 function );

		return( -1 );
	}
	if( unicode_character < 0x80 )
	{
		byte_stream_value = (uint16_t) unicode_character;
	}
	else if( ( unicode_character >= 0x0080 )
	      && ( unicode_character < 0x0180 ) )
	{
		unicode_character -= 0x0080;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x0080[ unicode_character ];
	}
	else if( ( unicode_character >= 0x02c0 )
	      && ( unicode_character < 0x0480 ) )
	{
		unicode_character -= 0x02c0;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x02c0[ unicode_character ];
	}
	else if( ( unicode_character >= 0x2000 )
	      && ( unicode_character < 0x2680 ) )
	{
		unicode_character -= 0x2000;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x2000[ unicode_character ];
	}
	else if( ( unicode_character >= 0x3000 )
	      && ( unicode_character < 0x3400 ) )
	{
		unicode_character -= 0x3000;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x3000[ unicode_character ];
	}
	else if( ( unicode_character >= 0x4e00 )
	      && ( unicode_character < 0x9fc0 ) )
	{
		unicode_character -= 0x4e00;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0x4e00[ unicode_character ];
	}
	else if( ( unicode_character >= 0xac00 )
	      && ( unicode_character < 0xd7a4 ) )
	{
		unicode_character -= 0xac00;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0xac00[ unicode_character ];
	}
	else if( ( unicode_character >= 0xf900 )
	      && ( unicode_character < 0xfa0c ) )
	{
		unicode_character -= 0xf900;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0xf900[ unicode_character ];
	}
	else if( ( unicode_character >= 0xff00 )
	      && ( unicode_character < 0x10000 ) )
	{
		unicode_character -= 0xff00;
		byte_stream_value  = libuna_codepage_windows_949_unicode_to_byte_stream_base_0xff00[ unicode_character ];
	}
	do
	{
		byte_stream[ safe_byte_stream_index++ ] = (uint8_t) ( byte_stream_value & 0x00ff );

		byte_stream_value >>= 8;
	}
	while( byte_stream_value != 0 );

	*byte_stream_index = safe_byte_stream_index;

	return( 1 );
}

