/*
 * The internal definitions
 *
 * Copyright (C) 2010-2018, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBSMRAW_DEFINITIONS_H )
#define _LIBSMRAW_DEFINITIONS_H

#include <common.h>
#include <byte_stream.h>

#define LIBSMRAW_ENDIAN_BIG				_BYTE_STREAM_ENDIAN_BIG
#define LIBSMRAW_ENDIAN_LITTLE				_BYTE_STREAM_ENDIAN_LITTLE

/* Define HAVE_LOCAL_LIBSMRAW for local use of libsmraw
 */
#if !defined( HAVE_LOCAL_LIBSMRAW )
#include <libsmraw/definitions.h>

#else

#define LIBSMRAW_VERSION				20181215

/* The version string
 */
#define LIBSMRAW_VERSION_STRING				"20181215"

/* The access flags definitions
 * bit 1	set to 1 for read access
 * bit 2	set to 1 for write access
 * bit 3        set to 1 to truncate an existing file on write
 * bit 4-8	not used
 */
enum LIBSMRAW_ACCESS_FLAGS
{
	LIBSMRAW_ACCESS_FLAG_READ			= 0x01,
	LIBSMRAW_ACCESS_FLAG_WRITE			= 0x02,
	LIBSMRAW_ACCESS_FLAG_TRUNCATE			= 0x04
};

/* The file access macros
 */
#define LIBSMRAW_OPEN_READ				( LIBSMRAW_ACCESS_FLAG_READ )
#define LIBSMRAW_OPEN_READ_WRITE			( LIBSMRAW_ACCESS_FLAG_READ | LIBSMRAW_ACCESS_FLAG_WRITE )
#define LIBSMRAW_OPEN_WRITE				( LIBSMRAW_ACCESS_FLAG_WRITE )
#define LIBSMRAW_OPEN_WRITE_TRUNCATE			( LIBSMRAW_ACCESS_FLAG_WRITE | LIBSMRAW_ACCESS_FLAG_TRUNCATE )
#define LIBSMRAW_OPEN_READ_WRITE_TRUNCATE		( LIBSMRAW_ACCESS_FLAG_READ | LIBSMRAW_ACCESS_FLAG_WRITE | LIBSMRAW_ACCESS_FLAG_TRUNCATE )

/* The default maximum segment size
 */
#define LIBSMRAW_DEFAULT_MAXIMUM_SEGMENT_SIZE		( 1500 * 1024 * 1024 )

/* The media type definitions
 */
enum LIBSMRAW_MEDIA_TYPES
{
	LIBSMRAW_MEDIA_TYPE_UNKNOWN			= 0,
	LIBSMRAW_MEDIA_TYPE_FIXED,
	LIBSMRAW_MEDIA_TYPE_MEMORY,
	LIBSMRAW_MEDIA_TYPE_OPTICAL,
	LIBSMRAW_MEDIA_TYPE_REMOVABLE
};

/* The media flags definitions
 */
enum LIBSMRAW_MEDIA_FLAGS
{
	LIBSMRAW_MEDIA_FLAG_PHYSICAL			= 0x01
};

#endif

/* The segment file naming schema definitions
 */
enum LIBSMRAW_SEGMENT_FILE_NAMING_SCHEMAS
{
	LIBSMRAW_SEGMENT_FILE_NAMING_SCHEMA_UNKNOWN	= 0,

	/* Numeric naming schema e.g.
	 * .1, .2, ... .10 ...
	 * .000, .001, ... .010 ...
	 * PREFIX000, PREFIX001, ...
	 */
	LIBSMRAW_SEGMENT_FILE_NAMING_SCHEMA_NUMERIC	= (uint8_t) 'n',

	/* Single naming schema e.g.
	 * .dd
	 * .raw
	 */
	LIBSMRAW_SEGMENT_FILE_NAMING_SCHEMA_SINGLE	= (uint8_t) '1',

	/* Split naming schema e.g.
	 * PREFIXaa, PREFIXab, ...
	 */
	LIBSMRAW_SEGMENT_FILE_NAMING_SCHEMA_SPLIT	= (uint8_t) 's',

	/* XofN naming schema e.g.
	 * PREFIX.1of5, PREFIX.2of5, ...
	 */
	LIBSMRAW_SEGMENT_FILE_NAMING_SCHEMA_X_OF_N	= (uint8_t) 'x'
};

#endif

