Name: libsmraw
Version: 20210807
Release: 1
Summary: Library to access the storage media (SM) (split) RAW format
Group: System Environment/Libraries
License: LGPLv3+
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libsmraw
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
             
BuildRequires: gcc             

%description -n libsmraw
Library to access the storage media (SM) (split) RAW format

%package -n libsmraw-static
Summary: Library to access the storage media (SM) (split) RAW format
Group: Development/Libraries
Requires: libsmraw = %{version}-%{release}

%description -n libsmraw-static
Static library version of libsmraw.

%package -n libsmraw-devel
Summary: Header files and libraries for developing applications for libsmraw
Group: Development/Libraries
Requires: libsmraw = %{version}-%{release}

%description -n libsmraw-devel
Header files and libraries for developing applications for libsmraw.

%package -n libsmraw-python2
Obsoletes: libsmraw-python < %{version}
Provides: libsmraw-python = %{version}
Summary: Python 2 bindings for libsmraw
Group: System Environment/Libraries
Requires: libsmraw = %{version}-%{release} python2
BuildRequires: python2-devel

%description -n libsmraw-python2
Python 2 bindings for libsmraw

%package -n libsmraw-python3
Summary: Python 3 bindings for libsmraw
Group: System Environment/Libraries
Requires: libsmraw = %{version}-%{release} python3
BuildRequires: python3-devel

%description -n libsmraw-python3
Python 3 bindings for libsmraw

%package -n libsmraw-tools
Summary: Several tools for reading and writing storage media (SM) (split) RAW files
Group: Applications/System
Requires: libsmraw = %{version}-%{release} openssl fuse-libs 
BuildRequires: openssl-devel fuse-devel 

%description -n libsmraw-tools
Several tools for reading and writing storage media (SM) (split) RAW files

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python2 --enable-python3
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libsmraw
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%attr(755,root,root) %{_libdir}/*.so.*

%files -n libsmraw-static
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%attr(755,root,root) %{_libdir}/*.a

%files -n libsmraw-devel
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/libsmraw.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libsmraw-python2
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python2*/site-packages/*.a
%{_libdir}/python2*/site-packages/*.la
%{_libdir}/python2*/site-packages/*.so

%files -n libsmraw-python3
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.la
%{_libdir}/python3*/site-packages/*.so

%files -n libsmraw-tools
%defattr(644,root,root,755)
%license COPYING COPYING.LESSER
%doc AUTHORS README
%attr(755,root,root) %{_bindir}/*
%{_mandir}/man1/*

%changelog
* Sat Aug  7 2021 Joachim Metz <joachim.metz@gmail.com> 20210807-1
- Auto-generated

