/*
 * Definitions for libvsgpt
 *
 * Copyright (C) 2019-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBVSGPT_DEFINITIONS_H )
#define _LIBVSGPT_DEFINITIONS_H

#include <libvsgpt/types.h>

#define LIBVSGPT_VERSION		20240228

/* The version string
 */
#define LIBVSGPT_VERSION_STRING		"20240228"

/* The byte order definitions
 */
enum LIBVSGPT_ENDIAN
{
	LIBVSGPT_ENDIAN_BIG		= (int) 'b',
	LIBVSGPT_ENDIAN_LITTLE		= (int) 'l',
};

/* The access flags definitions
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBVSGPT_ACCESS_FLAGS
{
	LIBVSGPT_ACCESS_FLAG_READ	= 0x01,
/* Reserved: not supported yet */
	LIBVSGPT_ACCESS_FLAG_WRITE	= 0x02
};

/* The file access macros
 */
#define LIBVSGPT_OPEN_READ		( LIBVSGPT_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBVSGPT_OPEN_WRITE		( LIBVSGPT_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBVSGPT_OPEN_READ_WRITE	( LIBVSGPT_ACCESS_FLAG_READ | LIBVSGPT_ACCESS_FLAG_WRITE )

#endif /* !defined( _LIBVSGPT_DEFINITIONS_H ) */

