Name: libvshadow
Version: 20191103
Release: 1
Summary: Library to access the Windows NT Volume Shadow Snapshot (VSS) format
Group: System Environment/Libraries
License: LGPL
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libvshadow
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
            
BuildRequires: gcc            

%description -n libvshadow
Library to access the Windows NT Volume Shadow Snapshot (VSS) format

%package -n libvshadow-static
Summary: Library to access the Windows NT Volume Shadow Snapshot (VSS) format
Group: Development/Libraries
Requires: libvshadow = %{version}-%{release}

%description -n libvshadow-static
Static library version of libvshadow.

%package -n libvshadow-devel
Summary: Header files and libraries for developing applications for libvshadow
Group: Development/Libraries
Requires: libvshadow = %{version}-%{release}

%description -n libvshadow-devel
Header files and libraries for developing applications for libvshadow.

%package -n libvshadow-python2
Obsoletes: libvshadow-python < %{version}
Provides: libvshadow-python = %{version}
Summary: Python 2 bindings for libvshadow
Group: System Environment/Libraries
Requires: libvshadow = %{version}-%{release} python2
BuildRequires: python2-devel

%description -n libvshadow-python2
Python 2 bindings for libvshadow

%package -n libvshadow-python3
Summary: Python 3 bindings for libvshadow
Group: System Environment/Libraries
Requires: libvshadow = %{version}-%{release} python3
BuildRequires: python3-devel

%description -n libvshadow-python3
Python 3 bindings for libvshadow

%package -n libvshadow-tools
Summary: Several tools for reading Windows NT Volume Shadow Snapshots (VSS)
Group: Applications/System
Requires: libvshadow = %{version}-%{release} fuse-libs
BuildRequires: fuse-devel

%description -n libvshadow-tools
Several tools for reading Windows NT Volume Shadow Snapshots (VSS)

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python2 --enable-python3
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libvshadow
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%attr(755,root,root) %{_libdir}/*.so.*

%files -n libvshadow-static
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%attr(755,root,root) %{_libdir}/*.a

%files -n libvshadow-devel
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%{_libdir}/*.la
%{_libdir}/*.so
%{_libdir}/pkgconfig/libvshadow.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libvshadow-python2
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%{_libdir}/python2*/site-packages/*.a
%{_libdir}/python2*/site-packages/*.la
%{_libdir}/python2*/site-packages/*.so

%files -n libvshadow-python3
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.la
%{_libdir}/python3*/site-packages/*.so

%files -n libvshadow-tools
%defattr(644,root,root,755)
%license COPYING
%doc AUTHORS README
%attr(755,root,root) %{_bindir}/*
%{_mandir}/man1/*

%changelog
* Sun Nov  3 2019 Joachim Metz <joachim.metz@gmail.com> 20191103-1
- Auto-generated

