/*
 * Codepage definitions for libvsmbr
 *
 * Copyright (C) 2010-2024, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBVSMBR_CODEPAGE_H )
#define _LIBVSMBR_CODEPAGE_H

#include <libvsmbr/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBVSMBR_CODEPAGES
{
	LIBVSMBR_CODEPAGE_ASCII				= 20127,

	LIBVSMBR_CODEPAGE_ISO_8859_1			= 28591,
	LIBVSMBR_CODEPAGE_ISO_8859_2			= 28592,
	LIBVSMBR_CODEPAGE_ISO_8859_3			= 28593,
	LIBVSMBR_CODEPAGE_ISO_8859_4			= 28594,
	LIBVSMBR_CODEPAGE_ISO_8859_5			= 28595,
	LIBVSMBR_CODEPAGE_ISO_8859_6			= 28596,
	LIBVSMBR_CODEPAGE_ISO_8859_7			= 28597,
	LIBVSMBR_CODEPAGE_ISO_8859_8			= 28598,
	LIBVSMBR_CODEPAGE_ISO_8859_9			= 28599,
	LIBVSMBR_CODEPAGE_ISO_8859_10			= 28600,
	LIBVSMBR_CODEPAGE_ISO_8859_11			= 28601,
	LIBVSMBR_CODEPAGE_ISO_8859_13			= 28603,
	LIBVSMBR_CODEPAGE_ISO_8859_14			= 28604,
	LIBVSMBR_CODEPAGE_ISO_8859_15			= 28605,
	LIBVSMBR_CODEPAGE_ISO_8859_16			= 28606,

	LIBVSMBR_CODEPAGE_KOI8_R			= 20866,
	LIBVSMBR_CODEPAGE_KOI8_U			= 21866,

	LIBVSMBR_CODEPAGE_WINDOWS_874			= 874,
	LIBVSMBR_CODEPAGE_WINDOWS_932			= 932,
	LIBVSMBR_CODEPAGE_WINDOWS_936			= 936,
	LIBVSMBR_CODEPAGE_WINDOWS_949			= 949,
	LIBVSMBR_CODEPAGE_WINDOWS_950			= 950,
	LIBVSMBR_CODEPAGE_WINDOWS_1250			= 1250,
	LIBVSMBR_CODEPAGE_WINDOWS_1251			= 1251,
	LIBVSMBR_CODEPAGE_WINDOWS_1252			= 1252,
	LIBVSMBR_CODEPAGE_WINDOWS_1253			= 1253,
	LIBVSMBR_CODEPAGE_WINDOWS_1254			= 1254,
	LIBVSMBR_CODEPAGE_WINDOWS_1255			= 1255,
	LIBVSMBR_CODEPAGE_WINDOWS_1256			= 1256,
	LIBVSMBR_CODEPAGE_WINDOWS_1257			= 1257,
	LIBVSMBR_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBVSMBR_CODEPAGE_US_ASCII			LIBVSMBR_CODEPAGE_ASCII

#define LIBVSMBR_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBVSMBR_CODEPAGE_ISO_8859_1
#define LIBVSMBR_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBVSMBR_CODEPAGE_ISO_8859_2
#define LIBVSMBR_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBVSMBR_CODEPAGE_ISO_8859_3
#define LIBVSMBR_CODEPAGE_ISO_NORTH_EUROPEAN		LIBVSMBR_CODEPAGE_ISO_8859_4
#define LIBVSMBR_CODEPAGE_ISO_CYRILLIC			LIBVSMBR_CODEPAGE_ISO_8859_5
#define LIBVSMBR_CODEPAGE_ISO_ARABIC			LIBVSMBR_CODEPAGE_ISO_8859_6
#define LIBVSMBR_CODEPAGE_ISO_GREEK			LIBVSMBR_CODEPAGE_ISO_8859_7
#define LIBVSMBR_CODEPAGE_ISO_HEBREW			LIBVSMBR_CODEPAGE_ISO_8859_8
#define LIBVSMBR_CODEPAGE_ISO_TURKISH			LIBVSMBR_CODEPAGE_ISO_8859_9
#define LIBVSMBR_CODEPAGE_ISO_NORDIC			LIBVSMBR_CODEPAGE_ISO_8859_10
#define LIBVSMBR_CODEPAGE_ISO_THAI			LIBVSMBR_CODEPAGE_ISO_8859_11
#define LIBVSMBR_CODEPAGE_ISO_BALTIC			LIBVSMBR_CODEPAGE_ISO_8859_13
#define LIBVSMBR_CODEPAGE_ISO_CELTIC			LIBVSMBR_CODEPAGE_ISO_8859_14

#define LIBVSMBR_CODEPAGE_ISO_LATIN_1			LIBVSMBR_CODEPAGE_ISO_8859_1
#define LIBVSMBR_CODEPAGE_ISO_LATIN_2			LIBVSMBR_CODEPAGE_ISO_8859_2
#define LIBVSMBR_CODEPAGE_ISO_LATIN_3			LIBVSMBR_CODEPAGE_ISO_8859_3
#define LIBVSMBR_CODEPAGE_ISO_LATIN_4			LIBVSMBR_CODEPAGE_ISO_8859_4
#define LIBVSMBR_CODEPAGE_ISO_LATIN_5			LIBVSMBR_CODEPAGE_ISO_8859_9
#define LIBVSMBR_CODEPAGE_ISO_LATIN_6			LIBVSMBR_CODEPAGE_ISO_8859_10
#define LIBVSMBR_CODEPAGE_ISO_LATIN_7			LIBVSMBR_CODEPAGE_ISO_8859_13
#define LIBVSMBR_CODEPAGE_ISO_LATIN_8			LIBVSMBR_CODEPAGE_ISO_8859_14
#define LIBVSMBR_CODEPAGE_ISO_LATIN_9			LIBVSMBR_CODEPAGE_ISO_8859_15
#define LIBVSMBR_CODEPAGE_ISO_LATIN_10			LIBVSMBR_CODEPAGE_ISO_8859_16

#define LIBVSMBR_CODEPAGE_KOI8_RUSSIAN			LIBVSMBR_CODEPAGE_KOI8_R
#define LIBVSMBR_CODEPAGE_KOI8_UKRAINIAN		LIBVSMBR_CODEPAGE_KOI8_U

#define LIBVSMBR_CODEPAGE_WINDOWS_THAI			LIBVSMBR_CODEPAGE_WINDOWS_874
#define LIBVSMBR_CODEPAGE_WINDOWS_JAPANESE		LIBVSMBR_CODEPAGE_WINDOWS_932
#define LIBVSMBR_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBVSMBR_CODEPAGE_WINDOWS_936
#define LIBVSMBR_CODEPAGE_WINDOWS_KOREAN		LIBVSMBR_CODEPAGE_WINDOWS_949
#define LIBVSMBR_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBVSMBR_CODEPAGE_WINDOWS_950
#define LIBVSMBR_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBVSMBR_CODEPAGE_WINDOWS_1250
#define LIBVSMBR_CODEPAGE_WINDOWS_CYRILLIC		LIBVSMBR_CODEPAGE_WINDOWS_1251
#define LIBVSMBR_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBVSMBR_CODEPAGE_WINDOWS_1252
#define LIBVSMBR_CODEPAGE_WINDOWS_GREEK			LIBVSMBR_CODEPAGE_WINDOWS_1253
#define LIBVSMBR_CODEPAGE_WINDOWS_TURKISH		LIBVSMBR_CODEPAGE_WINDOWS_1254
#define LIBVSMBR_CODEPAGE_WINDOWS_HEBREW		LIBVSMBR_CODEPAGE_WINDOWS_1255
#define LIBVSMBR_CODEPAGE_WINDOWS_ARABIC		LIBVSMBR_CODEPAGE_WINDOWS_1256
#define LIBVSMBR_CODEPAGE_WINDOWS_BALTIC		LIBVSMBR_CODEPAGE_WINDOWS_1257
#define LIBVSMBR_CODEPAGE_WINDOWS_VIETNAMESE		LIBVSMBR_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBVSMBR_CODEPAGE_H ) */

