Name: libvsmbr
Version: 20240505
Release: 1
Summary: Library to access the Master Boot Record (MBR) volume system format
Group: System Environment/Libraries
License: LGPL-3.0-or-later
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libvsmbr
            
BuildRequires: gcc            

%description -n libvsmbr
Library to access the Master Boot Record (MBR) volume system format

%package -n libvsmbr-static
Summary: Library to access the Master Boot Record (MBR) volume system format
Group: Development/Libraries
Requires: libvsmbr = %{version}-%{release}

%description -n libvsmbr-static
Static library version of libvsmbr.

%package -n libvsmbr-devel
Summary: Header files and libraries for developing applications for libvsmbr
Group: Development/Libraries
Requires: libvsmbr = %{version}-%{release}

%description -n libvsmbr-devel
Header files and libraries for developing applications for libvsmbr.

%package -n libvsmbr-python3
Summary: Python 3 bindings for libvsmbr
Group: System Environment/Libraries
Requires: libvsmbr = %{version}-%{release} python3
BuildRequires: python3-devel python3-setuptools

%description -n libvsmbr-python3
Python 3 bindings for libvsmbr

%package -n libvsmbr-tools
Summary: Several tools for Several tools for reading Master Boot Record (MBR) volume systems
Group: Applications/System
Requires: libvsmbr = %{version}-%{release}

%description -n libvsmbr-tools
Several tools for Several tools for reading Master Boot Record (MBR) volume systems

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libvsmbr
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so.*

%files -n libvsmbr-static
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.a

%files -n libvsmbr-devel
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so
%{_libdir}/pkgconfig/libvsmbr.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libvsmbr-python3
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.so

%files -n libvsmbr-tools
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_bindir}/*
%{_mandir}/man1/*

%changelog
* Sun May  5 2024 Joachim Metz <joachim.metz@gmail.com> 20240505-1
- Auto-generated

