/*
 * Codepage definitions for libwrc
 *
 * Copyright (C) 2011-2023, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBWRC_CODEPAGE_H )
#define _LIBWRC_CODEPAGE_H

#include <libwrc/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBWRC_CODEPAGES
{
	LIBWRC_CODEPAGE_ASCII				= 20127,

	LIBWRC_CODEPAGE_ISO_8859_1			= 28591,
	LIBWRC_CODEPAGE_ISO_8859_2			= 28592,
	LIBWRC_CODEPAGE_ISO_8859_3			= 28593,
	LIBWRC_CODEPAGE_ISO_8859_4			= 28594,
	LIBWRC_CODEPAGE_ISO_8859_5			= 28595,
	LIBWRC_CODEPAGE_ISO_8859_6			= 28596,
	LIBWRC_CODEPAGE_ISO_8859_7			= 28597,
	LIBWRC_CODEPAGE_ISO_8859_8			= 28598,
	LIBWRC_CODEPAGE_ISO_8859_9			= 28599,
	LIBWRC_CODEPAGE_ISO_8859_10			= 28600,
	LIBWRC_CODEPAGE_ISO_8859_11			= 28601,
	LIBWRC_CODEPAGE_ISO_8859_13			= 28603,
	LIBWRC_CODEPAGE_ISO_8859_14			= 28604,
	LIBWRC_CODEPAGE_ISO_8859_15			= 28605,
	LIBWRC_CODEPAGE_ISO_8859_16			= 28606,

	LIBWRC_CODEPAGE_KOI8_R				= 20866,
	LIBWRC_CODEPAGE_KOI8_U				= 21866,

	LIBWRC_CODEPAGE_WINDOWS_874			= 874,
	LIBWRC_CODEPAGE_WINDOWS_932			= 932,
	LIBWRC_CODEPAGE_WINDOWS_936			= 936,
	LIBWRC_CODEPAGE_WINDOWS_949			= 949,
	LIBWRC_CODEPAGE_WINDOWS_950			= 950,
	LIBWRC_CODEPAGE_WINDOWS_1250			= 1250,
	LIBWRC_CODEPAGE_WINDOWS_1251			= 1251,
	LIBWRC_CODEPAGE_WINDOWS_1252			= 1252,
	LIBWRC_CODEPAGE_WINDOWS_1253			= 1253,
	LIBWRC_CODEPAGE_WINDOWS_1254			= 1254,
	LIBWRC_CODEPAGE_WINDOWS_1255			= 1255,
	LIBWRC_CODEPAGE_WINDOWS_1256			= 1256,
	LIBWRC_CODEPAGE_WINDOWS_1257			= 1257,
	LIBWRC_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBWRC_CODEPAGE_US_ASCII			LIBWRC_CODEPAGE_ASCII

#define LIBWRC_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBWRC_CODEPAGE_ISO_8859_1
#define LIBWRC_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBWRC_CODEPAGE_ISO_8859_2
#define LIBWRC_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBWRC_CODEPAGE_ISO_8859_3
#define LIBWRC_CODEPAGE_ISO_NORTH_EUROPEAN		LIBWRC_CODEPAGE_ISO_8859_4
#define LIBWRC_CODEPAGE_ISO_CYRILLIC			LIBWRC_CODEPAGE_ISO_8859_5
#define LIBWRC_CODEPAGE_ISO_ARABIC			LIBWRC_CODEPAGE_ISO_8859_6
#define LIBWRC_CODEPAGE_ISO_GREEK			LIBWRC_CODEPAGE_ISO_8859_7
#define LIBWRC_CODEPAGE_ISO_HEBREW			LIBWRC_CODEPAGE_ISO_8859_8
#define LIBWRC_CODEPAGE_ISO_TURKISH			LIBWRC_CODEPAGE_ISO_8859_9
#define LIBWRC_CODEPAGE_ISO_NORDIC			LIBWRC_CODEPAGE_ISO_8859_10
#define LIBWRC_CODEPAGE_ISO_THAI			LIBWRC_CODEPAGE_ISO_8859_11
#define LIBWRC_CODEPAGE_ISO_BALTIC			LIBWRC_CODEPAGE_ISO_8859_13
#define LIBWRC_CODEPAGE_ISO_CELTIC			LIBWRC_CODEPAGE_ISO_8859_14

#define LIBWRC_CODEPAGE_ISO_LATIN_1			LIBWRC_CODEPAGE_ISO_8859_1
#define LIBWRC_CODEPAGE_ISO_LATIN_2			LIBWRC_CODEPAGE_ISO_8859_2
#define LIBWRC_CODEPAGE_ISO_LATIN_3			LIBWRC_CODEPAGE_ISO_8859_3
#define LIBWRC_CODEPAGE_ISO_LATIN_4			LIBWRC_CODEPAGE_ISO_8859_4
#define LIBWRC_CODEPAGE_ISO_LATIN_5			LIBWRC_CODEPAGE_ISO_8859_9
#define LIBWRC_CODEPAGE_ISO_LATIN_6			LIBWRC_CODEPAGE_ISO_8859_10
#define LIBWRC_CODEPAGE_ISO_LATIN_7			LIBWRC_CODEPAGE_ISO_8859_13
#define LIBWRC_CODEPAGE_ISO_LATIN_8			LIBWRC_CODEPAGE_ISO_8859_14
#define LIBWRC_CODEPAGE_ISO_LATIN_9			LIBWRC_CODEPAGE_ISO_8859_15
#define LIBWRC_CODEPAGE_ISO_LATIN_10			LIBWRC_CODEPAGE_ISO_8859_16

#define LIBWRC_CODEPAGE_KOI8_RUSSIAN			LIBWRC_CODEPAGE_KOI8_R
#define LIBWRC_CODEPAGE_KOI8_UKRAINIAN			LIBWRC_CODEPAGE_KOI8_U

#define LIBWRC_CODEPAGE_WINDOWS_THAI			LIBWRC_CODEPAGE_WINDOWS_874
#define LIBWRC_CODEPAGE_WINDOWS_JAPANESE		LIBWRC_CODEPAGE_WINDOWS_932
#define LIBWRC_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBWRC_CODEPAGE_WINDOWS_936
#define LIBWRC_CODEPAGE_WINDOWS_KOREAN			LIBWRC_CODEPAGE_WINDOWS_949
#define LIBWRC_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBWRC_CODEPAGE_WINDOWS_950
#define LIBWRC_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBWRC_CODEPAGE_WINDOWS_1250
#define LIBWRC_CODEPAGE_WINDOWS_CYRILLIC		LIBWRC_CODEPAGE_WINDOWS_1251
#define LIBWRC_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBWRC_CODEPAGE_WINDOWS_1252
#define LIBWRC_CODEPAGE_WINDOWS_GREEK			LIBWRC_CODEPAGE_WINDOWS_1253
#define LIBWRC_CODEPAGE_WINDOWS_TURKISH			LIBWRC_CODEPAGE_WINDOWS_1254
#define LIBWRC_CODEPAGE_WINDOWS_HEBREW			LIBWRC_CODEPAGE_WINDOWS_1255
#define LIBWRC_CODEPAGE_WINDOWS_ARABIC			LIBWRC_CODEPAGE_WINDOWS_1256
#define LIBWRC_CODEPAGE_WINDOWS_BALTIC			LIBWRC_CODEPAGE_WINDOWS_1257
#define LIBWRC_CODEPAGE_WINDOWS_VIETNAMESE		LIBWRC_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBWRC_CODEPAGE_H ) */

