#!/usr/bin/env python
#
# Python-bindings mui_resource type test script
#
# Copyright (C) 2011-2021, Joachim Metz <joachim.metz@gmail.com>
#
# Refer to AUTHORS for acknowledgements.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

import unittest

import pywrc


class MUIResourceTypeTests(unittest.TestCase):
  """Tests the mui_resource type."""

  _TEST_DATA = bytes(bytearray([
      0xcd, 0xfe, 0xcd, 0xfe, 0xe8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x01, 0x00, 0x00, 0x00, 0x9d, 0x73, 0x62, 0x3d, 0x3f, 0x20, 0x93, 0x35,
      0x58, 0xe7, 0x05, 0x7b, 0xb7, 0xf4, 0xd0, 0x03, 0xfb, 0xf0, 0xa9, 0x8b,
      0xbe, 0xdb, 0xf7, 0xb9, 0xb0, 0x39, 0x07, 0xe0, 0x06, 0xc4, 0x0e, 0xff,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x88, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00, 0xb8, 0x00, 0x00, 0x00,
      0x08, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
      0xd0, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xd8, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x45, 0x00, 0x56, 0x00, 0x54, 0x00,
      0x5f, 0x00, 0x54, 0x00, 0x45, 0x00, 0x4d, 0x00, 0x50, 0x00, 0x4c, 0x00,
      0x41, 0x00, 0x54, 0x00, 0x45, 0x00, 0x00, 0x00, 0x4d, 0x00, 0x55, 0x00,
      0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
      0x4d, 0x00, 0x55, 0x00, 0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00,
      0x65, 0x00, 0x6e, 0x00, 0x2d, 0x00, 0x55, 0x00, 0x53, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00]))

  def test_copy_from_byte_stream(self):
    """Tests the copy_from_byte_stream function."""
    mui_resource = pywrc.mui_resource()
    mui_resource.copy_from_byte_stream(self._TEST_DATA)

    with self.assertRaises(TypeError):
      mui_resource.copy_from_byte_stream(None)

    with self.assertRaises(IOError):
      mui_resource.copy_from_byte_stream(b'')

  def test_get_file_type(self):
    """Tests the get_file_type function."""
    mui_resource = pywrc.mui_resource()
    mui_resource.copy_from_byte_stream(self._TEST_DATA)

    file_type = mui_resource.get_file_type()
    self.assertEqual(file_type, 17)

  def test_get_main_name(self):
    """Tests the get_main_name function."""
    mui_resource = pywrc.mui_resource()
    mui_resource.copy_from_byte_stream(self._TEST_DATA)

    main_name = mui_resource.get_main_name()
    self.assertEqual(main_name, 'WEVT_TEMPLATE')

  def test_get_mui_name(self):
    """Tests the get_mui_name function."""
    mui_resource = pywrc.mui_resource()
    mui_resource.copy_from_byte_stream(self._TEST_DATA)

    mui_name = mui_resource.get_mui_name()
    self.assertEqual(mui_name, 'MUI')

  def test_get_language(self):
    """Tests the get_language function."""
    mui_resource = pywrc.mui_resource()
    mui_resource.copy_from_byte_stream(self._TEST_DATA)

    language = mui_resource.get_language()
    self.assertEqual(language, 'en-US')

  def test_get_fallback_language(self):
    """Tests the get_fallback_language function."""
    mui_resource = pywrc.mui_resource()
    mui_resource.copy_from_byte_stream(self._TEST_DATA)

    fallback_language = mui_resource.get_fallback_language()
    self.assertEqual(fallback_language, 'en-US')


if __name__ == "__main__":
  unittest.main(verbosity=2)
