#!/usr/bin/env python
#
# Python-bindings version_information_resource type test script
#
# Copyright (C) 2011-2021, Joachim Metz <joachim.metz@gmail.com>
#
# Refer to AUTHORS for acknowledgements.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

import unittest

import pywrc


class VersionInformationResourceTypeTests(unittest.TestCase):
  """Tests the version_information_resource type."""

  _TEST_DATA = bytes(bytearray([
      0xfc, 0x02, 0x34, 0x00, 0x00, 0x00, 0x56, 0x00, 0x53, 0x00, 0x5f, 0x00,
      0x56, 0x00, 0x45, 0x00, 0x52, 0x00, 0x53, 0x00, 0x49, 0x00, 0x4f, 0x00,
      0x4e, 0x00, 0x5f, 0x00, 0x49, 0x00, 0x4e, 0x00, 0x46, 0x00, 0x4f, 0x00,
      0x00, 0x00, 0x00, 0x00, 0xbd, 0x04, 0xef, 0xfe, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x5c, 0x02, 0x00, 0x00,
      0x01, 0x00, 0x53, 0x00, 0x74, 0x00, 0x72, 0x00, 0x69, 0x00, 0x6e, 0x00,
      0x67, 0x00, 0x46, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x49, 0x00,
      0x6e, 0x00, 0x66, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x38, 0x02, 0x00, 0x00,
      0x01, 0x00, 0x30, 0x00, 0x34, 0x00, 0x30, 0x00, 0x39, 0x00, 0x30, 0x00,
      0x34, 0x00, 0x65, 0x00, 0x34, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x09, 0x00,
      0x01, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x6d, 0x00, 0x65, 0x00,
      0x6e, 0x00, 0x74, 0x00, 0x73, 0x00, 0x00, 0x00, 0x43, 0x00, 0x6f, 0x00,
      0x6d, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x74, 0x00, 0x73, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x5e, 0x00, 0x1b, 0x00, 0x01, 0x00, 0x46, 0x00,
      0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x44, 0x00, 0x65, 0x00, 0x73, 0x00,
      0x63, 0x00, 0x72, 0x00, 0x69, 0x00, 0x70, 0x00, 0x74, 0x00, 0x69, 0x00,
      0x6f, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x57, 0x00, 0x69, 0x00,
      0x6e, 0x00, 0x64, 0x00, 0x6f, 0x00, 0x77, 0x00, 0x73, 0x00, 0x20, 0x00,
      0x52, 0x00, 0x65, 0x00, 0x73, 0x00, 0x6f, 0x00, 0x75, 0x00, 0x72, 0x00,
      0x63, 0x00, 0x65, 0x00, 0x20, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00,
      0x74, 0x00, 0x20, 0x00, 0x66, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x06, 0x00, 0x01, 0x00, 0x46, 0x00,
      0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x56, 0x00, 0x65, 0x00, 0x72, 0x00,
      0x73, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x31, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x00, 0x00,
      0x3a, 0x00, 0x0d, 0x00, 0x01, 0x00, 0x49, 0x00, 0x6e, 0x00, 0x74, 0x00,
      0x65, 0x00, 0x72, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x4e, 0x00,
      0x61, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x00, 0x00, 0x77, 0x00, 0x72, 0x00,
      0x63, 0x00, 0x5f, 0x00, 0x74, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00,
      0x2e, 0x00, 0x64, 0x00, 0x6c, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x84, 0x00, 0x30, 0x00, 0x01, 0x00, 0x4c, 0x00, 0x65, 0x00, 0x67, 0x00,
      0x61, 0x00, 0x6c, 0x00, 0x43, 0x00, 0x6f, 0x00, 0x70, 0x00, 0x79, 0x00,
      0x72, 0x00, 0x69, 0x00, 0x67, 0x00, 0x68, 0x00, 0x74, 0x00, 0x00, 0x00,
      0x28, 0x00, 0x43, 0x00, 0x29, 0x00, 0x20, 0x00, 0x32, 0x00, 0x30, 0x00,
      0x31, 0x00, 0x37, 0x00, 0x2c, 0x00, 0x20, 0x00, 0x4a, 0x00, 0x6f, 0x00,
      0x61, 0x00, 0x63, 0x00, 0x68, 0x00, 0x69, 0x00, 0x6d, 0x00, 0x20, 0x00,
      0x4d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x7a, 0x00, 0x20, 0x00, 0x3c, 0x00,
      0x6a, 0x00, 0x6f, 0x00, 0x61, 0x00, 0x63, 0x00, 0x68, 0x00, 0x69, 0x00,
      0x6d, 0x00, 0x2e, 0x00, 0x6d, 0x00, 0x65, 0x00, 0x74, 0x00, 0x7a, 0x00,
      0x40, 0x00, 0x67, 0x00, 0x6d, 0x00, 0x61, 0x00, 0x69, 0x00, 0x6c, 0x00,
      0x2e, 0x00, 0x63, 0x00, 0x6f, 0x00, 0x6d, 0x00, 0x3e, 0x00, 0x00, 0x00,
      0x42, 0x00, 0x0d, 0x00, 0x01, 0x00, 0x4f, 0x00, 0x72, 0x00, 0x69, 0x00,
      0x67, 0x00, 0x69, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6c, 0x00, 0x46, 0x00,
      0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x6e, 0x00, 0x61, 0x00, 0x6d, 0x00,
      0x65, 0x00, 0x00, 0x00, 0x77, 0x00, 0x72, 0x00, 0x63, 0x00, 0x5f, 0x00,
      0x74, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x2e, 0x00, 0x64, 0x00,
      0x6c, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x09, 0x00,
      0x01, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00, 0x64, 0x00, 0x75, 0x00,
      0x63, 0x00, 0x74, 0x00, 0x4e, 0x00, 0x61, 0x00, 0x6d, 0x00, 0x65, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x77, 0x00, 0x72, 0x00, 0x63, 0x00, 0x5f, 0x00,
      0x74, 0x00, 0x65, 0x00, 0x73, 0x00, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00,
      0x30, 0x00, 0x06, 0x00, 0x01, 0x00, 0x50, 0x00, 0x72, 0x00, 0x6f, 0x00,
      0x64, 0x00, 0x75, 0x00, 0x63, 0x00, 0x74, 0x00, 0x56, 0x00, 0x65, 0x00,
      0x72, 0x00, 0x73, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00, 0x00, 0x00,
      0x31, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x2e, 0x00, 0x30, 0x00, 0x00, 0x00,
      0x44, 0x00, 0x00, 0x00, 0x01, 0x00, 0x56, 0x00, 0x61, 0x00, 0x72, 0x00,
      0x46, 0x00, 0x69, 0x00, 0x6c, 0x00, 0x65, 0x00, 0x49, 0x00, 0x6e, 0x00,
      0x66, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x04, 0x00,
      0x00, 0x00, 0x54, 0x00, 0x72, 0x00, 0x61, 0x00, 0x6e, 0x00, 0x73, 0x00,
      0x6c, 0x00, 0x61, 0x00, 0x74, 0x00, 0x69, 0x00, 0x6f, 0x00, 0x6e, 0x00,
      0x00, 0x00, 0x00, 0x00, 0x09, 0x04, 0xe4, 0x04]))

  def test_copy_from_byte_stream(self):
    """Tests the copy_from_byte_stream function."""
    version_information_resource = pywrc.version_information_resource()
    version_information_resource.copy_from_byte_stream(self._TEST_DATA)

    with self.assertRaises(TypeError):
      version_information_resource.copy_from_byte_stream(None)

    with self.assertRaises(IOError):
      version_information_resource.copy_from_byte_stream(b'')

  def test_get_file_version(self):
    """Tests the get_file_version function."""
    version_information_resource = pywrc.version_information_resource()
    version_information_resource.copy_from_byte_stream(self._TEST_DATA)

    file_version = version_information_resource.get_file_version()
    self.assertEqual(file_version, 0x1000000000000)

  def test_get_product_version(self):
    """Tests the get_product_version function."""
    version_information_resource = pywrc.version_information_resource()
    version_information_resource.copy_from_byte_stream(self._TEST_DATA)

    product_version = version_information_resource.get_product_version()
    self.assertEqual(product_version, 0x1000000000000)


if __name__ == "__main__":
  unittest.main(verbosity=2)
