from http import HTTPStatus
from typing import Any
from typing import Dict
from typing import Optional

import httpx

from ... import errors
from ...client import Client
from ...models.get_invite_link_response_200 import GetInviteLinkResponse200
from ...types import Response


def _get_kwargs(
    invite_link_id: str,
    *,
    client: Client,
) -> Dict[str, Any]:
    url = "{}/invite-links/{inviteLinkId}".format(client.base_url, inviteLinkId=invite_link_id)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    return {
        "method": "get",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "follow_redirects": client.follow_redirects,
    }


def _parse_response(*, client: Client, response: httpx.Response) -> Optional[GetInviteLinkResponse200]:
    if response.status_code == HTTPStatus.OK:
        response_200 = GetInviteLinkResponse200.from_dict(response.json())

        return response_200
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(*, client: Client, response: httpx.Response) -> Response[GetInviteLinkResponse200]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    invite_link_id: str,
    *,
    client: Client,
) -> Response[GetInviteLinkResponse200]:
    """Get an invite link

    Args:
        invite_link_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[GetInviteLinkResponse200]
    """

    kwargs = _get_kwargs(
        invite_link_id=invite_link_id,
        client=client,
    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    invite_link_id: str,
    *,
    client: Client,
) -> Optional[GetInviteLinkResponse200]:
    """Get an invite link

    Args:
        invite_link_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        GetInviteLinkResponse200
    """

    return sync_detailed(
        invite_link_id=invite_link_id,
        client=client,
    ).parsed


async def asyncio_detailed(
    invite_link_id: str,
    *,
    client: Client,
) -> Response[GetInviteLinkResponse200]:
    """Get an invite link

    Args:
        invite_link_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[GetInviteLinkResponse200]
    """

    kwargs = _get_kwargs(
        invite_link_id=invite_link_id,
        client=client,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    invite_link_id: str,
    *,
    client: Client,
) -> Optional[GetInviteLinkResponse200]:
    """Get an invite link

    Args:
        invite_link_id (str):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        GetInviteLinkResponse200
    """

    return (
        await asyncio_detailed(
            invite_link_id=invite_link_id,
            client=client,
        )
    ).parsed
