from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.get_github_list_repositories_response_200_status import (
    GetGithubListRepositoriesResponse200Status,
)

if TYPE_CHECKING:
    from ..models.git_repo import GitRepo


T = TypeVar("T", bound="GetGithubListRepositoriesResponse200")


@_attrs_define
class GetGithubListRepositoriesResponse200:
    """
    Attributes:
        results (List['GitRepo']):
        status (GetGithubListRepositoriesResponse200Status):
    """

    results: List["GitRepo"]
    status: GetGithubListRepositoriesResponse200Status
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        results = []
        for results_item_data in self.results:
            results_item = results_item_data.to_dict()
            results.append(results_item)

        status = self.status.value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "results": results,
                "status": status,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.git_repo import GitRepo

        d = src_dict.copy()
        results = []
        _results = d.pop("results")
        for results_item_data in _results:
            results_item = GitRepo.from_dict(results_item_data)

            results.append(results_item)

        status = GetGithubListRepositoriesResponse200Status(d.pop("status"))

        get_github_list_repositories_response_200 = cls(
            results=results,
            status=status,
        )

        get_github_list_repositories_response_200.additional_properties = d
        return get_github_list_repositories_response_200

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
