from typing import TYPE_CHECKING, Any, BinaryIO, Dict, List, Optional, TextIO, Tuple, Type, TypeVar

from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..models.lineage_node_dependency_type import LineageNodeDependencyType
from ..types import UNSET, Unset

T = TypeVar("T", bound="LineageNodeDependency")


@_attrs_define
class LineageNodeDependency:
    """
    Attributes:
        name (str):
        type (LineageNodeDependencyType):
    """

    name: str
    type: LineageNodeDependencyType
    additional_properties: Dict[str, Any] = _attrs_field(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        name = self.name

        type = self.type.value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "name": name,
                "type": type,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        name = d.pop("name")

        type = LineageNodeDependencyType(d.pop("type"))

        lineage_node_dependency = cls(
            name=name,
            type=type,
        )

        lineage_node_dependency.additional_properties = d
        return lineage_node_dependency

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
