from http import HTTPStatus
from typing import Any
from typing import Dict
from typing import Optional

import httpx

from ... import errors
from ...client import Client
from ...models.api_organization_member_profile import ApiOrganizationMemberProfile
from ...models.organization_member_profile_update import OrganizationMemberProfileUpdate
from ...types import Response


def _get_kwargs(
    user_uuid: str,
    *,
    client: Client,
    json_body: OrganizationMemberProfileUpdate,
) -> Dict[str, Any]:
    url = "{}/api/v1/org/users/{userUuid}".format(client.base_url, userUuid=user_uuid)

    headers: Dict[str, str] = client.get_headers()
    cookies: Dict[str, Any] = client.get_cookies()

    json_json_body = json_body.to_dict()

    return {
        "method": "patch",
        "url": url,
        "headers": headers,
        "cookies": cookies,
        "timeout": client.get_timeout(),
        "follow_redirects": client.follow_redirects,
        "json": json_json_body,
    }


def _parse_response(*, client: Client, response: httpx.Response) -> Optional[ApiOrganizationMemberProfile]:
    if response.status_code == HTTPStatus.OK:
        response_200 = ApiOrganizationMemberProfile.from_dict(response.json())

        return response_200
    if client.raise_on_unexpected_status:
        raise errors.UnexpectedStatus(response.status_code, response.content)
    else:
        return None


def _build_response(*, client: Client, response: httpx.Response) -> Response[ApiOrganizationMemberProfile]:
    return Response(
        status_code=HTTPStatus(response.status_code),
        content=response.content,
        headers=response.headers,
        parsed=_parse_response(client=client, response=response),
    )


def sync_detailed(
    user_uuid: str,
    *,
    client: Client,
    json_body: OrganizationMemberProfileUpdate,
) -> Response[ApiOrganizationMemberProfile]:
    """Updates the membership profile for a user in the current user's organization

    Args:
        user_uuid (str):
        json_body (OrganizationMemberProfileUpdate):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ApiOrganizationMemberProfile]
    """

    kwargs = _get_kwargs(
        user_uuid=user_uuid,
        client=client,
        json_body=json_body,
    )

    response = httpx.request(
        verify=client.verify_ssl,
        **kwargs,
    )

    return _build_response(client=client, response=response)


def sync(
    user_uuid: str,
    *,
    client: Client,
    json_body: OrganizationMemberProfileUpdate,
) -> Optional[ApiOrganizationMemberProfile]:
    """Updates the membership profile for a user in the current user's organization

    Args:
        user_uuid (str):
        json_body (OrganizationMemberProfileUpdate):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ApiOrganizationMemberProfile
    """

    return sync_detailed(
        user_uuid=user_uuid,
        client=client,
        json_body=json_body,
    ).parsed


async def asyncio_detailed(
    user_uuid: str,
    *,
    client: Client,
    json_body: OrganizationMemberProfileUpdate,
) -> Response[ApiOrganizationMemberProfile]:
    """Updates the membership profile for a user in the current user's organization

    Args:
        user_uuid (str):
        json_body (OrganizationMemberProfileUpdate):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        Response[ApiOrganizationMemberProfile]
    """

    kwargs = _get_kwargs(
        user_uuid=user_uuid,
        client=client,
        json_body=json_body,
    )

    async with httpx.AsyncClient(verify=client.verify_ssl) as _client:
        response = await _client.request(**kwargs)

    return _build_response(client=client, response=response)


async def asyncio(
    user_uuid: str,
    *,
    client: Client,
    json_body: OrganizationMemberProfileUpdate,
) -> Optional[ApiOrganizationMemberProfile]:
    """Updates the membership profile for a user in the current user's organization

    Args:
        user_uuid (str):
        json_body (OrganizationMemberProfileUpdate):

    Raises:
        errors.UnexpectedStatus: If the server returns an undocumented status code and Client.raise_on_unexpected_status is True.
        httpx.TimeoutException: If the request takes longer than Client.timeout.

    Returns:
        ApiOrganizationMemberProfile
    """

    return (
        await asyncio_detailed(
            user_uuid=user_uuid,
            client=client,
            json_body=json_body,
        )
    ).parsed
