from typing import TYPE_CHECKING, Any, Dict, List, Type, TypeVar

import attr

from ..models.run_metric_query_response_200_status import (
    RunMetricQueryResponse200Status,
)

if TYPE_CHECKING:
    from ..models.run_metric_query_response_200_results import (
        RunMetricQueryResponse200Results,
    )


T = TypeVar("T", bound="RunMetricQueryResponse200")


@attr.s(auto_attribs=True)
class RunMetricQueryResponse200:
    """
    Attributes:
        results (RunMetricQueryResponse200Results):
        status (RunMetricQueryResponse200Status):
    """

    results: "RunMetricQueryResponse200Results"
    status: RunMetricQueryResponse200Status
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        results = self.results.to_dict()

        status = self.status.value

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update(
            {
                "results": results,
                "status": status,
            }
        )

        return field_dict

    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        from ..models.run_metric_query_response_200_results import (
            RunMetricQueryResponse200Results,
        )

        d = src_dict.copy()
        results = RunMetricQueryResponse200Results.from_dict(d.pop("results"))

        status = RunMetricQueryResponse200Status(d.pop("status"))

        run_metric_query_response_200 = cls(
            results=results,
            status=status,
        )

        run_metric_query_response_200.additional_properties = d
        return run_metric_query_response_200

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
