# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class MatchBand(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'minimum_score': 'int',
        'maximum_score': 'int',
        'num_source_words': 'int',
        'num_segments': 'int'
    }

    attribute_map = {
        'minimum_score': 'minimum_score',
        'maximum_score': 'maximum_score',
        'num_source_words': 'num_source_words',
        'num_segments': 'num_segments'
    }

    def __init__(self, minimum_score=None, maximum_score=None, num_source_words=None, num_segments=None, local_vars_configuration=None):  # noqa: E501
        """MatchBand - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._minimum_score = None
        self._maximum_score = None
        self._num_source_words = None
        self._num_segments = None
        self.discriminator = None

        if minimum_score is not None:
            self.minimum_score = minimum_score
        if maximum_score is not None:
            self.maximum_score = maximum_score
        if num_source_words is not None:
            self.num_source_words = num_source_words
        if num_segments is not None:
            self.num_segments = num_segments

    @property
    def minimum_score(self):
        """Gets the minimum_score of this MatchBand.  # noqa: E501

        The minimum fuzzy match score.  # noqa: E501

        :return: The minimum_score of this MatchBand.  # noqa: E501
        :rtype: int
        """
        return self._minimum_score

    @minimum_score.setter
    def minimum_score(self, minimum_score):
        """Sets the minimum_score of this MatchBand.

        The minimum fuzzy match score.  # noqa: E501

        :param minimum_score: The minimum_score of this MatchBand.  # noqa: E501
        :type: int
        """

        self._minimum_score = minimum_score

    @property
    def maximum_score(self):
        """Gets the maximum_score of this MatchBand.  # noqa: E501

        The maximum fuzzy match score.  # noqa: E501

        :return: The maximum_score of this MatchBand.  # noqa: E501
        :rtype: int
        """
        return self._maximum_score

    @maximum_score.setter
    def maximum_score(self, maximum_score):
        """Sets the maximum_score of this MatchBand.

        The maximum fuzzy match score.  # noqa: E501

        :param maximum_score: The maximum_score of this MatchBand.  # noqa: E501
        :type: int
        """

        self._maximum_score = maximum_score

    @property
    def num_source_words(self):
        """Gets the num_source_words of this MatchBand.  # noqa: E501

        The number of source words in the band.  # noqa: E501

        :return: The num_source_words of this MatchBand.  # noqa: E501
        :rtype: int
        """
        return self._num_source_words

    @num_source_words.setter
    def num_source_words(self, num_source_words):
        """Sets the num_source_words of this MatchBand.

        The number of source words in the band.  # noqa: E501

        :param num_source_words: The num_source_words of this MatchBand.  # noqa: E501
        :type: int
        """

        self._num_source_words = num_source_words

    @property
    def num_segments(self):
        """Gets the num_segments of this MatchBand.  # noqa: E501

        The number of source segments in the band.  # noqa: E501

        :return: The num_segments of this MatchBand.  # noqa: E501
        :rtype: int
        """
        return self._num_segments

    @num_segments.setter
    def num_segments(self, num_segments):
        """Sets the num_segments of this MatchBand.

        The number of source segments in the band.  # noqa: E501

        :param num_segments: The num_segments of this MatchBand.  # noqa: E501
        :type: int
        """

        self._num_segments = num_segments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MatchBand):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MatchBand):
            return True

        return self.to_dict() != other.to_dict()
