# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. ## Authentication Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class ResourceStatus(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'email': 'str',
        'name': 'str',
        'num_words_confirmed': 'int',
        'num_words_new': 'int',
        'num_words_fuzzy': 'int',
        'num_words_exact': 'int',
        'num_words_reviewed': 'int',
        'time_elapsed': 'int',
        'time_elapsed_translation': 'int',
        'time_elapsed_research': 'int',
        'time_elapsed_review': 'int',
        'num_segments_confirmed': 'int',
        'num_segments_reviewed': 'int'
    }

    attribute_map = {
        'email': 'email',
        'name': 'name',
        'num_words_confirmed': 'num_words_confirmed',
        'num_words_new': 'num_words_new',
        'num_words_fuzzy': 'num_words_fuzzy',
        'num_words_exact': 'num_words_exact',
        'num_words_reviewed': 'num_words_reviewed',
        'time_elapsed': 'time_elapsed',
        'time_elapsed_translation': 'time_elapsed_translation',
        'time_elapsed_research': 'time_elapsed_research',
        'time_elapsed_review': 'time_elapsed_review',
        'num_segments_confirmed': 'num_segments_confirmed',
        'num_segments_reviewed': 'num_segments_reviewed'
    }

    def __init__(self, email=None, name=None, num_words_confirmed=None, num_words_new=None, num_words_fuzzy=None, num_words_exact=None, num_words_reviewed=None, time_elapsed=None, time_elapsed_translation=None, time_elapsed_research=None, time_elapsed_review=None, num_segments_confirmed=None, num_segments_reviewed=None, local_vars_configuration=None):  # noqa: E501
        """ResourceStatus - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._email = None
        self._name = None
        self._num_words_confirmed = None
        self._num_words_new = None
        self._num_words_fuzzy = None
        self._num_words_exact = None
        self._num_words_reviewed = None
        self._time_elapsed = None
        self._time_elapsed_translation = None
        self._time_elapsed_research = None
        self._time_elapsed_review = None
        self._num_segments_confirmed = None
        self._num_segments_reviewed = None
        self.discriminator = None

        if email is not None:
            self.email = email
        if name is not None:
            self.name = name
        if num_words_confirmed is not None:
            self.num_words_confirmed = num_words_confirmed
        if num_words_new is not None:
            self.num_words_new = num_words_new
        if num_words_fuzzy is not None:
            self.num_words_fuzzy = num_words_fuzzy
        if num_words_exact is not None:
            self.num_words_exact = num_words_exact
        if num_words_reviewed is not None:
            self.num_words_reviewed = num_words_reviewed
        if time_elapsed is not None:
            self.time_elapsed = time_elapsed
        if time_elapsed_translation is not None:
            self.time_elapsed_translation = time_elapsed_translation
        if time_elapsed_research is not None:
            self.time_elapsed_research = time_elapsed_research
        if time_elapsed_review is not None:
            self.time_elapsed_review = time_elapsed_review
        if num_segments_confirmed is not None:
            self.num_segments_confirmed = num_segments_confirmed
        if num_segments_reviewed is not None:
            self.num_segments_reviewed = num_segments_reviewed

    @property
    def email(self):
        """Gets the email of this ResourceStatus.  # noqa: E501

        An email address.  # noqa: E501

        :return: The email of this ResourceStatus.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this ResourceStatus.

        An email address.  # noqa: E501

        :param email: The email of this ResourceStatus.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def name(self):
        """Gets the name of this ResourceStatus.  # noqa: E501

        The full name.  # noqa: E501

        :return: The name of this ResourceStatus.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ResourceStatus.

        The full name.  # noqa: E501

        :param name: The name of this ResourceStatus.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def num_words_confirmed(self):
        """Gets the num_words_confirmed of this ResourceStatus.  # noqa: E501

        The number of source words confirmed.  # noqa: E501

        :return: The num_words_confirmed of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._num_words_confirmed

    @num_words_confirmed.setter
    def num_words_confirmed(self, num_words_confirmed):
        """Sets the num_words_confirmed of this ResourceStatus.

        The number of source words confirmed.  # noqa: E501

        :param num_words_confirmed: The num_words_confirmed of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._num_words_confirmed = num_words_confirmed

    @property
    def num_words_new(self):
        """Gets the num_words_new of this ResourceStatus.  # noqa: E501

        The number of new source words confirmed.  # noqa: E501

        :return: The num_words_new of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._num_words_new

    @num_words_new.setter
    def num_words_new(self, num_words_new):
        """Sets the num_words_new of this ResourceStatus.

        The number of new source words confirmed.  # noqa: E501

        :param num_words_new: The num_words_new of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._num_words_new = num_words_new

    @property
    def num_words_fuzzy(self):
        """Gets the num_words_fuzzy of this ResourceStatus.  # noqa: E501

        The number of fuzzy match source words confirmed.  # noqa: E501

        :return: The num_words_fuzzy of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._num_words_fuzzy

    @num_words_fuzzy.setter
    def num_words_fuzzy(self, num_words_fuzzy):
        """Sets the num_words_fuzzy of this ResourceStatus.

        The number of fuzzy match source words confirmed.  # noqa: E501

        :param num_words_fuzzy: The num_words_fuzzy of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._num_words_fuzzy = num_words_fuzzy

    @property
    def num_words_exact(self):
        """Gets the num_words_exact of this ResourceStatus.  # noqa: E501

        The number of exact match source words confirmed.  # noqa: E501

        :return: The num_words_exact of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._num_words_exact

    @num_words_exact.setter
    def num_words_exact(self, num_words_exact):
        """Sets the num_words_exact of this ResourceStatus.

        The number of exact match source words confirmed.  # noqa: E501

        :param num_words_exact: The num_words_exact of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._num_words_exact = num_words_exact

    @property
    def num_words_reviewed(self):
        """Gets the num_words_reviewed of this ResourceStatus.  # noqa: E501

        The number of source words reviewed.  # noqa: E501

        :return: The num_words_reviewed of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._num_words_reviewed

    @num_words_reviewed.setter
    def num_words_reviewed(self, num_words_reviewed):
        """Sets the num_words_reviewed of this ResourceStatus.

        The number of source words reviewed.  # noqa: E501

        :param num_words_reviewed: The num_words_reviewed of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._num_words_reviewed = num_words_reviewed

    @property
    def time_elapsed(self):
        """Gets the time_elapsed of this ResourceStatus.  # noqa: E501

        The total time spent on translation and research. Measured in milliseconds.  # noqa: E501

        :return: The time_elapsed of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._time_elapsed

    @time_elapsed.setter
    def time_elapsed(self, time_elapsed):
        """Sets the time_elapsed of this ResourceStatus.

        The total time spent on translation and research. Measured in milliseconds.  # noqa: E501

        :param time_elapsed: The time_elapsed of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._time_elapsed = time_elapsed

    @property
    def time_elapsed_translation(self):
        """Gets the time_elapsed_translation of this ResourceStatus.  # noqa: E501

        The total time spent translating. Measured in milliseconds.  # noqa: E501

        :return: The time_elapsed_translation of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._time_elapsed_translation

    @time_elapsed_translation.setter
    def time_elapsed_translation(self, time_elapsed_translation):
        """Sets the time_elapsed_translation of this ResourceStatus.

        The total time spent translating. Measured in milliseconds.  # noqa: E501

        :param time_elapsed_translation: The time_elapsed_translation of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._time_elapsed_translation = time_elapsed_translation

    @property
    def time_elapsed_research(self):
        """Gets the time_elapsed_research of this ResourceStatus.  # noqa: E501

        The total time spent on research. Measured in milliseconds.  # noqa: E501

        :return: The time_elapsed_research of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._time_elapsed_research

    @time_elapsed_research.setter
    def time_elapsed_research(self, time_elapsed_research):
        """Sets the time_elapsed_research of this ResourceStatus.

        The total time spent on research. Measured in milliseconds.  # noqa: E501

        :param time_elapsed_research: The time_elapsed_research of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._time_elapsed_research = time_elapsed_research

    @property
    def time_elapsed_review(self):
        """Gets the time_elapsed_review of this ResourceStatus.  # noqa: E501

        The total time spent reviewing. Measured in milliseconds.  # noqa: E501

        :return: The time_elapsed_review of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._time_elapsed_review

    @time_elapsed_review.setter
    def time_elapsed_review(self, time_elapsed_review):
        """Sets the time_elapsed_review of this ResourceStatus.

        The total time spent reviewing. Measured in milliseconds.  # noqa: E501

        :param time_elapsed_review: The time_elapsed_review of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._time_elapsed_review = time_elapsed_review

    @property
    def num_segments_confirmed(self):
        """Gets the num_segments_confirmed of this ResourceStatus.  # noqa: E501

        The number of source segments confirmed.  # noqa: E501

        :return: The num_segments_confirmed of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._num_segments_confirmed

    @num_segments_confirmed.setter
    def num_segments_confirmed(self, num_segments_confirmed):
        """Sets the num_segments_confirmed of this ResourceStatus.

        The number of source segments confirmed.  # noqa: E501

        :param num_segments_confirmed: The num_segments_confirmed of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._num_segments_confirmed = num_segments_confirmed

    @property
    def num_segments_reviewed(self):
        """Gets the num_segments_reviewed of this ResourceStatus.  # noqa: E501

        The number of source segments reviewed.  # noqa: E501

        :return: The num_segments_reviewed of this ResourceStatus.  # noqa: E501
        :rtype: int
        """
        return self._num_segments_reviewed

    @num_segments_reviewed.setter
    def num_segments_reviewed(self, num_segments_reviewed):
        """Sets the num_segments_reviewed of this ResourceStatus.

        The number of source segments reviewed.  # noqa: E501

        :param num_segments_reviewed: The num_segments_reviewed of this ResourceStatus.  # noqa: E501
        :type: int
        """

        self._num_segments_reviewed = num_segments_reviewed

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ResourceStatus):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ResourceStatus):
            return True

        return self.to_dict() != other.to_dict()
