# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lilt.api_client import ApiClient
from lilt.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ConverterConfigApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_converter_config(self, organization_id, **kwargs):  # noqa: E501
        """Add Converter Config  # noqa: E501

        Add a file filter configuration for your Organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_converter_config(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization_id: A unique Organization identifier. (required)
        :param CreateConverterConfigParameters body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConverterConfigUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.add_converter_config_with_http_info(organization_id, **kwargs)  # noqa: E501

    def add_converter_config_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Add Converter Config  # noqa: E501

        Add a file filter configuration for your Organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_converter_config_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization_id: A unique Organization identifier. (required)
        :param CreateConverterConfigParameters body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConverterConfigUpdateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'organization_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_converter_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_id` when calling `add_converter_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'organization_id' in local_var_params and local_var_params['organization_id'] is not None:  # noqa: E501
            query_params.append(('organizationId', local_var_params['organization_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/configs/converter', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConverterConfigUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_converter_config(self, config_id, **kwargs):  # noqa: E501
        """Delete Converter Config  # noqa: E501

        Delete a file filter configuration by id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_converter_config(config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ConverterConfigUpdateResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_converter_config_with_http_info(config_id, **kwargs)  # noqa: E501

    def delete_converter_config_with_http_info(self, config_id, **kwargs):  # noqa: E501
        """Delete Converter Config  # noqa: E501

        Delete a file filter configuration by id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_converter_config_with_http_info(config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ConverterConfigUpdateResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'config_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_converter_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and ('config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `delete_converter_config`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/configs/converter/{configId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ConverterConfigUpdateResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_filter_mapping(self, config_id, file_extension, **kwargs):  # noqa: E501
        """Delete Filter Mapping  # noqa: E501

        Delete a file filter mapping by id and file extension.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_filter_mapping(config_id, file_extension, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param str file_extension: A file extension to delete. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_filter_mapping_with_http_info(config_id, file_extension, **kwargs)  # noqa: E501

    def delete_filter_mapping_with_http_info(self, config_id, file_extension, **kwargs):  # noqa: E501
        """Delete Filter Mapping  # noqa: E501

        Delete a file filter mapping by id and file extension.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_filter_mapping_with_http_info(config_id, file_extension, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param str file_extension: A file extension to delete. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, str), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'config_id',
            'file_extension'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_filter_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and ('config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `delete_filter_mapping`")  # noqa: E501
        # verify the required parameter 'file_extension' is set
        if self.api_client.client_side_validation and ('file_extension' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_extension'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_extension` when calling `delete_filter_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501
        if 'file_extension' in local_var_params:
            path_params['fileExtension'] = local_var_params['file_extension']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/configs/converter/{configId}/{fileExtension}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_filter_mapping(self, config_id, file_extension, **kwargs):  # noqa: E501
        """Add Filter Mapping  # noqa: E501

        Add a specific filter mapping to your file filter configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_filter_mapping(config_id, file_extension, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param str file_extension: A file extension for the filter mapping. (required)
        :param EditFilterMappingParameters body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.edit_filter_mapping_with_http_info(config_id, file_extension, **kwargs)  # noqa: E501

    def edit_filter_mapping_with_http_info(self, config_id, file_extension, **kwargs):  # noqa: E501
        """Add Filter Mapping  # noqa: E501

        Add a specific filter mapping to your file filter configuration   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_filter_mapping_with_http_info(config_id, file_extension, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param str file_extension: A file extension for the filter mapping. (required)
        :param EditFilterMappingParameters body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, str), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'config_id',
            'file_extension',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_filter_mapping" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and ('config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `edit_filter_mapping`")  # noqa: E501
        # verify the required parameter 'file_extension' is set
        if self.api_client.client_side_validation and ('file_extension' not in local_var_params or  # noqa: E501
                                                        local_var_params['file_extension'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `file_extension` when calling `edit_filter_mapping`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501
        if 'file_extension' in local_var_params:
            path_params['fileExtension'] = local_var_params['file_extension']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/configs/converter/{configId}/{fileExtension}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_converter_config_by_id(self, config_id, **kwargs):  # noqa: E501
        """Fetch Converter Config by Id  # noqa: E501

        Fetch a file filter configuration by id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_converter_config_by_id(config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_converter_config_by_id_with_http_info(config_id, **kwargs)  # noqa: E501

    def get_converter_config_by_id_with_http_info(self, config_id, **kwargs):  # noqa: E501
        """Fetch Converter Config by Id  # noqa: E501

        Fetch a file filter configuration by id.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_converter_config_by_id_with_http_info(config_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int config_id: A unique configuration identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, str), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'config_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_converter_config_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'config_id' is set
        if self.api_client.client_side_validation and ('config_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['config_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `config_id` when calling `get_converter_config_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'config_id' in local_var_params:
            path_params['configId'] = local_var_params['config_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/configs/converter/{configId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_converter_configs(self, organization_id, **kwargs):  # noqa: E501
        """List Converter Configs  # noqa: E501

        List all file filter configurations for your Organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_converter_configs(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization_id: A unique Organization identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: dict(str, str)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_converter_configs_with_http_info(organization_id, **kwargs)  # noqa: E501

    def get_converter_configs_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """List Converter Configs  # noqa: E501

        List all file filter configurations for your Organization.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_converter_configs_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int organization_id: A unique Organization identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(dict(str, str), status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'organization_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_converter_configs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['organization_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `organization_id` when calling `get_converter_configs`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'organization_id' in local_var_params and local_var_params['organization_id'] is not None:  # noqa: E501
            query_params.append(('organizationId', local_var_params['organization_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/configs/converter', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, str)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
