# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lilt.api_client import ApiClient
from lilt.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WorkflowsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def advance_workflow_stage(self, document_id, task_id, **kwargs):  # noqa: E501
        """Advance workflow to the next stage  # noqa: E501

        Advance a workflow to the next stage and mark current workflow task as complete.  Example CURL: ``` curl --X --request POST 'https://lilt.com/2/workflows/document/{documentId}/task/{taskId}/advance?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.advance_workflow_stage(document_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param int task_id: The task id of the current workflow stage. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NextWorkflowTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.advance_workflow_stage_with_http_info(document_id, task_id, **kwargs)  # noqa: E501

    def advance_workflow_stage_with_http_info(self, document_id, task_id, **kwargs):  # noqa: E501
        """Advance workflow to the next stage  # noqa: E501

        Advance a workflow to the next stage and mark current workflow task as complete.  Example CURL: ``` curl --X --request POST 'https://lilt.com/2/workflows/document/{documentId}/task/{taskId}/advance?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.advance_workflow_stage_with_http_info(document_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param int task_id: The task id of the current workflow stage. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NextWorkflowTask, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_id',
            'task_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method advance_workflow_stage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_id' is set
        if self.api_client.client_side_validation and ('document_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_id` when calling `advance_workflow_stage`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `advance_workflow_stage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document_id' in local_var_params:
            path_params['documentId'] = local_var_params['document_id']  # noqa: E501
        if 'task_id' in local_var_params:
            path_params['taskId'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/document/{documentId}/task/{taskId}/advance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NextWorkflowTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document_workflow(self, document_id, **kwargs):  # noqa: E501
        """Retrieve document Workflow metadata  # noqa: E501

        Get Workflow metadata related to a document. This is useful for gathering information about the current Workflow stage of a document.  Example CURL: ``` curl --X --request GET 'https://lilt.com/2/workflows/document/{documentId}?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_workflow(document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DocumentWorkflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_document_workflow_with_http_info(document_id, **kwargs)  # noqa: E501

    def get_document_workflow_with_http_info(self, document_id, **kwargs):  # noqa: E501
        """Retrieve document Workflow metadata  # noqa: E501

        Get Workflow metadata related to a document. This is useful for gathering information about the current Workflow stage of a document.  Example CURL: ``` curl --X --request GET 'https://lilt.com/2/workflows/document/{documentId}?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_workflow_with_http_info(document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DocumentWorkflow, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_workflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_id' is set
        if self.api_client.client_side_validation and ('document_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_id` when calling `get_document_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document_id' in local_var_params:
            path_params['documentId'] = local_var_params['document_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/document/{documentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentWorkflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_templates(self, **kwargs):  # noqa: E501
        """Retrieve workflow templates  # noqa: E501

        Get all the possible Workflow Templates owned by the team. Useful for retrieving the ids corresponding to each workflow tables, and passing them to subsequent requests, for example, creating a new Job with a specific Workflow.  Example CURL: ``` curl --X --request GET 'https://lilt.com/2/workflows/templates?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_templates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[WorkflowTemplate]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_workflow_templates_with_http_info(**kwargs)  # noqa: E501

    def get_workflow_templates_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve workflow templates  # noqa: E501

        Get all the possible Workflow Templates owned by the team. Useful for retrieving the ids corresponding to each workflow tables, and passing them to subsequent requests, for example, creating a new Job with a specific Workflow.  Example CURL: ``` curl --X --request GET 'https://lilt.com/2/workflows/templates?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_templates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[WorkflowTemplate], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_templates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/templates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkflowTemplate]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reject_workflow_stage(self, document_id, task_id, **kwargs):  # noqa: E501
        """Move workflow to the previous stage  # noqa: E501

        Move a workflow to the previous stage and mark current workflow task as rejected.  Example CURL: ``` curl --X --request POST 'https://lilt.com/2/workflows/document/{documentId}/task/{taskId}/reject?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_workflow_stage(document_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param int task_id: The task id of the current workflow stage. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NextWorkflowTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reject_workflow_stage_with_http_info(document_id, task_id, **kwargs)  # noqa: E501

    def reject_workflow_stage_with_http_info(self, document_id, task_id, **kwargs):  # noqa: E501
        """Move workflow to the previous stage  # noqa: E501

        Move a workflow to the previous stage and mark current workflow task as rejected.  Example CURL: ``` curl --X --request POST 'https://lilt.com/2/workflows/document/{documentId}/task/{taskId}/reject?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_workflow_stage_with_http_info(document_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param int task_id: The task id of the current workflow stage. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NextWorkflowTask, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_id',
            'task_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_workflow_stage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_id' is set
        if self.api_client.client_side_validation and ('document_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_id` when calling `reject_workflow_stage`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and ('task_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['task_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `task_id` when calling `reject_workflow_stage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document_id' in local_var_params:
            path_params['documentId'] = local_var_params['document_id']  # noqa: E501
        if 'task_id' in local_var_params:
            path_params['taskId'] = local_var_params['task_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/document/{documentId}/task/{taskId}/reject', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NextWorkflowTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_document_stage(self, document_id, **kwargs):  # noqa: E501
        """Set Workflow stage for a document  # noqa: E501

        Set the Workflow stage for a document. You can find the stage information required for this request from the \"Retrieve document Workflow metadata\" endpoint.  Example CURL: ``` curl --X --request PUT 'https://lilt.com/2/workflows/document/{documentId}/stage?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{   \"workflowStageId\": {workflowStageId} }' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_document_stage(document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param SetDocumentStageRequest workflow_stage_id:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NextWorkflowTask
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_document_stage_with_http_info(document_id, **kwargs)  # noqa: E501

    def set_document_stage_with_http_info(self, document_id, **kwargs):  # noqa: E501
        """Set Workflow stage for a document  # noqa: E501

        Set the Workflow stage for a document. You can find the stage information required for this request from the \"Retrieve document Workflow metadata\" endpoint.  Example CURL: ``` curl --X --request PUT 'https://lilt.com/2/workflows/document/{documentId}/stage?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{   \"workflowStageId\": {workflowStageId} }' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_document_stage_with_http_info(document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A document id. (required)
        :param SetDocumentStageRequest workflow_stage_id:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NextWorkflowTask, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_id',
            'workflow_stage_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_document_stage" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_id' is set
        if self.api_client.client_side_validation and ('document_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_id` when calling `set_document_stage`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'document_id' in local_var_params:
            path_params['documentId'] = local_var_params['document_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workflow_stage_id' in local_var_params:
            body_params = local_var_params['workflow_stage_id']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{documentId}/stage', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NextWorkflowTask',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
