# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class JobCreateParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'language_pairs': 'list[LanguagePair]',
        'file_ids': 'list[int]',
        'due': 'str',
        'workflow_template_id': 'int'
    }

    attribute_map = {
        'name': 'name',
        'language_pairs': 'languagePairs',
        'file_ids': 'fileIds',
        'due': 'due',
        'workflow_template_id': 'workflowTemplateId'
    }

    def __init__(self, name=None, language_pairs=None, file_ids=None, due=None, workflow_template_id=None, local_vars_configuration=None):  # noqa: E501
        """JobCreateParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._language_pairs = None
        self._file_ids = None
        self._due = None
        self._workflow_template_id = None
        self.discriminator = None

        self.name = name
        self.language_pairs = language_pairs
        self.file_ids = file_ids
        if due is not None:
            self.due = due
        if workflow_template_id is not None:
            self.workflow_template_id = workflow_template_id

    @property
    def name(self):
        """Gets the name of this JobCreateParameters.  # noqa: E501

        A name for the Job.  # noqa: E501

        :return: The name of this JobCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this JobCreateParameters.

        A name for the Job.  # noqa: E501

        :param name: The name of this JobCreateParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def language_pairs(self):
        """Gets the language_pairs of this JobCreateParameters.  # noqa: E501

        Language pairs is a set of one or more pairs that includes source language, source locale(optional), target language, target locale(optional), and memoryId.  # noqa: E501

        :return: The language_pairs of this JobCreateParameters.  # noqa: E501
        :rtype: list[LanguagePair]
        """
        return self._language_pairs

    @language_pairs.setter
    def language_pairs(self, language_pairs):
        """Sets the language_pairs of this JobCreateParameters.

        Language pairs is a set of one or more pairs that includes source language, source locale(optional), target language, target locale(optional), and memoryId.  # noqa: E501

        :param language_pairs: The language_pairs of this JobCreateParameters.  # noqa: E501
        :type: list[LanguagePair]
        """
        if self.local_vars_configuration.client_side_validation and language_pairs is None:  # noqa: E501
            raise ValueError("Invalid value for `language_pairs`, must not be `None`")  # noqa: E501

        self._language_pairs = language_pairs

    @property
    def file_ids(self):
        """Gets the file_ids of this JobCreateParameters.  # noqa: E501

        A list of file ids to upload to job creation.  # noqa: E501

        :return: The file_ids of this JobCreateParameters.  # noqa: E501
        :rtype: list[int]
        """
        return self._file_ids

    @file_ids.setter
    def file_ids(self, file_ids):
        """Sets the file_ids of this JobCreateParameters.

        A list of file ids to upload to job creation.  # noqa: E501

        :param file_ids: The file_ids of this JobCreateParameters.  # noqa: E501
        :type: list[int]
        """
        if self.local_vars_configuration.client_side_validation and file_ids is None:  # noqa: E501
            raise ValueError("Invalid value for `file_ids`, must not be `None`")  # noqa: E501

        self._file_ids = file_ids

    @property
    def due(self):
        """Gets the due of this JobCreateParameters.  # noqa: E501

        An ISO string date representing job due date.  # noqa: E501

        :return: The due of this JobCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._due

    @due.setter
    def due(self, due):
        """Sets the due of this JobCreateParameters.

        An ISO string date representing job due date.  # noqa: E501

        :param due: The due of this JobCreateParameters.  # noqa: E501
        :type: str
        """

        self._due = due

    @property
    def workflow_template_id(self):
        """Gets the workflow_template_id of this JobCreateParameters.  # noqa: E501

        Identifier of the workflow template to be used when creating a job. If not passed the organization default will be used.  # noqa: E501

        :return: The workflow_template_id of this JobCreateParameters.  # noqa: E501
        :rtype: int
        """
        return self._workflow_template_id

    @workflow_template_id.setter
    def workflow_template_id(self, workflow_template_id):
        """Sets the workflow_template_id of this JobCreateParameters.

        Identifier of the workflow template to be used when creating a job. If not passed the organization default will be used.  # noqa: E501

        :param workflow_template_id: The workflow_template_id of this JobCreateParameters.  # noqa: E501
        :type: int
        """

        self._workflow_template_id = workflow_template_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobCreateParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobCreateParameters):
            return True

        return self.to_dict() != other.to_dict()
