# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class MemoryCreateParameters(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'srclang': 'str',
        'trglang': 'str',
        'srclocale': 'str',
        'trglocale': 'str'
    }

    attribute_map = {
        'name': 'name',
        'srclang': 'srclang',
        'trglang': 'trglang',
        'srclocale': 'srclocale',
        'trglocale': 'trglocale'
    }

    def __init__(self, name=None, srclang=None, trglang=None, srclocale=None, trglocale=None, local_vars_configuration=None):  # noqa: E501
        """MemoryCreateParameters - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._srclang = None
        self._trglang = None
        self._srclocale = None
        self._trglocale = None
        self.discriminator = None

        self.name = name
        self.srclang = srclang
        self.trglang = trglang
        if srclocale is not None:
            self.srclocale = srclocale
        if trglocale is not None:
            self.trglocale = trglocale

    @property
    def name(self):
        """Gets the name of this MemoryCreateParameters.  # noqa: E501

        A name for the Memory.  # noqa: E501

        :return: The name of this MemoryCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this MemoryCreateParameters.

        A name for the Memory.  # noqa: E501

        :param name: The name of this MemoryCreateParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def srclang(self):
        """Gets the srclang of this MemoryCreateParameters.  # noqa: E501

        An ISO 639-1 language identifier.  # noqa: E501

        :return: The srclang of this MemoryCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._srclang

    @srclang.setter
    def srclang(self, srclang):
        """Sets the srclang of this MemoryCreateParameters.

        An ISO 639-1 language identifier.  # noqa: E501

        :param srclang: The srclang of this MemoryCreateParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and srclang is None:  # noqa: E501
            raise ValueError("Invalid value for `srclang`, must not be `None`")  # noqa: E501

        self._srclang = srclang

    @property
    def trglang(self):
        """Gets the trglang of this MemoryCreateParameters.  # noqa: E501

        An ISO 639-1 language identifier.  # noqa: E501

        :return: The trglang of this MemoryCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._trglang

    @trglang.setter
    def trglang(self, trglang):
        """Sets the trglang of this MemoryCreateParameters.

        An ISO 639-1 language identifier.  # noqa: E501

        :param trglang: The trglang of this MemoryCreateParameters.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and trglang is None:  # noqa: E501
            raise ValueError("Invalid value for `trglang`, must not be `None`")  # noqa: E501

        self._trglang = trglang

    @property
    def srclocale(self):
        """Gets the srclocale of this MemoryCreateParameters.  # noqa: E501

        An ISO 3166-1 region name for language locales  # noqa: E501

        :return: The srclocale of this MemoryCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._srclocale

    @srclocale.setter
    def srclocale(self, srclocale):
        """Sets the srclocale of this MemoryCreateParameters.

        An ISO 3166-1 region name for language locales  # noqa: E501

        :param srclocale: The srclocale of this MemoryCreateParameters.  # noqa: E501
        :type: str
        """

        self._srclocale = srclocale

    @property
    def trglocale(self):
        """Gets the trglocale of this MemoryCreateParameters.  # noqa: E501

        An ISO 3166-1 region name for language locales  # noqa: E501

        :return: The trglocale of this MemoryCreateParameters.  # noqa: E501
        :rtype: str
        """
        return self._trglocale

    @trglocale.setter
    def trglocale(self, trglocale):
        """Sets the trglocale of this MemoryCreateParameters.

        An ISO 3166-1 region name for language locales  # noqa: E501

        :param trglocale: The trglocale of this MemoryCreateParameters.  # noqa: E501
        :type: str
        """

        self._trglocale = trglocale

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MemoryCreateParameters):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, MemoryCreateParameters):
            return True

        return self.to_dict() != other.to_dict()
