# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class Segment(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'created_at': 'int',
        'updated_at': 'int',
        'document_id': 'int',
        'memory_id': 'int',
        'source': 'str',
        'srclang': 'str',
        'target': 'str',
        'trglang': 'str',
        'is_confirmed': 'bool',
        'is_reviewed': 'bool'
    }

    attribute_map = {
        'id': 'id',
        'created_at': 'created_at',
        'updated_at': 'updated_at',
        'document_id': 'document_id',
        'memory_id': 'memory_id',
        'source': 'source',
        'srclang': 'srclang',
        'target': 'target',
        'trglang': 'trglang',
        'is_confirmed': 'is_confirmed',
        'is_reviewed': 'is_reviewed'
    }

    def __init__(self, id=None, created_at=None, updated_at=None, document_id=None, memory_id=None, source=None, srclang=None, target=None, trglang=None, is_confirmed=None, is_reviewed=None, local_vars_configuration=None):  # noqa: E501
        """Segment - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._created_at = None
        self._updated_at = None
        self._document_id = None
        self._memory_id = None
        self._source = None
        self._srclang = None
        self._target = None
        self._trglang = None
        self._is_confirmed = None
        self._is_reviewed = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if created_at is not None:
            self.created_at = created_at
        if updated_at is not None:
            self.updated_at = updated_at
        if document_id is not None:
            self.document_id = document_id
        if memory_id is not None:
            self.memory_id = memory_id
        if source is not None:
            self.source = source
        if srclang is not None:
            self.srclang = srclang
        if target is not None:
            self.target = target
        if trglang is not None:
            self.trglang = trglang
        if is_confirmed is not None:
            self.is_confirmed = is_confirmed
        if is_reviewed is not None:
            self.is_reviewed = is_reviewed

    @property
    def id(self):
        """Gets the id of this Segment.  # noqa: E501

        A unique number identifying the Segment.  # noqa: E501

        :return: The id of this Segment.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Segment.

        A unique number identifying the Segment.  # noqa: E501

        :param id: The id of this Segment.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def created_at(self):
        """Gets the created_at of this Segment.  # noqa: E501

        Time at which the object was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The created_at of this Segment.  # noqa: E501
        :rtype: int
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Segment.

        Time at which the object was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :param created_at: The created_at of this Segment.  # noqa: E501
        :type: int
        """

        self._created_at = created_at

    @property
    def updated_at(self):
        """Gets the updated_at of this Segment.  # noqa: E501

        Time at which the object was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :return: The updated_at of this Segment.  # noqa: E501
        :rtype: int
        """
        return self._updated_at

    @updated_at.setter
    def updated_at(self, updated_at):
        """Sets the updated_at of this Segment.

        Time at which the object was created. Measured in seconds since the Unix epoch.  # noqa: E501

        :param updated_at: The updated_at of this Segment.  # noqa: E501
        :type: int
        """

        self._updated_at = updated_at

    @property
    def document_id(self):
        """Gets the document_id of this Segment.  # noqa: E501

        A unique Document identifier.  # noqa: E501

        :return: The document_id of this Segment.  # noqa: E501
        :rtype: int
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """Sets the document_id of this Segment.

        A unique Document identifier.  # noqa: E501

        :param document_id: The document_id of this Segment.  # noqa: E501
        :type: int
        """

        self._document_id = document_id

    @property
    def memory_id(self):
        """Gets the memory_id of this Segment.  # noqa: E501

        The Memory with which this Segment is associated.  # noqa: E501

        :return: The memory_id of this Segment.  # noqa: E501
        :rtype: int
        """
        return self._memory_id

    @memory_id.setter
    def memory_id(self, memory_id):
        """Sets the memory_id of this Segment.

        The Memory with which this Segment is associated.  # noqa: E501

        :param memory_id: The memory_id of this Segment.  # noqa: E501
        :type: int
        """

        self._memory_id = memory_id

    @property
    def source(self):
        """Gets the source of this Segment.  # noqa: E501

        The source string.  # noqa: E501

        :return: The source of this Segment.  # noqa: E501
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """Sets the source of this Segment.

        The source string.  # noqa: E501

        :param source: The source of this Segment.  # noqa: E501
        :type: str
        """

        self._source = source

    @property
    def srclang(self):
        """Gets the srclang of this Segment.  # noqa: E501

        An ISO 639-1 language code.  # noqa: E501

        :return: The srclang of this Segment.  # noqa: E501
        :rtype: str
        """
        return self._srclang

    @srclang.setter
    def srclang(self, srclang):
        """Sets the srclang of this Segment.

        An ISO 639-1 language code.  # noqa: E501

        :param srclang: The srclang of this Segment.  # noqa: E501
        :type: str
        """

        self._srclang = srclang

    @property
    def target(self):
        """Gets the target of this Segment.  # noqa: E501

        The target string.  # noqa: E501

        :return: The target of this Segment.  # noqa: E501
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """Sets the target of this Segment.

        The target string.  # noqa: E501

        :param target: The target of this Segment.  # noqa: E501
        :type: str
        """

        self._target = target

    @property
    def trglang(self):
        """Gets the trglang of this Segment.  # noqa: E501

        An ISO 639-1 language code.  # noqa: E501

        :return: The trglang of this Segment.  # noqa: E501
        :rtype: str
        """
        return self._trglang

    @trglang.setter
    def trglang(self, trglang):
        """Sets the trglang of this Segment.

        An ISO 639-1 language code.  # noqa: E501

        :param trglang: The trglang of this Segment.  # noqa: E501
        :type: str
        """

        self._trglang = trglang

    @property
    def is_confirmed(self):
        """Gets the is_confirmed of this Segment.  # noqa: E501

        The confirmation status.  # noqa: E501

        :return: The is_confirmed of this Segment.  # noqa: E501
        :rtype: bool
        """
        return self._is_confirmed

    @is_confirmed.setter
    def is_confirmed(self, is_confirmed):
        """Sets the is_confirmed of this Segment.

        The confirmation status.  # noqa: E501

        :param is_confirmed: The is_confirmed of this Segment.  # noqa: E501
        :type: bool
        """

        self._is_confirmed = is_confirmed

    @property
    def is_reviewed(self):
        """Gets the is_reviewed of this Segment.  # noqa: E501

        The review status.  # noqa: E501

        :return: The is_reviewed of this Segment.  # noqa: E501
        :rtype: bool
        """
        return self._is_reviewed

    @is_reviewed.setter
    def is_reviewed(self, is_reviewed):
        """Sets the is_reviewed of this Segment.

        The review status.  # noqa: E501

        :param is_reviewed: The is_reviewed of this Segment.  # noqa: E501
        :type: bool
        """

        self._is_reviewed = is_reviewed

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Segment):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Segment):
            return True

        return self.to_dict() != other.to_dict()
