# lilt-python
Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals   
The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:
  * Training of and translating with interactive, adaptive machine translation
  * Large-scale translation memory
  * The Lexicon (a large-scale termbase)
  * Programmatic control of the Lilt CAT environment
  * Translation memory synchronization

Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests. 
The base url for this REST API is `https://api.lilt.com/`.

## Authentication

Requests are authenticated via REST API key, which requires the Business plan.

Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.

For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.

## Quotas

Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3.0
- Package version: 3.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/lilt/lilt-python.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/lilt/lilt-python.git`)

Then import the package:
```python
import lilt
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import lilt
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import lilt
from lilt.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://api.lilt.com
# See configuration.py for a list of all supported configuration parameters.
configuration = lilt.Configuration(
    host = "https://api.lilt.com"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKeyAuth
configuration = lilt.Configuration(
    host = "https://api.lilt.com",
    api_key = {
        'key': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['key'] = 'Bearer'

# Configure HTTP basic authorization: BasicAuth
configuration = lilt.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)


# Enter a context with an instance of the API client
with lilt.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = lilt.CreateApi(api_client)
    content_id = 56 # int | The content ID.

    try:
        # Delete Lilt Create content
        api_response = api_instance.delete_lilt_create_content(content_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling CreateApi->delete_lilt_create_content: %s\n" % e)
    
```

## Checking Credentials

If you would like to test your credentials using our functionality tests you can do the following. Run: 

```sh
pip show lilt-python
```

Navigate to the Location field and create a .env file inside the package using .env_example as a template. Fill out the API_HOST and API_KEY lines using the credentials you were given.

Then while inside the package folder, run:

```sh
pip install -r test-requirements.txt
```

Followed by:

```sh
local_test
```

You should be able to see the tests run.


## Documentation for API Endpoints

All URIs are relative to *https://api.lilt.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CreateApi* | [**delete_lilt_create_content**](docs/CreateApi.md#delete_lilt_create_content) | **DELETE** /v2/create/{contentId} | Delete Lilt Create content
*CreateApi* | [**generate_lilt_create_content**](docs/CreateApi.md#generate_lilt_create_content) | **POST** /v2/create | Generate new Lilt Create content
*CreateApi* | [**get_lilt_create_by_id**](docs/CreateApi.md#get_lilt_create_by_id) | **GET** /v2/create/{contentId} | Get Lilt Create content by ID.
*CreateApi* | [**get_lilt_create_content**](docs/CreateApi.md#get_lilt_create_content) | **GET** /v2/create | Get Lilt Create content
*CreateApi* | [**get_lilt_create_preferences**](docs/CreateApi.md#get_lilt_create_preferences) | **GET** /v2/create/preferences | Get Lilt Create preferences
*CreateApi* | [**regenerate_lilt_create_content**](docs/CreateApi.md#regenerate_lilt_create_content) | **GET** /v2/create/{contentId}/create | Regenerate Lilt Create content
*CreateApi* | [**sign_lilt_create_terms**](docs/CreateApi.md#sign_lilt_create_terms) | **POST** /v2/create/terms-and-conditions | Sign the Lilt Create terms and conditions
*CreateApi* | [**update_lilt_create_content**](docs/CreateApi.md#update_lilt_create_content) | **PUT** /v2/create/{contentId} | Update Lilt Create content
*CreateApi* | [**update_lilt_create_preferences**](docs/CreateApi.md#update_lilt_create_preferences) | **PUT** /v2/create/preferences | Update Lilt Create preferences
*DocumentsApi* | [**download_document**](docs/DocumentsApi.md#download_document) | **GET** /v2/documents/files | Download a Document
*DocumentsApi* | [**upload_document**](docs/DocumentsApi.md#upload_document) | **POST** /v2/documents/files | Upload a File
*FilesApi* | [**add_label**](docs/FilesApi.md#add_label) | **POST** /v2/files/labels | Add Label to File
*FilesApi* | [**delete_file**](docs/FilesApi.md#delete_file) | **DELETE** /v2/files | Delete a File
*FilesApi* | [**download**](docs/FilesApi.md#download) | **GET** /v2/files/download | Download file
*FilesApi* | [**get_files**](docs/FilesApi.md#get_files) | **GET** /v2/files | Retrieve a File
*FilesApi* | [**remove_label**](docs/FilesApi.md#remove_label) | **DELETE** /v2/files/labels | Remove Label from File
*FilesApi* | [**upload_file**](docs/FilesApi.md#upload_file) | **POST** /v2/files | Upload a File
*JobsApi* | [**archive_job**](docs/JobsApi.md#archive_job) | **POST** /v2/jobs/{jobId}/archive | Archive a Job
*JobsApi* | [**create_job**](docs/JobsApi.md#create_job) | **POST** /v2/jobs | Create a Job
*JobsApi* | [**delete_job**](docs/JobsApi.md#delete_job) | **DELETE** /v2/jobs/{jobId} | Delete a Job
*JobsApi* | [**deliver_job**](docs/JobsApi.md#deliver_job) | **POST** /v2/jobs/{jobId}/deliver | Deliver a Job
*JobsApi* | [**download_job**](docs/JobsApi.md#download_job) | **GET** /v2/jobs/{jobId}/download | Download a Job
*JobsApi* | [**export_job**](docs/JobsApi.md#export_job) | **GET** /v2/jobs/{jobId}/export | Export a Job
*JobsApi* | [**get_job**](docs/JobsApi.md#get_job) | **GET** /v2/jobs/{jobId} | Retrieve a Job
*JobsApi* | [**get_job_leverage_stats**](docs/JobsApi.md#get_job_leverage_stats) | **POST** /v2/jobs/{jobId}/stats | Retrieve Job Leverage Stats
*JobsApi* | [**reactivate_job**](docs/JobsApi.md#reactivate_job) | **POST** /v2/jobs/{jobId}/reactivate | Reactivate a Job
*JobsApi* | [**retrieve_all_jobs**](docs/JobsApi.md#retrieve_all_jobs) | **GET** /v2/jobs | Retrieve all Jobs
*JobsApi* | [**unarchive_job**](docs/JobsApi.md#unarchive_job) | **POST** /v2/jobs/{jobId}/unarchive | Unarchive a Job
*JobsApi* | [**update_job**](docs/JobsApi.md#update_job) | **PUT** /v2/jobs/{jobId} | Update a Job
*LanguagesApi* | [**get_languages**](docs/LanguagesApi.md#get_languages) | **GET** /v2/languages | Retrieve supported languages
*MemoriesApi* | [**create_memory**](docs/MemoriesApi.md#create_memory) | **POST** /v2/memories | Create a Memory
*MemoriesApi* | [**delete_memory**](docs/MemoriesApi.md#delete_memory) | **DELETE** /v2/memories | Delete a Memory
*MemoriesApi* | [**delete_segment_from_memory**](docs/MemoriesApi.md#delete_segment_from_memory) | **DELETE** /v2/memories/segment | Delete a segment from a memory.
*MemoriesApi* | [**download_termbase**](docs/MemoriesApi.md#download_termbase) | **GET** /v2/memories/termbase/download | Termbase download for a Memory
*MemoriesApi* | [**export_termbase**](docs/MemoriesApi.md#export_termbase) | **POST** /v2/memories/termbase/export | Termbase export for a Memory
*MemoriesApi* | [**get_memory**](docs/MemoriesApi.md#get_memory) | **GET** /v2/memories | Retrieve a Memory
*MemoriesApi* | [**import_memory_file**](docs/MemoriesApi.md#import_memory_file) | **POST** /v2/memories/import | File import for a Memory
*MemoriesApi* | [**query_memory**](docs/MemoriesApi.md#query_memory) | **GET** /v2/memories/query | Query a Memory
*MemoriesApi* | [**update_memory**](docs/MemoriesApi.md#update_memory) | **PUT** /v2/memories | Update the name of a Memory
*ProjectsApi* | [**create_project**](docs/ProjectsApi.md#create_project) | **POST** /v2/projects | Create a Project
*ProjectsApi* | [**delete_project**](docs/ProjectsApi.md#delete_project) | **DELETE** /v2/projects | Delete a Project
*ProjectsApi* | [**get_projects**](docs/ProjectsApi.md#get_projects) | **GET** /v2/projects | Retrieve a Project
*TranslateApi* | [**batch_translate_file**](docs/TranslateApi.md#batch_translate_file) | **POST** /v2/translate/file | Translate a File
*TranslateApi* | [**download_file**](docs/TranslateApi.md#download_file) | **GET** /v2/translate/files | Download translated file
*TranslateApi* | [**monitor_file_translation**](docs/TranslateApi.md#monitor_file_translation) | **GET** /v2/translate/file | Monitor file translation
*TranslateApi* | [**translate_segment_post**](docs/TranslateApi.md#translate_segment_post) | **POST** /v2/translate | Translate a segment
*WorkflowsApi* | [**get_workflow_templates**](docs/WorkflowsApi.md#get_workflow_templates) | **GET** /v2/workflows/templates | Retrieve workflow templates


## Documentation For Models

 - [AddFileLabelRequest](docs/AddFileLabelRequest.md)
 - [CreateConverterConfigParameters](docs/CreateConverterConfigParameters.md)
 - [DeleteSegmentFromMemoryResponse](docs/DeleteSegmentFromMemoryResponse.md)
 - [DocumentWithSegments](docs/DocumentWithSegments.md)
 - [DocumentWithoutSegments](docs/DocumentWithoutSegments.md)
 - [DocumentWithoutSegmentsStatus](docs/DocumentWithoutSegmentsStatus.md)
 - [Error](docs/Error.md)
 - [FileDeleteResponse](docs/FileDeleteResponse.md)
 - [GetLiltCreateContentResponse](docs/GetLiltCreateContentResponse.md)
 - [InlineResponse200](docs/InlineResponse200.md)
 - [Job](docs/Job.md)
 - [JobCreateParameters](docs/JobCreateParameters.md)
 - [JobDeleteResponse](docs/JobDeleteResponse.md)
 - [JobLeverageStats](docs/JobLeverageStats.md)
 - [JobProject](docs/JobProject.md)
 - [JobStats](docs/JobStats.md)
 - [JobUpdateParameters](docs/JobUpdateParameters.md)
 - [LanguagePair](docs/LanguagePair.md)
 - [LanguagesResponse](docs/LanguagesResponse.md)
 - [LiltCreateContent](docs/LiltCreateContent.md)
 - [LiltCreateContentPreferences](docs/LiltCreateContentPreferences.md)
 - [LiltCreateContentRequest](docs/LiltCreateContentRequest.md)
 - [LiltCreateContentTemplateParams](docs/LiltCreateContentTemplateParams.md)
 - [Memory](docs/Memory.md)
 - [MemoryCreateParameters](docs/MemoryCreateParameters.md)
 - [MemoryDeleteResponse](docs/MemoryDeleteResponse.md)
 - [MemoryImportResponse](docs/MemoryImportResponse.md)
 - [MemoryUpdateParameters](docs/MemoryUpdateParameters.md)
 - [Project](docs/Project.md)
 - [ProjectCreateParameters](docs/ProjectCreateParameters.md)
 - [ProjectDeleteResponse](docs/ProjectDeleteResponse.md)
 - [ProjectStats](docs/ProjectStats.md)
 - [SDLXLIFFFilter](docs/SDLXLIFFFilter.md)
 - [Segment](docs/Segment.md)
 - [SignLiltCreateTermsResponse](docs/SignLiltCreateTermsResponse.md)
 - [SourceFile](docs/SourceFile.md)
 - [TermbaseExportResponse](docs/TermbaseExportResponse.md)
 - [TranslateSegmentBody](docs/TranslateSegmentBody.md)
 - [Translation](docs/Translation.md)
 - [TranslationInfo](docs/TranslationInfo.md)
 - [TranslationList](docs/TranslationList.md)
 - [TranslationMemoryEntry](docs/TranslationMemoryEntry.md)
 - [WorkflowStageAssignment](docs/WorkflowStageAssignment.md)
 - [WorkflowStageTemplate](docs/WorkflowStageTemplate.md)
 - [WorkflowTemplate](docs/WorkflowTemplate.md)


## Documentation For Authorization


## ApiKeyAuth

- **Type**: API key
- **API key parameter name**: key
- **Location**: URL query string


## BasicAuth

- **Type**: HTTP basic authentication


## Author




