# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v3.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lilt.api_client import ApiClient
from lilt.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CreateApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_lilt_create_content(self, content_id, **kwargs):  # noqa: E501
        """Delete Lilt Create content  # noqa: E501

        Delete a piece of Lilt Create content.  Example CURL: ```bash curl -X DELETE 'https://api.lilt.com/v2/create/1234?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_lilt_create_content(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponse200
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_lilt_create_content_with_http_info(content_id, **kwargs)  # noqa: E501

    def delete_lilt_create_content_with_http_info(self, content_id, **kwargs):  # noqa: E501
        """Delete Lilt Create content  # noqa: E501

        Delete a piece of Lilt Create content.  Example CURL: ```bash curl -X DELETE 'https://api.lilt.com/v2/create/1234?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_lilt_create_content_with_http_info(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponse200, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_lilt_create_content" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'content_id' is set
        if self.api_client.client_side_validation and ('content_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_id` when calling `delete_lilt_create_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'content_id' in local_var_params:
            path_params['contentId'] = local_var_params['content_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/octet-stream', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create/{contentId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse200',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def generate_lilt_create_content(self, template_params, **kwargs):  # noqa: E501
        """Generate new Lilt Create content  # noqa: E501

        Generate new Lilt Create content with the given parameters.  Example CURL: ```bash curl -X POST 'https://api.lilt.com/v2/create?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{   \"language\":\"en-US\",   \"template\":\"blog-post\",   \"templateParams\":{     \"contentLength\":\"100\",     \"language\":\"en-US\",     \"sections\":[],     \"summary\":\"a blog post about hiking\"     },   \"preferences\":{\"tone\":\"formal\",\"styleguide\":\"\"} }' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_lilt_create_content(template_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LiltCreateContentRequest template_params: Input parameters that determine what content will be generated.  (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.generate_lilt_create_content_with_http_info(template_params, **kwargs)  # noqa: E501

    def generate_lilt_create_content_with_http_info(self, template_params, **kwargs):  # noqa: E501
        """Generate new Lilt Create content  # noqa: E501

        Generate new Lilt Create content with the given parameters.  Example CURL: ```bash curl -X POST 'https://api.lilt.com/v2/create?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{   \"language\":\"en-US\",   \"template\":\"blog-post\",   \"templateParams\":{     \"contentLength\":\"100\",     \"language\":\"en-US\",     \"sections\":[],     \"summary\":\"a blog post about hiking\"     },   \"preferences\":{\"tone\":\"formal\",\"styleguide\":\"\"} }' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.generate_lilt_create_content_with_http_info(template_params, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LiltCreateContentRequest template_params: Input parameters that determine what content will be generated.  (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'template_params'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method generate_lilt_create_content" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'template_params' is set
        if self.api_client.client_side_validation and ('template_params' not in local_var_params or  # noqa: E501
                                                        local_var_params['template_params'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `template_params` when calling `generate_lilt_create_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'template_params' in local_var_params:
            body_params = local_var_params['template_params']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'text/plain', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_lilt_create_by_id(self, content_id, **kwargs):  # noqa: E501
        """Get Lilt Create content by ID.  # noqa: E501

        Get Lilt Create content by ID.  Example CURL: ```bash curl -X GET 'https://api.lilt.com/v2/create/1234?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lilt_create_by_id(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LiltCreateContent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_lilt_create_by_id_with_http_info(content_id, **kwargs)  # noqa: E501

    def get_lilt_create_by_id_with_http_info(self, content_id, **kwargs):  # noqa: E501
        """Get Lilt Create content by ID.  # noqa: E501

        Get Lilt Create content by ID.  Example CURL: ```bash curl -X GET 'https://api.lilt.com/v2/create/1234?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lilt_create_by_id_with_http_info(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LiltCreateContent, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lilt_create_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'content_id' is set
        if self.api_client.client_side_validation and ('content_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_id` when calling `get_lilt_create_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'content_id' in local_var_params:
            path_params['contentId'] = local_var_params['content_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/octet-stream', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create/{contentId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LiltCreateContent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_lilt_create_content(self, **kwargs):  # noqa: E501
        """Get Lilt Create content  # noqa: E501

        Get a list of all content that has been generated by Lilt Create.  Example CURL: ```bash curl -X GET 'https://api.lilt.com/v2/create?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lilt_create_content(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: GetLiltCreateContentResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_lilt_create_content_with_http_info(**kwargs)  # noqa: E501

    def get_lilt_create_content_with_http_info(self, **kwargs):  # noqa: E501
        """Get Lilt Create content  # noqa: E501

        Get a list of all content that has been generated by Lilt Create.  Example CURL: ```bash curl -X GET 'https://api.lilt.com/v2/create?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lilt_create_content_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(GetLiltCreateContentResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lilt_create_content" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/octet-stream', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='GetLiltCreateContentResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_lilt_create_preferences(self, **kwargs):  # noqa: E501
        """Get Lilt Create preferences  # noqa: E501

        Get the stored preferences for Lilt Create.  Example CURL: ```bash curl -X POST 'https://api.lilt.com/v2/create/preferences?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lilt_create_preferences(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_lilt_create_preferences_with_http_info(**kwargs)  # noqa: E501

    def get_lilt_create_preferences_with_http_info(self, **kwargs):  # noqa: E501
        """Get Lilt Create preferences  # noqa: E501

        Get the stored preferences for Lilt Create.  Example CURL: ```bash curl -X POST 'https://api.lilt.com/v2/create/preferences?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lilt_create_preferences_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lilt_create_preferences" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create/preferences', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def regenerate_lilt_create_content(self, content_id, **kwargs):  # noqa: E501
        """Regenerate Lilt Create content  # noqa: E501

        Regenerate the given piece of content with the current parameters.  Example CURL: ```bash curl -X GET 'https://api.lilt.com/v2/create/1234/create?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.regenerate_lilt_create_content(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.regenerate_lilt_create_content_with_http_info(content_id, **kwargs)  # noqa: E501

    def regenerate_lilt_create_content_with_http_info(self, content_id, **kwargs):  # noqa: E501
        """Regenerate Lilt Create content  # noqa: E501

        Regenerate the given piece of content with the current parameters.  Example CURL: ```bash curl -X GET 'https://api.lilt.com/v2/create/1234/create?key=API_KEY' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.regenerate_lilt_create_content_with_http_info(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method regenerate_lilt_create_content" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'content_id' is set
        if self.api_client.client_side_validation and ('content_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_id` when calling `regenerate_lilt_create_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'content_id' in local_var_params:
            path_params['contentId'] = local_var_params['content_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create/{contentId}/create', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def sign_lilt_create_terms(self, signed_agreement, **kwargs):  # noqa: E501
        """Sign the Lilt Create terms and conditions  # noqa: E501

        Lilt Create requires that the terms and conditions are signed first before using it. The terms and conditions can be signed by using this endpoint.  Example CURL: ```bash curl -X POST 'https://api.lilt.com/v2/create/terms-and-conditions?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{\"signedAgreement\": true}' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sign_lilt_create_terms(signed_agreement, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateConverterConfigParameters signed_agreement: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SignLiltCreateTermsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.sign_lilt_create_terms_with_http_info(signed_agreement, **kwargs)  # noqa: E501

    def sign_lilt_create_terms_with_http_info(self, signed_agreement, **kwargs):  # noqa: E501
        """Sign the Lilt Create terms and conditions  # noqa: E501

        Lilt Create requires that the terms and conditions are signed first before using it. The terms and conditions can be signed by using this endpoint.  Example CURL: ```bash curl -X POST 'https://api.lilt.com/v2/create/terms-and-conditions?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{\"signedAgreement\": true}' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.sign_lilt_create_terms_with_http_info(signed_agreement, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CreateConverterConfigParameters signed_agreement: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SignLiltCreateTermsResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'signed_agreement'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method sign_lilt_create_terms" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'signed_agreement' is set
        if self.api_client.client_side_validation and ('signed_agreement' not in local_var_params or  # noqa: E501
                                                        local_var_params['signed_agreement'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `signed_agreement` when calling `sign_lilt_create_terms`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'signed_agreement' in local_var_params:
            body_params = local_var_params['signed_agreement']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/octet-stream', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create/terms-and-conditions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SignLiltCreateTermsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_lilt_create_content(self, content_id, **kwargs):  # noqa: E501
        """Update Lilt Create content  # noqa: E501

        Update a piece of Lilt Create content.  Example CURL: ```bash curl -X PUT 'https://api.lilt.com/v2/create/1234?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{\"language\":\"de-DE\"}' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lilt_create_content(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param LiltCreateContent body:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LiltCreateContent
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_lilt_create_content_with_http_info(content_id, **kwargs)  # noqa: E501

    def update_lilt_create_content_with_http_info(self, content_id, **kwargs):  # noqa: E501
        """Update Lilt Create content  # noqa: E501

        Update a piece of Lilt Create content.  Example CURL: ```bash curl -X PUT 'https://api.lilt.com/v2/create/1234?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{\"language\":\"de-DE\"}' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lilt_create_content_with_http_info(content_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int content_id: The content ID. (required)
        :param LiltCreateContent body:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LiltCreateContent, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'content_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lilt_create_content" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'content_id' is set
        if self.api_client.client_side_validation and ('content_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['content_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `content_id` when calling `update_lilt_create_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'content_id' in local_var_params:
            path_params['contentId'] = local_var_params['content_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/octet-stream', 'text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create/{contentId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LiltCreateContent',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_lilt_create_preferences(self, **kwargs):  # noqa: E501
        """Update Lilt Create preferences  # noqa: E501

        Update the stored preferences for Lilt Create.  Example CURL: ```bash curl -X PUT 'https://api.lilt.com/v2/create/preferences?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{\"tone\": \"formal\", \"styleguide\": \"\"}' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lilt_create_preferences(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LiltCreateContent styleguide: Which styleguide to use.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_lilt_create_preferences_with_http_info(**kwargs)  # noqa: E501

    def update_lilt_create_preferences_with_http_info(self, **kwargs):  # noqa: E501
        """Update Lilt Create preferences  # noqa: E501

        Update the stored preferences for Lilt Create.  Example CURL: ```bash curl -X PUT 'https://api.lilt.com/v2/create/preferences?key=API_KEY' \\ --header 'Content-Type: application/json' \\ --data-raw '{\"tone\": \"formal\", \"styleguide\": \"\"}' ```    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_lilt_create_preferences_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param LiltCreateContent styleguide: Which styleguide to use.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'styleguide'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_lilt_create_preferences" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'styleguide' in local_var_params:
            body_params = local_var_params['styleguide']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', 'text/plain', 'application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/v2/create/preferences', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
