# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class AutoAssignmentResponse(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'project_id': 'float',
        'success': 'bool',
        'error': 'str',
        'errors': 'list[AssignmentError]',
        'assignments': 'list[AssignmentDetails]'
    }

    attribute_map = {
        'project_id': 'projectId',
        'success': 'success',
        'error': 'error',
        'errors': 'errors',
        'assignments': 'assignments'
    }

    def __init__(self, project_id=None, success=None, error=None, errors=None, assignments=None, local_vars_configuration=None):  # noqa: E501
        """AutoAssignmentResponse - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._project_id = None
        self._success = None
        self._error = None
        self._errors = None
        self._assignments = None
        self.discriminator = None

        self.project_id = project_id
        self.success = success
        if error is not None:
            self.error = error
        if errors is not None:
            self.errors = errors
        if assignments is not None:
            self.assignments = assignments

    @property
    def project_id(self):
        """Gets the project_id of this AutoAssignmentResponse.  # noqa: E501

        The id of the project.  # noqa: E501

        :return: The project_id of this AutoAssignmentResponse.  # noqa: E501
        :rtype: float
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """Sets the project_id of this AutoAssignmentResponse.

        The id of the project.  # noqa: E501

        :param project_id: The project_id of this AutoAssignmentResponse.  # noqa: E501
        :type: float
        """
        if self.local_vars_configuration.client_side_validation and project_id is None:  # noqa: E501
            raise ValueError("Invalid value for `project_id`, must not be `None`")  # noqa: E501

        self._project_id = project_id

    @property
    def success(self):
        """Gets the success of this AutoAssignmentResponse.  # noqa: E501

        True if the operation was successful for this project.  # noqa: E501

        :return: The success of this AutoAssignmentResponse.  # noqa: E501
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this AutoAssignmentResponse.

        True if the operation was successful for this project.  # noqa: E501

        :param success: The success of this AutoAssignmentResponse.  # noqa: E501
        :type: bool
        """
        if self.local_vars_configuration.client_side_validation and success is None:  # noqa: E501
            raise ValueError("Invalid value for `success`, must not be `None`")  # noqa: E501

        self._success = success

    @property
    def error(self):
        """Gets the error of this AutoAssignmentResponse.  # noqa: E501

        An optional error message if success = false  # noqa: E501

        :return: The error of this AutoAssignmentResponse.  # noqa: E501
        :rtype: str
        """
        return self._error

    @error.setter
    def error(self, error):
        """Sets the error of this AutoAssignmentResponse.

        An optional error message if success = false  # noqa: E501

        :param error: The error of this AutoAssignmentResponse.  # noqa: E501
        :type: str
        """

        self._error = error

    @property
    def errors(self):
        """Gets the errors of this AutoAssignmentResponse.  # noqa: E501

        A list of errors if there were any.  # noqa: E501

        :return: The errors of this AutoAssignmentResponse.  # noqa: E501
        :rtype: list[AssignmentError]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this AutoAssignmentResponse.

        A list of errors if there were any.  # noqa: E501

        :param errors: The errors of this AutoAssignmentResponse.  # noqa: E501
        :type: list[AssignmentError]
        """

        self._errors = errors

    @property
    def assignments(self):
        """Gets the assignments of this AutoAssignmentResponse.  # noqa: E501

        Assignment details, like which user was assigned and which role.  # noqa: E501

        :return: The assignments of this AutoAssignmentResponse.  # noqa: E501
        :rtype: list[AssignmentDetails]
        """
        return self._assignments

    @assignments.setter
    def assignments(self, assignments):
        """Sets the assignments of this AutoAssignmentResponse.

        Assignment details, like which user was assigned and which role.  # noqa: E501

        :param assignments: The assignments of this AutoAssignmentResponse.  # noqa: E501
        :type: list[AssignmentDetails]
        """

        self._assignments = assignments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AutoAssignmentResponse):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, AutoAssignmentResponse):
            return True

        return self.to_dict() != other.to_dict()
