# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class DocumentWorkflow(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'document_id': 'int',
        'workflow_id': 'int',
        'stages': 'list[WorkflowStage]',
        'current_task': 'WorkflowTask'
    }

    attribute_map = {
        'document_id': 'documentId',
        'workflow_id': 'workflowId',
        'stages': 'stages',
        'current_task': 'currentTask'
    }

    def __init__(self, document_id=None, workflow_id=None, stages=None, current_task=None, local_vars_configuration=None):  # noqa: E501
        """DocumentWorkflow - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._document_id = None
        self._workflow_id = None
        self._stages = None
        self._current_task = None
        self.discriminator = None

        if document_id is not None:
            self.document_id = document_id
        if workflow_id is not None:
            self.workflow_id = workflow_id
        if stages is not None:
            self.stages = stages
        if current_task is not None:
            self.current_task = current_task

    @property
    def document_id(self):
        """Gets the document_id of this DocumentWorkflow.  # noqa: E501

        Identifier of a document.  # noqa: E501

        :return: The document_id of this DocumentWorkflow.  # noqa: E501
        :rtype: int
        """
        return self._document_id

    @document_id.setter
    def document_id(self, document_id):
        """Sets the document_id of this DocumentWorkflow.

        Identifier of a document.  # noqa: E501

        :param document_id: The document_id of this DocumentWorkflow.  # noqa: E501
        :type: int
        """

        self._document_id = document_id

    @property
    def workflow_id(self):
        """Gets the workflow_id of this DocumentWorkflow.  # noqa: E501

        Identifier for a Workflow that the document is using.  # noqa: E501

        :return: The workflow_id of this DocumentWorkflow.  # noqa: E501
        :rtype: int
        """
        return self._workflow_id

    @workflow_id.setter
    def workflow_id(self, workflow_id):
        """Sets the workflow_id of this DocumentWorkflow.

        Identifier for a Workflow that the document is using.  # noqa: E501

        :param workflow_id: The workflow_id of this DocumentWorkflow.  # noqa: E501
        :type: int
        """

        self._workflow_id = workflow_id

    @property
    def stages(self):
        """Gets the stages of this DocumentWorkflow.  # noqa: E501

        The stages in the document's workflow.  # noqa: E501

        :return: The stages of this DocumentWorkflow.  # noqa: E501
        :rtype: list[WorkflowStage]
        """
        return self._stages

    @stages.setter
    def stages(self, stages):
        """Sets the stages of this DocumentWorkflow.

        The stages in the document's workflow.  # noqa: E501

        :param stages: The stages of this DocumentWorkflow.  # noqa: E501
        :type: list[WorkflowStage]
        """

        self._stages = stages

    @property
    def current_task(self):
        """Gets the current_task of this DocumentWorkflow.  # noqa: E501


        :return: The current_task of this DocumentWorkflow.  # noqa: E501
        :rtype: WorkflowTask
        """
        return self._current_task

    @current_task.setter
    def current_task(self, current_task):
        """Sets the current_task of this DocumentWorkflow.


        :param current_task: The current_task of this DocumentWorkflow.  # noqa: E501
        :type: WorkflowTask
        """

        self._current_task = current_task

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DocumentWorkflow):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DocumentWorkflow):
            return True

        return self.to_dict() != other.to_dict()
