# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v3.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class LanguagePair(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'trg_lang': 'str',
        'trg_locale': 'str',
        'due_date': 'str',
        'memory_id': 'int',
        'external_model_id': 'int',
        'pretranslate': 'bool',
        'auto_accept': 'bool',
        'case_sensitive': 'bool',
        'take_match_attribution': 'bool',
        'config_id': 'int',
        'workflow_template_id': 'int',
        'workflow_template_name': 'int',
        'workflow_stage_assignments': 'list[WorkflowStageAssignment]'
    }

    attribute_map = {
        'trg_lang': 'trgLang',
        'trg_locale': 'trgLocale',
        'due_date': 'dueDate',
        'memory_id': 'memoryId',
        'external_model_id': 'externalModelId',
        'pretranslate': 'pretranslate',
        'auto_accept': 'autoAccept',
        'case_sensitive': 'caseSensitive',
        'take_match_attribution': 'takeMatchAttribution',
        'config_id': 'configId',
        'workflow_template_id': 'workflowTemplateId',
        'workflow_template_name': 'workflowTemplateName',
        'workflow_stage_assignments': 'workflowStageAssignments'
    }

    def __init__(self, trg_lang=None, trg_locale=None, due_date=None, memory_id=None, external_model_id=None, pretranslate=None, auto_accept=None, case_sensitive=None, take_match_attribution=None, config_id=None, workflow_template_id=None, workflow_template_name=None, workflow_stage_assignments=None, local_vars_configuration=None):  # noqa: E501
        """LanguagePair - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._trg_lang = None
        self._trg_locale = None
        self._due_date = None
        self._memory_id = None
        self._external_model_id = None
        self._pretranslate = None
        self._auto_accept = None
        self._case_sensitive = None
        self._take_match_attribution = None
        self._config_id = None
        self._workflow_template_id = None
        self._workflow_template_name = None
        self._workflow_stage_assignments = None
        self.discriminator = None

        self.trg_lang = trg_lang
        if trg_locale is not None:
            self.trg_locale = trg_locale
        if due_date is not None:
            self.due_date = due_date
        self.memory_id = memory_id
        if external_model_id is not None:
            self.external_model_id = external_model_id
        if pretranslate is not None:
            self.pretranslate = pretranslate
        if auto_accept is not None:
            self.auto_accept = auto_accept
        if case_sensitive is not None:
            self.case_sensitive = case_sensitive
        if take_match_attribution is not None:
            self.take_match_attribution = take_match_attribution
        if config_id is not None:
            self.config_id = config_id
        if workflow_template_id is not None:
            self.workflow_template_id = workflow_template_id
        if workflow_template_name is not None:
            self.workflow_template_name = workflow_template_name
        if workflow_stage_assignments is not None:
            self.workflow_stage_assignments = workflow_stage_assignments

    @property
    def trg_lang(self):
        """Gets the trg_lang of this LanguagePair.  # noqa: E501

        Target language, an ISO 639-1 language identifier.  # noqa: E501

        :return: The trg_lang of this LanguagePair.  # noqa: E501
        :rtype: str
        """
        return self._trg_lang

    @trg_lang.setter
    def trg_lang(self, trg_lang):
        """Sets the trg_lang of this LanguagePair.

        Target language, an ISO 639-1 language identifier.  # noqa: E501

        :param trg_lang: The trg_lang of this LanguagePair.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and trg_lang is None:  # noqa: E501
            raise ValueError("Invalid value for `trg_lang`, must not be `None`")  # noqa: E501

        self._trg_lang = trg_lang

    @property
    def trg_locale(self):
        """Gets the trg_locale of this LanguagePair.  # noqa: E501

        A locale identifier, supported for target language.  # noqa: E501

        :return: The trg_locale of this LanguagePair.  # noqa: E501
        :rtype: str
        """
        return self._trg_locale

    @trg_locale.setter
    def trg_locale(self, trg_locale):
        """Sets the trg_locale of this LanguagePair.

        A locale identifier, supported for target language.  # noqa: E501

        :param trg_locale: The trg_locale of this LanguagePair.  # noqa: E501
        :type: str
        """

        self._trg_locale = trg_locale

    @property
    def due_date(self):
        """Gets the due_date of this LanguagePair.  # noqa: E501

        An ISO date.  # noqa: E501

        :return: The due_date of this LanguagePair.  # noqa: E501
        :rtype: str
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this LanguagePair.

        An ISO date.  # noqa: E501

        :param due_date: The due_date of this LanguagePair.  # noqa: E501
        :type: str
        """

        self._due_date = due_date

    @property
    def memory_id(self):
        """Gets the memory_id of this LanguagePair.  # noqa: E501

        A unique number identifying the associated Memory.  # noqa: E501

        :return: The memory_id of this LanguagePair.  # noqa: E501
        :rtype: int
        """
        return self._memory_id

    @memory_id.setter
    def memory_id(self, memory_id):
        """Sets the memory_id of this LanguagePair.

        A unique number identifying the associated Memory.  # noqa: E501

        :param memory_id: The memory_id of this LanguagePair.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and memory_id is None:  # noqa: E501
            raise ValueError("Invalid value for `memory_id`, must not be `None`")  # noqa: E501

        self._memory_id = memory_id

    @property
    def external_model_id(self):
        """Gets the external_model_id of this LanguagePair.  # noqa: E501

        A unique identifier for working with a third party model in the Lilt Platform  # noqa: E501

        :return: The external_model_id of this LanguagePair.  # noqa: E501
        :rtype: int
        """
        return self._external_model_id

    @external_model_id.setter
    def external_model_id(self, external_model_id):
        """Sets the external_model_id of this LanguagePair.

        A unique identifier for working with a third party model in the Lilt Platform  # noqa: E501

        :param external_model_id: The external_model_id of this LanguagePair.  # noqa: E501
        :type: int
        """

        self._external_model_id = external_model_id

    @property
    def pretranslate(self):
        """Gets the pretranslate of this LanguagePair.  # noqa: E501

        Attribute translation authorship of exact matches to the creator of the document being pretranslated.  # noqa: E501

        :return: The pretranslate of this LanguagePair.  # noqa: E501
        :rtype: bool
        """
        return self._pretranslate

    @pretranslate.setter
    def pretranslate(self, pretranslate):
        """Sets the pretranslate of this LanguagePair.

        Attribute translation authorship of exact matches to the creator of the document being pretranslated.  # noqa: E501

        :param pretranslate: The pretranslate of this LanguagePair.  # noqa: E501
        :type: bool
        """

        self._pretranslate = pretranslate

    @property
    def auto_accept(self):
        """Gets the auto_accept of this LanguagePair.  # noqa: E501

        Accept and lock exact matches.  # noqa: E501

        :return: The auto_accept of this LanguagePair.  # noqa: E501
        :rtype: bool
        """
        return self._auto_accept

    @auto_accept.setter
    def auto_accept(self, auto_accept):
        """Sets the auto_accept of this LanguagePair.

        Accept and lock exact matches.  # noqa: E501

        :param auto_accept: The auto_accept of this LanguagePair.  # noqa: E501
        :type: bool
        """

        self._auto_accept = auto_accept

    @property
    def case_sensitive(self):
        """Gets the case_sensitive of this LanguagePair.  # noqa: E501

        Use case sensitive translation memory matching.  # noqa: E501

        :return: The case_sensitive of this LanguagePair.  # noqa: E501
        :rtype: bool
        """
        return self._case_sensitive

    @case_sensitive.setter
    def case_sensitive(self, case_sensitive):
        """Sets the case_sensitive of this LanguagePair.

        Use case sensitive translation memory matching.  # noqa: E501

        :param case_sensitive: The case_sensitive of this LanguagePair.  # noqa: E501
        :type: bool
        """

        self._case_sensitive = case_sensitive

    @property
    def take_match_attribution(self):
        """Gets the take_match_attribution of this LanguagePair.  # noqa: E501

        Use MT for unmatched segments.  # noqa: E501

        :return: The take_match_attribution of this LanguagePair.  # noqa: E501
        :rtype: bool
        """
        return self._take_match_attribution

    @take_match_attribution.setter
    def take_match_attribution(self, take_match_attribution):
        """Sets the take_match_attribution of this LanguagePair.

        Use MT for unmatched segments.  # noqa: E501

        :param take_match_attribution: The take_match_attribution of this LanguagePair.  # noqa: E501
        :type: bool
        """

        self._take_match_attribution = take_match_attribution

    @property
    def config_id(self):
        """Gets the config_id of this LanguagePair.  # noqa: E501

        Configuration id  # noqa: E501

        :return: The config_id of this LanguagePair.  # noqa: E501
        :rtype: int
        """
        return self._config_id

    @config_id.setter
    def config_id(self, config_id):
        """Sets the config_id of this LanguagePair.

        Configuration id  # noqa: E501

        :param config_id: The config_id of this LanguagePair.  # noqa: E501
        :type: int
        """

        self._config_id = config_id

    @property
    def workflow_template_id(self):
        """Gets the workflow_template_id of this LanguagePair.  # noqa: E501

        Workflow Template id, to assign a specific Workflow to the project created out of this Language Pair. WorkflowTemplateIds can be retrieved via the /workflows/templates endpoint. If not specified then the Job level workflowTemplateId will be used.  # noqa: E501

        :return: The workflow_template_id of this LanguagePair.  # noqa: E501
        :rtype: int
        """
        return self._workflow_template_id

    @workflow_template_id.setter
    def workflow_template_id(self, workflow_template_id):
        """Sets the workflow_template_id of this LanguagePair.

        Workflow Template id, to assign a specific Workflow to the project created out of this Language Pair. WorkflowTemplateIds can be retrieved via the /workflows/templates endpoint. If not specified then the Job level workflowTemplateId will be used.  # noqa: E501

        :param workflow_template_id: The workflow_template_id of this LanguagePair.  # noqa: E501
        :type: int
        """

        self._workflow_template_id = workflow_template_id

    @property
    def workflow_template_name(self):
        """Gets the workflow_template_name of this LanguagePair.  # noqa: E501

        Workflow Template Name, when passed with TeamId it allows for an on the fly look up of the correct WorkflowTemplate to use. If workflowTemplateId is passed the workflowTemplateId supercedes other lookups.  # noqa: E501

        :return: The workflow_template_name of this LanguagePair.  # noqa: E501
        :rtype: int
        """
        return self._workflow_template_name

    @workflow_template_name.setter
    def workflow_template_name(self, workflow_template_name):
        """Sets the workflow_template_name of this LanguagePair.

        Workflow Template Name, when passed with TeamId it allows for an on the fly look up of the correct WorkflowTemplate to use. If workflowTemplateId is passed the workflowTemplateId supercedes other lookups.  # noqa: E501

        :param workflow_template_name: The workflow_template_name of this LanguagePair.  # noqa: E501
        :type: int
        """

        self._workflow_template_name = workflow_template_name

    @property
    def workflow_stage_assignments(self):
        """Gets the workflow_stage_assignments of this LanguagePair.  # noqa: E501


        :return: The workflow_stage_assignments of this LanguagePair.  # noqa: E501
        :rtype: list[WorkflowStageAssignment]
        """
        return self._workflow_stage_assignments

    @workflow_stage_assignments.setter
    def workflow_stage_assignments(self, workflow_stage_assignments):
        """Sets the workflow_stage_assignments of this LanguagePair.


        :param workflow_stage_assignments: The workflow_stage_assignments of this LanguagePair.  # noqa: E501
        :type: list[WorkflowStageAssignment]
        """

        self._workflow_stage_assignments = workflow_stage_assignments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LanguagePair):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LanguagePair):
            return True

        return self.to_dict() != other.to_dict()
