# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v3.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class SDLXLIFFFilter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'conf_name': 'str',
        'allowable_percentage': 'int',
        'allow_unlocked_segments': 'bool'
    }

    attribute_map = {
        'conf_name': 'confName',
        'allowable_percentage': 'allowablePercentage',
        'allow_unlocked_segments': 'allowUnlockedSegments'
    }

    def __init__(self, conf_name=None, allowable_percentage=None, allow_unlocked_segments=None, local_vars_configuration=None):  # noqa: E501
        """SDLXLIFFFilter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._conf_name = None
        self._allowable_percentage = None
        self._allow_unlocked_segments = None
        self.discriminator = None

        self.conf_name = conf_name
        if allowable_percentage is not None:
            self.allowable_percentage = allowable_percentage
        if allow_unlocked_segments is not None:
            self.allow_unlocked_segments = allow_unlocked_segments

    @property
    def conf_name(self):
        """Gets the conf_name of this SDLXLIFFFilter.  # noqa: E501

        the current state of the SDLXLIFF Trans Unit.  # noqa: E501

        :return: The conf_name of this SDLXLIFFFilter.  # noqa: E501
        :rtype: str
        """
        return self._conf_name

    @conf_name.setter
    def conf_name(self, conf_name):
        """Sets the conf_name of this SDLXLIFFFilter.

        the current state of the SDLXLIFF Trans Unit.  # noqa: E501

        :param conf_name: The conf_name of this SDLXLIFFFilter.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and conf_name is None:  # noqa: E501
            raise ValueError("Invalid value for `conf_name`, must not be `None`")  # noqa: E501
        allowed_values = ["Translated", "Draft", "ApprovedTranslation", "Locked", "SignedOff"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and conf_name not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `conf_name` ({0}), must be one of {1}"  # noqa: E501
                .format(conf_name, allowed_values)
            )

        self._conf_name = conf_name

    @property
    def allowable_percentage(self):
        """Gets the allowable_percentage of this SDLXLIFFFilter.  # noqa: E501

        This represents for the current conf_name what percentage the filter applies to.  If you pass -1 it will take any value for this field and won't ignore blank values. If you pass 50, Lilt will only import Segments that have a 50 percent match or better.  # noqa: E501

        :return: The allowable_percentage of this SDLXLIFFFilter.  # noqa: E501
        :rtype: int
        """
        return self._allowable_percentage

    @allowable_percentage.setter
    def allowable_percentage(self, allowable_percentage):
        """Sets the allowable_percentage of this SDLXLIFFFilter.

        This represents for the current conf_name what percentage the filter applies to.  If you pass -1 it will take any value for this field and won't ignore blank values. If you pass 50, Lilt will only import Segments that have a 50 percent match or better.  # noqa: E501

        :param allowable_percentage: The allowable_percentage of this SDLXLIFFFilter.  # noqa: E501
        :type: int
        """

        self._allowable_percentage = allowable_percentage

    @property
    def allow_unlocked_segments(self):
        """Gets the allow_unlocked_segments of this SDLXLIFFFilter.  # noqa: E501

        Boolean that tells Lilt whether we should allow unlocked Segments for this conf_name.  # noqa: E501

        :return: The allow_unlocked_segments of this SDLXLIFFFilter.  # noqa: E501
        :rtype: bool
        """
        return self._allow_unlocked_segments

    @allow_unlocked_segments.setter
    def allow_unlocked_segments(self, allow_unlocked_segments):
        """Sets the allow_unlocked_segments of this SDLXLIFFFilter.

        Boolean that tells Lilt whether we should allow unlocked Segments for this conf_name.  # noqa: E501

        :param allow_unlocked_segments: The allow_unlocked_segments of this SDLXLIFFFilter.  # noqa: E501
        :type: bool
        """

        self._allow_unlocked_segments = allow_unlocked_segments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SDLXLIFFFilter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SDLXLIFFFilter):
            return True

        return self.to_dict() != other.to_dict()
