# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import unittest
import datetime

import lilt
from lilt.models.document_workflow import DocumentWorkflow  # noqa: E501
from lilt.rest import ApiException

class TestDocumentWorkflow(unittest.TestCase):
    """DocumentWorkflow unit test stubs"""

    def setUp(self):
        pass

    def tearDown(self):
        pass

    def make_instance(self, include_optional):
        """Test DocumentWorkflow
            include_option is a boolean, when False only required
            params are included, when True both required and
            optional params are included """
        # model = lilt.models.document_workflow.DocumentWorkflow()  # noqa: E501
        if include_optional :
            return DocumentWorkflow(
                document_id = 12345, 
                workflow_id = 1111, 
                stages = [{"name":"ReadytoStart","assignmentType":"READY_TO_START"},{"id":1,"name":"Translate","assignmentType":"TRANSLATE"},{"id":2,"name":"Review","assignmentType":"REVIEW","active":True},{"id":3,"name":"AnalystReview","assignmentType":"SECONDARY_REVIEW"},{"name":"Done","assignmentType":"DONE"}], 
                current_task = lilt.models.workflow_task.WorkflowTask(
                    id = 1, 
                    workflow_stage_id = 123, 
                    name = 'Review', 
                    entered_at = '2022-09-09T21:33:21.000Z', 
                    started_at = '2022-09-09T21:33:21.000Z', )
            )
        else :
            return DocumentWorkflow(
        )

    def testDocumentWorkflow(self):
        """Test DocumentWorkflow"""
        inst_req_only = self.make_instance(include_optional=False)
        inst_req_and_optional = self.make_instance(include_optional=True)


if __name__ == '__main__':
    unittest.main()
