# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from lilt.api_client import ApiClient
from lilt.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CommentsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_comment(self, document_id, segment_id, body, **kwargs):  # noqa: E501
        """Create a new comment  # noqa: E501

        Create a new comment for the specified Segment ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_comment(document_id, segment_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A unique document identifier. (required)
        :param int segment_id: A unique segment identifier. (required)
        :param CommentBody body: The comment being created (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Comment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_comment_with_http_info(document_id, segment_id, body, **kwargs)  # noqa: E501

    def create_comment_with_http_info(self, document_id, segment_id, body, **kwargs):  # noqa: E501
        """Create a new comment  # noqa: E501

        Create a new comment for the specified Segment ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_comment_with_http_info(document_id, segment_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A unique document identifier. (required)
        :param int segment_id: A unique segment identifier. (required)
        :param CommentBody body: The comment being created (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Comment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_id',
            'segment_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_id' is set
        if self.api_client.client_side_validation and ('document_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_id` when calling `create_comment`")  # noqa: E501
        # verify the required parameter 'segment_id' is set
        if self.api_client.client_side_validation and ('segment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['segment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `segment_id` when calling `create_comment`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `create_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'document_id' in local_var_params and local_var_params['document_id'] is not None:  # noqa: E501
            query_params.append(('document_id', local_var_params['document_id']))  # noqa: E501
        if 'segment_id' in local_var_params and local_var_params['segment_id'] is not None:  # noqa: E501
            query_params.append(('segment_id', local_var_params['segment_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Comment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_comment(self, comment_id, **kwargs):  # noqa: E501
        """Delete a Comment  # noqa: E501

        Delete a Comment.  Example CURL command: ```   curl -X DELETE https://lilt.com/2/comments?key=API_KEY&comment_id=123 ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_comment(comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int comment_id: A unique Comment identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommentDeleteResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_comment_with_http_info(comment_id, **kwargs)  # noqa: E501

    def delete_comment_with_http_info(self, comment_id, **kwargs):  # noqa: E501
        """Delete a Comment  # noqa: E501

        Delete a Comment.  Example CURL command: ```   curl -X DELETE https://lilt.com/2/comments?key=API_KEY&comment_id=123 ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_comment_with_http_info(comment_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int comment_id: A unique Comment identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommentDeleteResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'comment_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'comment_id' is set
        if self.api_client.client_side_validation and ('comment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['comment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `comment_id` when calling `delete_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'comment_id' in local_var_params and local_var_params['comment_id'] is not None:  # noqa: E501
            query_params.append(('comment_id', local_var_params['comment_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/comments', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommentDeleteResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document_comments(self, document_id, **kwargs):  # noqa: E501
        """Retrieve a document's comments by segment  # noqa: E501

        Retrieves all comments associated with a specified document, grouped by their Segment's ID.  To retrieve a document's comments, specify the <strong>document_id</strong> request parameter.  Example CURL command: ```   curl -X GET https://lilt.com/2/comments?key=API_KEY&document_id=123 ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_comments(document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A unique document identifier. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DocumentComments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_document_comments_with_http_info(document_id, **kwargs)  # noqa: E501

    def get_document_comments_with_http_info(self, document_id, **kwargs):  # noqa: E501
        """Retrieve a document's comments by segment  # noqa: E501

        Retrieves all comments associated with a specified document, grouped by their Segment's ID.  To retrieve a document's comments, specify the <strong>document_id</strong> request parameter.  Example CURL command: ```   curl -X GET https://lilt.com/2/comments?key=API_KEY&document_id=123 ```   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_document_comments_with_http_info(document_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int document_id: A unique document identifier. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DocumentComments, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'document_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_comments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'document_id' is set
        if self.api_client.client_side_validation and ('document_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_id` when calling `get_document_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'document_id' in local_var_params and local_var_params['document_id'] is not None:  # noqa: E501
            query_params.append(('document_id', local_var_params['document_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DocumentComments',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_comment(self, comment_id, document_id, body, **kwargs):  # noqa: E501
        """Update an existing comment  # noqa: E501

        Update an existing comment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_comment(comment_id, document_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int comment_id: A unique comment identifier. (required)
        :param int document_id: A unique document identifier. (required)
        :param CommentBody body: The comment being updated. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Comment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_comment_with_http_info(comment_id, document_id, body, **kwargs)  # noqa: E501

    def update_comment_with_http_info(self, comment_id, document_id, body, **kwargs):  # noqa: E501
        """Update an existing comment  # noqa: E501

        Update an existing comment.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_comment_with_http_info(comment_id, document_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int comment_id: A unique comment identifier. (required)
        :param int document_id: A unique document identifier. (required)
        :param CommentBody body: The comment being updated. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Comment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'comment_id',
            'document_id',
            'body'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_comment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'comment_id' is set
        if self.api_client.client_side_validation and ('comment_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['comment_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `comment_id` when calling `update_comment`")  # noqa: E501
        # verify the required parameter 'document_id' is set
        if self.api_client.client_side_validation and ('document_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['document_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `document_id` when calling `update_comment`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in local_var_params or  # noqa: E501
                                                        local_var_params['body'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `body` when calling `update_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'comment_id' in local_var_params and local_var_params['comment_id'] is not None:  # noqa: E501
            query_params.append(('comment_id', local_var_params['comment_id']))  # noqa: E501
        if 'document_id' in local_var_params and local_var_params['document_id'] is not None:  # noqa: E501
            query_params.append(('document_id', local_var_params['document_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in local_var_params:
            body_params = local_var_params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth', 'BasicAuth']  # noqa: E501

        return self.api_client.call_api(
            '/comments', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Comment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
