# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request. 

    The version of the OpenAPI document: v3.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List
from lilt.models.domain_metadata import DomainMetadata
from lilt.models.filter_config import FilterConfig
from lilt.models.model import Model
from typing import Optional, Set
from typing_extensions import Self

class Domain(BaseModel):
    """
    Domain
    """ # noqa: E501
    domain_id: StrictInt = Field(description="The unique identifier for the domain.", alias="domainId")
    domain_name: StrictStr = Field(description="The name of the domain.", alias="domainName")
    models: List[Model] = Field(description="The models associated with the domain.")
    filter_configs: List[FilterConfig] = Field(description="The filter configurations associated with the domain.", alias="filterConfigs")
    domain_metadata: List[DomainMetadata] = Field(description="Metadata associated with the domain.", alias="domainMetadata")
    __properties: ClassVar[List[str]] = ["domainId", "domainName", "models", "filterConfigs", "domainMetadata"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Domain from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in models (list)
        _items = []
        if self.models:
            for _item_models in self.models:
                if _item_models:
                    _items.append(_item_models.to_dict())
            _dict['models'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in filter_configs (list)
        _items = []
        if self.filter_configs:
            for _item_filter_configs in self.filter_configs:
                if _item_filter_configs:
                    _items.append(_item_filter_configs.to_dict())
            _dict['filterConfigs'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in domain_metadata (list)
        _items = []
        if self.domain_metadata:
            for _item_domain_metadata in self.domain_metadata:
                if _item_domain_metadata:
                    _items.append(_item_domain_metadata.to_dict())
            _dict['domainMetadata'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Domain from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "domainId": obj.get("domainId"),
            "domainName": obj.get("domainName"),
            "models": [Model.from_dict(_item) for _item in obj["models"]] if obj.get("models") is not None else None,
            "filterConfigs": [FilterConfig.from_dict(_item) for _item in obj["filterConfigs"]] if obj.get("filterConfigs") is not None else None,
            "domainMetadata": [DomainMetadata.from_dict(_item) for _item in obj["domainMetadata"]] if obj.get("domainMetadata") is not None else None
        })
        return _obj


