# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request. 

    The version of the OpenAPI document: v3.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from lilt.models.domain_reference import DomainReference
from typing import Optional, Set
from typing_extensions import Self

class FilterConfig(BaseModel):
    """
    FilterConfig
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="The unique identifier for the filter configuration.")
    is_default: Optional[StrictBool] = Field(default=None, description="Indicates if the filter configuration is the default.", alias="isDefault")
    filter_config: Optional[StrictStr] = Field(default=None, description="The filter configuration.", alias="filterConfig")
    filter_name: Optional[StrictStr] = Field(default=None, description="The name of the filter.", alias="filterName")
    config_name: Optional[StrictStr] = Field(default=None, description="The name of the configuration.", alias="configName")
    config_description: Optional[StrictStr] = Field(default=None, description="The description of the configuration.", alias="configDescription")
    subfilters: Optional[StrictStr] = Field(default=None, description="The subfilters.")
    segmentation_config_setting: Optional[StrictStr] = Field(default=None, description="The segmentation configuration setting.", alias="segmentationConfigSetting")
    srx: Optional[StrictStr] = Field(default=None, description="The SRX (Segmentation Rules eXchange) data.")
    segmentation_config_name: Optional[StrictStr] = Field(default=None, description="The name of the segmentation configuration.", alias="segmentationConfigName")
    domains: Optional[List[DomainReference]] = Field(default=None, description="The domains associated with the filter configuration.")
    created_at: Optional[datetime] = Field(default=None, description="The creation timestamp.", alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, description="The last update timestamp.", alias="updatedAt")
    default: Optional[StrictBool] = Field(default=None, description="Indicates if the filter configuration is the default.")
    __properties: ClassVar[List[str]] = ["id", "isDefault", "filterConfig", "filterName", "configName", "configDescription", "subfilters", "segmentationConfigSetting", "srx", "segmentationConfigName", "domains", "createdAt", "updatedAt", "default"]

    @field_validator('segmentation_config_setting')
    def segmentation_config_setting_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['SENTENCE']):
            raise ValueError("must be one of enum values ('SENTENCE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FilterConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in domains (list)
        _items = []
        if self.domains:
            for _item_domains in self.domains:
                if _item_domains:
                    _items.append(_item_domains.to_dict())
            _dict['domains'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FilterConfig from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "isDefault": obj.get("isDefault"),
            "filterConfig": obj.get("filterConfig"),
            "filterName": obj.get("filterName"),
            "configName": obj.get("configName"),
            "configDescription": obj.get("configDescription"),
            "subfilters": obj.get("subfilters"),
            "segmentationConfigSetting": obj.get("segmentationConfigSetting"),
            "srx": obj.get("srx"),
            "segmentationConfigName": obj.get("segmentationConfigName"),
            "domains": [DomainReference.from_dict(_item) for _item in obj["domains"]] if obj.get("domains") is not None else None,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "default": obj.get("default")
        })
        return _obj


