# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request. 

    The version of the OpenAPI document: v3.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ProjectCreateParameters(BaseModel):
    """
    ProjectCreateParameters
    """ # noqa: E501
    name: StrictStr = Field(description="A name for the Project.")
    memory_id: StrictInt = Field(description="The Memory to associate with this new Project.")
    job_id: Optional[StrictInt] = Field(default=None, description="The Job to associate with this new Project. If a Job ID is not provided then a new Job will be created to contain the Project. ")
    due_date: Optional[StrictInt] = Field(default=None, description="The due date. Measured in seconds since the Unix epoch.")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="A JSON object of key/value string pairs. Stores custom project information.")
    workflow_template_id: Optional[StrictInt] = Field(default=None, description="The workflow template used to create this project. WorkflowTemplateIds can be retrieved via the /workflows/templates endpoint. If not specified then the organization default workflowTemplateId will be used.", alias="workflowTemplateId")
    workflow_template_name: Optional[StrictStr] = Field(default=None, description="Name of the workflow for the project, if a workflowTemplateId is passed, this field will be ignored.")
    llm_provider: Optional[StrictStr] = Field(default=None, description="The LLM provider to use for the project. Defaults to \"neural\".")
    external_model_id: Optional[StrictInt] = Field(default=None, description="External model ID, if any. Must match the chosen llm_provider.")
    is_plural: Optional[StrictBool] = Field(default=None, description="Whether the documents in this project contain ICU plural forms.")
    require_batch_qa_translator: Optional[StrictBool] = Field(default=None, description="Whether to require batch QA from the translator side.")
    enable_prompt_labeling: Optional[StrictBool] = Field(default=None, description="Whether to enable prompt labeling for the project.")
    job_type: Optional[StrictStr] = Field(default=None, description="(Optional) A specialized job type for advanced features.")
    additional_guidelines: Optional[StrictStr] = Field(default=None, description="(Optional) Additional instructions or guidelines.")
    is_enhanced_human_ai_optimized: Optional[StrictBool] = Field(default=None, description="Whether the project is enhanced with AI optimization.")
    domain_id: Optional[StrictInt] = Field(default=None, description="A domain ID to categorize this project under.", alias="domainId")
    __properties: ClassVar[List[str]] = ["name", "memory_id", "job_id", "due_date", "metadata", "workflowTemplateId", "workflow_template_name", "llm_provider", "external_model_id", "is_plural", "require_batch_qa_translator", "enable_prompt_labeling", "job_type", "additional_guidelines", "is_enhanced_human_ai_optimized", "domainId"]

    @field_validator('job_type')
    def job_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['TRANSLATION', 'PROMPT_RESPONSE']):
            raise ValueError("must be one of enum values ('TRANSLATION', 'PROMPT_RESPONSE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProjectCreateParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProjectCreateParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "memory_id": obj.get("memory_id"),
            "job_id": obj.get("job_id"),
            "due_date": obj.get("due_date"),
            "metadata": obj.get("metadata"),
            "workflowTemplateId": obj.get("workflowTemplateId"),
            "workflow_template_name": obj.get("workflow_template_name"),
            "llm_provider": obj.get("llm_provider"),
            "external_model_id": obj.get("external_model_id"),
            "is_plural": obj.get("is_plural"),
            "require_batch_qa_translator": obj.get("require_batch_qa_translator"),
            "enable_prompt_labeling": obj.get("enable_prompt_labeling"),
            "job_type": obj.get("job_type"),
            "additional_guidelines": obj.get("additional_guidelines"),
            "is_enhanced_human_ai_optimized": obj.get("is_enhanced_human_ai_optimized"),
            "domainId": obj.get("domainId")
        })
        return _obj


