# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class WorkflowStage(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'active': 'bool',
        'assignment_type': 'str'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'active': 'active',
        'assignment_type': 'assignmentType'
    }

    def __init__(self, id=None, name=None, active=None, assignment_type=None, local_vars_configuration=None):  # noqa: E501
        """WorkflowStage - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._active = None
        self._assignment_type = None
        self.discriminator = None

        if id is not None:
            self.id = id
        self.name = name
        if active is not None:
            self.active = active
        self.assignment_type = assignment_type

    @property
    def id(self):
        """Gets the id of this WorkflowStage.  # noqa: E501

        Identifier of the stage.  # noqa: E501

        :return: The id of this WorkflowStage.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WorkflowStage.

        Identifier of the stage.  # noqa: E501

        :param id: The id of this WorkflowStage.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this WorkflowStage.  # noqa: E501

        Name of the stage.  # noqa: E501

        :return: The name of this WorkflowStage.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WorkflowStage.

        Name of the stage.  # noqa: E501

        :param name: The name of this WorkflowStage.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def active(self):
        """Gets the active of this WorkflowStage.  # noqa: E501

        Flag which is set to true when the stage is active for a document.  # noqa: E501

        :return: The active of this WorkflowStage.  # noqa: E501
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """Sets the active of this WorkflowStage.

        Flag which is set to true when the stage is active for a document.  # noqa: E501

        :param active: The active of this WorkflowStage.  # noqa: E501
        :type: bool
        """

        self._active = active

    @property
    def assignment_type(self):
        """Gets the assignment_type of this WorkflowStage.  # noqa: E501

        An enum to represent all possible types of Workflow stage.  # noqa: E501

        :return: The assignment_type of this WorkflowStage.  # noqa: E501
        :rtype: str
        """
        return self._assignment_type

    @assignment_type.setter
    def assignment_type(self, assignment_type):
        """Sets the assignment_type of this WorkflowStage.

        An enum to represent all possible types of Workflow stage.  # noqa: E501

        :param assignment_type: The assignment_type of this WorkflowStage.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and assignment_type is None:  # noqa: E501
            raise ValueError("Invalid value for `assignment_type`, must not be `None`")  # noqa: E501
        allowed_values = ["READY_TO_START", "TRANSLATE", "REVIEW", "SECONDARY_REVIEW", "DONE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and assignment_type not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `assignment_type` ({0}), must be one of {1}"  # noqa: E501
                .format(assignment_type, allowed_values)
            )

        self._assignment_type = assignment_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkflowStage):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkflowStage):
            return True

        return self.to_dict() != other.to_dict()
