# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class WorkflowTask(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'workflow_stage_id': 'int',
        'name': 'str',
        'entered_at': 'str',
        'started_at': 'str'
    }

    attribute_map = {
        'id': 'id',
        'workflow_stage_id': 'workflowStageId',
        'name': 'name',
        'entered_at': 'enteredAt',
        'started_at': 'startedAt'
    }

    def __init__(self, id=None, workflow_stage_id=None, name=None, entered_at=None, started_at=None, local_vars_configuration=None):  # noqa: E501
        """WorkflowTask - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._workflow_stage_id = None
        self._name = None
        self._entered_at = None
        self._started_at = None
        self.discriminator = None

        self.id = id
        self.workflow_stage_id = workflow_stage_id
        self.name = name
        self.entered_at = entered_at
        if started_at is not None:
            self.started_at = started_at

    @property
    def id(self):
        """Gets the id of this WorkflowTask.  # noqa: E501

        Identifier of the current workflow task.  # noqa: E501

        :return: The id of this WorkflowTask.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this WorkflowTask.

        Identifier of the current workflow task.  # noqa: E501

        :param id: The id of this WorkflowTask.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def workflow_stage_id(self):
        """Gets the workflow_stage_id of this WorkflowTask.  # noqa: E501

        Identifier of the current workflow stage.  # noqa: E501

        :return: The workflow_stage_id of this WorkflowTask.  # noqa: E501
        :rtype: int
        """
        return self._workflow_stage_id

    @workflow_stage_id.setter
    def workflow_stage_id(self, workflow_stage_id):
        """Sets the workflow_stage_id of this WorkflowTask.

        Identifier of the current workflow stage.  # noqa: E501

        :param workflow_stage_id: The workflow_stage_id of this WorkflowTask.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and workflow_stage_id is None:  # noqa: E501
            raise ValueError("Invalid value for `workflow_stage_id`, must not be `None`")  # noqa: E501

        self._workflow_stage_id = workflow_stage_id

    @property
    def name(self):
        """Gets the name of this WorkflowTask.  # noqa: E501

        Name of the current workflow stage.  # noqa: E501

        :return: The name of this WorkflowTask.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this WorkflowTask.

        Name of the current workflow stage.  # noqa: E501

        :param name: The name of this WorkflowTask.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def entered_at(self):
        """Gets the entered_at of this WorkflowTask.  # noqa: E501

        Date and time when task was created.  # noqa: E501

        :return: The entered_at of this WorkflowTask.  # noqa: E501
        :rtype: str
        """
        return self._entered_at

    @entered_at.setter
    def entered_at(self, entered_at):
        """Sets the entered_at of this WorkflowTask.

        Date and time when task was created.  # noqa: E501

        :param entered_at: The entered_at of this WorkflowTask.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and entered_at is None:  # noqa: E501
            raise ValueError("Invalid value for `entered_at`, must not be `None`")  # noqa: E501

        self._entered_at = entered_at

    @property
    def started_at(self):
        """Gets the started_at of this WorkflowTask.  # noqa: E501

        Date and time when task was started.  # noqa: E501

        :return: The started_at of this WorkflowTask.  # noqa: E501
        :rtype: str
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this WorkflowTask.

        Date and time when task was started.  # noqa: E501

        :param started_at: The started_at of this WorkflowTask.  # noqa: E501
        :type: str
        """

        self._started_at = started_at

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkflowTask):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkflowTask):
            return True

        return self.to_dict() != other.to_dict()
