# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request. 

    The version of the OpenAPI document: v3.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from lilt.models.document_without_segments_status import DocumentWithoutSegmentsStatus
from lilt.models.segment import Segment
from typing import Optional, Set
from typing_extensions import Self

class DocumentWithSegments(BaseModel):
    """
    A Document is a collection of zero or more Segments. 
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="A unique number identifying the Document.")
    project_id: Optional[StrictInt] = Field(default=None, description="A unique number identifying the Project.")
    srclang: Optional[StrictStr] = Field(default=None, description="An ISO 639-1 language identifier.")
    trglang: Optional[StrictStr] = Field(default=None, description="An ISO 639-1 language identifier.")
    name: Optional[StrictStr] = Field(default=None, description="The document name.")
    import_in_progress: Optional[StrictBool] = Field(default=None, description="True if the document is currently being imported")
    import_succeeded: Optional[StrictBool] = Field(default=None, description="True if the import process succeeded.")
    import_error_message: Optional[StrictStr] = Field(default=None, description="Error message if `import_succeeded=false`")
    export_in_progress: Optional[StrictBool] = Field(default=None, description="True if the document is currently being exported for download")
    export_succeeded: Optional[StrictBool] = Field(default=None, description="True if the export process succeeded.")
    export_error_message: Optional[StrictStr] = Field(default=None, description="Error message if `export_succeeded=false`")
    is_pretranslating: Optional[StrictBool] = Field(default=None, description="True if the document is currently being pretranslated.")
    status: Optional[DocumentWithoutSegmentsStatus] = None
    translator_email: Optional[StrictStr] = Field(default=None, description="The email of the assigned translator.")
    reviewer_email: Optional[StrictStr] = Field(default=None, description="The email of the assigned reviewer.")
    created_at: Optional[StrictInt] = Field(default=None, description="Time at which the object was created. Measured in seconds since the Unix epoch.")
    updated_at: Optional[StrictInt] = Field(default=None, description="Time at which the object was created. Measured in seconds since the Unix epoch.")
    is_review_complete: Optional[StrictBool] = Field(default=None, description="Document review status.")
    segments: Optional[List[Segment]] = Field(default=None, description="A list of Segments.")
    __properties: ClassVar[List[str]] = ["id", "project_id", "srclang", "trglang", "name", "import_in_progress", "import_succeeded", "import_error_message", "export_in_progress", "export_succeeded", "export_error_message", "is_pretranslating", "status", "translator_email", "reviewer_email", "created_at", "updated_at", "is_review_complete", "segments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DocumentWithSegments from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of status
        if self.status:
            _dict['status'] = self.status.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in segments (list)
        _items = []
        if self.segments:
            for _item_segments in self.segments:
                if _item_segments:
                    _items.append(_item_segments.to_dict())
            _dict['segments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DocumentWithSegments from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "project_id": obj.get("project_id"),
            "srclang": obj.get("srclang"),
            "trglang": obj.get("trglang"),
            "name": obj.get("name"),
            "import_in_progress": obj.get("import_in_progress"),
            "import_succeeded": obj.get("import_succeeded"),
            "import_error_message": obj.get("import_error_message"),
            "export_in_progress": obj.get("export_in_progress"),
            "export_succeeded": obj.get("export_succeeded"),
            "export_error_message": obj.get("export_error_message"),
            "is_pretranslating": obj.get("is_pretranslating"),
            "status": DocumentWithoutSegmentsStatus.from_dict(obj["status"]) if obj.get("status") is not None else None,
            "translator_email": obj.get("translator_email"),
            "reviewer_email": obj.get("reviewer_email"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "is_review_complete": obj.get("is_review_complete"),
            "segments": [Segment.from_dict(_item) for _item in obj["segments"]] if obj.get("segments") is not None else None
        })
        return _obj


