# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request. 

    The version of the OpenAPI document: v3.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from lilt.models.language_pair import LanguagePair
from typing import Optional, Set
from typing_extensions import Self

class JobCreateParameters(BaseModel):
    """
    JobCreateParameters
    """ # noqa: E501
    name: StrictStr = Field(description="A name for the Job.")
    language_pairs: List[LanguagePair] = Field(description="Language pairs is a set of one or more pairs that includes source language, source locale(optional), target language, target locale(optional), and memoryId.", alias="languagePairs")
    file_ids: List[StrictInt] = Field(description="A list of file ids to upload to job creation.", alias="fileIds")
    due: Optional[StrictStr] = Field(default=None, description="An ISO string date representing job due date.")
    src_lang: StrictStr = Field(description="2-letter ISO source language code", alias="srcLang")
    src_locale: Optional[StrictStr] = Field(default=None, description="2-letter source language code", alias="srcLocale")
    is_plural: Optional[StrictBool] = Field(default=None, description="A boolean value representing if the files have plurals.", alias="isPlural")
    workflow_template_id: Optional[StrictInt] = Field(default=None, description="ID of the workflow template to be used. Use the [workflows templates endpoint](#tag/Workflows/operation/getWorkflowTemplates) to get the list of available workflows.", alias="workflowTemplateId")
    domain_id: Optional[StrictInt] = Field(default=None, description="ID of the domain to be used. Use the [domains endpoint](#tag/Domains/operation/getDomains) to get the list of available domains.", alias="domainId")
    __properties: ClassVar[List[str]] = ["name", "languagePairs", "fileIds", "due", "srcLang", "srcLocale", "isPlural", "workflowTemplateId", "domainId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of JobCreateParameters from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in language_pairs (list)
        _items = []
        if self.language_pairs:
            for _item_language_pairs in self.language_pairs:
                if _item_language_pairs:
                    _items.append(_item_language_pairs.to_dict())
            _dict['languagePairs'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of JobCreateParameters from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "languagePairs": [LanguagePair.from_dict(_item) for _item in obj["languagePairs"]] if obj.get("languagePairs") is not None else None,
            "fileIds": obj.get("fileIds"),
            "due": obj.get("due"),
            "srcLang": obj.get("srcLang"),
            "srcLocale": obj.get("srcLocale"),
            "isPlural": obj.get("isPlural"),
            "workflowTemplateId": obj.get("workflowTemplateId"),
            "domainId": obj.get("domainId")
        })
        return _obj


