# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request. 

    The version of the OpenAPI document: v3.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from lilt.models.workflow_stage_assignment import WorkflowStageAssignment
from typing import Optional, Set
from typing_extensions import Self

class LanguagePair(BaseModel):
    """
    A language pair couples the source and target language along with memory and pre-translations settings associated to a project. 
    """ # noqa: E501
    trg_lang: StrictStr = Field(description="Target language, an ISO 639-1 language identifier.", alias="trgLang")
    trg_locale: Optional[StrictStr] = Field(default=None, description="A locale identifier, supported for target language.", alias="trgLocale")
    due_date: Optional[StrictStr] = Field(default=None, description="An ISO date.", alias="dueDate")
    memory_id: StrictInt = Field(description="A unique number identifying the associated Memory.", alias="memoryId")
    external_model_id: Optional[StrictInt] = Field(default=None, description="A unique identifier for working with a third party model in the Lilt Platform", alias="externalModelId")
    pretranslate: Optional[StrictBool] = Field(default=None, description="Attribute translation authorship of exact matches to the creator of the document being pretranslated.")
    auto_accept: Optional[StrictBool] = Field(default=None, description="Accept and lock exact matches.", alias="autoAccept")
    case_sensitive: Optional[StrictBool] = Field(default=None, description="Use case sensitive translation memory matching.", alias="caseSensitive")
    take_match_attribution: Optional[StrictBool] = Field(default=None, description="Use MT for unmatched segments.", alias="takeMatchAttribution")
    config_id: Optional[StrictInt] = Field(default=None, description="Configuration id", alias="configId")
    workflow_template_id: Optional[StrictInt] = Field(default=None, description="Workflow Template id, to assign a specific Workflow to the project created out of this Language Pair. WorkflowTemplateIds can be retrieved via the /workflows/templates endpoint. If not specified then the Job level workflowTemplateId will be used.", alias="workflowTemplateId")
    workflow_template_name: Optional[StrictInt] = Field(default=None, description="Workflow Template Name, when passed with TeamId it allows for an on the fly look up of the correct WorkflowTemplate to use. If workflowTemplateId is passed the workflowTemplateId supercedes other lookups.", alias="workflowTemplateName")
    workflow_stage_assignments: Optional[List[WorkflowStageAssignment]] = Field(default=None, alias="workflowStageAssignments")
    __properties: ClassVar[List[str]] = ["trgLang", "trgLocale", "dueDate", "memoryId", "externalModelId", "pretranslate", "autoAccept", "caseSensitive", "takeMatchAttribution", "configId", "workflowTemplateId", "workflowTemplateName", "workflowStageAssignments"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of LanguagePair from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in workflow_stage_assignments (list)
        _items = []
        if self.workflow_stage_assignments:
            for _item_workflow_stage_assignments in self.workflow_stage_assignments:
                if _item_workflow_stage_assignments:
                    _items.append(_item_workflow_stage_assignments.to_dict())
            _dict['workflowStageAssignments'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of LanguagePair from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "trgLang": obj.get("trgLang"),
            "trgLocale": obj.get("trgLocale"),
            "dueDate": obj.get("dueDate"),
            "memoryId": obj.get("memoryId"),
            "externalModelId": obj.get("externalModelId"),
            "pretranslate": obj.get("pretranslate"),
            "autoAccept": obj.get("autoAccept"),
            "caseSensitive": obj.get("caseSensitive"),
            "takeMatchAttribution": obj.get("takeMatchAttribution"),
            "configId": obj.get("configId"),
            "workflowTemplateId": obj.get("workflowTemplateId"),
            "workflowTemplateName": obj.get("workflowTemplateName"),
            "workflowStageAssignments": [WorkflowStageAssignment.from_dict(_item) for _item in obj["workflowStageAssignments"]] if obj.get("workflowStageAssignments") is not None else None
        })
        return _obj


