# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class NextWorkflowTask(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'status': 'str',
        'new_task_id': 'int',
        'new_stage_name': 'str'
    }

    attribute_map = {
        'status': 'status',
        'new_task_id': 'newTaskId',
        'new_stage_name': 'newStageName'
    }

    def __init__(self, status=None, new_task_id=None, new_stage_name=None, local_vars_configuration=None):  # noqa: E501
        """NextWorkflowTask - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._status = None
        self._new_task_id = None
        self._new_stage_name = None
        self.discriminator = None

        self.status = status
        if new_task_id is not None:
            self.new_task_id = new_task_id
        if new_stage_name is not None:
            self.new_stage_name = new_stage_name

    @property
    def status(self):
        """Gets the status of this NextWorkflowTask.  # noqa: E501

        Identifier of the current workflow task.  # noqa: E501

        :return: The status of this NextWorkflowTask.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this NextWorkflowTask.

        Identifier of the current workflow task.  # noqa: E501

        :param status: The status of this NextWorkflowTask.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and status is None:  # noqa: E501
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["SUCCESS", "WORKFLOW_FINISHED", "ALREADY_AT_START", "INVALID_ARGUMENT", "POSTCONDITIONS_FAILED", "UNKNOWN_ERROR"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and status not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def new_task_id(self):
        """Gets the new_task_id of this NextWorkflowTask.  # noqa: E501

        The identifier of the workflow task that is now currently active.  # noqa: E501

        :return: The new_task_id of this NextWorkflowTask.  # noqa: E501
        :rtype: int
        """
        return self._new_task_id

    @new_task_id.setter
    def new_task_id(self, new_task_id):
        """Sets the new_task_id of this NextWorkflowTask.

        The identifier of the workflow task that is now currently active.  # noqa: E501

        :param new_task_id: The new_task_id of this NextWorkflowTask.  # noqa: E501
        :type: int
        """

        self._new_task_id = new_task_id

    @property
    def new_stage_name(self):
        """Gets the new_stage_name of this NextWorkflowTask.  # noqa: E501

        The name of the workflow task that is now currently active.  # noqa: E501

        :return: The new_stage_name of this NextWorkflowTask.  # noqa: E501
        :rtype: str
        """
        return self._new_stage_name

    @new_stage_name.setter
    def new_stage_name(self, new_stage_name):
        """Sets the new_stage_name of this NextWorkflowTask.

        The name of the workflow task that is now currently active.  # noqa: E501

        :param new_stage_name: The new_stage_name of this NextWorkflowTask.  # noqa: E501
        :type: str
        """

        self._new_stage_name = new_stage_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NextWorkflowTask):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NextWorkflowTask):
            return True

        return self.to_dict() != other.to_dict()
