# coding: utf-8

"""
    Lilt REST API

    Lilt REST API Support: https://lilt.atlassian.net/servicedesk/customer/portals    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  The base url for this REST API is `https://api.lilt.com/`.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request. 

    The version of the OpenAPI document: v3.0.2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from lilt.models.document_without_segments import DocumentWithoutSegments
from typing import Optional, Set
from typing_extensions import Self

class Project(BaseModel):
    """
    A Project is a collection of zero or more Documents. It is specific to a language pair, and is associated with exactly one Memory for that language pair. The Memory association cannot be changed after the Project is created. 
    """ # noqa: E501
    id: Optional[StrictInt] = Field(default=None, description="A unique number identifying the Project.")
    memory_id: Optional[StrictInt] = Field(default=None, description="A unique number identifying the associated Memory.")
    job_id: Optional[StrictInt] = Field(default=None, description="A unique number identifying the associated Job.")
    srclang: Optional[StrictStr] = Field(default=None, description="An ISO 639-1 language identifier.")
    trglang: Optional[StrictStr] = Field(default=None, description="An ISO 639-1 language identifier.")
    srclocale: Optional[StrictStr] = Field(default=None, description="A locale identifier, supported for srclang.")
    trglocale: Optional[StrictStr] = Field(default=None, description="A locale identifier, supported for trglang.")
    name: Optional[StrictStr] = Field(default=None, description="A name for the project.")
    state: Optional[StrictStr] = Field(default=None, description="The project's state. The possible states are `backlog`, `inProgress`, `inReview`, `inQA`, and `done`.")
    due_date: Optional[StrictInt] = Field(default=None, description="The due date. Measured in seconds since the Unix epoch.")
    archived: Optional[StrictBool] = Field(default=None, description="The archived state of the Project.")
    metadata: Optional[Dict[str, Any]] = Field(default=None, description="A JSON object of key/value string pairs. Stores custom project information.")
    sample_review_percentage: Optional[StrictInt] = Field(default=None, description="The project's sample review percentage.")
    created_at: Optional[StrictInt] = Field(default=None, description="Time at which the object was created. Measured in seconds since the Unix epoch.")
    updated_at: Optional[StrictInt] = Field(default=None, description="Time at which the object was created. Measured in seconds since the Unix epoch.")
    workflow_status: Optional[StrictStr] = Field(default=None, description="The status of the Workflow for the current project. This may not be present for all project endpoints even with workflows enabled.", alias="workflowStatus")
    document: Optional[List[DocumentWithoutSegments]] = Field(default=None, description="A list of Documents.")
    __properties: ClassVar[List[str]] = ["id", "memory_id", "job_id", "srclang", "trglang", "srclocale", "trglocale", "name", "state", "due_date", "archived", "metadata", "sample_review_percentage", "created_at", "updated_at", "workflowStatus", "document"]

    @field_validator('workflow_status')
    def workflow_status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['READY_TO_START', 'IN_PROGRESS', 'DONE']):
            raise ValueError("must be one of enum values ('READY_TO_START', 'IN_PROGRESS', 'DONE')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Project from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in document (list)
        _items = []
        if self.document:
            for _item_document in self.document:
                if _item_document:
                    _items.append(_item_document.to_dict())
            _dict['document'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Project from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "memory_id": obj.get("memory_id"),
            "job_id": obj.get("job_id"),
            "srclang": obj.get("srclang"),
            "trglang": obj.get("trglang"),
            "srclocale": obj.get("srclocale"),
            "trglocale": obj.get("trglocale"),
            "name": obj.get("name"),
            "state": obj.get("state"),
            "due_date": obj.get("due_date"),
            "archived": obj.get("archived"),
            "metadata": obj.get("metadata"),
            "sample_review_percentage": obj.get("sample_review_percentage"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "workflowStatus": obj.get("workflowStatus"),
            "document": [DocumentWithoutSegments.from_dict(_item) for _item in obj["document"]] if obj.get("document") is not None else None
        })
        return _obj


