# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class QARuleMatchesMatches(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'context': 'QARuleMatchesContext',
        'length': 'int',
        'message': 'str',
        'offset': 'int',
        'replacements': 'list[QARuleMatchesReplacements]',
        'rule': 'QARuleMatchesRule',
        'short_message': 'str'
    }

    attribute_map = {
        'context': 'context',
        'length': 'length',
        'message': 'message',
        'offset': 'offset',
        'replacements': 'replacements',
        'rule': 'rule',
        'short_message': 'shortMessage'
    }

    def __init__(self, context=None, length=None, message=None, offset=None, replacements=None, rule=None, short_message=None, local_vars_configuration=None):  # noqa: E501
        """QARuleMatchesMatches - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._context = None
        self._length = None
        self._message = None
        self._offset = None
        self._replacements = None
        self._rule = None
        self._short_message = None
        self.discriminator = None

        self.context = context
        self.length = length
        self.message = message
        self.offset = offset
        self.replacements = replacements
        if rule is not None:
            self.rule = rule
        if short_message is not None:
            self.short_message = short_message

    @property
    def context(self):
        """Gets the context of this QARuleMatchesMatches.  # noqa: E501


        :return: The context of this QARuleMatchesMatches.  # noqa: E501
        :rtype: QARuleMatchesContext
        """
        return self._context

    @context.setter
    def context(self, context):
        """Sets the context of this QARuleMatchesMatches.


        :param context: The context of this QARuleMatchesMatches.  # noqa: E501
        :type: QARuleMatchesContext
        """
        if self.local_vars_configuration.client_side_validation and context is None:  # noqa: E501
            raise ValueError("Invalid value for `context`, must not be `None`")  # noqa: E501

        self._context = context

    @property
    def length(self):
        """Gets the length of this QARuleMatchesMatches.  # noqa: E501

        The length of the error in characters.  # noqa: E501

        :return: The length of this QARuleMatchesMatches.  # noqa: E501
        :rtype: int
        """
        return self._length

    @length.setter
    def length(self, length):
        """Sets the length of this QARuleMatchesMatches.

        The length of the error in characters.  # noqa: E501

        :param length: The length of this QARuleMatchesMatches.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and length is None:  # noqa: E501
            raise ValueError("Invalid value for `length`, must not be `None`")  # noqa: E501

        self._length = length

    @property
    def message(self):
        """Gets the message of this QARuleMatchesMatches.  # noqa: E501

        Message about the error displayed to the user.  # noqa: E501

        :return: The message of this QARuleMatchesMatches.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this QARuleMatchesMatches.

        Message about the error displayed to the user.  # noqa: E501

        :param message: The message of this QARuleMatchesMatches.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and message is None:  # noqa: E501
            raise ValueError("Invalid value for `message`, must not be `None`")  # noqa: E501

        self._message = message

    @property
    def offset(self):
        """Gets the offset of this QARuleMatchesMatches.  # noqa: E501

        The 0-based character offset of the error in the text.  # noqa: E501

        :return: The offset of this QARuleMatchesMatches.  # noqa: E501
        :rtype: int
        """
        return self._offset

    @offset.setter
    def offset(self, offset):
        """Sets the offset of this QARuleMatchesMatches.

        The 0-based character offset of the error in the text.  # noqa: E501

        :param offset: The offset of this QARuleMatchesMatches.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and offset is None:  # noqa: E501
            raise ValueError("Invalid value for `offset`, must not be `None`")  # noqa: E501

        self._offset = offset

    @property
    def replacements(self):
        """Gets the replacements of this QARuleMatchesMatches.  # noqa: E501

        Replacements that might correct the error. The array can be empty, in this case there is no suggested replacement.  # noqa: E501

        :return: The replacements of this QARuleMatchesMatches.  # noqa: E501
        :rtype: list[QARuleMatchesReplacements]
        """
        return self._replacements

    @replacements.setter
    def replacements(self, replacements):
        """Sets the replacements of this QARuleMatchesMatches.

        Replacements that might correct the error. The array can be empty, in this case there is no suggested replacement.  # noqa: E501

        :param replacements: The replacements of this QARuleMatchesMatches.  # noqa: E501
        :type: list[QARuleMatchesReplacements]
        """
        if self.local_vars_configuration.client_side_validation and replacements is None:  # noqa: E501
            raise ValueError("Invalid value for `replacements`, must not be `None`")  # noqa: E501

        self._replacements = replacements

    @property
    def rule(self):
        """Gets the rule of this QARuleMatchesMatches.  # noqa: E501


        :return: The rule of this QARuleMatchesMatches.  # noqa: E501
        :rtype: QARuleMatchesRule
        """
        return self._rule

    @rule.setter
    def rule(self, rule):
        """Sets the rule of this QARuleMatchesMatches.


        :param rule: The rule of this QARuleMatchesMatches.  # noqa: E501
        :type: QARuleMatchesRule
        """

        self._rule = rule

    @property
    def short_message(self):
        """Gets the short_message of this QARuleMatchesMatches.  # noqa: E501

        An optional shorter version of 'message'.  # noqa: E501

        :return: The short_message of this QARuleMatchesMatches.  # noqa: E501
        :rtype: str
        """
        return self._short_message

    @short_message.setter
    def short_message(self, short_message):
        """Sets the short_message of this QARuleMatchesMatches.

        An optional shorter version of 'message'.  # noqa: E501

        :param short_message: The short_message of this QARuleMatchesMatches.  # noqa: E501
        :type: str
        """

        self._short_message = short_message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QARuleMatchesMatches):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QARuleMatchesMatches):
            return True

        return self.to_dict() != other.to_dict()
