# coding: utf-8

"""
    Lilt REST API

    The Lilt REST API enables programmatic access to the full-range of Lilt backend services including:   * Training of and translating with interactive, adaptive machine translation   * Large-scale translation memory   * The Lexicon (a large-scale termbase)   * Programmatic control of the Lilt CAT environment   * Translation memory synchronization  Requests and responses are in JSON format. The REST API only responds to HTTPS / SSL requests.  ## Authentication  Requests are authenticated via REST API key, which requires the Business plan.  Requests are authenticated using [HTTP Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Add your REST API key as both the `username` and `password`.  For development, you may also pass the REST API key via the `key` query parameter. This is less secure than HTTP Basic Auth, and is not recommended for production use.  ## Quotas  Our services have a general quota of 4000 requests per minute. Should you hit the maximum requests per minute, you will need to wait 60 seconds before you can send another request.   # noqa: E501

    The version of the OpenAPI document: v2.0
    Contact: support@lilt.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from lilt.configuration import Configuration


class QARuleMatchesRule(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'category': 'QARuleMatchesRuleCategory',
        'description': 'str',
        'id': 'str',
        'issue_type': 'str',
        'sub_id': 'str',
        'urls': 'list[QARuleMatchesRuleUrls]'
    }

    attribute_map = {
        'category': 'category',
        'description': 'description',
        'id': 'id',
        'issue_type': 'issueType',
        'sub_id': 'subId',
        'urls': 'urls'
    }

    def __init__(self, category=None, description=None, id=None, issue_type=None, sub_id=None, urls=None, local_vars_configuration=None):  # noqa: E501
        """QARuleMatchesRule - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._category = None
        self._description = None
        self._id = None
        self._issue_type = None
        self._sub_id = None
        self._urls = None
        self.discriminator = None

        self.category = category
        self.description = description
        self.id = id
        if issue_type is not None:
            self.issue_type = issue_type
        if sub_id is not None:
            self.sub_id = sub_id
        if urls is not None:
            self.urls = urls

    @property
    def category(self):
        """Gets the category of this QARuleMatchesRule.  # noqa: E501


        :return: The category of this QARuleMatchesRule.  # noqa: E501
        :rtype: QARuleMatchesRuleCategory
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this QARuleMatchesRule.


        :param category: The category of this QARuleMatchesRule.  # noqa: E501
        :type: QARuleMatchesRuleCategory
        """
        if self.local_vars_configuration.client_side_validation and category is None:  # noqa: E501
            raise ValueError("Invalid value for `category`, must not be `None`")  # noqa: E501

        self._category = category

    @property
    def description(self):
        """Gets the description of this QARuleMatchesRule.  # noqa: E501


        :return: The description of this QARuleMatchesRule.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this QARuleMatchesRule.


        :param description: The description of this QARuleMatchesRule.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and description is None:  # noqa: E501
            raise ValueError("Invalid value for `description`, must not be `None`")  # noqa: E501

        self._description = description

    @property
    def id(self):
        """Gets the id of this QARuleMatchesRule.  # noqa: E501

        An rule's identifier that's unique for this language.  # noqa: E501

        :return: The id of this QARuleMatchesRule.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this QARuleMatchesRule.

        An rule's identifier that's unique for this language.  # noqa: E501

        :param id: The id of this QARuleMatchesRule.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and id is None:  # noqa: E501
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def issue_type(self):
        """Gets the issue_type of this QARuleMatchesRule.  # noqa: E501

        The Localization Quality Issue Type. This is not defined for all languages, in which case it will always be 'Uncategorized'.  # noqa: E501

        :return: The issue_type of this QARuleMatchesRule.  # noqa: E501
        :rtype: str
        """
        return self._issue_type

    @issue_type.setter
    def issue_type(self, issue_type):
        """Sets the issue_type of this QARuleMatchesRule.

        The Localization Quality Issue Type. This is not defined for all languages, in which case it will always be 'Uncategorized'.  # noqa: E501

        :param issue_type: The issue_type of this QARuleMatchesRule.  # noqa: E501
        :type: str
        """

        self._issue_type = issue_type

    @property
    def sub_id(self):
        """Gets the sub_id of this QARuleMatchesRule.  # noqa: E501

        An optional sub identifier of the rule, used when several rules are grouped.  # noqa: E501

        :return: The sub_id of this QARuleMatchesRule.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this QARuleMatchesRule.

        An optional sub identifier of the rule, used when several rules are grouped.  # noqa: E501

        :param sub_id: The sub_id of this QARuleMatchesRule.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def urls(self):
        """Gets the urls of this QARuleMatchesRule.  # noqa: E501

        An optional array of URLs with a more detailed description of the error.  # noqa: E501

        :return: The urls of this QARuleMatchesRule.  # noqa: E501
        :rtype: list[QARuleMatchesRuleUrls]
        """
        return self._urls

    @urls.setter
    def urls(self, urls):
        """Sets the urls of this QARuleMatchesRule.

        An optional array of URLs with a more detailed description of the error.  # noqa: E501

        :param urls: The urls of this QARuleMatchesRule.  # noqa: E501
        :type: list[QARuleMatchesRuleUrls]
        """

        self._urls = urls

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, QARuleMatchesRule):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, QARuleMatchesRule):
            return True

        return self.to_dict() != other.to_dict()
